#! /bin/bash
#
# Run this script in the generator folder.
#

make clean && make && ./generator

function compile {
	local FILE=$1
	echo -n "Compiling $FILE.c ... "
	gcc -Wall "${INCLUDES[@]}" -c "$FILE".c
	echo "done!"
}

function move_file {
	local FILE=$1
	DESTINATION=$2
	echo -n "Moving ${FILE} to $DESTINATION ... "
	mv "${FILE}" "${DESTINATION}"
	echo "done!"
}

FILES_API=(
	UpnpActionComplete
	UpnpActionRequest
	UpnpDiscovery
	UpnpEvent
	UpnpEventSubscribe
	UpnpExtraHeaders
	UpnpFileInfo
	UpnpStateVarComplete
	UpnpStateVarRequest
	UpnpSubscriptionRequest
)

FILES_OTHERS=(
	GenlibClientSubscription
	SSDPResultData
)

FILES_TEST=(
	TestClass
)

ALL_FILES=("${FILES_API[@]}" "${FILES_OTHERS[@]}" "${FILES_TEST[@]}")

echo
INCLUDES=("-I." "-I../.." "-I../src/inc" "-I../../upnp/src/inc" "-I../../ixml/inc" "-I../../upnp/inc")
for FILE in "${ALL_FILES[@]}"; do
	compile "$FILE"
	clang-format -i "$FILE".c
	clang-format -i "$FILE".h
done

rm ./*.o

echo
for FILE in "${FILES_API[@]}"; do
	move_file "$FILE".h ../inc
done

for FILE in "${FILES_API[@]}"; do
	move_file "$FILE".c ../src/api
done

FILE=${FILES_OTHERS[0]}
move_file "$FILE".h ../src/inc
move_file "$FILE".c ../src/genlib/client_table

FILE=${FILES_OTHERS[1]}
move_file "$FILE".h ../src/ssdp
move_file "$FILE".c ../src/ssdp
