/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/variables/PythonVariablesUtil;", "", "<init>", "()V", "callJupyterInlineCallback", "", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "values", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "frameVarsCallback", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "getPythonJupyterPsiFile", "Lcom/intellij/psi/PsiFile;", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.jupyter.py"})
public final class PythonVariablesUtil {
    @NotNull
    public static final PythonVariablesUtil INSTANCE = new PythonVariablesUtil();

    private PythonVariablesUtil() {
    }

    public final void callJupyterInlineCallback(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @NotNull XValueChildrenList values, @NotNull JupyterInlineCallback frameVarsCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)frameVarsCallback, (String)"frameVarsCallback");
        ApplicationManager.getApplication().runReadAction(() -> PythonVariablesUtil.callJupyterInlineCallback$lambda$0(project, notebookFile, frameVarsCallback, values));
    }

    @Nullable
    public final PsiFile getPythonJupyterPsiFile(@NotNull Project project, @NotNull VirtualFile originalFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        ThreadingAssertions.assertReadAccess();
        if (project.isDisposed()) {
            return null;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterHelper.INSTANCE.getJupyterVirtualFileByOriginalVirtualFile(originalFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        FileViewProvider fileViewProvider = PsiManager.getInstance((Project)project).findViewProvider(jupyterVirtualFile.getFile());
        return fileViewProvider != null ? fileViewProvider.getPsi((Language)JupyterPyDialect.INSTANCE) : null;
    }

    private static final void callJupyterInlineCallback$lambda$0(Project $project, BackedNotebookVirtualFile $notebookFile, JupyterInlineCallback $frameVarsCallback, XValueChildrenList $values) {
        PsiFile psiFile2 = INSTANCE.getPythonJupyterPsiFile($project, $notebookFile.getOriginFile());
        ScopeOwner scopeOwner = psiFile2 instanceof ScopeOwner ? (ScopeOwner)psiFile2 : null;
        if (scopeOwner == null) {
            return;
        }
        ScopeOwner scopeOwner2 = scopeOwner;
        $frameVarsCallback.frameChanged($values, scopeOwner2);
    }
}

