/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry<?, ?>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private static final long serialVersionUID = 1421746759512286392L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Collection<V> values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public Hashtable(int n, float f) {
    }

    public Hashtable(int n) {
    }

    public Hashtable() {
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
    }

    @Override
    public synchronized int size() {
        return 0;
    }

    @Override
    public synchronized boolean isEmpty() {
        return false;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return null;
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return null;
    }

    public synchronized boolean contains(Object object) {
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        return null;
    }

    protected void rehash() {
    }

    @Override
    public synchronized V put(K k, V v) {
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
    }

    @Override
    public synchronized void clear() {
    }

    public synchronized Object clone() {
        return null;
    }

    public synchronized String toString() {
        return null;
    }

    @Override
    public Set<K> keySet() {
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public synchronized boolean equals(Object object) {
        return false;
    }

    @Override
    public synchronized int hashCode() {
        return 0;
    }

    @Override
    public synchronized V getOrDefault(Object object, V v) {
        return null;
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> biConsumer) {
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        return null;
    }

    @Override
    public synchronized boolean remove(Object object, Object object2) {
        return false;
    }

    @Override
    public synchronized boolean replace(K k, V v, V v2) {
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        return null;
    }

    @Override
    public synchronized V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        return null;
    }

    @Override
    public synchronized V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        return null;
    }

    @Override
    public synchronized V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        return null;
    }

    @Override
    public synchronized V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        return null;
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        final Entry<?, ?>[] table;
        int index;
        Entry<?, ?> entry;
        Entry<?, ?> lastReturned;
        final int type;
        final boolean iterator;
        protected int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            Entry<?, ?> e = this.entry;
            int i = this.index;
            Entry<?, ?>[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public T nextElement() {
            Entry<?, ?> et = this.entry;
            int i = this.index;
            Entry<?, ?>[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                this.lastReturned = this.entry;
                Entry<?, ?> e = this.lastReturned;
                this.entry = e.next;
                return (T)(this.type == 0 ? e.key : (this.type == 1 ? e.value : e));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry<?, ?>[] tab = Hashtable.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry<Object, Object> e = tab[index];
                Entry<?, ?> prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        ++this.expectedModCount;
                        this.lastReturned = null;
                        ++Hashtable.this.modCount;
                        --Hashtable.this.count;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsValue(o);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Hashtable.this.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return super.add(o);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry<?, ?>[] tab = Hashtable.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object, Object> e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry<?, ?>[] tab = Hashtable.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object, Object> e = tab[index];
            Entry<?, ?> prev = null;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    e.value = null;
                    ++Hashtable.this.modCount;
                    --Hashtable.this.count;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Hashtable.this.remove(o) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }
}

