#[cfg(feature = "Win32_Media_DirectShow_Tv")]
pub mod Tv;
#[cfg(feature = "Win32_Media_DirectShow_Xml")]
pub mod Xml;
#[inline]
pub unsafe fn AMGetErrorTextA(hr: ::windows_core::HRESULT, pbuffer: &mut [u8]) -> u32 {
    ::windows_targets::link!("quartz.dll" "system" fn AMGetErrorTextA(hr : ::windows_core::HRESULT, pbuffer : ::windows_core::PSTR, maxlen : u32) -> u32);
    AMGetErrorTextA(hr, ::core::mem::transmute(pbuffer.as_ptr()), pbuffer.len().try_into().unwrap())
}
#[inline]
pub unsafe fn AMGetErrorTextW(hr: ::windows_core::HRESULT, pbuffer: &mut [u16]) -> u32 {
    ::windows_targets::link!("quartz.dll" "system" fn AMGetErrorTextW(hr : ::windows_core::HRESULT, pbuffer : ::windows_core::PWSTR, maxlen : u32) -> u32);
    AMGetErrorTextW(hr, ::core::mem::transmute(pbuffer.as_ptr()), pbuffer.len().try_into().unwrap())
}
::windows_core::imp::com_interface!(IAMAnalogVideoDecoder, IAMAnalogVideoDecoder_Vtbl, 0xc6e13350_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMAnalogVideoDecoder, ::windows_core::IUnknown);
impl IAMAnalogVideoDecoder {
    pub unsafe fn AvailableTVFormats(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvailableTVFormats)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTVFormat)(::windows_core::Interface::as_raw(self), lanalogvideostandard).ok()
    }
    pub unsafe fn TVFormat(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVFormat)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn HorizontalLocked(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).HorizontalLocked)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetVCRHorizontalLocking(&self, lvcrhorizontallocking: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVCRHorizontalLocking)(::windows_core::Interface::as_raw(self), lvcrhorizontallocking).ok()
    }
    pub unsafe fn VCRHorizontalLocking(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VCRHorizontalLocking)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn NumberOfLines(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).NumberOfLines)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputEnable(&self, loutputenable: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputEnable)(::windows_core::Interface::as_raw(self), loutputenable).ok()
    }
    pub unsafe fn OutputEnable(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).OutputEnable)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMAnalogVideoDecoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTVFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub HorizontalLocked: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetVCRHorizontalLocking: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub VCRHorizontalLocking: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub NumberOfLines: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetOutputEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub OutputEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMAnalogVideoEncoder, IAMAnalogVideoEncoder_Vtbl, 0xc6e133b0_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMAnalogVideoEncoder, ::windows_core::IUnknown);
impl IAMAnalogVideoEncoder {
    pub unsafe fn AvailableTVFormats(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvailableTVFormats)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTVFormat)(::windows_core::Interface::as_raw(self), lanalogvideostandard).ok()
    }
    pub unsafe fn TVFormat(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVFormat)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCopyProtection(&self, lvideocopyprotection: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCopyProtection)(::windows_core::Interface::as_raw(self), lvideocopyprotection).ok()
    }
    pub unsafe fn CopyProtection(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CopyProtection)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCCEnable(&self, lccenable: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCCEnable)(::windows_core::Interface::as_raw(self), lccenable).ok()
    }
    pub unsafe fn CCEnable(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CCEnable)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMAnalogVideoEncoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTVFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetCopyProtection: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub CopyProtection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetCCEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub CCEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMAsyncReaderTimestampScaling, IAMAsyncReaderTimestampScaling_Vtbl, 0xcf7b26fc_9a00_485b_8147_3e789d5e8f67);
::windows_core::imp::interface_hierarchy!(IAMAsyncReaderTimestampScaling, ::windows_core::IUnknown);
impl IAMAsyncReaderTimestampScaling {
    pub unsafe fn GetTimestampMode(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTimestampMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTimestampMode<P0>(&self, fraw: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetTimestampMode)(::windows_core::Interface::as_raw(self), fraw.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMAsyncReaderTimestampScaling_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTimestampMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetTimestampMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMAudioInputMixer, IAMAudioInputMixer_Vtbl, 0x54c39221_8380_11d0_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(IAMAudioInputMixer, ::windows_core::IUnknown);
impl IAMAudioInputMixer {
    pub unsafe fn SetEnable<P0>(&self, fenable: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnable)(::windows_core::Interface::as_raw(self), fenable.into_param().abi()).ok()
    }
    pub unsafe fn Enable(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Enable)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMono<P0>(&self, fmono: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetMono)(::windows_core::Interface::as_raw(self), fmono.into_param().abi()).ok()
    }
    pub unsafe fn Mono(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mono)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMixLevel(&self, level: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMixLevel)(::windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn MixLevel(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MixLevel)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPan(&self, pan: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPan)(::windows_core::Interface::as_raw(self), pan).ok()
    }
    pub unsafe fn Pan(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Pan)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLoudness<P0>(&self, floudness: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetLoudness)(::windows_core::Interface::as_raw(self), floudness.into_param().abi()).ok()
    }
    pub unsafe fn Loudness(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Loudness)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTreble(&self, treble: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTreble)(::windows_core::Interface::as_raw(self), treble).ok()
    }
    pub unsafe fn Treble(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Treble)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn TrebleRange(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TrebleRange)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBass(&self, bass: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBass)(::windows_core::Interface::as_raw(self), bass).ok()
    }
    pub unsafe fn Bass(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Bass)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn BassRange(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BassRange)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMAudioInputMixer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub Enable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetMono: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub Mono: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetMixLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub MixLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetPan: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub Pan: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetLoudness: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub Loudness: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetTreble: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub Treble: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub TrebleRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetBass: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub Bass: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub BassRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMAudioRendererStats, IAMAudioRendererStats_Vtbl, 0x22320cb2_d41a_11d2_bf7c_d7cb9df0bf93);
::windows_core::imp::interface_hierarchy!(IAMAudioRendererStats, ::windows_core::IUnknown);
impl IAMAudioRendererStats {
    pub unsafe fn GetStatParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStatParam)(::windows_core::Interface::as_raw(self), dwparam, pdwparam1, pdwparam2).ok()
    }
}
#[repr(C)]
pub struct IAMAudioRendererStats_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetStatParam: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMBufferNegotiation, IAMBufferNegotiation_Vtbl, 0x56ed71a0_af5f_11d0_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(IAMBufferNegotiation, ::windows_core::IUnknown);
impl IAMBufferNegotiation {
    pub unsafe fn SuggestAllocatorProperties(&self, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SuggestAllocatorProperties)(::windows_core::Interface::as_raw(self), pprop).ok()
    }
    pub unsafe fn GetAllocatorProperties(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllocatorProperties)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMBufferNegotiation_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SuggestAllocatorProperties: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub GetAllocatorProperties: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMCameraControl, IAMCameraControl_Vtbl, 0xc6e13370_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMCameraControl, ::windows_core::IUnknown);
impl IAMCameraControl {
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRange)(::windows_core::Interface::as_raw(self), property, pmin, pmax, psteppingdelta, pdefault, pcapsflags).ok()
    }
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Set)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Get)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
}
#[repr(C)]
pub struct IAMCameraControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub Set: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub Get: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMCertifiedOutputProtection, IAMCertifiedOutputProtection_Vtbl, 0x6feded3e_0ff1_4901_a2f1_43f7012c8515);
::windows_core::imp::interface_hierarchy!(IAMCertifiedOutputProtection, ::windows_core::IUnknown);
impl IAMCertifiedOutputProtection {
    pub unsafe fn KeyExchange(&self, prandom: *mut ::windows_core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).KeyExchange)(::windows_core::Interface::as_raw(self), prandom, varlencertgh, pdwlengthcertgh).ok()
    }
    pub unsafe fn SessionSequenceStart(&self, psig: *const AMCOPPSignature) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SessionSequenceStart)(::windows_core::Interface::as_raw(self), psig).ok()
    }
    pub unsafe fn ProtectionCommand(&self, cmd: *const AMCOPPCommand) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProtectionCommand)(::windows_core::Interface::as_raw(self), cmd).ok()
    }
    pub unsafe fn ProtectionStatus(&self, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProtectionStatus)(::windows_core::Interface::as_raw(self), pstatusinput, pstatusoutput).ok()
    }
}
#[repr(C)]
pub struct IAMCertifiedOutputProtection_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub KeyExchange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID, *mut *mut u8, *mut u32) -> ::windows_core::HRESULT,
    pub SessionSequenceStart: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const AMCOPPSignature) -> ::windows_core::HRESULT,
    pub ProtectionCommand: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const AMCOPPCommand) -> ::windows_core::HRESULT,
    pub ProtectionStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const AMCOPPStatusInput, *mut AMCOPPStatusOutput) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMChannelInfo, IAMChannelInfo_Vtbl, 0xfa2aa8f2_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMChannelInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMChannelInfo {
    pub unsafe fn ChannelName(&self, pbstrchannelname: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelName)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrchannelname)).ok()
    }
    pub unsafe fn ChannelDescription(&self, pbstrchanneldescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelDescription)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrchanneldescription)).ok()
    }
    pub unsafe fn ChannelURL(&self, pbstrchannelurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrchannelurl)).ok()
    }
    pub unsafe fn ContactAddress(&self, pbstrcontactaddress: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ContactAddress)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcontactaddress)).ok()
    }
    pub unsafe fn ContactPhone(&self, pbstrcontactphone: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ContactPhone)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcontactphone)).ok()
    }
    pub unsafe fn ContactEmail(&self, pbstrcontactemail: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ContactEmail)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcontactemail)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMChannelInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ChannelName: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ChannelDescription: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ChannelURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ContactAddress: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ContactPhone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ContactEmail: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMClockAdjust, IAMClockAdjust_Vtbl, 0x4d5466b0_a49c_11d1_abe8_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IAMClockAdjust, ::windows_core::IUnknown);
impl IAMClockAdjust {
    pub unsafe fn SetClockDelta(&self, rtdelta: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetClockDelta)(::windows_core::Interface::as_raw(self), rtdelta).ok()
    }
}
#[repr(C)]
pub struct IAMClockAdjust_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetClockDelta: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMClockSlave, IAMClockSlave_Vtbl, 0x9fd52741_176d_4b36_8f51_ca8f933223be);
::windows_core::imp::interface_hierarchy!(IAMClockSlave, ::windows_core::IUnknown);
impl IAMClockSlave {
    pub unsafe fn SetErrorTolerance(&self, dwtolerance: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetErrorTolerance)(::windows_core::Interface::as_raw(self), dwtolerance).ok()
    }
    pub unsafe fn GetErrorTolerance(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetErrorTolerance)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMClockSlave_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetErrorTolerance: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetErrorTolerance: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMCollection, IAMCollection_Vtbl, 0x56a868b9_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMCollection, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMCollection {
    pub unsafe fn Count(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Item(&self, litem: i32) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Item)(::windows_core::Interface::as_raw(self), litem, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn _NewEnum(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self)._NewEnum)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMCollection_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Item: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMCopyCaptureFileProgress, IAMCopyCaptureFileProgress_Vtbl, 0x670d1d20_a068_11d0_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(IAMCopyCaptureFileProgress, ::windows_core::IUnknown);
impl IAMCopyCaptureFileProgress {
    pub unsafe fn Progress(&self, iprogress: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Progress)(::windows_core::Interface::as_raw(self), iprogress).ok()
    }
}
#[repr(C)]
pub struct IAMCopyCaptureFileProgress_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Progress: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMCrossbar, IAMCrossbar_Vtbl, 0xc6e13380_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMCrossbar, ::windows_core::IUnknown);
impl IAMCrossbar {
    pub unsafe fn get_PinCounts(&self, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PinCounts)(::windows_core::Interface::as_raw(self), outputpincount, inputpincount).ok()
    }
    pub unsafe fn CanRoute(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CanRoute)(::windows_core::Interface::as_raw(self), outputpinindex, inputpinindex).ok()
    }
    pub unsafe fn Route(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Route)(::windows_core::Interface::as_raw(self), outputpinindex, inputpinindex).ok()
    }
    pub unsafe fn get_IsRoutedTo(&self, outputpinindex: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_IsRoutedTo)(::windows_core::Interface::as_raw(self), outputpinindex, &mut result__).map(|| result__)
    }
    pub unsafe fn get_CrossbarPinInfo<P0>(&self, isinputpin: P0, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).get_CrossbarPinInfo)(::windows_core::Interface::as_raw(self), isinputpin.into_param().abi(), pinindex, pinindexrelated, physicaltype).ok()
    }
}
#[repr(C)]
pub struct IAMCrossbar_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_PinCounts: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub CanRoute: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub Route: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub get_IsRoutedTo: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_CrossbarPinInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL, i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMDecoderCaps, IAMDecoderCaps_Vtbl, 0xc0dff467_d499_4986_972b_e1d9090fa941);
::windows_core::imp::interface_hierarchy!(IAMDecoderCaps, ::windows_core::IUnknown);
impl IAMDecoderCaps {
    pub unsafe fn GetDecoderCaps(&self, dwcapindex: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDecoderCaps)(::windows_core::Interface::as_raw(self), dwcapindex, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMDecoderCaps_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDecoderCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMDevMemoryAllocator, IAMDevMemoryAllocator_Vtbl, 0xc6545bf0_e76b_11d0_bd52_00a0c911ce86);
::windows_core::imp::interface_hierarchy!(IAMDevMemoryAllocator, ::windows_core::IUnknown);
impl IAMDevMemoryAllocator {
    pub unsafe fn GetInfo(&self, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(::windows_core::Interface::as_raw(self), pdwcbtotalfree, pdwcblargestfree, pdwcbtotalmemory, pdwcbminimumchunk).ok()
    }
    pub unsafe fn CheckMemory(&self, pbuffer: *const u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CheckMemory)(::windows_core::Interface::as_raw(self), pbuffer).ok()
    }
    pub unsafe fn Alloc(&self, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Alloc)(::windows_core::Interface::as_raw(self), ppbuffer, pdwcbbuffer).ok()
    }
    pub unsafe fn Free(&self, pbuffer: *const u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Free)(::windows_core::Interface::as_raw(self), pbuffer).ok()
    }
    pub unsafe fn GetDevMemoryObject<P0>(&self, ppunkinnner: *mut ::core::option::Option<::windows_core::IUnknown>, punkouter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).GetDevMemoryObject)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppunkinnner), punkouter.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMDevMemoryAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub CheckMemory: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const u8) -> ::windows_core::HRESULT,
    pub Alloc: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8, *mut u32) -> ::windows_core::HRESULT,
    pub Free: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const u8) -> ::windows_core::HRESULT,
    pub GetDevMemoryObject: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMDevMemoryControl, IAMDevMemoryControl_Vtbl, 0xc6545bf1_e76b_11d0_bd52_00a0c911ce86);
::windows_core::imp::interface_hierarchy!(IAMDevMemoryControl, ::windows_core::IUnknown);
impl IAMDevMemoryControl {
    pub unsafe fn QueryWriteSync(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryWriteSync)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteSync(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WriteSync)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetDevId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDevId)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMDevMemoryControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryWriteSync: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub WriteSync: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetDevId: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMDeviceRemoval, IAMDeviceRemoval_Vtbl, 0xf90a6130_b658_11d2_ae49_0000f8754b99);
::windows_core::imp::interface_hierarchy!(IAMDeviceRemoval, ::windows_core::IUnknown);
impl IAMDeviceRemoval {
    pub unsafe fn DeviceInfo(&self, pclsidinterfaceclass: *mut ::windows_core::GUID, pwszsymboliclink: *mut ::windows_core::PWSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DeviceInfo)(::windows_core::Interface::as_raw(self), pclsidinterfaceclass, pwszsymboliclink).ok()
    }
    pub unsafe fn Reassociate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reassociate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Disassociate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Disassociate)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAMDeviceRemoval_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub DeviceInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub Reassociate: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Disassociate: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMDirectSound, IAMDirectSound_Vtbl, 0x546f4260_d53e_11cf_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(IAMDirectSound, ::windows_core::IUnknown);
impl IAMDirectSound {
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetDirectSoundInterface(&self) -> ::windows_core::Result<super::Audio::DirectSound::IDirectSound> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectSoundInterface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetPrimaryBufferInterface(&self) -> ::windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPrimaryBufferInterface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetSecondaryBufferInterface(&self) -> ::windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSecondaryBufferInterface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseDirectSoundInterface<P0>(&self, lpds: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::Audio::DirectSound::IDirectSound>,
    {
        (::windows_core::Interface::vtable(self).ReleaseDirectSoundInterface)(::windows_core::Interface::as_raw(self), lpds.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleasePrimaryBufferInterface<P0>(&self, lpdsb: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::Audio::DirectSound::IDirectSoundBuffer>,
    {
        (::windows_core::Interface::vtable(self).ReleasePrimaryBufferInterface)(::windows_core::Interface::as_raw(self), lpdsb.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseSecondaryBufferInterface<P0>(&self, lpdsb: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::Audio::DirectSound::IDirectSoundBuffer>,
    {
        (::windows_core::Interface::vtable(self).ReleaseSecondaryBufferInterface)(::windows_core::Interface::as_raw(self), lpdsb.into_param().abi()).ok()
    }
    pub unsafe fn SetFocusWindow<P0, P1>(&self, param0: P0, param1: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetFocusWindow)(::windows_core::Interface::as_raw(self), param0.into_param().abi(), param1.into_param().abi()).ok()
    }
    pub unsafe fn GetFocusWindow(&self, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFocusWindow)(::windows_core::Interface::as_raw(self), param0, param1).ok()
    }
}
#[repr(C)]
pub struct IAMDirectSound_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetDirectSoundInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetDirectSoundInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetPrimaryBufferInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetPrimaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetSecondaryBufferInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetSecondaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleaseDirectSoundInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleaseDirectSoundInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleasePrimaryBufferInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleasePrimaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleaseSecondaryBufferInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleaseSecondaryBufferInterface: usize,
    pub SetFocusWindow: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetFocusWindow: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::HWND, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMDroppedFrames, IAMDroppedFrames_Vtbl, 0xc6e13344_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMDroppedFrames, ::windows_core::IUnknown);
impl IAMDroppedFrames {
    pub unsafe fn GetNumDropped(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumDropped)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumNotDropped(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumNotDropped)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDroppedInfo(&self, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDroppedInfo)(::windows_core::Interface::as_raw(self), lsize, plarray, plnumcopied).ok()
    }
    pub unsafe fn GetAverageFrameSize(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAverageFrameSize)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMDroppedFrames_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNumDropped: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetNumNotDropped: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetDroppedInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetAverageFrameSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMExtDevice, IAMExtDevice_Vtbl, 0xb5730a90_1a2c_11cf_8c23_00aa006b6814);
::windows_core::imp::interface_hierarchy!(IAMExtDevice, ::windows_core::IUnknown);
impl IAMExtDevice {
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCapability)(::windows_core::Interface::as_raw(self), capability, pvalue, pdblvalue).ok()
    }
    pub unsafe fn ExternalDeviceID(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ExternalDeviceID)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ExternalDeviceVersion(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ExternalDeviceVersion)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDevicePower(&self, powermode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDevicePower)(::windows_core::Interface::as_raw(self), powermode).ok()
    }
    pub unsafe fn DevicePower(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DevicePower)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Calibrate(&self, hevent: usize, mode: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Calibrate)(::windows_core::Interface::as_raw(self), hevent, mode, &mut result__).map(|| result__)
    }
    pub unsafe fn SetDevicePort(&self, deviceport: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDevicePort)(::windows_core::Interface::as_raw(self), deviceport).ok()
    }
    pub unsafe fn DevicePort(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DevicePort)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMExtDevice_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCapability: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut f64) -> ::windows_core::HRESULT,
    pub ExternalDeviceID: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub ExternalDeviceVersion: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub SetDevicePower: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub DevicePower: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Calibrate: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetDevicePort: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub DevicePort: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMExtTransport, IAMExtTransport_Vtbl, 0xa03cd5f0_3045_11cf_8c44_00aa006b6814);
::windows_core::imp::interface_hierarchy!(IAMExtTransport, ::windows_core::IUnknown);
impl IAMExtTransport {
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCapability)(::windows_core::Interface::as_raw(self), capability, pvalue, pdblvalue).ok()
    }
    pub unsafe fn SetMediaState(&self, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn MediaState(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MediaState)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLocalControl(&self, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLocalControl)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn LocalControl(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).LocalControl)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetStatus(&self, statusitem: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), statusitem, &mut result__).map(|| result__)
    }
    pub unsafe fn GetTransportBasicParameters(&self, param: i32, pvalue: *mut i32, ppszdata: *mut ::windows_core::PWSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTransportBasicParameters)(::windows_core::Interface::as_raw(self), param, pvalue, ppszdata).ok()
    }
    pub unsafe fn SetTransportBasicParameters<P0>(&self, param: i32, value: i32, pszdata: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetTransportBasicParameters)(::windows_core::Interface::as_raw(self), param, value, pszdata.into_param().abi()).ok()
    }
    pub unsafe fn GetTransportVideoParameters(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTransportVideoParameters)(::windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
    }
    pub unsafe fn SetTransportVideoParameters(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTransportVideoParameters)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn GetTransportAudioParameters(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTransportAudioParameters)(::windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
    }
    pub unsafe fn SetTransportAudioParameters(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTransportAudioParameters)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn SetMode(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRate(&self, dblrate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRate)(::windows_core::Interface::as_raw(self), dblrate).ok()
    }
    pub unsafe fn Rate(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Rate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetChase(&self, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetChase)(::windows_core::Interface::as_raw(self), penabled, poffset, phevent).ok()
    }
    pub unsafe fn SetChase(&self, enable: i32, offset: i32, hevent: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetChase)(::windows_core::Interface::as_raw(self), enable, offset, hevent).ok()
    }
    pub unsafe fn GetBump(&self, pspeed: *mut i32, pduration: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBump)(::windows_core::Interface::as_raw(self), pspeed, pduration).ok()
    }
    pub unsafe fn SetBump(&self, speed: i32, duration: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBump)(::windows_core::Interface::as_raw(self), speed, duration).ok()
    }
    pub unsafe fn AntiClogControl(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AntiClogControl)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAntiClogControl(&self, enable: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAntiClogControl)(::windows_core::Interface::as_raw(self), enable).ok()
    }
    pub unsafe fn GetEditPropertySet(&self, editid: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEditPropertySet)(::windows_core::Interface::as_raw(self), editid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetEditPropertySet(&self, peditid: *mut i32, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEditPropertySet)(::windows_core::Interface::as_raw(self), peditid, state).ok()
    }
    pub unsafe fn GetEditProperty(&self, editid: i32, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEditProperty)(::windows_core::Interface::as_raw(self), editid, param, &mut result__).map(|| result__)
    }
    pub unsafe fn SetEditProperty(&self, editid: i32, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEditProperty)(::windows_core::Interface::as_raw(self), editid, param, value).ok()
    }
    pub unsafe fn EditStart(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EditStart)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetEditStart(&self, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEditStart)(::windows_core::Interface::as_raw(self), value).ok()
    }
}
#[repr(C)]
pub struct IAMExtTransport_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCapability: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut f64) -> ::windows_core::HRESULT,
    pub SetMediaState: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub MediaState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetLocalControl: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub LocalControl: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetTransportBasicParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub SetTransportBasicParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub GetTransportVideoParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetTransportVideoParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub GetTransportAudioParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetTransportAudioParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub Rate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub GetChase: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut usize) -> ::windows_core::HRESULT,
    pub SetChase: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, usize) -> ::windows_core::HRESULT,
    pub GetBump: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetBump: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub AntiClogControl: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetAntiClogControl: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetEditPropertySet: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetEditPropertySet: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, i32) -> ::windows_core::HRESULT,
    pub GetEditProperty: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetEditProperty: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub EditStart: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetEditStart: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMExtendedErrorInfo, IAMExtendedErrorInfo_Vtbl, 0xfa2aa8f6_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMExtendedErrorInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMExtendedErrorInfo {
    pub unsafe fn HasError(&self, phaserror: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HasError)(::windows_core::Interface::as_raw(self), phaserror).ok()
    }
    pub unsafe fn ErrorDescription(&self, pbstrerrordescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ErrorDescription)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrerrordescription)).ok()
    }
    pub unsafe fn ErrorCode(&self, perrorcode: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ErrorCode)(::windows_core::Interface::as_raw(self), perrorcode).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMExtendedErrorInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub HasError: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub ErrorDescription: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ErrorCode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMExtendedSeeking, IAMExtendedSeeking_Vtbl, 0xfa2aa8f9_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMExtendedSeeking, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMExtendedSeeking {
    pub unsafe fn ExSeekCapabilities(&self, pexcapabilities: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ExSeekCapabilities)(::windows_core::Interface::as_raw(self), pexcapabilities).ok()
    }
    pub unsafe fn MarkerCount(&self, pmarkercount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MarkerCount)(::windows_core::Interface::as_raw(self), pmarkercount).ok()
    }
    pub unsafe fn CurrentMarker(&self, pcurrentmarker: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CurrentMarker)(::windows_core::Interface::as_raw(self), pcurrentmarker).ok()
    }
    pub unsafe fn GetMarkerTime(&self, markernum: i32, pmarkertime: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMarkerTime)(::windows_core::Interface::as_raw(self), markernum, pmarkertime).ok()
    }
    pub unsafe fn GetMarkerName(&self, markernum: i32, pbstrmarkername: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMarkerName)(::windows_core::Interface::as_raw(self), markernum, ::core::mem::transmute(pbstrmarkername)).ok()
    }
    pub unsafe fn SetPlaybackSpeed(&self, speed: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPlaybackSpeed)(::windows_core::Interface::as_raw(self), speed).ok()
    }
    pub unsafe fn PlaybackSpeed(&self, pspeed: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PlaybackSpeed)(::windows_core::Interface::as_raw(self), pspeed).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMExtendedSeeking_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ExSeekCapabilities: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub MarkerCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub CurrentMarker: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetMarkerTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut f64) -> ::windows_core::HRESULT,
    pub GetMarkerName: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetPlaybackSpeed: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub PlaybackSpeed: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMFilterGraphCallback, IAMFilterGraphCallback_Vtbl, 0x56a868fd_0ad4_11ce_b0a3_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IAMFilterGraphCallback, ::windows_core::IUnknown);
impl IAMFilterGraphCallback {
    pub unsafe fn UnableToRender<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).UnableToRender)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMFilterGraphCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub UnableToRender: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMFilterMiscFlags, IAMFilterMiscFlags_Vtbl, 0x2dd74950_a890_11d1_abe8_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IAMFilterMiscFlags, ::windows_core::IUnknown);
impl IAMFilterMiscFlags {
    pub unsafe fn GetMiscFlags(&self) -> u32 {
        (::windows_core::Interface::vtable(self).GetMiscFlags)(::windows_core::Interface::as_raw(self))
    }
}
#[repr(C)]
pub struct IAMFilterMiscFlags_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMiscFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> u32,
}
::windows_core::imp::com_interface!(IAMGraphBuilderCallback, IAMGraphBuilderCallback_Vtbl, 0x4995f511_9ddb_4f12_bd3b_f04611807b79);
::windows_core::imp::interface_hierarchy!(IAMGraphBuilderCallback, ::windows_core::IUnknown);
impl IAMGraphBuilderCallback {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SelectedFilter<P0>(&self, pmon: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
    {
        (::windows_core::Interface::vtable(self).SelectedFilter)(::windows_core::Interface::as_raw(self), pmon.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreatedFilter<P0>(&self, pfil: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).CreatedFilter)(::windows_core::Interface::as_raw(self), pfil.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMGraphBuilderCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SelectedFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SelectedFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreatedFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreatedFilter: usize,
}
::windows_core::imp::com_interface!(IAMGraphStreams, IAMGraphStreams_Vtbl, 0x632105fa_072e_11d3_8af9_00c04fb6bd3d);
::windows_core::imp::interface_hierarchy!(IAMGraphStreams, ::windows_core::IUnknown);
impl IAMGraphStreams {
    pub unsafe fn FindUpstreamInterface<P0>(&self, ppin: P0, riid: *const ::windows_core::GUID, ppvinterface: *mut *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).FindUpstreamInterface)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), riid, ppvinterface, dwflags).ok()
    }
    pub unsafe fn SyncUsingStreamOffset<P0>(&self, busestreamoffset: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SyncUsingStreamOffset)(::windows_core::Interface::as_raw(self), busestreamoffset.into_param().abi()).ok()
    }
    pub unsafe fn SetMaxGraphLatency(&self, rtmaxgraphlatency: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMaxGraphLatency)(::windows_core::Interface::as_raw(self), rtmaxgraphlatency).ok()
    }
}
#[repr(C)]
pub struct IAMGraphStreams_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub FindUpstreamInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SyncUsingStreamOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetMaxGraphLatency: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMLatency, IAMLatency_Vtbl, 0x62ea93ba_ec62_11d2_b770_00c04fb6bd3d);
::windows_core::imp::interface_hierarchy!(IAMLatency, ::windows_core::IUnknown);
impl IAMLatency {
    pub unsafe fn GetLatency(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetLatency)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMLatency_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetLatency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMLine21Decoder, IAMLine21Decoder_Vtbl, 0x6e8d4a21_310c_11d0_b79a_00aa003767a7);
::windows_core::imp::interface_hierarchy!(IAMLine21Decoder, ::windows_core::IUnknown);
impl IAMLine21Decoder {
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDecoderLevel)(::windows_core::Interface::as_raw(self), lplevel).ok()
    }
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentService)(::windows_core::Interface::as_raw(self), lpservice).ok()
    }
    pub unsafe fn SetCurrentService(&self, service: AM_LINE21_CCSERVICE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentService)(::windows_core::Interface::as_raw(self), service).ok()
    }
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetServiceState)(::windows_core::Interface::as_raw(self), lpstate).ok()
    }
    pub unsafe fn SetServiceState(&self, state: AM_LINE21_CCSTATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetServiceState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmih).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmi).ok()
    }
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBackgroundColor)(::windows_core::Interface::as_raw(self), pdwphyscolor).ok()
    }
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBackgroundColor)(::windows_core::Interface::as_raw(self), dwphyscolor).ok()
    }
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRedrawAlways)(::windows_core::Interface::as_raw(self), lpboption).ok()
    }
    pub unsafe fn SetRedrawAlways<P0>(&self, boption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetRedrawAlways)(::windows_core::Interface::as_raw(self), boption.into_param().abi()).ok()
    }
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), lpmode).ok()
    }
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_LINE21_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
}
#[repr(C)]
pub struct IAMLine21Decoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDecoderLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_LINE21_CCLEVEL) -> ::windows_core::HRESULT,
    pub GetCurrentService: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_LINE21_CCSERVICE) -> ::windows_core::HRESULT,
    pub SetCurrentService: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_LINE21_CCSERVICE) -> ::windows_core::HRESULT,
    pub GetServiceState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_LINE21_CCSTATE) -> ::windows_core::HRESULT,
    pub SetServiceState: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_LINE21_CCSTATE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetOutputFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetOutputFormat: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetOutputFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetOutputFormat: usize,
    pub GetBackgroundColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRedrawAlways: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetRedrawAlways: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetDrawBackgroundMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_LINE21_DRAWBGMODE) -> ::windows_core::HRESULT,
    pub SetDrawBackgroundMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_LINE21_DRAWBGMODE) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMMediaContent, IAMMediaContent_Vtbl, 0xfa2aa8f4_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMMediaContent, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaContent {
    pub unsafe fn AuthorName(&self, pbstrauthorname: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AuthorName)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrauthorname)).ok()
    }
    pub unsafe fn Title(&self, pbstrtitle: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Title)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrtitle)).ok()
    }
    pub unsafe fn Rating(&self, pbstrrating: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Rating)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrrating)).ok()
    }
    pub unsafe fn Description(&self, pbstrdescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Description)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrdescription)).ok()
    }
    pub unsafe fn Copyright(&self, pbstrcopyright: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Copyright)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcopyright)).ok()
    }
    pub unsafe fn BaseURL(&self, pbstrbaseurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BaseURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrbaseurl)).ok()
    }
    pub unsafe fn LogoURL(&self, pbstrlogourl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LogoURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrlogourl)).ok()
    }
    pub unsafe fn LogoIconURL(&self, pbstrlogourl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LogoIconURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrlogourl)).ok()
    }
    pub unsafe fn WatermarkURL(&self, pbstrwatermarkurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WatermarkURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrwatermarkurl)).ok()
    }
    pub unsafe fn MoreInfoURL(&self, pbstrmoreinfourl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfourl)).ok()
    }
    pub unsafe fn MoreInfoBannerImage(&self, pbstrmoreinfobannerimage: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoBannerImage)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfobannerimage)).ok()
    }
    pub unsafe fn MoreInfoBannerURL(&self, pbstrmoreinfobannerurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoBannerURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfobannerurl)).ok()
    }
    pub unsafe fn MoreInfoText(&self, pbstrmoreinfotext: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoText)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfotext)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMMediaContent_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub AuthorName: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Title: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Rating: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Description: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Copyright: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub BaseURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub LogoURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub LogoIconURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub WatermarkURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoBannerImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoBannerURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoText: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMMediaContent2, IAMMediaContent2_Vtbl, 0xce8f78c1_74d9_11d2_b09d_00a0c9a81117);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMMediaContent2, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaContent2 {
    pub unsafe fn get_MediaParameter<P0>(&self, entrynum: i32, bstrname: P0, pbstrvalue: *mut ::windows_core::BSTR) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).get_MediaParameter)(::windows_core::Interface::as_raw(self), entrynum, bstrname.into_param().abi(), ::core::mem::transmute(pbstrvalue)).ok()
    }
    pub unsafe fn get_MediaParameterName(&self, entrynum: i32, index: i32, pbstrname: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_MediaParameterName)(::windows_core::Interface::as_raw(self), entrynum, index, ::core::mem::transmute(pbstrname)).ok()
    }
    pub unsafe fn PlaylistCount(&self, pnumberentries: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PlaylistCount)(::windows_core::Interface::as_raw(self), pnumberentries).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMMediaContent2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub get_MediaParameter: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub get_MediaParameterName: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub PlaylistCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMMediaStream, IAMMediaStream_Vtbl, 0xbebe595d_9a6f_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IAMMediaStream, ::windows_core::IUnknown, IMediaStream);
impl IAMMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn Initialize<P0>(&self, psourceobject: P0, dwflags: u32, purposeid: *const ::windows_core::GUID, streamtype: STREAM_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).Initialize)(::windows_core::Interface::as_raw(self), psourceobject.into_param().abi(), dwflags, purposeid, streamtype).ok()
    }
    pub unsafe fn SetState(&self, state: FILTER_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn JoinAMMultiMediaStream<P0>(&self, pammultimediastream: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMMultiMediaStream>,
    {
        (::windows_core::Interface::vtable(self).JoinAMMultiMediaStream)(::windows_core::Interface::as_raw(self), pammultimediastream.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn JoinFilter<P0>(&self, pmediastreamfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStreamFilter>,
    {
        (::windows_core::Interface::vtable(self).JoinFilter)(::windows_core::Interface::as_raw(self), pmediastreamfilter.into_param().abi()).ok()
    }
    pub unsafe fn JoinFilterGraph<P0>(&self, pfiltergraph: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IFilterGraph>,
    {
        (::windows_core::Interface::vtable(self).JoinFilterGraph)(::windows_core::Interface::as_raw(self), pfiltergraph.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32, *const ::windows_core::GUID, STREAM_TYPE) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, FILTER_STATE) -> ::windows_core::HRESULT,
    pub JoinAMMultiMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub JoinFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    JoinFilter: usize,
    pub JoinFilterGraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMMediaTypeSample, IAMMediaTypeSample_Vtbl, 0xab6b4afb_f6e4_11d0_900d_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IAMMediaTypeSample, ::windows_core::IUnknown, IStreamSample);
impl IAMMediaTypeSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
    pub unsafe fn SetPointer(&self, pbuffer: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPointer)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbuffer.as_ptr()), pbuffer.len().try_into().unwrap()).ok()
    }
    pub unsafe fn GetPointer(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPointer)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSize(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetSize)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn IsSyncPoint(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsSyncPoint)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetSyncPoint<P0>(&self, bissyncpoint: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetSyncPoint)(::windows_core::Interface::as_raw(self), bissyncpoint.into_param().abi()).ok()
    }
    pub unsafe fn IsPreroll(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsPreroll)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetPreroll<P0>(&self, bispreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetPreroll)(::windows_core::Interface::as_raw(self), bispreroll.into_param().abi()).ok()
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetActualDataLength)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetActualDataLength(&self, __midl__iammediatypesample0000: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetActualDataLength)(::windows_core::Interface::as_raw(self), __midl__iammediatypesample0000).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetMediaType(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaType)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaType)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    pub unsafe fn IsDiscontinuity(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsDiscontinuity)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDiscontinuity<P0>(&self, bdiscontinuity: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDiscontinuity)(::windows_core::Interface::as_raw(self), bdiscontinuity.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
}
#[repr(C)]
pub struct IAMMediaTypeSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    pub SetPointer: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const u8, i32) -> ::windows_core::HRESULT,
    pub GetPointer: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetSize: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> i32,
    pub GetTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub SetTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
    pub IsSyncPoint: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSyncPoint: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub IsPreroll: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetPreroll: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetActualDataLength: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> i32,
    pub SetActualDataLength: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetMediaType: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetMediaType: usize,
    pub IsDiscontinuity: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetDiscontinuity: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetMediaTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub SetMediaTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMMediaTypeStream, IAMMediaTypeStream_Vtbl, 0xab6b4afa_f6e4_11d0_900d_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IAMMediaTypeStream, ::windows_core::IUnknown, IMediaStream);
impl IAMMediaTypeStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetFormat(&self, pmediatype: *mut super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pmediatype, dwflags).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetFormat(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), pmediatype, dwflags).ok()
    }
    pub unsafe fn CreateSample<P0>(&self, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: P0) -> ::windows_core::Result<IAMMediaTypeSample>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSample)(::windows_core::Interface::as_raw(self), lsamplesize, pbbuffer, dwflags, punkouter.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetStreamAllocatorRequirements(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStreamAllocatorRequirements)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetStreamAllocatorRequirements(&self, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStreamAllocatorRequirements)(::windows_core::Interface::as_raw(self), pprops).ok()
    }
}
#[repr(C)]
pub struct IAMMediaTypeStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::MediaFoundation::AM_MEDIA_TYPE, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetFormat: usize,
    pub CreateSample: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *const u8, u32, *mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetStreamAllocatorRequirements: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub SetStreamAllocatorRequirements: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMMultiMediaStream, IAMMultiMediaStream_Vtbl, 0xbebe595c_9a6f_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IAMMultiMediaStream, ::windows_core::IUnknown, IMultiMediaStream);
impl IAMMultiMediaStream {
    pub unsafe fn GetInformation(&self, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), pdwflags, pstreamtype).ok()
    }
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows_core::GUID) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), idpurpose, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.EnumMediaStreams)(::windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetState(&self) -> ::windows_core::Result<STREAM_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetState)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetState(&self, newstate: STREAM_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetState)(::windows_core::Interface::as_raw(self), newstate).ok()
    }
    pub unsafe fn GetTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDuration(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetDuration)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Seek(&self, seektime: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Seek)(::windows_core::Interface::as_raw(self), seektime).ok()
    }
    pub unsafe fn GetEndOfStreamEventHandle(&self) -> ::windows_core::Result<super::super::Foundation::HANDLE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetEndOfStreamEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Initialize<P0>(&self, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).Initialize)(::windows_core::Interface::as_raw(self), streamtype, dwflags.0 as _, pfiltergraph.into_param().abi()).ok()
    }
    pub unsafe fn GetFilterGraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFilterGraph)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFilter(&self) -> ::windows_core::Result<IMediaStreamFilter> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFilter)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AddMediaStream<P0>(&self, pstreamobject: P0, purposeid: *const ::windows_core::GUID, dwflags: AMMSF_MS_FLAGS) -> ::windows_core::Result<IMediaStream>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddMediaStream)(::windows_core::Interface::as_raw(self), pstreamobject.into_param().abi(), purposeid, dwflags.0 as _, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn OpenFile<P0>(&self, pszfilename: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).OpenFile)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), dwflags).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OpenMoniker<P0, P1>(&self, pctx: P0, pmoniker: P1, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IBindCtx>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
    {
        (::windows_core::Interface::vtable(self).OpenMoniker)(::windows_core::Interface::as_raw(self), pctx.into_param().abi(), pmoniker.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn Render(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Render)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
}
#[repr(C)]
pub struct IAMMultiMediaStream_Vtbl {
    pub base__: IMultiMediaStream_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut ::core::ffi::c_void, STREAM_TYPE, u32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFilterGraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFilter: usize,
    pub AddMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const ::windows_core::GUID, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub OpenFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OpenMoniker: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OpenMoniker: usize,
    pub Render: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMNetShowConfig, IAMNetShowConfig_Vtbl, 0xfa2aa8f1_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetShowConfig, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowConfig {
    pub unsafe fn BufferingTime(&self, pbufferingtime: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BufferingTime)(::windows_core::Interface::as_raw(self), pbufferingtime).ok()
    }
    pub unsafe fn SetBufferingTime(&self, bufferingtime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBufferingTime)(::windows_core::Interface::as_raw(self), bufferingtime).ok()
    }
    pub unsafe fn UseFixedUDPPort(&self, pusefixedudpport: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseFixedUDPPort)(::windows_core::Interface::as_raw(self), pusefixedudpport).ok()
    }
    pub unsafe fn SetUseFixedUDPPort<P0>(&self, usefixedudpport: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetUseFixedUDPPort)(::windows_core::Interface::as_raw(self), usefixedudpport.into_param().abi()).ok()
    }
    pub unsafe fn FixedUDPPort(&self, pfixedudpport: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FixedUDPPort)(::windows_core::Interface::as_raw(self), pfixedudpport).ok()
    }
    pub unsafe fn SetFixedUDPPort(&self, fixedudpport: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFixedUDPPort)(::windows_core::Interface::as_raw(self), fixedudpport).ok()
    }
    pub unsafe fn UseHTTPProxy(&self, pusehttpproxy: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseHTTPProxy)(::windows_core::Interface::as_raw(self), pusehttpproxy).ok()
    }
    pub unsafe fn SetUseHTTPProxy<P0>(&self, usehttpproxy: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetUseHTTPProxy)(::windows_core::Interface::as_raw(self), usehttpproxy.into_param().abi()).ok()
    }
    pub unsafe fn EnableAutoProxy(&self, penableautoproxy: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableAutoProxy)(::windows_core::Interface::as_raw(self), penableautoproxy).ok()
    }
    pub unsafe fn SetEnableAutoProxy<P0>(&self, enableautoproxy: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableAutoProxy)(::windows_core::Interface::as_raw(self), enableautoproxy.into_param().abi()).ok()
    }
    pub unsafe fn HTTPProxyHost(&self, pbstrhttpproxyhost: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HTTPProxyHost)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrhttpproxyhost)).ok()
    }
    pub unsafe fn SetHTTPProxyHost<P0>(&self, bstrhttpproxyhost: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetHTTPProxyHost)(::windows_core::Interface::as_raw(self), bstrhttpproxyhost.into_param().abi()).ok()
    }
    pub unsafe fn HTTPProxyPort(&self, phttpproxyport: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HTTPProxyPort)(::windows_core::Interface::as_raw(self), phttpproxyport).ok()
    }
    pub unsafe fn SetHTTPProxyPort(&self, httpproxyport: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetHTTPProxyPort)(::windows_core::Interface::as_raw(self), httpproxyport).ok()
    }
    pub unsafe fn EnableMulticast(&self, penablemulticast: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableMulticast)(::windows_core::Interface::as_raw(self), penablemulticast).ok()
    }
    pub unsafe fn SetEnableMulticast<P0>(&self, enablemulticast: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableMulticast)(::windows_core::Interface::as_raw(self), enablemulticast.into_param().abi()).ok()
    }
    pub unsafe fn EnableUDP(&self, penableudp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableUDP)(::windows_core::Interface::as_raw(self), penableudp).ok()
    }
    pub unsafe fn SetEnableUDP<P0>(&self, enableudp: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableUDP)(::windows_core::Interface::as_raw(self), enableudp.into_param().abi()).ok()
    }
    pub unsafe fn EnableTCP(&self, penabletcp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableTCP)(::windows_core::Interface::as_raw(self), penabletcp).ok()
    }
    pub unsafe fn SetEnableTCP<P0>(&self, enabletcp: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableTCP)(::windows_core::Interface::as_raw(self), enabletcp.into_param().abi()).ok()
    }
    pub unsafe fn EnableHTTP(&self, penablehttp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableHTTP)(::windows_core::Interface::as_raw(self), penablehttp).ok()
    }
    pub unsafe fn SetEnableHTTP<P0>(&self, enablehttp: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableHTTP)(::windows_core::Interface::as_raw(self), enablehttp.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetShowConfig_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub BufferingTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetBufferingTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub UseFixedUDPPort: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetUseFixedUDPPort: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub FixedUDPPort: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetFixedUDPPort: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub UseHTTPProxy: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetUseHTTPProxy: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub EnableAutoProxy: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetEnableAutoProxy: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub HTTPProxyHost: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetHTTPProxyHost: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub HTTPProxyPort: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetHTTPProxyPort: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub EnableMulticast: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetEnableMulticast: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub EnableUDP: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetEnableUDP: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub EnableTCP: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetEnableTCP: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub EnableHTTP: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub SetEnableHTTP: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMNetShowExProps, IAMNetShowExProps_Vtbl, 0xfa2aa8f5_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetShowExProps, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowExProps {
    pub unsafe fn SourceProtocol(&self, psourceprotocol: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SourceProtocol)(::windows_core::Interface::as_raw(self), psourceprotocol).ok()
    }
    pub unsafe fn Bandwidth(&self, pbandwidth: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Bandwidth)(::windows_core::Interface::as_raw(self), pbandwidth).ok()
    }
    pub unsafe fn ErrorCorrection(&self, pbstrerrorcorrection: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ErrorCorrection)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrerrorcorrection)).ok()
    }
    pub unsafe fn CodecCount(&self, pcodeccount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CodecCount)(::windows_core::Interface::as_raw(self), pcodeccount).ok()
    }
    pub unsafe fn GetCodecInstalled(&self, codecnum: i32, pcodecinstalled: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCodecInstalled)(::windows_core::Interface::as_raw(self), codecnum, pcodecinstalled).ok()
    }
    pub unsafe fn GetCodecDescription(&self, codecnum: i32, pbstrcodecdescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCodecDescription)(::windows_core::Interface::as_raw(self), codecnum, ::core::mem::transmute(pbstrcodecdescription)).ok()
    }
    pub unsafe fn GetCodecURL(&self, codecnum: i32, pbstrcodecurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCodecURL)(::windows_core::Interface::as_raw(self), codecnum, ::core::mem::transmute(pbstrcodecurl)).ok()
    }
    pub unsafe fn CreationDate(&self, pcreationdate: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreationDate)(::windows_core::Interface::as_raw(self), pcreationdate).ok()
    }
    pub unsafe fn SourceLink(&self, pbstrsourcelink: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SourceLink)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrsourcelink)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetShowExProps_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SourceProtocol: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Bandwidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub ErrorCorrection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub CodecCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetCodecInstalled: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub GetCodecDescription: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetCodecURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub CreationDate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SourceLink: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMNetShowPreroll, IAMNetShowPreroll_Vtbl, 0xaae7e4e2_6388_11d1_8d93_006097c9a2b2);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetShowPreroll, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowPreroll {
    pub unsafe fn SetPreroll<P0>(&self, fpreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetPreroll)(::windows_core::Interface::as_raw(self), fpreroll.into_param().abi()).ok()
    }
    pub unsafe fn Preroll(&self, pfpreroll: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Preroll)(::windows_core::Interface::as_raw(self), pfpreroll).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetShowPreroll_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SetPreroll: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub Preroll: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMNetworkStatus, IAMNetworkStatus_Vtbl, 0xfa2aa8f3_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetworkStatus, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetworkStatus {
    pub unsafe fn ReceivedPackets(&self, preceivedpackets: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReceivedPackets)(::windows_core::Interface::as_raw(self), preceivedpackets).ok()
    }
    pub unsafe fn RecoveredPackets(&self, precoveredpackets: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RecoveredPackets)(::windows_core::Interface::as_raw(self), precoveredpackets).ok()
    }
    pub unsafe fn LostPackets(&self, plostpackets: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LostPackets)(::windows_core::Interface::as_raw(self), plostpackets).ok()
    }
    pub unsafe fn ReceptionQuality(&self, preceptionquality: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReceptionQuality)(::windows_core::Interface::as_raw(self), preceptionquality).ok()
    }
    pub unsafe fn BufferingCount(&self, pbufferingcount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BufferingCount)(::windows_core::Interface::as_raw(self), pbufferingcount).ok()
    }
    pub unsafe fn IsBroadcast(&self, pisbroadcast: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsBroadcast)(::windows_core::Interface::as_raw(self), pisbroadcast).ok()
    }
    pub unsafe fn BufferingProgress(&self, pbufferingprogress: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BufferingProgress)(::windows_core::Interface::as_raw(self), pbufferingprogress).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetworkStatus_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ReceivedPackets: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub RecoveredPackets: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub LostPackets: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub ReceptionQuality: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub BufferingCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub IsBroadcast: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub BufferingProgress: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMOpenProgress, IAMOpenProgress_Vtbl, 0x8e1c39a1_de53_11cf_aa63_0080c744528d);
::windows_core::imp::interface_hierarchy!(IAMOpenProgress, ::windows_core::IUnknown);
impl IAMOpenProgress {
    pub unsafe fn QueryProgress(&self, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryProgress)(::windows_core::Interface::as_raw(self), plltotal, pllcurrent).ok()
    }
    pub unsafe fn AbortOperation(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AbortOperation)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAMOpenProgress_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryProgress: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub AbortOperation: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMOverlayFX, IAMOverlayFX_Vtbl, 0x62fae250_7e65_4460_bfc9_6398b322073c);
::windows_core::imp::interface_hierarchy!(IAMOverlayFX, ::windows_core::IUnknown);
impl IAMOverlayFX {
    pub unsafe fn QueryOverlayFXCaps(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryOverlayFXCaps)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOverlayFX(&self, dwoverlayfx: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOverlayFX)(::windows_core::Interface::as_raw(self), dwoverlayfx).ok()
    }
    pub unsafe fn GetOverlayFX(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOverlayFX)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMOverlayFX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryOverlayFXCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetOverlayFX: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetOverlayFX: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMParse, IAMParse_Vtbl, 0xc47a3420_005c_11d2_9038_00a0c9697298);
::windows_core::imp::interface_hierarchy!(IAMParse, ::windows_core::IUnknown);
impl IAMParse {
    pub unsafe fn GetParseTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParseTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetParseTime(&self, rtcurrent: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParseTime)(::windows_core::Interface::as_raw(self), rtcurrent).ok()
    }
    pub unsafe fn Flush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Flush)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAMParse_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetParseTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub SetParseTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
    pub Flush: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMPhysicalPinInfo, IAMPhysicalPinInfo_Vtbl, 0xf938c991_3029_11cf_8c44_00aa006b6814);
::windows_core::imp::interface_hierarchy!(IAMPhysicalPinInfo, ::windows_core::IUnknown);
impl IAMPhysicalPinInfo {
    pub unsafe fn GetPhysicalType(&self, ptype: *mut i32, ppsztype: *mut ::windows_core::PWSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPhysicalType)(::windows_core::Interface::as_raw(self), ptype, ppsztype).ok()
    }
}
#[repr(C)]
pub struct IAMPhysicalPinInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPhysicalType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMPlayList, IAMPlayList_Vtbl, 0x56a868fe_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IAMPlayList, ::windows_core::IUnknown);
impl IAMPlayList {
    pub unsafe fn GetFlags(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFlags)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetItemCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetItemCount)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetItem(&self, dwitemindex: u32) -> ::windows_core::Result<IAMPlayListItem> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetItem)(::windows_core::Interface::as_raw(self), dwitemindex, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetNamedEvent<P0>(&self, pwszeventname: P0, dwitemindex: u32, ppitem: *mut ::core::option::Option<IAMPlayListItem>, pdwflags: *mut u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).GetNamedEvent)(::windows_core::Interface::as_raw(self), pwszeventname.into_param().abi(), dwitemindex, ::core::mem::transmute(ppitem), pdwflags).ok()
    }
    pub unsafe fn GetRepeatInfo(&self, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRepeatInfo)(::windows_core::Interface::as_raw(self), pdwrepeatcount, pdwrepeatstart, pdwrepeatend).ok()
    }
}
#[repr(C)]
pub struct IAMPlayList_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetItemCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetItem: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetNamedEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, u32, *mut *mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetRepeatInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMPlayListItem, IAMPlayListItem_Vtbl, 0x56a868ff_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IAMPlayListItem, ::windows_core::IUnknown);
impl IAMPlayListItem {
    pub unsafe fn GetFlags(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFlags)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceCount)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceURL(&self, dwsourceindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceURL)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetSourceStart(&self, dwsourceindex: u32) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceStart)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceDuration(&self, dwsourceindex: u32) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceDuration)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceStartMarker(&self, dwsourceindex: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceStartMarker)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceEndMarker(&self, dwsourceindex: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceEndMarker)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSourceStartMarkerName(&self, dwsourceindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceStartMarkerName)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetSourceEndMarkerName(&self, dwsourceindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceEndMarkerName)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetLinkURL(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetLinkURL)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetScanDuration(&self, dwsourceindex: u32) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetScanDuration)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMPlayListItem_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetSourceStart: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut i64) -> ::windows_core::HRESULT,
    pub GetSourceDuration: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut i64) -> ::windows_core::HRESULT,
    pub GetSourceStartMarker: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceEndMarker: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceStartMarkerName: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetSourceEndMarkerName: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetLinkURL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetScanDuration: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMPluginControl, IAMPluginControl_Vtbl, 0x0e26a181_f40c_4635_8786_976284b52981);
::windows_core::imp::interface_hierarchy!(IAMPluginControl, ::windows_core::IUnknown);
impl IAMPluginControl {
    pub unsafe fn GetPreferredClsid(&self, subtype: *const ::windows_core::GUID) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPreferredClsid)(::windows_core::Interface::as_raw(self), subtype, &mut result__).map(|| result__)
    }
    pub unsafe fn GetPreferredClsidByIndex(&self, index: u32, subtype: *mut ::windows_core::GUID, clsid: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPreferredClsidByIndex)(::windows_core::Interface::as_raw(self), index, subtype, clsid).ok()
    }
    pub unsafe fn SetPreferredClsid(&self, subtype: *const ::windows_core::GUID, clsid: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPreferredClsid)(::windows_core::Interface::as_raw(self), subtype, ::core::mem::transmute(clsid.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn IsDisabled(&self, clsid: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsDisabled)(::windows_core::Interface::as_raw(self), clsid).ok()
    }
    pub unsafe fn GetDisabledByIndex(&self, index: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDisabledByIndex)(::windows_core::Interface::as_raw(self), index, &mut result__).map(|| result__)
    }
    pub unsafe fn SetDisabled<P0>(&self, clsid: *const ::windows_core::GUID, disabled: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDisabled)(::windows_core::Interface::as_raw(self), clsid, disabled.into_param().abi()).ok()
    }
    pub unsafe fn IsLegacyDisabled<P0>(&self, dllname: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).IsLegacyDisabled)(::windows_core::Interface::as_raw(self), dllname.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMPluginControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPreferredClsid: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPreferredClsidByIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetPreferredClsid: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub IsDisabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDisabledByIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetDisabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub IsLegacyDisabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMPushSource, IAMPushSource_Vtbl, 0xf185fe76_e64e_11d2_b76e_00c04fb6bd3d);
::windows_core::imp::interface_hierarchy!(IAMPushSource, ::windows_core::IUnknown, IAMLatency);
impl IAMPushSource {
    pub unsafe fn GetLatency(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetLatency)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPushSourceFlags(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPushSourceFlags)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPushSourceFlags(&self, flags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPushSourceFlags)(::windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetStreamOffset(&self, rtoffset: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStreamOffset)(::windows_core::Interface::as_raw(self), rtoffset).ok()
    }
    pub unsafe fn GetStreamOffset(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStreamOffset)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMaxStreamOffset(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMaxStreamOffset)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMaxStreamOffset(&self, rtmaxoffset: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMaxStreamOffset)(::windows_core::Interface::as_raw(self), rtmaxoffset).ok()
    }
}
#[repr(C)]
pub struct IAMPushSource_Vtbl {
    pub base__: IAMLatency_Vtbl,
    pub GetPushSourceFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetPushSourceFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetStreamOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
    pub GetStreamOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub GetMaxStreamOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub SetMaxStreamOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMRebuild, IAMRebuild_Vtbl, 0x02ef04dd_7580_11d1_bece_00c04fb6e937);
::windows_core::imp::interface_hierarchy!(IAMRebuild, ::windows_core::IUnknown);
impl IAMRebuild {
    pub unsafe fn RebuildNow(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RebuildNow)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAMRebuild_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RebuildNow: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMResourceControl, IAMResourceControl_Vtbl, 0x8389d2d0_77d7_11d1_abe6_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IAMResourceControl, ::windows_core::IUnknown);
impl IAMResourceControl {
    pub unsafe fn Reserve(&self, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reserve)(::windows_core::Interface::as_raw(self), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null()))).ok()
    }
}
#[repr(C)]
pub struct IAMResourceControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Reserve: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IAMStats, IAMStats_Vtbl, 0xbc9bcf80_dcd2_11d2_abf6_00a0c905f375);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMStats, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMStats {
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Count(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetValueByIndex(&self, lindex: i32, szname: *mut ::windows_core::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetValueByIndex)(::windows_core::Interface::as_raw(self), lindex, ::core::mem::transmute(szname), lcount, dlast, daverage, dstddev, dmin, dmax).ok()
    }
    pub unsafe fn GetValueByName<P0>(&self, szname: P0, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).GetValueByName)(::windows_core::Interface::as_raw(self), szname.into_param().abi(), lindex, lcount, dlast, daverage, dstddev, dmin, dmax).ok()
    }
    pub unsafe fn GetIndex<P0>(&self, szname: P0, lcreate: i32) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetIndex)(::windows_core::Interface::as_raw(self), szname.into_param().abi(), lcreate, &mut result__).map(|| result__)
    }
    pub unsafe fn AddValue(&self, lindex: i32, dvalue: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AddValue)(::windows_core::Interface::as_raw(self), lindex, dvalue).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMStats_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Count: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetValueByIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut i32, *mut f64, *mut f64, *mut f64, *mut f64, *mut f64) -> ::windows_core::HRESULT,
    pub GetValueByName: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut i32, *mut i32, *mut f64, *mut f64, *mut f64, *mut f64, *mut f64) -> ::windows_core::HRESULT,
    pub GetIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, i32, *mut i32) -> ::windows_core::HRESULT,
    pub AddValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, f64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMStreamConfig, IAMStreamConfig_Vtbl, 0xc6e13340_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMStreamConfig, ::windows_core::IUnknown);
impl IAMStreamConfig {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetFormat(&self, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), pmt).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetFormat(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumberOfCapabilities(&self, picount: *mut i32, pisize: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNumberOfCapabilities)(::windows_core::Interface::as_raw(self), picount, pisize).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetStreamCaps(&self, iindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStreamCaps)(::windows_core::Interface::as_raw(self), iindex, ppmt, pscc).ok()
    }
}
#[repr(C)]
pub struct IAMStreamConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetFormat: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetFormat: usize,
    pub GetNumberOfCapabilities: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetStreamCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, *mut u8) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetStreamCaps: usize,
}
::windows_core::imp::com_interface!(IAMStreamControl, IAMStreamControl_Vtbl, 0x36b73881_c2c8_11cf_8b46_00805f6cef60);
::windows_core::imp::interface_hierarchy!(IAMStreamControl, ::windows_core::IUnknown);
impl IAMStreamControl {
    pub unsafe fn StartAt(&self, ptstart: ::core::option::Option<*const i64>, dwcookie: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StartAt)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptstart.unwrap_or(::std::ptr::null())), dwcookie).ok()
    }
    pub unsafe fn StopAt<P0>(&self, ptstop: ::core::option::Option<*const i64>, bsendextra: P0, dwcookie: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).StopAt)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptstop.unwrap_or(::std::ptr::null())), bsendextra.into_param().abi(), dwcookie).ok()
    }
    pub unsafe fn GetInfo(&self, pinfo: *mut AM_STREAM_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
}
#[repr(C)]
pub struct IAMStreamControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub StartAt: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, u32) -> ::windows_core::HRESULT,
    pub StopAt: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, super::super::Foundation::BOOL, u32) -> ::windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_STREAM_INFO) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMStreamSelect, IAMStreamSelect_Vtbl, 0xc1960960_17f5_11d1_abe1_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IAMStreamSelect, ::windows_core::IUnknown);
impl IAMStreamSelect {
    pub unsafe fn Count(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn Info(&self, lindex: i32, ppmt: ::core::option::Option<*mut *mut super::MediaFoundation::AM_MEDIA_TYPE>, pdwflags: ::core::option::Option<*mut u32>, plcid: ::core::option::Option<*mut u32>, pdwgroup: ::core::option::Option<*mut u32>, ppszname: ::core::option::Option<*mut ::windows_core::PWSTR>, ppobject: ::core::option::Option<*mut ::core::option::Option<::windows_core::IUnknown>>, ppunk: ::core::option::Option<*mut ::core::option::Option<::windows_core::IUnknown>>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Info)(
            ::windows_core::Interface::as_raw(self),
            lindex,
            ::core::mem::transmute(ppmt.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdwflags.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(plcid.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdwgroup.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppszname.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppobject.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppunk.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn Enable(&self, lindex: i32, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Enable)(::windows_core::Interface::as_raw(self), lindex, dwflags).ok()
    }
}
#[repr(C)]
pub struct IAMStreamSelect_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Count: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub Info: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, *mut u32, *mut u32, *mut u32, *mut ::windows_core::PWSTR, *mut *mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    Info: usize,
    pub Enable: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTVAudio, IAMTVAudio_Vtbl, 0x83ec1c30_23d1_11d1_99e6_00a0c9560266);
::windows_core::imp::interface_hierarchy!(IAMTVAudio, ::windows_core::IUnknown);
impl IAMTVAudio {
    pub unsafe fn GetHardwareSupportedTVAudioModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetHardwareSupportedTVAudioModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAvailableTVAudioModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAvailableTVAudioModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn TVAudioMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVAudioMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTVAudioMode(&self, lmode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTVAudioMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMTVAudio_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetHardwareSupportedTVAudioModes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetAvailableTVAudioModes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub TVAudioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTVAudioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub RegisterNotificationCallBack: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub UnRegisterNotificationCallBack: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTVAudioNotification, IAMTVAudioNotification_Vtbl, 0x83ec1c33_23d1_11d1_99e6_00a0c9560266);
::windows_core::imp::interface_hierarchy!(IAMTVAudioNotification, ::windows_core::IUnknown);
impl IAMTVAudioNotification {
    pub unsafe fn OnEvent(&self, event: AMTVAudioEventType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnEvent)(::windows_core::Interface::as_raw(self), event).ok()
    }
}
#[repr(C)]
pub struct IAMTVAudioNotification_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, AMTVAudioEventType) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTVTuner, IAMTVTuner_Vtbl, 0x211a8766_03ac_11d1_8d13_00aa00bd8339);
::windows_core::imp::interface_hierarchy!(IAMTVTuner, ::windows_core::IUnknown, IAMTuner);
impl IAMTVTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.put_Channel)(::windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok()
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.get_Channel)(::windows_core::Interface::as_raw(self), plchannel, plvideosubchannel, plaudiosubchannel).ok()
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ChannelMinMax)(::windows_core::Interface::as_raw(self), lchannelmin, lchannelmax).ok()
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetCountryCode)(::windows_core::Interface::as_raw(self), lcountrycode).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTuningSpace)(::windows_core::Interface::as_raw(self), ltuningspace).ok()
    }
    pub unsafe fn TuningSpace(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.TuningSpace)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Logon<P0>(&self, hcurrentuser: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Logon)(::windows_core::Interface::as_raw(self), hcurrentuser.into_param().abi()).ok()
    }
    pub unsafe fn Logout(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Logout)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SignalPresent(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SignalPresent)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<AMTunerModeType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.Mode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAvailableModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetAvailableModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
    pub unsafe fn AvailableTVFormats(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvailableTVFormats)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn TVFormat(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVFormat)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AutoTune(&self, lchannel: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AutoTune)(::windows_core::Interface::as_raw(self), lchannel, &mut result__).map(|| result__)
    }
    pub unsafe fn StoreAutoTune(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StoreAutoTune)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn NumInputConnections(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).NumInputConnections)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn put_InputType(&self, lindex: i32, inputtype: TunerInputType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_InputType)(::windows_core::Interface::as_raw(self), lindex, inputtype).ok()
    }
    pub unsafe fn get_InputType(&self, lindex: i32) -> ::windows_core::Result<TunerInputType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_InputType)(::windows_core::Interface::as_raw(self), lindex, &mut result__).map(|| result__)
    }
    pub unsafe fn SetConnectInput(&self, lindex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetConnectInput)(::windows_core::Interface::as_raw(self), lindex).ok()
    }
    pub unsafe fn ConnectInput(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ConnectInput)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn VideoFrequency(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VideoFrequency)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AudioFrequency(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AudioFrequency)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IAMTVTuner_Vtbl {
    pub base__: IAMTuner_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub AutoTune: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub StoreAutoTune: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NumInputConnections: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub put_InputType: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, TunerInputType) -> ::windows_core::HRESULT,
    pub get_InputType: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut TunerInputType) -> ::windows_core::HRESULT,
    pub SetConnectInput: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub ConnectInput: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub VideoFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub AudioFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTimecodeDisplay, IAMTimecodeDisplay_Vtbl, 0x9b496ce2_811b_11cf_8c77_00aa006b6814);
::windows_core::imp::interface_hierarchy!(IAMTimecodeDisplay, ::windows_core::IUnknown);
impl IAMTimecodeDisplay {
    pub unsafe fn GetTCDisplayEnable(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCDisplayEnable)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTCDisplayEnable(&self, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCDisplayEnable)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn GetTCDisplay(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCDisplay)(::windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
    }
    pub unsafe fn SetTCDisplay(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCDisplay)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
}
#[repr(C)]
pub struct IAMTimecodeDisplay_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTCDisplayEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTCDisplayEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetTCDisplay: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetTCDisplay: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTimecodeGenerator, IAMTimecodeGenerator_Vtbl, 0x9b496ce0_811b_11cf_8c77_00aa006b6814);
::windows_core::imp::interface_hierarchy!(IAMTimecodeGenerator, ::windows_core::IUnknown);
impl IAMTimecodeGenerator {
    pub unsafe fn GetTCGMode(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCGMode)(::windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
    }
    pub unsafe fn SetTCGMode(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCGMode)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVITCLine)(::windows_core::Interface::as_raw(self), line).ok()
    }
    pub unsafe fn VITCLine(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VITCLine)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTimecode(&self, ptimecodesample: *const super::TIMECODE_SAMPLE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTimecode)(::windows_core::Interface::as_raw(self), ptimecodesample).ok()
    }
    pub unsafe fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTimecode)(::windows_core::Interface::as_raw(self), ptimecodesample).ok()
    }
}
#[repr(C)]
pub struct IAMTimecodeGenerator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTCGMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetTCGMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub SetVITCLine: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub VITCLine: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTimecode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::TIMECODE_SAMPLE) -> ::windows_core::HRESULT,
    pub GetTimecode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::TIMECODE_SAMPLE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTimecodeReader, IAMTimecodeReader_Vtbl, 0x9b496ce1_811b_11cf_8c77_00aa006b6814);
::windows_core::imp::interface_hierarchy!(IAMTimecodeReader, ::windows_core::IUnknown);
impl IAMTimecodeReader {
    pub unsafe fn GetTCRMode(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCRMode)(::windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
    }
    pub unsafe fn SetTCRMode(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCRMode)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVITCLine)(::windows_core::Interface::as_raw(self), line).ok()
    }
    pub unsafe fn VITCLine(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VITCLine)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTimecode)(::windows_core::Interface::as_raw(self), ptimecodesample).ok()
    }
}
#[repr(C)]
pub struct IAMTimecodeReader_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTCRMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetTCRMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub SetVITCLine: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub VITCLine: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetTimecode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::TIMECODE_SAMPLE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTuner, IAMTuner_Vtbl, 0x211a8761_03ac_11d1_8d13_00aa00bd8339);
::windows_core::imp::interface_hierarchy!(IAMTuner, ::windows_core::IUnknown);
impl IAMTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Channel)(::windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok()
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Channel)(::windows_core::Interface::as_raw(self), plchannel, plvideosubchannel, plaudiosubchannel).ok()
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelMinMax)(::windows_core::Interface::as_raw(self), lchannelmin, lchannelmax).ok()
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCountryCode)(::windows_core::Interface::as_raw(self), lcountrycode).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTuningSpace)(::windows_core::Interface::as_raw(self), ltuningspace).ok()
    }
    pub unsafe fn TuningSpace(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TuningSpace)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Logon<P0>(&self, hcurrentuser: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Logon)(::windows_core::Interface::as_raw(self), hcurrentuser.into_param().abi()).ok()
    }
    pub unsafe fn Logout(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Logout)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SignalPresent(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SignalPresent)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<AMTunerModeType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAvailableModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAvailableModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMTuner_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub put_Channel: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub get_Channel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub ChannelMinMax: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub CountryCode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTuningSpace: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub TuningSpace: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Logon: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    pub Logout: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SignalPresent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, AMTunerModeType) -> ::windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AMTunerModeType) -> ::windows_core::HRESULT,
    pub GetAvailableModes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub RegisterNotificationCallBack: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub UnRegisterNotificationCallBack: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMTunerNotification, IAMTunerNotification_Vtbl, 0x211a8760_03ac_11d1_8d13_00aa00bd8339);
::windows_core::imp::interface_hierarchy!(IAMTunerNotification, ::windows_core::IUnknown);
impl IAMTunerNotification {
    pub unsafe fn OnEvent(&self, event: AMTunerEventType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnEvent)(::windows_core::Interface::as_raw(self), event).ok()
    }
}
#[repr(C)]
pub struct IAMTunerNotification_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, AMTunerEventType) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVfwCaptureDialogs, IAMVfwCaptureDialogs_Vtbl, 0xd8d715a0_6e5e_11d0_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(IAMVfwCaptureDialogs, ::windows_core::IUnknown);
impl IAMVfwCaptureDialogs {
    pub unsafe fn HasDialog(&self, idialog: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HasDialog)(::windows_core::Interface::as_raw(self), idialog).ok()
    }
    pub unsafe fn ShowDialog<P0>(&self, idialog: i32, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).ShowDialog)(::windows_core::Interface::as_raw(self), idialog, hwnd.into_param().abi()).ok()
    }
    pub unsafe fn SendDriverMessage(&self, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SendDriverMessage)(::windows_core::Interface::as_raw(self), idialog, umsg, dw1, dw2).ok()
    }
}
#[repr(C)]
pub struct IAMVfwCaptureDialogs_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub HasDialog: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub ShowDialog: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    pub SendDriverMessage: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVfwCompressDialogs, IAMVfwCompressDialogs_Vtbl, 0xd8d715a3_6e5e_11d0_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(IAMVfwCompressDialogs, ::windows_core::IUnknown);
impl IAMVfwCompressDialogs {
    pub unsafe fn ShowDialog<P0>(&self, idialog: i32, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).ShowDialog)(::windows_core::Interface::as_raw(self), idialog, hwnd.into_param().abi()).ok()
    }
    pub unsafe fn GetState(&self, pstate: *mut ::core::ffi::c_void, pcbstate: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), pstate, pcbstate).ok()
    }
    pub unsafe fn SetState(&self, pstate: *const ::core::ffi::c_void, cbstate: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), pstate, cbstate).ok()
    }
    pub unsafe fn SendDriverMessage(&self, umsg: i32, dw1: i32, dw2: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SendDriverMessage)(::windows_core::Interface::as_raw(self), umsg, dw1, dw2).ok()
    }
}
#[repr(C)]
pub struct IAMVfwCompressDialogs_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub ShowDialog: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SendDriverMessage: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVideoAccelerator, IAMVideoAccelerator_Vtbl, 0x256a6a22_fbad_11d1_82bf_00a0c9696c8f);
::windows_core::imp::interface_hierarchy!(IAMVideoAccelerator, ::windows_core::IUnknown);
impl IAMVideoAccelerator {
    pub unsafe fn GetVideoAcceleratorGUIDs(&self, pdwnumguidssupported: *mut u32, pguidssupported: ::core::option::Option<*mut ::windows_core::GUID>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoAcceleratorGUIDs)(::windows_core::Interface::as_raw(self), pdwnumguidssupported, ::core::mem::transmute(pguidssupported.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompFormatsSupported(&self, pguid: *const ::windows_core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDPIXELFORMAT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetUncompFormatsSupported)(::windows_core::Interface::as_raw(self), pguid, pdwnumformatssupported, ::core::mem::transmute(pformatssupported.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalMemInfo(&self, pguid: *const ::windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInternalMemInfo)(::windows_core::Interface::as_raw(self), pguid, pamvauncompdatainfo, pamvainternalmeminfo).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetCompBufferInfo(&self, pguid: *const ::windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: ::core::option::Option<*mut AMVACompBufferInfo>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCompBufferInfo)(::windows_core::Interface::as_raw(self), pguid, pamvauncompdatainfo, pdwnumtypescompbuffers, ::core::mem::transmute(pamvacompbufferinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalCompBufferInfo(&self, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: ::core::option::Option<*mut AMVACompBufferInfo>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInternalCompBufferInfo)(::windows_core::Interface::as_raw(self), pdwnumtypescompbuffers, ::core::mem::transmute(pamvacompbufferinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn BeginFrame(&self, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BeginFrame)(::windows_core::Interface::as_raw(self), amvabeginframeinfo).ok()
    }
    pub unsafe fn EndFrame(&self, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndFrame)(::windows_core::Interface::as_raw(self), pendframeinfo).ok()
    }
    pub unsafe fn GetBuffer<P0>(&self, dwtypeindex: u32, dwbufferindex: u32, breadonly: P0, ppbuffer: *mut *mut ::core::ffi::c_void, lpstride: *mut i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).GetBuffer)(::windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex, breadonly.into_param().abi(), ppbuffer, lpstride).ok()
    }
    pub unsafe fn ReleaseBuffer(&self, dwtypeindex: u32, dwbufferindex: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReleaseBuffer)(::windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex).ok()
    }
    pub unsafe fn Execute(&self, dwfunction: u32, lpprivateinputdata: *const ::core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::core::ffi::c_void, cbprivateoutputdata: u32, pamvabufferinfo: &[AMVABUFFERINFO]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Execute)(::windows_core::Interface::as_raw(self), dwfunction, lpprivateinputdata, cbprivateinputdata, lpprivateoutputdat, cbprivateoutputdata, pamvabufferinfo.len().try_into().unwrap(), ::core::mem::transmute(pamvabufferinfo.as_ptr())).ok()
    }
    pub unsafe fn QueryRenderStatus(&self, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryRenderStatus)(::windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex, dwflags).ok()
    }
    pub unsafe fn DisplayFrame<P0>(&self, dwfliptoindex: u32, pmediasample: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).DisplayFrame)(::windows_core::Interface::as_raw(self), dwfliptoindex, pmediasample.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMVideoAccelerator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetVideoAcceleratorGUIDs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetUncompFormatsSupported: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut u32, *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetUncompFormatsSupported: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetInternalMemInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const AMVAUncompDataInfo, *mut AMVAInternalMemInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetInternalMemInfo: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetCompBufferInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const AMVAUncompDataInfo, *mut u32, *mut AMVACompBufferInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetCompBufferInfo: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetInternalCompBufferInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut AMVACompBufferInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetInternalCompBufferInfo: usize,
    pub BeginFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const AMVABeginFrameInfo) -> ::windows_core::HRESULT,
    pub EndFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const AMVAEndFrameInfo) -> ::windows_core::HRESULT,
    pub GetBuffer: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, super::super::Foundation::BOOL, *mut *mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub ReleaseBuffer: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const ::core::ffi::c_void, u32, *const ::core::ffi::c_void, u32, u32, *const AMVABUFFERINFO) -> ::windows_core::HRESULT,
    pub QueryRenderStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32) -> ::windows_core::HRESULT,
    pub DisplayFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVideoAcceleratorNotify, IAMVideoAcceleratorNotify_Vtbl, 0x256a6a21_fbad_11d1_82bf_00a0c9696c8f);
::windows_core::imp::interface_hierarchy!(IAMVideoAcceleratorNotify, ::windows_core::IUnknown);
impl IAMVideoAcceleratorNotify {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompSurfacesInfo(&self, pguid: *const ::windows_core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetUncompSurfacesInfo)(::windows_core::Interface::as_raw(self), pguid, puncompbufferinfo).ok()
    }
    pub unsafe fn SetUncompSurfacesInfo(&self, dwactualuncompsurfacesallocated: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetUncompSurfacesInfo)(::windows_core::Interface::as_raw(self), dwactualuncompsurfacesallocated).ok()
    }
    pub unsafe fn GetCreateVideoAcceleratorData(&self, pguid: *const ::windows_core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCreateVideoAcceleratorData)(::windows_core::Interface::as_raw(self), pguid, pdwsizemiscdata, ppmiscdata).ok()
    }
}
#[repr(C)]
pub struct IAMVideoAcceleratorNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetUncompSurfacesInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut AMVAUncompBufferInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetUncompSurfacesInfo: usize,
    pub SetUncompSurfacesInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetCreateVideoAcceleratorData: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVideoCompression, IAMVideoCompression_Vtbl, 0xc6e13343_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMVideoCompression, ::windows_core::IUnknown);
impl IAMVideoCompression {
    pub unsafe fn SetKeyFrameRate(&self, keyframerate: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetKeyFrameRate)(::windows_core::Interface::as_raw(self), keyframerate).ok()
    }
    pub unsafe fn KeyFrameRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).KeyFrameRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPFramesPerKeyFrame(&self, pframesperkeyframe: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPFramesPerKeyFrame)(::windows_core::Interface::as_raw(self), pframesperkeyframe).ok()
    }
    pub unsafe fn PFramesPerKeyFrame(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PFramesPerKeyFrame)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetQuality(&self, quality: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetQuality)(::windows_core::Interface::as_raw(self), quality).ok()
    }
    pub unsafe fn Quality(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Quality)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetWindowSize(&self, windowsize: u64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowSize)(::windows_core::Interface::as_raw(self), windowsize).ok()
    }
    pub unsafe fn WindowSize(&self) -> ::windows_core::Result<u64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WindowSize)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetInfo(&self, pszversion: ::windows_core::PWSTR, pcbversion: ::core::option::Option<*mut i32>, pszdescription: ::windows_core::PWSTR, pcbdescription: ::core::option::Option<*mut i32>, pdefaultkeyframerate: ::core::option::Option<*mut i32>, pdefaultpframesperkey: ::core::option::Option<*mut i32>, pdefaultquality: ::core::option::Option<*mut f64>, pcapabilities: ::core::option::Option<*mut i32>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(
            ::windows_core::Interface::as_raw(self),
            ::core::mem::transmute(pszversion),
            ::core::mem::transmute(pcbversion.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pszdescription),
            ::core::mem::transmute(pcbdescription.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdefaultkeyframerate.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdefaultpframesperkey.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdefaultquality.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pcapabilities.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn OverrideKeyFrame(&self, framenumber: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OverrideKeyFrame)(::windows_core::Interface::as_raw(self), framenumber).ok()
    }
    pub unsafe fn OverrideFrameSize(&self, framenumber: i32, size: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OverrideFrameSize)(::windows_core::Interface::as_raw(self), framenumber, size).ok()
    }
}
#[repr(C)]
pub struct IAMVideoCompression_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetKeyFrameRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub KeyFrameRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetPFramesPerKeyFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub PFramesPerKeyFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetQuality: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub Quality: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetWindowSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, u64) -> ::windows_core::HRESULT,
    pub WindowSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u64) -> ::windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PWSTR, *mut i32, ::windows_core::PWSTR, *mut i32, *mut i32, *mut i32, *mut f64, *mut i32) -> ::windows_core::HRESULT,
    pub OverrideKeyFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub OverrideFrameSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVideoControl, IAMVideoControl_Vtbl, 0x6a2e0670_28e4_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMVideoControl, ::windows_core::IUnknown);
impl IAMVideoControl {
    pub unsafe fn GetCaps<P0>(&self, ppin: P0) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCaps)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMode<P0>(&self, ppin: P0, mode: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), mode).ok()
    }
    pub unsafe fn GetMode<P0>(&self, ppin: P0) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMode)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentActualFrameRate<P0>(&self, ppin: P0) -> ::windows_core::Result<i64>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentActualFrameRate)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetMaxAvailableFrameRate<P0>(&self, ppin: P0, iindex: i32, dimensions: super::super::Foundation::SIZE) -> ::windows_core::Result<i64>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMaxAvailableFrameRate)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), iindex, ::core::mem::transmute(dimensions), &mut result__).map(|| result__)
    }
    pub unsafe fn GetFrameRateList<P0>(&self, ppin: P0, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).GetFrameRateList)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), iindex, ::core::mem::transmute(dimensions), listsize, framerates).ok()
    }
}
#[repr(C)]
pub struct IAMVideoControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetCurrentActualFrameRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub GetMaxAvailableFrameRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, i32, super::super::Foundation::SIZE, *mut i64) -> ::windows_core::HRESULT,
    pub GetFrameRateList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, i32, super::super::Foundation::SIZE, *mut i32, *mut *mut i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVideoDecimationProperties, IAMVideoDecimationProperties_Vtbl, 0x60d32930_13da_11d3_9ec6_c4fcaef5c7be);
::windows_core::imp::interface_hierarchy!(IAMVideoDecimationProperties, ::windows_core::IUnknown);
impl IAMVideoDecimationProperties {
    pub unsafe fn QueryDecimationUsage(&self) -> ::windows_core::Result<DECIMATION_USAGE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryDecimationUsage)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDecimationUsage(&self, usage: DECIMATION_USAGE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecimationUsage)(::windows_core::Interface::as_raw(self), usage).ok()
    }
}
#[repr(C)]
pub struct IAMVideoDecimationProperties_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryDecimationUsage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DECIMATION_USAGE) -> ::windows_core::HRESULT,
    pub SetDecimationUsage: unsafe extern "system" fn(*mut ::core::ffi::c_void, DECIMATION_USAGE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMVideoProcAmp, IAMVideoProcAmp_Vtbl, 0xc6e13360_30ac_11d0_a18c_00a0c9118956);
::windows_core::imp::interface_hierarchy!(IAMVideoProcAmp, ::windows_core::IUnknown);
impl IAMVideoProcAmp {
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRange)(::windows_core::Interface::as_raw(self), property, pmin, pmax, psteppingdelta, pdefault, pcapsflags).ok()
    }
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Set)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Get)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
}
#[repr(C)]
pub struct IAMVideoProcAmp_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub Set: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub Get: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMWMBufferPass, IAMWMBufferPass_Vtbl, 0x6dd816d7_e740_4123_9e24_2444412644d8);
::windows_core::imp::interface_hierarchy!(IAMWMBufferPass, ::windows_core::IUnknown);
impl IAMWMBufferPass {
    pub unsafe fn SetNotify<P0>(&self, pcallback: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMWMBufferPassCallback>,
    {
        (::windows_core::Interface::vtable(self).SetNotify)(::windows_core::Interface::as_raw(self), pcallback.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IAMWMBufferPass_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetNotify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMWMBufferPassCallback, IAMWMBufferPassCallback_Vtbl, 0xb25b8372_d2d2_44b2_8653_1b8dae332489);
::windows_core::imp::interface_hierarchy!(IAMWMBufferPassCallback, ::windows_core::IUnknown);
impl IAMWMBufferPassCallback {
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn Notify<P0, P1>(&self, pnssbuffer3: P0, ppin: P1, prtstart: *const i64, prtend: *const i64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::INSSBuffer3>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Notify)(::windows_core::Interface::as_raw(self), pnssbuffer3.into_param().abi(), ppin.into_param().abi(), prtstart, prtend).ok()
    }
}
#[repr(C)]
pub struct IAMWMBufferPassCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub Notify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    Notify: usize,
}
::windows_core::imp::com_interface!(IAMWstDecoder, IAMWstDecoder_Vtbl, 0xc056de21_75c2_11d3_a184_00105aef9f33);
::windows_core::imp::interface_hierarchy!(IAMWstDecoder, ::windows_core::IUnknown);
impl IAMWstDecoder {
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_WST_LEVEL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDecoderLevel)(::windows_core::Interface::as_raw(self), lplevel).ok()
    }
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_WST_SERVICE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentService)(::windows_core::Interface::as_raw(self), lpservice).ok()
    }
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_WST_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetServiceState)(::windows_core::Interface::as_raw(self), lpstate).ok()
    }
    pub unsafe fn SetServiceState(&self, state: AM_WST_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetServiceState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmih).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmi).ok()
    }
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBackgroundColor)(::windows_core::Interface::as_raw(self), pdwphyscolor).ok()
    }
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBackgroundColor)(::windows_core::Interface::as_raw(self), dwphyscolor).ok()
    }
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRedrawAlways)(::windows_core::Interface::as_raw(self), lpboption).ok()
    }
    pub unsafe fn SetRedrawAlways<P0>(&self, boption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetRedrawAlways)(::windows_core::Interface::as_raw(self), boption.into_param().abi()).ok()
    }
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), lpmode).ok()
    }
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_WST_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn SetAnswerMode<P0>(&self, banswer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetAnswerMode)(::windows_core::Interface::as_raw(self), banswer.into_param().abi()).ok()
    }
    pub unsafe fn GetAnswerMode(&self, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAnswerMode)(::windows_core::Interface::as_raw(self), pbanswer).ok()
    }
    pub unsafe fn SetHoldPage<P0>(&self, bholdpage: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetHoldPage)(::windows_core::Interface::as_raw(self), bholdpage.into_param().abi()).ok()
    }
    pub unsafe fn GetHoldPage(&self, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetHoldPage)(::windows_core::Interface::as_raw(self), pbholdpage).ok()
    }
    pub unsafe fn GetCurrentPage(&self, pwstpage: *mut AM_WST_PAGE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentPage)(::windows_core::Interface::as_raw(self), pwstpage).ok()
    }
    pub unsafe fn SetCurrentPage(&self, wstpage: AM_WST_PAGE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentPage)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(wstpage)).ok()
    }
}
#[repr(C)]
pub struct IAMWstDecoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDecoderLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_WST_LEVEL) -> ::windows_core::HRESULT,
    pub GetCurrentService: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_WST_SERVICE) -> ::windows_core::HRESULT,
    pub GetServiceState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_WST_STATE) -> ::windows_core::HRESULT,
    pub SetServiceState: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_WST_STATE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetOutputFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetOutputFormat: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetOutputFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetOutputFormat: usize,
    pub GetBackgroundColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRedrawAlways: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetRedrawAlways: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetDrawBackgroundMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_WST_DRAWBGMODE) -> ::windows_core::HRESULT,
    pub SetDrawBackgroundMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_WST_DRAWBGMODE) -> ::windows_core::HRESULT,
    pub SetAnswerMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetAnswerMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetHoldPage: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetHoldPage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetCurrentPage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_WST_PAGE) -> ::windows_core::HRESULT,
    pub SetCurrentPage: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_WST_PAGE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAMovieSetup, IAMovieSetup_Vtbl, 0xa3d8cec0_7e5a_11cf_bbc5_00805f6cef20);
::windows_core::imp::interface_hierarchy!(IAMovieSetup, ::windows_core::IUnknown);
impl IAMovieSetup {
    pub unsafe fn Register(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Register)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Unregister(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Unregister)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAMovieSetup_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Register: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Unregister: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAsyncReader, IAsyncReader_Vtbl, 0x56a868aa_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IAsyncReader, ::windows_core::IUnknown);
impl IAsyncReader {
    pub unsafe fn RequestAllocator<P0>(&self, ppreferred: P0, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<IMemAllocator>
    where
        P0: ::windows_core::IntoParam<IMemAllocator>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RequestAllocator)(::windows_core::Interface::as_raw(self), ppreferred.into_param().abi(), pprops, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Request<P0>(&self, psample: P0, dwuser: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).Request)(::windows_core::Interface::as_raw(self), psample.into_param().abi(), dwuser).ok()
    }
    pub unsafe fn WaitForNext(&self, dwtimeout: u32, ppsample: ::core::option::Option<*mut ::core::option::Option<IMediaSample>>, pdwuser: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitForNext)(::windows_core::Interface::as_raw(self), dwtimeout, ::core::mem::transmute(ppsample.unwrap_or(::std::ptr::null_mut())), pdwuser).ok()
    }
    pub unsafe fn SyncReadAligned<P0>(&self, psample: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).SyncReadAligned)(::windows_core::Interface::as_raw(self), psample.into_param().abi()).ok()
    }
    pub unsafe fn SyncRead(&self, llposition: i64, pbuffer: &mut [u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SyncRead)(::windows_core::Interface::as_raw(self), llposition, pbuffer.len().try_into().unwrap(), ::core::mem::transmute(pbuffer.as_ptr())).ok()
    }
    pub unsafe fn Length(&self, ptotal: *mut i64, pavailable: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Length)(::windows_core::Interface::as_raw(self), ptotal, pavailable).ok()
    }
    pub unsafe fn BeginFlush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BeginFlush)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndFlush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndFlush)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IAsyncReader_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RequestAllocator: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const ALLOCATOR_PROPERTIES, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    pub WaitForNext: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void, *mut usize) -> ::windows_core::HRESULT,
    pub SyncReadAligned: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SyncRead: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64, i32, *mut u8) -> ::windows_core::HRESULT,
    pub Length: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub BeginFlush: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EndFlush: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAudioData, IAudioData_Vtbl, 0x54c719c0_af60_11d0_8212_00c04fc32c45);
::windows_core::imp::interface_hierarchy!(IAudioData, ::windows_core::IUnknown, IMemoryData);
impl IAudioData {
    pub unsafe fn SetBuffer(&self, cbsize: u32, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetBuffer)(::windows_core::Interface::as_raw(self), cbsize, pbdata, dwflags).ok()
    }
    pub unsafe fn GetInfo(&self, pdwlength: *mut u32, ppbdata: *mut *mut u8, pcbactualdata: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInfo)(::windows_core::Interface::as_raw(self), pdwlength, ppbdata, pcbactualdata).ok()
    }
    pub unsafe fn SetActual(&self, cbdatavalid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetActual)(::windows_core::Interface::as_raw(self), cbdatavalid).ok()
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pwaveformatcurrent).ok()
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), lpwaveformat).ok()
    }
}
#[repr(C)]
pub struct IAudioData_Vtbl {
    pub base__: IMemoryData_Vtbl,
    #[cfg(feature = "Win32_Media_Audio")]
    pub GetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_Audio")]
    pub SetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    SetFormat: usize,
}
::windows_core::imp::com_interface!(IAudioMediaStream, IAudioMediaStream_Vtbl, 0xf7537560_a3be_11d0_8212_00c04fc32c45);
::windows_core::imp::interface_hierarchy!(IAudioMediaStream, ::windows_core::IUnknown, IMediaStream);
impl IAudioMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pwaveformatcurrent).ok()
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), lpwaveformat).ok()
    }
    pub unsafe fn CreateSample<P0>(&self, paudiodata: P0, dwflags: u32) -> ::windows_core::Result<IAudioStreamSample>
    where
        P0: ::windows_core::IntoParam<IAudioData>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSample)(::windows_core::Interface::as_raw(self), paudiodata.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IAudioMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Media_Audio")]
    pub GetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_Audio")]
    pub SetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    SetFormat: usize,
    pub CreateSample: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IAudioStreamSample, IAudioStreamSample_Vtbl, 0x345fee00_aba5_11d0_8212_00c04fc32c45);
::windows_core::imp::interface_hierarchy!(IAudioStreamSample, ::windows_core::IUnknown, IStreamSample);
impl IAudioStreamSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
    pub unsafe fn GetAudioData(&self) -> ::windows_core::Result<IAudioData> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAudioData)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IAudioStreamSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    pub GetAudioData: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_AUX, IBDA_AUX_Vtbl, 0x7def4c09_6e66_4567_a819_f0e17f4a81ab);
::windows_core::imp::interface_hierarchy!(IBDA_AUX, ::windows_core::IUnknown);
impl IBDA_AUX {
    pub unsafe fn QueryCapabilities(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryCapabilities)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn EnumCapability(&self, dwindex: u32, dwinputid: *mut u32, pconnectortype: *mut ::windows_core::GUID, conntypenum: *mut u32, numvideostds: *mut u32, analogstds: *mut u64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumCapability)(::windows_core::Interface::as_raw(self), dwindex, dwinputid, pconnectortype, conntypenum, numvideostds, analogstds).ok()
    }
}
#[repr(C)]
pub struct IBDA_AUX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryCapabilities: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub EnumCapability: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut ::windows_core::GUID, *mut u32, *mut u32, *mut u64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_AutoDemodulate, IBDA_AutoDemodulate_Vtbl, 0xddf15b12_bd25_11d2_9ca0_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_AutoDemodulate, ::windows_core::IUnknown);
impl IBDA_AutoDemodulate {
    pub unsafe fn put_AutoDemodulate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_AutoDemodulate)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IBDA_AutoDemodulate_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub put_AutoDemodulate: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_AutoDemodulateEx, IBDA_AutoDemodulateEx_Vtbl, 0x34518d13_1182_48e6_b28f_b24987787326);
::windows_core::imp::interface_hierarchy!(IBDA_AutoDemodulateEx, ::windows_core::IUnknown, IBDA_AutoDemodulate);
impl IBDA_AutoDemodulateEx {
    pub unsafe fn put_AutoDemodulate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.put_AutoDemodulate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn get_SupportedDeviceNodeTypes(&self, ulcdevicenodetypesmax: u32, pulcdevicenodetypes: *mut u32, pguiddevicenodetypes: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SupportedDeviceNodeTypes)(::windows_core::Interface::as_raw(self), ulcdevicenodetypesmax, pulcdevicenodetypes, pguiddevicenodetypes).ok()
    }
    pub unsafe fn get_SupportedVideoFormats(&self, pulamtunermodetype: *mut u32, pulanalogvideostandard: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SupportedVideoFormats)(::windows_core::Interface::as_raw(self), pulamtunermodetype, pulanalogvideostandard).ok()
    }
    pub unsafe fn get_AuxInputCount(&self, pulcompositecount: *mut u32, pulsvideocount: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_AuxInputCount)(::windows_core::Interface::as_raw(self), pulcompositecount, pulsvideocount).ok()
    }
}
#[repr(C)]
pub struct IBDA_AutoDemodulateEx_Vtbl {
    pub base__: IBDA_AutoDemodulate_Vtbl,
    pub get_SupportedDeviceNodeTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub get_SupportedVideoFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub get_AuxInputCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_ConditionalAccess, IBDA_ConditionalAccess_Vtbl, 0xcd51f1e0_7be9_4123_8482_a2a796c0a6b0);
::windows_core::imp::interface_hierarchy!(IBDA_ConditionalAccess, ::windows_core::IUnknown);
impl IBDA_ConditionalAccess {
    pub unsafe fn get_SmartCardStatus(&self, pcardstatus: *mut SmartCardStatusType, pcardassociation: *mut SmartCardAssociationType, pbstrcarderror: *mut ::windows_core::BSTR, pfooblocked: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SmartCardStatus)(::windows_core::Interface::as_raw(self), pcardstatus, pcardassociation, ::core::mem::transmute(pbstrcarderror), pfooblocked).ok()
    }
    pub unsafe fn get_SmartCardInfo(&self, pbstrcardname: *mut ::windows_core::BSTR, pbstrcardmanufacturer: *mut ::windows_core::BSTR, pfdaylightsavings: *mut super::super::Foundation::VARIANT_BOOL, pbyratingregion: *mut u8, pltimezoneoffsetminutes: *mut i32, pbstrlanguage: *mut ::windows_core::BSTR, pealocationcode: *mut EALocationCodeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SmartCardInfo)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcardname), ::core::mem::transmute(pbstrcardmanufacturer), pfdaylightsavings, pbyratingregion, pltimezoneoffsetminutes, ::core::mem::transmute(pbstrlanguage), pealocationcode).ok()
    }
    pub unsafe fn get_SmartCardApplications(&self, pulcapplications: *mut u32, rgapplications: &mut [SmartCardApplication]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SmartCardApplications)(::windows_core::Interface::as_raw(self), pulcapplications, rgapplications.len().try_into().unwrap(), ::core::mem::transmute(rgapplications.as_ptr())).ok()
    }
    pub unsafe fn get_Entitlement(&self, usvirtualchannel: u16) -> ::windows_core::Result<EntitlementType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_Entitlement)(::windows_core::Interface::as_raw(self), usvirtualchannel, &mut result__).map(|| result__)
    }
    pub unsafe fn TuneByChannel(&self, usvirtualchannel: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TuneByChannel)(::windows_core::Interface::as_raw(self), usvirtualchannel).ok()
    }
    pub unsafe fn SetProgram(&self, usprogramnumber: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProgram)(::windows_core::Interface::as_raw(self), usprogramnumber).ok()
    }
    pub unsafe fn AddProgram(&self, usprogramnumber: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AddProgram)(::windows_core::Interface::as_raw(self), usprogramnumber).ok()
    }
    pub unsafe fn RemoveProgram(&self, usprogramnumber: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RemoveProgram)(::windows_core::Interface::as_raw(self), usprogramnumber).ok()
    }
    pub unsafe fn GetModuleUI(&self, bydialognumber: u8) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetModuleUI)(::windows_core::Interface::as_raw(self), bydialognumber, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn InformUIClosed(&self, bydialognumber: u8, closereason: UICloseReasonType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InformUIClosed)(::windows_core::Interface::as_raw(self), bydialognumber, closereason).ok()
    }
}
#[repr(C)]
pub struct IBDA_ConditionalAccess_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_SmartCardStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut SmartCardStatusType, *mut SmartCardAssociationType, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    pub get_SmartCardInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut super::super::Foundation::VARIANT_BOOL, *mut u8, *mut i32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut EALocationCodeType) -> ::windows_core::HRESULT,
    pub get_SmartCardApplications: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut SmartCardApplication) -> ::windows_core::HRESULT,
    pub get_Entitlement: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16, *mut EntitlementType) -> ::windows_core::HRESULT,
    pub TuneByChannel: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16) -> ::windows_core::HRESULT,
    pub SetProgram: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16) -> ::windows_core::HRESULT,
    pub AddProgram: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16) -> ::windows_core::HRESULT,
    pub RemoveProgram: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16) -> ::windows_core::HRESULT,
    pub GetModuleUI: unsafe extern "system" fn(*mut ::core::ffi::c_void, u8, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub InformUIClosed: unsafe extern "system" fn(*mut ::core::ffi::c_void, u8, UICloseReasonType) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_ConditionalAccessEx, IBDA_ConditionalAccessEx_Vtbl, 0x497c3418_23cb_44ba_bb62_769f506fcea7);
::windows_core::imp::interface_hierarchy!(IBDA_ConditionalAccessEx, ::windows_core::IUnknown);
impl IBDA_ConditionalAccessEx {
    pub unsafe fn CheckEntitlementToken<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, requesttype: BDA_CONDITIONALACCESS_REQUESTTYPE, pbentitlementtoken: &[u8]) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CheckEntitlementToken)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), requesttype, pbentitlementtoken.len().try_into().unwrap(), ::core::mem::transmute(pbentitlementtoken.as_ptr()), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCaptureToken(&self, pbcapturetoken: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCaptureToken)(::windows_core::Interface::as_raw(self), pbcapturetoken.len().try_into().unwrap(), ::core::mem::transmute(pbcapturetoken.as_ptr())).ok()
    }
    pub unsafe fn OpenBroadcastMmi<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, eventid: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).OpenBroadcastMmi)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), eventid).ok()
    }
    pub unsafe fn CloseMmiDialog<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, uldialognumber: u32, reasoncode: BDA_CONDITIONALACCESS_MMICLOSEREASON) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CloseMmiDialog)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), uldialognumber, reasoncode, &mut result__).map(|| result__)
    }
    pub unsafe fn CreateDialogRequestNumber(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateDialogRequestNumber)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBDA_ConditionalAccessEx_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CheckEntitlementToken: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, ::std::mem::MaybeUninit<::windows_core::BSTR>, BDA_CONDITIONALACCESS_REQUESTTYPE, u32, *const u8, *mut u32) -> ::windows_core::HRESULT,
    pub SetCaptureToken: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub OpenBroadcastMmi: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, ::std::mem::MaybeUninit<::windows_core::BSTR>, u32) -> ::windows_core::HRESULT,
    pub CloseMmiDialog: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, ::std::mem::MaybeUninit<::windows_core::BSTR>, u32, BDA_CONDITIONALACCESS_MMICLOSEREASON, *mut u32) -> ::windows_core::HRESULT,
    pub CreateDialogRequestNumber: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DRIDRMService, IBDA_DRIDRMService_Vtbl, 0x1f9bc2a5_44a3_4c52_aab1_0bbce5a1381d);
::windows_core::imp::interface_hierarchy!(IBDA_DRIDRMService, ::windows_core::IUnknown);
impl IBDA_DRIDRMService {
    pub unsafe fn SetDRM<P0>(&self, bstrnewdrm: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetDRM)(::windows_core::Interface::as_raw(self), bstrnewdrm.into_param().abi()).ok()
    }
    pub unsafe fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut ::windows_core::BSTR, drmuuid: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDRMStatus)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrdrmuuidlist), drmuuid).ok()
    }
    pub unsafe fn GetPairingStatus(&self, penumpairingstatus: *mut BDA_DrmPairingError) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPairingStatus)(::windows_core::Interface::as_raw(self), penumpairingstatus).ok()
    }
}
#[repr(C)]
pub struct IBDA_DRIDRMService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetDRM: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetDRMStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPairingStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut BDA_DrmPairingError) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DRIWMDRMSession, IBDA_DRIWMDRMSession_Vtbl, 0x05c690f8_56db_4bb2_b053_79c12098bb26);
::windows_core::imp::interface_hierarchy!(IBDA_DRIWMDRMSession, ::windows_core::IUnknown);
impl IBDA_DRIWMDRMSession {
    pub unsafe fn AcknowledgeLicense(&self, hrlicenseack: ::windows_core::HRESULT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AcknowledgeLicense)(::windows_core::Interface::as_raw(self), hrlicenseack).ok()
    }
    pub unsafe fn ProcessLicenseChallenge(&self, pblicensemessage: &[u8], pdwcblicenseresponse: *mut u32, ppblicenseresponse: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProcessLicenseChallenge)(::windows_core::Interface::as_raw(self), pblicensemessage.len().try_into().unwrap(), ::core::mem::transmute(pblicensemessage.as_ptr()), pdwcblicenseresponse, ppblicenseresponse).ok()
    }
    pub unsafe fn ProcessRegistrationChallenge(&self, pbregistrationmessage: &[u8], pdwcbregistrationresponse: *mut u32, ppbregistrationresponse: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProcessRegistrationChallenge)(::windows_core::Interface::as_raw(self), pbregistrationmessage.len().try_into().unwrap(), ::core::mem::transmute(pbregistrationmessage.as_ptr()), pdwcbregistrationresponse, ppbregistrationresponse).ok()
    }
    pub unsafe fn SetRevInfo(&self, pbrevinfo: &[u8], pdwresponse: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRevInfo)(::windows_core::Interface::as_raw(self), pbrevinfo.len().try_into().unwrap(), ::core::mem::transmute(pbrevinfo.as_ptr()), pdwresponse).ok()
    }
    pub unsafe fn SetCrl(&self, pbcrllen: &[u8], pdwresponse: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCrl)(::windows_core::Interface::as_raw(self), pbcrllen.len().try_into().unwrap(), ::core::mem::transmute(pbcrllen.as_ptr()), pdwresponse).ok()
    }
    pub unsafe fn GetHMSAssociationData(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetHMSAssociationData)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLastCardeaError(&self, pdwerror: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetLastCardeaError)(::windows_core::Interface::as_raw(self), pdwerror).ok()
    }
}
#[repr(C)]
pub struct IBDA_DRIWMDRMSession_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AcknowledgeLicense: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::HRESULT) -> ::windows_core::HRESULT,
    pub ProcessLicenseChallenge: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, *mut u32, *mut *mut u8) -> ::windows_core::HRESULT,
    pub ProcessRegistrationChallenge: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, *mut u32, *mut *mut u8) -> ::windows_core::HRESULT,
    pub SetRevInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, *mut u32) -> ::windows_core::HRESULT,
    pub SetCrl: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, *mut u32) -> ::windows_core::HRESULT,
    pub GetHMSAssociationData: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetLastCardeaError: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DRM, IBDA_DRM_Vtbl, 0xf98d88b0_1992_4cd6_a6d9_b9afab99330d);
::windows_core::imp::interface_hierarchy!(IBDA_DRM, ::windows_core::IUnknown);
impl IBDA_DRM {
    pub unsafe fn GetDRMPairingStatus(&self, pdwstatus: *mut u32, pherror: *mut ::windows_core::HRESULT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDRMPairingStatus)(::windows_core::Interface::as_raw(self), pdwstatus, pherror).ok()
    }
    pub unsafe fn PerformDRMPairing<P0>(&self, fsync: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).PerformDRMPairing)(::windows_core::Interface::as_raw(self), fsync.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IBDA_DRM_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDRMPairingStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut ::windows_core::HRESULT) -> ::windows_core::HRESULT,
    pub PerformDRMPairing: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DRMService, IBDA_DRMService_Vtbl, 0xbff6b5bb_b0ae_484c_9dca_73528fb0b46e);
::windows_core::imp::interface_hierarchy!(IBDA_DRMService, ::windows_core::IUnknown);
impl IBDA_DRMService {
    pub unsafe fn SetDRM(&self, puuidnewdrm: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDRM)(::windows_core::Interface::as_raw(self), puuidnewdrm).ok()
    }
    pub unsafe fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut ::windows_core::BSTR, drmuuid: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDRMStatus)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrdrmuuidlist), drmuuid).ok()
    }
}
#[repr(C)]
pub struct IBDA_DRMService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetDRM: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDRMStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DeviceControl, IBDA_DeviceControl_Vtbl, 0xfd0a5af3_b41d_11d2_9c95_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_DeviceControl, ::windows_core::IUnknown);
impl IBDA_DeviceControl {
    pub unsafe fn StartChanges(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StartChanges)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CheckChanges(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CheckChanges)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CommitChanges(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CommitChanges)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetChangeState(&self, pstate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetChangeState)(::windows_core::Interface::as_raw(self), pstate).ok()
    }
}
#[repr(C)]
pub struct IBDA_DeviceControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub StartChanges: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CheckChanges: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CommitChanges: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetChangeState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
::windows_core::imp::com_interface!(IBDA_DiagnosticProperties, IBDA_DiagnosticProperties_Vtbl, 0x20e80cb5_c543_4c1b_8eb3_49e719eee7d4);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
::windows_core::imp::interface_hierarchy!(IBDA_DiagnosticProperties, ::windows_core::IUnknown, super::super::System::Com::StructuredStorage::IPropertyBag);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl IBDA_DiagnosticProperties {
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Read<P0, P1>(&self, pszpropname: P0, pvar: *mut ::windows_core::VARIANT, perrorlog: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IErrorLog>,
    {
        (::windows_core::Interface::vtable(self).base__.Read)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), ::core::mem::transmute(pvar), perrorlog.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Write<P0>(&self, pszpropname: P0, pvar: *const ::windows_core::VARIANT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.Write)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), ::core::mem::transmute(pvar)).ok()
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(C)]
pub struct IBDA_DiagnosticProperties_Vtbl {
    pub base__: super::super::System::Com::StructuredStorage::IPropertyBag_Vtbl,
}
::windows_core::imp::com_interface!(IBDA_DigitalDemodulator, IBDA_DigitalDemodulator_Vtbl, 0xef30f379_985b_4d10_b640_a79d5e04e1e0);
::windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator, ::windows_core::IUnknown);
impl IBDA_DigitalDemodulator {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetInnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetInnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
}
#[repr(C)]
pub struct IBDA_DigitalDemodulator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetModulationType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ModulationType) -> ::windows_core::HRESULT,
    pub ModulationType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ModulationType) -> ::windows_core::HRESULT,
    pub SetInnerFECMethod: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const FECMethod) -> ::windows_core::HRESULT,
    pub InnerFECMethod: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut FECMethod) -> ::windows_core::HRESULT,
    pub SetInnerFECRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub InnerFECRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub SetOuterFECMethod: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const FECMethod) -> ::windows_core::HRESULT,
    pub OuterFECMethod: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut FECMethod) -> ::windows_core::HRESULT,
    pub SetOuterFECRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub OuterFECRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub SetSymbolRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const u32) -> ::windows_core::HRESULT,
    pub SymbolRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetSpectralInversion: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const SpectralInversion) -> ::windows_core::HRESULT,
    pub SpectralInversion: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut SpectralInversion) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DigitalDemodulator2, IBDA_DigitalDemodulator2_Vtbl, 0x525ed3ee_5cf3_4e1e_9a06_5368a84f9a6e);
::windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator2, ::windows_core::IUnknown, IBDA_DigitalDemodulator);
impl IBDA_DigitalDemodulator2 {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetInnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetInnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetOuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetOuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SetGuardInterval(&self, pguardinterval: *const GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetGuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn GuardInterval(&self, pguardinterval: *mut GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn SetTransmissionMode(&self, ptransmissionmode: *const TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn TransmissionMode(&self, ptransmissionmode: *mut TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn SetRollOff(&self, prolloff: *const RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn RollOff(&self, prolloff: *mut RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn SetPilot(&self, ppilot: *const Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
    pub unsafe fn Pilot(&self, ppilot: *mut Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
}
#[repr(C)]
pub struct IBDA_DigitalDemodulator2_Vtbl {
    pub base__: IBDA_DigitalDemodulator_Vtbl,
    pub SetGuardInterval: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const GuardInterval) -> ::windows_core::HRESULT,
    pub GuardInterval: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut GuardInterval) -> ::windows_core::HRESULT,
    pub SetTransmissionMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const TransmissionMode) -> ::windows_core::HRESULT,
    pub TransmissionMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut TransmissionMode) -> ::windows_core::HRESULT,
    pub SetRollOff: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const RollOff) -> ::windows_core::HRESULT,
    pub RollOff: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut RollOff) -> ::windows_core::HRESULT,
    pub SetPilot: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const Pilot) -> ::windows_core::HRESULT,
    pub Pilot: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut Pilot) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DigitalDemodulator3, IBDA_DigitalDemodulator3_Vtbl, 0x13f19604_7d32_4359_93a2_a05205d90ac9);
::windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator3, ::windows_core::IUnknown, IBDA_DigitalDemodulator, IBDA_DigitalDemodulator2);
impl IBDA_DigitalDemodulator3 {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.ModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetInnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.InnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetInnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.InnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetOuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.OuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetOuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.OuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetSymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetSpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SetGuardInterval(&self, pguardinterval: *const GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetGuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn GuardInterval(&self, pguardinterval: *mut GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn SetTransmissionMode(&self, ptransmissionmode: *const TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn TransmissionMode(&self, ptransmissionmode: *mut TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.TransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn SetRollOff(&self, prolloff: *const RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetRollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn RollOff(&self, prolloff: *mut RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.RollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn SetPilot(&self, ppilot: *const Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetPilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
    pub unsafe fn Pilot(&self, ppilot: *mut Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Pilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
    pub unsafe fn SetSignalTimeouts(&self, psignaltimeouts: *const BDA_SIGNAL_TIMEOUTS) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSignalTimeouts)(::windows_core::Interface::as_raw(self), psignaltimeouts).ok()
    }
    pub unsafe fn SignalTimeouts(&self, psignaltimeouts: *mut BDA_SIGNAL_TIMEOUTS) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalTimeouts)(::windows_core::Interface::as_raw(self), psignaltimeouts).ok()
    }
    pub unsafe fn SetPLPNumber(&self, pplpnumber: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPLPNumber)(::windows_core::Interface::as_raw(self), pplpnumber).ok()
    }
    pub unsafe fn PLPNumber(&self, pplpnumber: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PLPNumber)(::windows_core::Interface::as_raw(self), pplpnumber).ok()
    }
}
#[repr(C)]
pub struct IBDA_DigitalDemodulator3_Vtbl {
    pub base__: IBDA_DigitalDemodulator2_Vtbl,
    pub SetSignalTimeouts: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const BDA_SIGNAL_TIMEOUTS) -> ::windows_core::HRESULT,
    pub SignalTimeouts: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut BDA_SIGNAL_TIMEOUTS) -> ::windows_core::HRESULT,
    pub SetPLPNumber: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const u32) -> ::windows_core::HRESULT,
    pub PLPNumber: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_DiseqCommand, IBDA_DiseqCommand_Vtbl, 0xf84e2ab0_3c6b_45e3_a0fc_8669d4b81f11);
::windows_core::imp::interface_hierarchy!(IBDA_DiseqCommand, ::windows_core::IUnknown);
impl IBDA_DiseqCommand {
    pub unsafe fn SetEnableDiseqCommands<P0>(&self, benable: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetEnableDiseqCommands)(::windows_core::Interface::as_raw(self), benable.into_param().abi()).ok()
    }
    pub unsafe fn SetDiseqLNBSource(&self, ullnbsource: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDiseqLNBSource)(::windows_core::Interface::as_raw(self), ullnbsource).ok()
    }
    pub unsafe fn SetDiseqUseToneBurst<P0>(&self, busetoneburst: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetDiseqUseToneBurst)(::windows_core::Interface::as_raw(self), busetoneburst.into_param().abi()).ok()
    }
    pub unsafe fn SetDiseqRepeats(&self, ulrepeats: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDiseqRepeats)(::windows_core::Interface::as_raw(self), ulrepeats).ok()
    }
    pub unsafe fn put_DiseqSendCommand(&self, ulrequestid: u32, pbcommand: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_DiseqSendCommand)(::windows_core::Interface::as_raw(self), ulrequestid, pbcommand.len().try_into().unwrap(), ::core::mem::transmute(pbcommand.as_ptr())).ok()
    }
    pub unsafe fn get_DiseqResponse(&self, ulrequestid: u32, pulcbresponselen: *mut u32, pbresponse: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DiseqResponse)(::windows_core::Interface::as_raw(self), ulrequestid, pulcbresponselen, pbresponse).ok()
    }
}
#[repr(C)]
pub struct IBDA_DiseqCommand_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetEnableDiseqCommands: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    pub SetDiseqLNBSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetDiseqUseToneBurst: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    pub SetDiseqRepeats: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub put_DiseqSendCommand: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *const u8) -> ::windows_core::HRESULT,
    pub get_DiseqResponse: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_EasMessage, IBDA_EasMessage_Vtbl, 0xd806973d_3ebe_46de_8fbb_6358fe784208);
::windows_core::imp::interface_hierarchy!(IBDA_EasMessage, ::windows_core::IUnknown);
impl IBDA_EasMessage {
    pub unsafe fn get_EasMessage(&self, uleventid: u32, ppeasobject: *mut ::core::option::Option<::windows_core::IUnknown>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_EasMessage)(::windows_core::Interface::as_raw(self), uleventid, ::core::mem::transmute(ppeasobject)).ok()
    }
}
#[repr(C)]
pub struct IBDA_EasMessage_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_EasMessage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_Encoder, IBDA_Encoder_Vtbl, 0x3a8bad59_59fe_4559_a0ba_396cfaa98ae3);
::windows_core::imp::interface_hierarchy!(IBDA_Encoder, ::windows_core::IUnknown);
impl IBDA_Encoder {
    pub unsafe fn QueryCapabilities(&self, numaudiofmts: *mut u32, numvideofmts: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryCapabilities)(::windows_core::Interface::as_raw(self), numaudiofmts, numvideofmts).ok()
    }
    pub unsafe fn EnumAudioCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, samplingrate: *mut u32, bitdepth: *mut u32, numchannels: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumAudioCapability)(::windows_core::Interface::as_raw(self), fmtindex, methodid, algorithmtype, samplingrate, bitdepth, numchannels).ok()
    }
    pub unsafe fn EnumVideoCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, verticalsize: *mut u32, horizontalsize: *mut u32, aspectratio: *mut u32, frameratecode: *mut u32, progressivesequence: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumVideoCapability)(::windows_core::Interface::as_raw(self), fmtindex, methodid, algorithmtype, verticalsize, horizontalsize, aspectratio, frameratecode, progressivesequence).ok()
    }
    pub unsafe fn SetParameters(&self, audiobitratemode: u32, audiobitrate: u32, audiomethodid: u32, audioprogram: u32, videobitratemode: u32, videobitrate: u32, videomethodid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParameters)(::windows_core::Interface::as_raw(self), audiobitratemode, audiobitrate, audiomethodid, audioprogram, videobitratemode, videobitrate, videomethodid).ok()
    }
    pub unsafe fn GetState(&self, audiobitratemax: *mut u32, audiobitratemin: *mut u32, audiobitratemode: *mut u32, audiobitratestepping: *mut u32, audiobitrate: *mut u32, audiomethodid: *mut u32, availableaudioprograms: *mut u32, audioprogram: *mut u32, videobitratemax: *mut u32, videobitratemin: *mut u32, videobitratemode: *mut u32, videobitrate: *mut u32, videobitratestepping: *mut u32, videomethodid: *mut u32, signalsourceid: *mut u32, signalformat: *mut u64, signallock: *mut super::super::Foundation::BOOL, signallevel: *mut i32, signaltonoiseratio: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), audiobitratemax, audiobitratemin, audiobitratemode, audiobitratestepping, audiobitrate, audiomethodid, availableaudioprograms, audioprogram, videobitratemax, videobitratemin, videobitratemode, videobitrate, videobitratestepping, videomethodid, signalsourceid, signalformat, signallock, signallevel, signaltonoiseratio).ok()
    }
}
#[repr(C)]
pub struct IBDA_Encoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryCapabilities: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub EnumAudioCapability: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub EnumVideoCapability: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub SetParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, u32, u32, u32, u32) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u64, *mut super::super::Foundation::BOOL, *mut i32, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_EthernetFilter, IBDA_EthernetFilter_Vtbl, 0x71985f43_1ca1_11d3_9cc8_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_EthernetFilter, ::windows_core::IUnknown);
impl IBDA_EthernetFilter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastListSize)(::windows_core::Interface::as_raw(self), pulcbaddresses).ok()
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastList)(::windows_core::Interface::as_raw(self), paddresslist.len().try_into().unwrap(), ::core::mem::transmute(paddresslist.as_ptr())).ok()
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, paddresslist).ok()
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastMode)(::windows_core::Interface::as_raw(self), ulmodemask).ok()
    }
    pub unsafe fn GetMulticastMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMulticastMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBDA_EthernetFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_EventingService, IBDA_EventingService_Vtbl, 0x207c413f_00dc_4c61_bad6_6fee1ff07064);
::windows_core::imp::interface_hierarchy!(IBDA_EventingService, ::windows_core::IUnknown);
impl IBDA_EventingService {
    pub unsafe fn CompleteEvent(&self, uleventid: u32, uleventresult: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CompleteEvent)(::windows_core::Interface::as_raw(self), uleventid, uleventresult).ok()
    }
}
#[repr(C)]
pub struct IBDA_EventingService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CompleteEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_FDC, IBDA_FDC_Vtbl, 0x138adc7e_58ae_437f_b0b4_c9fe19d5b4ac);
::windows_core::imp::interface_hierarchy!(IBDA_FDC, ::windows_core::IUnknown);
impl IBDA_FDC {
    pub unsafe fn GetStatus(&self, currentbitrate: *mut u32, carrierlock: *mut super::super::Foundation::BOOL, currentfrequency: *mut u32, currentspectruminversion: *mut super::super::Foundation::BOOL, currentpidlist: *mut ::windows_core::BSTR, currenttidlist: *mut ::windows_core::BSTR, overflow: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), currentbitrate, carrierlock, currentfrequency, currentspectruminversion, ::core::mem::transmute(currentpidlist), ::core::mem::transmute(currenttidlist), overflow).ok()
    }
    pub unsafe fn RequestTables<P0>(&self, tableids: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RequestTables)(::windows_core::Interface::as_raw(self), tableids.into_param().abi()).ok()
    }
    pub unsafe fn AddPid<P0>(&self, pidstoadd: P0) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddPid)(::windows_core::Interface::as_raw(self), pidstoadd.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn RemovePid<P0>(&self, pidstoremove: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RemovePid)(::windows_core::Interface::as_raw(self), pidstoremove.into_param().abi()).ok()
    }
    pub unsafe fn AddTid<P0>(&self, tidstoadd: P0) -> ::windows_core::Result<::windows_core::BSTR>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddTid)(::windows_core::Interface::as_raw(self), tidstoadd.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn RemoveTid<P0>(&self, tidstoremove: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RemoveTid)(::windows_core::Interface::as_raw(self), tidstoremove.into_param().abi()).ok()
    }
    pub unsafe fn GetTableSection(&self, pid: *mut u32, maxbuffersize: u32, actualsize: *mut u32, secbuffer: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTableSection)(::windows_core::Interface::as_raw(self), pid, maxbuffersize, actualsize, secbuffer).ok()
    }
}
#[repr(C)]
pub struct IBDA_FDC_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut super::super::Foundation::BOOL, *mut u32, *mut super::super::Foundation::BOOL, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub RequestTables: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub AddPid: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut u32) -> ::windows_core::HRESULT,
    pub RemovePid: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub AddTid: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub RemoveTid: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetTableSection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut u32, *mut u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_FrequencyFilter, IBDA_FrequencyFilter_Vtbl, 0x71985f47_1ca1_11d3_9cc8_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_FrequencyFilter, ::windows_core::IUnknown);
impl IBDA_FrequencyFilter {
    pub unsafe fn SetAutotune(&self, ultransponder: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAutotune)(::windows_core::Interface::as_raw(self), ultransponder).ok()
    }
    pub unsafe fn Autotune(&self, pultransponder: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Autotune)(::windows_core::Interface::as_raw(self), pultransponder).ok()
    }
    pub unsafe fn SetFrequency(&self, ulfrequency: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFrequency)(::windows_core::Interface::as_raw(self), ulfrequency).ok()
    }
    pub unsafe fn Frequency(&self, pulfrequency: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Frequency)(::windows_core::Interface::as_raw(self), pulfrequency).ok()
    }
    pub unsafe fn SetPolarity(&self, polarity: Polarisation) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPolarity)(::windows_core::Interface::as_raw(self), polarity).ok()
    }
    pub unsafe fn Polarity(&self, ppolarity: *mut Polarisation) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Polarity)(::windows_core::Interface::as_raw(self), ppolarity).ok()
    }
    pub unsafe fn SetRange(&self, ulrange: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRange)(::windows_core::Interface::as_raw(self), ulrange).ok()
    }
    pub unsafe fn Range(&self, pulrange: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Range)(::windows_core::Interface::as_raw(self), pulrange).ok()
    }
    pub unsafe fn SetBandwidth(&self, ulbandwidth: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBandwidth)(::windows_core::Interface::as_raw(self), ulbandwidth).ok()
    }
    pub unsafe fn Bandwidth(&self, pulbandwidth: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Bandwidth)(::windows_core::Interface::as_raw(self), pulbandwidth).ok()
    }
    pub unsafe fn SetFrequencyMultiplier(&self, ulmultiplier: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFrequencyMultiplier)(::windows_core::Interface::as_raw(self), ulmultiplier).ok()
    }
    pub unsafe fn FrequencyMultiplier(&self, pulmultiplier: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FrequencyMultiplier)(::windows_core::Interface::as_raw(self), pulmultiplier).ok()
    }
}
#[repr(C)]
pub struct IBDA_FrequencyFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetAutotune: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Autotune: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Frequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetPolarity: unsafe extern "system" fn(*mut ::core::ffi::c_void, Polarisation) -> ::windows_core::HRESULT,
    pub Polarity: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut Polarisation) -> ::windows_core::HRESULT,
    pub SetRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Range: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetBandwidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Bandwidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetFrequencyMultiplier: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub FrequencyMultiplier: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_GuideDataDeliveryService, IBDA_GuideDataDeliveryService_Vtbl, 0xc0afcb73_23e7_4bc6_bafa_fdc167b4719f);
::windows_core::imp::interface_hierarchy!(IBDA_GuideDataDeliveryService, ::windows_core::IUnknown);
impl IBDA_GuideDataDeliveryService {
    pub unsafe fn GetGuideDataType(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetGuideDataType)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetGuideData(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8, pulguidedatapercentageprogress: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetGuideData)(::windows_core::Interface::as_raw(self), pulcbbufferlen, pbbuffer, pulguidedatapercentageprogress).ok()
    }
    pub unsafe fn RequestGuideDataUpdate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RequestGuideDataUpdate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetTuneXmlFromServiceIdx(&self, ul64serviceidx: u64) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTuneXmlFromServiceIdx)(::windows_core::Interface::as_raw(self), ul64serviceidx, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetServices(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetServices)(::windows_core::Interface::as_raw(self), pulcbbufferlen, pbbuffer).ok()
    }
    pub unsafe fn GetServiceInfoFromTuneXml<P0>(&self, bstrtunexml: P0) -> ::windows_core::Result<::windows_core::BSTR>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetServiceInfoFromTuneXml)(::windows_core::Interface::as_raw(self), bstrtunexml.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IBDA_GuideDataDeliveryService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetGuideDataType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetGuideData: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8, *mut u32) -> ::windows_core::HRESULT,
    pub RequestGuideDataUpdate: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetTuneXmlFromServiceIdx: unsafe extern "system" fn(*mut ::core::ffi::c_void, u64, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetServices: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub GetServiceInfoFromTuneXml: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_IPSinkControl, IBDA_IPSinkControl_Vtbl, 0x3f4dc8e2_4050_11d3_8f4b_00c04f7971e2);
::windows_core::imp::interface_hierarchy!(IBDA_IPSinkControl, ::windows_core::IUnknown);
impl IBDA_IPSinkControl {
    pub unsafe fn GetMulticastList(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbsize, pbbuffer).ok()
    }
    pub unsafe fn GetAdapterIPAddress(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAdapterIPAddress)(::windows_core::Interface::as_raw(self), pulcbsize, pbbuffer).ok()
    }
}
#[repr(C)]
pub struct IBDA_IPSinkControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetAdapterIPAddress: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_IPSinkInfo, IBDA_IPSinkInfo_Vtbl, 0xa750108f_492e_4d51_95f7_649b23ff7ad7);
::windows_core::imp::interface_hierarchy!(IBDA_IPSinkInfo, ::windows_core::IUnknown);
impl IBDA_IPSinkInfo {
    pub unsafe fn get_MulticastList(&self, pulcbaddresses: *mut u32, ppbaddresslist: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_MulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, ppbaddresslist).ok()
    }
    pub unsafe fn AdapterIPAddress(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AdapterIPAddress)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AdapterDescription(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AdapterDescription)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IBDA_IPSinkInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_MulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut u8) -> ::windows_core::HRESULT,
    pub AdapterIPAddress: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub AdapterDescription: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_IPV4Filter, IBDA_IPV4Filter_Vtbl, 0x71985f44_1ca1_11d3_9cc8_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_IPV4Filter, ::windows_core::IUnknown);
impl IBDA_IPV4Filter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastListSize)(::windows_core::Interface::as_raw(self), pulcbaddresses).ok()
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastList)(::windows_core::Interface::as_raw(self), paddresslist.len().try_into().unwrap(), ::core::mem::transmute(paddresslist.as_ptr())).ok()
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, paddresslist).ok()
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastMode)(::windows_core::Interface::as_raw(self), ulmodemask).ok()
    }
    pub unsafe fn GetMulticastMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMulticastMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBDA_IPV4Filter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_IPV6Filter, IBDA_IPV6Filter_Vtbl, 0xe1785a74_2a23_4fb3_9245_a8f88017ef33);
::windows_core::imp::interface_hierarchy!(IBDA_IPV6Filter, ::windows_core::IUnknown);
impl IBDA_IPV6Filter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastListSize)(::windows_core::Interface::as_raw(self), pulcbaddresses).ok()
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastList)(::windows_core::Interface::as_raw(self), paddresslist.len().try_into().unwrap(), ::core::mem::transmute(paddresslist.as_ptr())).ok()
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, paddresslist).ok()
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastMode)(::windows_core::Interface::as_raw(self), ulmodemask).ok()
    }
    pub unsafe fn GetMulticastMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMulticastMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBDA_IPV6Filter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_ISDBConditionalAccess, IBDA_ISDBConditionalAccess_Vtbl, 0x5e68c627_16c2_4e6c_b1e2_d00170cdaa0f);
::windows_core::imp::interface_hierarchy!(IBDA_ISDBConditionalAccess, ::windows_core::IUnknown);
impl IBDA_ISDBConditionalAccess {
    pub unsafe fn SetIsdbCasRequest(&self, ulrequestid: u32, pbrequestbuffer: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetIsdbCasRequest)(::windows_core::Interface::as_raw(self), ulrequestid, pbrequestbuffer.len().try_into().unwrap(), ::core::mem::transmute(pbrequestbuffer.as_ptr())).ok()
    }
}
#[repr(C)]
pub struct IBDA_ISDBConditionalAccess_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetIsdbCasRequest: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *const u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_LNBInfo, IBDA_LNBInfo_Vtbl, 0x992cf102_49f9_4719_a664_c4f23e2408f4);
::windows_core::imp::interface_hierarchy!(IBDA_LNBInfo, ::windows_core::IUnknown);
impl IBDA_LNBInfo {
    pub unsafe fn SetLocalOscilatorFrequencyLowBand(&self, ulloflow: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLocalOscilatorFrequencyLowBand)(::windows_core::Interface::as_raw(self), ulloflow).ok()
    }
    pub unsafe fn LocalOscilatorFrequencyLowBand(&self, pulloflow: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LocalOscilatorFrequencyLowBand)(::windows_core::Interface::as_raw(self), pulloflow).ok()
    }
    pub unsafe fn SetLocalOscilatorFrequencyHighBand(&self, ullofhigh: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLocalOscilatorFrequencyHighBand)(::windows_core::Interface::as_raw(self), ullofhigh).ok()
    }
    pub unsafe fn LocalOscilatorFrequencyHighBand(&self, pullofhigh: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LocalOscilatorFrequencyHighBand)(::windows_core::Interface::as_raw(self), pullofhigh).ok()
    }
    pub unsafe fn SetHighLowSwitchFrequency(&self, ulswitchfrequency: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetHighLowSwitchFrequency)(::windows_core::Interface::as_raw(self), ulswitchfrequency).ok()
    }
    pub unsafe fn HighLowSwitchFrequency(&self, pulswitchfrequency: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HighLowSwitchFrequency)(::windows_core::Interface::as_raw(self), pulswitchfrequency).ok()
    }
}
#[repr(C)]
pub struct IBDA_LNBInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetLocalOscilatorFrequencyLowBand: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub LocalOscilatorFrequencyLowBand: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetLocalOscilatorFrequencyHighBand: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub LocalOscilatorFrequencyHighBand: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetHighLowSwitchFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub HighLowSwitchFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_MUX, IBDA_MUX_Vtbl, 0x942aafec_4c05_4c74_b8eb_8706c2a4943f);
::windows_core::imp::interface_hierarchy!(IBDA_MUX, ::windows_core::IUnknown);
impl IBDA_MUX {
    pub unsafe fn SetPidList(&self, pbpidlistbuffer: &[BDA_MUX_PIDLISTITEM]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPidList)(::windows_core::Interface::as_raw(self), pbpidlistbuffer.len().try_into().unwrap(), ::core::mem::transmute(pbpidlistbuffer.as_ptr())).ok()
    }
    pub unsafe fn GetPidList(&self, pulpidlistcount: *mut u32, pbpidlistbuffer: *mut BDA_MUX_PIDLISTITEM) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPidList)(::windows_core::Interface::as_raw(self), pulpidlistcount, pbpidlistbuffer).ok()
    }
}
#[repr(C)]
pub struct IBDA_MUX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetPidList: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const BDA_MUX_PIDLISTITEM) -> ::windows_core::HRESULT,
    pub GetPidList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut BDA_MUX_PIDLISTITEM) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_NameValueService, IBDA_NameValueService_Vtbl, 0x7f0b3150_7b81_4ad4_98e3_7e9097094301);
::windows_core::imp::interface_hierarchy!(IBDA_NameValueService, ::windows_core::IUnknown);
impl IBDA_NameValueService {
    pub unsafe fn GetValueNameByIndex(&self, ulindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetValueNameByIndex)(::windows_core::Interface::as_raw(self), ulindex, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetValue<P0, P1>(&self, bstrname: P0, bstrlanguage: P1) -> ::windows_core::Result<::windows_core::BSTR>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetValue)(::windows_core::Interface::as_raw(self), bstrname.into_param().abi(), bstrlanguage.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetValue<P0, P1, P2>(&self, uldialogrequest: u32, bstrlanguage: P0, bstrname: P1, bstrvalue: P2, ulreserved: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
        P2: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetValue)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), bstrname.into_param().abi(), bstrvalue.into_param().abi(), ulreserved).ok()
    }
}
#[repr(C)]
pub struct IBDA_NameValueService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetValueNameByIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, ::std::mem::MaybeUninit<::windows_core::BSTR>, ::std::mem::MaybeUninit<::windows_core::BSTR>, ::std::mem::MaybeUninit<::windows_core::BSTR>, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_NetworkProvider, IBDA_NetworkProvider_Vtbl, 0xfd501041_8ebe_11ce_8183_00aa00577da2);
::windows_core::imp::interface_hierarchy!(IBDA_NetworkProvider, ::windows_core::IUnknown);
impl IBDA_NetworkProvider {
    pub unsafe fn PutSignalSource(&self, ulsignalsource: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutSignalSource)(::windows_core::Interface::as_raw(self), ulsignalsource).ok()
    }
    pub unsafe fn GetSignalSource(&self, pulsignalsource: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSignalSource)(::windows_core::Interface::as_raw(self), pulsignalsource).ok()
    }
    pub unsafe fn GetNetworkType(&self, pguidnetworktype: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNetworkType)(::windows_core::Interface::as_raw(self), pguidnetworktype).ok()
    }
    pub unsafe fn PutTuningSpace(&self, guidtuningspace: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutTuningSpace)(::windows_core::Interface::as_raw(self), guidtuningspace).ok()
    }
    pub unsafe fn GetTuningSpace(&self, pguidtuingspace: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTuningSpace)(::windows_core::Interface::as_raw(self), pguidtuingspace).ok()
    }
    pub unsafe fn RegisterDeviceFilter<P0>(&self, punkfiltercontrol: P0, ppvregisitrationcontext: *mut u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).RegisterDeviceFilter)(::windows_core::Interface::as_raw(self), punkfiltercontrol.into_param().abi(), ppvregisitrationcontext).ok()
    }
    pub unsafe fn UnRegisterDeviceFilter(&self, pvregistrationcontext: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnRegisterDeviceFilter)(::windows_core::Interface::as_raw(self), pvregistrationcontext).ok()
    }
}
#[repr(C)]
pub struct IBDA_NetworkProvider_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PutSignalSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetSignalSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetNetworkType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub PutTuningSpace: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetTuningSpace: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub RegisterDeviceFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub UnRegisterDeviceFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_NullTransform, IBDA_NullTransform_Vtbl, 0xddf15b0d_bd25_11d2_9ca0_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_NullTransform, ::windows_core::IUnknown);
impl IBDA_NullTransform {
    pub unsafe fn Start(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Start)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IBDA_NullTransform_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Start: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_PinControl, IBDA_PinControl_Vtbl, 0x0ded49d5_a8b7_4d5d_97a1_12b0c195874d);
::windows_core::imp::interface_hierarchy!(IBDA_PinControl, ::windows_core::IUnknown);
impl IBDA_PinControl {
    pub unsafe fn GetPinID(&self, pulpinid: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPinID)(::windows_core::Interface::as_raw(self), pulpinid).ok()
    }
    pub unsafe fn GetPinType(&self, pulpintype: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPinType)(::windows_core::Interface::as_raw(self), pulpintype).ok()
    }
    pub unsafe fn RegistrationContext(&self, pulregistrationctx: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RegistrationContext)(::windows_core::Interface::as_raw(self), pulregistrationctx).ok()
    }
}
#[repr(C)]
pub struct IBDA_PinControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPinID: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetPinType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub RegistrationContext: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_SignalProperties, IBDA_SignalProperties_Vtbl, 0xd2f1644b_b409_11d2_bc69_00a0c9ee9e16);
::windows_core::imp::interface_hierarchy!(IBDA_SignalProperties, ::windows_core::IUnknown);
impl IBDA_SignalProperties {
    pub unsafe fn PutNetworkType(&self, guidnetworktype: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutNetworkType)(::windows_core::Interface::as_raw(self), guidnetworktype).ok()
    }
    pub unsafe fn GetNetworkType(&self, pguidnetworktype: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNetworkType)(::windows_core::Interface::as_raw(self), pguidnetworktype).ok()
    }
    pub unsafe fn PutSignalSource(&self, ulsignalsource: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutSignalSource)(::windows_core::Interface::as_raw(self), ulsignalsource).ok()
    }
    pub unsafe fn GetSignalSource(&self, pulsignalsource: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSignalSource)(::windows_core::Interface::as_raw(self), pulsignalsource).ok()
    }
    pub unsafe fn PutTuningSpace(&self, guidtuningspace: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutTuningSpace)(::windows_core::Interface::as_raw(self), guidtuningspace).ok()
    }
    pub unsafe fn GetTuningSpace(&self, pguidtuingspace: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTuningSpace)(::windows_core::Interface::as_raw(self), pguidtuingspace).ok()
    }
}
#[repr(C)]
pub struct IBDA_SignalProperties_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PutNetworkType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetNetworkType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub PutSignalSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetSignalSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub PutTuningSpace: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetTuningSpace: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_SignalStatistics, IBDA_SignalStatistics_Vtbl, 0x1347d106_cf3a_428a_a5cb_ac0d9a2a4338);
::windows_core::imp::interface_hierarchy!(IBDA_SignalStatistics, ::windows_core::IUnknown);
impl IBDA_SignalStatistics {
    pub unsafe fn SetSignalStrength(&self, ldbstrength: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSignalStrength)(::windows_core::Interface::as_raw(self), ldbstrength).ok()
    }
    pub unsafe fn SignalStrength(&self, pldbstrength: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalStrength)(::windows_core::Interface::as_raw(self), pldbstrength).ok()
    }
    pub unsafe fn SetSignalQuality(&self, lpercentquality: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSignalQuality)(::windows_core::Interface::as_raw(self), lpercentquality).ok()
    }
    pub unsafe fn SignalQuality(&self, plpercentquality: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalQuality)(::windows_core::Interface::as_raw(self), plpercentquality).ok()
    }
    pub unsafe fn SetSignalPresent<P0>(&self, fpresent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetSignalPresent)(::windows_core::Interface::as_raw(self), fpresent.into_param().abi()).ok()
    }
    pub unsafe fn SignalPresent(&self, pfpresent: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalPresent)(::windows_core::Interface::as_raw(self), pfpresent).ok()
    }
    pub unsafe fn SetSignalLocked<P0>(&self, flocked: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetSignalLocked)(::windows_core::Interface::as_raw(self), flocked.into_param().abi()).ok()
    }
    pub unsafe fn SignalLocked(&self, pflocked: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalLocked)(::windows_core::Interface::as_raw(self), pflocked).ok()
    }
    pub unsafe fn SetSampleTime(&self, lmssampletime: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSampleTime)(::windows_core::Interface::as_raw(self), lmssampletime).ok()
    }
    pub unsafe fn SampleTime(&self, plmssampletime: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SampleTime)(::windows_core::Interface::as_raw(self), plmssampletime).ok()
    }
}
#[repr(C)]
pub struct IBDA_SignalStatistics_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetSignalStrength: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SignalStrength: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSignalQuality: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SignalQuality: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSignalPresent: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    pub SignalPresent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u8) -> ::windows_core::HRESULT,
    pub SetSignalLocked: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    pub SignalLocked: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u8) -> ::windows_core::HRESULT,
    pub SetSampleTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SampleTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_Topology, IBDA_Topology_Vtbl, 0x79b56888_7fea_4690_b45d_38fd3c7849be);
::windows_core::imp::interface_hierarchy!(IBDA_Topology, ::windows_core::IUnknown);
impl IBDA_Topology {
    pub unsafe fn GetNodeTypes(&self, pulcnodetypes: *mut u32, rgulnodetypes: &mut [u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNodeTypes)(::windows_core::Interface::as_raw(self), pulcnodetypes, rgulnodetypes.len().try_into().unwrap(), ::core::mem::transmute(rgulnodetypes.as_ptr())).ok()
    }
    pub unsafe fn GetNodeDescriptors(&self, ulcnodedescriptors: *mut u32, rgnodedescriptors: &mut [BDANODE_DESCRIPTOR]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNodeDescriptors)(::windows_core::Interface::as_raw(self), ulcnodedescriptors, rgnodedescriptors.len().try_into().unwrap(), ::core::mem::transmute(rgnodedescriptors.as_ptr())).ok()
    }
    pub unsafe fn GetNodeInterfaces(&self, ulnodetype: u32, pulcinterfaces: *mut u32, rgguidinterfaces: &mut [::windows_core::GUID]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNodeInterfaces)(::windows_core::Interface::as_raw(self), ulnodetype, pulcinterfaces, rgguidinterfaces.len().try_into().unwrap(), ::core::mem::transmute(rgguidinterfaces.as_ptr())).ok()
    }
    pub unsafe fn GetPinTypes(&self, pulcpintypes: *mut u32, rgulpintypes: &mut [u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPinTypes)(::windows_core::Interface::as_raw(self), pulcpintypes, rgulpintypes.len().try_into().unwrap(), ::core::mem::transmute(rgulpintypes.as_ptr())).ok()
    }
    pub unsafe fn GetTemplateConnections(&self, pulcconnections: *mut u32, rgconnections: &mut [BDA_TEMPLATE_CONNECTION]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTemplateConnections)(::windows_core::Interface::as_raw(self), pulcconnections, rgconnections.len().try_into().unwrap(), ::core::mem::transmute(rgconnections.as_ptr())).ok()
    }
    pub unsafe fn CreatePin(&self, ulpintype: u32, pulpinid: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreatePin)(::windows_core::Interface::as_raw(self), ulpintype, pulpinid).ok()
    }
    pub unsafe fn DeletePin(&self, ulpinid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DeletePin)(::windows_core::Interface::as_raw(self), ulpinid).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, ulpinid: u32, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaType)(::windows_core::Interface::as_raw(self), ulpinid, pmediatype).ok()
    }
    pub unsafe fn SetMedium(&self, ulpinid: u32, pmedium: *const REGPINMEDIUM) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMedium)(::windows_core::Interface::as_raw(self), ulpinid, pmedium).ok()
    }
    pub unsafe fn CreateTopology(&self, ulinputpinid: u32, uloutputpinid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreateTopology)(::windows_core::Interface::as_raw(self), ulinputpinid, uloutputpinid).ok()
    }
    pub unsafe fn GetControlNode(&self, ulinputpinid: u32, uloutputpinid: u32, ulnodetype: u32, ppcontrolnode: *mut ::core::option::Option<::windows_core::IUnknown>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetControlNode)(::windows_core::Interface::as_raw(self), ulinputpinid, uloutputpinid, ulnodetype, ::core::mem::transmute(ppcontrolnode)).ok()
    }
}
#[repr(C)]
pub struct IBDA_Topology_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNodeTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetNodeDescriptors: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut BDANODE_DESCRIPTOR) -> ::windows_core::HRESULT,
    pub GetNodeInterfaces: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPinTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetTemplateConnections: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut BDA_TEMPLATE_CONNECTION) -> ::windows_core::HRESULT,
    pub CreatePin: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub DeletePin: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetMediaType: usize,
    pub SetMedium: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const REGPINMEDIUM) -> ::windows_core::HRESULT,
    pub CreateTopology: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
    pub GetControlNode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_TransportStreamInfo, IBDA_TransportStreamInfo_Vtbl, 0x8e882535_5f86_47ab_86cf_c281a72a0549);
::windows_core::imp::interface_hierarchy!(IBDA_TransportStreamInfo, ::windows_core::IUnknown);
impl IBDA_TransportStreamInfo {
    pub unsafe fn PatTableTickCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PatTableTickCount)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IBDA_TransportStreamInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PatTableTickCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_TransportStreamSelector, IBDA_TransportStreamSelector_Vtbl, 0x1dcfafe9_b45e_41b3_bb2a_561eb129ae98);
::windows_core::imp::interface_hierarchy!(IBDA_TransportStreamSelector, ::windows_core::IUnknown);
impl IBDA_TransportStreamSelector {
    pub unsafe fn SetTSID(&self, ustsid: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTSID)(::windows_core::Interface::as_raw(self), ustsid).ok()
    }
    pub unsafe fn GetTSInformation(&self, pultsinformationbufferlen: *mut u32, pbtsinformationbuffer: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTSInformation)(::windows_core::Interface::as_raw(self), pultsinformationbufferlen, pbtsinformationbuffer).ok()
    }
}
#[repr(C)]
pub struct IBDA_TransportStreamSelector_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetTSID: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16) -> ::windows_core::HRESULT,
    pub GetTSInformation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_UserActivityService, IBDA_UserActivityService_Vtbl, 0x53b14189_e478_4b7a_a1ff_506db4b99dfe);
::windows_core::imp::interface_hierarchy!(IBDA_UserActivityService, ::windows_core::IUnknown);
impl IBDA_UserActivityService {
    pub unsafe fn SetCurrentTunerUseReason(&self, dwusereason: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentTunerUseReason)(::windows_core::Interface::as_raw(self), dwusereason).ok()
    }
    pub unsafe fn GetUserActivityInterval(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetUserActivityInterval)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn UserActivityDetected(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UserActivityDetected)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IBDA_UserActivityService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetCurrentTunerUseReason: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetUserActivityInterval: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub UserActivityDetected: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_VoidTransform, IBDA_VoidTransform_Vtbl, 0x71985f46_1ca1_11d3_9cc8_00c04f7971e0);
::windows_core::imp::interface_hierarchy!(IBDA_VoidTransform, ::windows_core::IUnknown);
impl IBDA_VoidTransform {
    pub unsafe fn Start(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Start)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IBDA_VoidTransform_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Start: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_WMDRMSession, IBDA_WMDRMSession_Vtbl, 0x4be6fa3d_07cd_4139_8b80_8c18ba3aec88);
::windows_core::imp::interface_hierarchy!(IBDA_WMDRMSession, ::windows_core::IUnknown);
impl IBDA_WMDRMSession {
    pub unsafe fn GetStatus(&self, maxcapturetoken: *mut u32, maxstreamingpid: *mut u32, maxlicense: *mut u32, minsecuritylevel: *mut u32, revinfosequencenumber: *mut u32, revinfoissuedtime: *mut u64, revinfottl: *mut u32, revlistversion: *mut u32, ulstate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), maxcapturetoken, maxstreamingpid, maxlicense, minsecuritylevel, revinfosequencenumber, revinfoissuedtime, revinfottl, revlistversion, ulstate).ok()
    }
    pub unsafe fn SetRevInfo(&self, pbrevinfo: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRevInfo)(::windows_core::Interface::as_raw(self), pbrevinfo.len().try_into().unwrap(), ::core::mem::transmute(pbrevinfo.as_ptr())).ok()
    }
    pub unsafe fn SetCrl(&self, pbcrllen: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCrl)(::windows_core::Interface::as_raw(self), pbcrllen.len().try_into().unwrap(), ::core::mem::transmute(pbcrllen.as_ptr())).ok()
    }
    pub unsafe fn TransactMessage(&self, pbrequest: &[u8], pulcbresponse: *mut u32, pbresponse: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TransactMessage)(::windows_core::Interface::as_raw(self), pbrequest.len().try_into().unwrap(), ::core::mem::transmute(pbrequest.as_ptr()), pulcbresponse, pbresponse).ok()
    }
    pub unsafe fn GetLicense(&self, uuidkey: *const ::windows_core::GUID, pulpackagelen: *mut u32, pbpackage: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetLicense)(::windows_core::Interface::as_raw(self), uuidkey, pulpackagelen, pbpackage).ok()
    }
    pub unsafe fn ReissueLicense(&self, uuidkey: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReissueLicense)(::windows_core::Interface::as_raw(self), uuidkey).ok()
    }
    pub unsafe fn RenewLicense(&self, pbinxmrlicense: &[u8], pbentitlementtoken: &[u8], puldescramblestatus: *mut u32, puloutxmrlicenselen: *mut u32, pboutxmrlicense: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RenewLicense)(::windows_core::Interface::as_raw(self), pbinxmrlicense.len().try_into().unwrap(), ::core::mem::transmute(pbinxmrlicense.as_ptr()), pbentitlementtoken.len().try_into().unwrap(), ::core::mem::transmute(pbentitlementtoken.as_ptr()), puldescramblestatus, puloutxmrlicenselen, pboutxmrlicense).ok()
    }
    pub unsafe fn GetKeyInfo(&self, pulkeyinfolen: *mut u32, pbkeyinfo: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetKeyInfo)(::windows_core::Interface::as_raw(self), pulkeyinfolen, pbkeyinfo).ok()
    }
}
#[repr(C)]
pub struct IBDA_WMDRMSession_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u64, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub SetRevInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub SetCrl: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub TransactMessage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub GetLicense: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub ReissueLicense: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub RenewLicense: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, u32, *const u8, *mut u32, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub GetKeyInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBDA_WMDRMTuner, IBDA_WMDRMTuner_Vtbl, 0x86d979cf_a8a7_4f94_b5fb_14c0aca68fe6);
::windows_core::imp::interface_hierarchy!(IBDA_WMDRMTuner, ::windows_core::IUnknown);
impl IBDA_WMDRMTuner {
    pub unsafe fn PurchaseEntitlement<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, pbpurchasetoken: &[u8], puldescramblestatus: *mut u32, pulcapturetokenlen: *mut u32, pbcapturetoken: *mut u8) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).PurchaseEntitlement)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), pbpurchasetoken.len().try_into().unwrap(), ::core::mem::transmute(pbpurchasetoken.as_ptr()), puldescramblestatus, pulcapturetokenlen, pbcapturetoken).ok()
    }
    pub unsafe fn CancelCaptureToken(&self, pbcapturetoken: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CancelCaptureToken)(::windows_core::Interface::as_raw(self), pbcapturetoken.len().try_into().unwrap(), ::core::mem::transmute(pbcapturetoken.as_ptr())).ok()
    }
    pub unsafe fn SetPidProtection(&self, ulpid: u32, uuidkey: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPidProtection)(::windows_core::Interface::as_raw(self), ulpid, uuidkey).ok()
    }
    pub unsafe fn GetPidProtection(&self, pulpid: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPidProtection)(::windows_core::Interface::as_raw(self), pulpid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetSyncValue(&self, ulsyncvalue: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSyncValue)(::windows_core::Interface::as_raw(self), ulsyncvalue).ok()
    }
    pub unsafe fn GetStartCodeProfile(&self, pulstartcodeprofilelen: *mut u32, pbstartcodeprofile: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStartCodeProfile)(::windows_core::Interface::as_raw(self), pulstartcodeprofilelen, pbstartcodeprofile).ok()
    }
}
#[repr(C)]
pub struct IBDA_WMDRMTuner_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PurchaseEntitlement: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, ::std::mem::MaybeUninit<::windows_core::BSTR>, u32, *const u8, *mut u32, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub CancelCaptureToken: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
    pub SetPidProtection: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPidProtection: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetSyncValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetStartCodeProfile: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBPCSatelliteTuner, IBPCSatelliteTuner_Vtbl, 0x211a8765_03ac_11d1_8d13_00aa00bd8339);
::windows_core::imp::interface_hierarchy!(IBPCSatelliteTuner, ::windows_core::IUnknown, IAMTuner);
impl IBPCSatelliteTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.put_Channel)(::windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok()
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.get_Channel)(::windows_core::Interface::as_raw(self), plchannel, plvideosubchannel, plaudiosubchannel).ok()
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ChannelMinMax)(::windows_core::Interface::as_raw(self), lchannelmin, lchannelmax).ok()
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetCountryCode)(::windows_core::Interface::as_raw(self), lcountrycode).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTuningSpace)(::windows_core::Interface::as_raw(self), ltuningspace).ok()
    }
    pub unsafe fn TuningSpace(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.TuningSpace)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Logon<P0>(&self, hcurrentuser: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Logon)(::windows_core::Interface::as_raw(self), hcurrentuser.into_param().abi()).ok()
    }
    pub unsafe fn Logout(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Logout)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SignalPresent(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SignalPresent)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<AMTunerModeType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.Mode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAvailableModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetAvailableModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
    pub unsafe fn get_DefaultSubChannelTypes(&self, pldefaultvideotype: *mut i32, pldefaultaudiotype: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DefaultSubChannelTypes)(::windows_core::Interface::as_raw(self), pldefaultvideotype, pldefaultaudiotype).ok()
    }
    pub unsafe fn put_DefaultSubChannelTypes(&self, ldefaultvideotype: i32, ldefaultaudiotype: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_DefaultSubChannelTypes)(::windows_core::Interface::as_raw(self), ldefaultvideotype, ldefaultaudiotype).ok()
    }
    pub unsafe fn IsTapingPermitted(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsTapingPermitted)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IBPCSatelliteTuner_Vtbl {
    pub base__: IAMTuner_Vtbl,
    pub get_DefaultSubChannelTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_DefaultSubChannelTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub IsTapingPermitted: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IBaseFilter, IBaseFilter_Vtbl, 0x56a86895_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBaseFilter, ::windows_core::IUnknown, super::super::System::Com::IPersist, IMediaFilter);
#[cfg(feature = "Win32_System_Com")]
impl IBaseFilter {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn GetState(&self, dwmillisecstimeout: u32) -> ::windows_core::Result<FILTER_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetState)(::windows_core::Interface::as_raw(self), dwmillisecstimeout, &mut result__).map(|| result__)
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn GetSyncSource(&self) -> ::windows_core::Result<super::IReferenceClock> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetSyncSource)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumPins(&self) -> ::windows_core::Result<IEnumPins> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumPins)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn FindPin<P0>(&self, id: P0) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindPin)(::windows_core::Interface::as_raw(self), id.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn QueryFilterInfo(&self, pinfo: *mut FILTER_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryFilterInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
    pub unsafe fn JoinFilterGraph<P0, P1>(&self, pgraph: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IFilterGraph>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).JoinFilterGraph)(::windows_core::Interface::as_raw(self), pgraph.into_param().abi(), pname.into_param().abi()).ok()
    }
    pub unsafe fn QueryVendorInfo(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryVendorInfo)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IBaseFilter_Vtbl {
    pub base__: IMediaFilter_Vtbl,
    pub EnumPins: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub FindPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub QueryFilterInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut FILTER_INFO) -> ::windows_core::HRESULT,
    pub JoinFilterGraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub QueryVendorInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBaseVideoMixer, IBaseVideoMixer_Vtbl, 0x61ded640_e912_11ce_a099_00aa00479a58);
::windows_core::imp::interface_hierarchy!(IBaseVideoMixer, ::windows_core::IUnknown);
impl IBaseVideoMixer {
    pub unsafe fn SetLeadPin(&self, ipin: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLeadPin)(::windows_core::Interface::as_raw(self), ipin).ok()
    }
    pub unsafe fn GetLeadPin(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetLeadPin)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetInputPinCount(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetInputPinCount)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsUsingClock(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsUsingClock)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetUsingClock(&self, bvalue: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetUsingClock)(::windows_core::Interface::as_raw(self), bvalue).ok()
    }
    pub unsafe fn GetClockPeriod(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetClockPeriod)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetClockPeriod(&self, bvalue: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetClockPeriod)(::windows_core::Interface::as_raw(self), bvalue).ok()
    }
}
#[repr(C)]
pub struct IBaseVideoMixer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetLeadPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetLeadPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetInputPinCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub IsUsingClock: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetUsingClock: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetClockPeriod: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetClockPeriod: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IBasicAudio, IBasicAudio_Vtbl, 0x56a868b3_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBasicAudio, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IBasicAudio {
    pub unsafe fn SetVolume(&self, lvolume: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVolume)(::windows_core::Interface::as_raw(self), lvolume).ok()
    }
    pub unsafe fn Volume(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Volume)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBalance(&self, lbalance: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBalance)(::windows_core::Interface::as_raw(self), lbalance).ok()
    }
    pub unsafe fn Balance(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Balance)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IBasicAudio_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SetVolume: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Volume: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetBalance: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Balance: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IBasicVideo, IBasicVideo_Vtbl, 0x56a868b5_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBasicVideo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IBasicVideo {
    pub unsafe fn AvgTimePerFrame(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvgTimePerFrame)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn BitRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BitRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn BitErrorRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BitErrorRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn VideoWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VideoWidth)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn VideoHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VideoHeight)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceLeft(&self, sourceleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceLeft)(::windows_core::Interface::as_raw(self), sourceleft).ok()
    }
    pub unsafe fn SourceLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceLeft)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceWidth(&self, sourcewidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceWidth)(::windows_core::Interface::as_raw(self), sourcewidth).ok()
    }
    pub unsafe fn SourceWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceWidth)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceTop(&self, sourcetop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceTop)(::windows_core::Interface::as_raw(self), sourcetop).ok()
    }
    pub unsafe fn SourceTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceTop)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceHeight(&self, sourceheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceHeight)(::windows_core::Interface::as_raw(self), sourceheight).ok()
    }
    pub unsafe fn SourceHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceHeight)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationLeft(&self, destinationleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationLeft)(::windows_core::Interface::as_raw(self), destinationleft).ok()
    }
    pub unsafe fn DestinationLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationLeft)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationWidth(&self, destinationwidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationWidth)(::windows_core::Interface::as_raw(self), destinationwidth).ok()
    }
    pub unsafe fn DestinationWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationWidth)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationTop(&self, destinationtop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationTop)(::windows_core::Interface::as_raw(self), destinationtop).ok()
    }
    pub unsafe fn DestinationTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationTop)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationHeight(&self, destinationheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationHeight)(::windows_core::Interface::as_raw(self), destinationheight).ok()
    }
    pub unsafe fn DestinationHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationHeight)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourcePosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourcePosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSourcePosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultSourcePosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultSourcePosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDestinationPosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationPosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetDestinationPosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDestinationPosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultDestinationPosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultDestinationPosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetVideoSize(&self, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoSize)(::windows_core::Interface::as_raw(self), pwidth, pheight).ok()
    }
    pub unsafe fn GetVideoPaletteEntries(&self, startindex: i32, entries: i32, pretrieved: *mut i32, ppalette: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoPaletteEntries)(::windows_core::Interface::as_raw(self), startindex, entries, pretrieved, ppalette).ok()
    }
    pub unsafe fn GetCurrentImage(&self, pbuffersize: *mut i32, pdibimage: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentImage)(::windows_core::Interface::as_raw(self), pbuffersize, pdibimage).ok()
    }
    pub unsafe fn IsUsingDefaultSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsUsingDefaultSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn IsUsingDefaultDestination(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsUsingDefaultDestination)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IBasicVideo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub AvgTimePerFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub BitRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub BitErrorRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub VideoWidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub VideoHeight: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceLeft: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SourceLeft: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceWidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SourceWidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceTop: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SourceTop: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceHeight: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SourceHeight: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationLeft: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub DestinationLeft: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationWidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub DestinationWidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationTop: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub DestinationTop: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationHeight: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub DestinationHeight: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSourcePosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32, i32) -> ::windows_core::HRESULT,
    pub GetSourcePosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetDefaultSourcePosition: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetDestinationPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32, i32) -> ::windows_core::HRESULT,
    pub GetDestinationPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetDefaultDestinationPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetVideoPaletteEntries: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetCurrentImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub IsUsingDefaultSource: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub IsUsingDefaultDestination: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IBasicVideo2, IBasicVideo2_Vtbl, 0x329bb360_f6ea_11d1_9038_00a0c9697298);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBasicVideo2, ::windows_core::IUnknown, super::super::System::Com::IDispatch, IBasicVideo);
#[cfg(feature = "Win32_System_Com")]
impl IBasicVideo2 {
    pub unsafe fn AvgTimePerFrame(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AvgTimePerFrame)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn BitRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.BitRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn BitErrorRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.BitErrorRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn VideoWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.VideoWidth)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn VideoHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.VideoHeight)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceLeft(&self, sourceleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceLeft)(::windows_core::Interface::as_raw(self), sourceleft).ok()
    }
    pub unsafe fn SourceLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceLeft)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceWidth(&self, sourcewidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceWidth)(::windows_core::Interface::as_raw(self), sourcewidth).ok()
    }
    pub unsafe fn SourceWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceWidth)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceTop(&self, sourcetop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceTop)(::windows_core::Interface::as_raw(self), sourcetop).ok()
    }
    pub unsafe fn SourceTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceTop)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceHeight(&self, sourceheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceHeight)(::windows_core::Interface::as_raw(self), sourceheight).ok()
    }
    pub unsafe fn SourceHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceHeight)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationLeft(&self, destinationleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationLeft)(::windows_core::Interface::as_raw(self), destinationleft).ok()
    }
    pub unsafe fn DestinationLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationLeft)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationWidth(&self, destinationwidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationWidth)(::windows_core::Interface::as_raw(self), destinationwidth).ok()
    }
    pub unsafe fn DestinationWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationWidth)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationTop(&self, destinationtop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationTop)(::windows_core::Interface::as_raw(self), destinationtop).ok()
    }
    pub unsafe fn DestinationTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationTop)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDestinationHeight(&self, destinationheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationHeight)(::windows_core::Interface::as_raw(self), destinationheight).ok()
    }
    pub unsafe fn DestinationHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationHeight)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourcePosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourcePosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSourcePosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultSourcePosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefaultSourcePosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDestinationPosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationPosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetDestinationPosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetDestinationPosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultDestinationPosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefaultDestinationPosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetVideoSize(&self, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVideoSize)(::windows_core::Interface::as_raw(self), pwidth, pheight).ok()
    }
    pub unsafe fn GetVideoPaletteEntries(&self, startindex: i32, entries: i32, pretrieved: *mut i32, ppalette: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVideoPaletteEntries)(::windows_core::Interface::as_raw(self), startindex, entries, pretrieved, ppalette).ok()
    }
    pub unsafe fn GetCurrentImage(&self, pbuffersize: *mut i32, pdibimage: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetCurrentImage)(::windows_core::Interface::as_raw(self), pbuffersize, pdibimage).ok()
    }
    pub unsafe fn IsUsingDefaultSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsUsingDefaultSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn IsUsingDefaultDestination(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsUsingDefaultDestination)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetPreferredAspectRatio(&self, plaspectx: *mut i32, plaspecty: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPreferredAspectRatio)(::windows_core::Interface::as_raw(self), plaspectx, plaspecty).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IBasicVideo2_Vtbl {
    pub base__: IBasicVideo_Vtbl,
    pub GetPreferredAspectRatio: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBroadcastEvent, IBroadcastEvent_Vtbl, 0x3b21263f_26e8_489d_aac4_924f7efd9511);
::windows_core::imp::interface_hierarchy!(IBroadcastEvent, ::windows_core::IUnknown);
impl IBroadcastEvent {
    pub unsafe fn Fire(&self, eventid: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Fire)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(eventid)).ok()
    }
}
#[repr(C)]
pub struct IBroadcastEvent_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Fire: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBroadcastEventEx, IBroadcastEventEx_Vtbl, 0x3d9e3887_1929_423f_8021_43682de95448);
::windows_core::imp::interface_hierarchy!(IBroadcastEventEx, ::windows_core::IUnknown, IBroadcastEvent);
impl IBroadcastEventEx {
    pub unsafe fn Fire(&self, eventid: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Fire)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(eventid)).ok()
    }
    pub unsafe fn FireEx(&self, eventid: ::windows_core::GUID, param1: u32, param2: u32, param3: u32, param4: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FireEx)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(eventid), param1, param2, param3, param4).ok()
    }
}
#[repr(C)]
pub struct IBroadcastEventEx_Vtbl {
    pub base__: IBroadcastEvent_Vtbl,
    pub FireEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, u32, u32, u32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IBufferingTime, IBufferingTime_Vtbl, 0x1e00486a_78dd_11d2_8dd3_006097c9a2b2);
::windows_core::imp::interface_hierarchy!(IBufferingTime, ::windows_core::IUnknown);
impl IBufferingTime {
    pub unsafe fn GetBufferingTime(&self, pdwmilliseconds: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBufferingTime)(::windows_core::Interface::as_raw(self), pdwmilliseconds).ok()
    }
    pub unsafe fn SetBufferingTime(&self, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBufferingTime)(::windows_core::Interface::as_raw(self), dwmilliseconds).ok()
    }
}
#[repr(C)]
pub struct IBufferingTime_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetBufferingTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetBufferingTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ICCSubStreamFiltering, ICCSubStreamFiltering_Vtbl, 0x4b2bd7ea_8347_467b_8dbf_62f784929cc3);
::windows_core::imp::interface_hierarchy!(ICCSubStreamFiltering, ::windows_core::IUnknown);
impl ICCSubStreamFiltering {
    pub unsafe fn SubstreamTypes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SubstreamTypes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSubstreamTypes(&self, types: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSubstreamTypes)(::windows_core::Interface::as_raw(self), types).ok()
    }
}
#[repr(C)]
pub struct ICCSubStreamFiltering_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SubstreamTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetSubstreamTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ICameraControl, ICameraControl_Vtbl, 0x2ba1785d_4d1b_44ef_85e8_c7f1d3f20184);
::windows_core::imp::interface_hierarchy!(ICameraControl, ::windows_core::IUnknown);
impl ICameraControl {
    pub unsafe fn get_Exposure(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Exposure)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Exposure(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Exposure)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Exposure(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Exposure)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Focus(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Focus)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Focus(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Focus)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Focus(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Focus)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Iris(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Iris)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Iris(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Iris)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Iris(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Iris)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Zoom(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Zoom)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Zoom(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Zoom)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Zoom(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Zoom)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_FocalLengths(&self, plocularfocallength: *mut i32, plobjectivefocallengthmin: *mut i32, plobjectivefocallengthmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_FocalLengths)(::windows_core::Interface::as_raw(self), plocularfocallength, plobjectivefocallengthmin, plobjectivefocallengthmax).ok()
    }
    pub unsafe fn get_Pan(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Pan)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Pan(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Pan)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Pan(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Pan)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Tilt(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Tilt)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Tilt(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Tilt)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Tilt(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Tilt)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PanTilt(&self, ppanvalue: *mut i32, ptiltvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PanTilt)(::windows_core::Interface::as_raw(self), ppanvalue, ptiltvalue, pflags).ok()
    }
    pub unsafe fn put_PanTilt(&self, panvalue: i32, tiltvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PanTilt)(::windows_core::Interface::as_raw(self), panvalue, tiltvalue, flags).ok()
    }
    pub unsafe fn get_Roll(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Roll)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Roll(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Roll)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Roll(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Roll)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ExposureRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ExposureRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ExposureRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ExposureRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_ExposureRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_ExposureRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_FocusRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_FocusRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_FocusRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_FocusRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_FocusRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_FocusRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_IrisRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_IrisRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_IrisRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_IrisRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_IrisRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_IrisRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ZoomRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ZoomRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ZoomRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ZoomRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_ZoomRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_ZoomRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PanRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PanRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_PanRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PanRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn get_TiltRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_TiltRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_TiltRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_TiltRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_TiltRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_TiltRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PanTiltRelative(&self, ppanvalue: *mut i32, ptiltvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PanTiltRelative)(::windows_core::Interface::as_raw(self), ppanvalue, ptiltvalue, pflags).ok()
    }
    pub unsafe fn put_PanTiltRelative(&self, panvalue: i32, tiltvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PanTiltRelative)(::windows_core::Interface::as_raw(self), panvalue, tiltvalue, flags).ok()
    }
    pub unsafe fn getRange_PanRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_PanRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_RollRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_RollRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_RollRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_RollRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_RollRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_RollRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ScanMode(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ScanMode)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ScanMode(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ScanMode)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn get_PrivacyMode(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PrivacyMode)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_PrivacyMode(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PrivacyMode)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
}
#[repr(C)]
pub struct ICameraControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_Exposure: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Exposure: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Exposure: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Focus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Focus: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Focus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Iris: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Iris: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Iris: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Zoom: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Zoom: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Zoom: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_FocalLengths: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Pan: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Pan: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Pan: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Tilt: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Tilt: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Tilt: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_PanTilt: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_PanTilt: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub get_Roll: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Roll: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Roll: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_ExposureRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_ExposureRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_ExposureRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_FocusRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_FocusRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_FocusRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_IrisRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_IrisRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_IrisRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_ZoomRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_ZoomRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_ZoomRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_PanRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_PanRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub get_TiltRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_TiltRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_TiltRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_PanTiltRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_PanTiltRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_PanRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_RollRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_RollRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_RollRelative: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_ScanMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_ScanMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub get_PrivacyMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_PrivacyMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ICaptureGraphBuilder, ICaptureGraphBuilder_Vtbl, 0xbf87b6e0_8c27_11d0_b3f0_00aa003761c5);
::windows_core::imp::interface_hierarchy!(ICaptureGraphBuilder, ::windows_core::IUnknown);
impl ICaptureGraphBuilder {
    pub unsafe fn SetFiltergraph<P0>(&self, pfg: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).SetFiltergraph)(::windows_core::Interface::as_raw(self), pfg.into_param().abi()).ok()
    }
    pub unsafe fn GetFiltergraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFiltergraph)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetOutputFileName<P0>(&self, ptype: *const ::windows_core::GUID, lpstrfile: P0, ppf: *mut ::core::option::Option<IBaseFilter>, ppsink: *mut ::core::option::Option<IFileSinkFilter>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetOutputFileName)(::windows_core::Interface::as_raw(self), ptype, lpstrfile.into_param().abi(), ::core::mem::transmute(ppf), ::core::mem::transmute(ppsink)).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindInterface<P0>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, pf: P0, riid: *const ::windows_core::GUID, ppint: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).FindInterface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), pf.into_param().abi(), riid, ppint).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RenderStream<P0, P1, P2>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, psource: P0, pfcompressor: P1, pfrenderer: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RenderStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), psource.into_param().abi(), pfcompressor.into_param().abi(), pfrenderer.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ControlStream<P0>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, pfilter: P0, pstart: *const i64, pstop: *const i64, wstartcookie: u16, wstopcookie: u16) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).ControlStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), pfilter.into_param().abi(), pstart, pstop, wstartcookie, wstopcookie).ok()
    }
    pub unsafe fn AllocCapFile<P0>(&self, lpstr: P0, dwlsize: u64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).AllocCapFile)(::windows_core::Interface::as_raw(self), lpstr.into_param().abi(), dwlsize).ok()
    }
    pub unsafe fn CopyCaptureFile<P0, P1, P2>(&self, lpwstrold: P0, lpwstrnew: P1, fallowescabort: i32, pcallback: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P2: ::windows_core::IntoParam<IAMCopyCaptureFileProgress>,
    {
        (::windows_core::Interface::vtable(self).CopyCaptureFile)(::windows_core::Interface::as_raw(self), lpwstrold.into_param().abi(), lpwstrnew.into_param().abi(), fallowescabort, pcallback.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct ICaptureGraphBuilder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetFiltergraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFiltergraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetOutputFileName: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetOutputFileName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FindInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindInterface: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RenderStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RenderStream: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ControlStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::core::ffi::c_void, *const i64, *const i64, u16, u16) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ControlStream: usize,
    pub AllocCapFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, u64) -> ::windows_core::HRESULT,
    pub CopyCaptureFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, ::windows_core::PCWSTR, i32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ICaptureGraphBuilder2, ICaptureGraphBuilder2_Vtbl, 0x93e5a4e0_2d50_11d2_abfa_00a0c9c6e38d);
::windows_core::imp::interface_hierarchy!(ICaptureGraphBuilder2, ::windows_core::IUnknown);
impl ICaptureGraphBuilder2 {
    pub unsafe fn SetFiltergraph<P0>(&self, pfg: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).SetFiltergraph)(::windows_core::Interface::as_raw(self), pfg.into_param().abi()).ok()
    }
    pub unsafe fn GetFiltergraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFiltergraph)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetOutputFileName<P0>(&self, ptype: *const ::windows_core::GUID, lpstrfile: P0, ppf: *mut ::core::option::Option<IBaseFilter>, ppsink: ::core::option::Option<*mut ::core::option::Option<IFileSinkFilter>>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetOutputFileName)(::windows_core::Interface::as_raw(self), ptype, lpstrfile.into_param().abi(), ::core::mem::transmute(ppf), ::core::mem::transmute(ppsink.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindInterface<P0>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, ptype: ::core::option::Option<*const ::windows_core::GUID>, pf: P0, riid: *const ::windows_core::GUID, ppint: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).FindInterface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptype.unwrap_or(::std::ptr::null())), pf.into_param().abi(), riid, ppint).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RenderStream<P0, P1, P2>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, ptype: *const ::windows_core::GUID, psource: P0, pfcompressor: P1, pfrenderer: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RenderStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), ptype, psource.into_param().abi(), pfcompressor.into_param().abi(), pfrenderer.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ControlStream<P0>(&self, pcategory: *const ::windows_core::GUID, ptype: *const ::windows_core::GUID, pfilter: P0, pstart: ::core::option::Option<*const i64>, pstop: ::core::option::Option<*const i64>, wstartcookie: u16, wstopcookie: u16) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).ControlStream)(::windows_core::Interface::as_raw(self), pcategory, ptype, pfilter.into_param().abi(), ::core::mem::transmute(pstart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pstop.unwrap_or(::std::ptr::null())), wstartcookie, wstopcookie).ok()
    }
    pub unsafe fn AllocCapFile<P0>(&self, lpstr: P0, dwlsize: u64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).AllocCapFile)(::windows_core::Interface::as_raw(self), lpstr.into_param().abi(), dwlsize).ok()
    }
    pub unsafe fn CopyCaptureFile<P0, P1, P2>(&self, lpwstrold: P0, lpwstrnew: P1, fallowescabort: i32, pcallback: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P2: ::windows_core::IntoParam<IAMCopyCaptureFileProgress>,
    {
        (::windows_core::Interface::vtable(self).CopyCaptureFile)(::windows_core::Interface::as_raw(self), lpwstrold.into_param().abi(), lpwstrnew.into_param().abi(), fallowescabort, pcallback.into_param().abi()).ok()
    }
    pub unsafe fn FindPin<P0, P1>(&self, psource: P0, pindir: PIN_DIRECTION, pcategory: ::core::option::Option<*const ::windows_core::GUID>, ptype: ::core::option::Option<*const ::windows_core::GUID>, funconnected: P1, num: i32) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindPin)(::windows_core::Interface::as_raw(self), psource.into_param().abi(), pindir, ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptype.unwrap_or(::std::ptr::null())), funconnected.into_param().abi(), num, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct ICaptureGraphBuilder2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetFiltergraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFiltergraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetOutputFileName: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetOutputFileName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FindInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const ::windows_core::GUID, *mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindInterface: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RenderStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const ::windows_core::GUID, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RenderStream: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ControlStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const ::windows_core::GUID, *mut ::core::ffi::c_void, *const i64, *const i64, u16, u16) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ControlStream: usize,
    pub AllocCapFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, u64) -> ::windows_core::HRESULT,
    pub CopyCaptureFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, ::windows_core::PCWSTR, i32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub FindPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, PIN_DIRECTION, *const ::windows_core::GUID, *const ::windows_core::GUID, super::super::Foundation::BOOL, i32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IConfigAsfWriter, IConfigAsfWriter_Vtbl, 0x45086030_f7e4_486a_b504_826bb5792a3b);
::windows_core::imp::interface_hierarchy!(IConfigAsfWriter, ::windows_core::IUnknown);
impl IConfigAsfWriter {
    pub unsafe fn ConfigureFilterUsingProfileId(&self, dwprofileid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConfigureFilterUsingProfileId)(::windows_core::Interface::as_raw(self), dwprofileid).ok()
    }
    pub unsafe fn GetCurrentProfileId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentProfileId)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ConfigureFilterUsingProfileGuid(&self, guidprofile: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConfigureFilterUsingProfileGuid)(::windows_core::Interface::as_raw(self), guidprofile).ok()
    }
    pub unsafe fn GetCurrentProfileGuid(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentProfileGuid)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn ConfigureFilterUsingProfile<P0>(&self, pprofile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::IWMProfile>,
    {
        (::windows_core::Interface::vtable(self).ConfigureFilterUsingProfile)(::windows_core::Interface::as_raw(self), pprofile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn GetCurrentProfile(&self) -> ::windows_core::Result<super::WindowsMediaFormat::IWMProfile> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentProfile)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetIndexMode<P0>(&self, bindexfile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetIndexMode)(::windows_core::Interface::as_raw(self), bindexfile.into_param().abi()).ok()
    }
    pub unsafe fn GetIndexMode(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetIndexMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IConfigAsfWriter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub ConfigureFilterUsingProfileId: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetCurrentProfileId: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub ConfigureFilterUsingProfileGuid: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetCurrentProfileGuid: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub ConfigureFilterUsingProfile: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    ConfigureFilterUsingProfile: usize,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub GetCurrentProfile: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    GetCurrentProfile: usize,
    pub SetIndexMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetIndexMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IConfigAsfWriter2, IConfigAsfWriter2_Vtbl, 0x7989ccaa_53f0_44f0_884a_f3b03f6ae066);
::windows_core::imp::interface_hierarchy!(IConfigAsfWriter2, ::windows_core::IUnknown, IConfigAsfWriter);
impl IConfigAsfWriter2 {
    pub unsafe fn ConfigureFilterUsingProfileId(&self, dwprofileid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ConfigureFilterUsingProfileId)(::windows_core::Interface::as_raw(self), dwprofileid).ok()
    }
    pub unsafe fn GetCurrentProfileId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentProfileId)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ConfigureFilterUsingProfileGuid(&self, guidprofile: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ConfigureFilterUsingProfileGuid)(::windows_core::Interface::as_raw(self), guidprofile).ok()
    }
    pub unsafe fn GetCurrentProfileGuid(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentProfileGuid)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn ConfigureFilterUsingProfile<P0>(&self, pprofile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::IWMProfile>,
    {
        (::windows_core::Interface::vtable(self).base__.ConfigureFilterUsingProfile)(::windows_core::Interface::as_raw(self), pprofile.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn GetCurrentProfile(&self) -> ::windows_core::Result<super::WindowsMediaFormat::IWMProfile> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentProfile)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetIndexMode<P0>(&self, bindexfile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetIndexMode)(::windows_core::Interface::as_raw(self), bindexfile.into_param().abi()).ok()
    }
    pub unsafe fn GetIndexMode(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetIndexMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn StreamNumFromPin<P0>(&self, ppin: P0) -> ::windows_core::Result<u16>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).StreamNumFromPin)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn SetParam(&self, dwparam: u32, dwparam1: u32, dwparam2: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParam)(::windows_core::Interface::as_raw(self), dwparam, dwparam1, dwparam2).ok()
    }
    pub unsafe fn GetParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParam)(::windows_core::Interface::as_raw(self), dwparam, pdwparam1, pdwparam2).ok()
    }
    pub unsafe fn ResetMultiPassState(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ResetMultiPassState)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IConfigAsfWriter2_Vtbl {
    pub base__: IConfigAsfWriter_Vtbl,
    pub StreamNumFromPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut u16) -> ::windows_core::HRESULT,
    pub SetParam: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32) -> ::windows_core::HRESULT,
    pub GetParam: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub ResetMultiPassState: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IConfigAviMux, IConfigAviMux_Vtbl, 0x5acd6aa0_f482_11ce_8b67_00aa00a3f1a6);
::windows_core::imp::interface_hierarchy!(IConfigAviMux, ::windows_core::IUnknown);
impl IConfigAviMux {
    pub unsafe fn SetMasterStream(&self, istream: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMasterStream)(::windows_core::Interface::as_raw(self), istream).ok()
    }
    pub unsafe fn GetMasterStream(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMasterStream)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputCompatibilityIndex<P0>(&self, foldindex: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetOutputCompatibilityIndex)(::windows_core::Interface::as_raw(self), foldindex.into_param().abi()).ok()
    }
    pub unsafe fn GetOutputCompatibilityIndex(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOutputCompatibilityIndex)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IConfigAviMux_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetMasterStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetMasterStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetOutputCompatibilityIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetOutputCompatibilityIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IConfigInterleaving, IConfigInterleaving_Vtbl, 0xbee3d220_157b_11d0_bd23_00a0c911ce86);
::windows_core::imp::interface_hierarchy!(IConfigInterleaving, ::windows_core::IUnknown);
impl IConfigInterleaving {
    pub unsafe fn SetMode(&self, mode: InterleavingMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<InterleavingMode> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn put_Interleaving(&self, prtinterleave: *const i64, prtpreroll: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Interleaving)(::windows_core::Interface::as_raw(self), prtinterleave, prtpreroll).ok()
    }
    pub unsafe fn get_Interleaving(&self, prtinterleave: *mut i64, prtpreroll: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Interleaving)(::windows_core::Interface::as_raw(self), prtinterleave, prtpreroll).ok()
    }
}
#[repr(C)]
pub struct IConfigInterleaving_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, InterleavingMode) -> ::windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut InterleavingMode) -> ::windows_core::HRESULT,
    pub put_Interleaving: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
    pub get_Interleaving: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ICreateDevEnum, ICreateDevEnum_Vtbl, 0x29840822_5b84_11d0_bd3b_00a0c911ce86);
::windows_core::imp::interface_hierarchy!(ICreateDevEnum, ::windows_core::IUnknown);
impl ICreateDevEnum {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateClassEnumerator(&self, clsiddeviceclass: *const ::windows_core::GUID, ppenummoniker: *mut ::core::option::Option<super::super::System::Com::IEnumMoniker>, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreateClassEnumerator)(::windows_core::Interface::as_raw(self), clsiddeviceclass, ::core::mem::transmute(ppenummoniker), dwflags).ok()
    }
}
#[repr(C)]
pub struct ICreateDevEnum_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateClassEnumerator: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateClassEnumerator: usize,
}
::windows_core::imp::com_interface!(IDDrawExclModeVideo, IDDrawExclModeVideo_Vtbl, 0x153acc21_d83b_11d1_82bf_00a0c9696c8f);
::windows_core::imp::interface_hierarchy!(IDDrawExclModeVideo, ::windows_core::IUnknown);
impl IDDrawExclModeVideo {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDDrawObject<P0>(&self, pddrawobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw>,
    {
        (::windows_core::Interface::vtable(self).SetDDrawObject)(::windows_core::Interface::as_raw(self), pddrawobject.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDDrawObject(&self, ppddrawobject: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDraw>, pbusingexternal: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDDrawObject)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppddrawobject), pbusingexternal).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDDrawSurface<P0>(&self, pddrawsurface: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface>,
    {
        (::windows_core::Interface::vtable(self).SetDDrawSurface)(::windows_core::Interface::as_raw(self), pddrawsurface.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDDrawSurface(&self, ppddrawsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface>, pbusingexternal: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDDrawSurface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppddrawsurface), pbusingexternal).ok()
    }
    pub unsafe fn SetDrawParameters(&self, prcsource: *const super::super::Foundation::RECT, prctarget: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawParameters)(::windows_core::Interface::as_raw(self), prcsource, prctarget).ok()
    }
    pub unsafe fn GetNativeVideoProps(&self, pdwvideowidth: *mut u32, pdwvideoheight: *mut u32, pdwpictaspectratiox: *mut u32, pdwpictaspectratioy: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNativeVideoProps)(::windows_core::Interface::as_raw(self), pdwvideowidth, pdwvideoheight, pdwpictaspectratiox, pdwpictaspectratioy).ok()
    }
    pub unsafe fn SetCallbackInterface<P0>(&self, pcallback: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IDDrawExclModeVideoCallback>,
    {
        (::windows_core::Interface::vtable(self).SetCallbackInterface)(::windows_core::Interface::as_raw(self), pcallback.into_param().abi(), dwflags).ok()
    }
}
#[repr(C)]
pub struct IDDrawExclModeVideo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDDrawObject: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDDrawObject: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDDrawObject: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDDrawObject: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDDrawSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDDrawSurface: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDDrawSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDDrawSurface: usize,
    pub SetDrawParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub GetNativeVideoProps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub SetCallbackInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDDrawExclModeVideoCallback, IDDrawExclModeVideoCallback_Vtbl, 0x913c24a0_20ab_11d2_9038_00a0c9697298);
::windows_core::imp::interface_hierarchy!(IDDrawExclModeVideoCallback, ::windows_core::IUnknown);
impl IDDrawExclModeVideoCallback {
    pub unsafe fn OnUpdateOverlay<P0, P1, P2>(&self, bbefore: P0, dwflags: u32, boldvisible: P1, prcoldsrc: *const super::super::Foundation::RECT, prcolddest: *const super::super::Foundation::RECT, bnewvisible: P2, prcnewsrc: *const super::super::Foundation::RECT, prcnewdest: *const super::super::Foundation::RECT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).OnUpdateOverlay)(::windows_core::Interface::as_raw(self), bbefore.into_param().abi(), dwflags, boldvisible.into_param().abi(), prcoldsrc, prcolddest, bnewvisible.into_param().abi(), prcnewsrc, prcnewdest).ok()
    }
    pub unsafe fn OnUpdateColorKey(&self, pkey: *const COLORKEY, dwcolor: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnUpdateColorKey)(::windows_core::Interface::as_raw(self), pkey, dwcolor).ok()
    }
    pub unsafe fn OnUpdateSize(&self, dwwidth: u32, dwheight: u32, dwarwidth: u32, dwarheight: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnUpdateSize)(::windows_core::Interface::as_raw(self), dwwidth, dwheight, dwarwidth, dwarheight).ok()
    }
}
#[repr(C)]
pub struct IDDrawExclModeVideoCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnUpdateOverlay: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL, u32, super::super::Foundation::BOOL, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT, super::super::Foundation::BOOL, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub OnUpdateColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const COLORKEY, u32) -> ::windows_core::HRESULT,
    pub OnUpdateSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDMOWrapperFilter, IDMOWrapperFilter_Vtbl, 0x52d6f586_9f0f_4824_8fc8_e32ca04930c2);
::windows_core::imp::interface_hierarchy!(IDMOWrapperFilter, ::windows_core::IUnknown);
impl IDMOWrapperFilter {
    pub unsafe fn Init(&self, clsiddmo: *const ::windows_core::GUID, catdmo: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Init)(::windows_core::Interface::as_raw(self), clsiddmo, catdmo).ok()
    }
}
#[repr(C)]
pub struct IDMOWrapperFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Init: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDShowPlugin, IDShowPlugin_Vtbl, 0x4746b7c8_700e_11d1_becc_00c04fb6e937);
::windows_core::imp::interface_hierarchy!(IDShowPlugin, ::windows_core::IUnknown);
impl IDShowPlugin {
    pub unsafe fn URL(&self, purl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).URL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(purl)).ok()
    }
    pub unsafe fn UserAgent(&self, puseragent: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UserAgent)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(puseragent)).ok()
    }
}
#[repr(C)]
pub struct IDShowPlugin_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub URL: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub UserAgent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDVEnc, IDVEnc_Vtbl, 0xd18e17a0_aacb_11d0_afb0_00aa00b67a42);
::windows_core::imp::interface_hierarchy!(IDVEnc, ::windows_core::IUnknown);
impl IDVEnc {
    pub unsafe fn get_IFormatResolution(&self, videoformat: *mut i32, dvformat: *mut i32, resolution: *mut i32, fdvinfo: u8, sdvinfo: *mut DVINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_IFormatResolution)(::windows_core::Interface::as_raw(self), videoformat, dvformat, resolution, fdvinfo, sdvinfo).ok()
    }
    pub unsafe fn put_IFormatResolution(&self, videoformat: i32, dvformat: i32, resolution: i32, fdvinfo: u8, sdvinfo: *const DVINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_IFormatResolution)(::windows_core::Interface::as_raw(self), videoformat, dvformat, resolution, fdvinfo, sdvinfo).ok()
    }
}
#[repr(C)]
pub struct IDVEnc_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_IFormatResolution: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, u8, *mut DVINFO) -> ::windows_core::HRESULT,
    pub put_IFormatResolution: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32, u8, *const DVINFO) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDVRGB219, IDVRGB219_Vtbl, 0x58473a19_2bc8_4663_8012_25f81babddd1);
::windows_core::imp::interface_hierarchy!(IDVRGB219, ::windows_core::IUnknown);
impl IDVRGB219 {
    pub unsafe fn SetRGB219<P0>(&self, bstate: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetRGB219)(::windows_core::Interface::as_raw(self), bstate.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IDVRGB219_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetRGB219: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDVSplitter, IDVSplitter_Vtbl, 0x92a3a302_da7c_4a1f_ba7e_1802bb5d2d02);
::windows_core::imp::interface_hierarchy!(IDVSplitter, ::windows_core::IUnknown);
impl IDVSplitter {
    pub unsafe fn DiscardAlternateVideoFrames(&self, ndiscard: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DiscardAlternateVideoFrames)(::windows_core::Interface::as_raw(self), ndiscard).ok()
    }
}
#[repr(C)]
pub struct IDVSplitter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub DiscardAlternateVideoFrames: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDecimateVideoImage, IDecimateVideoImage_Vtbl, 0x2e5ea3e0_e924_11d2_b6da_00a0c995e8df);
::windows_core::imp::interface_hierarchy!(IDecimateVideoImage, ::windows_core::IUnknown);
impl IDecimateVideoImage {
    pub unsafe fn SetDecimationImageSize(&self, lwidth: i32, lheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecimationImageSize)(::windows_core::Interface::as_raw(self), lwidth, lheight).ok()
    }
    pub unsafe fn ResetDecimationImageSize(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ResetDecimationImageSize)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IDecimateVideoImage_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetDecimationImageSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub ResetDecimationImageSize: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDeferredCommand, IDeferredCommand_Vtbl, 0x56a868b8_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IDeferredCommand, ::windows_core::IUnknown);
impl IDeferredCommand {
    pub unsafe fn Cancel(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Cancel)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Confidence(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Confidence)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Postpone(&self, newtime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Postpone)(::windows_core::Interface::as_raw(self), newtime).ok()
    }
    pub unsafe fn GetHResult(&self) -> ::windows_core::Result<::windows_core::HRESULT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetHResult)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDeferredCommand_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Cancel: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Confidence: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Postpone: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub GetHResult: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::HRESULT) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDirectDrawMediaSample, IDirectDrawMediaSample_Vtbl, 0xab6b4afe_f6e4_11d0_900d_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IDirectDrawMediaSample, ::windows_core::IUnknown);
impl IDirectDrawMediaSample {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetSurfaceAndReleaseLock(&self, ppdirectdrawsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface>, prect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurfaceAndReleaseLock)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppdirectdrawsurface), prect).ok()
    }
    pub unsafe fn LockMediaSamplePointer(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LockMediaSamplePointer)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IDirectDrawMediaSample_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetSurfaceAndReleaseLock: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetSurfaceAndReleaseLock: usize,
    pub LockMediaSamplePointer: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDirectDrawMediaSampleAllocator, IDirectDrawMediaSampleAllocator_Vtbl, 0xab6b4afc_f6e4_11d0_900d_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IDirectDrawMediaSampleAllocator, ::windows_core::IUnknown);
impl IDirectDrawMediaSampleAllocator {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDirectDraw(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDraw> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectDraw)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IDirectDrawMediaSampleAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDirectDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDirectDraw: usize,
}
::windows_core::imp::com_interface!(IDirectDrawMediaStream, IDirectDrawMediaStream_Vtbl, 0xf4104fce_9a70_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IDirectDrawMediaStream, ::windows_core::IUnknown, IMediaStream);
impl IDirectDrawMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetFormat(&self, pddsdcurrent: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, ppdirectdrawpalette: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawPalette>, pddsddesired: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, pdwflags: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pddsdcurrent, ::core::mem::transmute(ppdirectdrawpalette), pddsddesired, pdwflags).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetFormat<P0>(&self, pddsurfacedesc: *const super::super::Graphics::DirectDraw::DDSURFACEDESC, pdirectdrawpalette: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawPalette>,
    {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), pddsurfacedesc, pdirectdrawpalette.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDirectDraw(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDraw> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectDraw)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDirectDraw<P0>(&self, pdirectdraw: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw>,
    {
        (::windows_core::Interface::vtable(self).SetDirectDraw)(::windows_core::Interface::as_raw(self), pdirectdraw.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn CreateSample<P0>(&self, psurface: P0, prect: *const super::super::Foundation::RECT, dwflags: u32) -> ::windows_core::Result<IDirectDrawStreamSample>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSample)(::windows_core::Interface::as_raw(self), psurface.into_param().abi(), prect, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetTimePerFrame(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTimePerFrame)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDirectDrawMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, *mut *mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Graphics::DirectDraw::DDSURFACEDESC, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetFormat: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDirectDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDirectDraw: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDirectDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDirectDraw: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub CreateSample: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::super::Foundation::RECT, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    CreateSample: usize,
    pub GetTimePerFrame: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDirectDrawStreamSample, IDirectDrawStreamSample_Vtbl, 0xf4104fcf_9a70_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IDirectDrawStreamSample, ::windows_core::IUnknown, IStreamSample);
impl IDirectDrawStreamSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetSurface(&self, ppdirectdrawsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface>, prect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppdirectdrawsurface), prect).ok()
    }
    pub unsafe fn SetRect(&self, prect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRect)(::windows_core::Interface::as_raw(self), prect).ok()
    }
}
#[repr(C)]
pub struct IDirectDrawStreamSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetSurface: usize,
    pub SetRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDirectDrawVideo, IDirectDrawVideo_Vtbl, 0x36d39eb0_dd75_11ce_bf0e_00aa0055595a);
::windows_core::imp::interface_hierarchy!(IDirectDrawVideo, ::windows_core::IUnknown);
impl IDirectDrawVideo {
    pub unsafe fn GetSwitches(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSwitches)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSwitches(&self, switches: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSwitches)(::windows_core::Interface::as_raw(self), switches).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetCaps(&self, pcaps: *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCaps)(::windows_core::Interface::as_raw(self), pcaps).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetEmulatedCaps(&self, pcaps: *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetEmulatedCaps)(::windows_core::Interface::as_raw(self), pcaps).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetSurfaceDesc(&self, psurfacedesc: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurfaceDesc)(::windows_core::Interface::as_raw(self), psurfacedesc).ok()
    }
    pub unsafe fn GetFourCCCodes(&self, pcount: *mut u32, pcodes: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFourCCCodes)(::windows_core::Interface::as_raw(self), pcount, pcodes).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDirectDraw<P0>(&self, pdirectdraw: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw>,
    {
        (::windows_core::Interface::vtable(self).SetDirectDraw)(::windows_core::Interface::as_raw(self), pdirectdraw.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDirectDraw(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDraw> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectDraw)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetSurfaceType(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurfaceType)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDefault(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefault)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UseScanLine(&self, usescanline: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseScanLine)(::windows_core::Interface::as_raw(self), usescanline).ok()
    }
    pub unsafe fn CanUseScanLine(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanUseScanLine)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn UseOverlayStretch(&self, useoverlaystretch: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseOverlayStretch)(::windows_core::Interface::as_raw(self), useoverlaystretch).ok()
    }
    pub unsafe fn CanUseOverlayStretch(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanUseOverlayStretch)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn UseWhenFullScreen(&self, usewhenfullscreen: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseWhenFullScreen)(::windows_core::Interface::as_raw(self), usewhenfullscreen).ok()
    }
    pub unsafe fn WillUseFullScreen(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WillUseFullScreen)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDirectDrawVideo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetSwitches: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetSwitches: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetCaps: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetEmulatedCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetEmulatedCaps: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetSurfaceDesc: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDSURFACEDESC) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetSurfaceDesc: usize,
    pub GetFourCCCodes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDirectDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDirectDraw: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDirectDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDirectDraw: usize,
    pub GetSurfaceType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDefault: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub UseScanLine: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub CanUseScanLine: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub UseOverlayStretch: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub CanUseOverlayStretch: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub UseWhenFullScreen: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub WillUseFullScreen: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDistributorNotify, IDistributorNotify_Vtbl, 0x56a868af_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IDistributorNotify, ::windows_core::IUnknown);
impl IDistributorNotify {
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn NotifyGraphChange(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyGraphChange)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IDistributorNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Stop: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Run: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
    pub SetSyncSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NotifyGraphChange: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDrawVideoImage, IDrawVideoImage_Vtbl, 0x48efb120_ab49_11d2_aed2_00a0c995e8d5);
::windows_core::imp::interface_hierarchy!(IDrawVideoImage, ::windows_core::IUnknown);
impl IDrawVideoImage {
    pub unsafe fn DrawVideoImageBegin(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DrawVideoImageBegin)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DrawVideoImageEnd(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DrawVideoImageEnd)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn DrawVideoImageDraw<P0>(&self, hdc: P0, lprcsrc: *const super::super::Foundation::RECT, lprcdst: *const super::super::Foundation::RECT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Gdi::HDC>,
    {
        (::windows_core::Interface::vtable(self).DrawVideoImageDraw)(::windows_core::Interface::as_raw(self), hdc.into_param().abi(), lprcsrc, lprcdst).ok()
    }
}
#[repr(C)]
pub struct IDrawVideoImage_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub DrawVideoImageBegin: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub DrawVideoImageEnd: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub DrawVideoImageDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Graphics::Gdi::HDC, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    DrawVideoImageDraw: usize,
}
::windows_core::imp::com_interface!(IDvdCmd, IDvdCmd_Vtbl, 0x5a4a97e4_94ee_4a55_9751_74b5643aa27d);
::windows_core::imp::interface_hierarchy!(IDvdCmd, ::windows_core::IUnknown);
impl IDvdCmd {
    pub unsafe fn WaitForStart(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitForStart)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WaitForEnd(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitForEnd)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IDvdCmd_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub WaitForStart: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub WaitForEnd: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDvdControl, IDvdControl_Vtbl, 0xa70efe61_e2a3_11d0_a9be_00aa0061be93);
::windows_core::imp::interface_hierarchy!(IDvdControl, ::windows_core::IUnknown);
impl IDvdControl {
    pub unsafe fn TitlePlay(&self, ultitle: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TitlePlay)(::windows_core::Interface::as_raw(self), ultitle).ok()
    }
    pub unsafe fn ChapterPlay(&self, ultitle: u32, ulchapter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChapterPlay)(::windows_core::Interface::as_raw(self), ultitle, ulchapter).ok()
    }
    pub unsafe fn TimePlay(&self, ultitle: u32, bcdtime: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TimePlay)(::windows_core::Interface::as_raw(self), ultitle, bcdtime).ok()
    }
    pub unsafe fn StopForResume(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StopForResume)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GoUp(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GoUp)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TimeSearch(&self, bcdtime: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TimeSearch)(::windows_core::Interface::as_raw(self), bcdtime).ok()
    }
    pub unsafe fn ChapterSearch(&self, ulchapter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChapterSearch)(::windows_core::Interface::as_raw(self), ulchapter).ok()
    }
    pub unsafe fn PrevPGSearch(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PrevPGSearch)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TopPGSearch(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TopPGSearch)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn NextPGSearch(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NextPGSearch)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ForwardScan(&self, dwspeed: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ForwardScan)(::windows_core::Interface::as_raw(self), dwspeed).ok()
    }
    pub unsafe fn BackwardScan(&self, dwspeed: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BackwardScan)(::windows_core::Interface::as_raw(self), dwspeed).ok()
    }
    pub unsafe fn MenuCall(&self, menuid: DVD_MENU_ID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MenuCall)(::windows_core::Interface::as_raw(self), menuid).ok()
    }
    pub unsafe fn Resume(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Resume)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpperButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UpperButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn LowerButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LowerButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn LeftButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LeftButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn RightButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RightButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ButtonActivate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ButtonActivate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ButtonSelectAndActivate(&self, ulbutton: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ButtonSelectAndActivate)(::windows_core::Interface::as_raw(self), ulbutton).ok()
    }
    pub unsafe fn StillOff(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StillOff)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PauseOn(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PauseOn)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PauseOff(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PauseOff)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn MenuLanguageSelect(&self, language: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MenuLanguageSelect)(::windows_core::Interface::as_raw(self), language).ok()
    }
    pub unsafe fn AudioStreamChange(&self, ulaudio: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AudioStreamChange)(::windows_core::Interface::as_raw(self), ulaudio).ok()
    }
    pub unsafe fn SubpictureStreamChange<P0>(&self, ulsubpicture: u32, bdisplay: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SubpictureStreamChange)(::windows_core::Interface::as_raw(self), ulsubpicture, bdisplay.into_param().abi()).ok()
    }
    pub unsafe fn AngleChange(&self, ulangle: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AngleChange)(::windows_core::Interface::as_raw(self), ulangle).ok()
    }
    pub unsafe fn ParentalLevelSelect(&self, ulparentallevel: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ParentalLevelSelect)(::windows_core::Interface::as_raw(self), ulparentallevel).ok()
    }
    pub unsafe fn ParentalCountrySelect(&self, wcountry: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ParentalCountrySelect)(::windows_core::Interface::as_raw(self), wcountry).ok()
    }
    pub unsafe fn KaraokeAudioPresentationModeChange(&self, ulmode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).KaraokeAudioPresentationModeChange)(::windows_core::Interface::as_raw(self), ulmode).ok()
    }
    pub unsafe fn VideoModePreferrence(&self, ulpreferreddisplaymode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).VideoModePreferrence)(::windows_core::Interface::as_raw(self), ulpreferreddisplaymode).ok()
    }
    pub unsafe fn SetRoot<P0>(&self, pszpath: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetRoot)(::windows_core::Interface::as_raw(self), pszpath.into_param().abi()).ok()
    }
    pub unsafe fn MouseActivate(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MouseActivate)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    pub unsafe fn MouseSelect(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MouseSelect)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    pub unsafe fn ChapterPlayAutoStop(&self, ultitle: u32, ulchapter: u32, ulchapterstoplay: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChapterPlayAutoStop)(::windows_core::Interface::as_raw(self), ultitle, ulchapter, ulchapterstoplay).ok()
    }
}
#[repr(C)]
pub struct IDvdControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub TitlePlay: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub ChapterPlay: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
    pub TimePlay: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
    pub StopForResume: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GoUp: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub TimeSearch: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub ChapterSearch: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub PrevPGSearch: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub TopPGSearch: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NextPGSearch: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ForwardScan: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub BackwardScan: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub MenuCall: unsafe extern "system" fn(*mut ::core::ffi::c_void, DVD_MENU_ID) -> ::windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub UpperButtonSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LowerButtonSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LeftButtonSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RightButtonSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ButtonActivate: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ButtonSelectAndActivate: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub StillOff: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PauseOn: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PauseOff: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub MenuLanguageSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub AudioStreamChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SubpictureStreamChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub AngleChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub ParentalLevelSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub ParentalCountrySelect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u16) -> ::windows_core::HRESULT,
    pub KaraokeAudioPresentationModeChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub VideoModePreferrence: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetRoot: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub MouseActivate: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    pub MouseSelect: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    pub ChapterPlayAutoStop: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDvdControl2, IDvdControl2_Vtbl, 0x33bc7430_eec0_11d2_8201_00a0c9d74842);
::windows_core::imp::interface_hierarchy!(IDvdControl2, ::windows_core::IUnknown);
impl IDvdControl2 {
    pub unsafe fn PlayTitle(&self, ultitle: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayTitle)(::windows_core::Interface::as_raw(self), ultitle, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayChapterInTitle(&self, ultitle: u32, ulchapter: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayChapterInTitle)(::windows_core::Interface::as_raw(self), ultitle, ulchapter, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayAtTimeInTitle(&self, ultitle: u32, pstarttime: *const DVD_HMSF_TIMECODE, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayAtTimeInTitle)(::windows_core::Interface::as_raw(self), ultitle, pstarttime, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReturnFromSubmenu(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ReturnFromSubmenu)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayAtTime(&self, ptime: *const DVD_HMSF_TIMECODE, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayAtTime)(::windows_core::Interface::as_raw(self), ptime, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayChapter(&self, ulchapter: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayChapter)(::windows_core::Interface::as_raw(self), ulchapter, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayPrevChapter(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayPrevChapter)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn ReplayChapter(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ReplayChapter)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayNextChapter(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayNextChapter)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayForwards(&self, dspeed: f64, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayForwards)(::windows_core::Interface::as_raw(self), dspeed, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayBackwards(&self, dspeed: f64, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayBackwards)(::windows_core::Interface::as_raw(self), dspeed, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn ShowMenu(&self, menuid: DVD_MENU_ID, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ShowMenu)(::windows_core::Interface::as_raw(self), menuid, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Resume(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Resume)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SelectRelativeButton(&self, buttondir: DVD_RELATIVE_BUTTON) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectRelativeButton)(::windows_core::Interface::as_raw(self), buttondir).ok()
    }
    pub unsafe fn ActivateButton(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ActivateButton)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SelectButton(&self, ulbutton: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectButton)(::windows_core::Interface::as_raw(self), ulbutton).ok()
    }
    pub unsafe fn SelectAndActivateButton(&self, ulbutton: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectAndActivateButton)(::windows_core::Interface::as_raw(self), ulbutton).ok()
    }
    pub unsafe fn StillOff(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StillOff)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause<P0>(&self, bstate: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self), bstate.into_param().abi()).ok()
    }
    pub unsafe fn SelectAudioStream(&self, ulaudio: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SelectAudioStream)(::windows_core::Interface::as_raw(self), ulaudio, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SelectSubpictureStream(&self, ulsubpicture: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SelectSubpictureStream)(::windows_core::Interface::as_raw(self), ulsubpicture, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetSubpictureState<P0>(&self, bstate: P0, dwflags: u32) -> ::windows_core::Result<IDvdCmd>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetSubpictureState)(::windows_core::Interface::as_raw(self), bstate.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SelectAngle(&self, ulangle: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SelectAngle)(::windows_core::Interface::as_raw(self), ulangle, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SelectParentalLevel(&self, ulparentallevel: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectParentalLevel)(::windows_core::Interface::as_raw(self), ulparentallevel).ok()
    }
    pub unsafe fn SelectParentalCountry(&self, bcountry: &[u8; 2]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectParentalCountry)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(bcountry.as_ptr())).ok()
    }
    pub unsafe fn SelectKaraokeAudioPresentationMode(&self, ulmode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectKaraokeAudioPresentationMode)(::windows_core::Interface::as_raw(self), ulmode).ok()
    }
    pub unsafe fn SelectVideoModePreference(&self, ulpreferreddisplaymode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectVideoModePreference)(::windows_core::Interface::as_raw(self), ulpreferreddisplaymode).ok()
    }
    pub unsafe fn SetDVDDirectory<P0>(&self, pszwpath: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetDVDDirectory)(::windows_core::Interface::as_raw(self), pszwpath.into_param().abi()).ok()
    }
    pub unsafe fn ActivateAtPosition(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ActivateAtPosition)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    pub unsafe fn SelectAtPosition(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectAtPosition)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    pub unsafe fn PlayChaptersAutoStop(&self, ultitle: u32, ulchapter: u32, ulchapterstoplay: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayChaptersAutoStop)(::windows_core::Interface::as_raw(self), ultitle, ulchapter, ulchapterstoplay, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AcceptParentalLevelChange<P0>(&self, baccept: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).AcceptParentalLevelChange)(::windows_core::Interface::as_raw(self), baccept.into_param().abi()).ok()
    }
    pub unsafe fn SetOption<P0>(&self, flag: DVD_OPTION_FLAG, fstate: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetOption)(::windows_core::Interface::as_raw(self), flag, fstate.into_param().abi()).ok()
    }
    pub unsafe fn SetState<P0>(&self, pstate: P0, dwflags: u32) -> ::windows_core::Result<IDvdCmd>
    where
        P0: ::windows_core::IntoParam<IDvdState>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), pstate.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn PlayPeriodInTitleAutoStop(&self, ultitle: u32, pstarttime: *const DVD_HMSF_TIMECODE, pendtime: *const DVD_HMSF_TIMECODE, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayPeriodInTitleAutoStop)(::windows_core::Interface::as_raw(self), ultitle, pstarttime, pendtime, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetGPRM(&self, ulindex: u32, wvalue: u16, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetGPRM)(::windows_core::Interface::as_raw(self), ulindex, wvalue, dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SelectDefaultMenuLanguage(&self, language: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectDefaultMenuLanguage)(::windows_core::Interface::as_raw(self), language).ok()
    }
    pub unsafe fn SelectDefaultAudioLanguage(&self, language: u32, audioextension: DVD_AUDIO_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectDefaultAudioLanguage)(::windows_core::Interface::as_raw(self), language, audioextension).ok()
    }
    pub unsafe fn SelectDefaultSubpictureLanguage(&self, language: u32, subpictureextension: DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectDefaultSubpictureLanguage)(::windows_core::Interface::as_raw(self), language, subpictureextension).ok()
    }
}
#[repr(C)]
pub struct IDvdControl2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PlayTitle: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayChapterInTitle: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayAtTimeInTitle: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const DVD_HMSF_TIMECODE, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReturnFromSubmenu: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayAtTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const DVD_HMSF_TIMECODE, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayChapter: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayPrevChapter: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReplayChapter: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayNextChapter: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayForwards: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayBackwards: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ShowMenu: unsafe extern "system" fn(*mut ::core::ffi::c_void, DVD_MENU_ID, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectRelativeButton: unsafe extern "system" fn(*mut ::core::ffi::c_void, DVD_RELATIVE_BUTTON) -> ::windows_core::HRESULT,
    pub ActivateButton: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectButton: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SelectAndActivateButton: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub StillOff: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SelectAudioStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectSubpictureStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSubpictureState: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectAngle: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectParentalLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SelectParentalCountry: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const u8) -> ::windows_core::HRESULT,
    pub SelectKaraokeAudioPresentationMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SelectVideoModePreference: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetDVDDirectory: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub ActivateAtPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    pub SelectAtPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    pub PlayChaptersAutoStop: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub AcceptParentalLevelChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetOption: unsafe extern "system" fn(*mut ::core::ffi::c_void, DVD_OPTION_FLAG, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayPeriodInTitleAutoStop: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const DVD_HMSF_TIMECODE, *const DVD_HMSF_TIMECODE, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetGPRM: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u16, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectDefaultMenuLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SelectDefaultAudioLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, DVD_AUDIO_LANG_EXT) -> ::windows_core::HRESULT,
    pub SelectDefaultSubpictureLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDvdGraphBuilder, IDvdGraphBuilder_Vtbl, 0xfcc152b6_f372_11d0_8e00_00c04fd7c08b);
::windows_core::imp::interface_hierarchy!(IDvdGraphBuilder, ::windows_core::IUnknown);
impl IDvdGraphBuilder {
    pub unsafe fn GetFiltergraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFiltergraph)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetDvdInterface(&self, riid: *const ::windows_core::GUID, ppvif: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDvdInterface)(::windows_core::Interface::as_raw(self), riid, ppvif).ok()
    }
    pub unsafe fn RenderDvdVideoVolume<P0>(&self, lpcwszpathname: P0, dwflags: u32, pstatus: *mut AM_DVD_RENDERSTATUS) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RenderDvdVideoVolume)(::windows_core::Interface::as_raw(self), lpcwszpathname.into_param().abi(), dwflags, pstatus).ok()
    }
}
#[repr(C)]
pub struct IDvdGraphBuilder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetFiltergraph: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetDvdInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RenderDvdVideoVolume: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, u32, *mut AM_DVD_RENDERSTATUS) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDvdInfo, IDvdInfo_Vtbl, 0xa70efe60_e2a3_11d0_a9be_00aa0061be93);
::windows_core::imp::interface_hierarchy!(IDvdInfo, ::windows_core::IUnknown);
impl IDvdInfo {
    pub unsafe fn GetCurrentDomain(&self) -> ::windows_core::Result<DVD_DOMAIN> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentDomain)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentLocation(&self) -> ::windows_core::Result<DVD_PLAYBACK_LOCATION> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentLocation)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTotalTitleTime(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTotalTitleTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentButton(&self, pulbuttonsavailable: *mut u32, pulcurrentbutton: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentButton)(::windows_core::Interface::as_raw(self), pulbuttonsavailable, pulcurrentbutton).ok()
    }
    pub unsafe fn GetCurrentAngle(&self, pulanglesavailable: *mut u32, pulcurrentangle: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAngle)(::windows_core::Interface::as_raw(self), pulanglesavailable, pulcurrentangle).ok()
    }
    pub unsafe fn GetCurrentAudio(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAudio)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream).ok()
    }
    pub unsafe fn GetCurrentSubpicture(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32, pisdisabled: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentSubpicture)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream, pisdisabled).ok()
    }
    pub unsafe fn GetCurrentUOPS(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentUOPS)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAllSPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllSPRMs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAllGPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllGPRMs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAudioLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAudioLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSubpictureLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSubpictureLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).map(|| result__)
    }
    pub unsafe fn GetTitleAttributes(&self, ultitle: u32, patr: *mut DVD_ATR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTitleAttributes)(::windows_core::Interface::as_raw(self), ultitle, patr).ok()
    }
    pub unsafe fn GetVMGAttributes(&self, patr: *mut DVD_ATR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVMGAttributes)(::windows_core::Interface::as_raw(self), patr).ok()
    }
    pub unsafe fn GetCurrentVideoAttributes(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentVideoAttributes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentAudioAttributes(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentAudioAttributes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentSubpictureAttributes(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentSubpictureAttributes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentVolumeInfo(&self, pulnumofvol: *mut u32, pulthisvolnum: *mut u32, pside: *mut DVD_DISC_SIDE, pulnumoftitles: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentVolumeInfo)(::windows_core::Interface::as_raw(self), pulnumofvol, pulthisvolnum, pside, pulnumoftitles).ok()
    }
    pub unsafe fn GetDVDTextInfo(&self, ptextmanager: &mut [u8], pulactualsize: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextInfo)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptextmanager.as_ptr()), ptextmanager.len().try_into().unwrap(), pulactualsize).ok()
    }
    pub unsafe fn GetPlayerParentalLevel(&self, pulparentallevel: *mut u32, pulcountrycode: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPlayerParentalLevel)(::windows_core::Interface::as_raw(self), pulparentallevel, pulcountrycode).ok()
    }
    pub unsafe fn GetNumberOfChapters(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumberOfChapters)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).map(|| result__)
    }
    pub unsafe fn GetTitleParentalLevels(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTitleParentalLevels)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).map(|| result__)
    }
    pub unsafe fn GetRoot(&self, proot: &mut [u8], pulactualsize: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRoot)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(proot.as_ptr()), proot.len().try_into().unwrap(), pulactualsize).ok()
    }
}
#[repr(C)]
pub struct IDvdInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCurrentDomain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_DOMAIN) -> ::windows_core::HRESULT,
    pub GetCurrentLocation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_PLAYBACK_LOCATION) -> ::windows_core::HRESULT,
    pub GetTotalTitleTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentButton: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAngle: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAudio: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentSubpicture: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetCurrentUOPS: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetAllSPRMs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAllGPRMs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAudioLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetSubpictureLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut DVD_ATR) -> ::windows_core::HRESULT,
    pub GetVMGAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_ATR) -> ::windows_core::HRESULT,
    pub GetCurrentVideoAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetCurrentAudioAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetCurrentSubpictureAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetCurrentVolumeInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut DVD_DISC_SIDE, *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDTextInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u8, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetPlayerParentalLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetNumberOfChapters: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleParentalLevels: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetRoot: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PSTR, u32, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDvdInfo2, IDvdInfo2_Vtbl, 0x34151510_eec0_11d2_8201_00a0c9d74842);
::windows_core::imp::interface_hierarchy!(IDvdInfo2, ::windows_core::IUnknown);
impl IDvdInfo2 {
    pub unsafe fn GetCurrentDomain(&self) -> ::windows_core::Result<DVD_DOMAIN> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentDomain)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentLocation(&self) -> ::windows_core::Result<DVD_PLAYBACK_LOCATION2> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentLocation)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTotalTitleTime(&self, ptotaltime: *mut DVD_HMSF_TIMECODE, ultimecodeflags: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTotalTitleTime)(::windows_core::Interface::as_raw(self), ptotaltime, ultimecodeflags).ok()
    }
    pub unsafe fn GetCurrentButton(&self, pulbuttonsavailable: *mut u32, pulcurrentbutton: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentButton)(::windows_core::Interface::as_raw(self), pulbuttonsavailable, pulcurrentbutton).ok()
    }
    pub unsafe fn GetCurrentAngle(&self, pulanglesavailable: *mut u32, pulcurrentangle: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAngle)(::windows_core::Interface::as_raw(self), pulanglesavailable, pulcurrentangle).ok()
    }
    pub unsafe fn GetCurrentAudio(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAudio)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream).ok()
    }
    pub unsafe fn GetCurrentSubpicture(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32, pbisdisabled: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentSubpicture)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream, pbisdisabled).ok()
    }
    pub unsafe fn GetCurrentUOPS(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentUOPS)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAllSPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllSPRMs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAllGPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllGPRMs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetAudioLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAudioLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSubpictureLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSubpictureLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).map(|| result__)
    }
    pub unsafe fn GetTitleAttributes(&self, ultitle: u32, pmenu: *mut DVD_MenuAttributes, ptitle: *mut DVD_TitleAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTitleAttributes)(::windows_core::Interface::as_raw(self), ultitle, pmenu, ptitle).ok()
    }
    pub unsafe fn GetVMGAttributes(&self, patr: *mut DVD_MenuAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVMGAttributes)(::windows_core::Interface::as_raw(self), patr).ok()
    }
    pub unsafe fn GetCurrentVideoAttributes(&self, patr: *mut DVD_VideoAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentVideoAttributes)(::windows_core::Interface::as_raw(self), patr).ok()
    }
    pub unsafe fn GetAudioAttributes(&self, ulstream: u32, patr: *mut DVD_AudioAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAudioAttributes)(::windows_core::Interface::as_raw(self), ulstream, patr).ok()
    }
    pub unsafe fn GetKaraokeAttributes(&self, ulstream: u32, pattributes: *mut DVD_KaraokeAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetKaraokeAttributes)(::windows_core::Interface::as_raw(self), ulstream, pattributes).ok()
    }
    pub unsafe fn GetSubpictureAttributes(&self, ulstream: u32) -> ::windows_core::Result<DVD_SubpictureAttributes> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSubpictureAttributes)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).map(|| result__)
    }
    pub unsafe fn GetDVDVolumeInfo(&self, pulnumofvolumes: *mut u32, pulvolume: *mut u32, pside: *mut DVD_DISC_SIDE, pulnumoftitles: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDVolumeInfo)(::windows_core::Interface::as_raw(self), pulnumofvolumes, pulvolume, pside, pulnumoftitles).ok()
    }
    pub unsafe fn GetDVDTextNumberOfLanguages(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDVDTextNumberOfLanguages)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDVDTextLanguageInfo(&self, ullangindex: u32, pulnumofstrings: *mut u32, plangcode: *mut u32, pbcharacterset: *mut DVD_TextCharSet) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextLanguageInfo)(::windows_core::Interface::as_raw(self), ullangindex, pulnumofstrings, plangcode, pbcharacterset).ok()
    }
    pub unsafe fn GetDVDTextStringAsNative(&self, ullangindex: u32, ulstringindex: u32, pbbuffer: *mut u8, ulmaxbuffersize: u32, pulactualsize: *mut u32, ptype: *mut DVD_TextStringType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextStringAsNative)(::windows_core::Interface::as_raw(self), ullangindex, ulstringindex, pbbuffer, ulmaxbuffersize, pulactualsize, ptype).ok()
    }
    pub unsafe fn GetDVDTextStringAsUnicode(&self, ullangindex: u32, ulstringindex: u32, pchwbuffer: ::windows_core::PWSTR, ulmaxbuffersize: u32, pulactualsize: *mut u32, ptype: *mut DVD_TextStringType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextStringAsUnicode)(::windows_core::Interface::as_raw(self), ullangindex, ulstringindex, ::core::mem::transmute(pchwbuffer), ulmaxbuffersize, pulactualsize, ptype).ok()
    }
    pub unsafe fn GetPlayerParentalLevel(&self, pulparentallevel: *mut u32, pbcountrycode: &mut [u8; 2]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPlayerParentalLevel)(::windows_core::Interface::as_raw(self), pulparentallevel, ::core::mem::transmute(pbcountrycode.as_ptr())).ok()
    }
    pub unsafe fn GetNumberOfChapters(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumberOfChapters)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).map(|| result__)
    }
    pub unsafe fn GetTitleParentalLevels(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTitleParentalLevels)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).map(|| result__)
    }
    pub unsafe fn GetDVDDirectory(&self, pszwpath: &mut [u16], pulactualsize: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDDirectory)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pszwpath.as_ptr()), pszwpath.len().try_into().unwrap(), pulactualsize).ok()
    }
    pub unsafe fn IsAudioStreamEnabled(&self, ulstreamnum: u32) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsAudioStreamEnabled)(::windows_core::Interface::as_raw(self), ulstreamnum, &mut result__).map(|| result__)
    }
    pub unsafe fn GetDiscID<P0>(&self, pszwpath: P0) -> ::windows_core::Result<u64>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDiscID)(::windows_core::Interface::as_raw(self), pszwpath.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn GetState(&self) -> ::windows_core::Result<IDvdState> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetMenuLanguages(&self, planguages: *mut u32, ulmaxlanguages: u32, pulactuallanguages: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMenuLanguages)(::windows_core::Interface::as_raw(self), planguages, ulmaxlanguages, pulactuallanguages).ok()
    }
    pub unsafe fn GetButtonAtPosition(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetButtonAtPosition)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCmdFromEvent(&self, lparam1: isize) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCmdFromEvent)(::windows_core::Interface::as_raw(self), lparam1, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetDefaultMenuLanguage(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultMenuLanguage)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDefaultAudioLanguage(&self, planguage: *mut u32, paudioextension: *mut DVD_AUDIO_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDefaultAudioLanguage)(::windows_core::Interface::as_raw(self), planguage, paudioextension).ok()
    }
    pub unsafe fn GetDefaultSubpictureLanguage(&self, planguage: *mut u32, psubpictureextension: *mut DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDefaultSubpictureLanguage)(::windows_core::Interface::as_raw(self), planguage, psubpictureextension).ok()
    }
    pub unsafe fn GetDecoderCaps(&self, pcaps: *mut DVD_DECODER_CAPS) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDecoderCaps)(::windows_core::Interface::as_raw(self), pcaps).ok()
    }
    pub unsafe fn GetButtonRect(&self, ulbutton: u32) -> ::windows_core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetButtonRect)(::windows_core::Interface::as_raw(self), ulbutton, &mut result__).map(|| result__)
    }
    pub unsafe fn IsSubpictureStreamEnabled(&self, ulstreamnum: u32) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsSubpictureStreamEnabled)(::windows_core::Interface::as_raw(self), ulstreamnum, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDvdInfo2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCurrentDomain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_DOMAIN) -> ::windows_core::HRESULT,
    pub GetCurrentLocation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_PLAYBACK_LOCATION2) -> ::windows_core::HRESULT,
    pub GetTotalTitleTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_HMSF_TIMECODE, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentButton: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAngle: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAudio: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentSubpicture: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetCurrentUOPS: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetAllSPRMs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAllGPRMs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAudioLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetSubpictureLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut DVD_MenuAttributes, *mut DVD_TitleAttributes) -> ::windows_core::HRESULT,
    pub GetVMGAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_MenuAttributes) -> ::windows_core::HRESULT,
    pub GetCurrentVideoAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_VideoAttributes) -> ::windows_core::HRESULT,
    pub GetAudioAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut DVD_AudioAttributes) -> ::windows_core::HRESULT,
    pub GetKaraokeAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut DVD_KaraokeAttributes) -> ::windows_core::HRESULT,
    pub GetSubpictureAttributes: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut DVD_SubpictureAttributes) -> ::windows_core::HRESULT,
    pub GetDVDVolumeInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut DVD_DISC_SIDE, *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDTextNumberOfLanguages: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDTextLanguageInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut u32, *mut DVD_TextCharSet) -> ::windows_core::HRESULT,
    pub GetDVDTextStringAsNative: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *mut u8, u32, *mut u32, *mut DVD_TextStringType) -> ::windows_core::HRESULT,
    pub GetDVDTextStringAsUnicode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, ::windows_core::PWSTR, u32, *mut u32, *mut DVD_TextStringType) -> ::windows_core::HRESULT,
    pub GetPlayerParentalLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u8) -> ::windows_core::HRESULT,
    pub GetNumberOfChapters: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleParentalLevels: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDDirectory: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PWSTR, u32, *mut u32) -> ::windows_core::HRESULT,
    pub IsAudioStreamEnabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetDiscID: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, *mut u64) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetMenuLanguages: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetButtonAtPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::POINT, *mut u32) -> ::windows_core::HRESULT,
    pub GetCmdFromEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, isize, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetDefaultMenuLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetDefaultAudioLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut DVD_AUDIO_LANG_EXT) -> ::windows_core::HRESULT,
    pub GetDefaultSubpictureLanguage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::HRESULT,
    pub GetDecoderCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut DVD_DECODER_CAPS) -> ::windows_core::HRESULT,
    pub GetButtonRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub IsSubpictureStreamEnabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IDvdState, IDvdState_Vtbl, 0x86303d6d_1c4a_4087_ab42_f711167048ef);
::windows_core::imp::interface_hierarchy!(IDvdState, ::windows_core::IUnknown);
impl IDvdState {
    pub unsafe fn GetDiscID(&self) -> ::windows_core::Result<u64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDiscID)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetParentalLevel(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParentalLevel)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IDvdState_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDiscID: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u64) -> ::windows_core::HRESULT,
    pub GetParentalLevel: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IESEvent, IESEvent_Vtbl, 0x1f0e5357_af43_44e6_8547_654c645145d2);
::windows_core::imp::interface_hierarchy!(IESEvent, ::windows_core::IUnknown);
impl IESEvent {
    pub unsafe fn GetEventId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEventId)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEventType(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEventType)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCompletionStatus(&self, dwresult: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCompletionStatus)(::windows_core::Interface::as_raw(self), dwresult).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetData(&self) -> ::windows_core::Result<*mut super::super::System::Com::SAFEARRAY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetData)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetStringData(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStringData)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IESEvent_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetEventId: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetEventType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetCompletionStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetData: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut super::super::System::Com::SAFEARRAY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetData: usize,
    pub GetStringData: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IESEvents, IESEvents_Vtbl, 0xabd414bf_cfe5_4e5e_af5b_4b4e49c5bfeb);
::windows_core::imp::interface_hierarchy!(IESEvents, ::windows_core::IUnknown);
impl IESEvents {
    pub unsafe fn OnESEventReceived<P0>(&self, guideventtype: ::windows_core::GUID, pesevent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IESEvent>,
    {
        (::windows_core::Interface::vtable(self).OnESEventReceived)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(guideventtype), pesevent.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IESEvents_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnESEventReceived: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEncoderAPI, IEncoderAPI_Vtbl, 0x70423839_6acc_4b23_b079_21dbf08156a5);
::windows_core::imp::interface_hierarchy!(IEncoderAPI, ::windows_core::IUnknown);
impl IEncoderAPI {
    pub unsafe fn IsSupported(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsSupported)(::windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn IsAvailable(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsAvailable)(::windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetParameterRange(&self, api: *const ::windows_core::GUID, valuemin: *mut ::windows_core::VARIANT, valuemax: *mut ::windows_core::VARIANT, steppingdelta: *mut ::windows_core::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParameterRange)(::windows_core::Interface::as_raw(self), api, ::core::mem::transmute(valuemin), ::core::mem::transmute(valuemax), ::core::mem::transmute(steppingdelta)).ok()
    }
    pub unsafe fn GetParameterValues(&self, api: *const ::windows_core::GUID, values: *mut *mut ::windows_core::VARIANT, valuescount: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParameterValues)(::windows_core::Interface::as_raw(self), api, values, valuescount).ok()
    }
    pub unsafe fn GetDefaultValue(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<::windows_core::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultValue)(::windows_core::Interface::as_raw(self), api, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetValue(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<::windows_core::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetValue)(::windows_core::Interface::as_raw(self), api, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetValue(&self, api: *const ::windows_core::GUID, value: *const ::windows_core::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetValue)(::windows_core::Interface::as_raw(self), api, ::core::mem::transmute(value)).ok()
    }
}
#[repr(C)]
pub struct IEncoderAPI_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub IsSupported: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub IsAvailable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetParameterRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>) -> ::windows_core::HRESULT,
    pub GetParameterValues: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::windows_core::VARIANT, *mut u32) -> ::windows_core::HRESULT,
    pub GetDefaultValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>) -> ::windows_core::HRESULT,
    pub GetValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>) -> ::windows_core::HRESULT,
    pub SetValue: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const ::std::mem::MaybeUninit<::windows_core::VARIANT>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEnumFilters, IEnumFilters_Vtbl, 0x56a86893_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IEnumFilters, ::windows_core::IUnknown);
impl IEnumFilters {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, ppfilter: &mut [::core::option::Option<IBaseFilter>], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), ppfilter.len().try_into().unwrap(), ::core::mem::transmute(ppfilter.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cfilters: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cfilters).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumFilters_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEnumMediaTypes, IEnumMediaTypes_Vtbl, 0x89c31040_846b_11ce_97d3_00aa0055595a);
::windows_core::imp::interface_hierarchy!(IEnumMediaTypes, ::windows_core::IUnknown);
impl IEnumMediaTypes {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn Next(&self, ppmediatypes: &mut [*mut super::MediaFoundation::AM_MEDIA_TYPE], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), ppmediatypes.len().try_into().unwrap(), ::core::mem::transmute(ppmediatypes.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cmediatypes: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cmediatypes).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumMediaTypes> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumMediaTypes_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub Next: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEnumPIDMap, IEnumPIDMap_Vtbl, 0xafb6c2a2_2c41_11d3_8a60_0000f81e0e4a);
::windows_core::imp::interface_hierarchy!(IEnumPIDMap, ::windows_core::IUnknown);
impl IEnumPIDMap {
    pub unsafe fn Next(&self, ppidmap: &mut [PID_MAP], pcreceived: *mut u32) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), ppidmap.len().try_into().unwrap(), ::core::mem::transmute(ppidmap.as_ptr()), pcreceived)
    }
    pub unsafe fn Skip(&self, crecords: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), crecords).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumPIDMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumPIDMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut PID_MAP, *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEnumPins, IEnumPins_Vtbl, 0x56a86892_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IEnumPins, ::windows_core::IUnknown);
impl IEnumPins {
    pub unsafe fn Next(&self, pppins: &mut [::core::option::Option<IPin>], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), pppins.len().try_into().unwrap(), ::core::mem::transmute(pppins.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cpins: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cpins).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumPins> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumPins_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEnumRegFilters, IEnumRegFilters_Vtbl, 0x56a868a4_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IEnumRegFilters, ::windows_core::IUnknown);
impl IEnumRegFilters {
    pub unsafe fn Next(&self, apregfilter: &mut [*mut REGFILTER], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), apregfilter.len().try_into().unwrap(), ::core::mem::transmute(apregfilter.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cfilters: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cfilters).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumRegFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumRegFilters_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut REGFILTER, *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IEnumStreamIdMap, IEnumStreamIdMap_Vtbl, 0x945c1566_6202_46fc_96c7_d87f289c6534);
::windows_core::imp::interface_hierarchy!(IEnumStreamIdMap, ::windows_core::IUnknown);
impl IEnumStreamIdMap {
    pub unsafe fn Next(&self, pstreamidmap: &mut [STREAM_ID_MAP], pcreceived: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), pstreamidmap.len().try_into().unwrap(), ::core::mem::transmute(pstreamidmap.as_ptr()), ::core::mem::transmute(pcreceived.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Skip(&self, crecords: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), crecords).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumStreamIdMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IEnumStreamIdMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut STREAM_ID_MAP, *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFileSinkFilter, IFileSinkFilter_Vtbl, 0xa2104830_7c70_11cf_8bce_00aa00a3f1a6);
::windows_core::imp::interface_hierarchy!(IFileSinkFilter, ::windows_core::IUnknown);
impl IFileSinkFilter {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetFileName<P0>(&self, pszfilename: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetFileName)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetCurFile(&self, ppszfilename: *mut ::windows_core::PWSTR, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurFile)(::windows_core::Interface::as_raw(self), ppszfilename, pmt).ok()
    }
}
#[repr(C)]
pub struct IFileSinkFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetFileName: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetFileName: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetCurFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::PWSTR, *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetCurFile: usize,
}
::windows_core::imp::com_interface!(IFileSinkFilter2, IFileSinkFilter2_Vtbl, 0x00855b90_ce1b_11d0_bd4f_00a0c911ce86);
::windows_core::imp::interface_hierarchy!(IFileSinkFilter2, ::windows_core::IUnknown, IFileSinkFilter);
impl IFileSinkFilter2 {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetFileName<P0>(&self, pszfilename: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.SetFileName)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetCurFile(&self, ppszfilename: *mut ::windows_core::PWSTR, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetCurFile)(::windows_core::Interface::as_raw(self), ppszfilename, pmt).ok()
    }
    pub unsafe fn SetMode(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn GetMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFileSinkFilter2_Vtbl {
    pub base__: IFileSinkFilter_Vtbl,
    pub SetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFileSourceFilter, IFileSourceFilter_Vtbl, 0x56a868a6_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IFileSourceFilter, ::windows_core::IUnknown);
impl IFileSourceFilter {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn Load<P0>(&self, pszfilename: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).Load)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetCurFile(&self, ppszfilename: *mut ::windows_core::PWSTR, pmt: ::core::option::Option<*mut super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurFile)(::windows_core::Interface::as_raw(self), ppszfilename, ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
#[repr(C)]
pub struct IFileSourceFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub Load: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    Load: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetCurFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::PWSTR, *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetCurFile: usize,
}
::windows_core::imp::com_interface!(IFilterChain, IFilterChain_Vtbl, 0xdcfbdcf6_0dc2_45f5_9ab2_7c330ea09c29);
::windows_core::imp::interface_hierarchy!(IFilterChain, ::windows_core::IUnknown);
impl IFilterChain {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StartChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).StartChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PauseChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).PauseChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StopChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).StopChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFilterChain_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub StartChain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StartChain: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PauseChain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PauseChain: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub StopChain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StopChain: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveChain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveChain: usize,
}
::windows_core::imp::com_interface!(IFilterGraph, IFilterGraph_Vtbl, 0x56a8689f_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IFilterGraph, ::windows_core::IUnknown);
impl IFilterGraph {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IFilterGraph_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub AddFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveFilter: usize,
    pub EnumFilters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub FindFilterByName: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindFilterByName: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub ConnectDirect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    ConnectDirect: usize,
    pub Reconnect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Disconnect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetDefaultSyncSource: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFilterGraph2, IFilterGraph2_Vtbl, 0x36b73882_c2c8_11cf_8b46_00805f6cef60);
::windows_core::imp::interface_hierarchy!(IFilterGraph2, ::windows_core::IUnknown, IFilterGraph, IGraphBuilder);
impl IFilterGraph2 {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Connect<P0, P1>(&self, ppinout: P0, ppinin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Connect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi()).ok()
    }
    pub unsafe fn Render<P0>(&self, ppinout: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi()).ok()
    }
    pub unsafe fn RenderFile<P0, P1>(&self, lpcwstrfile: P0, lpcwstrplaylist: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.RenderFile)(::windows_core::Interface::as_raw(self), lpcwstrfile.into_param().abi(), lpcwstrplaylist.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0, P1>(&self, lpcwstrfilename: P0, lpcwstrfiltername: P1) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AddSourceFilter)(::windows_core::Interface::as_raw(self), lpcwstrfilename.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetLogFile(&self, hfile: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetLogFile)(::windows_core::Interface::as_raw(self), hfile).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Abort)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShouldOperationContinue(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ShouldOperationContinue)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilterForMoniker<P0, P1, P2>(&self, pmoniker: P0, pctx: P1, lpcwstrfiltername: P2) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IBindCtx>,
        P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddSourceFilterForMoniker)(::windows_core::Interface::as_raw(self), pmoniker.into_param().abi(), pctx.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ReconnectEx<P0>(&self, ppin: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).ReconnectEx)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn RenderEx<P0>(&self, ppinout: P0, dwflags: u32, pvcontext: ::core::option::Option<*const u32>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).RenderEx)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), dwflags, ::core::mem::transmute(pvcontext.unwrap_or(::std::ptr::null()))).ok()
    }
}
#[repr(C)]
pub struct IFilterGraph2_Vtbl {
    pub base__: IGraphBuilder_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub AddSourceFilterForMoniker: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddSourceFilterForMoniker: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub ReconnectEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    ReconnectEx: usize,
    pub RenderEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32, *const u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFilterGraph3, IFilterGraph3_Vtbl, 0xaaf38154_b80b_422f_91e6_b66467509a07);
::windows_core::imp::interface_hierarchy!(IFilterGraph3, ::windows_core::IUnknown, IFilterGraph, IGraphBuilder, IFilterGraph2);
impl IFilterGraph3 {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.base__.EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.base__.FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.base__.SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Connect<P0, P1>(&self, ppinout: P0, ppinin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Connect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi()).ok()
    }
    pub unsafe fn Render<P0>(&self, ppinout: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi()).ok()
    }
    pub unsafe fn RenderFile<P0, P1>(&self, lpcwstrfile: P0, lpcwstrplaylist: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.RenderFile)(::windows_core::Interface::as_raw(self), lpcwstrfile.into_param().abi(), lpcwstrplaylist.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0, P1>(&self, lpcwstrfilename: P0, lpcwstrfiltername: P1) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.AddSourceFilter)(::windows_core::Interface::as_raw(self), lpcwstrfilename.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetLogFile(&self, hfile: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetLogFile)(::windows_core::Interface::as_raw(self), hfile).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Abort)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShouldOperationContinue(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.ShouldOperationContinue)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilterForMoniker<P0, P1, P2>(&self, pmoniker: P0, pctx: P1, lpcwstrfiltername: P2) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IBindCtx>,
        P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AddSourceFilterForMoniker)(::windows_core::Interface::as_raw(self), pmoniker.into_param().abi(), pctx.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ReconnectEx<P0>(&self, ppin: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.ReconnectEx)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn RenderEx<P0>(&self, ppinout: P0, dwflags: u32, pvcontext: ::core::option::Option<*const u32>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.RenderEx)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), dwflags, ::core::mem::transmute(pvcontext.unwrap_or(::std::ptr::null()))).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetSyncSourceEx<P0, P1, P2>(&self, pclockformostoffiltergraph: P0, pclockforfilter: P1, pfilter: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
        P1: ::windows_core::IntoParam<super::IReferenceClock>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).SetSyncSourceEx)(::windows_core::Interface::as_raw(self), pclockformostoffiltergraph.into_param().abi(), pclockforfilter.into_param().abi(), pfilter.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IFilterGraph3_Vtbl {
    pub base__: IFilterGraph2_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SetSyncSourceEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetSyncSourceEx: usize,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IFilterInfo, IFilterInfo_Vtbl, 0x56a868ba_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IFilterInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IFilterInfo {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindPin<P0>(&self, strpinid: P0) -> ::windows_core::Result<super::super::System::Com::IDispatch>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindPin)(::windows_core::Interface::as_raw(self), strpinid.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Name(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Name)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn VendorInfo(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VendorInfo)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Filter(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Filter)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Pins(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Pins)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn IsFileSource(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsFileSource)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Filename(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Filename)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetFilename<P0>(&self, strfilename: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetFilename)(::windows_core::Interface::as_raw(self), strfilename.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IFilterInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub FindPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindPin: usize,
    pub Name: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub VendorInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Filter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Pins: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Pins: usize,
    pub IsFileSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Filename: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetFilename: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFilterMapper, IFilterMapper_Vtbl, 0x56a868a3_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IFilterMapper, ::windows_core::IUnknown);
impl IFilterMapper {
    pub unsafe fn RegisterFilter<P0>(&self, clsid: ::windows_core::GUID, name: P0, dwmerit: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterFilter)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(clsid), name.into_param().abi(), dwmerit).ok()
    }
    pub unsafe fn RegisterFilterInstance<P0>(&self, clsid: ::windows_core::GUID, name: P0) -> ::windows_core::Result<::windows_core::GUID>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RegisterFilterInstance)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(clsid), name.into_param().abi(), &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterPin<P0, P1, P2, P3, P4, P5>(&self, filter: ::windows_core::GUID, name: P0, brendered: P1, boutput: P2, bzero: P3, bmany: P4, connectstofilter: ::windows_core::GUID, connectstopin: P5) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P4: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P5: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterPin)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(filter), name.into_param().abi(), brendered.into_param().abi(), boutput.into_param().abi(), bzero.into_param().abi(), bmany.into_param().abi(), ::core::mem::transmute(connectstofilter), connectstopin.into_param().abi()).ok()
    }
    pub unsafe fn RegisterPinType<P0>(&self, clsfilter: ::windows_core::GUID, strname: P0, clsmajortype: ::windows_core::GUID, clssubtype: ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterPinType)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(clsfilter), strname.into_param().abi(), ::core::mem::transmute(clsmajortype), ::core::mem::transmute(clssubtype)).ok()
    }
    pub unsafe fn UnregisterFilter(&self, filter: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnregisterFilter)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(filter)).ok()
    }
    pub unsafe fn UnregisterFilterInstance(&self, mrid: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnregisterFilterInstance)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(mrid)).ok()
    }
    pub unsafe fn UnregisterPin<P0>(&self, filter: ::windows_core::GUID, name: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).UnregisterPin)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(filter), name.into_param().abi()).ok()
    }
    pub unsafe fn EnumMatchingFilters<P0, P1, P2>(&self, ppenum: *mut ::core::option::Option<IEnumRegFilters>, dwmerit: u32, binputneeded: P0, clsinmaj: ::windows_core::GUID, clsinsub: ::windows_core::GUID, brender: P1, boututneeded: P2, clsoutmaj: ::windows_core::GUID, clsoutsub: ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).EnumMatchingFilters)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppenum), dwmerit, binputneeded.into_param().abi(), ::core::mem::transmute(clsinmaj), ::core::mem::transmute(clsinsub), brender.into_param().abi(), boututneeded.into_param().abi(), ::core::mem::transmute(clsoutmaj), ::core::mem::transmute(clsoutsub)).ok()
    }
}
#[repr(C)]
pub struct IFilterMapper_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RegisterFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, ::windows_core::PCWSTR, u32) -> ::windows_core::HRESULT,
    pub RegisterFilterInstance: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, ::windows_core::PCWSTR, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub RegisterPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, ::windows_core::PCWSTR, super::super::Foundation::BOOL, super::super::Foundation::BOOL, super::super::Foundation::BOOL, super::super::Foundation::BOOL, ::windows_core::GUID, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub RegisterPinType: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, ::windows_core::PCWSTR, ::windows_core::GUID, ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub UnregisterFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub UnregisterFilterInstance: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub UnregisterPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub EnumMatchingFilters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, u32, super::super::Foundation::BOOL, ::windows_core::GUID, ::windows_core::GUID, super::super::Foundation::BOOL, super::super::Foundation::BOOL, ::windows_core::GUID, ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFilterMapper2, IFilterMapper2_Vtbl, 0xb79bb0b0_33c1_11d1_abe1_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IFilterMapper2, ::windows_core::IUnknown);
impl IFilterMapper2 {
    pub unsafe fn CreateCategory<P0>(&self, clsidcategory: *const ::windows_core::GUID, dwcategorymerit: u32, description: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).CreateCategory)(::windows_core::Interface::as_raw(self), clsidcategory, dwcategorymerit, description.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterFilter<P0>(&self, pclsidcategory: *const ::windows_core::GUID, szinstance: P0, filter: *const ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).UnregisterFilter)(::windows_core::Interface::as_raw(self), pclsidcategory, szinstance.into_param().abi(), filter).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RegisterFilter<P0, P1>(&self, clsidfilter: *const ::windows_core::GUID, name: P0, ppmoniker: ::core::option::Option<*mut ::core::option::Option<super::super::System::Com::IMoniker>>, pclsidcategory: *const ::windows_core::GUID, szinstance: P1, prf2: *const REGFILTER2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterFilter)(::windows_core::Interface::as_raw(self), clsidfilter, name.into_param().abi(), ::core::mem::transmute(ppmoniker.unwrap_or(::std::ptr::null_mut())), pclsidcategory, szinstance.into_param().abi(), prf2).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumMatchingFilters<P0, P1, P2, P3>(&self, ppenum: *mut ::core::option::Option<super::super::System::Com::IEnumMoniker>, dwflags: u32, bexactmatch: P0, dwmerit: u32, binputneeded: P1, cinputtypes: u32, pinputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedin: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryin: ::core::option::Option<*const ::windows_core::GUID>, brender: P2, boutputneeded: P3, coutputtypes: u32, poutputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedout: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryout: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).EnumMatchingFilters)(
            ::windows_core::Interface::as_raw(self),
            ::core::mem::transmute(ppenum),
            dwflags,
            bexactmatch.into_param().abi(),
            dwmerit,
            binputneeded.into_param().abi(),
            cinputtypes,
            ::core::mem::transmute(pinputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedin.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryin.unwrap_or(::std::ptr::null())),
            brender.into_param().abi(),
            boutputneeded.into_param().abi(),
            coutputtypes,
            ::core::mem::transmute(poutputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedout.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryout.unwrap_or(::std::ptr::null())),
        )
        .ok()
    }
}
#[repr(C)]
pub struct IFilterMapper2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CreateCategory: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, u32, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub UnregisterFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, ::windows_core::PCWSTR, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub RegisterFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void, *const ::windows_core::GUID, ::windows_core::PCWSTR, *const REGFILTER2) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RegisterFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumMatchingFilters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, u32, super::super::Foundation::BOOL, u32, super::super::Foundation::BOOL, u32, *const ::windows_core::GUID, *const REGPINMEDIUM, *const ::windows_core::GUID, super::super::Foundation::BOOL, super::super::Foundation::BOOL, u32, *const ::windows_core::GUID, *const REGPINMEDIUM, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumMatchingFilters: usize,
}
::windows_core::imp::com_interface!(IFilterMapper3, IFilterMapper3_Vtbl, 0xb79bb0b1_33c1_11d1_abe1_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IFilterMapper3, ::windows_core::IUnknown, IFilterMapper2);
impl IFilterMapper3 {
    pub unsafe fn CreateCategory<P0>(&self, clsidcategory: *const ::windows_core::GUID, dwcategorymerit: u32, description: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.CreateCategory)(::windows_core::Interface::as_raw(self), clsidcategory, dwcategorymerit, description.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterFilter<P0>(&self, pclsidcategory: *const ::windows_core::GUID, szinstance: P0, filter: *const ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.UnregisterFilter)(::windows_core::Interface::as_raw(self), pclsidcategory, szinstance.into_param().abi(), filter).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RegisterFilter<P0, P1>(&self, clsidfilter: *const ::windows_core::GUID, name: P0, ppmoniker: ::core::option::Option<*mut ::core::option::Option<super::super::System::Com::IMoniker>>, pclsidcategory: *const ::windows_core::GUID, szinstance: P1, prf2: *const REGFILTER2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.RegisterFilter)(::windows_core::Interface::as_raw(self), clsidfilter, name.into_param().abi(), ::core::mem::transmute(ppmoniker.unwrap_or(::std::ptr::null_mut())), pclsidcategory, szinstance.into_param().abi(), prf2).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumMatchingFilters<P0, P1, P2, P3>(&self, ppenum: *mut ::core::option::Option<super::super::System::Com::IEnumMoniker>, dwflags: u32, bexactmatch: P0, dwmerit: u32, binputneeded: P1, cinputtypes: u32, pinputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedin: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryin: ::core::option::Option<*const ::windows_core::GUID>, brender: P2, boutputneeded: P3, coutputtypes: u32, poutputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedout: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryout: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.EnumMatchingFilters)(
            ::windows_core::Interface::as_raw(self),
            ::core::mem::transmute(ppenum),
            dwflags,
            bexactmatch.into_param().abi(),
            dwmerit,
            binputneeded.into_param().abi(),
            cinputtypes,
            ::core::mem::transmute(pinputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedin.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryin.unwrap_or(::std::ptr::null())),
            brender.into_param().abi(),
            boutputneeded.into_param().abi(),
            coutputtypes,
            ::core::mem::transmute(poutputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedout.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryout.unwrap_or(::std::ptr::null())),
        )
        .ok()
    }
    pub unsafe fn GetICreateDevEnum(&self) -> ::windows_core::Result<ICreateDevEnum> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetICreateDevEnum)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IFilterMapper3_Vtbl {
    pub base__: IFilterMapper2_Vtbl,
    pub GetICreateDevEnum: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFrequencyMap, IFrequencyMap_Vtbl, 0x06fb45c1_693c_4ea7_b79f_7a6a54d8def2);
::windows_core::imp::interface_hierarchy!(IFrequencyMap, ::windows_core::IUnknown);
impl IFrequencyMap {
    pub unsafe fn get_FrequencyMapping(&self, ulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_FrequencyMapping)(::windows_core::Interface::as_raw(self), ulcount, ppullist).ok()
    }
    pub unsafe fn put_FrequencyMapping(&self, plist: &[u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_FrequencyMapping)(::windows_core::Interface::as_raw(self), plist.len().try_into().unwrap(), ::core::mem::transmute(plist.as_ptr())).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCountryCode(&self, ulcountrycode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCountryCode)(::windows_core::Interface::as_raw(self), ulcountrycode).ok()
    }
    pub unsafe fn get_DefaultFrequencyMapping(&self, ulcountrycode: u32, pulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DefaultFrequencyMapping)(::windows_core::Interface::as_raw(self), ulcountrycode, pulcount, ppullist).ok()
    }
    pub unsafe fn get_CountryCodeList(&self, pulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_CountryCodeList)(::windows_core::Interface::as_raw(self), pulcount, ppullist).ok()
    }
}
#[repr(C)]
pub struct IFrequencyMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_FrequencyMapping: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut u32) -> ::windows_core::HRESULT,
    pub put_FrequencyMapping: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u32) -> ::windows_core::HRESULT,
    pub CountryCode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub get_DefaultFrequencyMapping: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32, *mut *mut u32) -> ::windows_core::HRESULT,
    pub get_CountryCodeList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFullScreenVideo, IFullScreenVideo_Vtbl, 0xdd1d7110_7836_11cf_bf47_00aa0055595a);
::windows_core::imp::interface_hierarchy!(IFullScreenVideo, ::windows_core::IUnknown);
impl IFullScreenVideo {
    pub unsafe fn CountModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CountModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetModeInfo(&self, mode: i32, pwidth: *mut i32, pheight: *mut i32, pdepth: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetModeInfo)(::windows_core::Interface::as_raw(self), mode, pwidth, pheight, pdepth).ok()
    }
    pub unsafe fn GetCurrentMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsModeAvailable(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsModeAvailable)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn IsModeEnabled(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsModeEnabled)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn SetEnabled(&self, mode: i32, benabled: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEnabled)(::windows_core::Interface::as_raw(self), mode, benabled).ok()
    }
    pub unsafe fn GetClipFactor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetClipFactor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetClipFactor(&self, clipfactor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetClipFactor)(::windows_core::Interface::as_raw(self), clipfactor).ok()
    }
    pub unsafe fn SetMessageDrain<P0>(&self, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).SetMessageDrain)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi()).ok()
    }
    pub unsafe fn GetMessageDrain(&self) -> ::windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMessageDrain)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMonitor(&self, monitor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMonitor)(::windows_core::Interface::as_raw(self), monitor).ok()
    }
    pub unsafe fn GetMonitor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMonitor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn HideOnDeactivate(&self, hide: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HideOnDeactivate)(::windows_core::Interface::as_raw(self), hide).ok()
    }
    pub unsafe fn IsHideOnDeactivate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsHideOnDeactivate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetCaption<P0>(&self, strcaption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetCaption)(::windows_core::Interface::as_raw(self), strcaption.into_param().abi()).ok()
    }
    pub unsafe fn GetCaption(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCaption)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetDefault(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefault)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IFullScreenVideo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CountModes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub GetModeInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetCurrentMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub IsModeAvailable: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub IsModeEnabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SetEnabled: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub GetClipFactor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetClipFactor: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SetMessageDrain: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    pub GetMessageDrain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    pub SetMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub HideOnDeactivate: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub IsHideOnDeactivate: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetCaption: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetCaption: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetDefault: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IFullScreenVideoEx, IFullScreenVideoEx_Vtbl, 0x53479470_f1dd_11cf_bc42_00aa00ac74f6);
::windows_core::imp::interface_hierarchy!(IFullScreenVideoEx, ::windows_core::IUnknown, IFullScreenVideo);
impl IFullScreenVideoEx {
    pub unsafe fn CountModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CountModes)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetModeInfo(&self, mode: i32, pwidth: *mut i32, pheight: *mut i32, pdepth: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetModeInfo)(::windows_core::Interface::as_raw(self), mode, pwidth, pheight, pdepth).ok()
    }
    pub unsafe fn GetCurrentMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsModeAvailable(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsModeAvailable)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn IsModeEnabled(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsModeEnabled)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn SetEnabled(&self, mode: i32, benabled: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetEnabled)(::windows_core::Interface::as_raw(self), mode, benabled).ok()
    }
    pub unsafe fn GetClipFactor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetClipFactor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetClipFactor(&self, clipfactor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetClipFactor)(::windows_core::Interface::as_raw(self), clipfactor).ok()
    }
    pub unsafe fn SetMessageDrain<P0>(&self, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).base__.SetMessageDrain)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi()).ok()
    }
    pub unsafe fn GetMessageDrain(&self) -> ::windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMessageDrain)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMonitor(&self, monitor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMonitor)(::windows_core::Interface::as_raw(self), monitor).ok()
    }
    pub unsafe fn GetMonitor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMonitor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn HideOnDeactivate(&self, hide: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.HideOnDeactivate)(::windows_core::Interface::as_raw(self), hide).ok()
    }
    pub unsafe fn IsHideOnDeactivate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsHideOnDeactivate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetCaption<P0>(&self, strcaption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.SetCaption)(::windows_core::Interface::as_raw(self), strcaption.into_param().abi()).ok()
    }
    pub unsafe fn GetCaption(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCaption)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetDefault(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefault)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorTable<P0, P1>(&self, hwnd: P0, haccel: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
        P1: ::windows_core::IntoParam<super::super::UI::WindowsAndMessaging::HACCEL>,
    {
        (::windows_core::Interface::vtable(self).SetAcceleratorTable)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi(), haccel.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn GetAcceleratorTable(&self, phwnd: *mut super::super::Foundation::HWND, phaccel: *mut super::super::UI::WindowsAndMessaging::HACCEL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAcceleratorTable)(::windows_core::Interface::as_raw(self), phwnd, phaccel).ok()
    }
    pub unsafe fn KeepPixelAspectRatio(&self, keepaspect: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).KeepPixelAspectRatio)(::windows_core::Interface::as_raw(self), keepaspect).ok()
    }
    pub unsafe fn IsKeepPixelAspectRatio(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsKeepPixelAspectRatio)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IFullScreenVideoEx_Vtbl {
    pub base__: IFullScreenVideo_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetAcceleratorTable: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND, super::super::UI::WindowsAndMessaging::HACCEL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetAcceleratorTable: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub GetAcceleratorTable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::HWND, *mut super::super::UI::WindowsAndMessaging::HACCEL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    GetAcceleratorTable: usize,
    pub KeepPixelAspectRatio: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub IsKeepPixelAspectRatio: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IGetCapabilitiesKey, IGetCapabilitiesKey_Vtbl, 0xa8809222_07bb_48ea_951c_33158100625b);
::windows_core::imp::interface_hierarchy!(IGetCapabilitiesKey, ::windows_core::IUnknown);
impl IGetCapabilitiesKey {
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn GetCapabilitiesKey(&self) -> ::windows_core::Result<super::super::System::Registry::HKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCapabilitiesKey)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IGetCapabilitiesKey_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Registry")]
    pub GetCapabilitiesKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::System::Registry::HKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    GetCapabilitiesKey: usize,
}
::windows_core::imp::com_interface!(IGraphBuilder, IGraphBuilder_Vtbl, 0x56a868a9_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IGraphBuilder, ::windows_core::IUnknown, IFilterGraph);
impl IGraphBuilder {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).base__.RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Connect<P0, P1>(&self, ppinout: P0, ppinin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Connect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi()).ok()
    }
    pub unsafe fn Render<P0>(&self, ppinout: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi()).ok()
    }
    pub unsafe fn RenderFile<P0, P1>(&self, lpcwstrfile: P0, lpcwstrplaylist: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RenderFile)(::windows_core::Interface::as_raw(self), lpcwstrfile.into_param().abi(), lpcwstrplaylist.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0, P1>(&self, lpcwstrfilename: P0, lpcwstrfiltername: P1) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddSourceFilter)(::windows_core::Interface::as_raw(self), lpcwstrfilename.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetLogFile(&self, hfile: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLogFile)(::windows_core::Interface::as_raw(self), hfile).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Abort)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShouldOperationContinue(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ShouldOperationContinue)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IGraphBuilder_Vtbl {
    pub base__: IFilterGraph_Vtbl,
    pub Connect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Render: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RenderFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddSourceFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddSourceFilter: usize,
    pub SetLogFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    pub Abort: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ShouldOperationContinue: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IGraphConfig, IGraphConfig_Vtbl, 0x03a1eb8e_32bf_4245_8502_114d08a9cb88);
::windows_core::imp::interface_hierarchy!(IGraphConfig, ::windows_core::IUnknown);
impl IGraphConfig {
    #[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com"))]
    pub unsafe fn Reconnect<P0, P1, P2, P3>(&self, poutputpin: P0, pinputpin: P1, pmtfirstconnection: *const super::MediaFoundation::AM_MEDIA_TYPE, pusingfilter: P2, habortevent: P3, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
        P3: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Reconnect)(::windows_core::Interface::as_raw(self), poutputpin.into_param().abi(), pinputpin.into_param().abi(), pmtfirstconnection, pusingfilter.into_param().abi(), habortevent.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn Reconfigure<P0, P1>(&self, pcallback: P0, pvcontext: *const ::core::ffi::c_void, dwflags: u32, habortevent: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphConfigCallback>,
        P1: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Reconfigure)(::windows_core::Interface::as_raw(self), pcallback.into_param().abi(), pvcontext, dwflags, habortevent.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilterToCache<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).AddFilterToCache)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumCacheFilter(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumCacheFilter)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilterFromCache<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveFilterFromCache)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn GetStartTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStartTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn PushThroughData<P0, P1, P2>(&self, poutputpin: P0, pconnection: P1, heventabort: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPinConnection>,
        P2: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).PushThroughData)(::windows_core::Interface::as_raw(self), poutputpin.into_param().abi(), pconnection.into_param().abi(), heventabort.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetFilterFlags<P0>(&self, pfilter: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).SetFilterFlags)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), dwflags).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFilterFlags<P0>(&self, pfilter: P0) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFilterFlags)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilterEx<P0>(&self, pfilter: P0, flags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveFilterEx)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), flags).ok()
    }
}
#[repr(C)]
pub struct IGraphConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com"))]
    pub Reconnect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE, *mut ::core::ffi::c_void, super::super::Foundation::HANDLE, u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com")))]
    Reconnect: usize,
    pub Reconfigure: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const ::core::ffi::c_void, u32, super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddFilterToCache: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddFilterToCache: usize,
    pub EnumCacheFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveFilterFromCache: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveFilterFromCache: usize,
    pub GetStartTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub PushThroughData: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetFilterFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetFilterFlags: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFilterFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFilterFlags: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveFilterEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveFilterEx: usize,
}
::windows_core::imp::com_interface!(IGraphConfigCallback, IGraphConfigCallback_Vtbl, 0xade0fd60_d19d_11d2_abf6_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IGraphConfigCallback, ::windows_core::IUnknown);
impl IGraphConfigCallback {
    pub unsafe fn Reconfigure(&self, pvcontext: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reconfigure)(::windows_core::Interface::as_raw(self), pvcontext, dwflags).ok()
    }
}
#[repr(C)]
pub struct IGraphConfigCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Reconfigure: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IGraphVersion, IGraphVersion_Vtbl, 0x56a868ab_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IGraphVersion, ::windows_core::IUnknown);
impl IGraphVersion {
    pub unsafe fn QueryVersion(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryVersion)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IGraphVersion_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryVersion: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IIPDVDec, IIPDVDec_Vtbl, 0xb8e8bd60_0bfe_11d0_af91_00aa00b67a42);
::windows_core::imp::interface_hierarchy!(IIPDVDec, ::windows_core::IUnknown);
impl IIPDVDec {
    pub unsafe fn IPDisplay(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IPDisplay)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetIPDisplay(&self, displaypix: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetIPDisplay)(::windows_core::Interface::as_raw(self), displaypix).ok()
    }
}
#[repr(C)]
pub struct IIPDVDec_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub IPDisplay: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetIPDisplay: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMPEG2PIDMap, IMPEG2PIDMap_Vtbl, 0xafb6c2a1_2c41_11d3_8a60_0000f81e0e4a);
::windows_core::imp::interface_hierarchy!(IMPEG2PIDMap, ::windows_core::IUnknown);
impl IMPEG2PIDMap {
    pub unsafe fn MapPID(&self, culpid: u32, pulpid: *const u32, mediasamplecontent: MEDIA_SAMPLE_CONTENT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MapPID)(::windows_core::Interface::as_raw(self), culpid, pulpid, mediasamplecontent).ok()
    }
    pub unsafe fn UnmapPID(&self, culpid: u32, pulpid: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnmapPID)(::windows_core::Interface::as_raw(self), culpid, pulpid).ok()
    }
    pub unsafe fn EnumPIDMap(&self) -> ::windows_core::Result<IEnumPIDMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumPIDMap)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IMPEG2PIDMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub MapPID: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u32, MEDIA_SAMPLE_CONTENT) -> ::windows_core::HRESULT,
    pub UnmapPID: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u32) -> ::windows_core::HRESULT,
    pub EnumPIDMap: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMPEG2StreamIdMap, IMPEG2StreamIdMap_Vtbl, 0xd0e04c47_25b8_4369_925a_362a01d95444);
::windows_core::imp::interface_hierarchy!(IMPEG2StreamIdMap, ::windows_core::IUnknown);
impl IMPEG2StreamIdMap {
    pub unsafe fn MapStreamId(&self, ulstreamid: u32, mediasamplecontent: u32, ulsubstreamfiltervalue: u32, idataoffset: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MapStreamId)(::windows_core::Interface::as_raw(self), ulstreamid, mediasamplecontent, ulsubstreamfiltervalue, idataoffset).ok()
    }
    pub unsafe fn UnmapStreamId(&self, pulstreamid: &[u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnmapStreamId)(::windows_core::Interface::as_raw(self), pulstreamid.len().try_into().unwrap(), ::core::mem::transmute(pulstreamid.as_ptr())).ok()
    }
    pub unsafe fn EnumStreamIdMap(&self) -> ::windows_core::Result<IEnumStreamIdMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumStreamIdMap)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IMPEG2StreamIdMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub MapStreamId: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, i32) -> ::windows_core::HRESULT,
    pub UnmapStreamId: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u32) -> ::windows_core::HRESULT,
    pub EnumStreamIdMap: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaControl, IMediaControl_Vtbl, 0x56a868b1_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaControl, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IMediaControl {
    pub unsafe fn Run(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Run)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetState(&self, mstimeout: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), mstimeout, &mut result__).map(|| result__)
    }
    pub unsafe fn RenderFile<P0>(&self, strfilename: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RenderFile)(::windows_core::Interface::as_raw(self), strfilename.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0>(&self, strfilename: P0) -> ::windows_core::Result<super::super::System::Com::IDispatch>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddSourceFilter)(::windows_core::Interface::as_raw(self), strfilename.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FilterCollection(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FilterCollection)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RegFilterCollection(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RegFilterCollection)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn StopWhenReady(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StopWhenReady)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaControl_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Run: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub RenderFile: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddSourceFilter: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddSourceFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FilterCollection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FilterCollection: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RegFilterCollection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RegFilterCollection: usize,
    pub StopWhenReady: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaEvent, IMediaEvent_Vtbl, 0x56a868b6_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaEvent, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IMediaEvent {
    pub unsafe fn GetEventHandle(&self) -> ::windows_core::Result<isize> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEvent(&self, leventcode: *mut i32, lparam1: *mut isize, lparam2: *mut isize, mstimeout: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetEvent)(::windows_core::Interface::as_raw(self), leventcode, lparam1, lparam2, mstimeout).ok()
    }
    pub unsafe fn WaitForCompletion(&self, mstimeout: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WaitForCompletion)(::windows_core::Interface::as_raw(self), mstimeout, &mut result__).map(|| result__)
    }
    pub unsafe fn CancelDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CancelDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn RestoreDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RestoreDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn FreeEventParams(&self, levcode: i32, lparam1: isize, lparam2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FreeEventParams)(::windows_core::Interface::as_raw(self), levcode, lparam1, lparam2).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaEvent_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub GetEventHandle: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut isize) -> ::windows_core::HRESULT,
    pub GetEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut isize, *mut isize, i32) -> ::windows_core::HRESULT,
    pub WaitForCompletion: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub CancelDefaultHandling: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub RestoreDefaultHandling: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub FreeEventParams: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, isize, isize) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaEventEx, IMediaEventEx_Vtbl, 0x56a868c0_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaEventEx, ::windows_core::IUnknown, super::super::System::Com::IDispatch, IMediaEvent);
#[cfg(feature = "Win32_System_Com")]
impl IMediaEventEx {
    pub unsafe fn GetEventHandle(&self) -> ::windows_core::Result<isize> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetEvent(&self, leventcode: *mut i32, lparam1: *mut isize, lparam2: *mut isize, mstimeout: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetEvent)(::windows_core::Interface::as_raw(self), leventcode, lparam1, lparam2, mstimeout).ok()
    }
    pub unsafe fn WaitForCompletion(&self, mstimeout: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.WaitForCompletion)(::windows_core::Interface::as_raw(self), mstimeout, &mut result__).map(|| result__)
    }
    pub unsafe fn CancelDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CancelDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn RestoreDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.RestoreDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn FreeEventParams(&self, levcode: i32, lparam1: isize, lparam2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.FreeEventParams)(::windows_core::Interface::as_raw(self), levcode, lparam1, lparam2).ok()
    }
    pub unsafe fn SetNotifyWindow(&self, hwnd: isize, lmsg: i32, linstancedata: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetNotifyWindow)(::windows_core::Interface::as_raw(self), hwnd, lmsg, linstancedata).ok()
    }
    pub unsafe fn SetNotifyFlags(&self, lnonotifyflags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetNotifyFlags)(::windows_core::Interface::as_raw(self), lnonotifyflags).ok()
    }
    pub unsafe fn GetNotifyFlags(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNotifyFlags)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaEventEx_Vtbl {
    pub base__: IMediaEvent_Vtbl,
    pub SetNotifyWindow: unsafe extern "system" fn(*mut ::core::ffi::c_void, isize, i32, isize) -> ::windows_core::HRESULT,
    pub SetNotifyFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub GetNotifyFlags: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaEventSink, IMediaEventSink_Vtbl, 0x56a868a2_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IMediaEventSink, ::windows_core::IUnknown);
impl IMediaEventSink {
    pub unsafe fn Notify(&self, eventcode: i32, eventparam1: isize, eventparam2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Notify)(::windows_core::Interface::as_raw(self), eventcode, eventparam1, eventparam2).ok()
    }
}
#[repr(C)]
pub struct IMediaEventSink_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Notify: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, isize, isize) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaFilter, IMediaFilter_Vtbl, 0x56a86899_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaFilter, ::windows_core::IUnknown, super::super::System::Com::IPersist);
#[cfg(feature = "Win32_System_Com")]
impl IMediaFilter {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn GetState(&self, dwmillisecstimeout: u32) -> ::windows_core::Result<FILTER_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), dwmillisecstimeout, &mut result__).map(|| result__)
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn GetSyncSource(&self) -> ::windows_core::Result<super::IReferenceClock> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSyncSource)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaFilter_Vtbl {
    pub base__: super::super::System::Com::IPersist_Vtbl,
    pub Stop: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Run: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut FILTER_STATE) -> ::windows_core::HRESULT,
    pub SetSyncSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetSyncSource: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaParamInfo, IMediaParamInfo_Vtbl, 0x6d6cbb60_a223_44aa_842f_a2f06750be6d);
::windows_core::imp::interface_hierarchy!(IMediaParamInfo, ::windows_core::IUnknown);
impl IMediaParamInfo {
    pub unsafe fn GetParamCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParamCount)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetParamInfo(&self, dwparamindex: u32, pinfo: *mut MP_PARAMINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParamInfo)(::windows_core::Interface::as_raw(self), dwparamindex, pinfo).ok()
    }
    pub unsafe fn GetParamText(&self, dwparamindex: u32) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParamText)(::windows_core::Interface::as_raw(self), dwparamindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetNumTimeFormats(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumTimeFormats)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedTimeFormat(&self, dwformatindex: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSupportedTimeFormat)(::windows_core::Interface::as_raw(self), dwformatindex, &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentTimeFormat(&self, pguidtimeformat: *mut ::windows_core::GUID, ptimedata: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentTimeFormat)(::windows_core::Interface::as_raw(self), pguidtimeformat, ptimedata).ok()
    }
}
#[repr(C)]
pub struct IMediaParamInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetParamCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetParamInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut MP_PARAMINFO) -> ::windows_core::HRESULT,
    pub GetParamText: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetNumTimeFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub GetSupportedTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetCurrentTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaParams, IMediaParams_Vtbl, 0x6d6cbb61_a223_44aa_842f_a2f06750be6e);
::windows_core::imp::interface_hierarchy!(IMediaParams, ::windows_core::IUnknown);
impl IMediaParams {
    pub unsafe fn GetParam(&self, dwparamindex: u32) -> ::windows_core::Result<f32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParam)(::windows_core::Interface::as_raw(self), dwparamindex, &mut result__).map(|| result__)
    }
    pub unsafe fn SetParam(&self, dwparamindex: u32, value: f32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParam)(::windows_core::Interface::as_raw(self), dwparamindex, value).ok()
    }
    pub unsafe fn AddEnvelope(&self, dwparamindex: u32, csegments: u32, penvelopesegments: *const MP_ENVELOPE_SEGMENT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AddEnvelope)(::windows_core::Interface::as_raw(self), dwparamindex, csegments, penvelopesegments).ok()
    }
    pub unsafe fn FlushEnvelope(&self, dwparamindex: u32, reftimestart: i64, reftimeend: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FlushEnvelope)(::windows_core::Interface::as_raw(self), dwparamindex, reftimestart, reftimeend).ok()
    }
    pub unsafe fn SetTimeFormat(&self, guidtimeformat: ::windows_core::GUID, mptimedata: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTimeFormat)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(guidtimeformat), mptimedata).ok()
    }
}
#[repr(C)]
pub struct IMediaParams_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetParam: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut f32) -> ::windows_core::HRESULT,
    pub SetParam: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, f32) -> ::windows_core::HRESULT,
    pub AddEnvelope: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, *const MP_ENVELOPE_SEGMENT) -> ::windows_core::HRESULT,
    pub FlushEnvelope: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, i64, i64) -> ::windows_core::HRESULT,
    pub SetTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::GUID, u32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaPosition, IMediaPosition_Vtbl, 0x56a868b2_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaPosition, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IMediaPosition {
    pub unsafe fn Duration(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Duration)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetCurrentPosition(&self, lltime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentPosition)(::windows_core::Interface::as_raw(self), lltime).ok()
    }
    pub unsafe fn CurrentPosition(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CurrentPosition)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn StopTime(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).StopTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetStopTime(&self, lltime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStopTime)(::windows_core::Interface::as_raw(self), lltime).ok()
    }
    pub unsafe fn PrerollTime(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PrerollTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetPrerollTime(&self, lltime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPrerollTime)(::windows_core::Interface::as_raw(self), lltime).ok()
    }
    pub unsafe fn SetRate(&self, drate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRate)(::windows_core::Interface::as_raw(self), drate).ok()
    }
    pub unsafe fn Rate(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Rate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn CanSeekForward(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanSeekForward)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn CanSeekBackward(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanSeekBackward)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaPosition_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Duration: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetCurrentPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub CurrentPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub StopTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetStopTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub PrerollTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub SetPrerollTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub Rate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub CanSeekForward: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub CanSeekBackward: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
::windows_core::imp::com_interface!(IMediaPropertyBag, IMediaPropertyBag_Vtbl, 0x6025a880_c0d5_11d0_bd4e_00a0c911ce86);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
::windows_core::imp::interface_hierarchy!(IMediaPropertyBag, ::windows_core::IUnknown, super::super::System::Com::StructuredStorage::IPropertyBag);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl IMediaPropertyBag {
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Read<P0, P1>(&self, pszpropname: P0, pvar: *mut ::windows_core::VARIANT, perrorlog: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IErrorLog>,
    {
        (::windows_core::Interface::vtable(self).base__.Read)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), ::core::mem::transmute(pvar), perrorlog.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Write<P0>(&self, pszpropname: P0, pvar: *const ::windows_core::VARIANT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.Write)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), ::core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn EnumProperty(&self, iproperty: u32, pvarpropertyname: *mut ::windows_core::VARIANT, pvarpropertyvalue: *mut ::windows_core::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumProperty)(::windows_core::Interface::as_raw(self), iproperty, ::core::mem::transmute(pvarpropertyname), ::core::mem::transmute(pvarpropertyvalue)).ok()
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(C)]
pub struct IMediaPropertyBag_Vtbl {
    pub base__: super::super::System::Com::StructuredStorage::IPropertyBag_Vtbl,
    pub EnumProperty: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaSample, IMediaSample_Vtbl, 0x56a8689a_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IMediaSample, ::windows_core::IUnknown);
impl IMediaSample {
    pub unsafe fn GetPointer(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPointer)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSize(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetSize)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn IsSyncPoint(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsSyncPoint)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetSyncPoint<P0>(&self, bissyncpoint: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetSyncPoint)(::windows_core::Interface::as_raw(self), bissyncpoint.into_param().abi()).ok()
    }
    pub unsafe fn IsPreroll(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsPreroll)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetPreroll<P0>(&self, bispreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetPreroll)(::windows_core::Interface::as_raw(self), bispreroll.into_param().abi()).ok()
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetActualDataLength)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetActualDataLength(&self, __midl__imediasample0000: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetActualDataLength)(::windows_core::Interface::as_raw(self), __midl__imediasample0000).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetMediaType(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaType)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaType)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    pub unsafe fn IsDiscontinuity(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsDiscontinuity)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetDiscontinuity<P0>(&self, bdiscontinuity: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDiscontinuity)(::windows_core::Interface::as_raw(self), bdiscontinuity.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
}
#[repr(C)]
pub struct IMediaSample_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPointer: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetSize: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> i32,
    pub GetTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub SetTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
    pub IsSyncPoint: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetSyncPoint: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub IsPreroll: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetPreroll: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetActualDataLength: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> i32,
    pub SetActualDataLength: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetMediaType: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetMediaType: usize,
    pub IsDiscontinuity: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetDiscontinuity: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetMediaTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub SetMediaTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaSample2, IMediaSample2_Vtbl, 0x36b73884_c2c8_11cf_8b46_00805f6cef60);
::windows_core::imp::interface_hierarchy!(IMediaSample2, ::windows_core::IUnknown, IMediaSample);
impl IMediaSample2 {
    pub unsafe fn GetPointer(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetPointer)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetSize(&self) -> i32 {
        (::windows_core::Interface::vtable(self).base__.GetSize)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn IsSyncPoint(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).base__.IsSyncPoint)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetSyncPoint<P0>(&self, bissyncpoint: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSyncPoint)(::windows_core::Interface::as_raw(self), bissyncpoint.into_param().abi()).ok()
    }
    pub unsafe fn IsPreroll(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).base__.IsPreroll)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetPreroll<P0>(&self, bispreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetPreroll)(::windows_core::Interface::as_raw(self), bispreroll.into_param().abi()).ok()
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        (::windows_core::Interface::vtable(self).base__.GetActualDataLength)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetActualDataLength(&self, __midl__imediasample0000: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetActualDataLength)(::windows_core::Interface::as_raw(self), __midl__imediasample0000).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetMediaType(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMediaType)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMediaType)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    pub unsafe fn IsDiscontinuity(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).base__.IsDiscontinuity)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetDiscontinuity<P0>(&self, bdiscontinuity: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetDiscontinuity)(::windows_core::Interface::as_raw(self), bdiscontinuity.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMediaTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn GetProperties(&self, pbproperties: &mut [u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetProperties)(::windows_core::Interface::as_raw(self), pbproperties.len().try_into().unwrap(), ::core::mem::transmute(pbproperties.as_ptr())).ok()
    }
    pub unsafe fn SetProperties(&self, pbproperties: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProperties)(::windows_core::Interface::as_raw(self), pbproperties.len().try_into().unwrap(), ::core::mem::transmute(pbproperties.as_ptr())).ok()
    }
}
#[repr(C)]
pub struct IMediaSample2_Vtbl {
    pub base__: IMediaSample_Vtbl,
    pub GetProperties: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u8) -> ::windows_core::HRESULT,
    pub SetProperties: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaSample2Config, IMediaSample2Config_Vtbl, 0x68961e68_832b_41ea_bc91_63593f3e70e3);
::windows_core::imp::interface_hierarchy!(IMediaSample2Config, ::windows_core::IUnknown);
impl IMediaSample2Config {
    pub unsafe fn GetSurface(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IMediaSample2Config_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaSeeking, IMediaSeeking_Vtbl, 0x36b73880_c2c8_11cf_8b46_00805f6cef60);
::windows_core::imp::interface_hierarchy!(IMediaSeeking, ::windows_core::IUnknown);
impl IMediaSeeking {
    pub unsafe fn GetCapabilities(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCapabilities)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn CheckCapabilities(&self, pcapabilities: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CheckCapabilities)(::windows_core::Interface::as_raw(self), pcapabilities).ok()
    }
    pub unsafe fn IsFormatSupported(&self, pformat: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsFormatSupported)(::windows_core::Interface::as_raw(self), pformat).ok()
    }
    pub unsafe fn QueryPreferredFormat(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryPreferredFormat)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetTimeFormat(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTimeFormat)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn IsUsingTimeFormat(&self, pformat: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsUsingTimeFormat)(::windows_core::Interface::as_raw(self), pformat).ok()
    }
    pub unsafe fn SetTimeFormat(&self, pformat: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTimeFormat)(::windows_core::Interface::as_raw(self), pformat).ok()
    }
    pub unsafe fn GetDuration(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDuration)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetStopPosition(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStopPosition)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetCurrentPosition(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentPosition)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn ConvertTimeFormat(&self, ptarget: *mut i64, ptargetformat: ::core::option::Option<*const ::windows_core::GUID>, source: i64, psourceformat: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConvertTimeFormat)(::windows_core::Interface::as_raw(self), ptarget, ::core::mem::transmute(ptargetformat.unwrap_or(::std::ptr::null())), source, ::core::mem::transmute(psourceformat.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn SetPositions(&self, pcurrent: ::core::option::Option<*mut i64>, dwcurrentflags: u32, pstop: ::core::option::Option<*mut i64>, dwstopflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPositions)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcurrent.unwrap_or(::std::ptr::null_mut())), dwcurrentflags, ::core::mem::transmute(pstop.unwrap_or(::std::ptr::null_mut())), dwstopflags).ok()
    }
    pub unsafe fn GetPositions(&self, pcurrent: ::core::option::Option<*mut i64>, pstop: ::core::option::Option<*mut i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPositions)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcurrent.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pstop.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetAvailable(&self, pearliest: ::core::option::Option<*mut i64>, platest: ::core::option::Option<*mut i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAvailable)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pearliest.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(platest.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetRate(&self, drate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRate)(::windows_core::Interface::as_raw(self), drate).ok()
    }
    pub unsafe fn GetRate(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetPreroll(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPreroll)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IMediaSeeking_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCapabilities: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub CheckCapabilities: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub IsFormatSupported: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub QueryPreferredFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub IsUsingTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDuration: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub GetStopPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub GetCurrentPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub ConvertTimeFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *const ::windows_core::GUID, i64, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetPositions: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, u32, *mut i64, u32) -> ::windows_core::HRESULT,
    pub GetPositions: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub GetAvailable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, f64) -> ::windows_core::HRESULT,
    pub GetRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut f64) -> ::windows_core::HRESULT,
    pub GetPreroll: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMediaStream, IMediaStream_Vtbl, 0xb502d1bd_9a57_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IMediaStream, ::windows_core::IUnknown);
impl IMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
}
#[repr(C)]
pub struct IMediaStream_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMultiMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetInformation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::GUID, *mut STREAM_TYPE) -> ::windows_core::HRESULT,
    pub SetSameFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub AllocateSample: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSharedSample: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SendEndOfStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaStreamFilter, IMediaStreamFilter_Vtbl, 0xbebe595e_9a6f_11d0_8fde_00c04fd9189d);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaStreamFilter, ::windows_core::IUnknown, super::super::System::Com::IPersist, IMediaFilter, IBaseFilter);
#[cfg(feature = "Win32_System_Com")]
impl IMediaStreamFilter {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn GetState(&self, dwmillisecstimeout: u32) -> ::windows_core::Result<FILTER_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.GetState)(::windows_core::Interface::as_raw(self), dwmillisecstimeout, &mut result__).map(|| result__)
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn GetSyncSource(&self) -> ::windows_core::Result<super::IReferenceClock> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.GetSyncSource)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumPins(&self) -> ::windows_core::Result<IEnumPins> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.EnumPins)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn FindPin<P0>(&self, id: P0) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.FindPin)(::windows_core::Interface::as_raw(self), id.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn QueryFilterInfo(&self, pinfo: *mut FILTER_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.QueryFilterInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
    pub unsafe fn JoinFilterGraph<P0, P1>(&self, pgraph: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IFilterGraph>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.JoinFilterGraph)(::windows_core::Interface::as_raw(self), pgraph.into_param().abi(), pname.into_param().abi()).ok()
    }
    pub unsafe fn QueryVendorInfo(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.QueryVendorInfo)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AddMediaStream<P0>(&self, pammediastream: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMMediaStream>,
    {
        (::windows_core::Interface::vtable(self).AddMediaStream)(::windows_core::Interface::as_raw(self), pammediastream.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows_core::GUID) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaStream)(::windows_core::Interface::as_raw(self), idpurpose, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumMediaStreams)(::windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SupportSeeking<P0>(&self, brenderer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SupportSeeking)(::windows_core::Interface::as_raw(self), brenderer.into_param().abi()).ok()
    }
    pub unsafe fn ReferenceTimeToStreamTime(&self, ptime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReferenceTimeToStreamTime)(::windows_core::Interface::as_raw(self), ptime).ok()
    }
    pub unsafe fn GetCurrentStreamTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentStreamTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn WaitUntil(&self, waitstreamtime: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitUntil)(::windows_core::Interface::as_raw(self), waitstreamtime).ok()
    }
    pub unsafe fn Flush<P0>(&self, bcanceleos: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).Flush)(::windows_core::Interface::as_raw(self), bcanceleos.into_param().abi()).ok()
    }
    pub unsafe fn EndOfStream(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndOfStream)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaStreamFilter_Vtbl {
    pub base__: IBaseFilter_Vtbl,
    pub AddMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EnumMediaStreams: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SupportSeeking: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub ReferenceTimeToStreamTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub GetCurrentStreamTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub WaitUntil: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
    pub Flush: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub EndOfStream: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IMediaTypeInfo, IMediaTypeInfo_Vtbl, 0x56a868bc_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaTypeInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IMediaTypeInfo {
    pub unsafe fn Type(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Type)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Subtype(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Subtype)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMediaTypeInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Type: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Subtype: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMemAllocator, IMemAllocator_Vtbl, 0x56a8689c_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IMemAllocator, ::windows_core::IUnknown);
impl IMemAllocator {
    pub unsafe fn SetProperties(&self, prequest: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetProperties)(::windows_core::Interface::as_raw(self), prequest, &mut result__).map(|| result__)
    }
    pub unsafe fn GetProperties(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetProperties)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Commit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Commit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Decommit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Decommit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetBuffer(&self, ppbuffer: *mut ::core::option::Option<IMediaSample>, pstarttime: ::core::option::Option<*const i64>, pendtime: ::core::option::Option<*const i64>, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBuffer)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppbuffer), ::core::mem::transmute(pstarttime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pendtime.unwrap_or(::std::ptr::null())), dwflags).ok()
    }
    pub unsafe fn ReleaseBuffer<P0>(&self, pbuffer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).ReleaseBuffer)(::windows_core::Interface::as_raw(self), pbuffer.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IMemAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetProperties: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ALLOCATOR_PROPERTIES, *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub GetProperties: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub Commit: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Decommit: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetBuffer: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *const i64, *const i64, u32) -> ::windows_core::HRESULT,
    pub ReleaseBuffer: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMemAllocatorCallbackTemp, IMemAllocatorCallbackTemp_Vtbl, 0x379a0cf0_c1de_11d2_abf5_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IMemAllocatorCallbackTemp, ::windows_core::IUnknown, IMemAllocator);
impl IMemAllocatorCallbackTemp {
    pub unsafe fn SetProperties(&self, prequest: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SetProperties)(::windows_core::Interface::as_raw(self), prequest, &mut result__).map(|| result__)
    }
    pub unsafe fn GetProperties(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetProperties)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Commit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Commit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Decommit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Decommit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetBuffer(&self, ppbuffer: *mut ::core::option::Option<IMediaSample>, pstarttime: ::core::option::Option<*const i64>, pendtime: ::core::option::Option<*const i64>, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetBuffer)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppbuffer), ::core::mem::transmute(pstarttime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pendtime.unwrap_or(::std::ptr::null())), dwflags).ok()
    }
    pub unsafe fn ReleaseBuffer<P0>(&self, pbuffer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).base__.ReleaseBuffer)(::windows_core::Interface::as_raw(self), pbuffer.into_param().abi()).ok()
    }
    pub unsafe fn SetNotify<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMemAllocatorNotifyCallbackTemp>,
    {
        (::windows_core::Interface::vtable(self).SetNotify)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
    pub unsafe fn GetFreeCount(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFreeCount)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IMemAllocatorCallbackTemp_Vtbl {
    pub base__: IMemAllocator_Vtbl,
    pub SetNotify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFreeCount: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMemAllocatorNotifyCallbackTemp, IMemAllocatorNotifyCallbackTemp_Vtbl, 0x92980b30_c1de_11d2_abf5_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IMemAllocatorNotifyCallbackTemp, ::windows_core::IUnknown);
impl IMemAllocatorNotifyCallbackTemp {
    pub unsafe fn NotifyRelease(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyRelease)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IMemAllocatorNotifyCallbackTemp_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub NotifyRelease: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMemInputPin, IMemInputPin_Vtbl, 0x56a8689d_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IMemInputPin, ::windows_core::IUnknown);
impl IMemInputPin {
    pub unsafe fn GetAllocator(&self) -> ::windows_core::Result<IMemAllocator> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllocator)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn NotifyAllocator<P0, P1>(&self, pallocator: P0, breadonly: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMemAllocator>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).NotifyAllocator)(::windows_core::Interface::as_raw(self), pallocator.into_param().abi(), breadonly.into_param().abi()).ok()
    }
    pub unsafe fn GetAllocatorRequirements(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllocatorRequirements)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Receive<P0>(&self, psample: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).Receive)(::windows_core::Interface::as_raw(self), psample.into_param().abi()).ok()
    }
    pub unsafe fn ReceiveMultiple(&self, psamples: &[::core::option::Option<IMediaSample>]) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ReceiveMultiple)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(psamples.as_ptr()), psamples.len().try_into().unwrap(), &mut result__).map(|| result__)
    }
    pub unsafe fn ReceiveCanBlock(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReceiveCanBlock)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IMemInputPin_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetAllocator: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NotifyAllocator: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetAllocatorRequirements: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub Receive: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReceiveMultiple: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const *mut ::core::ffi::c_void, i32, *mut i32) -> ::windows_core::HRESULT,
    pub ReceiveCanBlock: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMemoryData, IMemoryData_Vtbl, 0x327fc560_af60_11d0_8212_00c04fc32c45);
::windows_core::imp::interface_hierarchy!(IMemoryData, ::windows_core::IUnknown);
impl IMemoryData {
    pub unsafe fn SetBuffer(&self, cbsize: u32, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBuffer)(::windows_core::Interface::as_raw(self), cbsize, pbdata, dwflags).ok()
    }
    pub unsafe fn GetInfo(&self, pdwlength: *mut u32, ppbdata: *mut *mut u8, pcbactualdata: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(::windows_core::Interface::as_raw(self), pdwlength, ppbdata, pcbactualdata).ok()
    }
    pub unsafe fn SetActual(&self, cbdatavalid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetActual)(::windows_core::Interface::as_raw(self), cbdatavalid).ok()
    }
}
#[repr(C)]
pub struct IMemoryData_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetBuffer: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const u8, u32) -> ::windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut u8, *mut u32) -> ::windows_core::HRESULT,
    pub SetActual: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMixerOCX, IMixerOCX_Vtbl, 0x81a3bd32_dee1_11d1_8508_00a0c91f9ca0);
::windows_core::imp::interface_hierarchy!(IMixerOCX, ::windows_core::IUnknown);
impl IMixerOCX {
    pub unsafe fn OnDisplayChange(&self, ulbitsperpixel: u32, ulscreenwidth: u32, ulscreenheight: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnDisplayChange)(::windows_core::Interface::as_raw(self), ulbitsperpixel, ulscreenwidth, ulscreenheight).ok()
    }
    pub unsafe fn GetAspectRatio(&self, pdwpictaspectratiox: *mut u32, pdwpictaspectratioy: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAspectRatio)(::windows_core::Interface::as_raw(self), pdwpictaspectratiox, pdwpictaspectratioy).ok()
    }
    pub unsafe fn GetVideoSize(&self, pdwvideowidth: *mut u32, pdwvideoheight: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoSize)(::windows_core::Interface::as_raw(self), pdwvideowidth, pdwvideoheight).ok()
    }
    pub unsafe fn GetStatus(&self) -> ::windows_core::Result<*mut u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnDraw<P0>(&self, hdcdraw: P0, prcdraw: *const super::super::Foundation::RECT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Gdi::HDC>,
    {
        (::windows_core::Interface::vtable(self).OnDraw)(::windows_core::Interface::as_raw(self), hdcdraw.into_param().abi(), prcdraw).ok()
    }
    pub unsafe fn SetDrawRegion(&self, lppttopleftsc: *const super::super::Foundation::POINT, prcdrawcc: *const super::super::Foundation::RECT, lprcclip: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawRegion)(::windows_core::Interface::as_raw(self), lppttopleftsc, prcdrawcc, lprcclip).ok()
    }
    pub unsafe fn Advise<P0>(&self, pmdns: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMixerOCXNotify>,
    {
        (::windows_core::Interface::vtable(self).Advise)(::windows_core::Interface::as_raw(self), pmdns.into_param().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnAdvise)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IMixerOCX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnDisplayChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32) -> ::windows_core::HRESULT,
    pub GetAspectRatio: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub OnDraw: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Graphics::Gdi::HDC, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    OnDraw: usize,
    pub SetDrawRegion: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::POINT, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMixerOCXNotify, IMixerOCXNotify_Vtbl, 0x81a3bd31_dee1_11d1_8508_00a0c91f9ca0);
::windows_core::imp::interface_hierarchy!(IMixerOCXNotify, ::windows_core::IUnknown);
impl IMixerOCXNotify {
    pub unsafe fn OnInvalidateRect(&self, lpcrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnInvalidateRect)(::windows_core::Interface::as_raw(self), lpcrect).ok()
    }
    pub unsafe fn OnStatusChange(&self, ulstatusflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnStatusChange)(::windows_core::Interface::as_raw(self), ulstatusflags).ok()
    }
    pub unsafe fn OnDataChange(&self, uldataflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnDataChange)(::windows_core::Interface::as_raw(self), uldataflags).ok()
    }
}
#[repr(C)]
pub struct IMixerOCXNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnInvalidateRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub OnStatusChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub OnDataChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMixerPinConfig, IMixerPinConfig_Vtbl, 0x593cdde1_0759_11d1_9e69_00c04fd7c15b);
::windows_core::imp::interface_hierarchy!(IMixerPinConfig, ::windows_core::IUnknown);
impl IMixerPinConfig {
    pub unsafe fn SetRelativePosition(&self, dwleft: u32, dwtop: u32, dwright: u32, dwbottom: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRelativePosition)(::windows_core::Interface::as_raw(self), dwleft, dwtop, dwright, dwbottom).ok()
    }
    pub unsafe fn GetRelativePosition(&self, pdwleft: *mut u32, pdwtop: *mut u32, pdwright: *mut u32, pdwbottom: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRelativePosition)(::windows_core::Interface::as_raw(self), pdwleft, pdwtop, pdwright, pdwbottom).ok()
    }
    pub unsafe fn SetZOrder(&self, dwzorder: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetZOrder)(::windows_core::Interface::as_raw(self), dwzorder).ok()
    }
    pub unsafe fn GetZOrder(&self, pdwzorder: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetZOrder)(::windows_core::Interface::as_raw(self), pdwzorder).ok()
    }
    pub unsafe fn SetColorKey(&self, pcolorkey: *mut COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    pub unsafe fn GetColorKey(&self, pcolorkey: *mut COLORKEY, pcolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey, pcolor).ok()
    }
    pub unsafe fn SetBlendingParameter(&self, dwblendingparameter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBlendingParameter)(::windows_core::Interface::as_raw(self), dwblendingparameter).ok()
    }
    pub unsafe fn GetBlendingParameter(&self, pdwblendingparameter: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBlendingParameter)(::windows_core::Interface::as_raw(self), pdwblendingparameter).ok()
    }
    pub unsafe fn SetAspectRatioMode(&self, amaspectratiomode: AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAspectRatioMode)(::windows_core::Interface::as_raw(self), amaspectratiomode).ok()
    }
    pub unsafe fn GetAspectRatioMode(&self, pamaspectratiomode: *mut AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAspectRatioMode)(::windows_core::Interface::as_raw(self), pamaspectratiomode).ok()
    }
    pub unsafe fn SetStreamTransparent<P0>(&self, bstreamtransparent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetStreamTransparent)(::windows_core::Interface::as_raw(self), bstreamtransparent.into_param().abi()).ok()
    }
    pub unsafe fn GetStreamTransparent(&self, pbstreamtransparent: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStreamTransparent)(::windows_core::Interface::as_raw(self), pbstreamtransparent).ok()
    }
}
#[repr(C)]
pub struct IMixerPinConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetRelativePosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32, u32) -> ::windows_core::HRESULT,
    pub GetRelativePosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32) -> ::windows_core::HRESULT,
    pub SetZOrder: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetZOrder: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut COLORKEY) -> ::windows_core::HRESULT,
    pub GetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut COLORKEY, *mut u32) -> ::windows_core::HRESULT,
    pub SetBlendingParameter: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetBlendingParameter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, AM_ASPECT_RATIO_MODE) -> ::windows_core::HRESULT,
    pub GetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AM_ASPECT_RATIO_MODE) -> ::windows_core::HRESULT,
    pub SetStreamTransparent: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetStreamTransparent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMixerPinConfig2, IMixerPinConfig2_Vtbl, 0xebf47182_8764_11d1_9e69_00c04fd7c15b);
::windows_core::imp::interface_hierarchy!(IMixerPinConfig2, ::windows_core::IUnknown, IMixerPinConfig);
impl IMixerPinConfig2 {
    pub unsafe fn SetRelativePosition(&self, dwleft: u32, dwtop: u32, dwright: u32, dwbottom: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetRelativePosition)(::windows_core::Interface::as_raw(self), dwleft, dwtop, dwright, dwbottom).ok()
    }
    pub unsafe fn GetRelativePosition(&self, pdwleft: *mut u32, pdwtop: *mut u32, pdwright: *mut u32, pdwbottom: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetRelativePosition)(::windows_core::Interface::as_raw(self), pdwleft, pdwtop, pdwright, pdwbottom).ok()
    }
    pub unsafe fn SetZOrder(&self, dwzorder: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetZOrder)(::windows_core::Interface::as_raw(self), dwzorder).ok()
    }
    pub unsafe fn GetZOrder(&self, pdwzorder: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetZOrder)(::windows_core::Interface::as_raw(self), pdwzorder).ok()
    }
    pub unsafe fn SetColorKey(&self, pcolorkey: *mut COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    pub unsafe fn GetColorKey(&self, pcolorkey: *mut COLORKEY, pcolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey, pcolor).ok()
    }
    pub unsafe fn SetBlendingParameter(&self, dwblendingparameter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetBlendingParameter)(::windows_core::Interface::as_raw(self), dwblendingparameter).ok()
    }
    pub unsafe fn GetBlendingParameter(&self, pdwblendingparameter: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetBlendingParameter)(::windows_core::Interface::as_raw(self), pdwblendingparameter).ok()
    }
    pub unsafe fn SetAspectRatioMode(&self, amaspectratiomode: AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetAspectRatioMode)(::windows_core::Interface::as_raw(self), amaspectratiomode).ok()
    }
    pub unsafe fn GetAspectRatioMode(&self, pamaspectratiomode: *mut AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetAspectRatioMode)(::windows_core::Interface::as_raw(self), pamaspectratiomode).ok()
    }
    pub unsafe fn SetStreamTransparent<P0>(&self, bstreamtransparent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetStreamTransparent)(::windows_core::Interface::as_raw(self), bstreamtransparent.into_param().abi()).ok()
    }
    pub unsafe fn GetStreamTransparent(&self, pbstreamtransparent: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetStreamTransparent)(::windows_core::Interface::as_raw(self), pbstreamtransparent).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetOverlaySurfaceColorControls(&self, pcolorcontrol: *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOverlaySurfaceColorControls)(::windows_core::Interface::as_raw(self), pcolorcontrol).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetOverlaySurfaceColorControls(&self, pcolorcontrol: *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetOverlaySurfaceColorControls)(::windows_core::Interface::as_raw(self), pcolorcontrol).ok()
    }
}
#[repr(C)]
pub struct IMixerPinConfig2_Vtbl {
    pub base__: IMixerPinConfig_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetOverlaySurfaceColorControls: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetOverlaySurfaceColorControls: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetOverlaySurfaceColorControls: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetOverlaySurfaceColorControls: usize,
}
::windows_core::imp::com_interface!(IMpeg2Demultiplexer, IMpeg2Demultiplexer_Vtbl, 0x436eee9c_264f_4242_90e1_4e330c107512);
::windows_core::imp::interface_hierarchy!(IMpeg2Demultiplexer, ::windows_core::IUnknown);
impl IMpeg2Demultiplexer {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn CreateOutputPin<P0>(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, pszpinname: P0) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateOutputPin)(::windows_core::Interface::as_raw(self), pmediatype, pszpinname.into_param().abi(), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetOutputPinMediaType<P0>(&self, pszpinname: P0, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetOutputPinMediaType)(::windows_core::Interface::as_raw(self), pszpinname.into_param().abi(), pmediatype).ok()
    }
    pub unsafe fn DeleteOutputPin<P0>(&self, pszpinname: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).DeleteOutputPin)(::windows_core::Interface::as_raw(self), pszpinname.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IMpeg2Demultiplexer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub CreateOutputPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE, ::windows_core::PCWSTR, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    CreateOutputPin: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetOutputPinMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetOutputPinMediaType: usize,
    pub DeleteOutputPin: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IMpegAudioDecoder, IMpegAudioDecoder_Vtbl, 0xb45dd570_3c77_11d1_abe1_00a0c905f375);
::windows_core::imp::interface_hierarchy!(IMpegAudioDecoder, ::windows_core::IUnknown);
impl IMpegAudioDecoder {
    pub unsafe fn FrequencyDivider(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FrequencyDivider)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetFrequencyDivider(&self, divider: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFrequencyDivider)(::windows_core::Interface::as_raw(self), divider).ok()
    }
    pub unsafe fn DecoderAccuracy(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DecoderAccuracy)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDecoderAccuracy(&self, accuracy: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecoderAccuracy)(::windows_core::Interface::as_raw(self), accuracy).ok()
    }
    pub unsafe fn Stereo(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Stereo)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetStereo(&self, stereo: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStereo)(::windows_core::Interface::as_raw(self), stereo).ok()
    }
    pub unsafe fn DecoderWordSize(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DecoderWordSize)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDecoderWordSize(&self, wordsize: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecoderWordSize)(::windows_core::Interface::as_raw(self), wordsize).ok()
    }
    pub unsafe fn IntegerDecode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IntegerDecode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetIntegerDecode(&self, intdecode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetIntegerDecode)(::windows_core::Interface::as_raw(self), intdecode).ok()
    }
    pub unsafe fn DualMode(&self, pintdecode: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DualMode)(::windows_core::Interface::as_raw(self), pintdecode).ok()
    }
    pub unsafe fn SetDualMode(&self, intdecode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDualMode)(::windows_core::Interface::as_raw(self), intdecode).ok()
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn AudioFormat(&self, lpfmt: *mut MPEG1WAVEFORMAT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AudioFormat)(::windows_core::Interface::as_raw(self), lpfmt).ok()
    }
}
#[repr(C)]
pub struct IMpegAudioDecoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub FrequencyDivider: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetFrequencyDivider: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub DecoderAccuracy: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDecoderAccuracy: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Stereo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetStereo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub DecoderWordSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDecoderWordSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub IntegerDecode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetIntegerDecode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub DualMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDualMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_Audio")]
    pub AudioFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut MPEG1WAVEFORMAT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    AudioFormat: usize,
}
::windows_core::imp::com_interface!(IMultiMediaStream, IMultiMediaStream_Vtbl, 0xb502d1bc_9a57_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IMultiMediaStream, ::windows_core::IUnknown);
impl IMultiMediaStream {
    pub unsafe fn GetInformation(&self, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInformation)(::windows_core::Interface::as_raw(self), pdwflags, pstreamtype).ok()
    }
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows_core::GUID) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaStream)(::windows_core::Interface::as_raw(self), idpurpose, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumMediaStreams)(::windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetState(&self) -> ::windows_core::Result<STREAM_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetState(&self, newstate: STREAM_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), newstate).ok()
    }
    pub unsafe fn GetTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTime)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetDuration(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDuration)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Seek(&self, seektime: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Seek)(::windows_core::Interface::as_raw(self), seektime).ok()
    }
    pub unsafe fn GetEndOfStreamEventHandle(&self) -> ::windows_core::Result<super::super::Foundation::HANDLE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEndOfStreamEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IMultiMediaStream_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetInformation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut MMSSF_GET_INFORMATION_FLAGS, *mut STREAM_TYPE) -> ::windows_core::HRESULT,
    pub GetMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EnumMediaStreams: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut STREAM_STATE) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(*mut ::core::ffi::c_void, STREAM_STATE) -> ::windows_core::HRESULT,
    pub GetTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub GetDuration: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64) -> ::windows_core::HRESULT,
    pub Seek: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64) -> ::windows_core::HRESULT,
    pub GetEndOfStreamEventHandle: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IOverlay, IOverlay_Vtbl, 0x56a868a1_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IOverlay, ::windows_core::IUnknown);
impl IOverlay {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self, pdwcolors: *mut u32, pppalette: *mut *mut super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPalette)(::windows_core::Interface::as_raw(self), pdwcolors, pppalette).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetPalette(&self, ppalette: &[super::super::Graphics::Gdi::PALETTEENTRY]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPalette)(::windows_core::Interface::as_raw(self), ppalette.len().try_into().unwrap(), ::core::mem::transmute(ppalette.as_ptr())).ok()
    }
    pub unsafe fn GetDefaultColorKey(&self) -> ::windows_core::Result<COLORKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultColorKey)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetColorKey(&self) -> ::windows_core::Result<COLORKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetColorKey)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetColorKey(&self, pcolorkey: *mut COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    pub unsafe fn GetWindowHandle(&self) -> ::windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetWindowHandle)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetClipList(&self, psourcerect: *mut super::super::Foundation::RECT, pdestinationrect: *mut super::super::Foundation::RECT, pprgndata: *mut *mut super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetClipList)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect, pprgndata).ok()
    }
    pub unsafe fn GetVideoPosition(&self, psourcerect: *mut super::super::Foundation::RECT, pdestinationrect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoPosition)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect).ok()
    }
    pub unsafe fn Advise<P0>(&self, poverlaynotify: P0, dwinterests: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IOverlayNotify>,
    {
        (::windows_core::Interface::vtable(self).Advise)(::windows_core::Interface::as_raw(self), poverlaynotify.into_param().abi(), dwinterests).ok()
    }
    pub unsafe fn Unadvise(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Unadvise)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IOverlay_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut *mut super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetPalette: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetPalette: usize,
    pub GetDefaultColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut COLORKEY) -> ::windows_core::HRESULT,
    pub GetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut COLORKEY) -> ::windows_core::HRESULT,
    pub SetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut COLORKEY) -> ::windows_core::HRESULT,
    pub GetWindowHandle: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetClipList: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::RECT, *mut super::super::Foundation::RECT, *mut *mut super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetClipList: usize,
    pub GetVideoPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::RECT, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IOverlayNotify, IOverlayNotify_Vtbl, 0x56a868a0_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IOverlayNotify, ::windows_core::IUnknown);
impl IOverlayNotify {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnPaletteChange(&self, dwcolors: u32, ppalette: *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnPaletteChange)(::windows_core::Interface::as_raw(self), dwcolors, ppalette).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnClipChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT, prgndata: *const super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnClipChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect, prgndata).ok()
    }
    pub unsafe fn OnColorKeyChange(&self, pcolorkey: *const COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnColorKeyChange)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    pub unsafe fn OnPositionChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnPositionChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect).ok()
    }
}
#[repr(C)]
pub struct IOverlayNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub OnPaletteChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    OnPaletteChange: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub OnClipChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT, *const super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    OnClipChange: usize,
    pub OnColorKeyChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const COLORKEY) -> ::windows_core::HRESULT,
    pub OnPositionChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IOverlayNotify2, IOverlayNotify2_Vtbl, 0x680efa10_d535_11d1_87c8_00a0c9223196);
::windows_core::imp::interface_hierarchy!(IOverlayNotify2, ::windows_core::IUnknown, IOverlayNotify);
impl IOverlayNotify2 {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnPaletteChange(&self, dwcolors: u32, ppalette: *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnPaletteChange)(::windows_core::Interface::as_raw(self), dwcolors, ppalette).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnClipChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT, prgndata: *const super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnClipChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect, prgndata).ok()
    }
    pub unsafe fn OnColorKeyChange(&self, pcolorkey: *const COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnColorKeyChange)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    pub unsafe fn OnPositionChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnPositionChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnDisplayChange<P0>(&self, hmonitor: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows_core::Interface::vtable(self).OnDisplayChange)(::windows_core::Interface::as_raw(self), hmonitor.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IOverlayNotify2_Vtbl {
    pub base__: IOverlayNotify_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub OnDisplayChange: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    OnDisplayChange: usize,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IPersistMediaPropertyBag, IPersistMediaPropertyBag_Vtbl, 0x5738e040_b67f_11d0_bd4d_00a0c911ce86);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IPersistMediaPropertyBag, ::windows_core::IUnknown, super::super::System::Com::IPersist);
#[cfg(feature = "Win32_System_Com")]
impl IPersistMediaPropertyBag {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn InitNew(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InitNew)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Load<P0, P1>(&self, ppropbag: P0, perrorlog: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaPropertyBag>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IErrorLog>,
    {
        (::windows_core::Interface::vtable(self).Load)(::windows_core::Interface::as_raw(self), ppropbag.into_param().abi(), perrorlog.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Save<P0, P1, P2>(&self, ppropbag: P0, fcleardirty: P1, fsaveallproperties: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaPropertyBag>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).Save)(::windows_core::Interface::as_raw(self), ppropbag.into_param().abi(), fcleardirty.into_param().abi(), fsaveallproperties.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IPersistMediaPropertyBag_Vtbl {
    pub base__: super::super::System::Com::IPersist_Vtbl,
    pub InitNew: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub Load: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com_StructuredStorage"))]
    Load: usize,
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub Save: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Foundation::BOOL, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com_StructuredStorage"))]
    Save: usize,
}
::windows_core::imp::com_interface!(IPin, IPin_Vtbl, 0x56a86891_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IPin, ::windows_core::IUnknown);
impl IPin {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn Connect<P0>(&self, preceivepin: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Connect)(::windows_core::Interface::as_raw(self), preceivepin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ReceiveConnection<P0>(&self, pconnector: P0, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).ReceiveConnection)(::windows_core::Interface::as_raw(self), pconnector.into_param().abi(), pmt).ok()
    }
    pub unsafe fn Disconnect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Disconnect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ConnectedTo(&self) -> ::windows_core::Result<IPin> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ConnectedTo)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn ConnectionMediaType(&self, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConnectionMediaType)(::windows_core::Interface::as_raw(self), pmt).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn QueryPinInfo(&self, pinfo: *mut PIN_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryPinInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
    pub unsafe fn QueryDirection(&self) -> ::windows_core::Result<PIN_DIRECTION> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryDirection)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn QueryId(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryId)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn QueryAccept(&self, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).QueryAccept)(::windows_core::Interface::as_raw(self), pmt)
    }
    pub unsafe fn EnumMediaTypes(&self) -> ::windows_core::Result<IEnumMediaTypes> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumMediaTypes)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn QueryInternalConnections(&self, appin: ::core::option::Option<*mut ::core::option::Option<IPin>>, npin: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryInternalConnections)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(appin.unwrap_or(::std::ptr::null_mut())), npin).ok()
    }
    pub unsafe fn EndOfStream(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndOfStream)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn BeginFlush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BeginFlush)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndFlush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndFlush)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn NewSegment(&self, tstart: i64, tstop: i64, drate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NewSegment)(::windows_core::Interface::as_raw(self), tstart, tstop, drate).ok()
    }
}
#[repr(C)]
pub struct IPin_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub Connect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    Connect: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub ReceiveConnection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    ReceiveConnection: usize,
    pub Disconnect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ConnectedTo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub ConnectionMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    ConnectionMediaType: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub QueryPinInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut PIN_INFO) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    QueryPinInfo: usize,
    pub QueryDirection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut PIN_DIRECTION) -> ::windows_core::HRESULT,
    pub QueryId: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub QueryAccept: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    QueryAccept: usize,
    pub EnumMediaTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub QueryInternalConnections: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub EndOfStream: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub BeginFlush: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EndFlush: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NewSegment: unsafe extern "system" fn(*mut ::core::ffi::c_void, i64, i64, f64) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IPinConnection, IPinConnection_Vtbl, 0x4a9a62d3_27d4_403d_91e9_89f540e55534);
::windows_core::imp::interface_hierarchy!(IPinConnection, ::windows_core::IUnknown);
impl IPinConnection {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn DynamicQueryAccept(&self, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DynamicQueryAccept)(::windows_core::Interface::as_raw(self), pmt).ok()
    }
    pub unsafe fn NotifyEndOfStream<P0>(&self, hnotifyevent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).NotifyEndOfStream)(::windows_core::Interface::as_raw(self), hnotifyevent.into_param().abi()).ok()
    }
    pub unsafe fn IsEndPin(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsEndPin)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn DynamicDisconnect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DynamicDisconnect)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IPinConnection_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub DynamicQueryAccept: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    DynamicQueryAccept: usize,
    pub NotifyEndOfStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    pub IsEndPin: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub DynamicDisconnect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IPinFlowControl, IPinFlowControl_Vtbl, 0xc56e9858_dbf3_4f6b_8119_384af2060deb);
::windows_core::imp::interface_hierarchy!(IPinFlowControl, ::windows_core::IUnknown);
impl IPinFlowControl {
    pub unsafe fn Block<P0>(&self, dwblockflags: u32, hevent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Block)(::windows_core::Interface::as_raw(self), dwblockflags, hevent.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IPinFlowControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Block: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IPinInfo, IPinInfo_Vtbl, 0x56a868bd_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IPinInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IPinInfo {
    pub unsafe fn Pin(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Pin)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ConnectedTo(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ConnectedTo)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ConnectionMediaType(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ConnectionMediaType)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FilterInfo(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FilterInfo)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Name(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Name)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Direction(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Direction)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn PinID(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PinID)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn MediaTypes(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MediaTypes)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Connect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).Connect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn ConnectDirect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).ConnectDirect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ConnectWithType<P0, P1>(&self, ppin: P0, pmediatype: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IDispatch>,
    {
        (::windows_core::Interface::vtable(self).ConnectWithType)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), pmediatype.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Disconnect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Render(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Render)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IPinInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Pin: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub ConnectedTo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ConnectedTo: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ConnectionMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ConnectionMediaType: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FilterInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FilterInfo: usize,
    pub Name: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Direction: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub PinID: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub MediaTypes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    MediaTypes: usize,
    pub Connect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ConnectDirect: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub ConnectWithType: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ConnectWithType: usize,
    pub Disconnect: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Render: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IQualProp, IQualProp_Vtbl, 0x1bd0ecb0_f8e2_11ce_aac6_0020af0b99a3);
::windows_core::imp::interface_hierarchy!(IQualProp, ::windows_core::IUnknown);
impl IQualProp {
    pub unsafe fn FramesDroppedInRenderer(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FramesDroppedInRenderer)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn FramesDrawn(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FramesDrawn)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AvgFrameRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvgFrameRate)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn Jitter(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Jitter)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn AvgSyncOffset(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvgSyncOffset)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn DevSyncOffset(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DevSyncOffset)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IQualProp_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub FramesDroppedInRenderer: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub FramesDrawn: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub AvgFrameRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub Jitter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub AvgSyncOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub DevSyncOffset: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IQualityControl, IQualityControl_Vtbl, 0x56a868a5_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IQualityControl, ::windows_core::IUnknown);
impl IQualityControl {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Notify<P0>(&self, pself: P0, q: Quality) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).Notify)(::windows_core::Interface::as_raw(self), pself.into_param().abi(), ::core::mem::transmute(q)).ok()
    }
    pub unsafe fn SetSink<P0>(&self, piqc: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IQualityControl>,
    {
        (::windows_core::Interface::vtable(self).SetSink)(::windows_core::Interface::as_raw(self), piqc.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IQualityControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Notify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, Quality) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Notify: usize,
    pub SetSink: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IQueueCommand, IQueueCommand_Vtbl, 0x56a868b7_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IQueueCommand, ::windows_core::IUnknown);
impl IQueueCommand {
    pub unsafe fn InvokeAtStreamTime(&self, pcmd: *mut ::core::option::Option<IDeferredCommand>, time: f64, iid: *const ::windows_core::GUID, dispidmethod: i32, wflags: i16, cargs: i32, pdispparams: *const ::windows_core::VARIANT, pvarresult: *mut ::windows_core::VARIANT, puargerr: *mut i16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InvokeAtStreamTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcmd), time, iid, dispidmethod, wflags, cargs, ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), puargerr).ok()
    }
    pub unsafe fn InvokeAtPresentationTime(&self, pcmd: *mut ::core::option::Option<IDeferredCommand>, time: f64, iid: *const ::windows_core::GUID, dispidmethod: i32, wflags: i16, cargs: i32, pdispparams: *const ::windows_core::VARIANT, pvarresult: *mut ::windows_core::VARIANT, puargerr: *mut i16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InvokeAtPresentationTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcmd), time, iid, dispidmethod, wflags, cargs, ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), puargerr).ok()
    }
}
#[repr(C)]
pub struct IQueueCommand_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub InvokeAtStreamTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, f64, *const ::windows_core::GUID, i32, i16, i32, *const ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut i16) -> ::windows_core::HRESULT,
    pub InvokeAtPresentationTime: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, f64, *const ::windows_core::GUID, i32, i16, i32, *const ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut ::std::mem::MaybeUninit<::windows_core::VARIANT>, *mut i16) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IRegFilterInfo, IRegFilterInfo_Vtbl, 0x56a868bb_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IRegFilterInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IRegFilterInfo {
    pub unsafe fn Name(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Name)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Filter(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Filter)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IRegFilterInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Name: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Filter: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Filter: usize,
}
::windows_core::imp::com_interface!(IRegisterServiceProvider, IRegisterServiceProvider_Vtbl, 0x7b3a2f01_0751_48dd_b556_004785171c54);
::windows_core::imp::interface_hierarchy!(IRegisterServiceProvider, ::windows_core::IUnknown);
impl IRegisterServiceProvider {
    pub unsafe fn RegisterService<P0>(&self, guidservice: *const ::windows_core::GUID, punkobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).RegisterService)(::windows_core::Interface::as_raw(self), guidservice, punkobject.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IRegisterServiceProvider_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RegisterService: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IResourceConsumer, IResourceConsumer_Vtbl, 0x56a868ad_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IResourceConsumer, ::windows_core::IUnknown);
impl IResourceConsumer {
    pub unsafe fn AcquireResource(&self, idresource: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AcquireResource)(::windows_core::Interface::as_raw(self), idresource).ok()
    }
    pub unsafe fn ReleaseResource(&self, idresource: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReleaseResource)(::windows_core::Interface::as_raw(self), idresource).ok()
    }
}
#[repr(C)]
pub struct IResourceConsumer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AcquireResource: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub ReleaseResource: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IResourceManager, IResourceManager_Vtbl, 0x56a868ac_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IResourceManager, ::windows_core::IUnknown);
impl IResourceManager {
    pub unsafe fn Register<P0>(&self, pname: P0, cresource: i32) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Register)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), cresource, &mut result__).map(|| result__)
    }
    pub unsafe fn RegisterGroup<P0>(&self, pname: P0, paltokens: &[i32]) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RegisterGroup)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), paltokens.len().try_into().unwrap(), ::core::mem::transmute(paltokens.as_ptr()), &mut result__).map(|| result__)
    }
    pub unsafe fn RequestResource<P0, P1>(&self, idresource: i32, pfocusobject: P0, pconsumer: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<IResourceConsumer>,
    {
        (::windows_core::Interface::vtable(self).RequestResource)(::windows_core::Interface::as_raw(self), idresource, pfocusobject.into_param().abi(), pconsumer.into_param().abi()).ok()
    }
    pub unsafe fn NotifyAcquire<P0>(&self, idresource: i32, pconsumer: P0, hr: ::windows_core::HRESULT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IResourceConsumer>,
    {
        (::windows_core::Interface::vtable(self).NotifyAcquire)(::windows_core::Interface::as_raw(self), idresource, pconsumer.into_param().abi(), hr).ok()
    }
    pub unsafe fn NotifyRelease<P0, P1>(&self, idresource: i32, pconsumer: P0, bstillwant: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IResourceConsumer>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).NotifyRelease)(::windows_core::Interface::as_raw(self), idresource, pconsumer.into_param().abi(), bstillwant.into_param().abi()).ok()
    }
    pub unsafe fn CancelRequest<P0>(&self, idresource: i32, pconsumer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IResourceConsumer>,
    {
        (::windows_core::Interface::vtable(self).CancelRequest)(::windows_core::Interface::as_raw(self), idresource, pconsumer.into_param().abi()).ok()
    }
    pub unsafe fn SetFocus<P0>(&self, pfocusobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).SetFocus)(::windows_core::Interface::as_raw(self), pfocusobject.into_param().abi()).ok()
    }
    pub unsafe fn ReleaseFocus<P0>(&self, pfocusobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).ReleaseFocus)(::windows_core::Interface::as_raw(self), pfocusobject.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IResourceManager_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Register: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, i32, *mut i32) -> ::windows_core::HRESULT,
    pub RegisterGroup: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::windows_core::PCWSTR, i32, *const i32, *mut i32) -> ::windows_core::HRESULT,
    pub RequestResource: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NotifyAcquire: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::core::ffi::c_void, ::windows_core::HRESULT) -> ::windows_core::HRESULT,
    pub NotifyRelease: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub CancelRequest: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetFocus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReleaseFocus: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ISeekingPassThru, ISeekingPassThru_Vtbl, 0x36b73883_c2c8_11cf_8b46_00805f6cef60);
::windows_core::imp::interface_hierarchy!(ISeekingPassThru, ::windows_core::IUnknown);
impl ISeekingPassThru {
    pub unsafe fn Init<P0, P1>(&self, bsupportrendering: P0, ppin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Init)(::windows_core::Interface::as_raw(self), bsupportrendering.into_param().abi(), ppin.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct ISeekingPassThru_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Init: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ISelector, ISelector_Vtbl, 0x1abdaeca_68b6_4f83_9371_b413907c7b9f);
::windows_core::imp::interface_hierarchy!(ISelector, ::windows_core::IUnknown);
impl ISelector {
    pub unsafe fn NumSources(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).NumSources)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SourceNodeId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceNodeId)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetSourceNodeId(&self, dwpinid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceNodeId)(::windows_core::Interface::as_raw(self), dwpinid).ok()
    }
}
#[repr(C)]
pub struct ISelector_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub NumSources: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SourceNodeId: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetSourceNodeId: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(ISpecifyParticularPages, ISpecifyParticularPages_Vtbl, 0x4c437b91_6e9e_11d1_a704_006097c4e476);
::windows_core::imp::interface_hierarchy!(ISpecifyParticularPages, ::windows_core::IUnknown);
impl ISpecifyParticularPages {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetPages(&self, guidwhatpages: *const ::windows_core::GUID) -> ::windows_core::Result<super::super::System::Ole::CAUUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPages)(::windows_core::Interface::as_raw(self), guidwhatpages, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct ISpecifyParticularPages_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetPages: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *mut super::super::System::Ole::CAUUID) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetPages: usize,
}
::windows_core::imp::com_interface!(IStreamBuilder, IStreamBuilder_Vtbl, 0x56a868bf_0ad4_11ce_b03a_0020af0ba770);
::windows_core::imp::interface_hierarchy!(IStreamBuilder, ::windows_core::IUnknown);
impl IStreamBuilder {
    pub unsafe fn Render<P0, P1>(&self, ppinout: P0, pgraph: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), pgraph.into_param().abi()).ok()
    }
    pub unsafe fn Backout<P0, P1>(&self, ppinout: P0, pgraph: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).Backout)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), pgraph.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IStreamBuilder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Render: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Backout: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IStreamSample, IStreamSample_Vtbl, 0xb502d1be_9a57_11d0_8fde_00c04fd9189d);
::windows_core::imp::interface_hierarchy!(IStreamSample, ::windows_core::IUnknown);
impl IStreamSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
}
#[repr(C)]
pub struct IStreamSample_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMediaStream: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetSampleTimes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i64, *mut i64, *mut i64) -> ::windows_core::HRESULT,
    pub SetSampleTimes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const i64, *const i64) -> ::windows_core::HRESULT,
    pub Update: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, super::super::Foundation::HANDLE, super::super::Foundation::PAPCFUNC, usize) -> ::windows_core::HRESULT,
    pub CompletionStatus: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRAspectRatioControl, IVMRAspectRatioControl_Vtbl, 0xede80b5c_bad6_4623_b537_65586c9f8dfd);
::windows_core::imp::interface_hierarchy!(IVMRAspectRatioControl, ::windows_core::IUnknown);
impl IVMRAspectRatioControl {
    pub unsafe fn GetAspectRatioMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAspectRatioMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAspectRatioMode(&self, dwarmode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAspectRatioMode)(::windows_core::Interface::as_raw(self), dwarmode).ok()
    }
}
#[repr(C)]
pub struct IVMRAspectRatioControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRAspectRatioControl9, IVMRAspectRatioControl9_Vtbl, 0x00d96c29_bbde_4efc_9901_bb5036392146);
::windows_core::imp::interface_hierarchy!(IVMRAspectRatioControl9, ::windows_core::IUnknown);
impl IVMRAspectRatioControl9 {
    pub unsafe fn GetAspectRatioMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAspectRatioMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAspectRatioMode(&self, dwarmode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAspectRatioMode)(::windows_core::Interface::as_raw(self), dwarmode).ok()
    }
}
#[repr(C)]
pub struct IVMRAspectRatioControl9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRDeinterlaceControl, IVMRDeinterlaceControl_Vtbl, 0xbb057577_0db8_4e6a_87a7_1a8c9a505a0f);
::windows_core::imp::interface_hierarchy!(IVMRDeinterlaceControl, ::windows_core::IUnknown);
impl IVMRDeinterlaceControl {
    pub unsafe fn GetNumberOfDeinterlaceModes(&self, lpvideodescription: *const VMRVideoDesc, lpdwnumdeinterlacemodes: *mut u32, lpdeinterlacemodes: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNumberOfDeinterlaceModes)(::windows_core::Interface::as_raw(self), lpvideodescription, lpdwnumdeinterlacemodes, lpdeinterlacemodes).ok()
    }
    pub unsafe fn GetDeinterlaceModeCaps(&self, lpdeinterlacemode: *const ::windows_core::GUID, lpvideodescription: *const VMRVideoDesc, lpdeinterlacecaps: *mut VMRDeinterlaceCaps) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDeinterlaceModeCaps)(::windows_core::Interface::as_raw(self), lpdeinterlacemode, lpvideodescription, lpdeinterlacecaps).ok()
    }
    pub unsafe fn GetDeinterlaceMode(&self, dwstreamid: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDeinterlaceMode)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetDeinterlaceMode(&self, dwstreamid: u32, lpdeinterlacemode: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDeinterlaceMode)(::windows_core::Interface::as_raw(self), dwstreamid, lpdeinterlacemode).ok()
    }
    pub unsafe fn GetDeinterlacePrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDeinterlacePrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDeinterlacePrefs(&self, dwdeinterlaceprefs: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDeinterlacePrefs)(::windows_core::Interface::as_raw(self), dwdeinterlaceprefs).ok()
    }
    pub unsafe fn GetActualDeinterlaceMode(&self, dwstreamid: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetActualDeinterlaceMode)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRDeinterlaceControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNumberOfDeinterlaceModes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMRVideoDesc, *mut u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDeinterlaceModeCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const VMRVideoDesc, *mut VMRDeinterlaceCaps) -> ::windows_core::HRESULT,
    pub GetDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDeinterlacePrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDeinterlacePrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetActualDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRDeinterlaceControl9, IVMRDeinterlaceControl9_Vtbl, 0xa215fb8d_13c2_4f7f_993c_003d6271a459);
::windows_core::imp::interface_hierarchy!(IVMRDeinterlaceControl9, ::windows_core::IUnknown);
impl IVMRDeinterlaceControl9 {
    pub unsafe fn GetNumberOfDeinterlaceModes(&self, lpvideodescription: *const VMR9VideoDesc, lpdwnumdeinterlacemodes: *mut u32, lpdeinterlacemodes: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNumberOfDeinterlaceModes)(::windows_core::Interface::as_raw(self), lpvideodescription, lpdwnumdeinterlacemodes, lpdeinterlacemodes).ok()
    }
    pub unsafe fn GetDeinterlaceModeCaps(&self, lpdeinterlacemode: *const ::windows_core::GUID, lpvideodescription: *const VMR9VideoDesc, lpdeinterlacecaps: *mut VMR9DeinterlaceCaps) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDeinterlaceModeCaps)(::windows_core::Interface::as_raw(self), lpdeinterlacemode, lpvideodescription, lpdeinterlacecaps).ok()
    }
    pub unsafe fn GetDeinterlaceMode(&self, dwstreamid: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDeinterlaceMode)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetDeinterlaceMode(&self, dwstreamid: u32, lpdeinterlacemode: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDeinterlaceMode)(::windows_core::Interface::as_raw(self), dwstreamid, lpdeinterlacemode).ok()
    }
    pub unsafe fn GetDeinterlacePrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDeinterlacePrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDeinterlacePrefs(&self, dwdeinterlaceprefs: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDeinterlacePrefs)(::windows_core::Interface::as_raw(self), dwdeinterlaceprefs).ok()
    }
    pub unsafe fn GetActualDeinterlaceMode(&self, dwstreamid: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetActualDeinterlaceMode)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRDeinterlaceControl9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNumberOfDeinterlaceModes: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMR9VideoDesc, *mut u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDeinterlaceModeCaps: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const ::windows_core::GUID, *const VMR9VideoDesc, *mut VMR9DeinterlaceCaps) -> ::windows_core::HRESULT,
    pub GetDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDeinterlacePrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDeinterlacePrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetActualDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRFilterConfig, IVMRFilterConfig_Vtbl, 0x9e5530c5_7034_48b4_bb46_0b8a6efc8e36);
::windows_core::imp::interface_hierarchy!(IVMRFilterConfig, ::windows_core::IUnknown);
impl IVMRFilterConfig {
    pub unsafe fn SetImageCompositor<P0>(&self, lpvmrimgcompositor: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRImageCompositor>,
    {
        (::windows_core::Interface::vtable(self).SetImageCompositor)(::windows_core::Interface::as_raw(self), lpvmrimgcompositor.into_param().abi()).ok()
    }
    pub unsafe fn SetNumberOfStreams(&self, dwmaxstreams: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetNumberOfStreams)(::windows_core::Interface::as_raw(self), dwmaxstreams).ok()
    }
    pub unsafe fn GetNumberOfStreams(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumberOfStreams)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRenderingPrefs(&self, dwrenderflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRenderingPrefs)(::windows_core::Interface::as_raw(self), dwrenderflags).ok()
    }
    pub unsafe fn GetRenderingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRenderingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRenderingMode(&self, mode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRenderingMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn GetRenderingMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRenderingMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRFilterConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetImageCompositor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetNumberOfStreams: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetNumberOfStreams: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetRenderingMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRenderingMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRFilterConfig9, IVMRFilterConfig9_Vtbl, 0x5a804648_4f66_4867_9c43_4f5c822cf1b8);
::windows_core::imp::interface_hierarchy!(IVMRFilterConfig9, ::windows_core::IUnknown);
impl IVMRFilterConfig9 {
    pub unsafe fn SetImageCompositor<P0>(&self, lpvmrimgcompositor: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRImageCompositor9>,
    {
        (::windows_core::Interface::vtable(self).SetImageCompositor)(::windows_core::Interface::as_raw(self), lpvmrimgcompositor.into_param().abi()).ok()
    }
    pub unsafe fn SetNumberOfStreams(&self, dwmaxstreams: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetNumberOfStreams)(::windows_core::Interface::as_raw(self), dwmaxstreams).ok()
    }
    pub unsafe fn GetNumberOfStreams(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumberOfStreams)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRenderingPrefs(&self, dwrenderflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRenderingPrefs)(::windows_core::Interface::as_raw(self), dwrenderflags).ok()
    }
    pub unsafe fn GetRenderingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRenderingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetRenderingMode(&self, mode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRenderingMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn GetRenderingMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRenderingMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRFilterConfig9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetImageCompositor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetNumberOfStreams: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetNumberOfStreams: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetRenderingMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRenderingMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRImageCompositor, IVMRImageCompositor_Vtbl, 0x7a4fb5af_479f_4074_bb40_ce6722e43c82);
::windows_core::imp::interface_hierarchy!(IVMRImageCompositor, ::windows_core::IUnknown);
impl IVMRImageCompositor {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn InitCompositionTarget<P0, P1>(&self, pd3ddevice: P0, pddsrendertarget: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface7>,
    {
        (::windows_core::Interface::vtable(self).InitCompositionTarget)(::windows_core::Interface::as_raw(self), pd3ddevice.into_param().abi(), pddsrendertarget.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn TermCompositionTarget<P0, P1>(&self, pd3ddevice: P0, pddsrendertarget: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface7>,
    {
        (::windows_core::Interface::vtable(self).TermCompositionTarget)(::windows_core::Interface::as_raw(self), pd3ddevice.into_param().abi(), pddsrendertarget.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetStreamMediaType<P0>(&self, dwstrmid: u32, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE, ftexture: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetStreamMediaType)(::windows_core::Interface::as_raw(self), dwstrmid, pmt, ftexture.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn CompositeImage<P0, P1>(&self, pd3ddevice: P0, pddsrendertarget: P1, pmtrendertarget: *const super::MediaFoundation::AM_MEDIA_TYPE, rtstart: i64, rtend: i64, dwclrbkgnd: u32, pvideostreaminfo: *const VMRVIDEOSTREAMINFO, cstreams: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface7>,
    {
        (::windows_core::Interface::vtable(self).CompositeImage)(::windows_core::Interface::as_raw(self), pd3ddevice.into_param().abi(), pddsrendertarget.into_param().abi(), pmtrendertarget, rtstart, rtend, dwclrbkgnd, pvideostreaminfo, cstreams).ok()
    }
}
#[repr(C)]
pub struct IVMRImageCompositor_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub InitCompositionTarget: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    InitCompositionTarget: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub TermCompositionTarget: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    TermCompositionTarget: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetStreamMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const super::MediaFoundation::AM_MEDIA_TYPE, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetStreamMediaType: usize,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Media_MediaFoundation"))]
    pub CompositeImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE, i64, i64, u32, *const VMRVIDEOSTREAMINFO, u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Media_MediaFoundation")))]
    CompositeImage: usize,
}
::windows_core::imp::com_interface!(IVMRImageCompositor9, IVMRImageCompositor9_Vtbl, 0x4a5c89eb_df51_4654_ac2a_e48e02bbabf6);
::windows_core::imp::interface_hierarchy!(IVMRImageCompositor9, ::windows_core::IUnknown);
impl IVMRImageCompositor9 {
    pub unsafe fn InitCompositionDevice<P0>(&self, pd3ddevice: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).InitCompositionDevice)(::windows_core::Interface::as_raw(self), pd3ddevice.into_param().abi()).ok()
    }
    pub unsafe fn TermCompositionDevice<P0>(&self, pd3ddevice: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).TermCompositionDevice)(::windows_core::Interface::as_raw(self), pd3ddevice.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetStreamMediaType<P0>(&self, dwstrmid: u32, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE, ftexture: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetStreamMediaType)(::windows_core::Interface::as_raw(self), dwstrmid, pmt, ftexture.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn CompositeImage<P0, P1>(&self, pd3ddevice: P0, pddsrendertarget: P1, pmtrendertarget: *const super::MediaFoundation::AM_MEDIA_TYPE, rtstart: i64, rtend: i64, dwclrbkgnd: u32, pvideostreaminfo: *const VMR9VideoStreamInfo, cstreams: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        (::windows_core::Interface::vtable(self).CompositeImage)(::windows_core::Interface::as_raw(self), pd3ddevice.into_param().abi(), pddsrendertarget.into_param().abi(), pmtrendertarget, rtstart, rtend, dwclrbkgnd, pvideostreaminfo, cstreams).ok()
    }
}
#[repr(C)]
pub struct IVMRImageCompositor9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub InitCompositionDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub TermCompositionDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetStreamMediaType: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const super::MediaFoundation::AM_MEDIA_TYPE, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetStreamMediaType: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
    pub CompositeImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE, i64, i64, u32, *const VMR9VideoStreamInfo, u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation")))]
    CompositeImage: usize,
}
::windows_core::imp::com_interface!(IVMRImagePresenter, IVMRImagePresenter_Vtbl, 0xce704fe7_e71e_41fb_baa2_c4403e1182f5);
::windows_core::imp::interface_hierarchy!(IVMRImagePresenter, ::windows_core::IUnknown);
impl IVMRImagePresenter {
    pub unsafe fn StartPresenting(&self, dwuserid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StartPresenting)(::windows_core::Interface::as_raw(self), dwuserid).ok()
    }
    pub unsafe fn StopPresenting(&self, dwuserid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StopPresenting)(::windows_core::Interface::as_raw(self), dwuserid).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn PresentImage(&self, dwuserid: usize, lppresinfo: *const VMRPRESENTATIONINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PresentImage)(::windows_core::Interface::as_raw(self), dwuserid, lppresinfo).ok()
    }
}
#[repr(C)]
pub struct IVMRImagePresenter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub StartPresenting: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    pub StopPresenting: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub PresentImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *const VMRPRESENTATIONINFO) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    PresentImage: usize,
}
::windows_core::imp::com_interface!(IVMRImagePresenter9, IVMRImagePresenter9_Vtbl, 0x69188c61_12a3_40f0_8ffc_342e7b433fd7);
::windows_core::imp::interface_hierarchy!(IVMRImagePresenter9, ::windows_core::IUnknown);
impl IVMRImagePresenter9 {
    pub unsafe fn StartPresenting(&self, dwuserid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StartPresenting)(::windows_core::Interface::as_raw(self), dwuserid).ok()
    }
    pub unsafe fn StopPresenting(&self, dwuserid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StopPresenting)(::windows_core::Interface::as_raw(self), dwuserid).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn PresentImage(&self, dwuserid: usize, lppresinfo: *const VMR9PresentationInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PresentImage)(::windows_core::Interface::as_raw(self), dwuserid, lppresinfo).ok()
    }
}
#[repr(C)]
pub struct IVMRImagePresenter9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub StartPresenting: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    pub StopPresenting: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub PresentImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *const VMR9PresentationInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    PresentImage: usize,
}
::windows_core::imp::com_interface!(IVMRImagePresenterConfig, IVMRImagePresenterConfig_Vtbl, 0x9f3a1c85_8555_49ba_935f_be5b5b29d178);
::windows_core::imp::interface_hierarchy!(IVMRImagePresenterConfig, ::windows_core::IUnknown);
impl IVMRImagePresenterConfig {
    pub unsafe fn SetRenderingPrefs(&self, dwrenderflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRenderingPrefs)(::windows_core::Interface::as_raw(self), dwrenderflags).ok()
    }
    pub unsafe fn GetRenderingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRenderingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRImagePresenterConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRImagePresenterConfig9, IVMRImagePresenterConfig9_Vtbl, 0x45c15cab_6e22_420a_8043_ae1f0ac02c7d);
::windows_core::imp::interface_hierarchy!(IVMRImagePresenterConfig9, ::windows_core::IUnknown);
impl IVMRImagePresenterConfig9 {
    pub unsafe fn SetRenderingPrefs(&self, dwrenderflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRenderingPrefs)(::windows_core::Interface::as_raw(self), dwrenderflags).ok()
    }
    pub unsafe fn GetRenderingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRenderingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRImagePresenterConfig9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetRenderingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRImagePresenterExclModeConfig, IVMRImagePresenterExclModeConfig_Vtbl, 0xe6f7ce40_4673_44f1_8f77_5499d68cb4ea);
::windows_core::imp::interface_hierarchy!(IVMRImagePresenterExclModeConfig, ::windows_core::IUnknown, IVMRImagePresenterConfig);
impl IVMRImagePresenterExclModeConfig {
    pub unsafe fn SetRenderingPrefs(&self, dwrenderflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetRenderingPrefs)(::windows_core::Interface::as_raw(self), dwrenderflags).ok()
    }
    pub unsafe fn GetRenderingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetRenderingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetXlcModeDDObjAndPrimarySurface<P0, P1>(&self, lpddobj: P0, lpprimarysurf: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw7>,
        P1: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface7>,
    {
        (::windows_core::Interface::vtable(self).SetXlcModeDDObjAndPrimarySurface)(::windows_core::Interface::as_raw(self), lpddobj.into_param().abi(), lpprimarysurf.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetXlcModeDDObjAndPrimarySurface(&self, lpddobj: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDraw7>, lpprimarysurf: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface7>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetXlcModeDDObjAndPrimarySurface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(lpddobj), ::core::mem::transmute(lpprimarysurf)).ok()
    }
}
#[repr(C)]
pub struct IVMRImagePresenterExclModeConfig_Vtbl {
    pub base__: IVMRImagePresenterConfig_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetXlcModeDDObjAndPrimarySurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetXlcModeDDObjAndPrimarySurface: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetXlcModeDDObjAndPrimarySurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetXlcModeDDObjAndPrimarySurface: usize,
}
::windows_core::imp::com_interface!(IVMRMixerBitmap, IVMRMixerBitmap_Vtbl, 0x1e673275_0257_40aa_af20_7c608d4a0428);
::windows_core::imp::interface_hierarchy!(IVMRMixerBitmap, ::windows_core::IUnknown);
impl IVMRMixerBitmap {
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn SetAlphaBitmap(&self, pbmpparms: *const VMRALPHABITMAP) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAlphaBitmap)(::windows_core::Interface::as_raw(self), pbmpparms).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn UpdateAlphaBitmapParameters(&self, pbmpparms: *const VMRALPHABITMAP) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UpdateAlphaBitmapParameters)(::windows_core::Interface::as_raw(self), pbmpparms).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn GetAlphaBitmapParameters(&self, pbmpparms: *mut VMRALPHABITMAP) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAlphaBitmapParameters)(::windows_core::Interface::as_raw(self), pbmpparms).ok()
    }
}
#[repr(C)]
pub struct IVMRMixerBitmap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub SetAlphaBitmap: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMRALPHABITMAP) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi")))]
    SetAlphaBitmap: usize,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub UpdateAlphaBitmapParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMRALPHABITMAP) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi")))]
    UpdateAlphaBitmapParameters: usize,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub GetAlphaBitmapParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut VMRALPHABITMAP) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi")))]
    GetAlphaBitmapParameters: usize,
}
::windows_core::imp::com_interface!(IVMRMixerBitmap9, IVMRMixerBitmap9_Vtbl, 0xced175e5_1935_4820_81bd_ff6ad00c9108);
::windows_core::imp::interface_hierarchy!(IVMRMixerBitmap9, ::windows_core::IUnknown);
impl IVMRMixerBitmap9 {
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn SetAlphaBitmap(&self, pbmpparms: *const VMR9AlphaBitmap) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAlphaBitmap)(::windows_core::Interface::as_raw(self), pbmpparms).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn UpdateAlphaBitmapParameters(&self, pbmpparms: *const VMR9AlphaBitmap) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UpdateAlphaBitmapParameters)(::windows_core::Interface::as_raw(self), pbmpparms).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn GetAlphaBitmapParameters(&self, pbmpparms: *mut VMR9AlphaBitmap) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAlphaBitmapParameters)(::windows_core::Interface::as_raw(self), pbmpparms).ok()
    }
}
#[repr(C)]
pub struct IVMRMixerBitmap9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub SetAlphaBitmap: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMR9AlphaBitmap) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi")))]
    SetAlphaBitmap: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub UpdateAlphaBitmapParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMR9AlphaBitmap) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi")))]
    UpdateAlphaBitmapParameters: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub GetAlphaBitmapParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut VMR9AlphaBitmap) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi")))]
    GetAlphaBitmapParameters: usize,
}
::windows_core::imp::com_interface!(IVMRMixerControl, IVMRMixerControl_Vtbl, 0x1c1a17b0_bed0_415d_974b_dc6696131599);
::windows_core::imp::interface_hierarchy!(IVMRMixerControl, ::windows_core::IUnknown);
impl IVMRMixerControl {
    pub unsafe fn SetAlpha(&self, dwstreamid: u32, alpha: f32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAlpha)(::windows_core::Interface::as_raw(self), dwstreamid, alpha).ok()
    }
    pub unsafe fn GetAlpha(&self, dwstreamid: u32) -> ::windows_core::Result<f32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAlpha)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetZOrder(&self, dwstreamid: u32, dwz: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetZOrder)(::windows_core::Interface::as_raw(self), dwstreamid, dwz).ok()
    }
    pub unsafe fn GetZOrder(&self, dwstreamid: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetZOrder)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputRect(&self, dwstreamid: u32, prect: *const NORMALIZEDRECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputRect)(::windows_core::Interface::as_raw(self), dwstreamid, prect).ok()
    }
    pub unsafe fn GetOutputRect(&self, dwstreamid: u32) -> ::windows_core::Result<NORMALIZEDRECT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOutputRect)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetBackgroundClr<P0>(&self, clrbkg: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::COLORREF>,
    {
        (::windows_core::Interface::vtable(self).SetBackgroundClr)(::windows_core::Interface::as_raw(self), clrbkg.into_param().abi()).ok()
    }
    pub unsafe fn GetBackgroundClr(&self, lpclrbkg: *const super::super::Foundation::COLORREF) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBackgroundClr)(::windows_core::Interface::as_raw(self), lpclrbkg).ok()
    }
    pub unsafe fn SetMixingPrefs(&self, dwmixerprefs: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMixingPrefs)(::windows_core::Interface::as_raw(self), dwmixerprefs).ok()
    }
    pub unsafe fn GetMixingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMixingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRMixerControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetAlpha: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, f32) -> ::windows_core::HRESULT,
    pub GetAlpha: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut f32) -> ::windows_core::HRESULT,
    pub SetZOrder: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
    pub GetZOrder: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub SetOutputRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const NORMALIZEDRECT) -> ::windows_core::HRESULT,
    pub GetOutputRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut NORMALIZEDRECT) -> ::windows_core::HRESULT,
    pub SetBackgroundClr: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub GetBackgroundClr: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub SetMixingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMixingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRMixerControl9, IVMRMixerControl9_Vtbl, 0x1a777eaa_47c8_4930_b2c9_8fee1c1b0f3b);
::windows_core::imp::interface_hierarchy!(IVMRMixerControl9, ::windows_core::IUnknown);
impl IVMRMixerControl9 {
    pub unsafe fn SetAlpha(&self, dwstreamid: u32, alpha: f32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAlpha)(::windows_core::Interface::as_raw(self), dwstreamid, alpha).ok()
    }
    pub unsafe fn GetAlpha(&self, dwstreamid: u32) -> ::windows_core::Result<f32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAlpha)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetZOrder(&self, dwstreamid: u32, dwz: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetZOrder)(::windows_core::Interface::as_raw(self), dwstreamid, dwz).ok()
    }
    pub unsafe fn GetZOrder(&self, dwstreamid: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetZOrder)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetOutputRect(&self, dwstreamid: u32, prect: *const VMR9NormalizedRect) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputRect)(::windows_core::Interface::as_raw(self), dwstreamid, prect).ok()
    }
    pub unsafe fn GetOutputRect(&self, dwstreamid: u32) -> ::windows_core::Result<VMR9NormalizedRect> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOutputRect)(::windows_core::Interface::as_raw(self), dwstreamid, &mut result__).map(|| result__)
    }
    pub unsafe fn SetBackgroundClr<P0>(&self, clrbkg: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::COLORREF>,
    {
        (::windows_core::Interface::vtable(self).SetBackgroundClr)(::windows_core::Interface::as_raw(self), clrbkg.into_param().abi()).ok()
    }
    pub unsafe fn GetBackgroundClr(&self, lpclrbkg: *const super::super::Foundation::COLORREF) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBackgroundClr)(::windows_core::Interface::as_raw(self), lpclrbkg).ok()
    }
    pub unsafe fn SetMixingPrefs(&self, dwmixerprefs: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMixingPrefs)(::windows_core::Interface::as_raw(self), dwmixerprefs).ok()
    }
    pub unsafe fn GetMixingPrefs(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMixingPrefs)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetProcAmpControl(&self, dwstreamid: u32, lpclrcontrol: *const VMR9ProcAmpControl) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProcAmpControl)(::windows_core::Interface::as_raw(self), dwstreamid, lpclrcontrol).ok()
    }
    pub unsafe fn GetProcAmpControl(&self, dwstreamid: u32, lpclrcontrol: *mut VMR9ProcAmpControl) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetProcAmpControl)(::windows_core::Interface::as_raw(self), dwstreamid, lpclrcontrol).ok()
    }
    pub unsafe fn GetProcAmpControlRange(&self, dwstreamid: u32, lpclrcontrol: *mut VMR9ProcAmpControlRange) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetProcAmpControlRange)(::windows_core::Interface::as_raw(self), dwstreamid, lpclrcontrol).ok()
    }
}
#[repr(C)]
pub struct IVMRMixerControl9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetAlpha: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, f32) -> ::windows_core::HRESULT,
    pub GetAlpha: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut f32) -> ::windows_core::HRESULT,
    pub SetZOrder: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32) -> ::windows_core::HRESULT,
    pub GetZOrder: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut u32) -> ::windows_core::HRESULT,
    pub SetOutputRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const VMR9NormalizedRect) -> ::windows_core::HRESULT,
    pub GetOutputRect: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut VMR9NormalizedRect) -> ::windows_core::HRESULT,
    pub SetBackgroundClr: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub GetBackgroundClr: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub SetMixingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMixingPrefs: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetProcAmpControl: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *const VMR9ProcAmpControl) -> ::windows_core::HRESULT,
    pub GetProcAmpControl: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut VMR9ProcAmpControl) -> ::windows_core::HRESULT,
    pub GetProcAmpControlRange: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut VMR9ProcAmpControlRange) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRMonitorConfig, IVMRMonitorConfig_Vtbl, 0x9cf0b1b6_fbaa_4b7f_88cf_cf1f130a0dce);
::windows_core::imp::interface_hierarchy!(IVMRMonitorConfig, ::windows_core::IUnknown);
impl IVMRMonitorConfig {
    pub unsafe fn SetMonitor(&self, pguid: *const VMRGUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMonitor)(::windows_core::Interface::as_raw(self), pguid).ok()
    }
    pub unsafe fn GetMonitor(&self, pguid: *mut VMRGUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMonitor)(::windows_core::Interface::as_raw(self), pguid).ok()
    }
    pub unsafe fn SetDefaultMonitor(&self, pguid: *const VMRGUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultMonitor)(::windows_core::Interface::as_raw(self), pguid).ok()
    }
    pub unsafe fn GetDefaultMonitor(&self, pguid: *mut VMRGUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDefaultMonitor)(::windows_core::Interface::as_raw(self), pguid).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableMonitors(&self, pinfo: &mut [VMRMONITORINFO], pdwnumdevices: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAvailableMonitors)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pinfo.as_ptr()), pinfo.len().try_into().unwrap(), pdwnumdevices).ok()
    }
}
#[repr(C)]
pub struct IVMRMonitorConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMRGUID) -> ::windows_core::HRESULT,
    pub GetMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut VMRGUID) -> ::windows_core::HRESULT,
    pub SetDefaultMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMRGUID) -> ::windows_core::HRESULT,
    pub GetDefaultMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut VMRGUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableMonitors: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut VMRMONITORINFO, u32, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableMonitors: usize,
}
::windows_core::imp::com_interface!(IVMRMonitorConfig9, IVMRMonitorConfig9_Vtbl, 0x46c2e457_8ba0_4eef_b80b_0680f0978749);
::windows_core::imp::interface_hierarchy!(IVMRMonitorConfig9, ::windows_core::IUnknown);
impl IVMRMonitorConfig9 {
    pub unsafe fn SetMonitor(&self, udev: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMonitor)(::windows_core::Interface::as_raw(self), udev).ok()
    }
    pub unsafe fn GetMonitor(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMonitor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetDefaultMonitor(&self, udev: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultMonitor)(::windows_core::Interface::as_raw(self), udev).ok()
    }
    pub unsafe fn GetDefaultMonitor(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultMonitor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableMonitors(&self, pinfo: &mut [VMR9MonitorInfo], pdwnumdevices: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAvailableMonitors)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pinfo.as_ptr()), pinfo.len().try_into().unwrap(), pdwnumdevices).ok()
    }
}
#[repr(C)]
pub struct IVMRMonitorConfig9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetDefaultMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetDefaultMonitor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableMonitors: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut VMR9MonitorInfo, u32, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableMonitors: usize,
}
::windows_core::imp::com_interface!(IVMRSurface, IVMRSurface_Vtbl, 0xa9849bbe_9ec8_4263_b764_62730f0d15d0);
::windows_core::imp::interface_hierarchy!(IVMRSurface, ::windows_core::IUnknown);
impl IVMRSurface {
    pub unsafe fn IsSurfaceLocked(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsSurfaceLocked)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn LockSurface(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).LockSurface)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn UnlockSurface(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnlockSurface)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetSurface(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDrawSurface7> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IVMRSurface_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub IsSurfaceLocked: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LockSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub UnlockSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetSurface: usize,
}
::windows_core::imp::com_interface!(IVMRSurface9, IVMRSurface9_Vtbl, 0xdfc581a1_6e1f_4c3a_8d0a_5e9792ea2afc);
::windows_core::imp::interface_hierarchy!(IVMRSurface9, ::windows_core::IUnknown);
impl IVMRSurface9 {
    pub unsafe fn IsSurfaceLocked(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsSurfaceLocked)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn LockSurface(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).LockSurface)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn UnlockSurface(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnlockSurface)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetSurface(&self) -> ::windows_core::Result<super::super::Graphics::Direct3D9::IDirect3DSurface9> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
}
#[repr(C)]
pub struct IVMRSurface9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub IsSurfaceLocked: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LockSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub UnlockSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetSurface: usize,
}
::windows_core::imp::com_interface!(IVMRSurfaceAllocator, IVMRSurfaceAllocator_Vtbl, 0x31ce832e_4484_458b_8cca_f4d7e3db0b52);
::windows_core::imp::interface_hierarchy!(IVMRSurfaceAllocator, ::windows_core::IUnknown);
impl IVMRSurfaceAllocator {
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn AllocateSurface(&self, dwuserid: usize, lpallocinfo: *const VMRALLOCATIONINFO, lpdwactualbuffers: *mut u32, lplpsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface7>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AllocateSurface)(::windows_core::Interface::as_raw(self), dwuserid, lpallocinfo, lpdwactualbuffers, ::core::mem::transmute(lplpsurface)).ok()
    }
    pub unsafe fn FreeSurface(&self, dwid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FreeSurface)(::windows_core::Interface::as_raw(self), dwid).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn PrepareSurface<P0>(&self, dwuserid: usize, lpsurface: P0, dwsurfaceflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface7>,
    {
        (::windows_core::Interface::vtable(self).PrepareSurface)(::windows_core::Interface::as_raw(self), dwuserid, lpsurface.into_param().abi(), dwsurfaceflags).ok()
    }
    pub unsafe fn AdviseNotify<P0>(&self, lpivmrsurfallocnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRSurfaceAllocatorNotify>,
    {
        (::windows_core::Interface::vtable(self).AdviseNotify)(::windows_core::Interface::as_raw(self), lpivmrsurfallocnotify.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IVMRSurfaceAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub AllocateSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *const VMRALLOCATIONINFO, *mut u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi")))]
    AllocateSurface: usize,
    pub FreeSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub PrepareSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    PrepareSurface: usize,
    pub AdviseNotify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRSurfaceAllocator9, IVMRSurfaceAllocator9_Vtbl, 0x8d5148ea_3f5d_46cf_9df1_d1b896eedb1f);
::windows_core::imp::interface_hierarchy!(IVMRSurfaceAllocator9, ::windows_core::IUnknown);
impl IVMRSurfaceAllocator9 {
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn InitializeDevice(&self, dwuserid: usize, lpallocinfo: *const VMR9AllocationInfo, lpnumbuffers: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InitializeDevice)(::windows_core::Interface::as_raw(self), dwuserid, lpallocinfo, lpnumbuffers).ok()
    }
    pub unsafe fn TerminateDevice(&self, dwid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TerminateDevice)(::windows_core::Interface::as_raw(self), dwid).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetSurface(&self, dwuserid: usize, surfaceindex: u32, surfaceflags: u32) -> ::windows_core::Result<super::super::Graphics::Direct3D9::IDirect3DSurface9> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), dwuserid, surfaceindex, surfaceflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AdviseNotify<P0>(&self, lpivmrsurfallocnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRSurfaceAllocatorNotify9>,
    {
        (::windows_core::Interface::vtable(self).AdviseNotify)(::windows_core::Interface::as_raw(self), lpivmrsurfallocnotify.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IVMRSurfaceAllocator9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub InitializeDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *const VMR9AllocationInfo, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    InitializeDevice: usize,
    pub TerminateDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetSurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, u32, u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetSurface: usize,
    pub AdviseNotify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRSurfaceAllocatorEx9, IVMRSurfaceAllocatorEx9_Vtbl, 0x6de9a68a_a928_4522_bf57_655ae3866456);
::windows_core::imp::interface_hierarchy!(IVMRSurfaceAllocatorEx9, ::windows_core::IUnknown, IVMRSurfaceAllocator9);
impl IVMRSurfaceAllocatorEx9 {
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn InitializeDevice(&self, dwuserid: usize, lpallocinfo: *const VMR9AllocationInfo, lpnumbuffers: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InitializeDevice)(::windows_core::Interface::as_raw(self), dwuserid, lpallocinfo, lpnumbuffers).ok()
    }
    pub unsafe fn TerminateDevice(&self, dwid: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.TerminateDevice)(::windows_core::Interface::as_raw(self), dwid).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetSurface(&self, dwuserid: usize, surfaceindex: u32, surfaceflags: u32) -> ::windows_core::Result<super::super::Graphics::Direct3D9::IDirect3DSurface9> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetSurface)(::windows_core::Interface::as_raw(self), dwuserid, surfaceindex, surfaceflags, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn AdviseNotify<P0>(&self, lpivmrsurfallocnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRSurfaceAllocatorNotify9>,
    {
        (::windows_core::Interface::vtable(self).base__.AdviseNotify)(::windows_core::Interface::as_raw(self), lpivmrsurfallocnotify.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetSurfaceEx(&self, dwuserid: usize, surfaceindex: u32, surfaceflags: u32, lplpsurface: *mut ::core::option::Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>, lprcdst: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurfaceEx)(::windows_core::Interface::as_raw(self), dwuserid, surfaceindex, surfaceflags, ::core::mem::transmute(lplpsurface), lprcdst).ok()
    }
}
#[repr(C)]
pub struct IVMRSurfaceAllocatorEx9_Vtbl {
    pub base__: IVMRSurfaceAllocator9_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetSurfaceEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, u32, u32, *mut *mut ::core::ffi::c_void, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetSurfaceEx: usize,
}
::windows_core::imp::com_interface!(IVMRSurfaceAllocatorNotify, IVMRSurfaceAllocatorNotify_Vtbl, 0xaada05a8_5a4e_4729_af0b_cea27aed51e2);
::windows_core::imp::interface_hierarchy!(IVMRSurfaceAllocatorNotify, ::windows_core::IUnknown);
impl IVMRSurfaceAllocatorNotify {
    pub unsafe fn AdviseSurfaceAllocator<P0>(&self, dwuserid: usize, lpivrmsurfaceallocator: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRSurfaceAllocator>,
    {
        (::windows_core::Interface::vtable(self).AdviseSurfaceAllocator)(::windows_core::Interface::as_raw(self), dwuserid, lpivrmsurfaceallocator.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn SetDDrawDevice<P0, P1>(&self, lpddrawdevice: P0, hmonitor: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw7>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows_core::Interface::vtable(self).SetDDrawDevice)(::windows_core::Interface::as_raw(self), lpddrawdevice.into_param().abi(), hmonitor.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn ChangeDDrawDevice<P0, P1>(&self, lpddrawdevice: P0, hmonitor: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw7>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows_core::Interface::vtable(self).ChangeDDrawDevice)(::windows_core::Interface::as_raw(self), lpddrawdevice.into_param().abi(), hmonitor.into_param().abi()).ok()
    }
    pub unsafe fn RestoreDDrawSurfaces(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RestoreDDrawSurfaces)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn NotifyEvent(&self, eventcode: i32, param1: isize, param2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyEvent)(::windows_core::Interface::as_raw(self), eventcode, param1, param2).ok()
    }
    pub unsafe fn SetBorderColor<P0>(&self, clrborder: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::COLORREF>,
    {
        (::windows_core::Interface::vtable(self).SetBorderColor)(::windows_core::Interface::as_raw(self), clrborder.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IVMRSurfaceAllocatorNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AdviseSurfaceAllocator: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub SetDDrawDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi")))]
    SetDDrawDevice: usize,
    #[cfg(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi"))]
    pub ChangeDDrawDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_DirectDraw", feature = "Win32_Graphics_Gdi")))]
    ChangeDDrawDevice: usize,
    pub RestoreDDrawSurfaces: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NotifyEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, isize, isize) -> ::windows_core::HRESULT,
    pub SetBorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRSurfaceAllocatorNotify9, IVMRSurfaceAllocatorNotify9_Vtbl, 0xdca3f5df_bb3a_4d03_bd81_84614bfbfa0c);
::windows_core::imp::interface_hierarchy!(IVMRSurfaceAllocatorNotify9, ::windows_core::IUnknown);
impl IVMRSurfaceAllocatorNotify9 {
    pub unsafe fn AdviseSurfaceAllocator<P0>(&self, dwuserid: usize, lpivrmsurfaceallocator: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IVMRSurfaceAllocator9>,
    {
        (::windows_core::Interface::vtable(self).AdviseSurfaceAllocator)(::windows_core::Interface::as_raw(self), dwuserid, lpivrmsurfaceallocator.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn SetD3DDevice<P0, P1>(&self, lpd3ddevice: P0, hmonitor: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Direct3D9::IDirect3DDevice9>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows_core::Interface::vtable(self).SetD3DDevice)(::windows_core::Interface::as_raw(self), lpd3ddevice.into_param().abi(), hmonitor.into_param().abi()).ok()
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn ChangeD3DDevice<P0, P1>(&self, lpd3ddevice: P0, hmonitor: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Direct3D9::IDirect3DDevice9>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows_core::Interface::vtable(self).ChangeD3DDevice)(::windows_core::Interface::as_raw(self), lpd3ddevice.into_param().abi(), hmonitor.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn AllocateSurfaceHelper(&self, lpallocinfo: *const VMR9AllocationInfo, lpnumbuffers: *mut u32, lplpsurface: *mut ::core::option::Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AllocateSurfaceHelper)(::windows_core::Interface::as_raw(self), lpallocinfo, lpnumbuffers, ::core::mem::transmute(lplpsurface)).ok()
    }
    pub unsafe fn NotifyEvent(&self, eventcode: i32, param1: isize, param2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyEvent)(::windows_core::Interface::as_raw(self), eventcode, param1, param2).ok()
    }
}
#[repr(C)]
pub struct IVMRSurfaceAllocatorNotify9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AdviseSurfaceAllocator: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub SetD3DDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi")))]
    SetD3DDevice: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi"))]
    pub ChangeD3DDevice: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Graphics_Gdi")))]
    ChangeD3DDevice: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub AllocateSurfaceHelper: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const VMR9AllocationInfo, *mut u32, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    AllocateSurfaceHelper: usize,
    pub NotifyEvent: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, isize, isize) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRVideoStreamControl, IVMRVideoStreamControl_Vtbl, 0x058d1f11_2a54_4bef_bd54_df706626b727);
::windows_core::imp::interface_hierarchy!(IVMRVideoStreamControl, ::windows_core::IUnknown);
impl IVMRVideoStreamControl {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetColorKey(&self, lpclrkey: *const super::super::Graphics::DirectDraw::DDCOLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetColorKey)(::windows_core::Interface::as_raw(self), lpclrkey).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetColorKey(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::DDCOLORKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetColorKey)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetStreamActiveState<P0>(&self, factive: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetStreamActiveState)(::windows_core::Interface::as_raw(self), factive.into_param().abi()).ok()
    }
    pub unsafe fn GetStreamActiveState(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStreamActiveState)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRVideoStreamControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Graphics::DirectDraw::DDCOLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetColorKey: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Graphics::DirectDraw::DDCOLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetColorKey: usize,
    pub SetStreamActiveState: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetStreamActiveState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRVideoStreamControl9, IVMRVideoStreamControl9_Vtbl, 0xd0cfe38b_93e7_4772_8957_0400c49a4485);
::windows_core::imp::interface_hierarchy!(IVMRVideoStreamControl9, ::windows_core::IUnknown);
impl IVMRVideoStreamControl9 {
    pub unsafe fn SetStreamActiveState<P0>(&self, factive: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetStreamActiveState)(::windows_core::Interface::as_raw(self), factive.into_param().abi()).ok()
    }
    pub unsafe fn GetStreamActiveState(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStreamActiveState)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRVideoStreamControl9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetStreamActiveState: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetStreamActiveState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRWindowlessControl, IVMRWindowlessControl_Vtbl, 0x0eb1088c_4dcd_46f0_878f_39dae86a51b7);
::windows_core::imp::interface_hierarchy!(IVMRWindowlessControl, ::windows_core::IUnknown);
impl IVMRWindowlessControl {
    pub unsafe fn GetNativeVideoSize(&self, lpwidth: *mut i32, lpheight: *mut i32, lparwidth: *mut i32, lparheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNativeVideoSize)(::windows_core::Interface::as_raw(self), lpwidth, lpheight, lparwidth, lparheight).ok()
    }
    pub unsafe fn GetMinIdealVideoSize(&self, lpwidth: *mut i32, lpheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMinIdealVideoSize)(::windows_core::Interface::as_raw(self), lpwidth, lpheight).ok()
    }
    pub unsafe fn GetMaxIdealVideoSize(&self, lpwidth: *mut i32, lpheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMaxIdealVideoSize)(::windows_core::Interface::as_raw(self), lpwidth, lpheight).ok()
    }
    pub unsafe fn SetVideoPosition(&self, lpsrcrect: *const super::super::Foundation::RECT, lpdstrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVideoPosition)(::windows_core::Interface::as_raw(self), lpsrcrect, lpdstrect).ok()
    }
    pub unsafe fn GetVideoPosition(&self, lpsrcrect: *mut super::super::Foundation::RECT, lpdstrect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoPosition)(::windows_core::Interface::as_raw(self), lpsrcrect, lpdstrect).ok()
    }
    pub unsafe fn GetAspectRatioMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAspectRatioMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAspectRatioMode(&self, aspectratiomode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAspectRatioMode)(::windows_core::Interface::as_raw(self), aspectratiomode).ok()
    }
    pub unsafe fn SetVideoClippingWindow<P0>(&self, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).SetVideoClippingWindow)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn RepaintVideo<P0, P1>(&self, hwnd: P0, hdc: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Gdi::HDC>,
    {
        (::windows_core::Interface::vtable(self).RepaintVideo)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi(), hdc.into_param().abi()).ok()
    }
    pub unsafe fn DisplayModeChanged(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DisplayModeChanged)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetCurrentImage(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentImage)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBorderColor<P0>(&self, clr: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::COLORREF>,
    {
        (::windows_core::Interface::vtable(self).SetBorderColor)(::windows_core::Interface::as_raw(self), clr.into_param().abi()).ok()
    }
    pub unsafe fn GetBorderColor(&self) -> ::windows_core::Result<super::super::Foundation::COLORREF> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetBorderColor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetColorKey<P0>(&self, clr: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::COLORREF>,
    {
        (::windows_core::Interface::vtable(self).SetColorKey)(::windows_core::Interface::as_raw(self), clr.into_param().abi()).ok()
    }
    pub unsafe fn GetColorKey(&self) -> ::windows_core::Result<super::super::Foundation::COLORREF> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetColorKey)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRWindowlessControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNativeVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetMinIdealVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetMaxIdealVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetVideoPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub GetVideoPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::RECT, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub GetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetVideoClippingWindow: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub RepaintVideo: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND, super::super::Graphics::Gdi::HDC) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    RepaintVideo: usize,
    pub DisplayModeChanged: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetCurrentImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub SetBorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub GetBorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub SetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub GetColorKey: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVMRWindowlessControl9, IVMRWindowlessControl9_Vtbl, 0x8f537d09_f85e_4414_b23b_502e54c79927);
::windows_core::imp::interface_hierarchy!(IVMRWindowlessControl9, ::windows_core::IUnknown);
impl IVMRWindowlessControl9 {
    pub unsafe fn GetNativeVideoSize(&self, lpwidth: *mut i32, lpheight: *mut i32, lparwidth: *mut i32, lparheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNativeVideoSize)(::windows_core::Interface::as_raw(self), lpwidth, lpheight, lparwidth, lparheight).ok()
    }
    pub unsafe fn GetMinIdealVideoSize(&self, lpwidth: *mut i32, lpheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMinIdealVideoSize)(::windows_core::Interface::as_raw(self), lpwidth, lpheight).ok()
    }
    pub unsafe fn GetMaxIdealVideoSize(&self, lpwidth: *mut i32, lpheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMaxIdealVideoSize)(::windows_core::Interface::as_raw(self), lpwidth, lpheight).ok()
    }
    pub unsafe fn SetVideoPosition(&self, lpsrcrect: *const super::super::Foundation::RECT, lpdstrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVideoPosition)(::windows_core::Interface::as_raw(self), lpsrcrect, lpdstrect).ok()
    }
    pub unsafe fn GetVideoPosition(&self, lpsrcrect: *mut super::super::Foundation::RECT, lpdstrect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoPosition)(::windows_core::Interface::as_raw(self), lpsrcrect, lpdstrect).ok()
    }
    pub unsafe fn GetAspectRatioMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAspectRatioMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAspectRatioMode(&self, aspectratiomode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAspectRatioMode)(::windows_core::Interface::as_raw(self), aspectratiomode).ok()
    }
    pub unsafe fn SetVideoClippingWindow<P0>(&self, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).SetVideoClippingWindow)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn RepaintVideo<P0, P1>(&self, hwnd: P0, hdc: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
        P1: ::windows_core::IntoParam<super::super::Graphics::Gdi::HDC>,
    {
        (::windows_core::Interface::vtable(self).RepaintVideo)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi(), hdc.into_param().abi()).ok()
    }
    pub unsafe fn DisplayModeChanged(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DisplayModeChanged)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetCurrentImage(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentImage)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBorderColor<P0>(&self, clr: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::COLORREF>,
    {
        (::windows_core::Interface::vtable(self).SetBorderColor)(::windows_core::Interface::as_raw(self), clr.into_param().abi()).ok()
    }
    pub unsafe fn GetBorderColor(&self) -> ::windows_core::Result<super::super::Foundation::COLORREF> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetBorderColor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVMRWindowlessControl9_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNativeVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetMinIdealVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetMaxIdealVideoSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub SetVideoPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::super::Foundation::RECT, *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub GetVideoPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::RECT, *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    pub GetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
    pub SetAspectRatioMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetVideoClippingWindow: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub RepaintVideo: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::HWND, super::super::Graphics::Gdi::HDC) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    RepaintVideo: usize,
    pub DisplayModeChanged: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetCurrentImage: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut u8) -> ::windows_core::HRESULT,
    pub SetBorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
    pub GetBorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::COLORREF) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPBaseConfig, IVPBaseConfig_Vtbl, 0);
::windows_core::imp::interface_hierarchy!(IVPBaseConfig, ::windows_core::IUnknown);
impl IVPBaseConfig {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetConnectInfo(&self, pdwnumconnectinfo: *mut u32, pddvpconnectinfo: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDVIDEOPORTCONNECT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetConnectInfo)(::windows_core::Interface::as_raw(self), pdwnumconnectinfo, ::core::mem::transmute(pddvpconnectinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetConnectInfo(&self, dwchosenentry: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetConnectInfo)(::windows_core::Interface::as_raw(self), dwchosenentry).ok()
    }
    pub unsafe fn GetVPDataInfo(&self, pamvpdatainfo: *mut AMVPDATAINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVPDataInfo)(::windows_core::Interface::as_raw(self), pamvpdatainfo).ok()
    }
    pub unsafe fn GetMaxPixelRate(&self, pamvpsize: *mut AMVPSIZE, pdwmaxpixelspersecond: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMaxPixelRate)(::windows_core::Interface::as_raw(self), pamvpsize, pdwmaxpixelspersecond).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn InformVPInputFormats(&self, dwnumformats: u32, pddpixelformats: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InformVPInputFormats)(::windows_core::Interface::as_raw(self), dwnumformats, pddpixelformats).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetVideoFormats(&self, pdwnumformats: *mut u32, pddpixelformats: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDPIXELFORMAT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoFormats)(::windows_core::Interface::as_raw(self), pdwnumformats, ::core::mem::transmute(pddpixelformats.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetVideoFormat(&self, dwchosenentry: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVideoFormat)(::windows_core::Interface::as_raw(self), dwchosenentry).ok()
    }
    pub unsafe fn SetInvertPolarity(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetInvertPolarity)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetOverlaySurface(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDrawSurface> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOverlaySurface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetDirectDrawKernelHandle(&self, dwddkernelhandle: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDirectDrawKernelHandle)(::windows_core::Interface::as_raw(self), dwddkernelhandle).ok()
    }
    pub unsafe fn SetVideoPortID(&self, dwvideoportid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVideoPortID)(::windows_core::Interface::as_raw(self), dwvideoportid).ok()
    }
    pub unsafe fn SetDDSurfaceKernelHandles(&self, chandles: u32, rgddkernelhandles: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDDSurfaceKernelHandles)(::windows_core::Interface::as_raw(self), chandles, rgddkernelhandles).ok()
    }
    pub unsafe fn SetSurfaceParameters(&self, dwpitch: u32, dwxorigin: u32, dwyorigin: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSurfaceParameters)(::windows_core::Interface::as_raw(self), dwpitch, dwxorigin, dwyorigin).ok()
    }
}
#[repr(C)]
pub struct IVPBaseConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetConnectInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut super::super::Graphics::DirectDraw::DDVIDEOPORTCONNECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetConnectInfo: usize,
    pub SetConnectInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetVPDataInfo: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AMVPDATAINFO) -> ::windows_core::HRESULT,
    pub GetMaxPixelRate: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AMVPSIZE, *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub InformVPInputFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    InformVPInputFormats: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetVideoFormats: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32, *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetVideoFormats: usize,
    pub SetVideoFormat: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetInvertPolarity: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetOverlaySurface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetOverlaySurface: usize,
    pub SetDirectDrawKernelHandle: unsafe extern "system" fn(*mut ::core::ffi::c_void, usize) -> ::windows_core::HRESULT,
    pub SetVideoPortID: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub SetDDSurfaceKernelHandles: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut usize) -> ::windows_core::HRESULT,
    pub SetSurfaceParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, u32, u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPBaseNotify, IVPBaseNotify_Vtbl, 0);
::windows_core::imp::interface_hierarchy!(IVPBaseNotify, ::windows_core::IUnknown);
impl IVPBaseNotify {
    pub unsafe fn RenegotiateVPParameters(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RenegotiateVPParameters)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IVPBaseNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RenegotiateVPParameters: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPConfig, IVPConfig_Vtbl, 0xbc29a660_30e3_11d0_9e69_00c04fd7c15b);
::windows_core::imp::interface_hierarchy!(IVPConfig, ::windows_core::IUnknown, IVPBaseConfig);
impl IVPConfig {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetConnectInfo(&self, pdwnumconnectinfo: *mut u32, pddvpconnectinfo: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDVIDEOPORTCONNECT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetConnectInfo)(::windows_core::Interface::as_raw(self), pdwnumconnectinfo, ::core::mem::transmute(pddvpconnectinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetConnectInfo(&self, dwchosenentry: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetConnectInfo)(::windows_core::Interface::as_raw(self), dwchosenentry).ok()
    }
    pub unsafe fn GetVPDataInfo(&self, pamvpdatainfo: *mut AMVPDATAINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVPDataInfo)(::windows_core::Interface::as_raw(self), pamvpdatainfo).ok()
    }
    pub unsafe fn GetMaxPixelRate(&self, pamvpsize: *mut AMVPSIZE, pdwmaxpixelspersecond: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMaxPixelRate)(::windows_core::Interface::as_raw(self), pamvpsize, pdwmaxpixelspersecond).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn InformVPInputFormats(&self, dwnumformats: u32, pddpixelformats: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InformVPInputFormats)(::windows_core::Interface::as_raw(self), dwnumformats, pddpixelformats).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetVideoFormats(&self, pdwnumformats: *mut u32, pddpixelformats: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDPIXELFORMAT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVideoFormats)(::windows_core::Interface::as_raw(self), pdwnumformats, ::core::mem::transmute(pddpixelformats.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetVideoFormat(&self, dwchosenentry: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetVideoFormat)(::windows_core::Interface::as_raw(self), dwchosenentry).ok()
    }
    pub unsafe fn SetInvertPolarity(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetInvertPolarity)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetOverlaySurface(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDrawSurface> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetOverlaySurface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetDirectDrawKernelHandle(&self, dwddkernelhandle: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDirectDrawKernelHandle)(::windows_core::Interface::as_raw(self), dwddkernelhandle).ok()
    }
    pub unsafe fn SetVideoPortID(&self, dwvideoportid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetVideoPortID)(::windows_core::Interface::as_raw(self), dwvideoportid).ok()
    }
    pub unsafe fn SetDDSurfaceKernelHandles(&self, chandles: u32, rgddkernelhandles: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDDSurfaceKernelHandles)(::windows_core::Interface::as_raw(self), chandles, rgddkernelhandles).ok()
    }
    pub unsafe fn SetSurfaceParameters(&self, dwpitch: u32, dwxorigin: u32, dwyorigin: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSurfaceParameters)(::windows_core::Interface::as_raw(self), dwpitch, dwxorigin, dwyorigin).ok()
    }
    pub unsafe fn IsVPDecimationAllowed(&self, pbisdecimationallowed: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsVPDecimationAllowed)(::windows_core::Interface::as_raw(self), pbisdecimationallowed).ok()
    }
    pub unsafe fn SetScalingFactors(&self, pamvpsize: *mut AMVPSIZE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetScalingFactors)(::windows_core::Interface::as_raw(self), pamvpsize).ok()
    }
}
#[repr(C)]
pub struct IVPConfig_Vtbl {
    pub base__: IVPBaseConfig_Vtbl,
    pub IsVPDecimationAllowed: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub SetScalingFactors: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AMVPSIZE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPManager, IVPManager_Vtbl, 0xaac18c18_e186_46d2_825d_a1f8dc8e395a);
::windows_core::imp::interface_hierarchy!(IVPManager, ::windows_core::IUnknown);
impl IVPManager {
    pub unsafe fn SetVideoPortIndex(&self, dwvideoportindex: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVideoPortIndex)(::windows_core::Interface::as_raw(self), dwvideoportindex).ok()
    }
    pub unsafe fn GetVideoPortIndex(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetVideoPortIndex)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[repr(C)]
pub struct IVPManager_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetVideoPortIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32) -> ::windows_core::HRESULT,
    pub GetVideoPortIndex: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut u32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPNotify, IVPNotify_Vtbl, 0xc76794a1_d6c5_11d0_9e69_00c04fd7c15b);
::windows_core::imp::interface_hierarchy!(IVPNotify, ::windows_core::IUnknown, IVPBaseNotify);
impl IVPNotify {
    pub unsafe fn RenegotiateVPParameters(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.RenegotiateVPParameters)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDeinterlaceMode(&self, mode: AMVP_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDeinterlaceMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn GetDeinterlaceMode(&self, pmode: *mut AMVP_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDeinterlaceMode)(::windows_core::Interface::as_raw(self), pmode).ok()
    }
}
#[repr(C)]
pub struct IVPNotify_Vtbl {
    pub base__: IVPBaseNotify_Vtbl,
    pub SetDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, AMVP_MODE) -> ::windows_core::HRESULT,
    pub GetDeinterlaceMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut AMVP_MODE) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPNotify2, IVPNotify2_Vtbl, 0xebf47183_8764_11d1_9e69_00c04fd7c15b);
::windows_core::imp::interface_hierarchy!(IVPNotify2, ::windows_core::IUnknown, IVPBaseNotify, IVPNotify);
impl IVPNotify2 {
    pub unsafe fn RenegotiateVPParameters(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.RenegotiateVPParameters)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDeinterlaceMode(&self, mode: AMVP_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDeinterlaceMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn GetDeinterlaceMode(&self, pmode: *mut AMVP_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetDeinterlaceMode)(::windows_core::Interface::as_raw(self), pmode).ok()
    }
    pub unsafe fn SetVPSyncMaster<P0>(&self, bvpsyncmaster: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetVPSyncMaster)(::windows_core::Interface::as_raw(self), bvpsyncmaster.into_param().abi()).ok()
    }
    pub unsafe fn GetVPSyncMaster(&self, pbvpsyncmaster: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVPSyncMaster)(::windows_core::Interface::as_raw(self), pbvpsyncmaster).ok()
    }
}
#[repr(C)]
pub struct IVPNotify2_Vtbl {
    pub base__: IVPNotify_Vtbl,
    pub SetVPSyncMaster: unsafe extern "system" fn(*mut ::core::ffi::c_void, super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    pub GetVPSyncMaster: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVPVBIConfig, IVPVBIConfig_Vtbl, 0xec529b00_1a1f_11d1_bad9_00609744111a);
::windows_core::imp::interface_hierarchy!(IVPVBIConfig, ::windows_core::IUnknown, IVPBaseConfig);
impl IVPVBIConfig {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetConnectInfo(&self, pdwnumconnectinfo: *mut u32, pddvpconnectinfo: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDVIDEOPORTCONNECT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetConnectInfo)(::windows_core::Interface::as_raw(self), pdwnumconnectinfo, ::core::mem::transmute(pddvpconnectinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetConnectInfo(&self, dwchosenentry: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetConnectInfo)(::windows_core::Interface::as_raw(self), dwchosenentry).ok()
    }
    pub unsafe fn GetVPDataInfo(&self, pamvpdatainfo: *mut AMVPDATAINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVPDataInfo)(::windows_core::Interface::as_raw(self), pamvpdatainfo).ok()
    }
    pub unsafe fn GetMaxPixelRate(&self, pamvpsize: *mut AMVPSIZE, pdwmaxpixelspersecond: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMaxPixelRate)(::windows_core::Interface::as_raw(self), pamvpsize, pdwmaxpixelspersecond).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn InformVPInputFormats(&self, dwnumformats: u32, pddpixelformats: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InformVPInputFormats)(::windows_core::Interface::as_raw(self), dwnumformats, pddpixelformats).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetVideoFormats(&self, pdwnumformats: *mut u32, pddpixelformats: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDPIXELFORMAT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVideoFormats)(::windows_core::Interface::as_raw(self), pdwnumformats, ::core::mem::transmute(pddpixelformats.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetVideoFormat(&self, dwchosenentry: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetVideoFormat)(::windows_core::Interface::as_raw(self), dwchosenentry).ok()
    }
    pub unsafe fn SetInvertPolarity(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetInvertPolarity)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetOverlaySurface(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDrawSurface> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetOverlaySurface)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetDirectDrawKernelHandle(&self, dwddkernelhandle: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDirectDrawKernelHandle)(::windows_core::Interface::as_raw(self), dwddkernelhandle).ok()
    }
    pub unsafe fn SetVideoPortID(&self, dwvideoportid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetVideoPortID)(::windows_core::Interface::as_raw(self), dwvideoportid).ok()
    }
    pub unsafe fn SetDDSurfaceKernelHandles(&self, chandles: u32, rgddkernelhandles: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDDSurfaceKernelHandles)(::windows_core::Interface::as_raw(self), chandles, rgddkernelhandles).ok()
    }
    pub unsafe fn SetSurfaceParameters(&self, dwpitch: u32, dwxorigin: u32, dwyorigin: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSurfaceParameters)(::windows_core::Interface::as_raw(self), dwpitch, dwxorigin, dwyorigin).ok()
    }
}
#[repr(C)]
pub struct IVPVBIConfig_Vtbl {
    pub base__: IVPBaseConfig_Vtbl,
}
::windows_core::imp::com_interface!(IVPVBINotify, IVPVBINotify_Vtbl, 0xec529b01_1a1f_11d1_bad9_00609744111a);
::windows_core::imp::interface_hierarchy!(IVPVBINotify, ::windows_core::IUnknown, IVPBaseNotify);
impl IVPVBINotify {
    pub unsafe fn RenegotiateVPParameters(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.RenegotiateVPParameters)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IVPVBINotify_Vtbl {
    pub base__: IVPBaseNotify_Vtbl,
}
::windows_core::imp::com_interface!(IVideoEncoder, IVideoEncoder_Vtbl, 0x02997c3b_8e1b_460e_9270_545e0de9563e);
::windows_core::imp::interface_hierarchy!(IVideoEncoder, ::windows_core::IUnknown, IEncoderAPI);
impl IVideoEncoder {
    pub unsafe fn IsSupported(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsSupported)(::windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn IsAvailable(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsAvailable)(::windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn GetParameterRange(&self, api: *const ::windows_core::GUID, valuemin: *mut ::windows_core::VARIANT, valuemax: *mut ::windows_core::VARIANT, steppingdelta: *mut ::windows_core::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetParameterRange)(::windows_core::Interface::as_raw(self), api, ::core::mem::transmute(valuemin), ::core::mem::transmute(valuemax), ::core::mem::transmute(steppingdelta)).ok()
    }
    pub unsafe fn GetParameterValues(&self, api: *const ::windows_core::GUID, values: *mut *mut ::windows_core::VARIANT, valuescount: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetParameterValues)(::windows_core::Interface::as_raw(self), api, values, valuescount).ok()
    }
    pub unsafe fn GetDefaultValue(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<::windows_core::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetDefaultValue)(::windows_core::Interface::as_raw(self), api, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetValue(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<::windows_core::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetValue)(::windows_core::Interface::as_raw(self), api, &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetValue(&self, api: *const ::windows_core::GUID, value: *const ::windows_core::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetValue)(::windows_core::Interface::as_raw(self), api, ::core::mem::transmute(value)).ok()
    }
}
#[repr(C)]
pub struct IVideoEncoder_Vtbl {
    pub base__: IEncoderAPI_Vtbl,
}
::windows_core::imp::com_interface!(IVideoFrameStep, IVideoFrameStep_Vtbl, 0xe46a9787_2b71_444d_a4b5_1fab7b708d6a);
::windows_core::imp::interface_hierarchy!(IVideoFrameStep, ::windows_core::IUnknown);
impl IVideoFrameStep {
    pub unsafe fn Step<P0>(&self, dwframes: u32, pstepobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).Step)(::windows_core::Interface::as_raw(self), dwframes, pstepobject.into_param().abi()).ok()
    }
    pub unsafe fn CanStep<P0>(&self, bmultiple: i32, pstepobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).CanStep)(::windows_core::Interface::as_raw(self), bmultiple, pstepobject.into_param().abi()).ok()
    }
    pub unsafe fn CancelStep(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CancelStep)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[repr(C)]
pub struct IVideoFrameStep_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Step: unsafe extern "system" fn(*mut ::core::ffi::c_void, u32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CanStep: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CancelStep: unsafe extern "system" fn(*mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IVideoProcAmp, IVideoProcAmp_Vtbl, 0x4050560e_42a7_413a_85c2_09269a2d0f44);
::windows_core::imp::interface_hierarchy!(IVideoProcAmp, ::windows_core::IUnknown);
impl IVideoProcAmp {
    pub unsafe fn get_BacklightCompensation(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_BacklightCompensation)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_BacklightCompensation(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_BacklightCompensation)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_BacklightCompensation(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_BacklightCompensation)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Brightness(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Brightness)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Brightness(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Brightness)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Brightness(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Brightness)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ColorEnable(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ColorEnable)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ColorEnable(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ColorEnable)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_ColorEnable(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_ColorEnable)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Contrast(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Contrast)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Contrast(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Contrast)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Contrast(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Contrast)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Gamma(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Gamma)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Gamma(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Gamma)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Gamma(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Gamma)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Saturation(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Saturation)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Saturation(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Saturation)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Saturation(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Saturation)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Sharpness(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Sharpness)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Sharpness(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Sharpness)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Sharpness(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Sharpness)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_WhiteBalance(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_WhiteBalance)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_WhiteBalance(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_WhiteBalance)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_WhiteBalance(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_WhiteBalance)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Gain(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Gain)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Gain(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Gain)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Gain(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Gain)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Hue(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Hue)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Hue(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Hue)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Hue(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Hue)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_DigitalMultiplier(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DigitalMultiplier)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_DigitalMultiplier(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_DigitalMultiplier)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_DigitalMultiplier(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_DigitalMultiplier)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PowerlineFrequency(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PowerlineFrequency)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_PowerlineFrequency(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PowerlineFrequency)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_PowerlineFrequency(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_PowerlineFrequency)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_WhiteBalanceComponent(&self, pvalue1: *mut i32, pvalue2: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_WhiteBalanceComponent)(::windows_core::Interface::as_raw(self), pvalue1, pvalue2, pflags).ok()
    }
    pub unsafe fn put_WhiteBalanceComponent(&self, value1: i32, value2: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_WhiteBalanceComponent)(::windows_core::Interface::as_raw(self), value1, value2, flags).ok()
    }
    pub unsafe fn getRange_WhiteBalanceComponent(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_WhiteBalanceComponent)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
}
#[repr(C)]
pub struct IVideoProcAmp_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_BacklightCompensation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_BacklightCompensation: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_BacklightCompensation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Brightness: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Brightness: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Brightness: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_ColorEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_ColorEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_ColorEnable: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Contrast: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Contrast: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Contrast: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Gamma: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Gamma: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Gamma: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Saturation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Saturation: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Saturation: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Sharpness: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Sharpness: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Sharpness: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_WhiteBalance: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_WhiteBalance: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_WhiteBalance: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Gain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Gain: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Gain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_Hue: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_Hue: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_Hue: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_DigitalMultiplier: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_DigitalMultiplier: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_DigitalMultiplier: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_PowerlineFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_PowerlineFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_PowerlineFrequency: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub get_WhiteBalanceComponent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub put_WhiteBalanceComponent: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32) -> ::windows_core::HRESULT,
    pub getRange_WhiteBalanceComponent: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::com_interface!(IVideoWindow, IVideoWindow_Vtbl, 0x56a868b4_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IVideoWindow, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IVideoWindow {
    pub unsafe fn SetCaption<P0>(&self, strcaption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetCaption)(::windows_core::Interface::as_raw(self), strcaption.into_param().abi()).ok()
    }
    pub unsafe fn Caption(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Caption)(::windows_core::Interface::as_raw(self), &mut result__).and_then(|| ::windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetWindowStyle(&self, windowstyle: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowStyle)(::windows_core::Interface::as_raw(self), windowstyle).ok()
    }
    pub unsafe fn WindowStyle(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WindowStyle)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetWindowStyleEx(&self, windowstyleex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowStyleEx)(::windows_core::Interface::as_raw(self), windowstyleex).ok()
    }
    pub unsafe fn WindowStyleEx(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WindowStyleEx)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetAutoShow(&self, autoshow: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAutoShow)(::windows_core::Interface::as_raw(self), autoshow).ok()
    }
    pub unsafe fn AutoShow(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AutoShow)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetWindowState(&self, windowstate: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowState)(::windows_core::Interface::as_raw(self), windowstate).ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn WindowState(&self) -> ::windows_core::Result<super::super::UI::WindowsAndMessaging::SHOW_WINDOW_CMD> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WindowState)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBackgroundPalette(&self, backgroundpalette: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBackgroundPalette)(::windows_core::Interface::as_raw(self), backgroundpalette).ok()
    }
    pub unsafe fn BackgroundPalette(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BackgroundPalette)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetVisible(&self, visible: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVisible)(::windows_core::Interface::as_raw(self), visible).ok()
    }
    pub unsafe fn Visible(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Visible)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLeft(&self, left: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLeft)(::windows_core::Interface::as_raw(self), left).ok()
    }
    pub unsafe fn Left(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Left)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetWidth(&self, width: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWidth)(::windows_core::Interface::as_raw(self), width).ok()
    }
    pub unsafe fn Width(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Width)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetTop(&self, top: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTop)(::windows_core::Interface::as_raw(self), top).ok()
    }
    pub unsafe fn Top(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Top)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetHeight(&self, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetHeight)(::windows_core::Interface::as_raw(self), height).ok()
    }
    pub unsafe fn Height(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Height)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetOwner(&self, owner: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOwner)(::windows_core::Interface::as_raw(self), owner).ok()
    }
    pub unsafe fn Owner(&self) -> ::windows_core::Result<isize> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Owner)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetMessageDrain(&self, drain: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMessageDrain)(::windows_core::Interface::as_raw(self), drain).ok()
    }
    pub unsafe fn MessageDrain(&self) -> ::windows_core::Result<isize> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MessageDrain)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn BorderColor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BorderColor)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetBorderColor(&self, color: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBorderColor)(::windows_core::Interface::as_raw(self), color).ok()
    }
    pub unsafe fn FullScreenMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FullScreenMode)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetFullScreenMode(&self, fullscreenmode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFullScreenMode)(::windows_core::Interface::as_raw(self), fullscreenmode).ok()
    }
    pub unsafe fn SetWindowForeground(&self, focus: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowForeground)(::windows_core::Interface::as_raw(self), focus).ok()
    }
    pub unsafe fn NotifyOwnerMessage(&self, hwnd: isize, umsg: i32, wparam: isize, lparam: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyOwnerMessage)(::windows_core::Interface::as_raw(self), hwnd, umsg, wparam, lparam).ok()
    }
    pub unsafe fn SetWindowPosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowPosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetWindowPosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetWindowPosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn GetMinIdealImageSize(&self, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMinIdealImageSize)(::windows_core::Interface::as_raw(self), pwidth, pheight).ok()
    }
    pub unsafe fn GetMaxIdealImageSize(&self, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMaxIdealImageSize)(::windows_core::Interface::as_raw(self), pwidth, pheight).ok()
    }
    pub unsafe fn GetRestorePosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRestorePosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn HideCursor(&self, hidecursor: OA_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HideCursor)(::windows_core::Interface::as_raw(self), hidecursor).ok()
    }
    pub unsafe fn IsCursorHidden(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsCursorHidden)(::windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IVideoWindow_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SetCaption: unsafe extern "system" fn(*mut ::core::ffi::c_void, ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Caption: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetWindowStyle: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub WindowStyle: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetWindowStyleEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub WindowStyleEx: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetAutoShow: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub AutoShow: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetWindowState: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub WindowState: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut super::super::UI::WindowsAndMessaging::SHOW_WINDOW_CMD) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    WindowState: usize,
    pub SetBackgroundPalette: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub BackgroundPalette: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetVisible: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Visible: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetLeft: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Left: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetWidth: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Width: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetTop: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Top: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetHeight: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub Height: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetOwner: unsafe extern "system" fn(*mut ::core::ffi::c_void, isize) -> ::windows_core::HRESULT,
    pub Owner: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut isize) -> ::windows_core::HRESULT,
    pub SetMessageDrain: unsafe extern "system" fn(*mut ::core::ffi::c_void, isize) -> ::windows_core::HRESULT,
    pub MessageDrain: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut isize) -> ::windows_core::HRESULT,
    pub BorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetBorderColor: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub FullScreenMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
    pub SetFullScreenMode: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub SetWindowForeground: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32) -> ::windows_core::HRESULT,
    pub NotifyOwnerMessage: unsafe extern "system" fn(*mut ::core::ffi::c_void, isize, i32, isize, isize) -> ::windows_core::HRESULT,
    pub SetWindowPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, i32, i32, i32, i32) -> ::windows_core::HRESULT,
    pub GetWindowPosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetMinIdealImageSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetMaxIdealImageSize: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub GetRestorePosition: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32, *mut i32, *mut i32, *mut i32) -> ::windows_core::HRESULT,
    pub HideCursor: unsafe extern "system" fn(*mut ::core::ffi::c_void, OA_BOOL) -> ::windows_core::HRESULT,
    pub IsCursorHidden: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut i32) -> ::windows_core::HRESULT,
}
::windows_core::imp::com_interface!(IWMCodecAMVideoAccelerator, IWMCodecAMVideoAccelerator_Vtbl, 0xd98ee251_34e0_4a2d_9312_9b4c788d9fa1);
::windows_core::imp::interface_hierarchy!(IWMCodecAMVideoAccelerator, ::windows_core::IUnknown);
impl IWMCodecAMVideoAccelerator {
    pub unsafe fn SetAcceleratorInterface<P0>(&self, piamva: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMVideoAccelerator>,
    {
        (::windows_core::Interface::vtable(self).SetAcceleratorInterface)(::windows_core::Interface::as_raw(self), piamva.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn NegotiateConnection(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NegotiateConnection)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn SetPlayerNotify<P0>(&self, phook: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::IWMPlayerTimestampHook>,
    {
        (::windows_core::Interface::vtable(self).SetPlayerNotify)(::windows_core::Interface::as_raw(self), phook.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IWMCodecAMVideoAccelerator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetAcceleratorInterface: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub NegotiateConnection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    NegotiateConnection: usize,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub SetPlayerNotify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    SetPlayerNotify: usize,
}
::windows_core::imp::com_interface!(IWMCodecVideoAccelerator, IWMCodecVideoAccelerator_Vtbl, 0x990641b0_739f_4e94_a808_9888da8f75af);
::windows_core::imp::interface_hierarchy!(IWMCodecVideoAccelerator, ::windows_core::IUnknown);
impl IWMCodecVideoAccelerator {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn NegotiateConnection<P0>(&self, piamva: P0, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMVideoAccelerator>,
    {
        (::windows_core::Interface::vtable(self).NegotiateConnection)(::windows_core::Interface::as_raw(self), piamva.into_param().abi(), pmediatype).ok()
    }
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn SetPlayerNotify<P0>(&self, phook: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::IWMPlayerTimestampHook>,
    {
        (::windows_core::Interface::vtable(self).SetPlayerNotify)(::windows_core::Interface::as_raw(self), phook.into_param().abi()).ok()
    }
}
#[repr(C)]
pub struct IWMCodecVideoAccelerator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub NegotiateConnection: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    NegotiateConnection: usize,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub SetPlayerNotify: unsafe extern "system" fn(*mut ::core::ffi::c_void, *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    SetPlayerNotify: usize,
}
pub const ADVISE_CLIPPING: ADVISE_TYPE = ADVISE_TYPE(1i32);
pub const ADVISE_COLORKEY: ADVISE_TYPE = ADVISE_TYPE(4i32);
pub const ADVISE_DISPLAY_CHANGE: ADVISE_TYPE = ADVISE_TYPE(16i32);
pub const ADVISE_NONE: ADVISE_TYPE = ADVISE_TYPE(0i32);
pub const ADVISE_PALETTE: ADVISE_TYPE = ADVISE_TYPE(2i32);
pub const ADVISE_POSITION: ADVISE_TYPE = ADVISE_TYPE(8i32);
pub const AMAP_3D_TARGET: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(2i32);
pub const AMAP_ALLOW_SYSMEM: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(4i32);
pub const AMAP_DIRECTED_FLIP: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(16i32);
pub const AMAP_DXVA_TARGET: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(32i32);
pub const AMAP_FORCE_SYSMEM: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(8i32);
pub const AMAP_PIXELFORMAT_VALID: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(1i32);
pub const AMCONTROL_COLORINFO_PRESENT: u32 = 128u32;
pub const AMCONTROL_PAD_TO_16x9: u32 = 4u32;
pub const AMCONTROL_PAD_TO_4x3: u32 = 2u32;
pub const AMCONTROL_USED: u32 = 1u32;
pub const AMCOPYPROTECT_RestrictDuplication: u32 = 1u32;
pub const AMDDS_ALL: u32 = 255u32;
pub const AMDDS_DCIPS: u32 = 1u32;
pub const AMDDS_DEFAULT: u32 = 255u32;
pub const AMDDS_NONE: u32 = 0u32;
pub const AMDDS_PS: u32 = 2u32;
pub const AMDDS_RGBFLP: u32 = 64u32;
pub const AMDDS_RGBOFF: u32 = 16u32;
pub const AMDDS_RGBOVR: u32 = 4u32;
pub const AMDDS_YUVFLP: u32 = 128u32;
pub const AMDDS_YUVOFF: u32 = 32u32;
pub const AMDDS_YUVOVR: u32 = 8u32;
pub const AMF_AUTOMATICGAIN: f64 = -1f64;
pub const AMINTERLACE_1FieldPerSample: u32 = 2u32;
pub const AMINTERLACE_DisplayModeBobOnly: u32 = 0u32;
pub const AMINTERLACE_DisplayModeBobOrWeave: u32 = 128u32;
pub const AMINTERLACE_DisplayModeMask: u32 = 192u32;
pub const AMINTERLACE_DisplayModeWeaveOnly: u32 = 64u32;
pub const AMINTERLACE_Field1First: u32 = 4u32;
pub const AMINTERLACE_FieldPatBothIrregular: u32 = 48u32;
pub const AMINTERLACE_FieldPatBothRegular: u32 = 32u32;
pub const AMINTERLACE_FieldPatField1Only: u32 = 0u32;
pub const AMINTERLACE_FieldPatField2Only: u32 = 16u32;
pub const AMINTERLACE_FieldPatternMask: u32 = 48u32;
pub const AMINTERLACE_IsInterlaced: u32 = 1u32;
pub const AMINTERLACE_UNUSED: u32 = 8u32;
pub const AMMSF_ADDDEFAULTRENDERER: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(1i32);
pub const AMMSF_CREATEPEER: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(2i32);
pub const AMMSF_NOCLOCK: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(4i32);
pub const AMMSF_NOGRAPHTHREAD: AMMSF_MMS_INIT_FLAGS = AMMSF_MMS_INIT_FLAGS(1i32);
pub const AMMSF_NORENDER: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(2i32);
pub const AMMSF_NOSTALL: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(8i32);
pub const AMMSF_RENDERALLSTREAMS: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(1i32);
pub const AMMSF_RENDERTOEXISTING: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(0i32);
pub const AMMSF_RENDERTYPEMASK: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(3i32);
pub const AMMSF_RUN: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(8i32);
pub const AMMSF_STOPIFNOSAMPLES: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(4i32);
pub const AMOVERFX_DEINTERLACE: AMOVERLAYFX = AMOVERLAYFX(8i32);
pub const AMOVERFX_MIRRORLEFTRIGHT: AMOVERLAYFX = AMOVERLAYFX(2i32);
pub const AMOVERFX_MIRRORUPDOWN: AMOVERLAYFX = AMOVERLAYFX(4i32);
pub const AMOVERFX_NOFX: AMOVERLAYFX = AMOVERLAYFX(0i32);
pub const AMPLAYLISTEVENT_BREAK: AMPlayListEventFlags = AMPlayListEventFlags(1i32);
pub const AMPLAYLISTEVENT_MASK: AMPlayListEventFlags = AMPlayListEventFlags(15i32);
pub const AMPLAYLISTEVENT_NEXT: AMPlayListEventFlags = AMPlayListEventFlags(2i32);
pub const AMPLAYLISTEVENT_REFRESH: AMPlayListEventFlags = AMPlayListEventFlags(16i32);
pub const AMPLAYLISTEVENT_RESUME: AMPlayListEventFlags = AMPlayListEventFlags(0i32);
pub const AMPLAYLISTITEM_CANBIND: AMPlayListItemFlags = AMPlayListItemFlags(2i32);
pub const AMPLAYLISTITEM_CANSKIP: AMPlayListItemFlags = AMPlayListItemFlags(1i32);
pub const AMPLAYLIST_FORCEBANNER: AMPlayListFlags = AMPlayListFlags(2i32);
pub const AMPLAYLIST_STARTINSCANMODE: AMPlayListFlags = AMPlayListFlags(1i32);
pub const AMPROPERTY_PIN_CATEGORY: AMPROPERTY_PIN = AMPROPERTY_PIN(0i32);
pub const AMPROPERTY_PIN_MEDIUM: AMPROPERTY_PIN = AMPROPERTY_PIN(1i32);
pub const AMRESCTL_RESERVEFLAGS_RESERVE: _AMRESCTL_RESERVEFLAGS = _AMRESCTL_RESERVEFLAGS(0i32);
pub const AMRESCTL_RESERVEFLAGS_UNRESERVE: _AMRESCTL_RESERVEFLAGS = _AMRESCTL_RESERVEFLAGS(1i32);
pub const AMSTREAMSELECTENABLE_ENABLE: _AMSTREAMSELECTENABLEFLAGS = _AMSTREAMSELECTENABLEFLAGS(1i32);
pub const AMSTREAMSELECTENABLE_ENABLEALL: _AMSTREAMSELECTENABLEFLAGS = _AMSTREAMSELECTENABLEFLAGS(2i32);
pub const AMSTREAMSELECTINFO_ENABLED: _AMSTREAMSELECTINFOFLAGS = _AMSTREAMSELECTINFOFLAGS(1i32);
pub const AMSTREAMSELECTINFO_EXCLUSIVE: _AMSTREAMSELECTINFOFLAGS = _AMSTREAMSELECTINFOFLAGS(2i32);
pub const AMTUNER_EVENT_CHANGED: AMTunerEventType = AMTunerEventType(1i32);
pub const AMTUNER_HASNOSIGNALSTRENGTH: AMTunerSignalStrength = AMTunerSignalStrength(-1i32);
pub const AMTUNER_MODE_AM_RADIO: AMTunerModeType = AMTunerModeType(4i32);
pub const AMTUNER_MODE_DEFAULT: AMTunerModeType = AMTunerModeType(0i32);
pub const AMTUNER_MODE_DSS: AMTunerModeType = AMTunerModeType(8i32);
pub const AMTUNER_MODE_FM_RADIO: AMTunerModeType = AMTunerModeType(2i32);
pub const AMTUNER_MODE_TV: AMTunerModeType = AMTunerModeType(1i32);
pub const AMTUNER_NOSIGNAL: AMTunerSignalStrength = AMTunerSignalStrength(0i32);
pub const AMTUNER_SIGNALPRESENT: AMTunerSignalStrength = AMTunerSignalStrength(1i32);
pub const AMTUNER_SUBCHAN_DEFAULT: AMTunerSubChannel = AMTunerSubChannel(-1i32);
pub const AMTUNER_SUBCHAN_NO_TUNE: AMTunerSubChannel = AMTunerSubChannel(-2i32);
pub const AMTVAUDIO_EVENT_CHANGED: AMTVAudioEventType = AMTVAudioEventType(1i32);
pub const AMTVAUDIO_MODE_LANG_A: TVAudioMode = TVAudioMode(16i32);
pub const AMTVAUDIO_MODE_LANG_B: TVAudioMode = TVAudioMode(32i32);
pub const AMTVAUDIO_MODE_LANG_C: TVAudioMode = TVAudioMode(64i32);
pub const AMTVAUDIO_MODE_MONO: TVAudioMode = TVAudioMode(1i32);
pub const AMTVAUDIO_MODE_STEREO: TVAudioMode = TVAudioMode(2i32);
pub const AMTVAUDIO_PRESET_LANG_A: TVAudioMode = TVAudioMode(4096i32);
pub const AMTVAUDIO_PRESET_LANG_B: TVAudioMode = TVAudioMode(8192i32);
pub const AMTVAUDIO_PRESET_LANG_C: TVAudioMode = TVAudioMode(16384i32);
pub const AMTVAUDIO_PRESET_STEREO: TVAudioMode = TVAudioMode(512i32);
pub const AMVA_QUERYRENDERSTATUSF_READ: u32 = 1u32;
pub const AMVA_TYPEINDEX_OUTPUTFRAME: u32 = 4294967295u32;
pub const AMVP_BEST_BANDWIDTH: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(1i32);
pub const AMVP_DO_NOT_CARE: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(0i32);
pub const AMVP_INPUT_SAME_AS_OUTPUT: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(2i32);
pub const AMVP_MODE_BOBINTERLEAVED: AMVP_MODE = AMVP_MODE(1i32);
pub const AMVP_MODE_BOBNONINTERLEAVED: AMVP_MODE = AMVP_MODE(2i32);
pub const AMVP_MODE_SKIPEVEN: AMVP_MODE = AMVP_MODE(3i32);
pub const AMVP_MODE_SKIPODD: AMVP_MODE = AMVP_MODE(4i32);
pub const AMVP_MODE_WEAVE: AMVP_MODE = AMVP_MODE(0i32);
pub const AM_AC3_ALTERNATE_AUDIO_1: u32 = 1u32;
pub const AM_AC3_ALTERNATE_AUDIO_2: u32 = 2u32;
pub const AM_AC3_ALTERNATE_AUDIO_BOTH: u32 = 3u32;
pub const AM_AC3_SERVICE_COMMENTARY: u32 = 5u32;
pub const AM_AC3_SERVICE_DIALOG_ONLY: u32 = 4u32;
pub const AM_AC3_SERVICE_EMERGENCY_FLASH: u32 = 6u32;
pub const AM_AC3_SERVICE_HEARING_IMPAIRED: u32 = 3u32;
pub const AM_AC3_SERVICE_MAIN_AUDIO: u32 = 0u32;
pub const AM_AC3_SERVICE_NO_DIALOG: u32 = 1u32;
pub const AM_AC3_SERVICE_VISUALLY_IMPAIRED: u32 = 2u32;
pub const AM_AC3_SERVICE_VOICE_OVER: u32 = 7u32;
pub const AM_ARMODE_CROP: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(2i32);
pub const AM_ARMODE_LETTER_BOX: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(1i32);
pub const AM_ARMODE_STRETCHED: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(0i32);
pub const AM_ARMODE_STRETCHED_AS_PRIMARY: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(3i32);
pub const AM_AUDREND_STAT_PARAM_BREAK_COUNT: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(1i32);
pub const AM_AUDREND_STAT_PARAM_BUFFERFULLNESS: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(11i32);
pub const AM_AUDREND_STAT_PARAM_DISCONTINUITIES: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(5i32);
pub const AM_AUDREND_STAT_PARAM_JITTER: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(12i32);
pub const AM_AUDREND_STAT_PARAM_LAST_BUFFER_DUR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(4i32);
pub const AM_AUDREND_STAT_PARAM_SILENCE_DUR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(3i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_ACCUMERROR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(10i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_DROPWRITE_DUR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(7i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_HIGHLOWERROR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(8i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_LASTHIGHLOWERROR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(9i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_MODE: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(2i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_RATE: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(6i32);
pub const AM_CONTENTPROPERTY_AUTHOR: u32 = 2u32;
pub const AM_CONTENTPROPERTY_COPYRIGHT: u32 = 4u32;
pub const AM_CONTENTPROPERTY_DESCRIPTION: u32 = 8u32;
pub const AM_CONTENTPROPERTY_TITLE: u32 = 1u32;
pub const AM_DIGITAL_CP_DVD_COMPLIANT: AM_DIGITAL_CP = AM_DIGITAL_CP(2i32);
pub const AM_DIGITAL_CP_OFF: AM_DIGITAL_CP = AM_DIGITAL_CP(0i32);
pub const AM_DIGITAL_CP_ON: AM_DIGITAL_CP = AM_DIGITAL_CP(1i32);
pub const AM_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(2i32);
pub const AM_DVDCOPYSTATE_AUTHENTICATION_REQUIRED: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(3i32);
pub const AM_DVDCOPYSTATE_DONE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(4i32);
pub const AM_DVDCOPYSTATE_INITIALIZE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(0i32);
pub const AM_DVDCOPYSTATE_INITIALIZE_TITLE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(1i32);
pub const AM_DVD_ADAPT_GRAPH: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(16384i32);
pub const AM_DVD_CGMS_COPY_ONCE: u32 = 16u32;
pub const AM_DVD_CGMS_COPY_PERMITTED: u32 = 0u32;
pub const AM_DVD_CGMS_COPY_PROTECT_MASK: u32 = 24u32;
pub const AM_DVD_CGMS_NO_COPY: u32 = 24u32;
pub const AM_DVD_CGMS_RESERVED_MASK: u32 = 120u32;
pub const AM_DVD_COPYRIGHTED: u32 = 64u32;
pub const AM_DVD_COPYRIGHT_MASK: u32 = 64u32;
pub const AM_DVD_DO_NOT_CLEAR: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(512i32);
pub const AM_DVD_EVR_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(4096i32);
pub const AM_DVD_EVR_QOS: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(8192i32);
pub const AM_DVD_HWDEC_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(2i32);
pub const AM_DVD_HWDEC_PREFER: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(1i32);
pub const AM_DVD_MASK: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(65535i32);
pub const AM_DVD_NOT_COPYRIGHTED: u32 = 0u32;
pub const AM_DVD_NOVPE: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(256i32);
pub const AM_DVD_SECTOR_NOT_PROTECTED: u32 = 0u32;
pub const AM_DVD_SECTOR_PROTECTED: u32 = 32u32;
pub const AM_DVD_SECTOR_PROTECT_MASK: u32 = 32u32;
pub const AM_DVD_STREAM_AUDIO: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(2i32);
pub const AM_DVD_STREAM_SUBPIC: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(4i32);
pub const AM_DVD_STREAM_VIDEO: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(1i32);
pub const AM_DVD_SWDEC_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(8i32);
pub const AM_DVD_SWDEC_PREFER: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(4i32);
pub const AM_DVD_VMR9_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(2048i32);
pub const AM_EXSEEK_BUFFERING: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(32i32);
pub const AM_EXSEEK_CANSCAN: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(2i32);
pub const AM_EXSEEK_CANSEEK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(1i32);
pub const AM_EXSEEK_MARKERSEEK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(4i32);
pub const AM_EXSEEK_NOSTANDARDREPAINT: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(16i32);
pub const AM_EXSEEK_SCANWITHOUTCLOCK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(8i32);
pub const AM_EXSEEK_SENDS_VIDEOFRAMEREADY: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(64i32);
pub const AM_FILE_OVERWRITE: AM_FILESINK_FLAGS = AM_FILESINK_FLAGS(1i32);
pub const AM_FILTER_FLAGS_REMOVABLE: AM_FILTER_FLAGS = AM_FILTER_FLAGS(1i32);
pub const AM_FILTER_MISC_FLAGS_IS_RENDERER: _AM_FILTER_MISC_FLAGS = _AM_FILTER_MISC_FLAGS(1i32);
pub const AM_FILTER_MISC_FLAGS_IS_SOURCE: _AM_FILTER_MISC_FLAGS = _AM_FILTER_MISC_FLAGS(2i32);
pub const AM_GBF_NODDSURFACELOCK: u32 = 8u32;
pub const AM_GBF_NOTASYNCPOINT: u32 = 2u32;
pub const AM_GBF_NOWAIT: u32 = 4u32;
pub const AM_GBF_PREVFRAMESKIPPED: u32 = 1u32;
pub const AM_GETDECODERCAP_QUERY_EVR_SUPPORT: u32 = 7u32;
pub const AM_GETDECODERCAP_QUERY_VMR9_SUPPORT: u32 = 6u32;
pub const AM_GETDECODERCAP_QUERY_VMR_SUPPORT: u32 = 1u32;
pub const AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(2i32);
pub const AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(1i32);
pub const AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(4i32);
pub const AM_INTERFACESETID_Standard: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1a8766a0_62ce_11cf_a5d6_28db04c10000);
pub const AM_INTF_SEARCH_FILTER: _AM_INTF_SEARCH_FLAGS = _AM_INTF_SEARCH_FLAGS(4i32);
pub const AM_INTF_SEARCH_INPUT_PIN: _AM_INTF_SEARCH_FLAGS = _AM_INTF_SEARCH_FLAGS(1i32);
pub const AM_INTF_SEARCH_OUTPUT_PIN: _AM_INTF_SEARCH_FLAGS = _AM_INTF_SEARCH_FLAGS(2i32);
pub const AM_KSCATEGORY_AUDIO: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6994ad04_93ef_11d0_a3cc_00a0c9223196);
pub const AM_KSCATEGORY_CAPTURE: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x65e8773d_8f56_11d0_a3b9_00a0c9223196);
pub const AM_KSCATEGORY_CROSSBAR: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa799a801_a46d_11d0_a18c_00a02401dcd4);
pub const AM_KSCATEGORY_DATACOMPRESSOR: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1e84c900_7e70_11d0_a5d6_28db04c10000);
pub const AM_KSCATEGORY_RENDER: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x65e8773e_8f56_11d0_a3b9_00a0c9223196);
pub const AM_KSCATEGORY_SPLITTER: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0a4252a0_7e70_11d0_a5d6_28db04c10000);
pub const AM_KSCATEGORY_TVAUDIO: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa799a802_a46d_11d0_a18c_00a02401dcd4);
pub const AM_KSCATEGORY_TVTUNER: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa799a800_a46d_11d0_a18c_00a02401dcd4);
pub const AM_KSCATEGORY_VBICODEC: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x07dad660_22f1_11d1_a9f4_00c04fbbde8f);
pub const AM_KSCATEGORY_VBICODEC_MI: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9c24a977_0951_451a_8006_0e49bd28cd5f);
pub const AM_KSCATEGORY_VIDEO: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6994ad05_93ef_11d0_a3cc_00a0c9223196);
pub const AM_KSPROPSETID_AC3: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbfabe720_6e1f_11d0_bcf2_444553540000);
pub const AM_KSPROPSETID_CopyProt: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0e8a0a40_6aef_11d0_9ed0_00a024ca19b3);
pub const AM_KSPROPSETID_DVD_RateChange: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3577eb09_9582_477f_b29c_b0c452a4ff9a);
pub const AM_KSPROPSETID_DvdKaraoke: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xae4720ae_aa71_42d8_b82a_fffdf58b76fd);
pub const AM_KSPROPSETID_DvdSubPic: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xac390460_43af_11d0_bd6a_003505c103a9);
pub const AM_KSPROPSETID_FrameStep: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc830acbd_ab07_492f_8852_45b6987c2979);
pub const AM_KSPROPSETID_MPEG4_MediaType_Attributes: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xff6c4bfa_07a9_4c7b_a237_672f9d68065f);
pub const AM_KSPROPSETID_TSRateChange: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa503c5c0_1d1d_11d1_ad80_444553540000);
pub const AM_L21_CCLEVEL_TC2: AM_LINE21_CCLEVEL = AM_LINE21_CCLEVEL(0i32);
pub const AM_L21_CCSERVICE_Caption1: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(1i32);
pub const AM_L21_CCSERVICE_Caption2: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(2i32);
pub const AM_L21_CCSERVICE_DefChannel: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(10i32);
pub const AM_L21_CCSERVICE_Invalid: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(11i32);
pub const AM_L21_CCSERVICE_None: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(0i32);
pub const AM_L21_CCSERVICE_Text1: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(3i32);
pub const AM_L21_CCSERVICE_Text2: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(4i32);
pub const AM_L21_CCSERVICE_XDS: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(5i32);
pub const AM_L21_CCSTATE_Off: AM_LINE21_CCSTATE = AM_LINE21_CCSTATE(0i32);
pub const AM_L21_CCSTATE_On: AM_LINE21_CCSTATE = AM_LINE21_CCSTATE(1i32);
pub const AM_L21_CCSTYLE_None: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(0i32);
pub const AM_L21_CCSTYLE_PaintOn: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(2i32);
pub const AM_L21_CCSTYLE_PopOn: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(1i32);
pub const AM_L21_CCSTYLE_RollUp: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(3i32);
pub const AM_L21_DRAWBGMODE_Opaque: AM_LINE21_DRAWBGMODE = AM_LINE21_DRAWBGMODE(0i32);
pub const AM_L21_DRAWBGMODE_Transparent: AM_LINE21_DRAWBGMODE = AM_LINE21_DRAWBGMODE(1i32);
pub const AM_LOADSTATUS_CLOSED: u32 = 0u32;
pub const AM_LOADSTATUS_CONNECTING: u32 = 4u32;
pub const AM_LOADSTATUS_LOADINGDESCR: u32 = 1u32;
pub const AM_LOADSTATUS_LOADINGMCAST: u32 = 2u32;
pub const AM_LOADSTATUS_LOCATING: u32 = 3u32;
pub const AM_LOADSTATUS_OPEN: u32 = 6u32;
pub const AM_LOADSTATUS_OPENING: u32 = 5u32;
pub const AM_MACROVISION_DISABLED: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(0i32);
pub const AM_MACROVISION_LEVEL1: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(1i32);
pub const AM_MACROVISION_LEVEL2: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(2i32);
pub const AM_MACROVISION_LEVEL3: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(3i32);
pub const AM_MEDIAEVENT_NONOTIFY: AM_MEDIAEVENT_FLAGS = AM_MEDIAEVENT_FLAGS(1i32);
pub const AM_MPEG2Level_High: AM_MPEG2Level = AM_MPEG2Level(4i32);
pub const AM_MPEG2Level_High1440: AM_MPEG2Level = AM_MPEG2Level(3i32);
pub const AM_MPEG2Level_Low: AM_MPEG2Level = AM_MPEG2Level(1i32);
pub const AM_MPEG2Level_Main: AM_MPEG2Level = AM_MPEG2Level(2i32);
pub const AM_MPEG2Profile_High: AM_MPEG2Profile = AM_MPEG2Profile(5i32);
pub const AM_MPEG2Profile_Main: AM_MPEG2Profile = AM_MPEG2Profile(2i32);
pub const AM_MPEG2Profile_SNRScalable: AM_MPEG2Profile = AM_MPEG2Profile(3i32);
pub const AM_MPEG2Profile_Simple: AM_MPEG2Profile = AM_MPEG2Profile(1i32);
pub const AM_MPEG2Profile_SpatiallyScalable: AM_MPEG2Profile = AM_MPEG2Profile(4i32);
pub const AM_MPEG_AUDIO_DUAL_LEFT: u32 = 1u32;
pub const AM_MPEG_AUDIO_DUAL_MERGE: u32 = 0u32;
pub const AM_MPEG_AUDIO_DUAL_RIGHT: u32 = 2u32;
pub const AM_OVERLAY_NOTIFY_DEST_CHANGE: _AM_OVERLAY_NOTIFY_FLAGS = _AM_OVERLAY_NOTIFY_FLAGS(4i32);
pub const AM_OVERLAY_NOTIFY_SOURCE_CHANGE: _AM_OVERLAY_NOTIFY_FLAGS = _AM_OVERLAY_NOTIFY_FLAGS(2i32);
pub const AM_OVERLAY_NOTIFY_VISIBLE_CHANGE: _AM_OVERLAY_NOTIFY_FLAGS = _AM_OVERLAY_NOTIFY_FLAGS(1i32);
pub const AM_PIN_FLOW_CONTROL_BLOCK: _AM_PIN_FLOW_CONTROL_BLOCK_FLAGS = _AM_PIN_FLOW_CONTROL_BLOCK_FLAGS(1i32);
pub const AM_PROPERTY_AC3_ALTERNATE_AUDIO: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(2i32);
pub const AM_PROPERTY_AC3_BIT_STREAM_MODE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(4i32);
pub const AM_PROPERTY_AC3_DIALOGUE_LEVEL: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(5i32);
pub const AM_PROPERTY_AC3_DOWNMIX: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(3i32);
pub const AM_PROPERTY_AC3_ERROR_CONCEALMENT: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(1i32);
pub const AM_PROPERTY_AC3_LANGUAGE_CODE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(6i32);
pub const AM_PROPERTY_AC3_ROOM_TYPE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(7i32);
pub const AM_PROPERTY_COPY_ANALOG_COMPONENT: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(8i32);
pub const AM_PROPERTY_COPY_DIGITAL_CP: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(9i32);
pub const AM_PROPERTY_COPY_DVD_SRM: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(10i32);
pub const AM_PROPERTY_COPY_MACROVISION: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(5i32);
pub const AM_PROPERTY_DVDCOPY_CHLG_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(1i32);
pub const AM_PROPERTY_DVDCOPY_DEC_KEY2: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(3i32);
pub const AM_PROPERTY_DVDCOPY_DISC_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(128i32);
pub const AM_PROPERTY_DVDCOPY_DVD_KEY1: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(2i32);
pub const AM_PROPERTY_DVDCOPY_REGION: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(6i32);
pub const AM_PROPERTY_DVDCOPY_SET_COPY_STATE: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(7i32);
pub const AM_PROPERTY_DVDCOPY_SUPPORTS_NEW_KEYCOUNT: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(11i32);
pub const AM_PROPERTY_DVDCOPY_TITLE_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(4i32);
pub const AM_PROPERTY_DVDKARAOKE_DATA: AM_PROPERTY_DVDKARAOKE = AM_PROPERTY_DVDKARAOKE(1i32);
pub const AM_PROPERTY_DVDKARAOKE_ENABLE: AM_PROPERTY_DVDKARAOKE = AM_PROPERTY_DVDKARAOKE(0i32);
pub const AM_PROPERTY_DVDSUBPIC_COMPOSIT_ON: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(2i32);
pub const AM_PROPERTY_DVDSUBPIC_HLI: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(1i32);
pub const AM_PROPERTY_DVDSUBPIC_PALETTE: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(0i32);
pub const AM_PROPERTY_FRAMESTEP_CANCEL: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(2i32);
pub const AM_PROPERTY_FRAMESTEP_CANSTEP: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(3i32);
pub const AM_PROPERTY_FRAMESTEP_CANSTEPMULTIPLE: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(4i32);
pub const AM_PROPERTY_FRAMESTEP_STEP: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(1i32);
pub const AM_PUSHSOURCECAPS_INTERNAL_RM: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(1i32);
pub const AM_PUSHSOURCECAPS_NOT_LIVE: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(2i32);
pub const AM_PUSHSOURCECAPS_PRIVATE_CLOCK: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(4i32);
pub const AM_PUSHSOURCEREQS_USE_CLOCK_CHAIN: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(131072i32);
pub const AM_PUSHSOURCEREQS_USE_STREAM_CLOCK: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(65536i32);
pub const AM_QUERY_DECODER_ATSC_HD_SUPPORT: u32 = 5u32;
pub const AM_QUERY_DECODER_ATSC_SD_SUPPORT: u32 = 4u32;
pub const AM_QUERY_DECODER_DVD_SUPPORT: u32 = 3u32;
pub const AM_QUERY_DECODER_DXVA_1_SUPPORT: u32 = 2u32;
pub const AM_QUERY_DECODER_VMR_SUPPORT: u32 = 1u32;
pub const AM_RATE_ChangeRate: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(1i32);
pub const AM_RATE_CorrectTS: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(8i32);
pub const AM_RATE_DecoderPosition: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(4i32);
pub const AM_RATE_DecoderVersion: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(5i32);
pub const AM_RATE_ExactRateChange: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(2i32);
pub const AM_RATE_FullDataRateMax: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(2i32);
pub const AM_RATE_MaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(3i32);
pub const AM_RATE_QueryFullFrameRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(6i32);
pub const AM_RATE_QueryLastRateSegPTS: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(7i32);
pub const AM_RATE_QueryMapping: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(11i32);
pub const AM_RATE_ResetOnTimeDisc: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(10i32);
pub const AM_RATE_ReverseDecode: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(3i32);
pub const AM_RATE_ReverseMaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(9i32);
pub const AM_RATE_SimpleRateChange: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(1i32);
pub const AM_RATE_Step: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(4i32);
pub const AM_RATE_UseRateVersion: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(5i32);
pub const AM_RENDEREX_RENDERTOEXISTINGRENDERERS: _AM_RENSDEREXFLAGS = _AM_RENSDEREXFLAGS(1i32);
pub const AM_ReverseBlockEnd: u32 = 4u32;
pub const AM_ReverseBlockStart: u32 = 2u32;
pub const AM_SAMPLE_DATADISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(4i32);
pub const AM_SAMPLE_ENDOFSTREAM: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(512i32);
pub const AM_SAMPLE_FLUSH_ON_PAUSE: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(128i32);
pub const AM_SAMPLE_PREROLL: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(2i32);
pub const AM_SAMPLE_SPLICEPOINT: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(1i32);
pub const AM_SAMPLE_STOPVALID: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(256i32);
pub const AM_SAMPLE_TIMEDISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(64i32);
pub const AM_SAMPLE_TIMEVALID: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(16i32);
pub const AM_SAMPLE_TYPECHANGED: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(8i32);
pub const AM_SEEKING_AbsolutePositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(1i32);
pub const AM_SEEKING_CanDoSegments: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(128i32);
pub const AM_SEEKING_CanGetCurrentPos: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(8i32);
pub const AM_SEEKING_CanGetDuration: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(32i32);
pub const AM_SEEKING_CanGetStopPos: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(16i32);
pub const AM_SEEKING_CanPlayBackwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(64i32);
pub const AM_SEEKING_CanSeekAbsolute: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(1i32);
pub const AM_SEEKING_CanSeekBackwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(4i32);
pub const AM_SEEKING_CanSeekForwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(2i32);
pub const AM_SEEKING_IncrementalPositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(3i32);
pub const AM_SEEKING_NoFlush: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(32i32);
pub const AM_SEEKING_NoPositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(0i32);
pub const AM_SEEKING_PositioningBitsMask: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(3i32);
pub const AM_SEEKING_RelativePositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(2i32);
pub const AM_SEEKING_ReturnTime: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(8i32);
pub const AM_SEEKING_SeekToKeyFrame: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(4i32);
pub const AM_SEEKING_Segment: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(16i32);
pub const AM_SEEKING_Source: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(256i32);
pub const AM_STREAM_CONTROL: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(1i32);
pub const AM_STREAM_INFO_DISCARDING: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(4i32);
pub const AM_STREAM_INFO_START_DEFINED: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(1i32);
pub const AM_STREAM_INFO_STOP_DEFINED: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(2i32);
pub const AM_STREAM_INFO_STOP_SEND_EXTRA: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(16i32);
pub const AM_STREAM_MEDIA: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(0i32);
pub const AM_UseNewCSSKey: u32 = 1u32;
pub const AM_VIDEO_FLAG_B_SAMPLE: i32 = 32i32;
pub const AM_VIDEO_FLAG_FIELD1: i32 = 1i32;
pub const AM_VIDEO_FLAG_FIELD1FIRST: i32 = 4i32;
pub const AM_VIDEO_FLAG_FIELD2: i32 = 2i32;
pub const AM_VIDEO_FLAG_FIELD_MASK: i32 = 3i32;
pub const AM_VIDEO_FLAG_INTERLEAVED_FRAME: i32 = 0i32;
pub const AM_VIDEO_FLAG_IPB_MASK: i32 = 48i32;
pub const AM_VIDEO_FLAG_I_SAMPLE: i32 = 0i32;
pub const AM_VIDEO_FLAG_P_SAMPLE: i32 = 16i32;
pub const AM_VIDEO_FLAG_REPEAT_FIELD: i32 = 64i32;
pub const AM_VIDEO_FLAG_WEAVE: i32 = 8i32;
pub const AM_WST_DRAWBGMODE_Opaque: AM_WST_DRAWBGMODE = AM_WST_DRAWBGMODE(0i32);
pub const AM_WST_DRAWBGMODE_Transparent: AM_WST_DRAWBGMODE = AM_WST_DRAWBGMODE(1i32);
pub const AM_WST_LEVEL_1_5: AM_WST_LEVEL = AM_WST_LEVEL(0i32);
pub const AM_WST_SERVICE_IDS: AM_WST_SERVICE = AM_WST_SERVICE(2i32);
pub const AM_WST_SERVICE_Invalid: AM_WST_SERVICE = AM_WST_SERVICE(3i32);
pub const AM_WST_SERVICE_None: AM_WST_SERVICE = AM_WST_SERVICE(0i32);
pub const AM_WST_SERVICE_Text: AM_WST_SERVICE = AM_WST_SERVICE(1i32);
pub const AM_WST_STATE_Off: AM_WST_STATE = AM_WST_STATE(0i32);
pub const AM_WST_STATE_On: AM_WST_STATE = AM_WST_STATE(1i32);
pub const AM_WST_STYLE_Invers: AM_WST_STYLE = AM_WST_STYLE(1i32);
pub const AM_WST_STYLE_None: AM_WST_STYLE = AM_WST_STYLE(0i32);
pub const ANNEX_A_DSM_CC: MPEG2StreamType = MPEG2StreamType(8i32);
pub const ATSCCT_AC3: ATSCComponentTypeFlags = ATSCComponentTypeFlags(1i32);
pub const AVIF_COPYRIGHTED: u32 = 131072u32;
pub const AVIF_HASINDEX: u32 = 16u32;
pub const AVIF_ISINTERLEAVED: u32 = 256u32;
pub const AVIF_MUSTUSEINDEX: u32 = 32u32;
pub const AVIF_TRUSTCKTYPE: u32 = 2048u32;
pub const AVIF_WASCAPTUREFILE: u32 = 65536u32;
pub const AVIIF_COMPRESSOR: u32 = 268369920u32;
pub const AVIIF_COMPUSE: i32 = 268369920i32;
pub const AVIIF_FIRSTPART: i32 = 32i32;
pub const AVIIF_KEYFRAME: i32 = 16i32;
pub const AVIIF_LASTPART: i32 = 64i32;
pub const AVIIF_LIST: i32 = 1i32;
pub const AVIIF_NOTIME: i32 = 256i32;
pub const AVIIF_NO_TIME: u32 = 256u32;
pub const AVISF_DISABLED: u32 = 1u32;
pub const AVISF_VIDEO_PALCHANGES: u32 = 65536u32;
pub const AVISTDINDEX_DELTAFRAME: u32 = 2147483648u32;
pub const AVI_HEADERSIZE: u32 = 2048u32;
pub const AVI_INDEX_IS_DATA: u32 = 128u32;
pub const AVI_INDEX_OF_CHUNKS: u32 = 1u32;
pub const AVI_INDEX_OF_INDEXES: u32 = 0u32;
pub const AVI_INDEX_OF_SUB_2FIELD: u32 = 3u32;
pub const AVI_INDEX_OF_TIMED_CHUNKS: u32 = 2u32;
pub const AVI_INDEX_SUB_2FIELD: u32 = 1u32;
pub const AVI_INDEX_SUB_DEFAULT: u32 = 0u32;
pub const AnalogVideoMask_MCE_NTSC: AnalogVideoStandard = AnalogVideoStandard(1052167i32);
pub const AnalogVideoMask_MCE_PAL: AnalogVideoStandard = AnalogVideoStandard(496i32);
pub const AnalogVideoMask_MCE_SECAM: AnalogVideoStandard = AnalogVideoStandard(1044480i32);
pub const AnalogVideo_NTSC_433: AnalogVideoStandard = AnalogVideoStandard(4i32);
pub const AnalogVideo_NTSC_M: AnalogVideoStandard = AnalogVideoStandard(1i32);
pub const AnalogVideo_NTSC_M_J: AnalogVideoStandard = AnalogVideoStandard(2i32);
pub const AnalogVideo_NTSC_Mask: u32 = 7u32;
pub const AnalogVideo_None: AnalogVideoStandard = AnalogVideoStandard(0i32);
pub const AnalogVideo_PAL_60: AnalogVideoStandard = AnalogVideoStandard(2048i32);
pub const AnalogVideo_PAL_B: AnalogVideoStandard = AnalogVideoStandard(16i32);
pub const AnalogVideo_PAL_D: AnalogVideoStandard = AnalogVideoStandard(32i32);
pub const AnalogVideo_PAL_G: AnalogVideoStandard = AnalogVideoStandard(64i32);
pub const AnalogVideo_PAL_H: AnalogVideoStandard = AnalogVideoStandard(128i32);
pub const AnalogVideo_PAL_I: AnalogVideoStandard = AnalogVideoStandard(256i32);
pub const AnalogVideo_PAL_M: AnalogVideoStandard = AnalogVideoStandard(512i32);
pub const AnalogVideo_PAL_Mask: u32 = 1052656u32;
pub const AnalogVideo_PAL_N: AnalogVideoStandard = AnalogVideoStandard(1024i32);
pub const AnalogVideo_PAL_N_COMBO: AnalogVideoStandard = AnalogVideoStandard(1048576i32);
pub const AnalogVideo_SECAM_B: AnalogVideoStandard = AnalogVideoStandard(4096i32);
pub const AnalogVideo_SECAM_D: AnalogVideoStandard = AnalogVideoStandard(8192i32);
pub const AnalogVideo_SECAM_G: AnalogVideoStandard = AnalogVideoStandard(16384i32);
pub const AnalogVideo_SECAM_H: AnalogVideoStandard = AnalogVideoStandard(32768i32);
pub const AnalogVideo_SECAM_K: AnalogVideoStandard = AnalogVideoStandard(65536i32);
pub const AnalogVideo_SECAM_K1: AnalogVideoStandard = AnalogVideoStandard(131072i32);
pub const AnalogVideo_SECAM_L: AnalogVideoStandard = AnalogVideoStandard(262144i32);
pub const AnalogVideo_SECAM_L1: AnalogVideoStandard = AnalogVideoStandard(524288i32);
pub const AnalogVideo_SECAM_Mask: u32 = 1044480u32;
pub const Associated: SmartCardAssociationType = SmartCardAssociationType(1i32);
pub const AssociationUnknown: SmartCardAssociationType = SmartCardAssociationType(2i32);
pub const BDACOMP_EXCLUDE_TS_FROM_TR: BDA_Comp_Flags = BDA_Comp_Flags(1i32);
pub const BDACOMP_INCLUDE_COMPONENTS_IN_TR: BDA_Comp_Flags = BDA_Comp_Flags(4i32);
pub const BDACOMP_INCLUDE_LOCATOR_IN_TR: BDA_Comp_Flags = BDA_Comp_Flags(2i32);
pub const BDACOMP_NOT_DEFINED: BDA_Comp_Flags = BDA_Comp_Flags(0i32);
pub const BDA_BCC_RATE_1_2: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(1i32);
pub const BDA_BCC_RATE_1_3: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(10i32);
pub const BDA_BCC_RATE_1_4: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(9i32);
pub const BDA_BCC_RATE_2_3: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(2i32);
pub const BDA_BCC_RATE_2_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(11i32);
pub const BDA_BCC_RATE_3_4: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(3i32);
pub const BDA_BCC_RATE_3_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(4i32);
pub const BDA_BCC_RATE_4_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(5i32);
pub const BDA_BCC_RATE_5_11: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(7i32);
pub const BDA_BCC_RATE_5_6: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(6i32);
pub const BDA_BCC_RATE_6_7: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(12i32);
pub const BDA_BCC_RATE_7_8: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(8i32);
pub const BDA_BCC_RATE_8_9: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(13i32);
pub const BDA_BCC_RATE_9_10: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(14i32);
pub const BDA_BCC_RATE_MAX: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(15i32);
pub const BDA_BCC_RATE_NOT_DEFINED: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(0i32);
pub const BDA_BCC_RATE_NOT_SET: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(-1i32);
pub const BDA_CHANGES_COMPLETE: BDA_CHANGE_STATE = BDA_CHANGE_STATE(0i32);
pub const BDA_CHANGES_PENDING: BDA_CHANGE_STATE = BDA_CHANGE_STATE(1i32);
pub const BDA_CHAN_BANDWITH_NOT_DEFINED: BDA_Channel_Bandwidth = BDA_Channel_Bandwidth(0i32);
pub const BDA_CHAN_BANDWITH_NOT_SET: BDA_Channel_Bandwidth = BDA_Channel_Bandwidth(-1i32);
pub const BDA_DISCOVERY_COMPLETE: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(2i32);
pub const BDA_DISCOVERY_REQUIRED: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(1i32);
pub const BDA_DISCOVERY_UNSPECIFIED: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(0i32);
pub const BDA_DrmPairing_Aborted: BDA_DrmPairingError = BDA_DrmPairingError(8i32);
pub const BDA_DrmPairing_DrmInitFailed: BDA_DrmPairingError = BDA_DrmPairingError(5i32);
pub const BDA_DrmPairing_DrmNotPaired: BDA_DrmPairingError = BDA_DrmPairingError(6i32);
pub const BDA_DrmPairing_DrmRePairSoon: BDA_DrmPairingError = BDA_DrmPairingError(7i32);
pub const BDA_DrmPairing_HardwareFailure: BDA_DrmPairingError = BDA_DrmPairingError(1i32);
pub const BDA_DrmPairing_NeedIndiv: BDA_DrmPairingError = BDA_DrmPairingError(3i32);
pub const BDA_DrmPairing_NeedRevocationData: BDA_DrmPairingError = BDA_DrmPairingError(2i32);
pub const BDA_DrmPairing_NeedSDKUpdate: BDA_DrmPairingError = BDA_DrmPairingError(9i32);
pub const BDA_DrmPairing_Other: BDA_DrmPairingError = BDA_DrmPairingError(4i32);
pub const BDA_DrmPairing_Succeeded: BDA_DrmPairingError = BDA_DrmPairingError(0i32);
pub const BDA_EVENT_ACCESS_DENIED: BDA_EVENT_ID = BDA_EVENT_ID(15i32);
pub const BDA_EVENT_ACCESS_GRANTED: BDA_EVENT_ID = BDA_EVENT_ID(14i32);
pub const BDA_EVENT_CHANNEL_ACQUIRED: BDA_EVENT_ID = BDA_EVENT_ID(4i32);
pub const BDA_EVENT_CHANNEL_ACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(7i32);
pub const BDA_EVENT_CHANNEL_DEACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(8i32);
pub const BDA_EVENT_CHANNEL_LOST: BDA_EVENT_ID = BDA_EVENT_ID(5i32);
pub const BDA_EVENT_CHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = BDA_EVENT_ID(6i32);
pub const BDA_EVENT_DATA_START: BDA_EVENT_ID = BDA_EVENT_ID(2i32);
pub const BDA_EVENT_DATA_STOP: BDA_EVENT_ID = BDA_EVENT_ID(3i32);
pub const BDA_EVENT_OFFER_EXTENDED: BDA_EVENT_ID = BDA_EVENT_ID(16i32);
pub const BDA_EVENT_PURCHASE_COMPLETED: BDA_EVENT_ID = BDA_EVENT_ID(17i32);
pub const BDA_EVENT_SIGNAL_LOCK: BDA_EVENT_ID = BDA_EVENT_ID(1i32);
pub const BDA_EVENT_SIGNAL_LOSS: BDA_EVENT_ID = BDA_EVENT_ID(0i32);
pub const BDA_EVENT_SMART_CARD_INSERTED: BDA_EVENT_ID = BDA_EVENT_ID(18i32);
pub const BDA_EVENT_SMART_CARD_REMOVED: BDA_EVENT_ID = BDA_EVENT_ID(19i32);
pub const BDA_EVENT_SUBCHANNEL_ACQUIRED: BDA_EVENT_ID = BDA_EVENT_ID(9i32);
pub const BDA_EVENT_SUBCHANNEL_ACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(12i32);
pub const BDA_EVENT_SUBCHANNEL_DEACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(13i32);
pub const BDA_EVENT_SUBCHANNEL_LOST: BDA_EVENT_ID = BDA_EVENT_ID(10i32);
pub const BDA_EVENT_SUBCHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = BDA_EVENT_ID(11i32);
pub const BDA_E_ACCESS_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040009_u32 as _);
pub const BDA_E_BUFFER_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004000B_u32 as _);
pub const BDA_E_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004000E_u32 as _);
pub const BDA_E_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040001_u32 as _);
pub const BDA_E_INVALID_CAPTURE_TOKEN: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0044002_u32 as _);
pub const BDA_E_INVALID_ENTITLEMENT_TOKEN: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0044001_u32 as _);
pub const BDA_E_INVALID_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040006_u32 as _);
pub const BDA_E_INVALID_LANGUAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040010_u32 as _);
pub const BDA_E_INVALID_PURCHASE_TOKEN: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0044004_u32 as _);
pub const BDA_E_INVALID_SCHEMA: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040005_u32 as _);
pub const BDA_E_INVALID_TUNE_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0043004_u32 as _);
pub const BDA_E_INVALID_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040007_u32 as _);
pub const BDA_E_IPNETWORK_ADDRESS_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0045002_u32 as _);
pub const BDA_E_IPNETWORK_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0045001_u32 as _);
pub const BDA_E_IPNETWORK_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0045003_u32 as _);
pub const BDA_E_IPNETWORK_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0045004_u32 as _);
pub const BDA_E_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004000A_u32 as _);
pub const BDA_E_NOT_IMPLEMENTED: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040002_u32 as _);
pub const BDA_E_NO_HANDLER: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004000F_u32 as _);
pub const BDA_E_NO_MORE_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0041002_u32 as _);
pub const BDA_E_NO_MORE_EVENTS: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0041001_u32 as _);
pub const BDA_E_NO_SUCH_COMMAND: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040003_u32 as _);
pub const BDA_E_OUT_OF_BOUNDS: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040004_u32 as _);
pub const BDA_E_OUT_OF_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004000D_u32 as _);
pub const BDA_E_OUT_OF_RESOURCES: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004000C_u32 as _);
pub const BDA_E_READ_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040008_u32 as _);
pub const BDA_E_TIMEOUT_ELAPSED: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0040011_u32 as _);
pub const BDA_E_TUNER_CONFLICT: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0043003_u32 as _);
pub const BDA_E_TUNER_INITIALIZING: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0043001_u32 as _);
pub const BDA_E_TUNER_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0043002_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV01: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046001_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV02: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046002_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV03: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046003_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV04: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046004_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV05: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046005_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV06: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046006_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV07: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046007_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV08: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0046008_u32 as _);
pub const BDA_E_TUNE_FAILED_SDVFF: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC00460FF_u32 as _);
pub const BDA_E_WMDRM_INVALID_CERTIFICATE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004F002_u32 as _);
pub const BDA_E_WMDRM_INVALID_DATE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004F005_u32 as _);
pub const BDA_E_WMDRM_INVALID_PROXIMITY: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004F006_u32 as _);
pub const BDA_E_WMDRM_INVALID_SIGNATURE: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004F001_u32 as _);
pub const BDA_E_WMDRM_INVALID_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004F004_u32 as _);
pub const BDA_E_WMDRM_KEY_ID_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC004F008_u32 as _);
pub const BDA_E_WOULD_DISRUPT_STREAMING: ::windows_core::HRESULT = ::windows_core::HRESULT(0xC0044003_u32 as _);
pub const BDA_FEC_BCH: FECMethod = FECMethod(4i32);
pub const BDA_FEC_LDPC: FECMethod = FECMethod(3i32);
pub const BDA_FEC_MAX: FECMethod = FECMethod(6i32);
pub const BDA_FEC_METHOD_NOT_DEFINED: FECMethod = FECMethod(0i32);
pub const BDA_FEC_METHOD_NOT_SET: FECMethod = FECMethod(-1i32);
pub const BDA_FEC_RS_147_130: FECMethod = FECMethod(5i32);
pub const BDA_FEC_RS_204_188: FECMethod = FECMethod(2i32);
pub const BDA_FEC_VITERBI: FECMethod = FECMethod(1i32);
pub const BDA_FILTERED_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(1i32);
pub const BDA_FREQUENCY_MULTIPLIER_NOT_DEFINED: BDA_Frequency_Multiplier = BDA_Frequency_Multiplier(0i32);
pub const BDA_FREQUENCY_MULTIPLIER_NOT_SET: BDA_Frequency_Multiplier = BDA_Frequency_Multiplier(-1i32);
pub const BDA_FREQUENCY_NOT_DEFINED: BDA_Frequency = BDA_Frequency(0i32);
pub const BDA_FREQUENCY_NOT_SET: BDA_Frequency = BDA_Frequency(-1i32);
pub const BDA_GUARD_19_128: GuardInterval = GuardInterval(6i32);
pub const BDA_GUARD_19_256: GuardInterval = GuardInterval(7i32);
pub const BDA_GUARD_1_128: GuardInterval = GuardInterval(5i32);
pub const BDA_GUARD_1_16: GuardInterval = GuardInterval(2i32);
pub const BDA_GUARD_1_32: GuardInterval = GuardInterval(1i32);
pub const BDA_GUARD_1_4: GuardInterval = GuardInterval(4i32);
pub const BDA_GUARD_1_8: GuardInterval = GuardInterval(3i32);
pub const BDA_GUARD_MAX: GuardInterval = GuardInterval(8i32);
pub const BDA_GUARD_NOT_DEFINED: GuardInterval = GuardInterval(0i32);
pub const BDA_GUARD_NOT_SET: GuardInterval = GuardInterval(-1i32);
pub const BDA_HALPHA_1: HierarchyAlpha = HierarchyAlpha(1i32);
pub const BDA_HALPHA_2: HierarchyAlpha = HierarchyAlpha(2i32);
pub const BDA_HALPHA_4: HierarchyAlpha = HierarchyAlpha(3i32);
pub const BDA_HALPHA_MAX: HierarchyAlpha = HierarchyAlpha(4i32);
pub const BDA_HALPHA_NOT_DEFINED: HierarchyAlpha = HierarchyAlpha(0i32);
pub const BDA_HALPHA_NOT_SET: HierarchyAlpha = HierarchyAlpha(-1i32);
pub const BDA_LNB_SOURCE_A: LNB_Source = LNB_Source(1i32);
pub const BDA_LNB_SOURCE_B: LNB_Source = LNB_Source(2i32);
pub const BDA_LNB_SOURCE_C: LNB_Source = LNB_Source(3i32);
pub const BDA_LNB_SOURCE_D: LNB_Source = LNB_Source(4i32);
pub const BDA_LNB_SOURCE_MAX: LNB_Source = LNB_Source(5i32);
pub const BDA_LNB_SOURCE_NOT_DEFINED: LNB_Source = LNB_Source(0i32);
pub const BDA_LNB_SOURCE_NOT_SET: LNB_Source = LNB_Source(-1i32);
pub const BDA_MOD_1024QAM: ModulationType = ModulationType(19i32);
pub const BDA_MOD_112QAM: ModulationType = ModulationType(6i32);
pub const BDA_MOD_128QAM: ModulationType = ModulationType(7i32);
pub const BDA_MOD_160QAM: ModulationType = ModulationType(8i32);
pub const BDA_MOD_16APSK: ModulationType = ModulationType(29i32);
pub const BDA_MOD_16QAM: ModulationType = ModulationType(1i32);
pub const BDA_MOD_16VSB: ModulationType = ModulationType(24i32);
pub const BDA_MOD_192QAM: ModulationType = ModulationType(9i32);
pub const BDA_MOD_224QAM: ModulationType = ModulationType(10i32);
pub const BDA_MOD_256QAM: ModulationType = ModulationType(11i32);
pub const BDA_MOD_320QAM: ModulationType = ModulationType(12i32);
pub const BDA_MOD_32APSK: ModulationType = ModulationType(30i32);
pub const BDA_MOD_32QAM: ModulationType = ModulationType(2i32);
pub const BDA_MOD_384QAM: ModulationType = ModulationType(13i32);
pub const BDA_MOD_448QAM: ModulationType = ModulationType(14i32);
pub const BDA_MOD_512QAM: ModulationType = ModulationType(15i32);
pub const BDA_MOD_640QAM: ModulationType = ModulationType(16i32);
pub const BDA_MOD_64QAM: ModulationType = ModulationType(3i32);
pub const BDA_MOD_768QAM: ModulationType = ModulationType(17i32);
pub const BDA_MOD_80QAM: ModulationType = ModulationType(4i32);
pub const BDA_MOD_896QAM: ModulationType = ModulationType(18i32);
pub const BDA_MOD_8PSK: ModulationType = ModulationType(27i32);
pub const BDA_MOD_8VSB: ModulationType = ModulationType(23i32);
pub const BDA_MOD_96QAM: ModulationType = ModulationType(5i32);
pub const BDA_MOD_ANALOG_AMPLITUDE: ModulationType = ModulationType(25i32);
pub const BDA_MOD_ANALOG_FREQUENCY: ModulationType = ModulationType(26i32);
pub const BDA_MOD_BPSK: ModulationType = ModulationType(21i32);
pub const BDA_MOD_DIRECTV: ModulationType = ModulationType(33i32);
pub const BDA_MOD_ISDB_S_TMCC: ModulationType = ModulationType(35i32);
pub const BDA_MOD_ISDB_T_TMCC: ModulationType = ModulationType(34i32);
pub const BDA_MOD_MAX: ModulationType = ModulationType(36i32);
pub const BDA_MOD_NBC_8PSK: ModulationType = ModulationType(32i32);
pub const BDA_MOD_NBC_QPSK: ModulationType = ModulationType(31i32);
pub const BDA_MOD_NOT_DEFINED: ModulationType = ModulationType(0i32);
pub const BDA_MOD_NOT_SET: ModulationType = ModulationType(-1i32);
pub const BDA_MOD_OQPSK: ModulationType = ModulationType(22i32);
pub const BDA_MOD_QPSK: ModulationType = ModulationType(20i32);
pub const BDA_MOD_RF: ModulationType = ModulationType(28i32);
pub const BDA_NO_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(2i32);
pub const BDA_PILOT_MAX: Pilot = Pilot(3i32);
pub const BDA_PILOT_NOT_DEFINED: Pilot = Pilot(0i32);
pub const BDA_PILOT_NOT_SET: Pilot = Pilot(-1i32);
pub const BDA_PILOT_OFF: Pilot = Pilot(1i32);
pub const BDA_PILOT_ON: Pilot = Pilot(2i32);
pub const BDA_PLP_ID_NOT_SET: i32 = -1i32;
pub const BDA_POLARISATION_CIRCULAR_L: Polarisation = Polarisation(3i32);
pub const BDA_POLARISATION_CIRCULAR_R: Polarisation = Polarisation(4i32);
pub const BDA_POLARISATION_LINEAR_H: Polarisation = Polarisation(1i32);
pub const BDA_POLARISATION_LINEAR_V: Polarisation = Polarisation(2i32);
pub const BDA_POLARISATION_MAX: Polarisation = Polarisation(5i32);
pub const BDA_POLARISATION_NOT_DEFINED: Polarisation = Polarisation(0i32);
pub const BDA_POLARISATION_NOT_SET: Polarisation = Polarisation(-1i32);
pub const BDA_PROMISCUOUS_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(0i32);
pub const BDA_RANGE_NOT_DEFINED: BDA_Range = BDA_Range(0i32);
pub const BDA_RANGE_NOT_SET: BDA_Range = BDA_Range(-1i32);
pub const BDA_ROLL_OFF_20: RollOff = RollOff(1i32);
pub const BDA_ROLL_OFF_25: RollOff = RollOff(2i32);
pub const BDA_ROLL_OFF_35: RollOff = RollOff(3i32);
pub const BDA_ROLL_OFF_MAX: RollOff = RollOff(4i32);
pub const BDA_ROLL_OFF_NOT_DEFINED: RollOff = RollOff(0i32);
pub const BDA_ROLL_OFF_NOT_SET: RollOff = RollOff(-1i32);
pub const BDA_SCAN_MOD_1024QAM: ScanModulationTypes = ScanModulationTypes(262144i32);
pub const BDA_SCAN_MOD_112QAM: ScanModulationTypes = ScanModulationTypes(32i32);
pub const BDA_SCAN_MOD_128QAM: ScanModulationTypes = ScanModulationTypes(64i32);
pub const BDA_SCAN_MOD_160QAM: ScanModulationTypes = ScanModulationTypes(128i32);
pub const BDA_SCAN_MOD_16APSK: ScanModulationTypes = ScanModulationTypes(268435456i32);
pub const BDA_SCAN_MOD_16QAM: ScanModulationTypes = ScanModulationTypes(1i32);
pub const BDA_SCAN_MOD_16VSB: ScanModulationTypes = ScanModulationTypes(8388608i32);
pub const BDA_SCAN_MOD_192QAM: ScanModulationTypes = ScanModulationTypes(256i32);
pub const BDA_SCAN_MOD_224QAM: ScanModulationTypes = ScanModulationTypes(512i32);
pub const BDA_SCAN_MOD_256QAM: ScanModulationTypes = ScanModulationTypes(1024i32);
pub const BDA_SCAN_MOD_320QAM: ScanModulationTypes = ScanModulationTypes(2048i32);
pub const BDA_SCAN_MOD_32APSK: ScanModulationTypes = ScanModulationTypes(536870912i32);
pub const BDA_SCAN_MOD_32QAM: ScanModulationTypes = ScanModulationTypes(2i32);
pub const BDA_SCAN_MOD_384QAM: ScanModulationTypes = ScanModulationTypes(4096i32);
pub const BDA_SCAN_MOD_448QAM: ScanModulationTypes = ScanModulationTypes(8192i32);
pub const BDA_SCAN_MOD_512QAM: ScanModulationTypes = ScanModulationTypes(16384i32);
pub const BDA_SCAN_MOD_640QAM: ScanModulationTypes = ScanModulationTypes(32768i32);
pub const BDA_SCAN_MOD_64QAM: ScanModulationTypes = ScanModulationTypes(4i32);
pub const BDA_SCAN_MOD_768QAM: ScanModulationTypes = ScanModulationTypes(65536i32);
pub const BDA_SCAN_MOD_80QAM: ScanModulationTypes = ScanModulationTypes(8i32);
pub const BDA_SCAN_MOD_896QAM: ScanModulationTypes = ScanModulationTypes(131072i32);
pub const BDA_SCAN_MOD_8PSK: ScanModulationTypes = ScanModulationTypes(67108864i32);
pub const BDA_SCAN_MOD_8VSB: ScanModulationTypes = ScanModulationTypes(4194304i32);
pub const BDA_SCAN_MOD_96QAM: ScanModulationTypes = ScanModulationTypes(16i32);
pub const BDA_SCAN_MOD_AM_RADIO: ScanModulationTypes = ScanModulationTypes(16777216i32);
pub const BDA_SCAN_MOD_BPSK: ScanModulationTypes = ScanModulationTypes(1048576i32);
pub const BDA_SCAN_MOD_FM_RADIO: ScanModulationTypes = ScanModulationTypes(33554432i32);
pub const BDA_SCAN_MOD_OQPSK: ScanModulationTypes = ScanModulationTypes(2097152i32);
pub const BDA_SCAN_MOD_QPSK: ScanModulationTypes = ScanModulationTypes(524288i32);
pub const BDA_SCAN_MOD_RF: ScanModulationTypes = ScanModulationTypes(134217728i32);
pub const BDA_SIGNAL_ACTIVE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(2i32);
pub const BDA_SIGNAL_INACTIVE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(1i32);
pub const BDA_SIGNAL_UNAVAILABLE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(0i32);
pub const BDA_SPECTRAL_INVERSION_AUTOMATIC: SpectralInversion = SpectralInversion(1i32);
pub const BDA_SPECTRAL_INVERSION_INVERTED: SpectralInversion = SpectralInversion(3i32);
pub const BDA_SPECTRAL_INVERSION_MAX: SpectralInversion = SpectralInversion(4i32);
pub const BDA_SPECTRAL_INVERSION_NORMAL: SpectralInversion = SpectralInversion(2i32);
pub const BDA_SPECTRAL_INVERSION_NOT_DEFINED: SpectralInversion = SpectralInversion(0i32);
pub const BDA_SPECTRAL_INVERSION_NOT_SET: SpectralInversion = SpectralInversion(-1i32);
pub const BDA_UNDEFINED_CHANNEL: BDA_Channel = BDA_Channel(-1i32);
pub const BDA_UNITIALIZED_MPEG2STREAMTYPE: MPEG2StreamType = MPEG2StreamType(-1i32);
pub const BDA_XMIT_MODE_16K: TransmissionMode = TransmissionMode(7i32);
pub const BDA_XMIT_MODE_1K: TransmissionMode = TransmissionMode(6i32);
pub const BDA_XMIT_MODE_2K: TransmissionMode = TransmissionMode(1i32);
pub const BDA_XMIT_MODE_2K_INTERLEAVED: TransmissionMode = TransmissionMode(4i32);
pub const BDA_XMIT_MODE_32K: TransmissionMode = TransmissionMode(8i32);
pub const BDA_XMIT_MODE_4K: TransmissionMode = TransmissionMode(3i32);
pub const BDA_XMIT_MODE_4K_INTERLEAVED: TransmissionMode = TransmissionMode(5i32);
pub const BDA_XMIT_MODE_8K: TransmissionMode = TransmissionMode(2i32);
pub const BDA_XMIT_MODE_MAX: TransmissionMode = TransmissionMode(9i32);
pub const BDA_XMIT_MODE_NOT_DEFINED: TransmissionMode = TransmissionMode(0i32);
pub const BDA_XMIT_MODE_NOT_SET: TransmissionMode = TransmissionMode(-1i32);
pub const CATEGORY_COUNT: ComponentCategory = ComponentCategory(8i32);
pub const CDEF_BYPASS_CLASS_MANAGER: u32 = 2u32;
pub const CDEF_CLASS_DEFAULT: u32 = 1u32;
pub const CDEF_DEVMON_CMGR_DEVICE: u32 = 16u32;
pub const CDEF_DEVMON_DMO: u32 = 32u32;
pub const CDEF_DEVMON_FILTER: u32 = 128u32;
pub const CDEF_DEVMON_PNP_DEVICE: u32 = 64u32;
pub const CDEF_DEVMON_SELECTIVE_MASK: u32 = 240u32;
pub const CDEF_MERIT_ABOVE_DO_NOT_USE: u32 = 8u32;
pub const CFSTR_VFW_FILTERLIST: ::windows_core::PCSTR = ::windows_core::s!("Video for Windows 4 Filters");
pub const CHARS_IN_GUID: u32 = 39u32;
pub const CK_INDEX: COLORKEY_TYPE = COLORKEY_TYPE(1i32);
pub const CK_NOCOLORKEY: COLORKEY_TYPE = COLORKEY_TYPE(0i32);
pub const CK_RGB: COLORKEY_TYPE = COLORKEY_TYPE(2i32);
pub const CLSID_AMAudioData: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf2468580_af8a_11d0_8212_00c04fc32c45);
pub const CLSID_AMAudioStream: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8496e040_af4c_11d0_8212_00c04fc32c45);
pub const CLSID_AMDirectDrawStream: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x49c47ce4_9ba4_11d0_8212_00c04fc32c45);
pub const CLSID_AMMediaTypeStream: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcf0f2f7c_f7bf_11d0_900d_00c04fd9189d);
pub const CLSID_AMMultiMediaStream: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x49c47ce5_9ba4_11d0_8212_00c04fc32c45);
pub const CLSID_DMOFilterCategory: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbcd5796c_bd52_4d30_ab76_70f975b89199);
pub const CLSID_DMOWrapperFilter: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x94297043_bd82_4dfd_b0de_8177739c6d20);
pub const CLSID_PBDA_AUX_DATA_TYPE: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfd456373_3323_4090_adca_8ed45f55cf10);
pub const CLSID_PBDA_Encoder_DATA_TYPE: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x728fd6bc_5546_4716_b103_f899f5a1fa68);
pub const CLSID_PBDA_FDC_DATA_TYPE: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe7dbf9a0_22ab_4047_8e67_ef9ad504e729);
pub const CLSID_PBDA_GDDS_DATA_TYPE: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc80c0df3_6052_4c16_9f56_c44c21f73c45);
pub const COMPSTAT_ABORT: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(4i32);
pub const COMPSTAT_NOUPDATEOK: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(1i32);
pub const COMPSTAT_WAIT: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(2i32);
pub const CONDITIONALACCESS_ABORTED: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(2i32);
pub const CONDITIONALACCESS_ACCESS_NOT_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(1i32);
pub const CONDITIONALACCESS_ACCESS_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(2i32);
pub const CONDITIONALACCESS_ACCESS_POSSIBLE_NO_STREAMING_DISRUPTION: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(3i32);
pub const CONDITIONALACCESS_ACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(0i32);
pub const CONDITIONALACCESS_CLOSED_ITSELF: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(1i32);
pub const CONDITIONALACCESS_DIALOG_FOCUS_CHANGE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(4i32);
pub const CONDITIONALACCESS_DIALOG_TIMEOUT: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(3i32);
pub const CONDITIONALACCESS_DIALOG_USER_DISMISSED: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(5i32);
pub const CONDITIONALACCESS_DIALOG_USER_NOT_AVAILABLE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(6i32);
pub const CONDITIONALACCESS_ENDED_NOCHANGE: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(1i32);
pub const CONDITIONALACCESS_SUCCESSFULL: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(0i32);
pub const CONDITIONALACCESS_TUNER_REQUESTED_CLOSE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(2i32);
pub const CONDITIONALACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(0i32);
pub const COPP_ACP_ForceDWORD: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(2147483647i32);
pub const COPP_ACP_Level0: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(0i32);
pub const COPP_ACP_Level1: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(1i32);
pub const COPP_ACP_Level2: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(2i32);
pub const COPP_ACP_Level3: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(3i32);
pub const COPP_ACP_LevelMax: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(3i32);
pub const COPP_ACP_LevelMin: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(0i32);
pub const COPP_AspectRatio_EN300294_Box14by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(1i32);
pub const COPP_AspectRatio_EN300294_Box14by9Top: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(2i32);
pub const COPP_AspectRatio_EN300294_Box16by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(3i32);
pub const COPP_AspectRatio_EN300294_Box16by9Top: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(4i32);
pub const COPP_AspectRatio_EN300294_BoxGT16by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(5i32);
pub const COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(7i32);
pub const COPP_AspectRatio_EN300294_FullFormat4by3: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(0i32);
pub const COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(6i32);
pub const COPP_AspectRatio_ForceDWORD: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(2147483647i32);
pub const COPP_BusType_AGP: COPP_BusType = COPP_BusType(4i32);
pub const COPP_BusType_ForceDWORD: COPP_BusType = COPP_BusType(2147483647i32);
pub const COPP_BusType_Integrated: COPP_BusType = COPP_BusType(-2147483648i32);
pub const COPP_BusType_PCI: COPP_BusType = COPP_BusType(1i32);
pub const COPP_BusType_PCIExpress: COPP_BusType = COPP_BusType(3i32);
pub const COPP_BusType_PCIX: COPP_BusType = COPP_BusType(2i32);
pub const COPP_BusType_Unknown: COPP_BusType = COPP_BusType(0i32);
pub const COPP_CGMSA_CopyFreely: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(1i32);
pub const COPP_CGMSA_CopyNever: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(4i32);
pub const COPP_CGMSA_CopyNoMore: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(2i32);
pub const COPP_CGMSA_CopyOneGeneration: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(3i32);
pub const COPP_CGMSA_Disabled: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(0i32);
pub const COPP_CGMSA_ForceDWORD: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(2147483647i32);
pub const COPP_CGMSA_LevelMax: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(12i32);
pub const COPP_CGMSA_LevelMin: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(0i32);
pub const COPP_CGMSA_RedistributionControlRequired: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(8i32);
pub const COPP_ConnectorType_ComponentVideo: COPP_ConnectorType = COPP_ConnectorType(3i32);
pub const COPP_ConnectorType_CompositeVideo: COPP_ConnectorType = COPP_ConnectorType(2i32);
pub const COPP_ConnectorType_DVI: COPP_ConnectorType = COPP_ConnectorType(4i32);
pub const COPP_ConnectorType_D_JPN: COPP_ConnectorType = COPP_ConnectorType(8i32);
pub const COPP_ConnectorType_ForceDWORD: COPP_ConnectorType = COPP_ConnectorType(2147483647i32);
pub const COPP_ConnectorType_HDMI: COPP_ConnectorType = COPP_ConnectorType(5i32);
pub const COPP_ConnectorType_Internal: COPP_ConnectorType = COPP_ConnectorType(-2147483648i32);
pub const COPP_ConnectorType_LVDS: COPP_ConnectorType = COPP_ConnectorType(6i32);
pub const COPP_ConnectorType_SVideo: COPP_ConnectorType = COPP_ConnectorType(1i32);
pub const COPP_ConnectorType_TMDS: COPP_ConnectorType = COPP_ConnectorType(7i32);
pub const COPP_ConnectorType_Unknown: COPP_ConnectorType = COPP_ConnectorType(-1i32);
pub const COPP_ConnectorType_VGA: COPP_ConnectorType = COPP_ConnectorType(0i32);
pub const COPP_DefaultProtectionLevel: u32 = 0u32;
pub const COPP_HDCPFlagsReserved: COPP_StatusHDCPFlags = COPP_StatusHDCPFlags(-2i32);
pub const COPP_HDCPRepeater: COPP_StatusHDCPFlags = COPP_StatusHDCPFlags(1i32);
pub const COPP_HDCP_ForceDWORD: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(2147483647i32);
pub const COPP_HDCP_Level0: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(0i32);
pub const COPP_HDCP_Level1: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(1i32);
pub const COPP_HDCP_LevelMax: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(1i32);
pub const COPP_HDCP_LevelMin: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(0i32);
pub const COPP_ImageAspectRatio_EN300294_Mask: u32 = 7u32;
pub const COPP_LinkLost: COPP_StatusFlags = COPP_StatusFlags(1i32);
pub const COPP_NoProtectionLevelAvailable: i32 = -1i32;
pub const COPP_ProtectionStandard_ARIBTRB15_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(16384i32);
pub const COPP_ProtectionStandard_ARIBTRB15_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2048i32);
pub const COPP_ProtectionStandard_ARIBTRB15_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(4096i32);
pub const COPP_ProtectionStandard_ARIBTRB15_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(8192i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(128i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(32i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(64i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(1024i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(256i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(512i32);
pub const COPP_ProtectionStandard_EIA608B_525: COPP_TVProtectionStandard = COPP_TVProtectionStandard(8i32);
pub const COPP_ProtectionStandard_EN300294_625i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(16i32);
pub const COPP_ProtectionStandard_IEC61880_2_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2i32);
pub const COPP_ProtectionStandard_IEC61880_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(1i32);
pub const COPP_ProtectionStandard_IEC62375_625p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(4i32);
pub const COPP_ProtectionStandard_Mask: COPP_TVProtectionStandard = COPP_TVProtectionStandard(-2147450881i32);
pub const COPP_ProtectionStandard_None: COPP_TVProtectionStandard = COPP_TVProtectionStandard(0i32);
pub const COPP_ProtectionStandard_Reserved: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2147450880i32);
pub const COPP_ProtectionStandard_Unknown: COPP_TVProtectionStandard = COPP_TVProtectionStandard(-2147483648i32);
pub const COPP_RenegotiationRequired: COPP_StatusFlags = COPP_StatusFlags(2i32);
pub const COPP_StatusFlagsReserved: COPP_StatusFlags = COPP_StatusFlags(-4i32);
pub const COPP_StatusNormal: COPP_StatusFlags = COPP_StatusFlags(0i32);
pub const CameraControl_Exposure: CameraControlProperty = CameraControlProperty(4i32);
pub const CameraControl_Flags_Auto: CameraControlFlags = CameraControlFlags(1i32);
pub const CameraControl_Flags_Manual: CameraControlFlags = CameraControlFlags(2i32);
pub const CameraControl_Focus: CameraControlProperty = CameraControlProperty(6i32);
pub const CameraControl_Iris: CameraControlProperty = CameraControlProperty(5i32);
pub const CameraControl_Pan: CameraControlProperty = CameraControlProperty(0i32);
pub const CameraControl_Roll: CameraControlProperty = CameraControlProperty(2i32);
pub const CameraControl_Tilt: CameraControlProperty = CameraControlProperty(1i32);
pub const CameraControl_Zoom: CameraControlProperty = CameraControlProperty(3i32);
pub const CardDataChanged: SmartCardStatusType = SmartCardStatusType(3i32);
pub const CardError: SmartCardStatusType = SmartCardStatusType(2i32);
pub const CardFirmwareUpgrade: SmartCardStatusType = SmartCardStatusType(4i32);
pub const CardInserted: SmartCardStatusType = SmartCardStatusType(0i32);
pub const CardRemoved: SmartCardStatusType = SmartCardStatusType(1i32);
pub const CategoryAudio: ComponentCategory = ComponentCategory(2i32);
pub const CategoryCaptions: ComponentCategory = ComponentCategory(5i32);
pub const CategoryData: ComponentCategory = ComponentCategory(7i32);
pub const CategoryNotSet: ComponentCategory = ComponentCategory(-1i32);
pub const CategoryOther: ComponentCategory = ComponentCategory(0i32);
pub const CategorySubtitles: ComponentCategory = ComponentCategory(4i32);
pub const CategorySuperimpose: ComponentCategory = ComponentCategory(6i32);
pub const CategoryText: ComponentCategory = ComponentCategory(3i32);
pub const CategoryVideo: ComponentCategory = ComponentCategory(1i32);
pub const CompressionCaps_CanBFrame: CompressionCaps = CompressionCaps(8i32);
pub const CompressionCaps_CanCrunch: CompressionCaps = CompressionCaps(2i32);
pub const CompressionCaps_CanKeyFrame: CompressionCaps = CompressionCaps(4i32);
pub const CompressionCaps_CanQuality: CompressionCaps = CompressionCaps(1i32);
pub const CompressionCaps_CanWindow: CompressionCaps = CompressionCaps(16i32);
pub const ConstantBitRate: VIDEOENCODER_BITRATE_MODE = VIDEOENCODER_BITRATE_MODE(0i32);
pub const DDSFF_PROGRESSIVERENDER: DDSFF_FLAGS = DDSFF_FLAGS(1i32);
pub const DECIMATION_DEFAULT: DECIMATION_USAGE = DECIMATION_USAGE(4i32);
pub const DECIMATION_LEGACY: DECIMATION_USAGE = DECIMATION_USAGE(0i32);
pub const DECIMATION_USE_DECODER_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(1i32);
pub const DECIMATION_USE_OVERLAY_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(3i32);
pub const DECIMATION_USE_VIDEOPORT_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(2i32);
pub const DECODER_CAP_NOTSUPPORTED: u32 = 0u32;
pub const DECODER_CAP_SUPPORTED: u32 = 1u32;
pub const DISPLAY_16x9: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(1i32);
pub const DISPLAY_4x3_LETTERBOX_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(3i32);
pub const DISPLAY_4x3_PANSCAN_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(2i32);
pub const DISPLAY_CONTENT_DEFAULT: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(0i32);
pub const DOLBY_AC3_AUDIO: MPEG2StreamType = MPEG2StreamType(129i32);
pub const DOLBY_DIGITAL_PLUS_AUDIO_ATSC: MPEG2StreamType = MPEG2StreamType(135i32);
pub const DVB_Cable: DVBSystemType = DVBSystemType(0i32);
pub const DVB_Satellite: DVBSystemType = DVBSystemType(2i32);
pub const DVB_Terrestrial: DVBSystemType = DVBSystemType(1i32);
pub const DVDECODERRESOLUTION_180x120: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1002i32);
pub const DVDECODERRESOLUTION_360x240: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1001i32);
pub const DVDECODERRESOLUTION_720x480: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1000i32);
pub const DVDECODERRESOLUTION_88x60: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1003i32);
pub const DVD_AUDIO_CAPS_AC3: u32 = 1u32;
pub const DVD_AUDIO_CAPS_DTS: u32 = 8u32;
pub const DVD_AUDIO_CAPS_LPCM: u32 = 4u32;
pub const DVD_AUDIO_CAPS_MPEG2: u32 = 2u32;
pub const DVD_AUDIO_CAPS_SDDS: u32 = 16u32;
pub const DVD_AUD_EXT_Captions: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(1i32);
pub const DVD_AUD_EXT_DirectorComments1: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(3i32);
pub const DVD_AUD_EXT_DirectorComments2: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(4i32);
pub const DVD_AUD_EXT_NotSpecified: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(0i32);
pub const DVD_AUD_EXT_VisuallyImpaired: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(2i32);
pub const DVD_AppMode_Karaoke: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(1i32);
pub const DVD_AppMode_Not_Specified: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(0i32);
pub const DVD_AppMode_Other: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(3i32);
pub const DVD_Assignment_LR: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(2i32);
pub const DVD_Assignment_LR1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(4i32);
pub const DVD_Assignment_LR12: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(6i32);
pub const DVD_Assignment_LRM: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(3i32);
pub const DVD_Assignment_LRM1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(5i32);
pub const DVD_Assignment_LRM12: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(7i32);
pub const DVD_Assignment_reserved0: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(0i32);
pub const DVD_Assignment_reserved1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(1i32);
pub const DVD_AudioDuringFFwdRew: DVD_OPTION_FLAG = DVD_OPTION_FLAG(4i32);
pub const DVD_AudioFormat_AC3: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(0i32);
pub const DVD_AudioFormat_DTS: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(6i32);
pub const DVD_AudioFormat_LPCM: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(5i32);
pub const DVD_AudioFormat_MPEG1: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(1i32);
pub const DVD_AudioFormat_MPEG1_DRC: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(2i32);
pub const DVD_AudioFormat_MPEG2: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(3i32);
pub const DVD_AudioFormat_MPEG2_DRC: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(4i32);
pub const DVD_AudioFormat_Other: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(8i32);
pub const DVD_AudioFormat_SDDS: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(7i32);
pub const DVD_AudioMode_Karaoke: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(1i32);
pub const DVD_AudioMode_None: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(0i32);
pub const DVD_AudioMode_Other: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(3i32);
pub const DVD_AudioMode_Surround: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(2i32);
pub const DVD_CMD_FLAG_Block: DVD_CMD_FLAGS = DVD_CMD_FLAGS(4i32);
pub const DVD_CMD_FLAG_EndAfterRendered: DVD_CMD_FLAGS = DVD_CMD_FLAGS(16i32);
pub const DVD_CMD_FLAG_Flush: DVD_CMD_FLAGS = DVD_CMD_FLAGS(1i32);
pub const DVD_CMD_FLAG_None: DVD_CMD_FLAGS = DVD_CMD_FLAGS(0i32);
pub const DVD_CMD_FLAG_SendEvents: DVD_CMD_FLAGS = DVD_CMD_FLAGS(2i32);
pub const DVD_CMD_FLAG_StartWhenRendered: DVD_CMD_FLAGS = DVD_CMD_FLAGS(8i32);
pub const DVD_CacheSizeInMB: DVD_OPTION_FLAG = DVD_OPTION_FLAG(6i32);
pub const DVD_Channel_Audio: DVD_TextStringType = DVD_TextStringType(32i32);
pub const DVD_CharSet_ISO646: DVD_TextCharSet = DVD_TextCharSet(1i32);
pub const DVD_CharSet_ISO8859_1: DVD_TextCharSet = DVD_TextCharSet(3i32);
pub const DVD_CharSet_JIS_Roman_Kanji: DVD_TextCharSet = DVD_TextCharSet(2i32);
pub const DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana: DVD_TextCharSet = DVD_TextCharSet(4i32);
pub const DVD_CharSet_Unicode: DVD_TextCharSet = DVD_TextCharSet(0i32);
pub const DVD_DEFAULT_AUDIO_STREAM: u32 = 15u32;
pub const DVD_DIR_BACKWARD: DVD_PLAY_DIRECTION = DVD_PLAY_DIRECTION(1i32);
pub const DVD_DIR_FORWARD: DVD_PLAY_DIRECTION = DVD_PLAY_DIRECTION(0i32);
pub const DVD_DOMAIN_FirstPlay: DVD_DOMAIN = DVD_DOMAIN(1i32);
pub const DVD_DOMAIN_Stop: DVD_DOMAIN = DVD_DOMAIN(5i32);
pub const DVD_DOMAIN_Title: DVD_DOMAIN = DVD_DOMAIN(4i32);
pub const DVD_DOMAIN_VideoManagerMenu: DVD_DOMAIN = DVD_DOMAIN(2i32);
pub const DVD_DOMAIN_VideoTitleSetMenu: DVD_DOMAIN = DVD_DOMAIN(3i32);
pub const DVD_DisableStillThrottle: DVD_OPTION_FLAG = DVD_OPTION_FLAG(14i32);
pub const DVD_ERROR_CopyProtectFail: DVD_ERROR = DVD_ERROR(2i32);
pub const DVD_ERROR_CopyProtectOutputFail: DVD_ERROR = DVD_ERROR(9i32);
pub const DVD_ERROR_CopyProtectOutputNotSupported: DVD_ERROR = DVD_ERROR(10i32);
pub const DVD_ERROR_IncompatibleDiscAndDecoderRegions: DVD_ERROR = DVD_ERROR(8i32);
pub const DVD_ERROR_IncompatibleSystemAndDecoderRegions: DVD_ERROR = DVD_ERROR(7i32);
pub const DVD_ERROR_InvalidDVD1_0Disc: DVD_ERROR = DVD_ERROR(3i32);
pub const DVD_ERROR_InvalidDiscRegion: DVD_ERROR = DVD_ERROR(4i32);
pub const DVD_ERROR_LowParentalLevel: DVD_ERROR = DVD_ERROR(5i32);
pub const DVD_ERROR_MacrovisionFail: DVD_ERROR = DVD_ERROR(6i32);
pub const DVD_ERROR_Unexpected: DVD_ERROR = DVD_ERROR(1i32);
pub const DVD_EnableCC: DVD_OPTION_FLAG = DVD_OPTION_FLAG(19i32);
pub const DVD_EnableESOutput: DVD_OPTION_FLAG = DVD_OPTION_FLAG(12i32);
pub const DVD_EnableExtendedCopyProtectErrors: DVD_OPTION_FLAG = DVD_OPTION_FLAG(8i32);
pub const DVD_EnableLoggingEvents: DVD_OPTION_FLAG = DVD_OPTION_FLAG(15i32);
pub const DVD_EnableNonblockingAPIs: DVD_OPTION_FLAG = DVD_OPTION_FLAG(5i32);
pub const DVD_EnablePortableBookmarks: DVD_OPTION_FLAG = DVD_OPTION_FLAG(7i32);
pub const DVD_EnableStreaming: DVD_OPTION_FLAG = DVD_OPTION_FLAG(11i32);
pub const DVD_EnableTitleLength: DVD_OPTION_FLAG = DVD_OPTION_FLAG(13i32);
pub const DVD_FPS_25: DVD_FRAMERATE = DVD_FRAMERATE(1i32);
pub const DVD_FPS_30NonDrop: DVD_FRAMERATE = DVD_FRAMERATE(3i32);
pub const DVD_General_Comments: DVD_TextStringType = DVD_TextStringType(49i32);
pub const DVD_General_Name: DVD_TextStringType = DVD_TextStringType(48i32);
pub const DVD_HMSF_TimeCodeEvents: DVD_OPTION_FLAG = DVD_OPTION_FLAG(3i32);
pub const DVD_IncreaseOutputControl: DVD_OPTION_FLAG = DVD_OPTION_FLAG(10i32);
pub const DVD_Karaoke_GuideMelody1: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(4i32);
pub const DVD_Karaoke_GuideMelody2: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(8i32);
pub const DVD_Karaoke_GuideMelodyA: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(16i32);
pub const DVD_Karaoke_GuideMelodyB: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(32i32);
pub const DVD_Karaoke_GuideVocal1: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(1i32);
pub const DVD_Karaoke_GuideVocal2: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(2i32);
pub const DVD_Karaoke_SoundEffectA: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(64i32);
pub const DVD_Karaoke_SoundEffectB: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(128i32);
pub const DVD_MENU_Angle: DVD_MENU_ID = DVD_MENU_ID(6i32);
pub const DVD_MENU_Audio: DVD_MENU_ID = DVD_MENU_ID(5i32);
pub const DVD_MENU_Chapter: DVD_MENU_ID = DVD_MENU_ID(7i32);
pub const DVD_MENU_Root: DVD_MENU_ID = DVD_MENU_ID(3i32);
pub const DVD_MENU_Subpicture: DVD_MENU_ID = DVD_MENU_ID(4i32);
pub const DVD_MENU_Title: DVD_MENU_ID = DVD_MENU_ID(2i32);
pub const DVD_MaxReadBurstInKB: DVD_OPTION_FLAG = DVD_OPTION_FLAG(16i32);
pub const DVD_Mix_0to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(1i32);
pub const DVD_Mix_0to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(256i32);
pub const DVD_Mix_1to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(2i32);
pub const DVD_Mix_1to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(512i32);
pub const DVD_Mix_2to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(4i32);
pub const DVD_Mix_2to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(1024i32);
pub const DVD_Mix_3to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(8i32);
pub const DVD_Mix_3to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(2048i32);
pub const DVD_Mix_4to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(16i32);
pub const DVD_Mix_4to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(4096i32);
pub const DVD_Mix_Lto0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(32i32);
pub const DVD_Mix_Lto1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(8192i32);
pub const DVD_Mix_Rto0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(64i32);
pub const DVD_Mix_Rto1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(16384i32);
pub const DVD_NavCmdType_Button: DVD_NavCmdType = DVD_NavCmdType(4i32);
pub const DVD_NavCmdType_Cell: DVD_NavCmdType = DVD_NavCmdType(3i32);
pub const DVD_NavCmdType_Post: DVD_NavCmdType = DVD_NavCmdType(2i32);
pub const DVD_NavCmdType_Pre: DVD_NavCmdType = DVD_NavCmdType(1i32);
pub const DVD_NotifyParentalLevelChange: DVD_OPTION_FLAG = DVD_OPTION_FLAG(2i32);
pub const DVD_NotifyPositionChange: DVD_OPTION_FLAG = DVD_OPTION_FLAG(9i32);
pub const DVD_Other_Cut: DVD_TextStringType = DVD_TextStringType(81i32);
pub const DVD_Other_Scene: DVD_TextStringType = DVD_TextStringType(80i32);
pub const DVD_Other_Take: DVD_TextStringType = DVD_TextStringType(82i32);
pub const DVD_PARENTAL_LEVEL_1: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(256i32);
pub const DVD_PARENTAL_LEVEL_2: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(512i32);
pub const DVD_PARENTAL_LEVEL_3: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(1024i32);
pub const DVD_PARENTAL_LEVEL_4: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(2048i32);
pub const DVD_PARENTAL_LEVEL_5: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(4096i32);
pub const DVD_PARENTAL_LEVEL_6: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(8192i32);
pub const DVD_PARENTAL_LEVEL_7: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(16384i32);
pub const DVD_PARENTAL_LEVEL_8: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(32768i32);
pub const DVD_PB_STOPPED_CopyProtectFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(13i32);
pub const DVD_PB_STOPPED_CopyProtectOutputFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(14i32);
pub const DVD_PB_STOPPED_CopyProtectOutputNotSupported: DVD_PB_STOPPED = DVD_PB_STOPPED(15i32);
pub const DVD_PB_STOPPED_DiscEjected: DVD_PB_STOPPED = DVD_PB_STOPPED(5i32);
pub const DVD_PB_STOPPED_DiscReadError: DVD_PB_STOPPED = DVD_PB_STOPPED(12i32);
pub const DVD_PB_STOPPED_IllegalNavCommand: DVD_PB_STOPPED = DVD_PB_STOP