//
// Created by zxm on 2022/8/22.
//
#include <QCommandLineParser>
#include <QLocale>
#include <QScopedPointer>
#include <QTranslator>
#include <QDebug>
#include <stdio.h>
#include "utils/environments.h"
#include "BootVersionMgr.h"
#include "RollbackNotify.h"

int main(int argc, char **argv)
{
    const char kAppDesc[] = "uos-recovery-tool";
    QCoreApplication app(argc, argv);
    app.setApplicationVersion(VERSION);
    QString locale = QLocale::system().name();
    QString tsFile = QString("%1/uos-recovery-tool_%2.qm").arg(DI_I18N_TOOL_DIR_ENV, locale);
    QScopedPointer<QTranslator> translator(new QTranslator);
    if (!translator->load(tsFile)) {
        qWarning()<<"Failed to load ts: "<<tsFile;
    }
    qApp->installTranslator(translator.data());

    QCommandLineOption opActionType(QStringList()<<"a"<<"action",
                                    QString(QObject::tr("Choose an action type:\n") +
                                    "    bootlist:    " + QObject::tr("get boot list") + "\n" +
                                    "    notify:    " + QObject::tr("rollback notification") + "\n"));
    opActionType.setValueName("type");

    // init command line
    QCommandLineParser parser;
    parser.setApplicationDescription(kAppDesc);
    parser.addHelpOption();
    parser.addVersionOption();
    parser.addOption(opActionType);
    parser.process(app);

    if (!parser.parse(app.arguments())) {
        parser.showHelp(-1);
    }

    QString curAction = parser.value(opActionType);
    if (curAction == "bootlist") {
        BootVersionMgr bootVerMgr;
        QString bootList = bootVerMgr.getBootList();
    //    qInfo()<<bootList.toLocal8Bit().data()<<"\n";  // 原子更新修改了实现，只从标准输出获取数据
        printf("%s\n",bootList.toLocal8Bit().data());
    } else if (curAction == "notify") {
        RollbackNotify rollbackNotify;
        rollbackNotify.notify();
    } else {
        parser.showHelp(-1);
    }

    return 0;
}
