use progvis:lang:cpp:util;

class AssertError extends progvis:TypedError {
	Str message;

	init() {
		init("assert") {}
		progvis:program:onFatalException();
	}

	init(Str message) {
		init("assert") { message = message; }
		progvis:program:onFatalException();
	}

	void message(StrBuf to) : override {
		to << "Assertion failed";
		if (message.any)
			to << ": " << message;
	}
}

void assert(Bool condition) {
	if (!condition)
		throw AssertError();
}

void assert(Bool condition, Str message) {
	if (!condition)
		throw AssertError(message);
}

void assert(Bool condition, ConstPtr<Byte> message) {
	if (!condition)
		throw AssertError(toStorm(message));
}
