//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline sm2 64 '2^256 - 2^224 - 2^96 + 2^64 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: sm2
//! machine_wordsize = 64 (from "64")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xfffffffeffffffffffffffffffffffffffffffff00000000ffffffffffffffff (from "2^256 - 2^224 - 2^96 + 2^64 - 1")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//!                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/// Since `Index` and `IndexMut` aren't callable in `const` contexts yet, this helper type helps unify
/// arrays and user-defined array-wrapper types into a single type which can be indexed in `const`
/// contexts. Once `const trait`s are stabilized this type can go away
struct IndexConst<T: ?Sized>(T);

impl<'a, T, const N: usize> IndexConst<&'a [T; N]> {
    #[inline(always)]
    #[allow(unused)]
    const fn index(self, i: usize) -> &'a T {
        &self.0[i]
    }
}
impl<'a, 'b, T, const N: usize> IndexConst<&'a mut &'b mut [T; N]> {
    #[inline(always)]
    #[allow(unused)]
    const fn index_mut(self, i: usize) -> &'a mut T {
        &mut self.0[i]
    }
}

/** fiat_sm2_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_sm2_u1 = u8;
/** fiat_sm2_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_sm2_i1 = i8;
/** fiat_sm2_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_sm2_u2 = u8;
/** fiat_sm2_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_sm2_i2 = i8;

/** The type fiat_sm2_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_sm2_montgomery_domain_field_element(pub [u64; 4]);

impl core::ops::Index<usize> for fiat_sm2_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_sm2_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

impl<'a> IndexConst<&'a fiat_sm2_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index(self, i: usize) -> &'a u64 {
        &self.0.0[i]
    }
}

impl<'a, 'b> IndexConst<&'a mut &'b mut fiat_sm2_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index_mut(self, i: usize) -> &'a mut u64 {
        &mut self.0.0[i]
    }
}

/** The type fiat_sm2_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_sm2_non_montgomery_domain_field_element(pub [u64; 4]);

impl core::ops::Index<usize> for fiat_sm2_non_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_sm2_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

impl<'a> IndexConst<&'a fiat_sm2_non_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index(self, i: usize) -> &'a u64 {
        &self.0.0[i]
    }
}

impl<'a, 'b> IndexConst<&'a mut &'b mut fiat_sm2_non_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index_mut(self, i: usize) -> &'a mut u64 {
        &mut self.0.0[i]
    }
}


/// The function fiat_sm2_addcarryx_u64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub const fn fiat_sm2_addcarryx_u64(out1: &mut u64, out2: &mut fiat_sm2_u1, arg1: fiat_sm2_u1, arg2: u64, arg3: u64) {
  let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: fiat_sm2_u1 = ((x1 >> 64) as fiat_sm2_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_sm2_subborrowx_u64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub const fn fiat_sm2_subborrowx_u64(out1: &mut u64, out2: &mut fiat_sm2_u1, arg1: fiat_sm2_u1, arg2: u64, arg3: u64) {
  let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
  let x2: fiat_sm2_i1 = ((x1 >> 64) as fiat_sm2_i1);
  let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_sm2_i2) - (x2 as fiat_sm2_i2)) as fiat_sm2_u1);
}

/// The function fiat_sm2_mulx_u64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub const fn fiat_sm2_mulx_u64(out1: &mut u64, out2: &mut u64, arg1: u64, arg2: u64) {
  let x1: u128 = ((arg1 as u128) * (arg2 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: u64 = ((x1 >> 64) as u64);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_sm2_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub const fn fiat_sm2_cmovznz_u64(out1: &mut u64, arg1: fiat_sm2_u1, arg2: u64, arg3: u64) {
  let x1: fiat_sm2_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_sm2_i2) - (x1 as fiat_sm2_i2)) as fiat_sm2_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_sm2_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_mul(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element, arg2: &fiat_sm2_montgomery_domain_field_element) {
  let x1: u64 = (*IndexConst(arg1).index(1));
  let x2: u64 = (*IndexConst(arg1).index(2));
  let x3: u64 = (*IndexConst(arg1).index(3));
  let x4: u64 = (*IndexConst(arg1).index(0));
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_sm2_mulx_u64(&mut x5, &mut x6, x4, (*IndexConst(arg2).index(3)));
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_sm2_mulx_u64(&mut x7, &mut x8, x4, (*IndexConst(arg2).index(2)));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_sm2_mulx_u64(&mut x9, &mut x10, x4, (*IndexConst(arg2).index(1)));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_sm2_mulx_u64(&mut x11, &mut x12, x4, (*IndexConst(arg2).index(0)));
  let mut x13: u64 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let x19: u64 = ((x18 as u64) + x6);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_sm2_mulx_u64(&mut x20, &mut x21, x11, 0xfffffffeffffffff);
  let mut x22: u64 = 0;
  let mut x23: u64 = 0;
  fiat_sm2_mulx_u64(&mut x22, &mut x23, x11, 0xffffffffffffffff);
  let mut x24: u64 = 0;
  let mut x25: u64 = 0;
  fiat_sm2_mulx_u64(&mut x24, &mut x25, x11, 0xffffffff00000000);
  let mut x26: u64 = 0;
  let mut x27: u64 = 0;
  fiat_sm2_mulx_u64(&mut x26, &mut x27, x11, 0xffffffffffffffff);
  let mut x28: u64 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
  let mut x30: u64 = 0;
  let mut x31: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x30, &mut x31, x29, x25, x22);
  let mut x32: u64 = 0;
  let mut x33: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x32, &mut x33, x31, x23, x20);
  let x34: u64 = ((x33 as u64) + x21);
  let mut x35: u64 = 0;
  let mut x36: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x35, &mut x36, 0x0, x11, x26);
  let mut x37: u64 = 0;
  let mut x38: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x37, &mut x38, x36, x13, x28);
  let mut x39: u64 = 0;
  let mut x40: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x39, &mut x40, x38, x15, x30);
  let mut x41: u64 = 0;
  let mut x42: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x41, &mut x42, x40, x17, x32);
  let mut x43: u64 = 0;
  let mut x44: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x43, &mut x44, x42, x19, x34);
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_sm2_mulx_u64(&mut x45, &mut x46, x1, (*IndexConst(arg2).index(3)));
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_sm2_mulx_u64(&mut x47, &mut x48, x1, (*IndexConst(arg2).index(2)));
  let mut x49: u64 = 0;
  let mut x50: u64 = 0;
  fiat_sm2_mulx_u64(&mut x49, &mut x50, x1, (*IndexConst(arg2).index(1)));
  let mut x51: u64 = 0;
  let mut x52: u64 = 0;
  fiat_sm2_mulx_u64(&mut x51, &mut x52, x1, (*IndexConst(arg2).index(0)));
  let mut x53: u64 = 0;
  let mut x54: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x53, &mut x54, 0x0, x52, x49);
  let mut x55: u64 = 0;
  let mut x56: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x55, &mut x56, x54, x50, x47);
  let mut x57: u64 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x57, &mut x58, x56, x48, x45);
  let x59: u64 = ((x58 as u64) + x46);
  let mut x60: u64 = 0;
  let mut x61: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x60, &mut x61, 0x0, x37, x51);
  let mut x62: u64 = 0;
  let mut x63: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x62, &mut x63, x61, x39, x53);
  let mut x64: u64 = 0;
  let mut x65: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x64, &mut x65, x63, x41, x55);
  let mut x66: u64 = 0;
  let mut x67: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x66, &mut x67, x65, x43, x57);
  let mut x68: u64 = 0;
  let mut x69: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x68, &mut x69, x67, (x44 as u64), x59);
  let mut x70: u64 = 0;
  let mut x71: u64 = 0;
  fiat_sm2_mulx_u64(&mut x70, &mut x71, x60, 0xfffffffeffffffff);
  let mut x72: u64 = 0;
  let mut x73: u64 = 0;
  fiat_sm2_mulx_u64(&mut x72, &mut x73, x60, 0xffffffffffffffff);
  let mut x74: u64 = 0;
  let mut x75: u64 = 0;
  fiat_sm2_mulx_u64(&mut x74, &mut x75, x60, 0xffffffff00000000);
  let mut x76: u64 = 0;
  let mut x77: u64 = 0;
  fiat_sm2_mulx_u64(&mut x76, &mut x77, x60, 0xffffffffffffffff);
  let mut x78: u64 = 0;
  let mut x79: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x78, &mut x79, 0x0, x77, x74);
  let mut x80: u64 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x80, &mut x81, x79, x75, x72);
  let mut x82: u64 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x82, &mut x83, x81, x73, x70);
  let x84: u64 = ((x83 as u64) + x71);
  let mut x85: u64 = 0;
  let mut x86: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x85, &mut x86, 0x0, x60, x76);
  let mut x87: u64 = 0;
  let mut x88: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x87, &mut x88, x86, x62, x78);
  let mut x89: u64 = 0;
  let mut x90: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x89, &mut x90, x88, x64, x80);
  let mut x91: u64 = 0;
  let mut x92: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x91, &mut x92, x90, x66, x82);
  let mut x93: u64 = 0;
  let mut x94: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x93, &mut x94, x92, x68, x84);
  let x95: u64 = ((x94 as u64) + (x69 as u64));
  let mut x96: u64 = 0;
  let mut x97: u64 = 0;
  fiat_sm2_mulx_u64(&mut x96, &mut x97, x2, (*IndexConst(arg2).index(3)));
  let mut x98: u64 = 0;
  let mut x99: u64 = 0;
  fiat_sm2_mulx_u64(&mut x98, &mut x99, x2, (*IndexConst(arg2).index(2)));
  let mut x100: u64 = 0;
  let mut x101: u64 = 0;
  fiat_sm2_mulx_u64(&mut x100, &mut x101, x2, (*IndexConst(arg2).index(1)));
  let mut x102: u64 = 0;
  let mut x103: u64 = 0;
  fiat_sm2_mulx_u64(&mut x102, &mut x103, x2, (*IndexConst(arg2).index(0)));
  let mut x104: u64 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x104, &mut x105, 0x0, x103, x100);
  let mut x106: u64 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x106, &mut x107, x105, x101, x98);
  let mut x108: u64 = 0;
  let mut x109: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x108, &mut x109, x107, x99, x96);
  let x110: u64 = ((x109 as u64) + x97);
  let mut x111: u64 = 0;
  let mut x112: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x111, &mut x112, 0x0, x87, x102);
  let mut x113: u64 = 0;
  let mut x114: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x113, &mut x114, x112, x89, x104);
  let mut x115: u64 = 0;
  let mut x116: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x115, &mut x116, x114, x91, x106);
  let mut x117: u64 = 0;
  let mut x118: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x117, &mut x118, x116, x93, x108);
  let mut x119: u64 = 0;
  let mut x120: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x119, &mut x120, x118, x95, x110);
  let mut x121: u64 = 0;
  let mut x122: u64 = 0;
  fiat_sm2_mulx_u64(&mut x121, &mut x122, x111, 0xfffffffeffffffff);
  let mut x123: u64 = 0;
  let mut x124: u64 = 0;
  fiat_sm2_mulx_u64(&mut x123, &mut x124, x111, 0xffffffffffffffff);
  let mut x125: u64 = 0;
  let mut x126: u64 = 0;
  fiat_sm2_mulx_u64(&mut x125, &mut x126, x111, 0xffffffff00000000);
  let mut x127: u64 = 0;
  let mut x128: u64 = 0;
  fiat_sm2_mulx_u64(&mut x127, &mut x128, x111, 0xffffffffffffffff);
  let mut x129: u64 = 0;
  let mut x130: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x129, &mut x130, 0x0, x128, x125);
  let mut x131: u64 = 0;
  let mut x132: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x131, &mut x132, x130, x126, x123);
  let mut x133: u64 = 0;
  let mut x134: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x133, &mut x134, x132, x124, x121);
  let x135: u64 = ((x134 as u64) + x122);
  let mut x136: u64 = 0;
  let mut x137: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x136, &mut x137, 0x0, x111, x127);
  let mut x138: u64 = 0;
  let mut x139: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x138, &mut x139, x137, x113, x129);
  let mut x140: u64 = 0;
  let mut x141: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x140, &mut x141, x139, x115, x131);
  let mut x142: u64 = 0;
  let mut x143: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x142, &mut x143, x141, x117, x133);
  let mut x144: u64 = 0;
  let mut x145: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x144, &mut x145, x143, x119, x135);
  let x146: u64 = ((x145 as u64) + (x120 as u64));
  let mut x147: u64 = 0;
  let mut x148: u64 = 0;
  fiat_sm2_mulx_u64(&mut x147, &mut x148, x3, (*IndexConst(arg2).index(3)));
  let mut x149: u64 = 0;
  let mut x150: u64 = 0;
  fiat_sm2_mulx_u64(&mut x149, &mut x150, x3, (*IndexConst(arg2).index(2)));
  let mut x151: u64 = 0;
  let mut x152: u64 = 0;
  fiat_sm2_mulx_u64(&mut x151, &mut x152, x3, (*IndexConst(arg2).index(1)));
  let mut x153: u64 = 0;
  let mut x154: u64 = 0;
  fiat_sm2_mulx_u64(&mut x153, &mut x154, x3, (*IndexConst(arg2).index(0)));
  let mut x155: u64 = 0;
  let mut x156: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x155, &mut x156, 0x0, x154, x151);
  let mut x157: u64 = 0;
  let mut x158: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x157, &mut x158, x156, x152, x149);
  let mut x159: u64 = 0;
  let mut x160: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x159, &mut x160, x158, x150, x147);
  let x161: u64 = ((x160 as u64) + x148);
  let mut x162: u64 = 0;
  let mut x163: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x162, &mut x163, 0x0, x138, x153);
  let mut x164: u64 = 0;
  let mut x165: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x164, &mut x165, x163, x140, x155);
  let mut x166: u64 = 0;
  let mut x167: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x166, &mut x167, x165, x142, x157);
  let mut x168: u64 = 0;
  let mut x169: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x168, &mut x169, x167, x144, x159);
  let mut x170: u64 = 0;
  let mut x171: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x170, &mut x171, x169, x146, x161);
  let mut x172: u64 = 0;
  let mut x173: u64 = 0;
  fiat_sm2_mulx_u64(&mut x172, &mut x173, x162, 0xfffffffeffffffff);
  let mut x174: u64 = 0;
  let mut x175: u64 = 0;
  fiat_sm2_mulx_u64(&mut x174, &mut x175, x162, 0xffffffffffffffff);
  let mut x176: u64 = 0;
  let mut x177: u64 = 0;
  fiat_sm2_mulx_u64(&mut x176, &mut x177, x162, 0xffffffff00000000);
  let mut x178: u64 = 0;
  let mut x179: u64 = 0;
  fiat_sm2_mulx_u64(&mut x178, &mut x179, x162, 0xffffffffffffffff);
  let mut x180: u64 = 0;
  let mut x181: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x180, &mut x181, 0x0, x179, x176);
  let mut x182: u64 = 0;
  let mut x183: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x182, &mut x183, x181, x177, x174);
  let mut x184: u64 = 0;
  let mut x185: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x184, &mut x185, x183, x175, x172);
  let x186: u64 = ((x185 as u64) + x173);
  let mut x187: u64 = 0;
  let mut x188: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x187, &mut x188, 0x0, x162, x178);
  let mut x189: u64 = 0;
  let mut x190: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x189, &mut x190, x188, x164, x180);
  let mut x191: u64 = 0;
  let mut x192: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x191, &mut x192, x190, x166, x182);
  let mut x193: u64 = 0;
  let mut x194: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x193, &mut x194, x192, x168, x184);
  let mut x195: u64 = 0;
  let mut x196: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x195, &mut x196, x194, x170, x186);
  let x197: u64 = ((x196 as u64) + (x171 as u64));
  let mut x198: u64 = 0;
  let mut x199: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x198, &mut x199, 0x0, x189, 0xffffffffffffffff);
  let mut x200: u64 = 0;
  let mut x201: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x200, &mut x201, x199, x191, 0xffffffff00000000);
  let mut x202: u64 = 0;
  let mut x203: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x202, &mut x203, x201, x193, 0xffffffffffffffff);
  let mut x204: u64 = 0;
  let mut x205: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x204, &mut x205, x203, x195, 0xfffffffeffffffff);
  let mut x206: u64 = 0;
  let mut x207: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x206, &mut x207, x205, x197, (0x0 as u64));
  let mut x208: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x208, x207, x198, x189);
  let mut x209: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x209, x207, x200, x191);
  let mut x210: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x210, x207, x202, x193);
  let mut x211: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x211, x207, x204, x195);
  *IndexConst(&mut out1).index_mut(0) = x208;
  *IndexConst(&mut out1).index_mut(1) = x209;
  *IndexConst(&mut out1).index_mut(2) = x210;
  *IndexConst(&mut out1).index_mut(3) = x211;
}

/// The function fiat_sm2_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_square(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element) {
  let x1: u64 = (*IndexConst(arg1).index(1));
  let x2: u64 = (*IndexConst(arg1).index(2));
  let x3: u64 = (*IndexConst(arg1).index(3));
  let x4: u64 = (*IndexConst(arg1).index(0));
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_sm2_mulx_u64(&mut x5, &mut x6, x4, (*IndexConst(arg1).index(3)));
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_sm2_mulx_u64(&mut x7, &mut x8, x4, (*IndexConst(arg1).index(2)));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_sm2_mulx_u64(&mut x9, &mut x10, x4, (*IndexConst(arg1).index(1)));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_sm2_mulx_u64(&mut x11, &mut x12, x4, (*IndexConst(arg1).index(0)));
  let mut x13: u64 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let x19: u64 = ((x18 as u64) + x6);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_sm2_mulx_u64(&mut x20, &mut x21, x11, 0xfffffffeffffffff);
  let mut x22: u64 = 0;
  let mut x23: u64 = 0;
  fiat_sm2_mulx_u64(&mut x22, &mut x23, x11, 0xffffffffffffffff);
  let mut x24: u64 = 0;
  let mut x25: u64 = 0;
  fiat_sm2_mulx_u64(&mut x24, &mut x25, x11, 0xffffffff00000000);
  let mut x26: u64 = 0;
  let mut x27: u64 = 0;
  fiat_sm2_mulx_u64(&mut x26, &mut x27, x11, 0xffffffffffffffff);
  let mut x28: u64 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
  let mut x30: u64 = 0;
  let mut x31: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x30, &mut x31, x29, x25, x22);
  let mut x32: u64 = 0;
  let mut x33: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x32, &mut x33, x31, x23, x20);
  let x34: u64 = ((x33 as u64) + x21);
  let mut x35: u64 = 0;
  let mut x36: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x35, &mut x36, 0x0, x11, x26);
  let mut x37: u64 = 0;
  let mut x38: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x37, &mut x38, x36, x13, x28);
  let mut x39: u64 = 0;
  let mut x40: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x39, &mut x40, x38, x15, x30);
  let mut x41: u64 = 0;
  let mut x42: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x41, &mut x42, x40, x17, x32);
  let mut x43: u64 = 0;
  let mut x44: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x43, &mut x44, x42, x19, x34);
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_sm2_mulx_u64(&mut x45, &mut x46, x1, (*IndexConst(arg1).index(3)));
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_sm2_mulx_u64(&mut x47, &mut x48, x1, (*IndexConst(arg1).index(2)));
  let mut x49: u64 = 0;
  let mut x50: u64 = 0;
  fiat_sm2_mulx_u64(&mut x49, &mut x50, x1, (*IndexConst(arg1).index(1)));
  let mut x51: u64 = 0;
  let mut x52: u64 = 0;
  fiat_sm2_mulx_u64(&mut x51, &mut x52, x1, (*IndexConst(arg1).index(0)));
  let mut x53: u64 = 0;
  let mut x54: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x53, &mut x54, 0x0, x52, x49);
  let mut x55: u64 = 0;
  let mut x56: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x55, &mut x56, x54, x50, x47);
  let mut x57: u64 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x57, &mut x58, x56, x48, x45);
  let x59: u64 = ((x58 as u64) + x46);
  let mut x60: u64 = 0;
  let mut x61: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x60, &mut x61, 0x0, x37, x51);
  let mut x62: u64 = 0;
  let mut x63: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x62, &mut x63, x61, x39, x53);
  let mut x64: u64 = 0;
  let mut x65: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x64, &mut x65, x63, x41, x55);
  let mut x66: u64 = 0;
  let mut x67: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x66, &mut x67, x65, x43, x57);
  let mut x68: u64 = 0;
  let mut x69: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x68, &mut x69, x67, (x44 as u64), x59);
  let mut x70: u64 = 0;
  let mut x71: u64 = 0;
  fiat_sm2_mulx_u64(&mut x70, &mut x71, x60, 0xfffffffeffffffff);
  let mut x72: u64 = 0;
  let mut x73: u64 = 0;
  fiat_sm2_mulx_u64(&mut x72, &mut x73, x60, 0xffffffffffffffff);
  let mut x74: u64 = 0;
  let mut x75: u64 = 0;
  fiat_sm2_mulx_u64(&mut x74, &mut x75, x60, 0xffffffff00000000);
  let mut x76: u64 = 0;
  let mut x77: u64 = 0;
  fiat_sm2_mulx_u64(&mut x76, &mut x77, x60, 0xffffffffffffffff);
  let mut x78: u64 = 0;
  let mut x79: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x78, &mut x79, 0x0, x77, x74);
  let mut x80: u64 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x80, &mut x81, x79, x75, x72);
  let mut x82: u64 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x82, &mut x83, x81, x73, x70);
  let x84: u64 = ((x83 as u64) + x71);
  let mut x85: u64 = 0;
  let mut x86: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x85, &mut x86, 0x0, x60, x76);
  let mut x87: u64 = 0;
  let mut x88: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x87, &mut x88, x86, x62, x78);
  let mut x89: u64 = 0;
  let mut x90: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x89, &mut x90, x88, x64, x80);
  let mut x91: u64 = 0;
  let mut x92: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x91, &mut x92, x90, x66, x82);
  let mut x93: u64 = 0;
  let mut x94: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x93, &mut x94, x92, x68, x84);
  let x95: u64 = ((x94 as u64) + (x69 as u64));
  let mut x96: u64 = 0;
  let mut x97: u64 = 0;
  fiat_sm2_mulx_u64(&mut x96, &mut x97, x2, (*IndexConst(arg1).index(3)));
  let mut x98: u64 = 0;
  let mut x99: u64 = 0;
  fiat_sm2_mulx_u64(&mut x98, &mut x99, x2, (*IndexConst(arg1).index(2)));
  let mut x100: u64 = 0;
  let mut x101: u64 = 0;
  fiat_sm2_mulx_u64(&mut x100, &mut x101, x2, (*IndexConst(arg1).index(1)));
  let mut x102: u64 = 0;
  let mut x103: u64 = 0;
  fiat_sm2_mulx_u64(&mut x102, &mut x103, x2, (*IndexConst(arg1).index(0)));
  let mut x104: u64 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x104, &mut x105, 0x0, x103, x100);
  let mut x106: u64 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x106, &mut x107, x105, x101, x98);
  let mut x108: u64 = 0;
  let mut x109: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x108, &mut x109, x107, x99, x96);
  let x110: u64 = ((x109 as u64) + x97);
  let mut x111: u64 = 0;
  let mut x112: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x111, &mut x112, 0x0, x87, x102);
  let mut x113: u64 = 0;
  let mut x114: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x113, &mut x114, x112, x89, x104);
  let mut x115: u64 = 0;
  let mut x116: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x115, &mut x116, x114, x91, x106);
  let mut x117: u64 = 0;
  let mut x118: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x117, &mut x118, x116, x93, x108);
  let mut x119: u64 = 0;
  let mut x120: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x119, &mut x120, x118, x95, x110);
  let mut x121: u64 = 0;
  let mut x122: u64 = 0;
  fiat_sm2_mulx_u64(&mut x121, &mut x122, x111, 0xfffffffeffffffff);
  let mut x123: u64 = 0;
  let mut x124: u64 = 0;
  fiat_sm2_mulx_u64(&mut x123, &mut x124, x111, 0xffffffffffffffff);
  let mut x125: u64 = 0;
  let mut x126: u64 = 0;
  fiat_sm2_mulx_u64(&mut x125, &mut x126, x111, 0xffffffff00000000);
  let mut x127: u64 = 0;
  let mut x128: u64 = 0;
  fiat_sm2_mulx_u64(&mut x127, &mut x128, x111, 0xffffffffffffffff);
  let mut x129: u64 = 0;
  let mut x130: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x129, &mut x130, 0x0, x128, x125);
  let mut x131: u64 = 0;
  let mut x132: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x131, &mut x132, x130, x126, x123);
  let mut x133: u64 = 0;
  let mut x134: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x133, &mut x134, x132, x124, x121);
  let x135: u64 = ((x134 as u64) + x122);
  let mut x136: u64 = 0;
  let mut x137: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x136, &mut x137, 0x0, x111, x127);
  let mut x138: u64 = 0;
  let mut x139: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x138, &mut x139, x137, x113, x129);
  let mut x140: u64 = 0;
  let mut x141: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x140, &mut x141, x139, x115, x131);
  let mut x142: u64 = 0;
  let mut x143: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x142, &mut x143, x141, x117, x133);
  let mut x144: u64 = 0;
  let mut x145: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x144, &mut x145, x143, x119, x135);
  let x146: u64 = ((x145 as u64) + (x120 as u64));
  let mut x147: u64 = 0;
  let mut x148: u64 = 0;
  fiat_sm2_mulx_u64(&mut x147, &mut x148, x3, (*IndexConst(arg1).index(3)));
  let mut x149: u64 = 0;
  let mut x150: u64 = 0;
  fiat_sm2_mulx_u64(&mut x149, &mut x150, x3, (*IndexConst(arg1).index(2)));
  let mut x151: u64 = 0;
  let mut x152: u64 = 0;
  fiat_sm2_mulx_u64(&mut x151, &mut x152, x3, (*IndexConst(arg1).index(1)));
  let mut x153: u64 = 0;
  let mut x154: u64 = 0;
  fiat_sm2_mulx_u64(&mut x153, &mut x154, x3, (*IndexConst(arg1).index(0)));
  let mut x155: u64 = 0;
  let mut x156: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x155, &mut x156, 0x0, x154, x151);
  let mut x157: u64 = 0;
  let mut x158: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x157, &mut x158, x156, x152, x149);
  let mut x159: u64 = 0;
  let mut x160: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x159, &mut x160, x158, x150, x147);
  let x161: u64 = ((x160 as u64) + x148);
  let mut x162: u64 = 0;
  let mut x163: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x162, &mut x163, 0x0, x138, x153);
  let mut x164: u64 = 0;
  let mut x165: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x164, &mut x165, x163, x140, x155);
  let mut x166: u64 = 0;
  let mut x167: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x166, &mut x167, x165, x142, x157);
  let mut x168: u64 = 0;
  let mut x169: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x168, &mut x169, x167, x144, x159);
  let mut x170: u64 = 0;
  let mut x171: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x170, &mut x171, x169, x146, x161);
  let mut x172: u64 = 0;
  let mut x173: u64 = 0;
  fiat_sm2_mulx_u64(&mut x172, &mut x173, x162, 0xfffffffeffffffff);
  let mut x174: u64 = 0;
  let mut x175: u64 = 0;
  fiat_sm2_mulx_u64(&mut x174, &mut x175, x162, 0xffffffffffffffff);
  let mut x176: u64 = 0;
  let mut x177: u64 = 0;
  fiat_sm2_mulx_u64(&mut x176, &mut x177, x162, 0xffffffff00000000);
  let mut x178: u64 = 0;
  let mut x179: u64 = 0;
  fiat_sm2_mulx_u64(&mut x178, &mut x179, x162, 0xffffffffffffffff);
  let mut x180: u64 = 0;
  let mut x181: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x180, &mut x181, 0x0, x179, x176);
  let mut x182: u64 = 0;
  let mut x183: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x182, &mut x183, x181, x177, x174);
  let mut x184: u64 = 0;
  let mut x185: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x184, &mut x185, x183, x175, x172);
  let x186: u64 = ((x185 as u64) + x173);
  let mut x187: u64 = 0;
  let mut x188: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x187, &mut x188, 0x0, x162, x178);
  let mut x189: u64 = 0;
  let mut x190: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x189, &mut x190, x188, x164, x180);
  let mut x191: u64 = 0;
  let mut x192: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x191, &mut x192, x190, x166, x182);
  let mut x193: u64 = 0;
  let mut x194: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x193, &mut x194, x192, x168, x184);
  let mut x195: u64 = 0;
  let mut x196: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x195, &mut x196, x194, x170, x186);
  let x197: u64 = ((x196 as u64) + (x171 as u64));
  let mut x198: u64 = 0;
  let mut x199: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x198, &mut x199, 0x0, x189, 0xffffffffffffffff);
  let mut x200: u64 = 0;
  let mut x201: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x200, &mut x201, x199, x191, 0xffffffff00000000);
  let mut x202: u64 = 0;
  let mut x203: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x202, &mut x203, x201, x193, 0xffffffffffffffff);
  let mut x204: u64 = 0;
  let mut x205: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x204, &mut x205, x203, x195, 0xfffffffeffffffff);
  let mut x206: u64 = 0;
  let mut x207: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x206, &mut x207, x205, x197, (0x0 as u64));
  let mut x208: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x208, x207, x198, x189);
  let mut x209: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x209, x207, x200, x191);
  let mut x210: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x210, x207, x202, x193);
  let mut x211: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x211, x207, x204, x195);
  *IndexConst(&mut out1).index_mut(0) = x208;
  *IndexConst(&mut out1).index_mut(1) = x209;
  *IndexConst(&mut out1).index_mut(2) = x210;
  *IndexConst(&mut out1).index_mut(3) = x211;
}

/// The function fiat_sm2_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_add(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element, arg2: &fiat_sm2_montgomery_domain_field_element) {
  let mut x1: u64 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x1, &mut x2, 0x0, (*IndexConst(arg1).index(0)), (*IndexConst(arg2).index(0)));
  let mut x3: u64 = 0;
  let mut x4: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x3, &mut x4, x2, (*IndexConst(arg1).index(1)), (*IndexConst(arg2).index(1)));
  let mut x5: u64 = 0;
  let mut x6: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x5, &mut x6, x4, (*IndexConst(arg1).index(2)), (*IndexConst(arg2).index(2)));
  let mut x7: u64 = 0;
  let mut x8: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x7, &mut x8, x6, (*IndexConst(arg1).index(3)), (*IndexConst(arg2).index(3)));
  let mut x9: u64 = 0;
  let mut x10: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x9, &mut x10, 0x0, x1, 0xffffffffffffffff);
  let mut x11: u64 = 0;
  let mut x12: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x11, &mut x12, x10, x3, 0xffffffff00000000);
  let mut x13: u64 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x13, &mut x14, x12, x5, 0xffffffffffffffff);
  let mut x15: u64 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x15, &mut x16, x14, x7, 0xfffffffeffffffff);
  let mut x17: u64 = 0;
  let mut x18: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x17, &mut x18, x16, (x8 as u64), (0x0 as u64));
  let mut x19: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x19, x18, x9, x1);
  let mut x20: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x20, x18, x11, x3);
  let mut x21: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x21, x18, x13, x5);
  let mut x22: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x22, x18, x15, x7);
  *IndexConst(&mut out1).index_mut(0) = x19;
  *IndexConst(&mut out1).index_mut(1) = x20;
  *IndexConst(&mut out1).index_mut(2) = x21;
  *IndexConst(&mut out1).index_mut(3) = x22;
}

/// The function fiat_sm2_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_sub(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element, arg2: &fiat_sm2_montgomery_domain_field_element) {
  let mut x1: u64 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x1, &mut x2, 0x0, (*IndexConst(arg1).index(0)), (*IndexConst(arg2).index(0)));
  let mut x3: u64 = 0;
  let mut x4: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x3, &mut x4, x2, (*IndexConst(arg1).index(1)), (*IndexConst(arg2).index(1)));
  let mut x5: u64 = 0;
  let mut x6: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x5, &mut x6, x4, (*IndexConst(arg1).index(2)), (*IndexConst(arg2).index(2)));
  let mut x7: u64 = 0;
  let mut x8: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x7, &mut x8, x6, (*IndexConst(arg1).index(3)), (*IndexConst(arg2).index(3)));
  let mut x9: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x9, x8, (0x0 as u64), 0xffffffffffffffff);
  let mut x10: u64 = 0;
  let mut x11: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x10, &mut x11, 0x0, x1, x9);
  let mut x12: u64 = 0;
  let mut x13: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x12, &mut x13, x11, x3, (x9 & 0xffffffff00000000));
  let mut x14: u64 = 0;
  let mut x15: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x14, &mut x15, x13, x5, x9);
  let mut x16: u64 = 0;
  let mut x17: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x16, &mut x17, x15, x7, (x9 & 0xfffffffeffffffff));
  *IndexConst(&mut out1).index_mut(0) = x10;
  *IndexConst(&mut out1).index_mut(1) = x12;
  *IndexConst(&mut out1).index_mut(2) = x14;
  *IndexConst(&mut out1).index_mut(3) = x16;
}

/// The function fiat_sm2_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_opp(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element) {
  let mut x1: u64 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x1, &mut x2, 0x0, (0x0 as u64), (*IndexConst(arg1).index(0)));
  let mut x3: u64 = 0;
  let mut x4: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x3, &mut x4, x2, (0x0 as u64), (*IndexConst(arg1).index(1)));
  let mut x5: u64 = 0;
  let mut x6: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x5, &mut x6, x4, (0x0 as u64), (*IndexConst(arg1).index(2)));
  let mut x7: u64 = 0;
  let mut x8: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x7, &mut x8, x6, (0x0 as u64), (*IndexConst(arg1).index(3)));
  let mut x9: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x9, x8, (0x0 as u64), 0xffffffffffffffff);
  let mut x10: u64 = 0;
  let mut x11: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x10, &mut x11, 0x0, x1, x9);
  let mut x12: u64 = 0;
  let mut x13: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x12, &mut x13, x11, x3, (x9 & 0xffffffff00000000));
  let mut x14: u64 = 0;
  let mut x15: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x14, &mut x15, x13, x5, x9);
  let mut x16: u64 = 0;
  let mut x17: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x16, &mut x17, x15, x7, (x9 & 0xfffffffeffffffff));
  *IndexConst(&mut out1).index_mut(0) = x10;
  *IndexConst(&mut out1).index_mut(1) = x12;
  *IndexConst(&mut out1).index_mut(2) = x14;
  *IndexConst(&mut out1).index_mut(3) = x16;
}

/// The function fiat_sm2_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_from_montgomery(mut out1: &mut fiat_sm2_non_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element) {
  let x1: u64 = (*IndexConst(arg1).index(0));
  let mut x2: u64 = 0;
  let mut x3: u64 = 0;
  fiat_sm2_mulx_u64(&mut x2, &mut x3, x1, 0xfffffffeffffffff);
  let mut x4: u64 = 0;
  let mut x5: u64 = 0;
  fiat_sm2_mulx_u64(&mut x4, &mut x5, x1, 0xffffffffffffffff);
  let mut x6: u64 = 0;
  let mut x7: u64 = 0;
  fiat_sm2_mulx_u64(&mut x6, &mut x7, x1, 0xffffffff00000000);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_sm2_mulx_u64(&mut x8, &mut x9, x1, 0xffffffffffffffff);
  let mut x10: u64 = 0;
  let mut x11: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x10, &mut x11, 0x0, x9, x6);
  let mut x12: u64 = 0;
  let mut x13: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x12, &mut x13, x11, x7, x4);
  let mut x14: u64 = 0;
  let mut x15: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x14, &mut x15, x13, x5, x2);
  let mut x16: u64 = 0;
  let mut x17: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x16, &mut x17, 0x0, x1, x8);
  let mut x18: u64 = 0;
  let mut x19: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x18, &mut x19, x17, (0x0 as u64), x10);
  let mut x20: u64 = 0;
  let mut x21: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x20, &mut x21, x19, (0x0 as u64), x12);
  let mut x22: u64 = 0;
  let mut x23: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x22, &mut x23, x21, (0x0 as u64), x14);
  let mut x24: u64 = 0;
  let mut x25: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x24, &mut x25, 0x0, x18, (*IndexConst(arg1).index(1)));
  let mut x26: u64 = 0;
  let mut x27: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x26, &mut x27, x25, x20, (0x0 as u64));
  let mut x28: u64 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x28, &mut x29, x27, x22, (0x0 as u64));
  let mut x30: u64 = 0;
  let mut x31: u64 = 0;
  fiat_sm2_mulx_u64(&mut x30, &mut x31, x24, 0xfffffffeffffffff);
  let mut x32: u64 = 0;
  let mut x33: u64 = 0;
  fiat_sm2_mulx_u64(&mut x32, &mut x33, x24, 0xffffffffffffffff);
  let mut x34: u64 = 0;
  let mut x35: u64 = 0;
  fiat_sm2_mulx_u64(&mut x34, &mut x35, x24, 0xffffffff00000000);
  let mut x36: u64 = 0;
  let mut x37: u64 = 0;
  fiat_sm2_mulx_u64(&mut x36, &mut x37, x24, 0xffffffffffffffff);
  let mut x38: u64 = 0;
  let mut x39: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x38, &mut x39, 0x0, x37, x34);
  let mut x40: u64 = 0;
  let mut x41: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x40, &mut x41, x39, x35, x32);
  let mut x42: u64 = 0;
  let mut x43: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x42, &mut x43, x41, x33, x30);
  let mut x44: u64 = 0;
  let mut x45: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x44, &mut x45, 0x0, x24, x36);
  let mut x46: u64 = 0;
  let mut x47: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x46, &mut x47, x45, x26, x38);
  let mut x48: u64 = 0;
  let mut x49: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x48, &mut x49, x47, x28, x40);
  let mut x50: u64 = 0;
  let mut x51: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x50, &mut x51, x49, ((x29 as u64) + ((x23 as u64) + ((x15 as u64) + x3))), x42);
  let mut x52: u64 = 0;
  let mut x53: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x52, &mut x53, 0x0, x46, (*IndexConst(arg1).index(2)));
  let mut x54: u64 = 0;
  let mut x55: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x54, &mut x55, x53, x48, (0x0 as u64));
  let mut x56: u64 = 0;
  let mut x57: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x56, &mut x57, x55, x50, (0x0 as u64));
  let mut x58: u64 = 0;
  let mut x59: u64 = 0;
  fiat_sm2_mulx_u64(&mut x58, &mut x59, x52, 0xfffffffeffffffff);
  let mut x60: u64 = 0;
  let mut x61: u64 = 0;
  fiat_sm2_mulx_u64(&mut x60, &mut x61, x52, 0xffffffffffffffff);
  let mut x62: u64 = 0;
  let mut x63: u64 = 0;
  fiat_sm2_mulx_u64(&mut x62, &mut x63, x52, 0xffffffff00000000);
  let mut x64: u64 = 0;
  let mut x65: u64 = 0;
  fiat_sm2_mulx_u64(&mut x64, &mut x65, x52, 0xffffffffffffffff);
  let mut x66: u64 = 0;
  let mut x67: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x66, &mut x67, 0x0, x65, x62);
  let mut x68: u64 = 0;
  let mut x69: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x68, &mut x69, x67, x63, x60);
  let mut x70: u64 = 0;
  let mut x71: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x70, &mut x71, x69, x61, x58);
  let mut x72: u64 = 0;
  let mut x73: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x72, &mut x73, 0x0, x52, x64);
  let mut x74: u64 = 0;
  let mut x75: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x74, &mut x75, x73, x54, x66);
  let mut x76: u64 = 0;
  let mut x77: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x76, &mut x77, x75, x56, x68);
  let mut x78: u64 = 0;
  let mut x79: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x78, &mut x79, x77, ((x57 as u64) + ((x51 as u64) + ((x43 as u64) + x31))), x70);
  let mut x80: u64 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x80, &mut x81, 0x0, x74, (*IndexConst(arg1).index(3)));
  let mut x82: u64 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x82, &mut x83, x81, x76, (0x0 as u64));
  let mut x84: u64 = 0;
  let mut x85: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x84, &mut x85, x83, x78, (0x0 as u64));
  let mut x86: u64 = 0;
  let mut x87: u64 = 0;
  fiat_sm2_mulx_u64(&mut x86, &mut x87, x80, 0xfffffffeffffffff);
  let mut x88: u64 = 0;
  let mut x89: u64 = 0;
  fiat_sm2_mulx_u64(&mut x88, &mut x89, x80, 0xffffffffffffffff);
  let mut x90: u64 = 0;
  let mut x91: u64 = 0;
  fiat_sm2_mulx_u64(&mut x90, &mut x91, x80, 0xffffffff00000000);
  let mut x92: u64 = 0;
  let mut x93: u64 = 0;
  fiat_sm2_mulx_u64(&mut x92, &mut x93, x80, 0xffffffffffffffff);
  let mut x94: u64 = 0;
  let mut x95: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x94, &mut x95, 0x0, x93, x90);
  let mut x96: u64 = 0;
  let mut x97: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x96, &mut x97, x95, x91, x88);
  let mut x98: u64 = 0;
  let mut x99: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x98, &mut x99, x97, x89, x86);
  let mut x100: u64 = 0;
  let mut x101: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x100, &mut x101, 0x0, x80, x92);
  let mut x102: u64 = 0;
  let mut x103: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x102, &mut x103, x101, x82, x94);
  let mut x104: u64 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x104, &mut x105, x103, x84, x96);
  let mut x106: u64 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x106, &mut x107, x105, ((x85 as u64) + ((x79 as u64) + ((x71 as u64) + x59))), x98);
  let x108: u64 = ((x107 as u64) + ((x99 as u64) + x87));
  let mut x109: u64 = 0;
  let mut x110: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x109, &mut x110, 0x0, x102, 0xffffffffffffffff);
  let mut x111: u64 = 0;
  let mut x112: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x111, &mut x112, x110, x104, 0xffffffff00000000);
  let mut x113: u64 = 0;
  let mut x114: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x113, &mut x114, x112, x106, 0xffffffffffffffff);
  let mut x115: u64 = 0;
  let mut x116: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x115, &mut x116, x114, x108, 0xfffffffeffffffff);
  let mut x117: u64 = 0;
  let mut x118: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x117, &mut x118, x116, (0x0 as u64), (0x0 as u64));
  let mut x119: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x119, x118, x109, x102);
  let mut x120: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x120, x118, x111, x104);
  let mut x121: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x121, x118, x113, x106);
  let mut x122: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x122, x118, x115, x108);
  *IndexConst(&mut out1).index_mut(0) = x119;
  *IndexConst(&mut out1).index_mut(1) = x120;
  *IndexConst(&mut out1).index_mut(2) = x121;
  *IndexConst(&mut out1).index_mut(3) = x122;
}

/// The function fiat_sm2_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_to_montgomery(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_non_montgomery_domain_field_element) {
  let x1: u64 = (*IndexConst(arg1).index(1));
  let x2: u64 = (*IndexConst(arg1).index(2));
  let x3: u64 = (*IndexConst(arg1).index(3));
  let x4: u64 = (*IndexConst(arg1).index(0));
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_sm2_mulx_u64(&mut x5, &mut x6, x4, 0x400000002);
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_sm2_mulx_u64(&mut x7, &mut x8, x4, 0x100000001);
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_sm2_mulx_u64(&mut x9, &mut x10, x4, 0x2ffffffff);
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_sm2_mulx_u64(&mut x11, &mut x12, x4, 0x200000003);
  let mut x13: u64 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let mut x19: u64 = 0;
  let mut x20: u64 = 0;
  fiat_sm2_mulx_u64(&mut x19, &mut x20, x11, 0xfffffffeffffffff);
  let mut x21: u64 = 0;
  let mut x22: u64 = 0;
  fiat_sm2_mulx_u64(&mut x21, &mut x22, x11, 0xffffffffffffffff);
  let mut x23: u64 = 0;
  let mut x24: u64 = 0;
  fiat_sm2_mulx_u64(&mut x23, &mut x24, x11, 0xffffffff00000000);
  let mut x25: u64 = 0;
  let mut x26: u64 = 0;
  fiat_sm2_mulx_u64(&mut x25, &mut x26, x11, 0xffffffffffffffff);
  let mut x27: u64 = 0;
  let mut x28: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x27, &mut x28, 0x0, x26, x23);
  let mut x29: u64 = 0;
  let mut x30: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x29, &mut x30, x28, x24, x21);
  let mut x31: u64 = 0;
  let mut x32: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x31, &mut x32, x30, x22, x19);
  let mut x33: u64 = 0;
  let mut x34: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x33, &mut x34, 0x0, x11, x25);
  let mut x35: u64 = 0;
  let mut x36: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x35, &mut x36, x34, x13, x27);
  let mut x37: u64 = 0;
  let mut x38: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x37, &mut x38, x36, x15, x29);
  let mut x39: u64 = 0;
  let mut x40: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x39, &mut x40, x38, x17, x31);
  let mut x41: u64 = 0;
  let mut x42: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x41, &mut x42, x40, ((x18 as u64) + x6), ((x32 as u64) + x20));
  let mut x43: u64 = 0;
  let mut x44: u64 = 0;
  fiat_sm2_mulx_u64(&mut x43, &mut x44, x1, 0x400000002);
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_sm2_mulx_u64(&mut x45, &mut x46, x1, 0x100000001);
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_sm2_mulx_u64(&mut x47, &mut x48, x1, 0x2ffffffff);
  let mut x49: u64 = 0;
  let mut x50: u64 = 0;
  fiat_sm2_mulx_u64(&mut x49, &mut x50, x1, 0x200000003);
  let mut x51: u64 = 0;
  let mut x52: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x51, &mut x52, 0x0, x50, x47);
  let mut x53: u64 = 0;
  let mut x54: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x53, &mut x54, x52, x48, x45);
  let mut x55: u64 = 0;
  let mut x56: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x55, &mut x56, x54, x46, x43);
  let mut x57: u64 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x57, &mut x58, 0x0, x35, x49);
  let mut x59: u64 = 0;
  let mut x60: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x59, &mut x60, x58, x37, x51);
  let mut x61: u64 = 0;
  let mut x62: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x61, &mut x62, x60, x39, x53);
  let mut x63: u64 = 0;
  let mut x64: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x63, &mut x64, x62, x41, x55);
  let mut x65: u64 = 0;
  let mut x66: u64 = 0;
  fiat_sm2_mulx_u64(&mut x65, &mut x66, x57, 0xfffffffeffffffff);
  let mut x67: u64 = 0;
  let mut x68: u64 = 0;
  fiat_sm2_mulx_u64(&mut x67, &mut x68, x57, 0xffffffffffffffff);
  let mut x69: u64 = 0;
  let mut x70: u64 = 0;
  fiat_sm2_mulx_u64(&mut x69, &mut x70, x57, 0xffffffff00000000);
  let mut x71: u64 = 0;
  let mut x72: u64 = 0;
  fiat_sm2_mulx_u64(&mut x71, &mut x72, x57, 0xffffffffffffffff);
  let mut x73: u64 = 0;
  let mut x74: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x73, &mut x74, 0x0, x72, x69);
  let mut x75: u64 = 0;
  let mut x76: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x75, &mut x76, x74, x70, x67);
  let mut x77: u64 = 0;
  let mut x78: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x77, &mut x78, x76, x68, x65);
  let mut x79: u64 = 0;
  let mut x80: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x79, &mut x80, 0x0, x57, x71);
  let mut x81: u64 = 0;
  let mut x82: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x81, &mut x82, x80, x59, x73);
  let mut x83: u64 = 0;
  let mut x84: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x83, &mut x84, x82, x61, x75);
  let mut x85: u64 = 0;
  let mut x86: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x85, &mut x86, x84, x63, x77);
  let mut x87: u64 = 0;
  let mut x88: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x87, &mut x88, x86, (((x64 as u64) + (x42 as u64)) + ((x56 as u64) + x44)), ((x78 as u64) + x66));
  let mut x89: u64 = 0;
  let mut x90: u64 = 0;
  fiat_sm2_mulx_u64(&mut x89, &mut x90, x2, 0x400000002);
  let mut x91: u64 = 0;
  let mut x92: u64 = 0;
  fiat_sm2_mulx_u64(&mut x91, &mut x92, x2, 0x100000001);
  let mut x93: u64 = 0;
  let mut x94: u64 = 0;
  fiat_sm2_mulx_u64(&mut x93, &mut x94, x2, 0x2ffffffff);
  let mut x95: u64 = 0;
  let mut x96: u64 = 0;
  fiat_sm2_mulx_u64(&mut x95, &mut x96, x2, 0x200000003);
  let mut x97: u64 = 0;
  let mut x98: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x97, &mut x98, 0x0, x96, x93);
  let mut x99: u64 = 0;
  let mut x100: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x99, &mut x100, x98, x94, x91);
  let mut x101: u64 = 0;
  let mut x102: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x101, &mut x102, x100, x92, x89);
  let mut x103: u64 = 0;
  let mut x104: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x103, &mut x104, 0x0, x81, x95);
  let mut x105: u64 = 0;
  let mut x106: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x105, &mut x106, x104, x83, x97);
  let mut x107: u64 = 0;
  let mut x108: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x107, &mut x108, x106, x85, x99);
  let mut x109: u64 = 0;
  let mut x110: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x109, &mut x110, x108, x87, x101);
  let mut x111: u64 = 0;
  let mut x112: u64 = 0;
  fiat_sm2_mulx_u64(&mut x111, &mut x112, x103, 0xfffffffeffffffff);
  let mut x113: u64 = 0;
  let mut x114: u64 = 0;
  fiat_sm2_mulx_u64(&mut x113, &mut x114, x103, 0xffffffffffffffff);
  let mut x115: u64 = 0;
  let mut x116: u64 = 0;
  fiat_sm2_mulx_u64(&mut x115, &mut x116, x103, 0xffffffff00000000);
  let mut x117: u64 = 0;
  let mut x118: u64 = 0;
  fiat_sm2_mulx_u64(&mut x117, &mut x118, x103, 0xffffffffffffffff);
  let mut x119: u64 = 0;
  let mut x120: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x119, &mut x120, 0x0, x118, x115);
  let mut x121: u64 = 0;
  let mut x122: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x121, &mut x122, x120, x116, x113);
  let mut x123: u64 = 0;
  let mut x124: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x123, &mut x124, x122, x114, x111);
  let mut x125: u64 = 0;
  let mut x126: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x125, &mut x126, 0x0, x103, x117);
  let mut x127: u64 = 0;
  let mut x128: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x127, &mut x128, x126, x105, x119);
  let mut x129: u64 = 0;
  let mut x130: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x129, &mut x130, x128, x107, x121);
  let mut x131: u64 = 0;
  let mut x132: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x131, &mut x132, x130, x109, x123);
  let mut x133: u64 = 0;
  let mut x134: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x133, &mut x134, x132, (((x110 as u64) + (x88 as u64)) + ((x102 as u64) + x90)), ((x124 as u64) + x112));
  let mut x135: u64 = 0;
  let mut x136: u64 = 0;
  fiat_sm2_mulx_u64(&mut x135, &mut x136, x3, 0x400000002);
  let mut x137: u64 = 0;
  let mut x138: u64 = 0;
  fiat_sm2_mulx_u64(&mut x137, &mut x138, x3, 0x100000001);
  let mut x139: u64 = 0;
  let mut x140: u64 = 0;
  fiat_sm2_mulx_u64(&mut x139, &mut x140, x3, 0x2ffffffff);
  let mut x141: u64 = 0;
  let mut x142: u64 = 0;
  fiat_sm2_mulx_u64(&mut x141, &mut x142, x3, 0x200000003);
  let mut x143: u64 = 0;
  let mut x144: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x143, &mut x144, 0x0, x142, x139);
  let mut x145: u64 = 0;
  let mut x146: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x145, &mut x146, x144, x140, x137);
  let mut x147: u64 = 0;
  let mut x148: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x147, &mut x148, x146, x138, x135);
  let mut x149: u64 = 0;
  let mut x150: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x149, &mut x150, 0x0, x127, x141);
  let mut x151: u64 = 0;
  let mut x152: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x151, &mut x152, x150, x129, x143);
  let mut x153: u64 = 0;
  let mut x154: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x153, &mut x154, x152, x131, x145);
  let mut x155: u64 = 0;
  let mut x156: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x155, &mut x156, x154, x133, x147);
  let mut x157: u64 = 0;
  let mut x158: u64 = 0;
  fiat_sm2_mulx_u64(&mut x157, &mut x158, x149, 0xfffffffeffffffff);
  let mut x159: u64 = 0;
  let mut x160: u64 = 0;
  fiat_sm2_mulx_u64(&mut x159, &mut x160, x149, 0xffffffffffffffff);
  let mut x161: u64 = 0;
  let mut x162: u64 = 0;
  fiat_sm2_mulx_u64(&mut x161, &mut x162, x149, 0xffffffff00000000);
  let mut x163: u64 = 0;
  let mut x164: u64 = 0;
  fiat_sm2_mulx_u64(&mut x163, &mut x164, x149, 0xffffffffffffffff);
  let mut x165: u64 = 0;
  let mut x166: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x165, &mut x166, 0x0, x164, x161);
  let mut x167: u64 = 0;
  let mut x168: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x167, &mut x168, x166, x162, x159);
  let mut x169: u64 = 0;
  let mut x170: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x169, &mut x170, x168, x160, x157);
  let mut x171: u64 = 0;
  let mut x172: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x171, &mut x172, 0x0, x149, x163);
  let mut x173: u64 = 0;
  let mut x174: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x173, &mut x174, x172, x151, x165);
  let mut x175: u64 = 0;
  let mut x176: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x175, &mut x176, x174, x153, x167);
  let mut x177: u64 = 0;
  let mut x178: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x177, &mut x178, x176, x155, x169);
  let mut x179: u64 = 0;
  let mut x180: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x179, &mut x180, x178, (((x156 as u64) + (x134 as u64)) + ((x148 as u64) + x136)), ((x170 as u64) + x158));
  let mut x181: u64 = 0;
  let mut x182: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x181, &mut x182, 0x0, x173, 0xffffffffffffffff);
  let mut x183: u64 = 0;
  let mut x184: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x183, &mut x184, x182, x175, 0xffffffff00000000);
  let mut x185: u64 = 0;
  let mut x186: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x185, &mut x186, x184, x177, 0xffffffffffffffff);
  let mut x187: u64 = 0;
  let mut x188: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x187, &mut x188, x186, x179, 0xfffffffeffffffff);
  let mut x189: u64 = 0;
  let mut x190: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x189, &mut x190, x188, (x180 as u64), (0x0 as u64));
  let mut x191: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x191, x190, x181, x173);
  let mut x192: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x192, x190, x183, x175);
  let mut x193: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x193, x190, x185, x177);
  let mut x194: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x194, x190, x187, x179);
  *IndexConst(&mut out1).index_mut(0) = x191;
  *IndexConst(&mut out1).index_mut(1) = x192;
  *IndexConst(&mut out1).index_mut(2) = x193;
  *IndexConst(&mut out1).index_mut(3) = x194;
}

/// The function fiat_sm2_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub const fn fiat_sm2_nonzero(out1: &mut u64, arg1: &[u64; 4]) {
  let x1: u64 = ((*IndexConst(arg1).index(0)) | ((*IndexConst(arg1).index(1)) | ((*IndexConst(arg1).index(2)) | (*IndexConst(arg1).index(3)))));
  *out1 = x1;
}

/// The function fiat_sm2_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_sm2_selectznz(mut out1: &mut [u64; 4], arg1: fiat_sm2_u1, arg2: &[u64; 4], arg3: &[u64; 4]) {
  let mut x1: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x1, arg1, (*IndexConst(arg2).index(0)), (*IndexConst(arg3).index(0)));
  let mut x2: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x2, arg1, (*IndexConst(arg2).index(1)), (*IndexConst(arg3).index(1)));
  let mut x3: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x3, arg1, (*IndexConst(arg2).index(2)), (*IndexConst(arg3).index(2)));
  let mut x4: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x4, arg1, (*IndexConst(arg2).index(3)), (*IndexConst(arg3).index(3)));
  *IndexConst(&mut out1).index_mut(0) = x1;
  *IndexConst(&mut out1).index_mut(1) = x2;
  *IndexConst(&mut out1).index_mut(2) = x3;
  *IndexConst(&mut out1).index_mut(3) = x4;
}

/// The function fiat_sm2_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub const fn fiat_sm2_to_bytes(mut out1: &mut [u8; 32], arg1: &[u64; 4]) {
  let x1: u64 = (*IndexConst(arg1).index(3));
  let x2: u64 = (*IndexConst(arg1).index(2));
  let x3: u64 = (*IndexConst(arg1).index(1));
  let x4: u64 = (*IndexConst(arg1).index(0));
  let x5: u8 = ((x4 & (0xff as u64)) as u8);
  let x6: u64 = (x4 >> 8);
  let x7: u8 = ((x6 & (0xff as u64)) as u8);
  let x8: u64 = (x6 >> 8);
  let x9: u8 = ((x8 & (0xff as u64)) as u8);
  let x10: u64 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u64)) as u8);
  let x12: u64 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u64)) as u8);
  let x14: u64 = (x12 >> 8);
  let x15: u8 = ((x14 & (0xff as u64)) as u8);
  let x16: u64 = (x14 >> 8);
  let x17: u8 = ((x16 & (0xff as u64)) as u8);
  let x18: u8 = ((x16 >> 8) as u8);
  let x19: u8 = ((x3 & (0xff as u64)) as u8);
  let x20: u64 = (x3 >> 8);
  let x21: u8 = ((x20 & (0xff as u64)) as u8);
  let x22: u64 = (x20 >> 8);
  let x23: u8 = ((x22 & (0xff as u64)) as u8);
  let x24: u64 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u64)) as u8);
  let x26: u64 = (x24 >> 8);
  let x27: u8 = ((x26 & (0xff as u64)) as u8);
  let x28: u64 = (x26 >> 8);
  let x29: u8 = ((x28 & (0xff as u64)) as u8);
  let x30: u64 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u64)) as u8);
  let x32: u8 = ((x30 >> 8) as u8);
  let x33: u8 = ((x2 & (0xff as u64)) as u8);
  let x34: u64 = (x2 >> 8);
  let x35: u8 = ((x34 & (0xff as u64)) as u8);
  let x36: u64 = (x34 >> 8);
  let x37: u8 = ((x36 & (0xff as u64)) as u8);
  let x38: u64 = (x36 >> 8);
  let x39: u8 = ((x38 & (0xff as u64)) as u8);
  let x40: u64 = (x38 >> 8);
  let x41: u8 = ((x40 & (0xff as u64)) as u8);
  let x42: u64 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u64)) as u8);
  let x44: u64 = (x42 >> 8);
  let x45: u8 = ((x44 & (0xff as u64)) as u8);
  let x46: u8 = ((x44 >> 8) as u8);
  let x47: u8 = ((x1 & (0xff as u64)) as u8);
  let x48: u64 = (x1 >> 8);
  let x49: u8 = ((x48 & (0xff as u64)) as u8);
  let x50: u64 = (x48 >> 8);
  let x51: u8 = ((x50 & (0xff as u64)) as u8);
  let x52: u64 = (x50 >> 8);
  let x53: u8 = ((x52 & (0xff as u64)) as u8);
  let x54: u64 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u64)) as u8);
  let x56: u64 = (x54 >> 8);
  let x57: u8 = ((x56 & (0xff as u64)) as u8);
  let x58: u64 = (x56 >> 8);
  let x59: u8 = ((x58 & (0xff as u64)) as u8);
  let x60: u8 = ((x58 >> 8) as u8);
  *IndexConst(&mut out1).index_mut(0) = x5;
  *IndexConst(&mut out1).index_mut(1) = x7;
  *IndexConst(&mut out1).index_mut(2) = x9;
  *IndexConst(&mut out1).index_mut(3) = x11;
  *IndexConst(&mut out1).index_mut(4) = x13;
  *IndexConst(&mut out1).index_mut(5) = x15;
  *IndexConst(&mut out1).index_mut(6) = x17;
  *IndexConst(&mut out1).index_mut(7) = x18;
  *IndexConst(&mut out1).index_mut(8) = x19;
  *IndexConst(&mut out1).index_mut(9) = x21;
  *IndexConst(&mut out1).index_mut(10) = x23;
  *IndexConst(&mut out1).index_mut(11) = x25;
  *IndexConst(&mut out1).index_mut(12) = x27;
  *IndexConst(&mut out1).index_mut(13) = x29;
  *IndexConst(&mut out1).index_mut(14) = x31;
  *IndexConst(&mut out1).index_mut(15) = x32;
  *IndexConst(&mut out1).index_mut(16) = x33;
  *IndexConst(&mut out1).index_mut(17) = x35;
  *IndexConst(&mut out1).index_mut(18) = x37;
  *IndexConst(&mut out1).index_mut(19) = x39;
  *IndexConst(&mut out1).index_mut(20) = x41;
  *IndexConst(&mut out1).index_mut(21) = x43;
  *IndexConst(&mut out1).index_mut(22) = x45;
  *IndexConst(&mut out1).index_mut(23) = x46;
  *IndexConst(&mut out1).index_mut(24) = x47;
  *IndexConst(&mut out1).index_mut(25) = x49;
  *IndexConst(&mut out1).index_mut(26) = x51;
  *IndexConst(&mut out1).index_mut(27) = x53;
  *IndexConst(&mut out1).index_mut(28) = x55;
  *IndexConst(&mut out1).index_mut(29) = x57;
  *IndexConst(&mut out1).index_mut(30) = x59;
  *IndexConst(&mut out1).index_mut(31) = x60;
}

/// The function fiat_sm2_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_sm2_from_bytes(mut out1: &mut [u64; 4], arg1: &[u8; 32]) {
  let x1: u64 = (((*IndexConst(arg1).index(31)) as u64) << 56);
  let x2: u64 = (((*IndexConst(arg1).index(30)) as u64) << 48);
  let x3: u64 = (((*IndexConst(arg1).index(29)) as u64) << 40);
  let x4: u64 = (((*IndexConst(arg1).index(28)) as u64) << 32);
  let x5: u64 = (((*IndexConst(arg1).index(27)) as u64) << 24);
  let x6: u64 = (((*IndexConst(arg1).index(26)) as u64) << 16);
  let x7: u64 = (((*IndexConst(arg1).index(25)) as u64) << 8);
  let x8: u8 = (*IndexConst(arg1).index(24));
  let x9: u64 = (((*IndexConst(arg1).index(23)) as u64) << 56);
  let x10: u64 = (((*IndexConst(arg1).index(22)) as u64) << 48);
  let x11: u64 = (((*IndexConst(arg1).index(21)) as u64) << 40);
  let x12: u64 = (((*IndexConst(arg1).index(20)) as u64) << 32);
  let x13: u64 = (((*IndexConst(arg1).index(19)) as u64) << 24);
  let x14: u64 = (((*IndexConst(arg1).index(18)) as u64) << 16);
  let x15: u64 = (((*IndexConst(arg1).index(17)) as u64) << 8);
  let x16: u8 = (*IndexConst(arg1).index(16));
  let x17: u64 = (((*IndexConst(arg1).index(15)) as u64) << 56);
  let x18: u64 = (((*IndexConst(arg1).index(14)) as u64) << 48);
  let x19: u64 = (((*IndexConst(arg1).index(13)) as u64) << 40);
  let x20: u64 = (((*IndexConst(arg1).index(12)) as u64) << 32);
  let x21: u64 = (((*IndexConst(arg1).index(11)) as u64) << 24);
  let x22: u64 = (((*IndexConst(arg1).index(10)) as u64) << 16);
  let x23: u64 = (((*IndexConst(arg1).index(9)) as u64) << 8);
  let x24: u8 = (*IndexConst(arg1).index(8));
  let x25: u64 = (((*IndexConst(arg1).index(7)) as u64) << 56);
  let x26: u64 = (((*IndexConst(arg1).index(6)) as u64) << 48);
  let x27: u64 = (((*IndexConst(arg1).index(5)) as u64) << 40);
  let x28: u64 = (((*IndexConst(arg1).index(4)) as u64) << 32);
  let x29: u64 = (((*IndexConst(arg1).index(3)) as u64) << 24);
  let x30: u64 = (((*IndexConst(arg1).index(2)) as u64) << 16);
  let x31: u64 = (((*IndexConst(arg1).index(1)) as u64) << 8);
  let x32: u8 = (*IndexConst(arg1).index(0));
  let x33: u64 = (x31 + (x32 as u64));
  let x34: u64 = (x30 + x33);
  let x35: u64 = (x29 + x34);
  let x36: u64 = (x28 + x35);
  let x37: u64 = (x27 + x36);
  let x38: u64 = (x26 + x37);
  let x39: u64 = (x25 + x38);
  let x40: u64 = (x23 + (x24 as u64));
  let x41: u64 = (x22 + x40);
  let x42: u64 = (x21 + x41);
  let x43: u64 = (x20 + x42);
  let x44: u64 = (x19 + x43);
  let x45: u64 = (x18 + x44);
  let x46: u64 = (x17 + x45);
  let x47: u64 = (x15 + (x16 as u64));
  let x48: u64 = (x14 + x47);
  let x49: u64 = (x13 + x48);
  let x50: u64 = (x12 + x49);
  let x51: u64 = (x11 + x50);
  let x52: u64 = (x10 + x51);
  let x53: u64 = (x9 + x52);
  let x54: u64 = (x7 + (x8 as u64));
  let x55: u64 = (x6 + x54);
  let x56: u64 = (x5 + x55);
  let x57: u64 = (x4 + x56);
  let x58: u64 = (x3 + x57);
  let x59: u64 = (x2 + x58);
  let x60: u64 = (x1 + x59);
  *IndexConst(&mut out1).index_mut(0) = x39;
  *IndexConst(&mut out1).index_mut(1) = x46;
  *IndexConst(&mut out1).index_mut(2) = x53;
  *IndexConst(&mut out1).index_mut(3) = x60;
}

/// The function fiat_sm2_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_set_one(mut out1: &mut fiat_sm2_montgomery_domain_field_element) {
  *IndexConst(&mut out1).index_mut(0) = (0x1 as u64);
  *IndexConst(&mut out1).index_mut(1) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(2) = (0x0 as u64);
  *IndexConst(&mut out1).index_mut(3) = 0x100000000;
}

/// The function fiat_sm2_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_sm2_msat(mut out1: &mut [u64; 5]) {
  *IndexConst(&mut out1).index_mut(0) = 0xffffffffffffffff;
  *IndexConst(&mut out1).index_mut(1) = 0xffffffff00000000;
  *IndexConst(&mut out1).index_mut(2) = 0xffffffffffffffff;
  *IndexConst(&mut out1).index_mut(3) = 0xfffffffeffffffff;
  *IndexConst(&mut out1).index_mut(4) = (0x0 as u64);
}

/// The function fiat_sm2_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_sm2_divstep(out1: &mut u64, mut out2: &mut [u64; 5], mut out3: &mut [u64; 5], mut out4: &mut [u64; 4], mut out5: &mut [u64; 4], arg1: u64, arg2: &[u64; 5], arg3: &[u64; 5], arg4: &[u64; 4], arg5: &[u64; 4]) {
  let mut x1: u64 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u64));
  let x3: fiat_sm2_u1 = (((x1 >> 63) as fiat_sm2_u1) & (((*IndexConst(arg3).index(0)) & (0x1 as u64)) as fiat_sm2_u1));
  let mut x4: u64 = 0;
  let mut x5: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u64));
  let mut x6: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x6, x3, arg1, x4);
  let mut x7: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x7, x3, (*IndexConst(arg2).index(0)), (*IndexConst(arg3).index(0)));
  let mut x8: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x8, x3, (*IndexConst(arg2).index(1)), (*IndexConst(arg3).index(1)));
  let mut x9: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x9, x3, (*IndexConst(arg2).index(2)), (*IndexConst(arg3).index(2)));
  let mut x10: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x10, x3, (*IndexConst(arg2).index(3)), (*IndexConst(arg3).index(3)));
  let mut x11: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x11, x3, (*IndexConst(arg2).index(4)), (*IndexConst(arg3).index(4)));
  let mut x12: u64 = 0;
  let mut x13: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x12, &mut x13, 0x0, (0x1 as u64), (!(*IndexConst(arg2).index(0))));
  let mut x14: u64 = 0;
  let mut x15: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x14, &mut x15, x13, (0x0 as u64), (!(*IndexConst(arg2).index(1))));
  let mut x16: u64 = 0;
  let mut x17: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x16, &mut x17, x15, (0x0 as u64), (!(*IndexConst(arg2).index(2))));
  let mut x18: u64 = 0;
  let mut x19: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x18, &mut x19, x17, (0x0 as u64), (!(*IndexConst(arg2).index(3))));
  let mut x20: u64 = 0;
  let mut x21: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x20, &mut x21, x19, (0x0 as u64), (!(*IndexConst(arg2).index(4))));
  let mut x22: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x22, x3, (*IndexConst(arg3).index(0)), x12);
  let mut x23: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x23, x3, (*IndexConst(arg3).index(1)), x14);
  let mut x24: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x24, x3, (*IndexConst(arg3).index(2)), x16);
  let mut x25: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x25, x3, (*IndexConst(arg3).index(3)), x18);
  let mut x26: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x26, x3, (*IndexConst(arg3).index(4)), x20);
  let mut x27: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x27, x3, (*IndexConst(arg4).index(0)), (*IndexConst(arg5).index(0)));
  let mut x28: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x28, x3, (*IndexConst(arg4).index(1)), (*IndexConst(arg5).index(1)));
  let mut x29: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x29, x3, (*IndexConst(arg4).index(2)), (*IndexConst(arg5).index(2)));
  let mut x30: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x30, x3, (*IndexConst(arg4).index(3)), (*IndexConst(arg5).index(3)));
  let mut x31: u64 = 0;
  let mut x32: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x31, &mut x32, 0x0, x27, x27);
  let mut x33: u64 = 0;
  let mut x34: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x33, &mut x34, x32, x28, x28);
  let mut x35: u64 = 0;
  let mut x36: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x35, &mut x36, x34, x29, x29);
  let mut x37: u64 = 0;
  let mut x38: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x37, &mut x38, x36, x30, x30);
  let mut x39: u64 = 0;
  let mut x40: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x39, &mut x40, 0x0, x31, 0xffffffffffffffff);
  let mut x41: u64 = 0;
  let mut x42: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x41, &mut x42, x40, x33, 0xffffffff00000000);
  let mut x43: u64 = 0;
  let mut x44: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x43, &mut x44, x42, x35, 0xffffffffffffffff);
  let mut x45: u64 = 0;
  let mut x46: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x45, &mut x46, x44, x37, 0xfffffffeffffffff);
  let mut x47: u64 = 0;
  let mut x48: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x47, &mut x48, x46, (x38 as u64), (0x0 as u64));
  let x49: u64 = (*IndexConst(arg4).index(3));
  let x50: u64 = (*IndexConst(arg4).index(2));
  let x51: u64 = (*IndexConst(arg4).index(1));
  let x52: u64 = (*IndexConst(arg4).index(0));
  let mut x53: u64 = 0;
  let mut x54: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x53, &mut x54, 0x0, (0x0 as u64), x52);
  let mut x55: u64 = 0;
  let mut x56: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x55, &mut x56, x54, (0x0 as u64), x51);
  let mut x57: u64 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x57, &mut x58, x56, (0x0 as u64), x50);
  let mut x59: u64 = 0;
  let mut x60: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x59, &mut x60, x58, (0x0 as u64), x49);
  let mut x61: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x61, x60, (0x0 as u64), 0xffffffffffffffff);
  let mut x62: u64 = 0;
  let mut x63: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x62, &mut x63, 0x0, x53, x61);
  let mut x64: u64 = 0;
  let mut x65: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x64, &mut x65, x63, x55, (x61 & 0xffffffff00000000));
  let mut x66: u64 = 0;
  let mut x67: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x66, &mut x67, x65, x57, x61);
  let mut x68: u64 = 0;
  let mut x69: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x68, &mut x69, x67, x59, (x61 & 0xfffffffeffffffff));
  let mut x70: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x70, x3, (*IndexConst(arg5).index(0)), x62);
  let mut x71: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x71, x3, (*IndexConst(arg5).index(1)), x64);
  let mut x72: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x72, x3, (*IndexConst(arg5).index(2)), x66);
  let mut x73: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x73, x3, (*IndexConst(arg5).index(3)), x68);
  let x74: fiat_sm2_u1 = ((x22 & (0x1 as u64)) as fiat_sm2_u1);
  let mut x75: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x75, x74, (0x0 as u64), x7);
  let mut x76: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x76, x74, (0x0 as u64), x8);
  let mut x77: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x77, x74, (0x0 as u64), x9);
  let mut x78: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x78, x74, (0x0 as u64), x10);
  let mut x79: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x79, x74, (0x0 as u64), x11);
  let mut x80: u64 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x80, &mut x81, 0x0, x22, x75);
  let mut x82: u64 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x82, &mut x83, x81, x23, x76);
  let mut x84: u64 = 0;
  let mut x85: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x84, &mut x85, x83, x24, x77);
  let mut x86: u64 = 0;
  let mut x87: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x86, &mut x87, x85, x25, x78);
  let mut x88: u64 = 0;
  let mut x89: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x88, &mut x89, x87, x26, x79);
  let mut x90: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x90, x74, (0x0 as u64), x27);
  let mut x91: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x91, x74, (0x0 as u64), x28);
  let mut x92: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x92, x74, (0x0 as u64), x29);
  let mut x93: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x93, x74, (0x0 as u64), x30);
  let mut x94: u64 = 0;
  let mut x95: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x94, &mut x95, 0x0, x70, x90);
  let mut x96: u64 = 0;
  let mut x97: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x96, &mut x97, x95, x71, x91);
  let mut x98: u64 = 0;
  let mut x99: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x98, &mut x99, x97, x72, x92);
  let mut x100: u64 = 0;
  let mut x101: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x100, &mut x101, x99, x73, x93);
  let mut x102: u64 = 0;
  let mut x103: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x102, &mut x103, 0x0, x94, 0xffffffffffffffff);
  let mut x104: u64 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x104, &mut x105, x103, x96, 0xffffffff00000000);
  let mut x106: u64 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x106, &mut x107, x105, x98, 0xffffffffffffffff);
  let mut x108: u64 = 0;
  let mut x109: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x108, &mut x109, x107, x100, 0xfffffffeffffffff);
  let mut x110: u64 = 0;
  let mut x111: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u64(&mut x110, &mut x111, x109, (x101 as u64), (0x0 as u64));
  let mut x112: u64 = 0;
  let mut x113: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u64(&mut x112, &mut x113, 0x0, x6, (0x1 as u64));
  let x114: u64 = ((x80 >> 1) | ((x82 << 63) & 0xffffffffffffffff));
  let x115: u64 = ((x82 >> 1) | ((x84 << 63) & 0xffffffffffffffff));
  let x116: u64 = ((x84 >> 1) | ((x86 << 63) & 0xffffffffffffffff));
  let x117: u64 = ((x86 >> 1) | ((x88 << 63) & 0xffffffffffffffff));
  let x118: u64 = ((x88 & 0x8000000000000000) | (x88 >> 1));
  let mut x119: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x119, x48, x39, x31);
  let mut x120: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x120, x48, x41, x33);
  let mut x121: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x121, x48, x43, x35);
  let mut x122: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x122, x48, x45, x37);
  let mut x123: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x123, x111, x102, x94);
  let mut x124: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x124, x111, x104, x96);
  let mut x125: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x125, x111, x106, x98);
  let mut x126: u64 = 0;
  fiat_sm2_cmovznz_u64(&mut x126, x111, x108, x100);
  *out1 = x112;
  *IndexConst(&mut out2).index_mut(0) = x7;
  *IndexConst(&mut out2).index_mut(1) = x8;
  *IndexConst(&mut out2).index_mut(2) = x9;
  *IndexConst(&mut out2).index_mut(3) = x10;
  *IndexConst(&mut out2).index_mut(4) = x11;
  *IndexConst(&mut out3).index_mut(0) = x114;
  *IndexConst(&mut out3).index_mut(1) = x115;
  *IndexConst(&mut out3).index_mut(2) = x116;
  *IndexConst(&mut out3).index_mut(3) = x117;
  *IndexConst(&mut out3).index_mut(4) = x118;
  *IndexConst(&mut out4).index_mut(0) = x119;
  *IndexConst(&mut out4).index_mut(1) = x120;
  *IndexConst(&mut out4).index_mut(2) = x121;
  *IndexConst(&mut out4).index_mut(3) = x122;
  *IndexConst(&mut out5).index_mut(0) = x123;
  *IndexConst(&mut out5).index_mut(1) = x124;
  *IndexConst(&mut out5).index_mut(2) = x125;
  *IndexConst(&mut out5).index_mut(3) = x126;
}

/// The function fiat_sm2_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_sm2_divstep_precomp(mut out1: &mut [u64; 4]) {
  *IndexConst(&mut out1).index_mut(0) = 0x500000028ffffffe;
  *IndexConst(&mut out1).index_mut(1) = 0xe80000009ffffffe;
  *IndexConst(&mut out1).index_mut(2) = 0xd00000018ffffffe;
  *IndexConst(&mut out1).index_mut(3) = 0x280000011ffffffd;
}
