% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{dimnames.Assay}
\alias{dimnames.Assay}
\alias{dimnames<-.Assay}
\title{Assay-Level Feature and Cell Names}
\usage{
\method{dimnames}{Assay}(x)

\method{dimnames}{Assay}(x) <- value
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{value}{A two-length list where the first entry is the existing feature
names for \code{x} and the second entry is the \emph{updated} cell names
for \code{x}}
}
\value{
\code{dimnames}: A two-length list with the following values:
\itemize{
 \item A character vector will all features in \code{x}
 \item A character vector will all cells in \code{x}
}

\code{dimnames<-}: \code{x} with the cell names updated to those
in \code{value[[2L]]}
}
\description{
Get and set feature and cell names in v5 Assays
}
\examples{
rna <- pbmc_small[["RNA"]]

# Feature and cell names can be acquired with `rownames` and `colnames`
head(rownames(rna))
head(colnames(rna))

# Cell names can be updated with `colnames<-`
colnames(rna)[1] <- "newcell"
head(colnames(rna))

}
\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{split.Assay}()},
\code{\link{subset.Assay}()}


\code{\link{Cells}()},
\code{\link{dimnames.Assay5}()},
\code{\link{dimnames.Seurat}()}
}
\concept{assay}
\concept{dimnames}
