/* $Id: Seq_bond.cpp 153363 2009-02-26 15:32:40Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqloc.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/seqloc/Seq_bond.hpp>
#include <objects/seqloc/Seq_point.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CSeq_bond::~CSeq_bond(void)
{
}


TSeqPos CSeq_bond::GetStart(ESeqLocExtremes /*ext*/) const
{
    TSeqPos a = GetA().GetPoint();
    if (!IsSetB()) {
        return a;
    }
    TSeqPos b = GetB().GetPoint();
    return min(a, b);
}


TSeqPos CSeq_bond::GetStop (ESeqLocExtremes /*ext*/) const
{
    TSeqPos a = GetA().GetPoint();
    if (!IsSetB()) {
        return a;
    }
    TSeqPos b = GetB().GetPoint();
    return max(a, b);
}


bool CSeq_bond::IsSetStrand(EIsSetStrand flag) const
{
    switch (flag) {
    case eIsSetStrand_Any:
        return GetA().IsSetStrand()  ||
            (IsSetB()  &&  GetB().IsSetStrand());
    case eIsSetStrand_All:
        return GetA().IsSetStrand()  &&
            IsSetB()  &&  GetB().IsSetStrand();
    }
    return false;
}


ENa_strand CSeq_bond::GetStrand(void) const
{
    ENa_strand a_strand = GetA().IsSetStrand() ?
        GetA().GetStrand() : eNa_strand_unknown;
    ENa_strand b_strand = eNa_strand_unknown;
    if (IsSetB()  &&  GetB().IsSetStrand()) {
        b_strand = GetB().GetStrand();
    }

    if (a_strand == eNa_strand_unknown  &&  b_strand != eNa_strand_unknown) {
        a_strand = b_strand;
    } else if (a_strand != eNa_strand_unknown  &&  b_strand == eNa_strand_unknown ) {
        b_strand = a_strand;
    }

    return (a_strand != b_strand) ? eNa_strand_other : a_strand;
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1886, CRC32: b0b23470 */
