#############################################################################
# $Id: CMake.NCBIComponentsCheck.cmake 695491 2025-03-25 12:32:48Z ivanov $
#############################################################################

##
## NCBI CMake components definition functions
##    Author: Andrei Gourianov, gouriano@ncbi
##
##
## As a result, the following variables should be defined for component XXX
##  NCBI_COMPONENT_XXX_FOUND
##  NCBI_COMPONENT_XXX_INCLUDE
##  NCBI_COMPONENT_XXX_DEFINES
##  NCBI_COMPONENT_XXX_LIBS
##  HAVE_LIBXXX


#to debug
#set(NCBI_TRACE_ALLCOMPONENTS ON)
#set(NCBI_TRACE_COMPONENT_GRPC ON)

if(UNIX OR APPLE)
    include(CheckLibraryExists)
    find_package(PkgConfig)
endif()
include(CheckIncludeFile)
include(CheckIncludeFileCXX)
include(CheckSymbolExists)

#############################################################################
#############################################################################
# Unix

string(REPLACE ":" ";" NCBI_PKG_CONFIG_PATH  "$ENV{PKG_CONFIG_PATH}")
set(PKG_CONFIG_USE_CMAKE_PREFIX_PATH TRUE)
#message("NCBI_PKG_CONFIG_PATH init = ${NCBI_PKG_CONFIG_PATH}")

separate_arguments(NCBI_EXTRA_SYS_LIB_DIRS NATIVE_COMMAND ${CMAKE_EXE_LINKER_FLAGS})
list(FILTER NCBI_EXTRA_SYS_LIB_DIRS INCLUDE REGEX "^-L")
list(TRANSFORM NCBI_EXTRA_SYS_LIB_DIRS REPLACE "^-L" "")

#############################################################################
function(NCBI_get_component_config_locations _sub _type)
    set(_ncbi_build_type  "$<CONFIG>${NCBI_PlatformBits}")
    set(_ncbi_build_typeMT  "$<CONFIG>${NCBI_BUILD_TYPE_SUFFIX}")
    set(_dirs
        ${NCBI_COMPILER}${NCBI_COMPILER_VERSION}-${_ncbi_build_typeMT}/${_type}
        ${NCBI_COMPILER}-${_ncbi_build_typeMT}/${_type}
        ${_ncbi_build_typeMT}/${_type}
        ${_ncbi_build_type}/${_type}
        ${_type}${NCBI_PlatformBits}
        ${_type}
    )
    if(DEFINED NCBI_COMPILER_COMPONENTS)
        set(_components ${NCBI_COMPILER_COMPONENTS})
        list(REVERSE _components)
        foreach(_c IN LISTS _components)
            set(_dirs ${_c}-${_ncbi_build_type}/${_type} ${_dirs})
        endforeach()
    endif()
    if(MaxDebug IN_LIST NCBI_PTBCFG_PROJECT_FEATURES)
        set(_dirs
            ${NCBI_COMPILER}${NCBI_COMPILER_VERSION}-${_ncbi_build_typeMT}ASan/${_type}
            ${NCBI_COMPILER}-${_ncbi_build_typeMT}ASan/${_type}
            ${_dirs})
    endif()
    set(${_sub} ${_dirs} PARENT_SCOPE)
endfunction()

#############################################################################
function(NCBIcomponent_find_module _name _module)
    if(NCBI_COMPONENT_${_name}_DISABLED)
        return()
    endif()
# root
    set(_root "")
    if (DEFINED NCBI_ThirdParty_${_name})
        set(_root ${NCBI_ThirdParty_${_name}})
    else()
        string(FIND ${_name} "." dotfound)
        string(SUBSTRING ${_name} 0 ${dotfound} _dotname)
        if (DEFINED NCBI_ThirdParty_${_dotname})
            set(_root ${NCBI_ThirdParty_${_dotname}})
        endif()
    endif()
    if("${_root}" STREQUAL "" OR NOT EXISTS "${_root}")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_module: ${_name}: root directory (${_root}) not found ")
        endif()
        return()
    endif()

    set(_roots ${_root})
    NCBI_get_component_config_locations( _subdirs lib)

    set(_all_found NO)
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBIcomponent_find_module: ${_name}: checking ${_root}: ${_subdirs}")
    endif()
    foreach(_root IN LISTS _roots)
        foreach(_sub IN LISTS _subdirs)
            if("${NCBI_CONFIGURATION_TYPES_COUNT}" EQUAL 1)
                string(REPLACE "$<CONFIG>" "${STD_BUILD_TYPE}" _libdir ${_sub})
            else()
                string(REPLACE "$<CONFIG>" "Release" _libdir ${_sub})
            endif()
            if(EXISTS ${_root}/${_libdir}/pkgconfig)
                set(_pkgcfg ${NCBI_PKG_CONFIG_PATH})
                if(NOT ${_root}/${_libdir}/pkgconfig IN_LIST _pkgcfg)
                    list(INSERT _pkgcfg 0 ${_root}/${_libdir}/pkgconfig)
                endif()
                set(CMAKE_PREFIX_PATH ${_pkgcfg})
                string(REPLACE ";" ":" _config_path  "${_pkgcfg}")
                set(ENV{PKG_CONFIG_PATH} "${_config_path}")
                if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                    message("PKG_CONFIG_PATH = $ENV{PKG_CONFIG_PATH}")
                endif()
                unset(${_name}_FOUND CACHE)
                if(DEFINED ${_name}_STATIC_LIBRARIES)
                    foreach(_lib IN LISTS ${_name}_STATIC_LIBRARIES)
                        if(NOT "${pkgcfg_lib_${_name}_${_lib}}" STREQUAL "")
                            unset(pkgcfg_lib_${_name}_${_lib} CACHE)
                        endif()
                    endforeach()
                endif()
                if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                    pkg_check_modules(${_name} ${_module})
                else()
                    pkg_search_module(${_name} QUIET ${_module})
                endif()

                if(${_name}_FOUND)
                    if(NOT ${_root}/${_libdir}/pkgconfig IN_LIST NCBI_PKG_CONFIG_PATH)
                        list(INSERT NCBI_PKG_CONFIG_PATH 0 ${_root}/${_libdir}/pkgconfig)
                        set(NCBI_PKG_CONFIG_PATH ${NCBI_PKG_CONFIG_PATH} PARENT_SCOPE)
                    endif()
                    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                        message("${_name}_LIBRARIES = ${${_name}_LIBRARIES}")
                        message("${_name}_CFLAGS = ${${_name}_CFLAGS}")
                        message("${_name}_CFLAGS_OTHER = ${${_name}_CFLAGS_OTHER}")
                        message("${_name}_LDFLAGS = ${${_name}_LDFLAGS}")
                        message("${_name}_LINK_LIBRARIES = ${${_name}_LINK_LIBRARIES}")
                        message("${_name}_STATIC_LIBRARIES = ${${_name}_STATIC_LIBRARIES}")
                        message("${_name}_STATIC_CFLAGS = ${${_name}_STATIC_CFLAGS}")
                        message("${_name}_STATIC_CFLAGS_OTHER = ${${_name}_STATIC_CFLAGS_OTHER}")
                        message("${_name}_STATIC_LDFLAGS = ${${_name}_STATIC_LDFLAGS}")
                        message("${_name}_STATIC_LINK_LIBRARIES = ${${_name}_STATIC_LINK_LIBRARIES}")
                    endif()
                    if(NOT "${${_name}_CFLAGS}" STREQUAL "")
                        set(_pkg_defines "")
                        foreach( _value IN LISTS ${_name}_CFLAGS)
                            string(FIND ${_value} "-D" _pos)
                            if(${_pos} EQUAL 0)
                            string(SUBSTRING ${_value} 2 -1 _pos)
                                list(APPEND _pkg_defines ${_pos})
                            endif()
                        endforeach()
                        set(NCBI_COMPONENT_${_name}_DEFINES ${_pkg_defines} PARENT_SCOPE)
                    endif()
                    set(_pkg_include ${${_name}_INCLUDE_DIRS})
                    if(NOT "${${_name}_LINK_LIBRARIES}" STREQUAL "")
                        set(_pkg_libs ${${_name}_LINK_LIBRARIES})
                    else()
                        set(_pkg_libs ${${_name}_LDFLAGS})
                    endif()
                    set(_pkg_version ${${_name}_VERSION})
if(OFF AND NOT APPLE)
                    if(NOT BUILD_SHARED_LIBS)
                        set(_lib "")
                        set(_libs "")
                        foreach(_lib IN LISTS _pkg_libs)
                            string(REGEX REPLACE "[.]so$" ".a" _stlib ${_lib})
                            if(EXISTS ${_stlib})
                                list(APPEND _libs ${_stlib})
                            else()
                                set(_libs "")
                                break()
                            endif()
                        endforeach()
                        if(NOT "${_libs}" STREQUAL "")
                            set(_pkg_libs ${_libs})
                        endif()
                    endif()
endif()
                    set(NCBI_COMPONENT_${_name}_INCLUDE ${_pkg_include} PARENT_SCOPE)
                    set(NCBI_COMPONENT_${_name}_LIBS ${_pkg_libs} PARENT_SCOPE)
                    set(_all_found YES)
                    break()
                endif()
            endif()
        endforeach()
        if(_all_found)
            break()
        endif()
    endforeach()

    if(_all_found)
        set(NCBI_COMPONENT_${_name}_VERSION "${_pkg_version}" PARENT_SCOPE)
        if(NOT "${_pkg_version}" STREQUAL "")
            set(_pkg_version "(version ${_pkg_version})")
        endif()
        message(STATUS "Found ${_name}: ${_root} ${_pkg_version}")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("${_name}: include dir = ${_pkg_include}")
            message("${_name}: libs = ${_pkg_libs}")
            if(NOT "${_pkg_defines}" STREQUAL "")
                message("${_name}: defines = ${_pkg_defines}")
            endif()
        endif()
        set(NCBI_COMPONENT_${_name}_FOUND YES PARENT_SCOPE)

        string(TOUPPER ${_name} _upname)
        set(HAVE_LIB${_upname} 1 PARENT_SCOPE)
        string(REPLACE "." "_" _altname ${_upname})
        set(HAVE_${_altname} 1 PARENT_SCOPE)
    else()
        set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_module: ${_name}: module ${_module} not found")
        endif()
    endif()
endfunction()

#############################################################################
function(NCBIcomponent_find_cmake_package _name _package)
    if(NCBI_COMPONENT_${_name}_DISABLED)
        return()
    endif()
# root
    set(_root "")
    if (DEFINED NCBI_ThirdParty_${_name})
        set(_root ${NCBI_ThirdParty_${_name}})
    else()
        string(FIND ${_name} "." dotfound)
        string(SUBSTRING ${_name} 0 ${dotfound} _dotname)
        if (DEFINED NCBI_ThirdParty_${_dotname})
            set(_root ${NCBI_ThirdParty_${_dotname}})
        endif()
    endif()
    if("${_root}" STREQUAL "" OR NOT EXISTS "${_root}")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_cmake_package: ${_name}: root directory (${_root}) not found ")
        endif()
        return()
    endif()
    set(_prefix ${CMAKE_STATIC_LIBRARY_PREFIX})
    if(NCBI_PTBCFG_COMPONENT_StaticComponents)
        set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX} ${CMAKE_SHARED_LIBRARY_SUFFIX})
    else()
        if(BUILD_SHARED_LIBS OR TRUE)
            set(_suffixes ${CMAKE_SHARED_LIBRARY_SUFFIX} ${CMAKE_STATIC_LIBRARY_SUFFIX})
        else()
            set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX} ${CMAKE_SHARED_LIBRARY_SUFFIX})
        endif()
    endif()

    set(_roots ${_root})
    NCBI_get_component_config_locations( _subdirs lib)

    set(_all_found NO)
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBIcomponent_find_cmake_package: ${_name}: checking ${_root}: ${_subdirs}")
    endif()
    foreach(_root IN LISTS _roots)
        foreach(_sub IN LISTS _subdirs)
            if("${NCBI_CONFIGURATION_TYPES_COUNT}" EQUAL 1)
                string(REPLACE "$<CONFIG>" "${STD_BUILD_TYPE}" _libdir ${_sub})
            else()
                string(REPLACE "$<CONFIG>" "Release" _libdir ${_sub})
            endif()
            if(EXISTS ${_root}/${_libdir}/cmake)
                set(_prev_CMAKE_PREFIX_PATH ${CMAKE_PREFIX_PATH})
                set(CMAKE_PREFIX_PATH ${_root}/${_libdir}/cmake)
                if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                    message("NCBIcomponent_find_cmake_package: find_package(${_package} ${ARGN} NO_CMAKE_SYSTEM_PATH)")
                    find_package(${_package} ${ARGN} NO_CMAKE_SYSTEM_PATH)
                else()
                    find_package(${_package} QUIET ${ARGN} NO_CMAKE_SYSTEM_PATH)
                endif()
                set(CMAKE_PREFIX_PATH ${_prev_CMAKE_PREFIX_PATH})
                string(TOLOWER ${_package} _lopackage)

                if(${_package}_FOUND)
                    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                        message("${_package}_INCLUDE_DIRS = ${${_package}_INCLUDE_DIRS}")
                        message("${_package}_LIBRARIES = ${${_package}_LIBRARIES}")
                        message("${_package}_LINK_LIBRARIES = ${${_package}_LINK_LIBRARIES}")
                        message("${_package}_LDFLAGS = ${${_package}_LDFLAGS}")
                        message("${_package}_PLATFORM_DEPS = ${${_package}_PLATFORM_DEPS}")
                        message("${_package}_THIRD_PARTY_LIBS = ${${_package}_THIRD_PARTY_LIBS}")
                    endif()
                    if(${_package}_INCLUDE_DIRS)
                        set(_pkg_include ${${_package}_INCLUDE_DIRS})
                    elseif(${_package}_INCLUDE_DIR)
                        set(_pkg_include ${${_package}_INCLUDE_DIR})
                    else()
                        set(_pkg_include "")
                    endif()
                    set(_pkg_include ${${_package}_INCLUDE_DIRS})
                    if(NOT "${${_package}_LINK_LIBRARIES}" STREQUAL "")
                        set(_pkg_libs ${${_package}_LINK_LIBRARIES})
                        if(${_package}_PLATFORM_DEPS)
                            foreach(_dep IN LISTS ${_package}_PLATFORM_DEPS)
                                set(_found NO)
                                foreach(_suffix IN LISTS _suffixes)
                                    if(EXISTS ${_root}/${_libdir}/${_prefix}${_dep}${_suffix})
                                        LIST(APPEND _pkg_libs ${_root}/${_libdir}/${_prefix}${_dep}${_suffix})
                                        set(_found YES)
                                        break()
                                    endif()
                                endforeach()
#                                if(NOT _found)
#                                    LIST(APPEND _pkg_libs -l${_dep})
#                                endif()
                            endforeach()
                        endif()
                    elseif(NOT "${DC_CMAKE_LIB}" STREQUAL "")
                        set(_pkg_libs)
                        foreach(_lib IN LISTS DC_CMAKE_LIB)
                            if(TARGET "${_package}::${_lib}")
                                list(APPEND _pkg_libs "${_package}::${_lib}")
                            elseif(TARGET "${_lopackage}::${_lib}")
                                list(APPEND _pkg_libs "${_lopackage}::${_lib}")
                            elseif(TARGET "${_lib}")
                                list(APPEND _pkg_libs "${_lib}")
                            else()
                                message("ERROR: ${_package}::${_lib} is not a target")
                            endif()
                        endforeach()
                    elseif(TARGET "${_package}::${_lopackage}")
                        set(_pkg_libs ${_package}::${_lopackage})
                    elseif(TARGET "${_lopackage}::${_lopackage}")
                        set(_pkg_libs ${_lopackage}::${_lopackage})
                    elseif(TARGET "${_lopackage}::lib${_lopackage}")
                        set(_pkg_libs ${_lopackage}::lib${_lopackage})
                    else()
                        set(_pkg_libs ${${_package}_LDFLAGS})
                    endif()
                    set(_pkg_version ${${_package}_VERSION})
                    set(NCBI_COMPONENT_${_name}_INCLUDE ${_pkg_include} PARENT_SCOPE)
                    set(NCBI_COMPONENT_${_name}_LIBS ${_pkg_libs} PARENT_SCOPE)
                    set(_all_found YES)
                    break()
                endif()
            endif()
        endforeach()
        if(_all_found)
            break()
        endif()
    endforeach()

    if(_all_found)
        set(NCBI_COMPONENT_${_name}_VERSION "${_pkg_version}" PARENT_SCOPE)
        if(NOT "${_pkg_version}" STREQUAL "")
            set(_pkg_version "(version ${_pkg_version})")
        endif()
        message(STATUS "Found ${_name}: ${_root} ${_pkg_version}")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("${_name}: include dir = ${_pkg_include}")
            message("${_name}: libs = ${_pkg_libs}")
            if(NOT "${_pkg_defines}" STREQUAL "")
                message("${_name}: defines = ${_pkg_defines}")
            endif()
        endif()
        set(NCBI_COMPONENT_${_name}_FOUND YES PARENT_SCOPE)

        string(TOUPPER ${_name} _upname)
        set(HAVE_LIB${_upname} 1 PARENT_SCOPE)
        string(REPLACE "." "_" _altname ${_upname})
        set(HAVE_${_altname} 1 PARENT_SCOPE)
    else()
        set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_cmake_package: ${_name}: package ${_package} not found")
        endif()
    endif()
endfunction()

#############################################################################
function(NCBI_define_component _name)
    if(NCBI_COMPONENT_${_name}_DISABLED)
        return()
    endif()
# root
    set(_root "")
    if (DEFINED NCBI_ThirdParty_${_name})
        set(_root ${NCBI_ThirdParty_${_name}})
    else()
        string(FIND ${_name} "." dotfound)
        string(SUBSTRING ${_name} 0 ${dotfound} _dotname)
        if (DEFINED NCBI_ThirdParty_${_dotname})
            set(_root ${NCBI_ThirdParty_${_dotname}})
        endif()
    endif()
    if("${_root}" STREQUAL "" OR NOT EXISTS "${_root}")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBI_define_component: ${_name}: root directory (${_root}) not found ")
        endif()
        return()
    endif()

    set(_prefix ${CMAKE_STATIC_LIBRARY_PREFIX})
    if(NCBI_PTBCFG_COMPONENT_StaticComponents)
        set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX} ${CMAKE_SHARED_LIBRARY_SUFFIX})
    else()
        if(BUILD_SHARED_LIBS OR TRUE)
            set(_suffixes ${CMAKE_SHARED_LIBRARY_SUFFIX} ${CMAKE_STATIC_LIBRARY_SUFFIX})
        else()
            set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX} ${CMAKE_SHARED_LIBRARY_SUFFIX})
        endif()
    endif()

    set(_roots ${_root})
    set(_args ${ARGN})
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBI_define_component: ${_name}: checking ${_root}: ${_args}")
    endif()

# include dir
    if(DEFINED DC_INCPATH_SUFFIX)
        NCBI_get_component_config_locations(_subdirs ${DC_INCPATH_SUFFIX})
    else()
        NCBI_get_component_config_locations(_subdirs include)
    endif()

    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("${_name}: checking ${_root}: ${_subdirs}")
    endif()
    set(_inc "")

    foreach(_sub IN LISTS _subdirs)
        set(_mapped_Debug)
        set(_mapped_Release)
        set(_this_found YES)
        foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
            NCBI_util_Cfg_ToStd(${_cfg} _std_cfg)
            string(REPLACE "$<CONFIG>" "${_std_cfg}" _incdir ${_sub})
            if (NOT EXISTS ${_root}/${_incdir})
                set(_this_found NO)
                break()
            endif()
            set(_mapped_${_std_cfg} ${_incdir})
            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                message("${_name}/${_cfg}: found  ${_root}/${_incdir}")
            endif()
        endforeach()
        if(_this_found)
            if("${_mapped_Debug}" STREQUAL "")
                set(_inc ${_mapped_Release})
            elseif("${_mapped_Release}" STREQUAL "")
                set(_inc ${_mapped_Debug})
            elseif("${_mapped_Release}" STREQUAL "${_mapped_Debug}")
                set(_inc ${_mapped_Debug})
            else()
                set(_inc "$<IF:$<CONFIG:${NCBI_DEBUG_CONFIGURATION_TYPES_STRING}>,${_mapped_Debug},${_mapped_Release}>")
            endif()
            set(_inc ${_root}/${_inc})
            break()
        endif()
    endforeach()
    if("${_inc}" STREQUAL "")
        message("NOT FOUND ${_name}: ${_root}/include not found")
        return()
    endif()
    set(NCBI_COMPONENT_${_name}_INCLUDE ${_inc} PARENT_SCOPE)
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("${_name}: include dir = ${_inc}")
    endif()

# libraries
    if(DEFINED DC_LIBPATH_SUFFIX)
        NCBI_get_component_config_locations(_subdirs ${DC_LIBPATH_SUFFIX})
    else()
        NCBI_get_component_config_locations(_subdirs lib)
    endif()

    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("${_name}: checking ${_root}: ${_subdirs}")
    endif()
    if (BUILD_SHARED_LIBS AND DEFINED NCBI_ThirdParty_${_name}_SHLIB)
        set(_roots ${NCBI_ThirdParty_${_name}_SHLIB} ${_roots})
        set(_subdirs shlib64 shlib lib64 lib)
    endif()

    set(_all_found YES)
    foreach(_root IN LISTS _roots)
        foreach(_sub IN LISTS _subdirs)
            set(_all_found YES)
            set(_all_libs "")

            foreach(_lib IN LISTS _args)
                set(_mapped_location_Debug)
                set(_mapped_name_Debug)
                set(_mapped_location_Release)
                set(_mapped_name_Release)
                set(_all_cfg_found YES)
                foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
                    if(${_cfg} IN_LIST NCBI_DEBUG_CONFIGURATION_TYPES)
                        set(_std_cfg "Debug")
                    else()
                        set(_std_cfg "Release")
                    endif()
                    if(NOT "${_mapped_location_${_std_cfg}}" STREQUAL "")
                        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                            message("${_name}/${_cfg}: already found")
                        endif()
                        continue()
                    endif()
                    string(TOLOWER ${_std_cfg} _lo_std_cfg)
                    string(REPLACE "$<CONFIG>" "${_std_cfg}" _libdir ${_sub})
                    string(REPLACE "$<LOSTDCONFIG>" "${_lo_std_cfg}" _libdir ${_libdir})
                    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                        message("${_name}/${_cfg}: checking  ${_root}/${_libdir}")
                    endif()
                    set(_this_cfg_found NO)
                    foreach(_sfx IN LISTS _suffixes)
                        if(EXISTS ${_root}/${_libdir}/${_prefix}${_lib}${_sfx})
                            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                                message("${_name}/${_cfg}: found   ${_root}/${_libdir}/${_prefix}${_lib}${_sfx}")
                            endif()
                            set(_mapped_location_${_std_cfg} ${_libdir})
                            set(_mapped_name_${_std_cfg} ${_prefix}${_lib}${_sfx})
                            set(_this_cfg_found YES)
                            break()
                        elseif(EXISTS ${_root}/${_libdir}/${_prefix}${_lib}d${_sfx})
                            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                                message("${_name}/${_cfg}: found   ${_root}/${_libdir}/${_prefix}${_lib}d${_sfx}")
                            endif()
                            set(_mapped_location_${_std_cfg} ${_libdir})
                            set(_mapped_name_${_std_cfg} ${_prefix}${_lib}d${_sfx})
                            set(_this_cfg_found YES)
                            break()
                        endif()
                    endforeach()
                    if(NOT _this_cfg_found)
                        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                            message("${_name}/${_cfg}: not found   ${_root}/${_libdir}/${_prefix}${_lib}")
                        endif()
                        set(_all_cfg_found NO)
                        break()
                    endif()
                endforeach()
                if(_all_cfg_found)
                    if("${_mapped_name_Debug}" STREQUAL "")
                        set(_libname ${_mapped_name_Release})
                    elseif("${_mapped_name_Release}" STREQUAL "")
                        set(_libname ${_mapped_name_Debug})
                    elseif("${_mapped_name_Release}" STREQUAL "${_mapped_name_Debug}")
                        set(_libname ${_mapped_name_Debug})
                    else()
                        set(_libname "$<IF:$<CONFIG:${NCBI_DEBUG_CONFIGURATION_TYPES_STRING}>,${_mapped_name_Debug},${_mapped_name_Release}>")
                    endif()
                    if("${_mapped_location_Debug}" STREQUAL "")
                        set(_liblocation ${_mapped_location_Release})
                    elseif("${_mapped_location_Release}" STREQUAL "")
                        set(_liblocation ${_mapped_location_Debug})
                    elseif("${_mapped_location_Release}" STREQUAL "${_mapped_location_Debug}")
                        set(_liblocation ${_mapped_location_Debug})
                    else()
                        set(_liblocation "$<IF:$<CONFIG:${NCBI_DEBUG_CONFIGURATION_TYPES_STRING}>,${_mapped_location_Debug},${_mapped_location_Release}>")
                    endif()
                    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                        message("${_name}: found   ${_root}/${_liblocation}/${_libname}")
                    endif()
                    list(APPEND _all_libs ${_root}/${_liblocation}/${_libname})
                else()
                    set(_all_found NO)
                    break()
                endif()
            endforeach()

            if(_all_found)
                break()
            endif()
        endforeach()
        if(_all_found)
            break()
        endif()
    endforeach()

    if(_all_found)
        get_filename_component(_ver ${_root} NAME)
        string(REGEX MATCH "[0-9].*" _ver "${_ver}")
        set(NCBI_COMPONENT_${_name}_VERSION "${_ver}" PARENT_SCOPE)
        message(STATUS "Found ${_name}: ${_root}")
        set(NCBI_COMPONENT_${_name}_FOUND YES PARENT_SCOPE)
#        set(NCBI_COMPONENT_${_name}_INCLUDE ${_root}/include)
        set(NCBI_COMPONENT_${_name}_LIBS ${_all_libs} PARENT_SCOPE)

        string(TOUPPER ${_name} _upname)
        set(HAVE_LIB${_upname} 1 PARENT_SCOPE)
        string(REPLACE "." "_" _altname ${_upname})
        set(HAVE_${_altname} 1 PARENT_SCOPE)
    else()
        set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBI_define_component: ${_name}: some libraries not found at ${_root}")
        endif()
    endif()

endfunction()

#############################################################################
function(NCBIcomponent_find_default_module _name _module)
    if(NCBI_COMPONENT_${_name}_DISABLED)
        return()
    endif()
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBIcomponent_find_default_module: ${_name}: ${_module}")
    endif()

    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        pkg_search_module(${_name} ${_module})
    else()
        pkg_search_module(${_name} QUIET ${_module})
    endif()

    if(${_name}_FOUND)
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("${_name}_LIBRARIES = ${${_name}_LIBRARIES}")
            message("${_name}_CFLAGS = ${${_name}_CFLAGS}")
            message("${_name}_CFLAGS_OTHER = ${${_name}_CFLAGS_OTHER}")
            message("${_name}_LDFLAGS = ${${_name}_LDFLAGS}")
            message("${_name}_LINK_LIBRARIES = ${${_name}_LINK_LIBRARIES}")
        endif()
        if(NOT "${${_name}_CFLAGS}" STREQUAL "")
            set(_pkg_defines "")
            foreach( _value IN LISTS ${_name}_CFLAGS)
                string(FIND ${_value} "-D" _pos)
                if(${_pos} EQUAL 0)
                string(SUBSTRING ${_value} 2 -1 _pos)
                    list(APPEND _pkg_defines ${_pos})
                endif()
            endforeach()
            set(NCBI_COMPONENT_${_name}_DEFINES ${_pkg_defines} PARENT_SCOPE)
        endif()
        set(_pkg_include ${${_name}_INCLUDE_DIRS})
        if(NOT "${${_name}_LINK_LIBRARIES}" STREQUAL "" AND NOT APPLE)
            set(_pkg_libs ${${_name}_LINK_LIBRARIES})
        else()
            set(_pkg_libs ${${_name}_LDFLAGS})
        endif()
        set(_pkg_version ${${_name}_VERSION})

        if("${_pkg_include}" STREQUAL "" AND "${_pkg_libs}" STREQUAL "")
            set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                message("NCBIcomponent_find_default_module: ${_name}: module ${_module} not found")
            endif()
            return()
        endif()

        set(NCBI_COMPONENT_${_name}_VERSION "${_pkg_version}" PARENT_SCOPE)
        if(NOT "${_pkg_version}" STREQUAL "")
            set(_pkg_version "(version ${_pkg_version})")
        endif()
        message(STATUS "Found ${_name}: ${_pkg_version}")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("${_name}: include dir = ${_pkg_include}")
            message("${_name}: libs = ${_pkg_libs}")
            if(NOT "${_pkg_defines}" STREQUAL "")
                message("${_name}: defines = ${_pkg_defines}")
            endif()
        endif()
        set(NCBI_COMPONENT_${_name}_FOUND YES PARENT_SCOPE)
        set(NCBI_COMPONENT_${_name}_INCLUDE ${_pkg_include} PARENT_SCOPE)
        set(NCBI_COMPONENT_${_name}_LIBS ${_pkg_libs} PARENT_SCOPE)

        string(TOUPPER ${_name} _upname)
        set(HAVE_LIB${_upname} 1 PARENT_SCOPE)
        string(REPLACE "." "_" _altname ${_upname})
        set(HAVE_${_altname} 1 PARENT_SCOPE)
    else()
        set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_default_module: ${_name}: module ${_module} not found")
        endif()
    endif()
endfunction()

#############################################################################
macro(NCBIcomponent_find_package _name _pkg)
    if(NOT NCBI_COMPONENT_${_name}_DISABLED)
        set(_package ${_pkg})
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_package: ${_name}: using find_package(${_package})")
        endif()
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            find_package(${_package} ${ARGN})
        else()
            find_package(${_package} QUIET ${ARGN})
        endif()
        string(TOUPPER ${_package} _uppackage)
        string(TOLOWER ${_package} _lopackage)
        if (${_package}_FOUND OR ${_uppackage}_FOUND OR ${_lopackage}_FOUND)
            if( ${_uppackage}_LIBRARIES OR ${_uppackage}_INCLUDE_DIRS OR
                ${_uppackage}_LIBRARY   OR ${_uppackage}_INCLUDE_DIR)
                set(_package ${_uppackage})
            elseif( ${_lopackage}_LIBRARIES OR ${_lopackage}_INCLUDE_DIRS OR
                ${_lopackage}_LIBRARY   OR ${_lopackage}_INCLUDE_DIR)
                set(_package ${_lopackage})
            endif()
            if(${_package}_INCLUDE_DIRS)
                set(_pkg_include ${${_package}_INCLUDE_DIRS})
            elseif(${_package}_INCLUDE_DIR)
                set(_pkg_include ${${_package}_INCLUDE_DIR})
            else()
                set(_pkg_include "")
            endif()
            if(${_package}_LIBRARIES)
                set(_pkg_libs ${${_package}_LIBRARIES})
            elseif(${_package}_LIBRARY)
                set(_pkg_libs ${${_package}_LIBRARY})
            elseif(TARGET "${_package}::${_package}")
                set(_pkg_libs ${_package}::${_package})
            elseif(TARGET "${_lopackage}::${_lopackage}")
                set(_pkg_libs ${_lopackage}::${_lopackage})
            elseif(TARGET "${_uppackage}::${_uppackage}")
                set(_pkg_libs ${_uppackage}::${_uppackage})
            else()
                set(_pkg_libs "")
            endif()
            set(NCBI_COMPONENT_${_name}_INCLUDE ${_pkg_include})
            set(NCBI_COMPONENT_${_name}_LIBS ${_pkg_libs})
            if(DEFINED ${_package}_DEFINITIONS)
                set(NCBI_COMPONENT_${_name}_DEFINES ${${_package}_DEFINITIONS})
                set(_pkg_defines ${${_package}_DEFINITIONS})
            else()
                set(_pkg_defines "")
            endif()
            if(DEFINED ${_package}_VERSION_STRING)
                set(_pkg_version ${${_package}_VERSION_STRING})
            elseif(DEFINED ${_package}_VERSION)
                set(_pkg_version ${${_package}_VERSION})
            elseif(DEFINED ${_pkg}_VERSION)
                set(_pkg_version ${${_pkg}_VERSION})
            else()
                set(_pkg_version "")
            endif()

            set(NCBI_COMPONENT_${_name}_VERSION "${_pkg_version}")
            if(NOT "${_pkg_version}" STREQUAL "")
                set(_pkg_version "version ${_pkg_version}")
            endif()
#            message(STATUS "Found ${_name}: ${_pkg_libs} ${_pkg_version}")
            message(STATUS "Found ${_name}: ${_pkg_version}")
            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                message("${_name}: include dir = ${_pkg_include}")
                message("${_name}: libs = ${_pkg_libs}")
                if(NOT "${_pkg_defines}" STREQUAL "")
                    message("${_name}: defines = ${_pkg_defines}")
                endif()
            endif()
            set(NCBI_COMPONENT_${_name}_FOUND YES)

            string(TOUPPER ${_name} _upname)
            set(HAVE_LIB${_upname} 1)
            string(REPLACE "." "_" _altname ${_upname})
            set(HAVE_${_altname} 1)
        else()
            set(NCBI_COMPONENT_${_name}_FOUND NO)
            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                message("NCBIcomponent_find_package: ${_name}: package ${_package} not found")
            endif()
        endif()
    endif()
endmacro()

#############################################################################
macro(NCBIcomponent_find_library _name)
    if(NOT NCBI_COMPONENT_${_name}_DISABLED)
        set(_args ${ARGN})
        set(_all_libs "")
        set(_notfound_libs "")
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_find_library: ${_name}: ${_args}")
        endif()
        foreach(_lib IN LISTS _args)
            if(DEFINED DC_LIBPATH_SUFFIX)
                find_library(${_lib}_LIB ${_lib} PATH_SUFFIXES ${DC_LIBPATH_SUFFIX})
            else()
                find_library(${_lib}_LIB ${_lib})
            endif()
            if (${_lib}_LIB)
if(OFF)
                list(APPEND _all_libs ${${_lib}_LIB})
else()
                set(_libname ${_name}::${_lib}_LIB)
                add_library(${_libname} INTERFACE IMPORTED)
                set_property(TARGET ${_libname} PROPERTY INTERFACE_LINK_LIBRARIES ${${_lib}_LIB})
                message(STATUS "    Found ${_libname}: ${${_lib}_LIB}")
                list(APPEND _all_libs ${_libname})
endif()
            else()
                list(APPEND _notfound_libs ${_lib})
            endif()
        endforeach()
        if("${_notfound_libs}" STREQUAL "")
            set(NCBI_COMPONENT_${_name}_FOUND YES)
            set(NCBI_COMPONENT_${_name}_LIBS ${_all_libs})
            message(STATUS "Found ${_name}: ${NCBI_COMPONENT_${_name}_LIBS}")

            string(TOUPPER ${_name} _upname)
            set(HAVE_LIB${_upname} 1)
            set(HAVE_${_upname} 1)
        else()
            set(NCBI_COMPONENT_${_name}_FOUND NO)
            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                message("NCBIcomponent_find_library: ${_name}: some libraries not found: ${_notfound_libs}")
            endif()
        endif()
    endif()
endmacro()

#############################################################################
function(NCBIcomponent_find_include _name)
    if(NCBI_COMPONENT_${_name}_DISABLED OR NOT NCBI_COMPONENT_${_name}_FOUND)
        return()
    endif()
    set(_args ${ARGN})
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBIcomponent_find_include: ${_name}: finding ${_args}")
    endif()
    set(_found "")
    set(_known ${NCBI_COMPONENT_${_name}_INCLUDE})
    foreach(_inc IN LISTS _args)
        if(IS_ABSOLUTE ${_inc})
            if(IS_DIRECTORY ${_inc})
                list(APPEND _found ${_inc})
            else()
                get_filename_component(_dir ${_inc} DIRECTORY)
                list(APPEND _found ${_dir})
            endif()
        else()
            set(_res FALSE)
            if(NOT "${_known}" STREQUAL "")
                foreach(_k IN LISTS _known)
                    if(EXISTS "${_k}/${_inc}")
                        if(IS_DIRECTORY ${_k}/${_inc})
                            list(APPEND _found ${_k}/${_inc})
                        else()
                            get_filename_component(_dir ${_k}/${_inc} DIRECTORY)
                            list(APPEND _found ${_dir})
                        endif()
                        set(_res TRUE)
                    endif()
                endforeach()
            endif()
            if(NOT _res)
                find_file(_NCBI_COMPONENT_${_name}_INC ${_inc})
                if(_NCBI_COMPONENT_${_name}_INC)
                    set(_inc ${_NCBI_COMPONENT_${_name}_INC})
                    if(IS_DIRECTORY ${_inc})
                        list(APPEND _found ${_inc})
                    else()
                        get_filename_component(_dir ${_inc} DIRECTORY)
                        list(APPEND _found ${_dir})
                    endif()
                endif()
                unset(_NCBI_COMPONENT_${_name}_INC CACHE)
            endif()
        endif()
    endforeach()
    set(_found ${_known} ${_found})
    if(NOT "${_found}" STREQUAL "")
        list(REMOVE_DUPLICATES _found)
    endif()
    set(NCBI_COMPONENT_${_name}_INCLUDE ${_found} PARENT_SCOPE)
    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBIcomponent_find_include: ${_name}: include dirs: ${_found}")
    endif()
endfunction()

#############################################################################
macro(NCBIcomponent_check_include _name)
    if(NOT NCBI_COMPONENT_${_name}_DISABLED)
        set(_prefix ${DC_INCLUDE})
        if(NOT "${DC_INCLUDE}" STREQUAL "")
            set(_prefix ${_prefix}/)
        endif()
        set(_args ${ARGN})
        foreach(_c IN LISTS _args)
            if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                message("NCBIcomponent_check_include: ${_prefix}${_c}")
            endif()
            check_include_file_cxx(${_prefix}${_c} _HAVE_INC)
            if(NOT _HAVE_INC)
                set(NCBI_COMPONENT_${_name}_FOUND NO)
            endif()
            unset(_HAVE_INC CACHE)
        endforeach()
    endif()
endmacro()

#############################################################################
macro(NCBIcomponent_add  _name)
    if(NOT NCBI_COMPONENT_${_name}_DISABLED AND NCBI_COMPONENT_${_name}_FOUND)
        set(_args ${ARGN})
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NCBIcomponent_add: ${_name}: adding ${_args}")
        endif()
        foreach(_c IN LISTS _args)
            if(NCBI_COMPONENT_${_c}_FOUND)
                set(NCBI_COMPONENT_${_name}_INCLUDE ${NCBI_COMPONENT_${_name}_INCLUDE} ${NCBI_COMPONENT_${_c}_INCLUDE})
                set(NCBI_COMPONENT_${_name}_LIBS    ${NCBI_COMPONENT_${_name}_LIBS}    ${NCBI_COMPONENT_${_c}_LIBS})
            endif()
        endforeach()
    endif()
endmacro()

#############################################################################
macro(NCBI_find_Xlibrary _value _lib)
    if(NCBI_PTBCFG_COMPONENT_StaticComponents)
        find_library(${_value} NAMES ${CMAKE_STATIC_LIBRARY_PREFIX}${_lib}${CMAKE_STATIC_LIBRARY_SUFFIX} ${_lib})
    else()
        find_library(${_value} NAMES ${_lib})
    endif()
    if(NCBI_TRACE_COMPONENT_${_value} OR NCBI_TRACE_ALLCOMPONENTS)
        message("NCBI_find_Xlibrary: ${_value} = ${${_value}}")
    endif()
endmacro()

#############################################################################
function(NCBI_find_system_library _name _lib)
    set(_args ${ARGN})
    set(_type "${ARGV2}")

    set(_libname "NCBI::${_name}")
    if("${_type}" STREQUAL "STATIC")
        find_library(__NCBI_SYS_LIBS NAMES ${CMAKE_STATIC_LIBRARY_PREFIX}${_lib}${CMAKE_STATIC_LIBRARY_SUFFIX} ${_lib} PATHS ${NCBI_EXTRA_SYS_LIB_DIRS})
    else()
        find_library(__NCBI_SYS_LIBS NAMES ${_lib} PATHS ${NCBI_EXTRA_SYS_LIB_DIRS})
    endif()
    if(__NCBI_SYS_LIBS)
        add_library(${_libname} INTERFACE IMPORTED)
        set_property(TARGET ${_libname} PROPERTY INTERFACE_LINK_LIBRARIES ${__NCBI_SYS_LIBS})
        set(${_name} ${_libname} PARENT_SCOPE)
        message(STATUS "Found ${_name}: ${__NCBI_SYS_LIBS}")
    else()
        message("NOT FOUND ${_name}")
        set(${_name} "" PARENT_SCOPE)
    endif()
    unset(__NCBI_SYS_LIBS CACHE)
endfunction()

#############################################################################
macro(NCBI_define_Xcomponent)
    cmake_parse_arguments(DC "" "NAME;PACKAGE;MODULE;LIBPATH_SUFFIX;INCPATH_SUFFIX" "LIB;INCLUDE;ADD_COMPONENT;CHECK_INCLUDE;CMAKE_PACKAGE;CMAKE_LIB" ${ARGN})

    if("${DC_NAME}" STREQUAL "")
        message(FATAL_ERROR "No component name")
    endif()
    if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND)
        set(NCBI_COMPONENT_${DC_NAME}_FOUND NO)
        if(NOT NCBI_COMPONENT_${DC_NAME}_DISABLED)
            if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND AND NOT "${DC_CMAKE_PACKAGE}" STREQUAL "")
                NCBIcomponent_find_cmake_package(${DC_NAME} ${DC_CMAKE_PACKAGE})
            endif()
            if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND AND NOT "${DC_MODULE}" STREQUAL "" AND PKG_CONFIG_FOUND
                AND NOT NCBI_PTBCFG_COMPONENT_StaticComponents AND NOT NCBI_PTBCFG_USECONAN AND NOT NCBI_PTBCFG_PACKAGED)
                NCBIcomponent_find_module(${DC_NAME} ${DC_MODULE})
            endif()
            if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND)
                if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND AND "${DC_CMAKE_PACKAGE}" STREQUAL "")
                    NCBI_define_component(${DC_NAME} ${DC_LIB})
                endif()
                if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND AND NOT "${DC_MODULE}" STREQUAL "" AND PKG_CONFIG_FOUND
                     AND NOT NCBI_PTBCFG_USECONAN AND NOT NCBI_PTBCFG_PACKAGED)
                    NCBIcomponent_find_default_module(${DC_NAME} ${DC_MODULE})
                endif()
                if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND AND NOT "${DC_PACKAGE}" STREQUAL "")
                    NCBIcomponent_find_package(${DC_NAME} ${DC_PACKAGE})
                endif()
                if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND)
                    # alternate way by renaming package name
                    set(DC_PACKAGE_ALT ${NCBI_PACKAGE_ALT_${DC_NAME}})
                    if (NOT "${DC_PACKAGE_ALT}" STREQUAL "")
                        NCBIcomponent_find_package(${DC_NAME} ${DC_PACKAGE_ALT})
                    endif()
                endif()
                if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND AND NOT "${DC_LIB}" STREQUAL "")
                    set(NCBI_COMPONENT_${DC_NAME}_FOUND YES)
                    if(NOT "${DC_CHECK_INCLUDE}" STREQUAL "")
                        NCBIcomponent_check_include(${DC_NAME} ${DC_CHECK_INCLUDE})
                    endif()
                    if(NCBI_COMPONENT_${DC_NAME}_FOUND)
                        NCBIcomponent_find_library(${DC_NAME} ${DC_LIB})
                    endif()
                endif()

                if(NCBI_COMPONENT_${DC_NAME}_FOUND)
                    if(NOT "${DC_INCLUDE}" STREQUAL "")
                        NCBIcomponent_find_include(${DC_NAME} ${DC_INCLUDE})
                    endif()
                endif()
            endif()
            if(NCBI_COMPONENT_${DC_NAME}_FOUND)
                if(NOT "${DC_ADD_COMPONENT}" STREQUAL "")
                    NCBIcomponent_add(${DC_NAME} ${DC_ADD_COMPONENT})
                endif()
            endif()
            if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND)
                message("NOT FOUND ${DC_NAME}")
            elseif(NCBI_TRACE_COMPONENT_${DC_NAME} OR NCBI_TRACE_ALLCOMPONENTS)
                message("----------------------")
                message("NCBI_define_Xcomponent: ${DC_NAME}")
                message("version: ${NCBI_COMPONENT_${DC_NAME}_VERSION}")
                message("include: ${NCBI_COMPONENT_${DC_NAME}_INCLUDE}")
                message("libs:    ${NCBI_COMPONENT_${DC_NAME}_LIBS}")
                message("defines: ${NCBI_COMPONENT_${DC_NAME}_DEFINES}")
                message("----------------------")
            endif()
        endif()
    endif()
    unset(DC_NAME)
    unset(DC_PACKAGE)
    unset(DC_MODULE)
    unset(DC_LIBPATH_SUFFIX)
    unset(DC_INCPATH_SUFFIX)
    unset(DC_LIB)
    unset(DC_INCLUDE)
    unset(DC_COMPONENT)
endmacro()

#############################################################################
#############################################################################
# Windows

#############################################################################
function(NCBI_define_Wcomponent _name)

    if(NCBI_COMPONENT_${_name}_FOUND)
        return()
    endif()
    set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
    if(NCBI_COMPONENT_${_name}_DISABLED)
        return()
    endif()
# root
    if (DEFINED NCBI_ThirdParty_${_name})
        set(_root ${NCBI_ThirdParty_${_name}})
    else()
        string(FIND ${_name} "." dotfound)
        string(SUBSTRING ${_name} 0 ${dotfound} _dotname)
        if (DEFINED NCBI_ThirdParty_${_dotname})
            set(_root ${NCBI_ThirdParty_${_dotname}})
        else()
            message("NOT FOUND ${_name}: NCBI_ThirdParty_${_name} not found")
            return()
        endif()
    endif()
# include dir
    if (EXISTS ${_root}/include)
        set(_found YES)
    else()
        message("NOT FOUND ${_name}: ${_root}/include not found")
        set(_found NO)
    endif()
# libraries
    set(_enable_binpath TRUE)
    set(_args ${ARGN})
    if (_found)
        if(BUILD_SHARED_LIBS AND NOT NCBI_PTBCFG_COMPONENT_StaticComponents)
            set(_locations lib_dll/ lib_static/ lib/)
        else()
            set(_locations lib_static/ lib_dll/ lib/)
        endif()
        list(APPEND _locations "")
        set(_rt ${NCBI_BUILD_TYPE_SUFFIX})
        set(_usemap FALSE)

        foreach(_libdir IN LISTS _locations)
            set(_mapped_Debug)
            set(_mapped_Release)
            set(_found YES)
            foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
                if(${_cfg} IN_LIST NCBI_DEBUG_CONFIGURATION_TYPES)
                    set(_std_cfg "Debug")
                else()
                    set(_std_cfg "Release")
                endif()
                if(NOT "${_mapped_${_std_cfg}}" STREQUAL "")
                    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                        message("${_name}/${_cfg}: already found")
                    endif()
                    continue()
                endif()
                if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                    message("${_name}/${_cfg}: checking ${_root}/${_libdir}${_cfg}")
                endif()
                foreach(_lib IN LISTS _args)
                    if(EXISTS ${_root}/${_libdir}${_cfg}/${_lib})
                        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                            message("${_name}/${_cfg}: found 1   ${_root}/${_libdir}${_cfg}/${_lib}")
                        endif()
                        set(_mapped_${_std_cfg} ${_cfg})
                        continue()
                    elseif(EXISTS ${_root}/${_libdir}${_std_cfg}/${_lib})
                        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                            message("${_name}/${_cfg}: found 2   ${_root}/${_libdir}${_std_cfg}/${_lib}")
                        endif()
                        set(_mapped_${_std_cfg} ${_std_cfg})
                        set(_usemap TRUE)
                        continue()
                    elseif(EXISTS ${_root}/${_libdir}${_std_cfg}${_rt}/${_lib})
                        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                            message("${_name}/${_cfg}: found 3   ${_root}/${_libdir}${_std_cfg}${_rt}/${_lib}")
                        endif()
                        set(_mapped_${_std_cfg} ${_std_cfg}${_rt})
                        set(_usemap TRUE)
                        continue()
                    endif()
                    if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                        message("${_name}: ${_root}/${_libdir}${_cfg}/${_lib} not found")
                    endif()
                    unset(_mapped_${_std_cfg})
                    set(_found NO)
                    break()
                endforeach()
                if (NOT _found)
                    break()
                endif()
            endforeach()
            if (_found)
                if(_usemap)
                    if("${_mapped_Debug}" STREQUAL "")
                        set(_libtype ${_libdir}${_mapped_Release})
                    elseif("${_mapped_Release}" STREQUAL "")
                        set(_libtype ${_libdir}${_mapped_Debug})
                    elseif("${_mapped_Release}" STREQUAL "${_mapped_Debug}")
                        set(_libtype ${_libdir}${_mapped_Debug})
                    else()
                        set(_libtype ${_libdir}$<IF:$<CONFIG:${NCBI_DEBUG_CONFIGURATION_TYPES_STRING}>,${_mapped_Debug},${_mapped_Release}>)
                    endif()
                else()
                    set(_libtype ${_libdir}$<CONFIG>)
                endif()
                if("${_libdir}" STREQUAL "lib_static/")
                    set(_enable_binpath FALSE)
                endif()
                break()
            endif()
        endforeach()

        if (NOT _found)
            set(_locations lib libs)
            foreach(_libdir IN LISTS _locations)
                set(_found YES)
                if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                    message("${_name}: checking ${_root}/${_libdir}")
                endif()
                foreach(_lib IN LISTS _args)
                    if(NOT EXISTS ${_root}/${_libdir}/${_lib})
                        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
                            message("${_name}: ${_root}/${_libdir}/${_lib} not found")
                        endif()
                        set(_found NO)
                    endif()
                endforeach()
                if (_found)
                    set(_libtype ${_libdir})
                    break()
                endif()
            endforeach()
        endif()

        if (NOT _found)
            message("NOT FOUND ${_name}: some libraries not found at ${_root}")
        endif()
    endif()

    if (_found)
        get_filename_component(_ver ${_root} NAME)
        set(NCBI_COMPONENT_${_name}_VERSION "${_ver}" PARENT_SCOPE)
        message(STATUS "Found ${_name}: ${_root}")
        set(NCBI_COMPONENT_${_name}_FOUND YES PARENT_SCOPE)
        set(NCBI_COMPONENT_${_name}_INCLUDE ${_root}/include PARENT_SCOPE)
        foreach(_lib IN LISTS _args)
            set(NCBI_COMPONENT_${_name}_LIBS ${NCBI_COMPONENT_${_name}_LIBS} ${_root}/${_libtype}/${_lib})
        endforeach()
        set(NCBI_COMPONENT_${_name}_LIBS ${NCBI_COMPONENT_${_name}_LIBS} PARENT_SCOPE)
        if (EXISTS ${_root}/bin AND _enable_binpath)
            set(NCBI_COMPONENT_${_name}_BINPATH ${_root}/bin PARENT_SCOPE)
        endif()
        if(NCBI_TRACE_COMPONENT_${_name} OR NCBI_TRACE_ALLCOMPONENTS)
            message("----------------------")
            message("NCBI_define_Wcomponent: ${_name}")
            message("version: ${_ver}")
            message("include: ${_root}/include")
            message("libs:    ${NCBI_COMPONENT_${_name}_LIBS}")
            message("binpath: ${NCBI_COMPONENT_${_name}_BINPATH}")
            message("----------------------")
        endif()

        string(TOUPPER ${_name} _upname)
        set(HAVE_LIB${_upname} 1 PARENT_SCOPE)
        string(REPLACE "." "_" _altname ${_upname})
        set(HAVE_${_altname} 1 PARENT_SCOPE)
    else()
        set(NCBI_COMPONENT_${_name}_FOUND NO PARENT_SCOPE)
    endif()
endfunction()

#############################################################################
#############################################################################
# Conan

#############################################################################
function(NCBI_define_Pkgcomponent)
    cmake_parse_arguments(DC "" "NAME;PACKAGE;FIND" "REQUIRES" ${ARGN})

    if("${DC_NAME}" STREQUAL "")
        message(FATAL_ERROR "No component name")
    endif()
    if("${DC_PACKAGE}" STREQUAL "")
        message(FATAL_ERROR "No package name")
    endif()
    if(WIN32)
        set(_prefix "")
        set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX})
    else()
        set(_prefix lib)
        if(NCBI_PTBCFG_COMPONENT_StaticComponents)
            set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX} ${CMAKE_SHARED_LIBRARY_SUFFIX})
        else()
            if(BUILD_SHARED_LIBS OR TRUE)
                set(_suffixes ${CMAKE_SHARED_LIBRARY_SUFFIX} ${CMAKE_STATIC_LIBRARY_SUFFIX})
            else()
                set(_suffixes ${CMAKE_STATIC_LIBRARY_SUFFIX} ${CMAKE_SHARED_LIBRARY_SUFFIX})
            endif()
        endif()
    endif()
    string(TOUPPER ${DC_PACKAGE} _UPPACKAGE)
    set(DC_REQUIRES ${DC_PACKAGE} ${DC_REQUIRES})

    set(_found NO)
    set(NCBI_COMPONENT_${DC_NAME}_FOUND NO PARENT_SCOPE)
    if(NCBI_COMPONENT_${DC_NAME}_DISABLED)
        message("DISABLED ${DC_NAME}")
    elseif(DEFINED CONAN_${_UPPACKAGE}_ROOT)
        message(STATUS "Found ${DC_NAME}: ${CONAN_${_UPPACKAGE}_ROOT}")
        set(_found YES)
        set(NCBI_COMPONENT_${DC_NAME}_FOUND YES PARENT_SCOPE)
        set(_include ${CONAN_INCLUDE_DIRS_${_UPPACKAGE}})
        set(_defines ${CONAN_DEFINES_${_UPPACKAGE}})
        set(NCBI_COMPONENT_${DC_NAME}_INCLUDE ${_include} PARENT_SCOPE)
        set(NCBI_COMPONENT_${DC_NAME}_DEFINES ${_defines} PARENT_SCOPE)

        set(_all_libs "")
        foreach(_package IN LISTS DC_REQUIRES)
            string(TOUPPER ${_package} _UPPACKAGE)
            if(DEFINED CONAN_${_UPPACKAGE}_ROOT)
                if(TARGET CONAN_PKG::${_package})
                    list(APPEND _all_libs CONAN_PKG::${_package})
                else()
                    if(NOT "${CONAN_LIB_DIRS_${_UPPACKAGE}}" STREQUAL "" AND NOT "${CONAN_LIBS_${_UPPACKAGE}}" STREQUAL "")
                        foreach(_lib IN LISTS CONAN_LIBS_${_UPPACKAGE})
                            set(_this_found NO)
                            foreach(_dir IN LISTS CONAN_LIB_DIRS_${_UPPACKAGE})
                                foreach(_sfx IN LISTS _suffixes)
                                    if(EXISTS ${_dir}/${_prefix}${_lib}${_sfx})
                                        list(APPEND _all_libs ${_dir}/${_prefix}${_lib}${_sfx})
                                        set(_this_found YES)
                                        if(NCBI_TRACE_COMPONENT_${DC_NAME} OR NCBI_TRACE_ALLCOMPONENTS)
                                            message("${DC_NAME}: found:  ${_dir}/${_prefix}${_lib}${_sfx}")
                                        endif()
                                        break()
                                    endif()
                                endforeach()
                                if(_this_found)
                                    break()
                                endif()
                            endforeach()
                            if(NOT _this_found)
                                list(APPEND _all_libs ${_lib})
                            endif()
                        endforeach()
                    endif()
                endif()
            else()
                message("ERROR: ${DC_NAME}: ${_package} not found")
            endif()
        endforeach()
        set(NCBI_COMPONENT_${DC_NAME}_LIBS ${_all_libs} PARENT_SCOPE)
        if(MSVC)
            set(NCBI_COMPONENT_${DC_NAME}_BINPATH ${CONAN_BIN_DIRS_${_UPPACKAGE}} PARENT_SCOPE)
        endif()
    elseif(NOT "${DC_FIND}" STREQUAL "")
       set(CONAN_CMAKE_SILENT_OUTPUT TRUE)
if(OFF)
        NCBIcomponent_find_package(${DC_NAME} ${DC_FIND} CONFIG)
        if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND)
            file(GLOB _files "${CMAKE_BINARY_DIR}/Find${DC_FIND}*")
            list(LENGTH _files _count)
            if(NOT ${_count} EQUAL 0)
                NCBIcomponent_find_package(${DC_NAME} ${DC_FIND})
            endif()
        endif()
else()
        NCBIcomponent_find_package(${DC_NAME} ${DC_FIND} NO_CMAKE_SYSTEM_PATH)
        if(NOT NCBI_COMPONENT_${DC_NAME}_FOUND)
            NCBIcomponent_find_package(${DC_NAME} ${DC_FIND})
        endif()
endif()
        if(NCBI_COMPONENT_${DC_NAME}_FOUND)
            set(_found YES)
            set(_include ${NCBI_COMPONENT_${DC_NAME}_INCLUDE})
            set(_defines ${NCBI_COMPONENT_${DC_NAME}_DEFINES})
            set(_all_libs ${NCBI_COMPONENT_${DC_NAME}_LIBS})

            if("${_all_libs}" STREQUAL "" AND "${_include}" STREQUAL "")
                set(NCBI_COMPONENT_${DC_NAME}_FOUND NO PARENT_SCOPE)
                set(_found NO)
            else()
                set(NCBI_COMPONENT_${DC_NAME}_FOUND YES PARENT_SCOPE)
                set(NCBI_COMPONENT_${DC_NAME}_VERSION ${NCBI_COMPONENT_${DC_NAME}_VERSION} PARENT_SCOPE)
                set(NCBI_COMPONENT_${DC_NAME}_INCLUDE ${_include} PARENT_SCOPE)
                set(NCBI_COMPONENT_${DC_NAME}_LIBS ${_all_libs} PARENT_SCOPE)
                set(NCBI_COMPONENT_${DC_NAME}_DEFINES ${NCBI_COMPONENT_${DC_NAME}_DEFINES} PARENT_SCOPE)

                NCBI_map_imported_config( ${DC_NAME} ${_all_libs})
                if(MSVC)
                    foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
                        if(NOT "${NCBI_COMPONENT_${DC_NAME}_BINPATH_${_cfg}}" STREQUAL "")
                            set(NCBI_COMPONENT_${DC_NAME}_BINPATH_${_cfg} ${NCBI_COMPONENT_${DC_NAME}_BINPATH_${_cfg}} PARENT_SCOPE)
                        endif()
                    endforeach()
                endif()
            endif()
        endif()
    endif()

    if(_found)
        string(TOUPPER ${DC_NAME} _upname)
        set(HAVE_LIB${_upname} 1 PARENT_SCOPE)
        string(REPLACE "." "_" _altname ${_upname})
        set(HAVE_${_altname} 1 PARENT_SCOPE)

        list(APPEND NCBI_ALL_COMPONENTS ${DC_NAME})
        list(REMOVE_DUPLICATES NCBI_ALL_COMPONENTS)
        set(NCBI_ALL_COMPONENTS ${NCBI_ALL_COMPONENTS} PARENT_SCOPE)
        if(NCBI_TRACE_COMPONENT_${DC_NAME} OR NCBI_TRACE_ALLCOMPONENTS)
            message("----------------------")
            message("NCBI_define_Pkgcomponent: ${DC_NAME}")
            message("include: ${_include}")
            message("libs:    ${_all_libs}")
            message("defines: ${_defines}")
            message("----------------------")
        endif()
    else()
        if(NCBI_TRACE_COMPONENT_${DC_NAME} OR NCBI_TRACE_ALLCOMPONENTS)
            message("NOT FOUND ${DC_NAME}")
        endif()
    endif()
endfunction()

#############################################################################
function(NCBI_map_imported_config _comp)
    set(_all ${ARGN})
    list(REMOVE_DUPLICATES _all)
    foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
        set(NCBI_IMPORT_BINPATH_${_cfg})
    endforeach()

    set(_todo ${_all})
    set(_done)
    while(NOT "${_todo}" STREQUAL "")
        set(_next)
        foreach(_lib IN LISTS _todo)
            if(TARGET ${_lib} AND NOT ${_lib} IN_LIST _done)
                NCBI_map_one_import( ${_lib} INTERFACE_COMPILE_DEFINITIONS _out1)
                NCBI_map_one_import( ${_lib} INTERFACE_INCLUDE_DIRECTORIES _out2)
                set(_out3)
                NCBI_map_one_import( ${_lib} INTERFACE_LINK_LIBRARIES _out3)
                list(APPEND _next ${_out3})
            endif()
        endforeach()
        list(APPEND _done ${_todo})
        set(_todo ${_next})
        list(REMOVE_DUPLICATES _todo)
    endwhile()
    if(MSVC)
         foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
            if(NOT "${NCBI_IMPORT_BINPATH_${_cfg}}" STREQUAL "")
                set(NCBI_COMPONENT_${_comp}_BINPATH_${_cfg} ${NCBI_IMPORT_BINPATH_${_cfg}} PARENT_SCOPE)
            endif()
        endforeach()
    endif()
endfunction()

#############################################################################
function(NCBI_map_one_import _lib _property _todo)
    get_property(_props TARGET ${_lib} PROPERTY ${_property})
    if("${_props}" STREQUAL "")
        return()
    endif()
    set(_other)
    set(_CONFIG "CONFIG:")
    set(_LIBS FALSE)
    if(${_property} STREQUAL INTERFACE_LINK_LIBRARIES)
        set(_LIBS TRUE)
    endif()
    string(FIND "${_props}" ${_CONFIG} _pos)
    if(${_pos} LESS 0)
        if(_LIBS)
            foreach(_i IN LISTS _props)
                if(TARGET ${_i})
                    list(APPEND _other ${_i})
                endif()
            endforeach()
            set(${_todo} ${_other} PARENT_SCOPE)

            foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
                NCBI_util_Cfg_ToStd(${_cfg} _map_cfg)
                string(TOUPPER ${_cfg} _up_cfg)
                string(TOUPPER ${_map_cfg} _map_cfg)
                get_property(_loc TARGET ${_lib} PROPERTY IMPORTED_LOCATION_${_map_cfg})
                if(NOT "${_loc}" STREQUAL "")
                    if(NOT "${_up_cfg}" STREQUAL "${_map_cfg}")
                        set_property(TARGET ${_lib} PROPERTY IMPORTED_LOCATION_${_up_cfg} ${_loc})
                    endif()

                    get_filename_component(_path "${_loc}" DIRECTORY)
                    if(WIN32)
                        get_filename_component(_path "${_path}/../bin" ABSOLUTE)
                    endif()
                    if(EXISTS "${_path}")
                        list(APPEND NCBI_IMPORT_BINPATH_${_cfg} ${_path})
                        list(REMOVE_DUPLICATES NCBI_IMPORT_BINPATH_${_cfg})
                        set(NCBI_IMPORT_BINPATH_${_cfg} ${NCBI_IMPORT_BINPATH_${_cfg}} PARENT_SCOPE)
                    endif()
                endif()
                get_property(_loc TARGET ${_lib} PROPERTY IMPORTED_IMPLIB_${_map_cfg})
                if(NOT "${_loc}" STREQUAL "")
                    if(NOT "${_up_cfg}" STREQUAL "${_map_cfg}")
                        set_property(TARGET ${_lib} PROPERTY IMPORTED_IMPLIB_${_up_cfg} ${_loc})
                    endif()
                endif()
            endforeach()
        endif()
        return()
    endif()
    set(_append)
    foreach(_cfg IN LISTS NCBI_CONFIGURATION_TYPES)
        NCBI_util_Cfg_ToStd(${_cfg} _map_cfg)
        string(FIND "${_props}" ${_CONFIG}${_cfg} _pos)
        set(_skip_append FALSE)
        if(${_pos} GREATER 0)
            set(_skip_append TRUE)
        endif()
        list(LENGTH _props _count)
        set(_index 0)
        while(TRUE)
            set(_new)
            while(${_index} LESS ${_count})
                list(GET _props ${_index} _i)
                if(NOT "${_new}" STREQUAL "")
                    string(FIND "${_i}" ${_CONFIG} _pos)
                    if(${_pos} GREATER 0)
                        break()
                    else()
                        list(APPEND _new ${_i})
                    endif()
                endif()
                string(FIND "${_i}" ${_CONFIG}${_map_cfg} _pos)
                if(${_pos} GREATER 0)
                    string(REPLACE ${_CONFIG}${_map_cfg} ${_CONFIG}${_cfg} _new "${_i}")
                endif()
                math(EXPR _index "${_index} + 1")
            endwhile()
            if("${_new}" STREQUAL "")
                break()
            endif()
            if(NOT _LIBS)
                if(NOT _skip_append)
                    list(APPEND _append ${_new})
                endif()
                continue()
            endif()
            set(_checked)
            foreach(_i IN LISTS _new)
                if(TARGET ${_i})
                    list(APPEND _other ${_i})
                else()
                    string(FIND "${_i}" "${_CONFIG}" _pos)
                    if(${_pos} GREATER 0)
                        string(REPLACE ${_CONFIG}${_cfg} "" _j "${_i}")
                        string(REPLACE "$<$<>:" "" _j "${_j}")
                    else()
                        set(_j ${_i})
                    endif()
                    string(REPLACE ">" "" _j "${_j}")
                    if(TARGET "${_j}")
                        list(APPEND _other ${_j})
                    elseif(NOT "${_j}" STREQUAL "")
                    endif()
                endif()
                list(APPEND _checked ${_i})
            endforeach()
            if(NOT _skip_append)
                list(APPEND _append ${_checked})
            endif()
        endwhile()
    endforeach()
    if(NOT "${_append}" STREQUAL "")
        list(APPEND _props ${_append})
        set_property(TARGET ${_lib} PROPERTY ${_property} ${_props})
    endif()
    if (_LIBS AND NOT "${_other}" STREQUAL "")
        list(REMOVE_DUPLICATES _other)
        set(${_todo} ${_other} PARENT_SCOPE)
    endif()
endfunction()

#############################################################################
function(NCBI_verify_targets _file)
    if(NOT EXISTS ${_file})
        return()
    endif()

    file(STRINGS ${_file} _targets)
    if("${_targets}" STREQUAL "")
        return()
    endif()
    foreach( _prj IN LISTS _targets)
        if(NOT TARGET ${_prj})
            continue()
        endif()
        get_target_property(_deps ${_prj} INTERFACE_LINK_LIBRARIES)
        if(_deps)
            foreach( _dep IN LISTS _deps)
                if(TARGET ${_dep})
                    continue()
                endif()
                if("${_dep}" MATCHES ".+::.+")
                    string(REPLACE "::" ";" _names ${_dep})
                    list(GET _names 0 _name)
                    string(TOUPPER ${_name} _UPPACKAGE)
                    if(NOT DEFINED CONAN_${_UPPACKAGE}_ROOT)
                        list(GET _names 1 _name)
                        string(TOUPPER ${_name} _UPPACKAGE)
                    endif()
                    if(DEFINED CONAN_${_UPPACKAGE}_ROOT)
                        set(NCBI_COMPONENT_required_FOUND NO)
                        NCBI_define_Pkgcomponent(NAME required PACKAGE ${_name})
                        if(NCBI_COMPONENT_required_FOUND)
                            add_library(${_dep} INTERFACE IMPORTED)
                            set_property(TARGET ${_dep} PROPERTY INTERFACE_LINK_LIBRARIES      ${NCBI_COMPONENT_required_LIBS})
                            set_property(TARGET ${_dep} PROPERTY INTERFACE_INCLUDE_DIRECTORIES ${NCBI_COMPONENT_required_INCLUDE})
                            set_property(TARGET ${_dep} PROPERTY INTERFACE_COMPILE_DEFINITIONS ${NCBI_COMPONENT_required_DEFINES})
                        endif()
                    endif()
                else()
                    get_filename_component(_ext ${_dep} EXT)
                    if (NOT "${_ext}" STREQUAL "")
                        continue()
                    endif()
                    foreach(_component IN LISTS NCBI_ALL_COMPONENTS)
                        if(NOT "${NCBI_COMPONENT_${_component}_LIBS}" STREQUAL "")
                            foreach(_lib IN LISTS NCBI_COMPONENT_${_component}_LIBS)
                                get_filename_component(_directory ${_lib} DIRECTORY)
                                if("${_directory}" STREQUAL "")
                                    continue()
                                endif()
                                get_filename_component(_basename ${_lib} NAME_WE)
                                if ("${_dep}" STREQUAL "${_basename}" OR "lib${_dep}" STREQUAL "${_basename}")
                                    add_library(${_dep} INTERFACE IMPORTED)
                                    set_property(TARGET ${_dep} PROPERTY INTERFACE_LINK_LIBRARIES      ${NCBI_COMPONENT_${_component}_LIBS})
                                    set_property(TARGET ${_dep} PROPERTY INTERFACE_INCLUDE_DIRECTORIES ${NCBI_COMPONENT_${_component}_INCLUDE})
                                    set_property(TARGET ${_dep} PROPERTY INTERFACE_COMPILE_DEFINITIONS ${NCBI_COMPONENT_${_component}_DEFINES})
                                    break()
                                endif()
                            endforeach()
                        endif()
                        if(TARGET ${_dep})
                            break()
                        endif()
                    endforeach()
                endif()
            endforeach()
        endif()
    endforeach()
endfunction()

##############################################################################
macro(NCBI_util_disable_find_use_path)
    if(DEFINED CMAKE_FIND_USE_SYSTEM_ENVIRONMENT_PATH)
        set(NCBI_FIND_USE_SYSTEM_ENVIRONMENT_PATH ${CMAKE_FIND_USE_SYSTEM_ENVIRONMENT_PATH})
    endif()
    set(CMAKE_FIND_USE_SYSTEM_ENVIRONMENT_PATH FALSE)
    if(DEFINED CMAKE_FIND_USE_CMAKE_SYSTEM_PATH)
        set(NCBI_FIND_USE_CMAKE_SYSTEM_PATH ${CMAKE_FIND_USE_CMAKE_SYSTEM_PATH})
    endif()
    set(CMAKE_FIND_USE_CMAKE_SYSTEM_PATH FALSE)
endmacro()

macro(NCBI_util_enable_find_use_path)
    if(DEFINED NCBI_FIND_USE_SYSTEM_ENVIRONMENT_PATH)
        set(CMAKE_FIND_USE_SYSTEM_ENVIRONMENT_PATH ${NCBI_FIND_USE_SYSTEM_ENVIRONMENT_PATH})
        unset(NCBI_FIND_USE_SYSTEM_ENVIRONMENT_PATH)
    else()
        unset(CMAKE_FIND_USE_SYSTEM_ENVIRONMENT_PATH)
    endif()
    if(DEFINED NCBI_FIND_USE_CMAKE_SYSTEM_PATH)
        set(CMAKE_FIND_USE_CMAKE_SYSTEM_PATH ${NCBI_FIND_USE_CMAKE_SYSTEM_PATH})
        unset(NCBI_FIND_USE_CMAKE_SYSTEM_PATH)
    else()
        unset(CMAKE_FIND_USE_CMAKE_SYSTEM_PATH)
    endif()
endmacro()
