/*############################################################################*/
/*#                                                                          #*/
/*#  Ambisonic C++ Library                                                   #*/
/*#  Copyright © 2017 Videolabs                                              #*/
/*#                                                                          #*/
/*#  Filename:      AmbisonicProcessor.cpp                                   #*/
/*#  Version:       0.2                                                      #*/
/*#  Date:          19/05/2007                                               #*/
/*#  Author(s):     Peter Stitt, Bruce Wiggins                               #*/
/*#  Licence:       LGPL                                                     #*/
/*#                                                                          #*/
/*############################################################################*/

namespace spaudio {
    namespace ambi_decs {

        // Decoder coefficients for Ambisonics to stereo. Useful for conversion to 2-channels when not using headphone.
        const float decoder_coefficient_stereo[][16] =
        {
        {0.5f, 0.5f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f},
        {0.5f, -0.5f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
        };

        // First order AmbiX decoder for 5.1 loudspeaker array provided by Bruce Wiggins
        // Do not activate psychoacoustic optimisation filters
        const float decoder_coefficient_first_5_1[][4] = { {0.300520f, 0.405000f, 0.000000f, 0.360000f},
        {0.300520f, -0.405000f, 0.000000f, 0.360000f},
        {0.332340f, 0.415000f, 0.000000f, -0.330000f},
        {0.332340f, -0.415000f, 0.000000f, -0.330000f},
        {0.141421f, 0.000000f, 0.000000f, 0.160000f},
        {0.500000f, 0.000000f, 0.000000f, 0.000000f} };

        // Second order AmbiX decoder for 5.1 loudspeaker array provided by Bruce Wiggins
        // Do not activate psychoacoustic optimisation filters
        const float decoder_coefficient_second_5_1[][9] = { {0.286378f, 0.310000f, -0.000000f, 0.320000f, 0.144338f, 0.000000f, 0.000000f, 0.000000f, 0.098150f},
        {0.286378f, -0.310000f, -0.000000f, 0.320000f, -0.144338f, 0.000000f, 0.000000f, -0.000000f, 0.098150f},
        {0.449013f, 0.280000f, -0.000000f, -0.335000f, 0.092376f, -0.000000f, -0.000000f, 0.000000f, -0.092376f},
        {0.449013f, -0.280000f, -0.000000f, -0.335000f, -0.092376f, -0.000000f, -0.000000f, 0.000000f, -0.092376f},
        {0.060104f, 0.000000f, 0.000000f, 0.040000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.051962f},
        {0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };

        // Third order AmbiX decoder for 5.1 loudspeaker array provided by Bruce Wiggins
        // Do not activate psychoacoustic optimisation filters
        const float decoder_coefficient_third_5_1[][16] = { {0.219203f, 0.285000f, 0.000000f, 0.310000f, 0.213620f, 0.000000f, 0.000000f, 0.000000f, 0.005774f, 0.075895f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.031623f},
        {0.219203f, -0.285000f, 0.000000f, 0.310000f, -0.213620f, 0.000000f, 0.000000f, 0.000000f, 0.005774f, -0.075895f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.031623f},
        {0.417193f, 0.385000f, 0.000000f, -0.335000f, 0.023094f, 0.000000f, 0.000000f, 0.000000f, -0.028868f, -0.082219f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.031623f},
        {0.417193f, -0.385000f, 0.000000f, -0.335000f, -0.023094f, 0.000000f, 0.000000f, 0.000000f, -0.028868f, 0.082219f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.031623f},
        {0.095459f, 0.000000f, 0.000000f, 0.265000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.248261f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.132816f},
        {0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };


        // 7.1 Decoders
        // First order AmbiX decoder for 7.1 loudspeaker array
        // Do not activate psychoacoustic optimisation filters
        const float decoder_coefficient_first_7_1[][4] = { {0.303082f, 0.287875f, 0.000000f, 0.342728f},
        {0.303082f, -0.287875f, 0.000000f, 0.342728f},
        {0.300098f, 0.374300f, 0.000000f, -0.052342f},
        {0.300098f, -0.374300f, 0.000000f, -0.052342f},
        {0.259458f, 0.159799f, 0.000000f, -0.351986f},
        {0.259458f, -0.159799f, 0.000000f, -0.351986f},
        {0.066262f, 0.000000f, 0.000000f, 0.095211f},
        {0.500000f, 0.000000f, 0.000000f, 0.000000f} };

        // Second order AmbiX decoder for 7.1 loudspeaker array
        // Do not activate psychoacoustic optimisation filters
        const float decoder_coefficient_second_7_1[][9] = { {0.268964f, 0.270975f, 0.000000f, 0.333072f, 0.224335f, 0.000000f, 0.000000f, 0.000000f, 0.078680f},
        {0.268964f, -0.270975f, 0.000000f, 0.333072f, -0.224335f, -0.000000f, 0.000000f, 0.000000f, 0.078680f},
        {0.229483f, 0.410083f, 0.000000f, -0.054360f, -0.104766f, 0.000000f, 0.000000f, 0.000000f, -0.245007f},
        {0.229483f, -0.410083f, 0.000000f, -0.054360f, 0.104766f, -0.000000f, 0.000000f, 0.000000f, -0.245007f},
        {0.216456f, 0.126035f, 0.000000f, -0.348660f, -0.194391f, 0.000000f, 0.000000f, 0.000000f, 0.160026f},
        {0.216456f, -0.126035f, 0.000000f, -0.348660f, 0.194391f, -0.000000f, 0.000000f, 0.000000f, 0.160026f},
        {0.058222f, 0.000000f, 0.000000f, 0.146799f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.126464f},
        {0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };

        // Third order AmbiX decoder for 7.1 loudspeaker array
        // Do not activate psychoacoustic optimisation filters
        const float decoder_coefficient_third_7_1[][16] = { {0.238475f, 0.257618f, 0.000000f, 0.344630f, 0.272865f, 0.000000f, 0.000000f, 0.000000f, 0.075817f, 0.043776f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.043293f},
        {0.238475f, -0.257618f, 0.000000f, 0.344630f, -0.272865f, -0.000000f, 0.000000f, 0.000000f, 0.075817f, -0.043776f, -0.000000f, -0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.043293f},
        {0.214882f, 0.372126f, 0.000000f, -0.052741f, -0.090319f, 0.000000f, 0.000000f, 0.000000f, -0.301275f, -0.083357f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.057111f},
        {0.214882f, -0.372126f, 0.000000f, -0.052741f, 0.090319f, -0.000000f, 0.000000f, 0.000000f, -0.301275f, 0.083357f, -0.000000f, -0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.057111f},
        {0.197904f, 0.130070f, 0.000000f, -0.347020f, -0.241820f, 0.000000f, 0.000000f, 0.000000f, 0.170646f, 0.120386f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.013078f},
        {0.197904f, -0.130070f, 0.000000f, -0.347020f, 0.241820f, -0.000000f, 0.000000f, 0.000000f, 0.170646f, -0.120386f, -0.000000f, -0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.013078f},
        {0.077144f, 0.000000f, 0.000000f, 0.136861f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.152741f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.177300f},
        {0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };

    } // namespace ambi_decs
} // namespace spaudio
