// NOTE: There are three sets of functions that each have to be resolved separately.
//       1. Loader Functions: Used to query and create an instance to use
//       2. Instance Functions: Used to query and create a device to use
//       3. Device Functions: Used to interact directly with the device driver
#ifdef HL_USE_VULKAN_LOADER_FNS
// v1.0+
VULKAN_FN(vkCreateInstance)
VULKAN_FN(vkGetInstanceProcAddr)
VULKAN_FN(vkEnumerateInstanceExtensionProperties)
VULKAN_FN(vkEnumerateInstanceLayerProperties)
// v1.1+
VULKAN_FN(vkEnumerateInstanceVersion)
#endif
#ifdef HL_USE_VULKAN_INSTANCE_FNS
// v1.0+
VULKAN_FN(vkCreateDevice)
VULKAN_FN(vkDestroyInstance)
VULKAN_FN(vkEnumerateDeviceExtensionProperties)
VULKAN_FN(vkEnumerateDeviceLayerProperties)
VULKAN_FN(vkEnumeratePhysicalDevices)
VULKAN_FN(vkGetDeviceProcAddr)
VULKAN_FN(vkGetPhysicalDeviceFeatures)
VULKAN_FN(vkGetPhysicalDeviceFormatProperties)
// VULKAN_FN(vkGetPhysicalDeviceImageFormatProperties)
VULKAN_FN(vkGetPhysicalDeviceMemoryProperties)
VULKAN_FN(vkGetPhysicalDeviceProperties)
VULKAN_FN(vkGetPhysicalDeviceQueueFamilyProperties)
// VULKAN_FN(vkGetPhysicalDeviceSparseImageFormatProperties)
// v1.1+
VULKAN_FN(vkEnumeratePhysicalDeviceGroups)
VULKAN_FN(vkGetPhysicalDeviceExternalBufferProperties)
VULKAN_FN(vkGetPhysicalDeviceExternalFenceProperties)
VULKAN_FN(vkGetPhysicalDeviceExternalSemaphoreProperties)
VULKAN_FN(vkGetPhysicalDeviceFeatures2)
VULKAN_FN(vkGetPhysicalDeviceFormatProperties2)
// VULKAN_FN(vkGetPhysicalDeviceImageFormatProperties2)
VULKAN_FN(vkGetPhysicalDeviceMemoryProperties2)
VULKAN_FN(vkGetPhysicalDeviceProperties2)
VULKAN_FN(vkGetPhysicalDeviceQueueFamilyProperties2)
// VULKAN_FN(vkGetPhysicalDeviceSparseImageFormatProperties2)
// v1.3+
VULKAN_FN(vkGetPhysicalDeviceToolProperties)
#endif
#ifdef HL_USE_VULKAN_DEVICE_FNS
// v1.0+
VULKAN_FN(vkAllocateCommandBuffers)
VULKAN_FN(vkAllocateDescriptorSets)
VULKAN_FN(vkAllocateMemory)
VULKAN_FN(vkBeginCommandBuffer)
VULKAN_FN(vkBindBufferMemory)
// VULKAN_FN(vkBindImageMemory)
VULKAN_FN(vkCmdBeginQuery)
// VULKAN_FN(vkCmdBeginRenderPass)
VULKAN_FN(vkCmdBindDescriptorSets)
// VULKAN_FN(vkCmdBindIndexBuffer)
VULKAN_FN(vkCmdBindPipeline)
// VULKAN_FN(vkCmdBindVertexBuffers)
// VULKAN_FN(vkCmdBlitImage)
// VULKAN_FN(vkCmdClearAttachments)
// VULKAN_FN(vkCmdClearColorImage)
// VULKAN_FN(vkCmdClearDepthStencilImage)
VULKAN_FN(vkCmdCopyBuffer)
// VULKAN_FN(vkCmdCopyBufferToImage)
// VULKAN_FN(vkCmdCopyImage)
// VULKAN_FN(vkCmdCopyImageToBuffer)
VULKAN_FN(vkCmdCopyQueryPoolResults)
VULKAN_FN(vkCmdDispatch)
VULKAN_FN(vkCmdDispatchIndirect)
// VULKAN_FN(vkCmdDraw)
// VULKAN_FN(vkCmdDrawIndexed)
// VULKAN_FN(vkCmdDrawIndexedIndirect)
// VULKAN_FN(vkCmdDrawIndirect)
VULKAN_FN(vkCmdEndQuery)
// VULKAN_FN(vkCmdEndRenderPass)
VULKAN_FN(vkCmdExecuteCommands)
VULKAN_FN(vkCmdFillBuffer)
// VULKAN_FN(vkCmdNextSubpass)
VULKAN_FN(vkCmdPipelineBarrier)
VULKAN_FN(vkCmdPushConstants)
VULKAN_FN(vkCmdResetEvent)
VULKAN_FN(vkCmdResetQueryPool)
// VULKAN_FN(vkCmdResolveImage)
VULKAN_FN(vkCmdSetBlendConstants)
VULKAN_FN(vkCmdSetDepthBias)
VULKAN_FN(vkCmdSetDepthBounds)
VULKAN_FN(vkCmdSetEvent)
// VULKAN_FN(vkCmdSetLineWidth)
// VULKAN_FN(vkCmdSetScissor)
// VULKAN_FN(vkCmdSetStencilCompareMask)
// VULKAN_FN(vkCmdSetStencilReference)
// VULKAN_FN(vkCmdSetStencilWriteMask)
// VULKAN_FN(vkCmdSetViewport)
VULKAN_FN(vkCmdUpdateBuffer)
VULKAN_FN(vkCmdWaitEvents)
VULKAN_FN(vkCmdWriteTimestamp)
VULKAN_FN(vkCreateBuffer)
VULKAN_FN(vkCreateBufferView)
VULKAN_FN(vkCreateCommandPool)
VULKAN_FN(vkCreateComputePipelines)
VULKAN_FN(vkCreateDescriptorPool)
VULKAN_FN(vkCreateDescriptorSetLayout)
VULKAN_FN(vkCreateEvent)
VULKAN_FN(vkCreateFence)
// VULKAN_FN(vkCreateFramebuffer)
// VULKAN_FN(vkCreateGraphicsPipelines)
// VULKAN_FN(vkCreateImage)
// VULKAN_FN(vkCreateImageView)
VULKAN_FN(vkCreatePipelineCache)
VULKAN_FN(vkCreatePipelineLayout)
VULKAN_FN(vkCreateQueryPool)
// VULKAN_FN(vkCreateRenderPass)
// VULKAN_FN(vkCreateSampler)
VULKAN_FN(vkCreateSemaphore)
VULKAN_FN(vkCreateShaderModule)
VULKAN_FN(vkDestroyBuffer)
VULKAN_FN(vkDestroyBufferView)
VULKAN_FN(vkDestroyCommandPool)
VULKAN_FN(vkDestroyDescriptorPool)
VULKAN_FN(vkDestroyDescriptorSetLayout)
VULKAN_FN(vkDestroyDevice)
VULKAN_FN(vkDestroyEvent)
VULKAN_FN(vkDestroyFence)
// VULKAN_FN(vkDestroyFramebuffer)
// VULKAN_FN(vkDestroyImage)
// VULKAN_FN(vkDestroyImageView)
VULKAN_FN(vkDestroyPipeline)
VULKAN_FN(vkDestroyPipelineCache)
VULKAN_FN(vkDestroyPipelineLayout)
VULKAN_FN(vkDestroyQueryPool)
// VULKAN_FN(vkDestroyRenderPass)
// VULKAN_FN(vkDestroySampler)
VULKAN_FN(vkDestroySemaphore)
VULKAN_FN(vkDestroyShaderModule)
VULKAN_FN(vkDeviceWaitIdle)
VULKAN_FN(vkEndCommandBuffer)
VULKAN_FN(vkFlushMappedMemoryRanges)
VULKAN_FN(vkFreeCommandBuffers)
VULKAN_FN(vkFreeDescriptorSets)
VULKAN_FN(vkFreeMemory)
VULKAN_FN(vkGetBufferMemoryRequirements)
VULKAN_FN(vkGetDeviceMemoryCommitment)
VULKAN_FN(vkGetDeviceQueue)
VULKAN_FN(vkGetEventStatus)
VULKAN_FN(vkGetFenceStatus)
// VULKAN_FN(vkGetImageMemoryRequirements)
// VULKAN_FN(vkGetImageSparseMemoryRequirements)
// VULKAN_FN(vkGetImageSubresourceLayout)
VULKAN_FN(vkGetPipelineCacheData)
VULKAN_FN(vkGetQueryPoolResults)
// VULKAN_FN(vkGetRenderAreaGranularity)
VULKAN_FN(vkInvalidateMappedMemoryRanges)
VULKAN_FN(vkMapMemory)
VULKAN_FN(vkMergePipelineCaches)
// VULKAN_FN(vkQueueBindSparse)
VULKAN_FN(vkQueueSubmit)
VULKAN_FN(vkQueueWaitIdle)
VULKAN_FN(vkResetCommandBuffer)
VULKAN_FN(vkResetCommandPool)
VULKAN_FN(vkResetDescriptorPool)
VULKAN_FN(vkResetEvent)
VULKAN_FN(vkResetFences)
VULKAN_FN(vkSetEvent)
VULKAN_FN(vkUnmapMemory)
VULKAN_FN(vkUpdateDescriptorSets)
VULKAN_FN(vkWaitForFences)
// v1.1+
VULKAN_FN(vkBindBufferMemory2)
// VULKAN_FN(vkBindImageMemory2)
VULKAN_FN(vkCmdDispatchBase)
VULKAN_FN(vkCmdSetDeviceMask)
VULKAN_FN(vkCreateDescriptorUpdateTemplate)
// VULKAN_FN(vkCreateSamplerYcbcrConversion)
VULKAN_FN(vkDestroyDescriptorUpdateTemplate)
// VULKAN_FN(vkDestroySamplerYcbcrConversion)
VULKAN_FN(vkGetBufferMemoryRequirements2)
VULKAN_FN(vkGetDescriptorSetLayoutSupport)
VULKAN_FN(vkGetDeviceGroupPeerMemoryFeatures)
VULKAN_FN(vkGetDeviceQueue2)
// VULKAN_FN(vkGetImageMemoryRequirements2)
// VULKAN_FN(vkGetImageSparseMemoryRequirements2)
VULKAN_FN(vkTrimCommandPool)
VULKAN_FN(vkUpdateDescriptorSetWithTemplate)
// v1.2+
// VULKAN_FN(vkCmdBeginRenderPass2)
// VULKAN_FN(vkCmdDrawIndexedIndirectCount)
// VULKAN_FN(vkCmdDrawIndirectCount)
// VULKAN_FN(vkCmdEndRenderPass2)
// VULKAN_FN(vkCmdNextSubpass2)
// VULKAN_FN(vkCreateRenderPass2)
VULKAN_FN(vkGetBufferDeviceAddress)
VULKAN_FN(vkGetBufferOpaqueCaptureAddress)
VULKAN_FN(vkGetDeviceMemoryOpaqueCaptureAddress)
VULKAN_FN(vkGetSemaphoreCounterValue)
VULKAN_FN(vkResetQueryPool)
VULKAN_FN(vkSignalSemaphore)
VULKAN_FN(vkWaitSemaphores)
// v1.3+
// VULKAN_FN(vkCmdBeginRendering)
// VULKAN_FN(vkCmdBindVertexBuffers2)
// VULKAN_FN(vkCmdBlitImage2)
VULKAN_FN(vkCmdCopyBuffer2)
// VULKAN_FN(vkCmdCopyBufferToImage2)
// VULKAN_FN(vkCmdCopyImage2)
// VULKAN_FN(vkCmdCopyImageToBuffer2)
// VULKAN_FN(vkCmdEndRendering)
VULKAN_FN(vkCmdPipelineBarrier2)
VULKAN_FN(vkCmdResetEvent2)
// VULKAN_FN(vkCmdResolveImage2)
// VULKAN_FN(vkCmdSetCullMode)
// VULKAN_FN(vkCmdSetDepthBiasEnable)
// VULKAN_FN(vkCmdSetDepthBoundsTestEnable)
// VULKAN_FN(vkCmdSetDepthCompareOp)
// VULKAN_FN(vkCmdSetDepthTestEnable)
// VULKAN_FN(vkCmdSetDepthWriteEnable)
VULKAN_FN(vkCmdSetEvent2)
// VULKAN_FN(vkCmdSetFrontFace)
// VULKAN_FN(vkCmdSetPrimitiveRestartEnable)
// VULKAN_FN(vkCmdSetPrimitiveTopology)
// VULKAN_FN(vkCmdSetRasterizerDiscardEnable)
// VULKAN_FN(vkCmdSetScissorWithCount)
// VULKAN_FN(vkCmdSetStencilOp)
// VULKAN_FN(vkCmdSetStencilTestEnable)
// VULKAN_FN(vkCmdSetViewportWithCount)
VULKAN_FN(vkCmdWaitEvents2)
VULKAN_FN(vkCmdWriteTimestamp2)
VULKAN_FN(vkCreatePrivateDataSlot)
VULKAN_FN(vkDestroyPrivateDataSlot)
VULKAN_FN(vkGetDeviceBufferMemoryRequirements)
// VULKAN_FN(vkGetDeviceImageMemoryRequirements)
// VULKAN_FN(vkGetDeviceImageSparseMemoryRequirements)
VULKAN_FN(vkGetPrivateData)
VULKAN_FN(vkQueueSubmit2)
VULKAN_FN(vkSetPrivateData)
#endif