// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/connectors/v1/runtime.proto

package connectors

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the location.
type RuntimeConfig_State int32

const (
	// STATE_UNSPECIFIED.
	RuntimeConfig_STATE_UNSPECIFIED RuntimeConfig_State = 0
	// INACTIVE.
	//
	// Deprecated: Do not use.
	RuntimeConfig_INACTIVE RuntimeConfig_State = 1
	// ACTIVATING.
	//
	// Deprecated: Do not use.
	RuntimeConfig_ACTIVATING RuntimeConfig_State = 2
	// ACTIVE.
	RuntimeConfig_ACTIVE RuntimeConfig_State = 3
	// CREATING.
	RuntimeConfig_CREATING RuntimeConfig_State = 4
	// DELETING.
	RuntimeConfig_DELETING RuntimeConfig_State = 5
	// UPDATING.
	RuntimeConfig_UPDATING RuntimeConfig_State = 6
)

// Enum value maps for RuntimeConfig_State.
var (
	RuntimeConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INACTIVE",
		2: "ACTIVATING",
		3: "ACTIVE",
		4: "CREATING",
		5: "DELETING",
		6: "UPDATING",
	}
	RuntimeConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INACTIVE":          1,
		"ACTIVATING":        2,
		"ACTIVE":            3,
		"CREATING":          4,
		"DELETING":          5,
		"UPDATING":          6,
	}
)

func (x RuntimeConfig_State) Enum() *RuntimeConfig_State {
	p := new(RuntimeConfig_State)
	*p = x
	return p
}

func (x RuntimeConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuntimeConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_runtime_proto_enumTypes[0].Descriptor()
}

func (RuntimeConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_runtime_proto_enumTypes[0]
}

func (x RuntimeConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuntimeConfig_State.Descriptor instead.
func (RuntimeConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_runtime_proto_rawDescGZIP(), []int{1, 0}
}

// Request message for Connectors.GetRuntimeConfig.
type GetRuntimeConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the form:
	// `projects/*/locations/*/runtimeConfig`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRuntimeConfigRequest) Reset() {
	*x = GetRuntimeConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_runtime_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRuntimeConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRuntimeConfigRequest) ProtoMessage() {}

func (x *GetRuntimeConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_runtime_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRuntimeConfigRequest.ProtoReflect.Descriptor instead.
func (*GetRuntimeConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_runtime_proto_rawDescGZIP(), []int{0}
}

func (x *GetRuntimeConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// RuntimeConfig is the singleton resource of each location.
// It includes generic resource configs consumed by control plane and runtime
// plane like: pub/sub topic/subscription resource name, Cloud Storage location
// storing schema etc.
type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. location_id of the runtime location. E.g. "us-west1".
	LocationId string `protobuf:"bytes,1,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Output only. Pub/Sub topic for connd to send message.
	// E.g. projects/{project-id}/topics/{topic-id}
	ConndTopic string `protobuf:"bytes,2,opt,name=connd_topic,json=conndTopic,proto3" json:"connd_topic,omitempty"`
	// Output only. Pub/Sub subscription for connd to receive message.
	// E.g. projects/{project-id}/subscriptions/{topic-id}
	ConndSubscription string `protobuf:"bytes,3,opt,name=connd_subscription,json=conndSubscription,proto3" json:"connd_subscription,omitempty"`
	// Output only. Pub/Sub topic for control plne to send message.
	// communication.
	// E.g. projects/{project-id}/topics/{topic-id}
	ControlPlaneTopic string `protobuf:"bytes,4,opt,name=control_plane_topic,json=controlPlaneTopic,proto3" json:"control_plane_topic,omitempty"`
	// Output only. Pub/Sub subscription for control plane to receive message.
	// E.g. projects/{project-id}/subscriptions/{topic-id}
	ControlPlaneSubscription string `protobuf:"bytes,5,opt,name=control_plane_subscription,json=controlPlaneSubscription,proto3" json:"control_plane_subscription,omitempty"`
	// Output only. The endpoint of the connectors runtime ingress.
	RuntimeEndpoint string `protobuf:"bytes,6,opt,name=runtime_endpoint,json=runtimeEndpoint,proto3" json:"runtime_endpoint,omitempty"`
	// Output only. The state of the location.
	State RuntimeConfig_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.connectors.v1.RuntimeConfig_State" json:"state,omitempty"`
	// Output only. The Cloud Storage bucket that stores connector's schema reports.
	SchemaGcsBucket string `protobuf:"bytes,8,opt,name=schema_gcs_bucket,json=schemaGcsBucket,proto3" json:"schema_gcs_bucket,omitempty"`
	// Output only. The name of the Service Directory service name.
	ServiceDirectory string `protobuf:"bytes,9,opt,name=service_directory,json=serviceDirectory,proto3" json:"service_directory,omitempty"`
	// Output only. Name of the runtimeConfig resource.
	// Format: projects/{project}/locations/{location}/runtimeConfig
	Name string `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_runtime_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_runtime_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_runtime_proto_rawDescGZIP(), []int{1}
}

func (x *RuntimeConfig) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

func (x *RuntimeConfig) GetConndTopic() string {
	if x != nil {
		return x.ConndTopic
	}
	return ""
}

func (x *RuntimeConfig) GetConndSubscription() string {
	if x != nil {
		return x.ConndSubscription
	}
	return ""
}

func (x *RuntimeConfig) GetControlPlaneTopic() string {
	if x != nil {
		return x.ControlPlaneTopic
	}
	return ""
}

func (x *RuntimeConfig) GetControlPlaneSubscription() string {
	if x != nil {
		return x.ControlPlaneSubscription
	}
	return ""
}

func (x *RuntimeConfig) GetRuntimeEndpoint() string {
	if x != nil {
		return x.RuntimeEndpoint
	}
	return ""
}

func (x *RuntimeConfig) GetState() RuntimeConfig_State {
	if x != nil {
		return x.State
	}
	return RuntimeConfig_STATE_UNSPECIFIED
}

func (x *RuntimeConfig) GetSchemaGcsBucket() string {
	if x != nil {
		return x.SchemaGcsBucket
	}
	return ""
}

func (x *RuntimeConfig) GetServiceDirectory() string {
	if x != nil {
		return x.ServiceDirectory
	}
	return ""
}

func (x *RuntimeConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_connectors_v1_runtime_proto protoreflect.FileDescriptor

var file_google_cloud_connectors_v1_runtime_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x5e, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe0, 0x05, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x6e, 0x64, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x64, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x12, 0x32, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x64, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x64, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50,
	0x6c, 0x61, 0x6e, 0x65, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x41, 0x0a, 0x1a, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x47, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x12, 0x0a, 0x0a, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06,
	0x3a, 0x63, 0xea, 0x41, 0x60, 0x0a, 0x27, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x35,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x76, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_connectors_v1_runtime_proto_rawDescOnce sync.Once
	file_google_cloud_connectors_v1_runtime_proto_rawDescData = file_google_cloud_connectors_v1_runtime_proto_rawDesc
)

func file_google_cloud_connectors_v1_runtime_proto_rawDescGZIP() []byte {
	file_google_cloud_connectors_v1_runtime_proto_rawDescOnce.Do(func() {
		file_google_cloud_connectors_v1_runtime_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_connectors_v1_runtime_proto_rawDescData)
	})
	return file_google_cloud_connectors_v1_runtime_proto_rawDescData
}

var file_google_cloud_connectors_v1_runtime_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_connectors_v1_runtime_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_connectors_v1_runtime_proto_goTypes = []interface{}{
	(RuntimeConfig_State)(0),        // 0: google.cloud.connectors.v1.RuntimeConfig.State
	(*GetRuntimeConfigRequest)(nil), // 1: google.cloud.connectors.v1.GetRuntimeConfigRequest
	(*RuntimeConfig)(nil),           // 2: google.cloud.connectors.v1.RuntimeConfig
}
var file_google_cloud_connectors_v1_runtime_proto_depIdxs = []int32{
	0, // 0: google.cloud.connectors.v1.RuntimeConfig.state:type_name -> google.cloud.connectors.v1.RuntimeConfig.State
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_connectors_v1_runtime_proto_init() }
func file_google_cloud_connectors_v1_runtime_proto_init() {
	if File_google_cloud_connectors_v1_runtime_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_connectors_v1_runtime_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRuntimeConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_runtime_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_connectors_v1_runtime_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_connectors_v1_runtime_proto_goTypes,
		DependencyIndexes: file_google_cloud_connectors_v1_runtime_proto_depIdxs,
		EnumInfos:         file_google_cloud_connectors_v1_runtime_proto_enumTypes,
		MessageInfos:      file_google_cloud_connectors_v1_runtime_proto_msgTypes,
	}.Build()
	File_google_cloud_connectors_v1_runtime_proto = out.File
	file_google_cloud_connectors_v1_runtime_proto_rawDesc = nil
	file_google_cloud_connectors_v1_runtime_proto_goTypes = nil
	file_google_cloud_connectors_v1_runtime_proto_depIdxs = nil
}
