//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
	"regexp"
)

// CheckNameAvailabilityWithoutLocationServer is a fake server for instances of the armmysqlflexibleservers.CheckNameAvailabilityWithoutLocationClient type.
type CheckNameAvailabilityWithoutLocationServer struct {
	// Execute is the fake for method CheckNameAvailabilityWithoutLocationClient.Execute
	// HTTP status codes to indicate success: http.StatusOK
	Execute func(ctx context.Context, nameAvailabilityRequest armmysqlflexibleservers.NameAvailabilityRequest, options *armmysqlflexibleservers.CheckNameAvailabilityWithoutLocationClientExecuteOptions) (resp azfake.Responder[armmysqlflexibleservers.CheckNameAvailabilityWithoutLocationClientExecuteResponse], errResp azfake.ErrorResponder)
}

// NewCheckNameAvailabilityWithoutLocationServerTransport creates a new instance of CheckNameAvailabilityWithoutLocationServerTransport with the provided implementation.
// The returned CheckNameAvailabilityWithoutLocationServerTransport instance is connected to an instance of armmysqlflexibleservers.CheckNameAvailabilityWithoutLocationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCheckNameAvailabilityWithoutLocationServerTransport(srv *CheckNameAvailabilityWithoutLocationServer) *CheckNameAvailabilityWithoutLocationServerTransport {
	return &CheckNameAvailabilityWithoutLocationServerTransport{srv: srv}
}

// CheckNameAvailabilityWithoutLocationServerTransport connects instances of armmysqlflexibleservers.CheckNameAvailabilityWithoutLocationClient to instances of CheckNameAvailabilityWithoutLocationServer.
// Don't use this type directly, use NewCheckNameAvailabilityWithoutLocationServerTransport instead.
type CheckNameAvailabilityWithoutLocationServerTransport struct {
	srv *CheckNameAvailabilityWithoutLocationServer
}

// Do implements the policy.Transporter interface for CheckNameAvailabilityWithoutLocationServerTransport.
func (c *CheckNameAvailabilityWithoutLocationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CheckNameAvailabilityWithoutLocationClient.Execute":
		resp, err = c.dispatchExecute(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CheckNameAvailabilityWithoutLocationServerTransport) dispatchExecute(req *http.Request) (*http.Response, error) {
	if c.srv.Execute == nil {
		return nil, &nonRetriableError{errors.New("fake for method Execute not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmysqlflexibleservers.NameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Execute(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NameAvailability, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
