# bash completion for DSDA-Doom                            -*- shell-script -*-

_dsda_doom()
{
    local cur prev words cword
    _init_completion || return

    # Save the previous switch on the command line in the prevsw variable
    local i prevsw=""
    for (( i=1; $cword > 1 && i <= $cword; i++ )); do
        if [[ ${words[i]} == -* ]]; then
            prevsw=${words[i]}
        fi
    done

    # Allow adding more than one file with the same extension to the same switch
    case $prevsw in
        -iwad|-file)
            _filedir wad
            ;;
        -deh)
            _filedir '@(bex|deh)'
            ;;
        -record*|-*demo)
            _filedir lmp
            ;;
    esac

    if [[ $cur == -* ]]; then
        COMPREPLY=( $( compgen -W '-altdeath -aspect -auto
        -bexout -blockmap -complevel -config -deathmatch
        -deh -devparm -fast -fastdemo -file -fullscreen -geom -height
        -iwad -levelstat -noaccel -nocheats -nodraw -nodrawers
        -nofullscreen -nojoy -nomonsters -nomouse -nomusic -nosfx -nosound
        -nowindow -playdemo -record -recordfromto -resetgamma -respawn
        -save -shorttics -shotdir -skill -skipsec -solo-net -spechit -timedemo
        -timer -viddump -vidmode -warp -width -window' \
        -- "$cur" ) )
    else
        # DoLooseFiles() takes any file names on the command line before the
        # first switch parm and inserts the appropriate -file, -deh or -playdemo
        # switch in front of them.
        if [[ -z "$prevsw" ]]; then
            _filedir '@(bex|deh|lmp|wad)'
        fi
    fi
} &&

complete -F _dsda_doom dsda-doom

# ex: ts=4 sw=4 et filetype=sh
