#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# World of Goo 2
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250610.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='world-of-goo-2'
GAME_NAME='World of Goo 2'

ARCHIVE_BASE_3_NAME='World_of_Goo_2-x86_64-1.0.13211.7.AppImage'
ARCHIVE_BASE_3_MD5='80e2b52c2ef8c5045a6b5cec26d50f91'
ARCHIVE_BASE_3_SIZE='920432'
ARCHIVE_BASE_3_VERSION='1.0.13211-2dboy'
ARCHIVE_BASE_3_URL='https://worldofgoo2.com/#getitnow'

ARCHIVE_BASE_2_NAME='World_of_Goo_2-x86_64-1.0.4.13120.27.AppImage'
ARCHIVE_BASE_2_MD5='3c36dbdb0d0fa34ee795ed7c0098cddf'
ARCHIVE_BASE_2_SIZE='909392'
ARCHIVE_BASE_2_VERSION='1.0.4.13120-2dboy'

ARCHIVE_BASE_1_NAME='World_of_Goo_2-x86_64-1.0.12478.15.AppImage'
ARCHIVE_BASE_1_MD5='3748d37805bd4bc96f1b19d108d10f9d'
ARCHIVE_BASE_1_SIZE='903954'
ARCHIVE_BASE_1_VERSION='1.0.12478-2dboy'

ARCHIVE_BASE_0_NAME='World_of_Goo_2-x86_64.12329.171.AppImage'
ARCHIVE_BASE_0_MD5='011faf15abea1c51837e6e2683c80042'
ARCHIVE_BASE_0_SIZE='896550'
ARCHIVE_BASE_0_VERSION='1.0.12329-2dboy'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
WorldOfGoo2'
CONTENT_GAME_DATA_FILES='
game
WorldOfGoo2.png'

APP_MAIN_EXE='WorldOfGoo2'
APP_MAIN_ICON='WorldOfGoo2.png'
## Trying to run the game with the wayland SDL backend leads to a segmentation fault:
##
## #0  0x00007ffff7e9d1c3 in _XFlush () from /lib/x86_64-linux-gnu/libX11.so.6
## #1  0x00007ffff7e9fec5 in _XGetRequest () from /lib/x86_64-linux-gnu/libX11.so.6
## #2  0x00007ffff7e92905 in XQueryExtension () from /lib/x86_64-linux-gnu/libX11.so.6
## #3  0x00007ffff7726e20 in InitDisplayInfoEntry (dpy=0x5555572b50e0) at ../src/GLX/libglxmapping.c:639
## #4  __glXLookupDisplay (dpy=dpy@entry=0x5555572b50e0) at ../src/GLX/libglxmapping.c:755
## #5  0x00007ffff77225f7 in glXQueryVersion (dpy=0x5555572b50e0, major=0x7fffd57f9a94, minor=0x7fffd57f9a98) at ../src/GLX/libglx.c:1166
## #6  0x000055555597ff04 in ?? ()
## #7  0x000055555594a4f9 in ?? ()
## #8  0x0000555555940834 in ?? ()
## #9  0x000055555591f331 in ?? ()
## #10 0x000055555592cad5 in ?? ()
## #11 0x000055555592cb63 in ?? ()
## #12 0x00005555559363a2 in ?? ()
## #13 0x000055555596287f in ?? ()
## #14 0x00007ffff789cb7b in start_thread (arg=<optimized out>) at ./nptl/pthread_create.c:448
## #15 0x00007ffff791a7b8 in __GI___clone3 () at ../sysdeps/unix/sysv/linux/x86_64/clone3.S:78
##
## Forcing the use of system-provided SDL does not avoid this crash.
APP_MAIN_PRERUN='
# Prevent a crash on launch when the wayland backend of SDL is used
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'
## The game will segfault when loading the world selector if started through a symlinks farm
APP_MAIN_PREFIX_TYPE='none'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
libstdc++.so.6
libX11.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Force the use of system-provided SDL
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
PKG_BIN_DEPENDENCIES_LIBRARIES="$(dependencies_list_native_libraries 'PKG_BIN')
libSDL2-2.0.so.0"

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
