/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkDisplacementFieldJacobianDeterminantFilter_h
#define sitkDisplacementFieldJacobianDeterminantFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class DisplacementFieldJacobianDeterminantFilter
\brief Computes a scalar image from a vector image (e.g., deformation field) input, where each output scalar at each pixel is the Jacobian determinant of the vector field at that location. This calculation is correct in the case where the vector image is a "displacement" from the current location. The computation for the jacobian determinant is: det[ dT/dx ] = det[ I + du/dx ].

\par Overview
This filter is based on itkVectorGradientMagnitudeImageFilter and supports the m_DerivativeWeights weights for partial derivatives.


Note that the determinant of a zero vector field is also zero, whereas the Jacobian determinant of the corresponding identity warp transformation is 1.0. In order to compute the effective deformation Jacobian determinant 1.0 must be added to the diagonal elements of Jacobian prior to taking the derivative. i.e. det([ (1.0+dx/dx) dx/dy dx/dz ; dy/dx (1.0+dy/dy) dy/dz; dz/dx dz/dy (1.0+dz/dz) ])

\par Template Parameters (Input and Output)
This filter has one required template parameter which defines the input image type. The pixel type of the input image is assumed to be a vector (e.g., itk::Vector , itk::RGBPixel , itk::FixedArray ). The scalar type of the vector components must be castable to floating point. Instantiating with an image of RGBPixel<unsigned short>, for example, is allowed, but the filter will convert it to an image of Vector<float,3> for processing.


The second template parameter, TRealType, can be optionally specified to define the scalar numerical type used in calculations. This is the component type of the output image, which will be of itk::Vector<TRealType, N>, where N is the number of channels in the multiple component input image. The default type of TRealType is float. For extra precision, you may safely change this parameter to double.

The third template parameter is the output image type. The third parameter will be automatically constructed from the first and second parameters, so it is not necessary (or advisable) to set this parameter explicitly. Given an M-channel input image with dimensionality N, and a numerical type specified as TRealType, the output image will be of type itk::Image<TRealType, N>.

\par Filter Parameters
The method UseImageSpacingOn will cause derivatives in the image to be scaled (inversely) with the pixel size of the input image, effectively taking derivatives in world coordinates (versus isotropic image space). UseImageSpacingOff turns this functionality off. Default is UseImageSpacingOn. The parameter UseImageSpacing can be set directly with the method SetUseImageSpacing(bool) .


Weights can be applied to the derivatives directly using the SetDerivativeWeights method. Note that if UseImageSpacing is set to TRUE (ON), then these weights will be overridden by weights derived from the image spacing when the filter is updated. The argument to this method is a C array of TRealValue type.

\par Constraints
We use vnl_det for determinant computation, which only supports square matrices. So the vector dimension of the input image values must be equal to the image dimensions, which is trivially true for a deformation field that maps an n-dimensional space onto itself.


Currently, dimensions up to and including 4 are supported. This limitation comes from the presence of vnl_det() functions for matrices of dimension up to 4x4.

The template parameter TRealType must be floating point (float or double) or a user-defined "real" numerical type with arithmetic operations defined sufficient to compute derivatives.

\see Image 


\see Neighborhood 


\see NeighborhoodOperator 


\see NeighborhoodIterator 


\note This class was adapted by 


\author Hans J. Johnson, The University of Iowa from code provided by 


\author Tom Vercauteren, INRIA & Mauna Kea Technologies 


\author Torsten Rohlfing, Neuroscience Program, SRI International.
\sa itk::simple::DisplacementFieldJacobianDeterminantFilter for the procedural interface
\sa itk::DisplacementFieldJacobianDeterminantFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT DisplacementFieldJacobianDeterminantFilter : public ImageFilter {
    public:
      using Self = DisplacementFieldJacobianDeterminantFilter;

      /** Destructor */
      virtual ~DisplacementFieldJacobianDeterminantFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      DisplacementFieldJacobianDeterminantFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = RealVectorPixelIDTypeList;
\

      /**
       * Set/Get whether or not the filter will use the spacing of the input image (1/spacing) in the calculation of the Jacobian determinant. Use On to compute the Jacobian determinant in the space in which the data was acquired; use Off to reset the derivative weights, ignore the image spacing, and to compute the Jacobian determinant in the image space. Default is On.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Set/Get whether or not the filter will use the spacing of the input image (1/spacing) in the calculation of the Jacobian determinant. Use On to compute the Jacobian determinant in the space in which the data was acquired; use Off to reset the derivative weights, ignore the image spacing, and to compute the Jacobian determinant in the image space. Default is On.
       */
      bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }\

      /**
       * Directly Set/Get the array of weights used in the gradient calculations. Note that calling UseImageSpacingOn will clobber these values.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDerivativeWeights ( std::vector<double> DerivativeWeights ) { this->m_DerivativeWeights = std::move(DerivativeWeights); return *this; }

      /**
       * Directly Set/Get the array of weights used in the gradient calculations. Note that calling UseImageSpacingOn will clobber these values.
       */
      std::vector<double> GetDerivativeWeights() const { return this->m_DerivativeWeights; }

      /** Name of this class */
      std::string GetName() const { return std::string ("DisplacementFieldJacobianDeterminantFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_UseImageSpacing{true};

      std::vector<double>  m_DerivativeWeights{std::vector<double>()};



    };

    /**\
     * \brief Computes a scalar image from a vector image (e.g., deformation field) input, where each output scalar at each pixel is the Jacobian determinant of the vector field at that location. This calculation is correct in the case where the vector image is a "displacement" from the current location. The computation for the jacobian determinant is: det[ dT/dx ] = det[ I + du/dx ].
     *
     * This function directly calls the execute method of DisplacementFieldJacobianDeterminantFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::DisplacementFieldJacobianDeterminantFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image DisplacementFieldJacobianDeterminant ( const Image& image1, bool useImageSpacing = true, std::vector<double> derivativeWeights = std::vector<double>() );

     /** @} */
}
#endif
