/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyLanguageFacadeKt;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.PyControlFlow;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImplicitImportNameDefiner;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class PyDefUseUtil {
    private static final int MAX_CONTROL_FLOW_SIZE = 200;

    private PyDefUseUtil() {
    }

    @NotNull
    public static List<Instruction> getLatestDefs(@NotNull ScopeOwner block, @NotNull String varName, @NotNull PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports, @NotNull TypeEvalContext context) {
        if (block == null) {
            PyDefUseUtil.$$$reportNull$$$0(0);
        }
        if (varName == null) {
            PyDefUseUtil.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            PyDefUseUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyDefUseUtil.$$$reportNull$$$0(3);
        }
        return PyDefUseUtil.getLatestDefs(ControlFlowCache.getControlFlow(block), varName, anchor, acceptTypeAssertions, acceptImplicitImports, context);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static List<Instruction> getLatestDefs(@NotNull PyControlFlow controlFlow, @NotNull String varName, @NotNull PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports, @NotNull TypeEvalContext context) {
        if (controlFlow == null) {
            PyDefUseUtil.$$$reportNull$$$0(4);
        }
        if (varName == null) {
            PyDefUseUtil.$$$reportNull$$$0(5);
        }
        if (anchor == null) {
            PyDefUseUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyDefUseUtil.$$$reportNull$$$0(7);
        }
        Instruction[] instructions = controlFlow.getInstructions();
        int startNum = PyDefUseUtil.findStartInstructionId(anchor, controlFlow);
        if (startNum < 0) {
            List<Instruction> list = Collections.emptyList();
            if (list == null) {
                PyDefUseUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        QualifiedName varQname = QualifiedName.fromDottedString((String)varName);
        LanguageLevel languageLevel = PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)anchor.getContainingFile());
        LinkedHashSet result = new LinkedHashSet();
        HashMap pendingTypeGuard = new HashMap();
        @NotNull Ref foundPrefixWrite = Ref.create((Object)false);
        PyDefUseUtil.iteratePrev(startNum, controlFlow, instruction -> {
            PyImplicitImportNameDefiner implicit;
            ConditionalInstruction conditionalInstruction;
            PsiElement patt0$temp;
            TypeEvalContext newContext;
            PyWithContextExitInstruction withExit;
            if (instruction instanceof PyWithContextExitInstruction && !(withExit = (PyWithContextExitInstruction)((Object)instruction)).isSuppressingExceptions(context)) {
                return ControlFlowUtil.Operation.CONTINUE;
            }
            if (acceptTypeAssertions && instruction instanceof CallInstruction) {
                CallInstruction callInstruction = (CallInstruction)((Object)instruction);
                ConditionalInstruction typeGuardInstruction = (ConditionalInstruction)pendingTypeGuard.get(instruction.getElement());
                if (typeGuardInstruction != null) {
                    result.add(typeGuardInstruction);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                if (instruction.num() < startNum && context.getOrigin() == callInstruction.getElement().getContainingFile()) {
                    TypeEvalContext typeEvalContext = newContext = 200 > instructions.length ? TypeEvalContext.codeAnalysis((Project)context.getOrigin().getProject(), (PsiFile)context.getOrigin()) : TypeEvalContext.codeInsightFallback((Project)context.getOrigin().getProject());
                    if (callInstruction.isNoReturnCall(newContext)) {
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
            }
            if (instruction.num() < startNum && acceptTypeAssertions && instruction instanceof ConditionalInstruction && (patt0$temp = (conditionalInstruction = (ConditionalInstruction)instruction).getCondition()) instanceof PyTypedElement) {
                String narrowedQname;
                PyNarrowedType narrowedType;
                PyType patt1$temp;
                PyTypedElement typedElement = (PyTypedElement)patt0$temp;
                if (context.getOrigin() == typedElement.getContainingFile() && (patt1$temp = (newContext = 200 > instructions.length ? TypeEvalContext.codeAnalysis((Project)context.getOrigin().getProject(), (PsiFile)context.getOrigin()) : TypeEvalContext.codeInsightFallback((Project)context.getOrigin().getProject())).getType(typedElement)) instanceof PyNarrowedType && (narrowedType = (PyNarrowedType)patt1$temp).isBound() && (narrowedQname = narrowedType.getQname()) != null) {
                    if (PyDefUseUtil.isQualifiedBy(varQname, narrowedQname)) {
                        foundPrefixWrite.set((Object)true);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                    if (narrowedQname.equals(varName)) {
                        pendingTypeGuard.put(narrowedType.getOriginal(), conditionalInstruction);
                    }
                }
            }
            if (instruction instanceof ReadWriteInstruction) {
                ReadWriteInstruction rwInstruction = (ReadWriteInstruction)((Object)instruction);
                ReadWriteInstruction.ACCESS access = rwInstruction.getAccess();
                if (access.isWriteAccess() || acceptTypeAssertions && access.isAssertTypeAccess() && instruction.num() < startNum) {
                    String name = rwInstruction.getName();
                    if (name != null && PyDefUseUtil.isQualifiedBy(varQname, name) && PyDefUseUtil.isReachableWithVersionChecks((Instruction)rwInstruction, languageLevel)) {
                        foundPrefixWrite.set((Object)true);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                    if (Comparing.strEqual((String)name, (String)varName)) {
                        if (PyDefUseUtil.isReachableWithVersionChecks((Instruction)rwInstruction, languageLevel)) {
                            result.add(rwInstruction);
                        }
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
            } else if (acceptImplicitImports && (patt0$temp = instruction.getElement()) instanceof PyImplicitImportNameDefiner && !(implicit = (PyImplicitImportNameDefiner)patt0$temp).multiResolveName(varName).isEmpty()) {
                if (PyDefUseUtil.isReachableWithVersionChecks(instruction, languageLevel)) {
                    result.add(instruction);
                }
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        });
        if (((Boolean)foundPrefixWrite.get()).booleanValue()) {
            List<Instruction> list = Collections.emptyList();
            if (list == null) {
                PyDefUseUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        return new ArrayList<Instruction>(result);
    }

    private static boolean isQualifiedBy(QualifiedName varQname, @NotNull String qualifier) {
        if (qualifier == null) {
            PyDefUseUtil.$$$reportNull$$$0(10);
        }
        QualifiedName elementQname = QualifiedName.fromDottedString((String)qualifier);
        return varQname.getComponentCount() > elementQname.getComponentCount() && varQname.matchesPrefix(elementQname);
    }

    private static int findStartInstructionId(@NotNull PsiElement startAnchor, @NotNull PyControlFlow flow) {
        Collection pred;
        int instr;
        if (startAnchor == null) {
            PyDefUseUtil.$$$reportNull$$$0(11);
        }
        if (flow == null) {
            PyDefUseUtil.$$$reportNull$$$0(12);
        }
        PsiElement realCfgAnchor = startAnchor;
        PyAugAssignmentStatement augAssignment = PyAugAssignmentStatementNavigator.getStatementByTarget(startAnchor);
        if (augAssignment != null) {
            realCfgAnchor = augAssignment;
        }
        if ((instr = flow.getInstruction(realCfgAnchor)) < 0) {
            return instr;
        }
        if (startAnchor instanceof PyTargetExpression && !(pred = flow.getInstructions()[instr].allPred()).isEmpty()) {
            instr = ((Instruction)pred.iterator().next()).num();
        }
        return instr;
    }

    private static void iteratePrev(int startInstruction, @NotNull PyControlFlow controlFlow, @NotNull Function<? super Instruction, ControlFlowUtil.Operation> closure) {
        if (controlFlow == null) {
            PyDefUseUtil.$$$reportNull$$$0(13);
        }
        if (closure == null) {
            PyDefUseUtil.$$$reportNull$$$0(14);
        }
        Instruction[] instructions = controlFlow.getInstructions();
        IntArrayList stack = new IntArrayList(instructions.length);
        boolean[] visited = new boolean[instructions.length];
        visited[startInstruction] = true;
        stack.push(startInstruction);
        int count = 0;
        while (!stack.isEmpty()) {
            int num;
            Instruction instr;
            ControlFlowUtil.Operation nextOperation;
            if (++count % 512 == 0) {
                ProgressManager.checkCanceled();
            }
            if ((nextOperation = closure.apply((Instruction)(instr = instructions[num = stack.popInt()]))) == ControlFlowUtil.Operation.CONTINUE) continue;
            if (nextOperation == ControlFlowUtil.Operation.BREAK) break;
            assert (nextOperation == ControlFlowUtil.Operation.NEXT);
            Collection<Instruction> nextToProcess = controlFlow.getPrev(instr);
            for (Instruction pred : nextToProcess) {
                int predNum = pred.num();
                if (visited[predNum]) continue;
                visited[predNum] = true;
                stack.push(predNum);
            }
        }
    }

    private static boolean isReachableWithVersionChecks(@NotNull Instruction instruction, @NotNull LanguageLevel languageLevel) {
        PsiElement element;
        if (instruction == null) {
            PyDefUseUtil.$$$reportNull$$$0(15);
        }
        if (languageLevel == null) {
            PyDefUseUtil.$$$reportNull$$$0(16);
        }
        if ((element = instruction.getElement()) == null) {
            return true;
        }
        Version version = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
        return PyVersionSpecificStubBaseKt.evaluateVersionsForElement(element).contains((Comparable)version);
    }

    public static PsiElement @NotNull [] getPostRefs(@NotNull ScopeOwner block, @NotNull PyTargetExpression var, PyExpression anchor) {
        PyControlFlow controlFlow;
        Instruction[] instructions;
        int instr;
        if (block == null) {
            PyDefUseUtil.$$$reportNull$$$0(17);
        }
        if (var == null) {
            PyDefUseUtil.$$$reportNull$$$0(18);
        }
        if ((instr = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = (controlFlow = ControlFlowCache.getControlFlow(block)).getInstructions()), (PsiElement)anchor)) < 0) {
            if (PyElement.EMPTY_ARRAY == null) {
                PyDefUseUtil.$$$reportNull$$$0(19);
            }
            return PyElement.EMPTY_ARRAY;
        }
        boolean[] visited = new boolean[instructions.length];
        HashSet<PyElement> result = new HashSet<PyElement>();
        for (Instruction instruction : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction.num(), visited, result);
        }
        PsiElement[] psiElementArray = (PsiElement[])result.toArray(PyElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PyDefUseUtil.$$$reportNull$$$0(20);
        }
        return psiElementArray;
    }

    private static void getPostRefs(@NotNull PyTargetExpression var, Instruction[] instructions, int instr, boolean @NotNull [] visited, @NotNull Collection<PyElement> result) {
        ReadWriteInstruction instruction;
        if (var == null) {
            PyDefUseUtil.$$$reportNull$$$0(21);
        }
        if (result == null) {
            PyDefUseUtil.$$$reportNull$$$0(22);
        }
        if (visited == null) {
            PyDefUseUtil.$$$reportNull$$$0(23);
        }
        if (visited[instr]) {
            return;
        }
        visited[instr] = true;
        Instruction instruction2 = instructions[instr];
        if (instruction2 instanceof ReadWriteInstruction && Comparing.strEqual((String)(instruction = (ReadWriteInstruction)instruction2).getName(), (String)var.getName())) {
            ReadWriteInstruction.ACCESS access = instruction.getAccess();
            if (access.isWriteAccess()) {
                return;
            }
            result.add((PyElement)instruction.getElement());
        }
        for (Instruction instruction3 : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction3.num(), visited, result);
        }
    }

    public static boolean isDefinedBefore(@NotNull PsiElement searched, @NotNull PsiElement target) {
        Instruction[] instructions;
        int index;
        if (searched == null) {
            PyDefUseUtil.$$$reportNull$$$0(24);
        }
        if (target == null) {
            PyDefUseUtil.$$$reportNull$$$0(25);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(searched);
        Ref definedBefore = Ref.create((Object)false);
        if (scopeOwner != null && scopeOwner == ScopeUtil.getScopeOwner(target) && (index = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = ControlFlowCache.getControlFlow(scopeOwner).getInstructions()), (PsiElement)target)) >= 0) {
            ControlFlowUtil.iteratePrev((int)index, (Instruction[])instructions, instruction -> {
                if (instruction.getElement() == searched) {
                    boolean isWriteAccess;
                    boolean isImport = searched instanceof PyImportedNameDefiner;
                    boolean bl = isWriteAccess = instruction instanceof ReadWriteInstruction && ((ReadWriteInstruction)((Object)instruction)).getAccess().isWriteAccess();
                    if (isImport || isWriteAccess) {
                        definedBefore.set((Object)true);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                }
                return ControlFlowUtil.Operation.NEXT;
            });
        }
        return (Boolean)definedBefore.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyDefUseUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startAnchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searched";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyDefUseUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDefs";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLatestDefs";
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isQualifiedBy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findStartInstructionId";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "iteratePrev";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isReachableWithVersionChecks";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPostRefs";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDefinedBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 19, 20 -> new IllegalStateException(string);
        };
    }

    public static class InstructionNotFoundException
    extends RuntimeException {
    }
}

