/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageInfo {
    private static final int MIN_IMAGE_BYTES = 100;
    public final String format;
    public final int width;
    public final int height;
    public final int size;
    public final byte[] bytes;

    public ImageInfo(@NotNull String format, int width, int height, int size, byte @Nullable [] bytes) {
        if (format == null) {
            ImageInfo.$$$reportNull$$$0(0);
        }
        this.format = format;
        this.width = width;
        this.height = height;
        this.size = size;
        this.bytes = bytes;
    }

    @Nullable
    public BufferedImage createImage() {
        return this.bytes != null ? ImageInfo.readImage(this.bytes) : null;
    }

    @NotNull
    public ImageInfo stripBytes() {
        return new ImageInfo(this.format, this.width, this.height, this.size, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInfo info = (ImageInfo)o;
        if (this.width != info.width) {
            return false;
        }
        if (this.height != info.height) {
            return false;
        }
        if (this.size != info.size) {
            return false;
        }
        if (!this.format.equals(info.format)) {
            return false;
        }
        return Arrays.equals(this.bytes, info.bytes);
    }

    public int hashCode() {
        int result = this.format.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.size;
        result = 31 * result + (this.bytes != null ? Arrays.hashCode(this.bytes) : 0);
        return result;
    }

    @Nullable
    private static BufferedImage readImage(byte @NotNull [] bytes) {
        if (bytes == null) {
            ImageInfo.$$$reportNull$$$0(1);
        }
        return ImageInfo.extractImageData(bytes, new ImageDataExtractor<BufferedImage>(){

            @Override
            public BufferedImage extract(ImageReader reader) throws Exception {
                return reader.read(0, reader.getDefaultReadParam());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T extractImageData(byte @NotNull [] bytes, @NotNull ImageDataExtractor<T> dataExtractor) {
        if (dataExtractor == null) {
            ImageInfo.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            ImageInfo.$$$reportNull$$$0(3);
        }
        if (bytes.length < 100) {
            return null;
        }
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<Object> readers = stream != null ? ImageIO.getImageReaders(stream) : Collections.emptyIterator();
            ImageReader reader = readers.hasNext() ? (ImageReader)readers.next() : null;
            try {
                if (reader == null) return null;
                reader.setInput(stream, true, true);
                T t = dataExtractor.extract(reader);
                return t;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static ImageInfo tryDetectImage(final byte @NotNull [] bytes) {
        if (bytes == null) {
            ImageInfo.$$$reportNull$$$0(4);
        }
        return ImageInfo.extractImageData(bytes, new ImageDataExtractor<ImageInfo>(){

            @Override
            public ImageInfo extract(ImageReader reader) throws Exception {
                String format = reader.getFormatName();
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                return new ImageInfo(format, width, height, bytes.length, bytes);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExtractor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/ImageInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readImage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extractImageData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryDetectImage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class ImageDataExtractor<T> {
        ImageDataExtractor() {
        }

        public abstract T extract(ImageReader var1) throws Exception;
    }
}

