/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/CodeAnalysisCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCodeAnalysisCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeAnalysisCommand.kt\ncom/jetbrains/performancePlugin/commands/CodeAnalysisCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n13#2:128\n*S KotlinDebug\n*F\n+ 1 CodeAnalysisCommand.kt\ncom/jetbrains/performancePlugin/commands/CodeAnalysisCommand\n*L\n24#1:128\n*E\n"})
public final class CodeAnalysisCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%codeAnalysis";
    @NotNull
    private static final Logger LOG;

    public CodeAnalysisCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
        String[] stringArray = new String[]{" "};
        List commandArgs = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String commandType = (String)commandArgs.get(0);
        DumbService.Companion.getInstance(project2).waitForSmartMode();
        MessageBusConnection busConnection = project2.getMessageBus().connect();
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        busConnection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(project2, busConnection, commandType, actionCallback, context, this, commandArgs){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $busConnection;
            final /* synthetic */ String $commandType;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            final /* synthetic */ PlaybackContext $context;
            final /* synthetic */ CodeAnalysisCommand this$0;
            final /* synthetic */ List<String> $commandArgs;
            {
                this.$project = $project;
                this.$busConnection = $busConnection;
                this.$commandType = $commandType;
                this.$actionCallback = $actionCallback;
                this.$context = $context;
                this.this$0 = $receiver;
                this.$commandArgs = $commandArgs;
            }

            /*
             * WARNING - void declaration
             */
            public void daemonFinished() {
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.$project);
                Intrinsics.checkNotNull((Object)daemonCodeAnalyzer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
                DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)daemonCodeAnalyzer;
                Editor editor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                if (!(editor != null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(editor.getDocument());
                if (!(psiFile != null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (myDaemonCodeAnalyzer.isErrorAnalyzingFinished(psiFile)) {
                    this.$busConnection.disconnect();
                    String string = this.$commandType;
                    if (Intrinsics.areEqual((Object)string, (Object)"CHECK_ON_RED_CODE")) {
                        List list = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHighlights(...)");
                        List errorsOnHighlighting = list;
                        if (errorsOnHighlighting.size() > 0) {
                            StringBuilder errorMessages = new StringBuilder("Analysis on red code detected some errors: " + errorsOnHighlighting.size());
                            Iterable $this$forEach$iv = errorsOnHighlighting;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                HighlightInfo it = (HighlightInfo)element$iv;
                                boolean bl = false;
                                errorMessages.append("\n").append(it.getDescription());
                            }
                            ActionCallback actionCallback = this.$actionCallback.reject(errorMessages.toString());
                            Intrinsics.checkNotNull((Object)actionCallback);
                        } else {
                            this.$context.message("Analysis on red code performed successfully", this.this$0.getLine());
                            this.$actionCallback.setDone();
                        }
                    } else if (Intrinsics.areEqual((Object)string, (Object)"WARNINGS_ANALYSIS")) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        List list = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.WARNING, (Project)this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHighlights(...)");
                        Iterable iterable = list;
                        boolean $i$f$map = false;
                        void $this$forEach$iv = $this$map$iv;
                        Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            HighlightInfo bl = (HighlightInfo)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add("[" + it.startOffset + "-" + it.endOffset + "] " + it.getDescription());
                        }
                        List actualWarnings = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                        if (!((Collection)actualWarnings).isEmpty()) {
                            List expectedWarnings;
                            void $this$filterTo$iv$iv;
                            Map $this$filter$iv;
                            Map $this$groupingBy$iv;
                            StringBuilder logMessage = new StringBuilder("Highlighting detected some warnings: " + actualWarnings.size());
                            Iterable $this$forEach$iv2 = actualWarnings;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv2) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                logMessage.append('\n').append(it);
                            }
                            CodeAnalysisCommand.access$getLOG$cp().info(logMessage.toString());
                            $this$forEach$iv2 = actualWarnings;
                            boolean $i$f$groupingBy = false;
                            $this$groupingBy$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>((Iterable)((Object)$this$groupingBy$iv)){
                                final /* synthetic */ Iterable $this_groupingBy;
                                {
                                    this.$this_groupingBy = $receiver;
                                }

                                public Iterator<String> sourceIterator() {
                                    return this.$this_groupingBy.iterator();
                                }

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 * WARNING - void declaration
                                 */
                                public Object keyOf(Object element) {
                                    void var2_2;
                                    String it = (String)element;
                                    boolean bl = false;
                                    return var2_2;
                                }
                            }));
                            boolean $i$f$filter22 = false;
                            destination$iv$iv = $this$filter$iv;
                            Object destination$iv$iv2 = new LinkedHashMap<K, V>();
                            boolean $i$f$filterTo = false;
                            Iterator<Map.Entry<K, V>> bl = $this$filterTo$iv$iv.entrySet().iterator();
                            while (bl.hasNext()) {
                                Map.Entry<K, V> element$iv$iv;
                                Map.Entry<K, V> it = element$iv$iv = bl.next();
                                boolean bl3 = false;
                                if (!(((Number)it.getValue()).intValue() > 1)) continue;
                                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                            }
                            $this$filter$iv = destination$iv$iv2;
                            String[] $i$f$filter22 = this.$actionCallback;
                            boolean $i$f$forEach22 = false;
                            destination$iv$iv2 = $this$forEach$iv2.entrySet().iterator();
                            while (destination$iv$iv2.hasNext()) {
                                Map.Entry element$iv;
                                Map.Entry it = element$iv = (Map.Entry)destination$iv$iv2.next();
                                boolean bl4 = false;
                                $i$f$filter22.reject("Duplicate warning detected " + it.getValue() + " times: " + it.getKey());
                            }
                            if (this.$commandArgs.size() > 1) {
                                $i$f$filter22 = new String[]{","};
                                v3 = StringsKt.split$default((CharSequence)this.$commandArgs.get(1), (String[])$i$f$filter22, (boolean)false, (int)0, (int)6, null);
                            } else {
                                v3 = expectedWarnings = CollectionsKt.emptyList();
                            }
                            if (!((Collection)expectedWarnings).isEmpty()) {
                                void $this$filterNotTo$iv$iv;
                                Iterable $this$filterNot$iv;
                                $i$f$filter22 = expectedWarnings;
                                ActionCallbackProfilerStopper $i$f$forEach22 = this.$actionCallback;
                                boolean $i$f$forEach232 = false;
                                for (T element$iv : $this$forEach$iv3) {
                                    boolean bl5;
                                    String expectedWarning;
                                    block29: {
                                        expectedWarning = (String)element$iv;
                                        boolean bl6 = false;
                                        Iterable $this$any$iv = actualWarnings;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl5 = false;
                                        } else {
                                            for (T element$iv2 : $this$any$iv) {
                                                String actualWarning = (String)element$iv2;
                                                boolean bl7 = false;
                                                if (!StringsKt.contains$default((CharSequence)actualWarning, (CharSequence)expectedWarning, (boolean)false, (int)2, null)) continue;
                                                bl5 = true;
                                                break block29;
                                            }
                                            bl5 = false;
                                        }
                                    }
                                    if (bl5) continue;
                                    $i$f$forEach22.reject("Highlighting did not detect the warning '" + expectedWarning + "'");
                                }
                                Iterable $this$forEach$iv3 = CollectionsKt.distinct((Iterable)actualWarnings);
                                boolean $i$f$filterNot = false;
                                void $i$f$forEach232 = $this$filterNot$iv;
                                Collection destination$iv$iv3 = new ArrayList<E>();
                                boolean $i$f$filterNotTo = false;
                                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                    boolean bl8;
                                    block30: {
                                        String actualWarning = (String)element$iv$iv;
                                        boolean bl9 = false;
                                        Iterable $this$any$iv = expectedWarnings;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl8 = false;
                                        } else {
                                            for (T element$iv : $this$any$iv) {
                                                String expectedWarning = (String)element$iv;
                                                boolean bl10 = false;
                                                if (!StringsKt.contains$default((CharSequence)actualWarning, (CharSequence)expectedWarning, (boolean)false, (int)2, null)) continue;
                                                bl8 = true;
                                                break block30;
                                            }
                                            bl8 = false;
                                        }
                                    }
                                    if (bl8) continue;
                                    destination$iv$iv3.add(element$iv$iv);
                                }
                                $this$filterNot$iv = (List)destination$iv$iv3;
                                ActionCallbackProfilerStopper actionCallbackProfilerStopper = this.$actionCallback;
                                boolean $i$f$forEach3 = false;
                                for (T element$iv : $this$forEach$iv3) {
                                    String actualWarning = (String)element$iv;
                                    boolean bl11 = false;
                                    actionCallbackProfilerStopper.reject("Highlighting detected unexpected warning '" + actualWarning + "'");
                                }
                            }
                            if (!this.$actionCallback.isRejected()) {
                                this.$actionCallback.setDone();
                            }
                        } else {
                            iterable = this.$actionCallback.reject("Highlighting did not detect any warning");
                            Intrinsics.checkNotNull((Object)iterable);
                        }
                    } else {
                        throw new IllegalStateException(("Wrong type of code analysis: " + this.$commandType).toString());
                    }
                }
            }
        });
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CodeAnalysisCommand._execute$lambda$0(project2, context, this));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static final void _execute$lambda$0(Project $project, PlaybackContext $context, CodeAnalysisCommand this$0) {
        PsiManager.getInstance((Project)$project).dropPsiCaches();
        $context.message("Code highlighting started", this$0.getLine());
        DaemonCodeAnalyzer.getInstance((Project)$project).restart((Object)this$0);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeAnalysisCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/CodeAnalysisCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

