/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.stubs.PySuperClassIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PyClassInheritorsSearchExecutor
implements QueryExecutor<PyClass, PyClassInheritorsSearch.SearchParameters> {
    private static final ImmutableSet<String> IGNORED_BASES = ImmutableSet.of((Object)"object", (Object)"BaseException", (Object)"Exception");

    public boolean execute(@NotNull PyClassInheritorsSearch.SearchParameters queryParameters, @NotNull Processor<? super PyClass> consumer) {
        if (queryParameters == null) {
            PyClassInheritorsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PyClassInheritorsSearchExecutor.$$$reportNull$$$0(1);
        }
        HashSet<PyClass> processed = new HashSet<PyClass>();
        return PyClassInheritorsSearchExecutor.processDirectInheritors(queryParameters.getSuperClass(), consumer, queryParameters.isCheckDeepInheritance(), processed);
    }

    private static boolean processDirectInheritors(PyClass superClass, Processor<? super PyClass> consumer, boolean checkDeep, Set<PyClass> processed) {
        return (Boolean)ReadAction.compute(() -> {
            String superClassName = superClass.getName();
            if (superClassName == null || IGNORED_BASES.contains((Object)superClassName)) {
                return true;
            }
            if (processed.contains(superClass)) {
                return true;
            }
            processed.add(superClass);
            Project project = superClass.getProject();
            Collection candidates = StubIndex.getElements(PySuperClassIndex.KEY, (Object)superClassName, (Project)project, (GlobalSearchScope)ProjectScope.getAllScope((Project)project), PyClass.class);
            block0: for (PyClass candidate : candidates) {
                PyClass[] classes;
                for (PyClass superClassCandidate : classes = candidate.getSuperClasses(null)) {
                    if (!superClassCandidate.isEquivalentTo((PsiElement)superClass)) continue;
                    if (!consumer.process((Object)candidate)) {
                        return false;
                    }
                    if (!checkDeep || PyClassInheritorsSearchExecutor.processDirectInheritors(candidate, consumer, checkDeep, processed)) continue block0;
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/search/PyClassInheritorsSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

