/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodeRange;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class CommaLicense {
    private static final Map<String, String> closing2OpeningPunct = Map.of("`", "`", "}", "{", ")", "(", "]", "[", "\u2019", "\u2018", "'", "'", "\u201c", "\u201e", "\u00ab", "\u00bb", "\u00bb", "\u00ab", "\"", "\"");
    private static final NodePattern punctuationToMergeAfterWord = NodePattern.N.form("[*$]");
    private static final NodePattern ellipsisBeforeQuote = NodePattern.N.form("\u2026").noSpaceAfter().directlyBefore(NodePattern.N.and(node -> closing2OpeningPunct.get(node.form()) != null));
    public final Node start;
    public final Node end;
    public final NeedCommas need;
    public final boolean obligatory;

    private CommaLicense(Node start, Node end, NeedCommas need, boolean obligatory) {
        this.start = start;
        this.end = end;
        this.need = need;
        this.obligatory = obligatory;
    }

    public boolean allows(Node comma) {
        if (!",".equals(comma.form())) {
            return false;
        }
        if (this.need != NeedCommas.after && NodeRange.isInRange(comma, PhraseCommaChange.findNonPunctuation((Stream<Node>)this.start.back().skip(1L)), PhraseCommaChange.findNonPunctuation(this.start.forward()))) {
            return true;
        }
        return this.need != NeedCommas.before && NodeRange.isInRange(comma, PhraseCommaChange.findNonPunctuation(this.end.back()), PhraseCommaChange.findNonPunctuation((Stream<Node>)this.end.forward().skip(1L)));
    }

    public static CommaLicense forRange(Node start, Node end, NeedCommas need) {
        return new CommaLicense(start, end, need, false);
    }

    public static CommaLicense forPhrase(Node head, NeedCommas need) {
        return CommaLicense.forRange(head.phraseStart(), head.phraseEnd(), need);
    }

    public static CommaLicense forWord(Node node, NeedCommas need) {
        return CommaLicense.forRange(node, node, need);
    }

    public CommaLicense markObligatory() {
        return new CommaLicense(this.start, this.end, this.need, true);
    }

    public CommaLicense markObligatoryIf(boolean condition) {
        return condition ? this.markObligatory() : this;
    }

    public String toString() {
        return "[" + (this.obligatory ? "obligatory " : "") + String.valueOf((Object)this.need) + " " + this.start.tree().text().substring(this.start.startOffset(), this.end.endOffset()) + "]";
    }

    @Nullable
    public PhraseCommaChange addMissingCommas(NodePattern commaOrOpening, NodePattern commaOrClosing) {
        Node beforeComma1 = this.firstCommaInsertionPosition(commaOrOpening);
        Node beforeComma2 = this.secondCommaInsertionPosition(commaOrClosing);
        if (beforeComma1 == null && beforeComma2 == null) {
            return null;
        }
        NodeCorrector addBefore = beforeComma1 == null ? null : CommaLicense.addCommaDirectlyAfter(beforeComma1);
        NodeCorrector addAfter = beforeComma2 == null ? null : CommaLicense.addCommaDirectlyAfter(beforeComma2);
        return new PhraseCommaChange(this.start, this.end, addBefore, addAfter);
    }

    @Nullable
    public Node firstCommaInsertionPosition(NodePattern commaOrOpening) {
        return this.need == NeedCommas.after ? null : CommaLicense.findCommaBeforeInsertionAnchor(this.start, commaOrOpening);
    }

    @Nullable
    public Node secondCommaInsertionPosition(NodePattern commaOrClosing) {
        return this.need == NeedCommas.before ? null : CommaLicense.findCommaAfterInsertionAnchor(this.start, this.end, commaOrClosing);
    }

    @Nullable
    private static Node findCommaBeforeInsertionAnchor(Node start, NodePattern commaOrOpening) {
        if ((start = PhraseCommaChange.findNonPunctuation(start.forward())) == null || commaOrOpening.matches(start)) {
            return null;
        }
        Node prev = start.prevNode();
        return prev != null && !commaOrOpening.matches(prev) && prev.skipBack(n -> !CommonPatterns.letterWord.matches((Node)n)) != null ? prev : null;
    }

    @Nullable
    private static Node findCommaAfterInsertionAnchor(Node start, Node end, NodePattern commaOrClosing) {
        String opening;
        if ((end = PhraseCommaChange.findNonPunctuation(end.back())) == null || commaOrClosing.matches(end)) {
            return null;
        }
        Node next = end.nextNode();
        if (next != null && "(".equals(next.form())) {
            Node pair;
            Node head = next.head();
            Node node = pair = head == null ? null : head.phraseEnd();
            if (pair != null && ")".equals(pair.form())) {
                end = pair;
                next = end.nextNode();
            }
        }
        if (ellipsisBeforeQuote.matches(next)) {
            end = next;
            next = end.nextNode();
        }
        while (next != null && (opening = closing2OpeningPunct.get(next.form())) != null && !start.nextUntil(end).noneMatch(n -> opening.equals(n.form()))) {
            end = next;
            next = end.nextNode();
        }
        while (next != null && end.endOffset() == next.startOffset() && punctuationToMergeAfterWord.matches(next)) {
            end = next;
            next = end.nextNode();
        }
        next = end.nextNode();
        return next != null && !commaOrClosing.matches(next) && !"(".equals(next.form()) && next.skipForward(n -> !CommonPatterns.letterWord.matches((Node)n)) != null ? end : null;
    }

    public static NodeCorrector addCommaDirectlyAfter(Node node) {
        Node next = node.nextNode();
        if (CommonPatterns.comma.matches(next)) {
            return null;
        }
        return NodeCorrector.insertAfter(node, next != null && node.endOffset() == next.startOffset() ? ", " : ",");
    }

    @Nullable
    public static NodeCorrector addCommaBefore(Node start, NodePattern commaOrOpening) {
        Node prev = CommaLicense.findCommaBeforeInsertionAnchor(start, commaOrOpening);
        return prev != null ? CommaLicense.addCommaDirectlyAfter(prev) : null;
    }

    @Nullable
    public static NodeMatch surroundWithCommas(NodeMatch match, Node start, Node end, String missingBeforeMsg, String missingAfterMsg, String missingBothMsg, NodePattern commaOrOpening, NodePattern commaOrClosing) {
        PhraseCommaChange change = CommaLicense.forRange(start, end, NeedCommas.around).addMissingCommas(commaOrOpening, commaOrClosing);
        return change == null ? null : change.highlightAndCorrect(match).withMessage(change.selectMessage(missingBeforeMsg, missingAfterMsg, missingBothMsg));
    }

    public static NodeCorrector getCorrectorForSurroundWithCommas(NodeRange range, NodePattern commaOrOpening, NodePattern commaOrClosing) {
        PhraseCommaChange change = CommaLicense.forRange(range.start(), range.end(), NeedCommas.around).addMissingCommas(commaOrOpening, commaOrClosing);
        return change == null ? null : change.correct();
    }

    public static enum NeedCommas {
        before,
        after,
        around;

    }
}

