/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter2.Filter;
import org.jdom.filter2.Filters;
import org.jdom.xpath.XPathExpression;
import org.jdom.xpath.jaxen.JaxenXPathFactory;

public abstract class XPathFactory {
    private static final Namespace[] EMPTYNS = new Namespace[0];
    private static final AtomicReference<XPathFactory> defaultreference = new AtomicReference();

    public static XPathFactory instance() {
        XPathFactory ret = defaultreference.get();
        if (ret != null) {
            return ret;
        }
        JaxenXPathFactory fac = new JaxenXPathFactory();
        if (defaultreference.compareAndSet(null, fac)) {
            return fac;
        }
        return defaultreference.get();
    }

    public abstract <T> XPathExpression<T> compile(String var1, Filter<T> var2, Map<String, Object> var3, Namespace ... var4);

    public <T> XPathExpression<T> compile(String expression, Filter<T> filter2, Map<String, Object> variables, Collection<Namespace> namespaces) {
        return this.compile(expression, filter2, variables, namespaces.toArray(EMPTYNS));
    }

    public <T> XPathExpression<T> compile(String expression, Filter<T> filter2) {
        return this.compile(expression, filter2, null, EMPTYNS);
    }

    public XPathExpression<Element> elements(String expression) {
        return this.compile(expression, Filters.element(), null, EMPTYNS);
    }

    public XPathExpression<Object> compile(String expression) {
        return this.compile(expression, Filters.fpassthrough(), null, EMPTYNS);
    }
}

