/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.core.provider.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.xml.transform.stream.StreamSource;
import org.apache.hadoop.shaded.com.sun.jersey.core.provider.jaxb.AbstractJAXBProvider;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.javax.ws.rs.ext.Providers;
import org.apache.hadoop.shaded.javax.xml.bind.JAXBException;
import org.apache.hadoop.shaded.javax.xml.bind.Marshaller;
import org.apache.hadoop.shaded.javax.xml.bind.UnmarshalException;
import org.apache.hadoop.shaded.javax.xml.bind.Unmarshaller;
import org.apache.hadoop.shaded.javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.shaded.javax.xml.bind.annotation.XmlType;

public abstract class AbstractRootElementProvider
extends AbstractJAXBProvider<Object> {
    public AbstractRootElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractRootElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (type.getAnnotation(XmlRootElement.class) != null || type.getAnnotation(XmlType.class) != null) && this.isSupported(mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XmlRootElement.class) != null && this.isSupported(mediaType);
    }

    @Override
    public final Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return this.readFrom(type, mediaType, this.getUnmarshaller(type, mediaType), entityStream);
        }
        catch (UnmarshalException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected Object readFrom(Class<Object> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return u.unmarshal(entityStream);
        }
        return u.unmarshal(new StreamSource(entityStream), type).getValue();
    }

    @Override
    public final void writeTo(Object t2, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller m4 = this.getMarshaller(type, mediaType);
            Charset c = AbstractRootElementProvider.getCharset(mediaType);
            if (c != UTF8) {
                m4.setProperty("jaxb.encoding", c.name());
            }
            this.setHeader(m4, annotations);
            this.writeTo(t2, mediaType, c, m4, entityStream);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected void writeTo(Object t2, MediaType mediaType, Charset c, Marshaller m4, OutputStream entityStream) throws JAXBException {
        m4.marshal(t2, entityStream);
    }
}

