/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.io.IOException;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorReader;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorWriter;
import org.opensearch.neuralsearch.sparse.data.SparseVector;

public class CacheGatedForwardIndexReader
implements SparseVectorReader {
    private final SparseVectorReader cacheReader;
    private final SparseVectorWriter cacheWriter;
    private final SparseVectorReader luceneReader;

    public CacheGatedForwardIndexReader(SparseVectorReader cacheReader, SparseVectorWriter cacheWriter, SparseVectorReader luceneReader) {
        this.cacheReader = cacheReader == null ? SparseVectorReader.NOOP_READER : cacheReader;
        this.cacheWriter = cacheWriter == null ? SparseVectorWriter.NOOP_WRITER : cacheWriter;
        this.luceneReader = luceneReader == null ? SparseVectorReader.NOOP_READER : luceneReader;
    }

    @Override
    public SparseVector read(int docId) throws IOException {
        SparseVector vector = this.cacheReader.read(docId);
        if (vector != null) {
            return vector;
        }
        vector = this.luceneReader.read(docId);
        if (vector != null) {
            this.cacheWriter.insert(docId, vector);
        }
        return vector;
    }
}

