/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.index.IndexSettings;
import org.opensearch.replication.ReplicationPlugin;
import org.opensearch.replication.ReplicationSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/replication/task/shard/BatchSizeSettings;", "", "indexSettings", "Lorg/opensearch/index/IndexSettings;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "<init>", "(Lorg/opensearch/index/IndexSettings;Lorg/opensearch/replication/ReplicationSettings;)V", "getBatchSize", "", "hasIndexLevelSetting", "", "getBatchSizeSource", "", "dynamicBatchSize", "Ljava/lang/Integer;", "getEffectiveBatchSize", "reduceBatchSize", "", "resetBatchSize", "isDynamicallyReduced", "opensearch-cross-cluster-replication"})
public final class BatchSizeSettings {
    @NotNull
    private final IndexSettings indexSettings;
    @NotNull
    private final ReplicationSettings replicationSettings;
    @Nullable
    private volatile Integer dynamicBatchSize;

    public BatchSizeSettings(@NotNull IndexSettings indexSettings, @NotNull ReplicationSettings replicationSettings) {
        Intrinsics.checkNotNullParameter((Object)indexSettings, (String)"indexSettings");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        this.indexSettings = indexSettings;
        this.replicationSettings = replicationSettings;
    }

    public final int getBatchSize() {
        int n;
        if (this.hasIndexLevelSetting()) {
            Object object = ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_OPS_BATCH_SIZE_INDEX().get(this.indexSettings.getSettings());
            Intrinsics.checkNotNull((Object)object);
            n = ((Number)object).intValue();
        } else {
            Integer n2 = this.replicationSettings.getBatchSize();
            Intrinsics.checkNotNull((Object)n2);
            n = ((Number)n2).intValue();
        }
        return n;
    }

    public final boolean hasIndexLevelSetting() {
        return this.indexSettings.getSettings().hasValue(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_OPS_BATCH_SIZE_INDEX().getKey());
    }

    @NotNull
    public final String getBatchSizeSource() {
        return this.hasIndexLevelSetting() ? "index-level" : "cluster-level";
    }

    public final int getEffectiveBatchSize() {
        Integer n = this.dynamicBatchSize;
        return n != null ? n.intValue() : this.getBatchSize();
    }

    public final void reduceBatchSize() {
        int currentSize = this.getEffectiveBatchSize();
        this.dynamicBatchSize = Math.max(currentSize / 2, 16);
    }

    public final void resetBatchSize() {
        this.dynamicBatchSize = null;
    }

    public final boolean isDynamicallyReduced() {
        return this.dynamicBatchSize != null;
    }
}

