/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transportv2;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.AlertingV2Utils;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.actionv2.ExecuteMonitorV2Request;
import org.opensearch.alerting.actionv2.ExecuteMonitorV2Response;
import org.opensearch.alerting.core.settings.AlertingV2Settings;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.modelv2.MonitorV2RunResult;
import org.opensearch.alerting.modelv2.PPLSQLMonitor;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transportv2.TransportExecuteMonitorV2ActionKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BA\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR$\u0010\u001b\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/opensearch/alerting/transportv2/TransportExecuteMonitorV2Action;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/actionv2/ExecuteMonitorV2Request;", "Lorg/opensearch/alerting/actionv2/ExecuteMonitorV2Response;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "runner", "Lorg/opensearch/alerting/MonitorRunnerService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "settings", "Lorg/opensearch/common/settings/Settings;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/alerting/MonitorRunnerService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/common/settings/Settings;)V", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "alertingV2Enabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "filterByEnabled", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "execMonitorV2Request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
public final class TransportExecuteMonitorV2Action
extends HandledTransportAction<ExecuteMonitorV2Request, ExecuteMonitorV2Response>
implements SecureTransportAction {
    @NotNull
    private final TransportService transportService;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final MonitorRunnerService runner;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final Settings settings;
    private volatile Boolean alertingV2Enabled;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportExecuteMonitorV2Action(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull MonitorRunnerService runner, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/alerting/v2/monitor/execute", transportService, actionFilters, ExecuteMonitorV2Request::new);
        this.transportService = transportService;
        this.client = client;
        this.clusterService = clusterService;
        this.runner = runner;
        this.xContentRegistry = xContentRegistry;
        this.settings = settings;
        this.alertingV2Enabled = (Boolean)AlertingV2Settings.Companion.getALERTING_V2_ENABLED().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingV2Settings.Companion.getALERTING_V2_ENABLED(), arg_0 -> TransportExecuteMonitorV2Action._init_$lambda$0(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull ExecuteMonitorV2Request execMonitorV2Request, @NotNull ActionListener<ExecuteMonitorV2Response> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)execMonitorV2Request), (String)"execMonitorV2Request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.alertingV2Enabled.booleanValue()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Alerting V2 is currently disabled, please enable it with the cluster setting: " + AlertingV2Settings.Companion.getALERTING_V2_ENABLED().getKey(), RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        TransportExecuteMonitorV2ActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Function1 executeMonitorV22 = arg_0 -> TransportExecuteMonitorV2Action.doExecute$lambda$2$lambda$1(this, execMonitorV2Request, actionListener, arg_0);
            if (execMonitorV2Request.getMonitorV2Id() != null && execMonitorV2Request.getMonitorV2() != null) {
                TransportExecuteMonitorV2ActionKt.access$getLog$p().info("Both a monitor_v2 id and monitor_v2 object were passed in to ExecuteMonitorV2request. Proceeding to execute by monitor_v2 ID and ignoring monitor_v2 object.");
            }
            if (execMonitorV2Request.getMonitorV2Id() != null) {
                GetRequest getMonitorV2Request = new GetRequest(".opendistro-alerting-config").id(execMonitorV2Request.getMonitorV2Id());
                this.client.get(getMonitorV2Request, (ActionListener)new ActionListener<GetResponse>(actionListener, this, execMonitorV2Request, user, (Function1<? super MonitorV2, Unit>)executeMonitorV22){
                    final /* synthetic */ ActionListener<ExecuteMonitorV2Response> $actionListener;
                    final /* synthetic */ TransportExecuteMonitorV2Action this$0;
                    final /* synthetic */ ExecuteMonitorV2Request $execMonitorV2Request;
                    final /* synthetic */ User $user;
                    final /* synthetic */ Function1<MonitorV2, Unit> $executeMonitorV2;
                    {
                        this.$actionListener = $actionListener;
                        this.this$0 = $receiver;
                        this.$execMonitorV2Request = $execMonitorV2Request;
                        this.$user = $user;
                        this.$executeMonitorV2 = $executeMonitorV2;
                    }

                    public void onResponse(GetResponse getMonitorV2Response) {
                        Intrinsics.checkNotNullParameter((Object)getMonitorV2Response, (String)"getMonitorV2Response");
                        if (!getMonitorV2Response.isExists()) {
                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Can't find monitorV2 with id: " + getMonitorV2Response.getId() + " to execute", RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        if (getMonitorV2Response.isSourceEmpty()) {
                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Found monitorV2 with id: " + getMonitorV2Response.getId() + " but it was empty", RestStatus.NO_CONTENT, new Object[0])));
                            return;
                        }
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getMonitorV2Response.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                        Intrinsics.checkNotNull((Object)xcp);
                        String string = getMonitorV2Response.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        ScheduledJob scheduledJob2 = ScheduledJob.Companion.parse(xcp, string, getMonitorV2Response.getVersion());
                        Exception exception = AlertingV2Utils.INSTANCE.validateMonitorV2(scheduledJob2);
                        if (exception != null) {
                            Exception exception2 = exception;
                            ActionListener<ExecuteMonitorV2Response> actionListener = this.$actionListener;
                            Exception it = exception2;
                            boolean bl = false;
                            actionListener.onFailure((Exception)AlertingException.Companion.wrap(it));
                            return;
                        }
                        Intrinsics.checkNotNull((Object)scheduledJob2, (String)"null cannot be cast to non-null type org.opensearch.alerting.modelv2.MonitorV2");
                        MonitorV2 monitorV2 = (MonitorV2)scheduledJob2;
                        if (this.$execMonitorV2Request.getManual() && !this.this$0.checkUserPermissionsWithResource(this.$user, monitorV2.getUser(), this.$actionListener, "monitor", this.$execMonitorV2Request.getMonitorV2Id())) {
                            return;
                        }
                        try {
                            this.$executeMonitorV2.invoke((Object)monitorV2);
                        }
                        catch (Exception e) {
                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                        }
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
            } else {
                try {
                    MonitorV2 monitorV2 = execMonitorV2Request.getMonitorV2();
                    Intrinsics.checkNotNull((Object)monitorV2);
                    MonitorV2 monitorV22 = MonitorV2.makeCopy$default(monitorV2, null, 0L, null, false, null, null, null, null, user, 0, null, null, 3839, null);
                    executeMonitorV22.invoke((Object)monitorV22);
                }
                catch (Exception e) {
                    actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportExecuteMonitorV2Action this$0, Boolean it) {
        this$0.alertingV2Enabled = it;
    }

    private static final Unit doExecute$lambda$2$lambda$1(TransportExecuteMonitorV2Action this$0, ExecuteMonitorV2Request $execMonitorV2Request, ActionListener<ExecuteMonitorV2Response> $actionListener, MonitorV2 monitorV2) {
        BuildersKt.launch$default((CoroutineScope)this$0.runner, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($execMonitorV2Request, monitorV2, this$0, $actionListener, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ ExecuteMonitorV2Request $execMonitorV2Request;
            final /* synthetic */ MonitorV2 $monitorV2;
            final /* synthetic */ TransportExecuteMonitorV2Action this$0;
            final /* synthetic */ ActionListener<ExecuteMonitorV2Response> $actionListener;
            {
                this.$execMonitorV2Request = $execMonitorV2Request;
                this.$monitorV2 = $monitorV2;
                this.this$0 = $receiver;
                this.$actionListener = $actionListener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        periodEnd = Instant.ofEpochMilli(this.$execMonitorV2Request.getRequestEnd().getMillis());
                        if (!(this.$monitorV2 instanceof PPLSQLMonitor)) {
                            throw new IllegalStateException("Unexpected MonitorV2 type: " + this.$monitorV2.getClass().getName());
                        }
                        monitorV2Type = "ppl_monitor";
                        TransportExecuteMonitorV2ActionKt.access$getLog$p().info("Executing MonitorV2 from API - id: " + ((PPLSQLMonitor)this.$monitorV2).getId() + ", type: " + monitorV2Type + ", periodEnd: " + periodEnd + ", manual: " + this.$execMonitorV2Request.getManual());
                        v0 = TransportExecuteMonitorV2Action.access$getRunner$p(this.this$0);
                        Intrinsics.checkNotNull((Object)periodEnd);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)periodEnd);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)monitorV2Type);
                        this.label = 1;
                        v1 = v0.runJobV2(this.$monitorV2, periodEnd, this.$execMonitorV2Request.getDryrun(), this.$execMonitorV2Request.getManual(), TransportExecuteMonitorV2Action.access$getTransportService$p(this.this$0), (Continuation)this);
                        ** if (v1 != var5_2) goto lbl20
lbl19:
                        // 1 sources

                        return var5_2;
lbl20:
                        // 1 sources

                        ** GOTO lbl28
                    }
                    case 1: {
                        monitorV2Type = (String)this.L$1;
                        periodEnd = (Instant)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        monitorV2RunResult = (MonitorV2RunResult)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)periodEnd);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)monitorV2Type);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)monitorV2RunResult);
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, monitorV2RunResult, null){
                            int label;
                            final /* synthetic */ ActionListener<ExecuteMonitorV2Response> $actionListener;
                            final /* synthetic */ MonitorV2RunResult<?> $monitorV2RunResult;
                            {
                                this.$actionListener = $actionListener;
                                this.$monitorV2RunResult = $monitorV2RunResult;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$actionListener.onResponse((Object)((Object)new ExecuteMonitorV2Response(this.$monitorV2RunResult)));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v2 != var5_2) goto lbl36
lbl35:
                        // 1 sources

                        return var5_2;
lbl36:
                        // 1 sources

                        ** GOTO lbl61
                    }
                    case 2: {
                        monitorV2RunResult = (MonitorV2RunResult)this.L$2;
                        monitorV2Type = (String)this.L$1;
                        periodEnd = (Instant)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** GOTO lbl61
                        }
                        catch (Exception e) {
                            TransportExecuteMonitorV2ActionKt.access$getLog$p().error("Unexpected error running monitor", (Throwable)e);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)periodEnd);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)e);
                            this.L$2 = null;
                            this.label = 3;
                            v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, e, null){
                                int label;
                                final /* synthetic */ ActionListener<ExecuteMonitorV2Response> $actionListener;
                                final /* synthetic */ Exception $e;
                                {
                                    this.$actionListener = $actionListener;
                                    this.$e = $e;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(this.$e));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v3 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl61
                        }
                    }
                    case 3: {
                        e = (Exception)this.L$1;
                        periodEnd = (Instant)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl61:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MonitorRunnerService access$getRunner$p(TransportExecuteMonitorV2Action $this) {
        return $this.runner;
    }

    public static final /* synthetic */ TransportService access$getTransportService$p(TransportExecuteMonitorV2Action $this) {
        return $this.transportService;
    }
}

