/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.kubernetes;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.http.simple.SimpleHttpRequest;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.util.JWKSUtils;

public class KubernetesJwksEndpointLoader
implements PublicKeyLoader {
    private static final Logger logger = Logger.getLogger(KubernetesJwksEndpointLoader.class);
    private final KeycloakSession session;
    private final String issuer;

    public KubernetesJwksEndpointLoader(KeycloakSession session, String issuer) {
        this.session = session;
        this.issuer = issuer;
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        SimpleHttp simpleHttp = SimpleHttp.create((KeycloakSession)this.session);
        String token = this.getToken(this.issuer);
        String wellKnownEndpoint = this.issuer + "/.well-known/openid-configuration";
        SimpleHttpRequest wellKnownReqest = simpleHttp.doGet(wellKnownEndpoint).acceptJson();
        if (token != null) {
            wellKnownReqest.auth(token);
        }
        String jwksUri = ((OIDCConfigurationRepresentation)wellKnownReqest.asJson(OIDCConfigurationRepresentation.class)).getJwksUri();
        SimpleHttpRequest jwksRequest = simpleHttp.doGet(jwksUri).header("Accept", "application/jwk-set+json");
        if (token != null) {
            jwksRequest.auth(token);
        }
        JSONWebKeySet jwks = (JSONWebKeySet)jwksRequest.asJson(JSONWebKeySet.class);
        return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
    }

    private String getToken(String issuer) {
        try {
            File file = new File("/var/run/secrets/kubernetes.io/serviceaccount/token");
            if (!file.exists()) {
                return null;
            }
            String token = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            JsonWebToken jwt = (JsonWebToken)new JWSInput(token).readJsonContent(JsonWebToken.class);
            if (jwt.getIssuer().equals(issuer)) {
                logger.trace((Object)"Including service account token in request");
                return token;
            }
            logger.debug((Object)"Not including service account token due to issuer missmatch");
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read service account token file", (Throwable)e);
        }
        return null;
    }
}

