/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.organization;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedOrganizationIds
extends AbstractRevisioned
implements InRealm {
    private final String realmId;
    private final List<String> orgIds;

    public CachedOrganizationIds(Long revision, String id, RealmModel realm, OrganizationModel model) {
        super(revision, id);
        this.realmId = realm.getId();
        this.orgIds = List.of(model.getId());
    }

    public CachedOrganizationIds(Long revision, String id, RealmModel realm, Stream<OrganizationModel> models) {
        super(revision, id);
        this.realmId = realm.getId();
        Set<String> ids = models.map(OrganizationModel::getId).collect(Collectors.toSet());
        this.orgIds = ids.isEmpty() ? List.of() : List.of(ids.toArray(new String[0]));
    }

    public Collection<String> getOrgIds() {
        return this.orgIds;
    }

    @Override
    public String getRealm() {
        return this.realmId;
    }
}

