/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigValue;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.config.LoggingOptions;
import org.keycloak.config.Option;
import org.keycloak.config.WildcardOptionsUtil;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public class WildcardPropertyMapper<T>
extends PropertyMapper<T> {
    private static final Pattern valueValidator = Pattern.compile("[\\[\\]\\$\\-._a-zA-Z0-9]+");
    private final BiFunction<String, Set<String>, Set<String>> wildcardKeysTransformer;
    private final PropertyMapper.ValueMapper wildcardMapFrom;
    private final String fromPrefix;
    private String toPrefix;
    private String toSuffix;
    private Character replacementChar = null;

    public WildcardPropertyMapper(Option<T> option, String to, Function<AbstractCommand, Boolean> enabled, String enabledWhen, PropertyMapper.ValueMapper mapper, String mapFrom, PropertyMapper.ValueMapper parentMapper, String paramLabel, boolean mask, BiConsumer<PropertyMapper<T>, ConfigValue> validator, String description, BooleanSupplier required, String requiredWhen, BiFunction<String, Set<String>, Set<String>> wildcardKeysTransformer, PropertyMapper.ValueMapper wildcardMapFrom) {
        super(option, to, enabled, enabledWhen, mapper, mapFrom, parentMapper, paramLabel, mask, validator, description, required, requiredWhen, null, null);
        this.wildcardMapFrom = wildcardMapFrom;
        if (!WildcardOptionsUtil.isWildcardOption((String)this.getFrom()) || !this.getFrom().endsWith(">")) {
            throw new IllegalArgumentException("Invalid wildcard from format. Wildcard must be at the end of the option.");
        }
        this.fromPrefix = WildcardOptionsUtil.getWildcardPrefix((String)this.getFrom());
        if (option == LoggingOptions.LOG_LEVEL_CATEGORY) {
            this.replacementChar = Character.valueOf('.');
        }
        if (this.getTo() != null) {
            if (!this.getTo().startsWith("quarkus.") && !this.getTo().startsWith("kc.")) {
                throw new IllegalArgumentException("Wildcards should map to Quarkus or Keycloak options (option '%s' mapped to '%s'). If not, PropertyMappers logic will need adjusted".formatted(option.getKey(), this.getTo()));
            }
            if (!WildcardOptionsUtil.isWildcardOption((String)this.getTo())) {
                throw new IllegalArgumentException("Invalid wildcard map to.");
            }
            this.toPrefix = WildcardOptionsUtil.getWildcardPrefix((String)this.getTo());
            this.toSuffix = this.getTo().substring(this.getTo().lastIndexOf(">") + 1);
        }
        this.wildcardKeysTransformer = wildcardKeysTransformer;
    }

    @Override
    public boolean hasWildcard() {
        return true;
    }

    public String getTo(String wildcardKey) {
        return this.toPrefix + wildcardKey + this.toSuffix;
    }

    public String getFrom(String wildcardKey) {
        return this.fromPrefix + wildcardKey;
    }

    public Stream<String> getToFromWildcardTransformer(String value) {
        if (this.wildcardKeysTransformer == null) {
            return Stream.empty();
        }
        return this.wildcardKeysTransformer.apply(value, new HashSet()).stream().map(this::getTo);
    }

    @Override
    public PropertyMapper<?> forKey(String key) {
        String wildcardValue = this.extractWildcardValue(key).orElseThrow(() -> new IllegalArgumentException("Invalid wildcard value"));
        String to = this.getTo(wildcardValue);
        String from = this.getFrom(wildcardValue);
        String mapFrom = this.getMapFrom();
        if (WildcardOptionsUtil.isWildcardOption((String)mapFrom)) {
            mapFrom = WildcardOptionsUtil.getWildcardNamedKey((String)mapFrom, (String)wildcardValue);
        }
        return new PropertyMapper(this, from, to, mapFrom, wildcardValue, this.wildcardMapFrom == null ? null : (name, v, context) -> this.wildcardMapFrom.map(wildcardValue, v, context));
    }

    public Set<String> getConnectedOptions(String key) {
        return this.option.getConnectedOptions().stream().map(option -> WildcardOptionsUtil.isWildcardOption((String)option) ? WildcardOptionsUtil.getWildcardNamedKey((String)option, (String)key) : option).collect(Collectors.toSet());
    }

    public Optional<String> extractWildcardValue(String key) {
        String result = null;
        if (key.startsWith(this.fromPrefix)) {
            result = key.substring(this.fromPrefix.length());
        } else if (key.startsWith(this.toPrefix) && key.endsWith(this.toSuffix)) {
            result = key.substring(this.toPrefix.length(), key.length() - this.toSuffix.length());
        }
        return Optional.ofNullable(result).filter(WildcardPropertyMapper::isValidWildcardValue);
    }

    public static boolean isValidWildcardValue(String result) {
        return valueValidator.matcher(result).matches();
    }

    public boolean matchesWildcardOptionName(String name) {
        return this.extractWildcardValue(name).isPresent();
    }

    public Optional<String> getKcKeyForEnvKey(String envKey, String transformedKey) {
        if (transformedKey.startsWith(this.fromPrefix)) {
            if (this.replacementChar != null) {
                return Optional.ofNullable(this.getFrom(envKey.substring(this.fromPrefix.length()).toLowerCase().replace('_', this.replacementChar.charValue())));
            }
            return Optional.of(transformedKey);
        }
        return Optional.empty();
    }
}

