/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import jspecview.api.JSVPrintDialog;
import jspecview.common.PrintLayout;

public class AwtPrintDialog
extends JDialog
implements JSVPrintDialog {
    private static final long serialVersionUID = 1L;
    private ButtonGroup layoutButtonGroup = new ButtonGroup();
    private ButtonGroup fontButtonGroup = new ButtonGroup();
    private ButtonGroup positionButtonGroup = new ButtonGroup();
    private PrintLayout pl;
    private PrintLayout plNew;
    private JButton previewButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton printButton = new JButton();
    private JButton pdfButton = new JButton();
    private JCheckBox scaleXCheckBox = new JCheckBox();
    private JCheckBox scaleYCheckBox = new JCheckBox();
    private JCheckBox gridCheckBox = new JCheckBox();
    private JCheckBox titleCheckBox = new JCheckBox();
    private JRadioButton landscapeRadioButton = new JRadioButton();
    private JRadioButton topLeftRadioButton = new JRadioButton();
    private JRadioButton centerRadioButton = new JRadioButton();
    private JRadioButton portraitRadioButton = new JRadioButton();
    private JRadioButton fitToPageRadioButton = new JRadioButton();
    private JRadioButton chooseFontRadioButton = new JRadioButton();
    private JRadioButton defaultFontRadioButton = new JRadioButton();
    private static JComboBox<MediaSizeName> paperComboBox = new JComboBox();
    private static ImageIcon previewPortraitCenterIcon;
    private static ImageIcon previewPortraitDefaultIcon;
    private static ImageIcon previewPortraitFitIcon;
    private static ImageIcon previewLandscapeCenterIcon;
    private static ImageIcon previewLandscapeDefaultIcon;
    private static ImageIcon previewLandscapeFitIcon;

    public AwtPrintDialog() {
        super((Frame)null, "Print layout", true);
    }

    @Override
    public AwtPrintDialog set(JFrame jFrame, PrintLayout printLayout, boolean bl) {
        if (printLayout == null) {
            printLayout = new PrintLayout(null);
        }
        this.pl = printLayout;
        try {
            this.jbInit(bl);
            this.setSize(320, 250);
            this.setLocationRelativeTo(jFrame);
            this.setResizable(false);
            this.pack();
            this.pdfButton.requestFocusInWindow();
            this.setVisible(true);
            return this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setStaticElements() {
        if (previewLandscapeFitIcon != null) {
            return;
        }
        paperComboBox.addItem(MediaSizeName.NA_LETTER);
        paperComboBox.addItem(MediaSizeName.NA_LEGAL);
        paperComboBox.addItem(MediaSizeName.ISO_A4);
        paperComboBox.addItem(MediaSizeName.ISO_B4);
        previewPortraitCenterIcon = AwtPrintDialog.getIcon("portraitCenter");
        previewPortraitDefaultIcon = AwtPrintDialog.getIcon("portraitDefault");
        previewPortraitFitIcon = AwtPrintDialog.getIcon("portraitFit");
        previewLandscapeCenterIcon = AwtPrintDialog.getIcon("landscapeCenter");
        previewLandscapeDefaultIcon = AwtPrintDialog.getIcon("landscapeDefault");
        previewLandscapeFitIcon = AwtPrintDialog.getIcon("landscapeFit");
    }

    private static ImageIcon getIcon(String string) {
        return new ImageIcon(AwtPrintDialog.class.getResource("icons/" + string + ".gif"));
    }

    private void jbInit(boolean bl) throws Exception {
        this.layoutButtonGroup.add(this.portraitRadioButton);
        this.layoutButtonGroup.add(this.landscapeRadioButton);
        this.positionButtonGroup.add(this.centerRadioButton);
        this.positionButtonGroup.add(this.fitToPageRadioButton);
        this.positionButtonGroup.add(this.topLeftRadioButton);
        this.fontButtonGroup.add(this.defaultFontRadioButton);
        this.fontButtonGroup.add(this.chooseFontRadioButton);
        AwtPrintDialog.setStaticElements();
        TitledBorder titledBorder = new TitledBorder("Layout");
        titledBorder.setTitleJustification(2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.printButton.setToolTipText("");
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.printButton_actionPerformed(false);
            }
        });
        this.pdfButton.setToolTipText("");
        this.pdfButton.setText("Create PDF");
        this.pdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.printButton_actionPerformed(true);
            }
        });
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setBorder(titledBorder);
        jPanel2.setLayout(new GridBagLayout());
        this.landscapeRadioButton.setActionCommand("Landscape");
        this.landscapeRadioButton.setText("Landscape");
        this.landscapeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.landscapeRadioButton_actionPerformed(actionEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        this.scaleXCheckBox.setText("X-Scale");
        this.scaleYCheckBox.setText("Y-Scale");
        this.previewButton.setBorder(null);
        this.previewButton.setIcon(previewLandscapeDefaultIcon);
        this.gridCheckBox.setText("Grid");
        this.topLeftRadioButton.setActionCommand("Default");
        this.topLeftRadioButton.setText("Top Left");
        this.topLeftRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.defaultPosRadioButton_actionPerformed(actionEvent);
            }
        });
        this.centerRadioButton.setActionCommand("Center");
        this.centerRadioButton.setText("Center");
        this.centerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.centerRadioButton_actionPerformed(actionEvent);
            }
        });
        this.portraitRadioButton.setActionCommand("Portrait");
        this.portraitRadioButton.setText("Portrait");
        this.portraitRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.portraitRadioButton_actionPerformed(actionEvent);
            }
        });
        this.fitToPageRadioButton.setActionCommand("Fit To Page");
        this.fitToPageRadioButton.setText("Fit to Page");
        this.fitToPageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AwtPrintDialog.this.fitToPageRadioButton_actionPerformed(actionEvent);
            }
        });
        this.chooseFontRadioButton.setText("Choose font");
        this.defaultFontRadioButton.setText("Use default");
        this.titleCheckBox.setText("Titles");
        this.getContentPane().add((Component)jPanel3, "South");
        if (bl) {
            jPanel3.add((Component)this.printButton, null);
        }
        jPanel3.add((Component)this.pdfButton, null);
        jPanel3.add((Component)this.cancelButton, null);
        Insets insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, insets, 0, 0));
        jPanel2.add((Component)this.landscapeRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.portraitRadioButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.titleCheckBox, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.gridCheckBox, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.fitToPageRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.topLeftRadioButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.centerRadioButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.scaleXCheckBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.scaleYCheckBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this.previewButton, new GridBagConstraints(2, 0, 1, 5, 0.0, 1.0, 18, 1, insets, 0, 0));
        jPanel2.add(paperComboBox, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.setDefaults();
    }

    void portraitRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.setPreview();
    }

    void landscapeRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.setPreview();
    }

    void centerRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.setPreview();
    }

    void fitToPageRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.setPreview();
    }

    private void setPreview() {
        int n = " PL".indexOf(this.layoutButtonGroup.getSelection().getActionCommand().charAt(0));
        int n2 = " DCF".indexOf(this.positionButtonGroup.getSelection().getActionCommand().charAt(0));
        ImageIcon imageIcon = null;
        switch ((n << 4) + n2) {
            default: {
                imageIcon = previewPortraitDefaultIcon;
                break;
            }
            case 18: {
                imageIcon = previewPortraitCenterIcon;
                break;
            }
            case 19: {
                imageIcon = previewPortraitFitIcon;
                break;
            }
            case 33: {
                imageIcon = previewLandscapeDefaultIcon;
                break;
            }
            case 34: {
                imageIcon = previewLandscapeCenterIcon;
                break;
            }
            case 35: {
                imageIcon = previewLandscapeFitIcon;
            }
        }
        this.previewButton.setIcon(imageIcon);
    }

    void defaultPosRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.setPreview();
    }

    private void setDefaults() {
        this.landscapeRadioButton.setSelected(this.pl.layout.equals("landscape"));
        this.portraitRadioButton.setSelected(!this.landscapeRadioButton.isSelected());
        this.scaleXCheckBox.setSelected(this.pl.showXScale);
        this.scaleYCheckBox.setSelected(this.pl.showYScale);
        this.gridCheckBox.setSelected(this.pl.showGrid);
        this.titleCheckBox.setSelected(this.pl.showTitles);
        this.fitToPageRadioButton.setSelected(this.pl.position.equals("fit to page"));
        this.centerRadioButton.setSelected(this.pl.position.equals("center"));
        this.topLeftRadioButton.setSelected(this.pl.position.equals("default"));
        this.defaultFontRadioButton.setSelected(this.pl.font == null);
        int n = 0;
        while (n < paperComboBox.getItemCount()) {
            if (this.pl.paper == null || paperComboBox.getItemAt(n).equals(this.pl.paper)) {
                paperComboBox.setSelectedIndex(n);
                break;
            }
            ++n;
        }
        this.setPreview();
    }

    void printButton_actionPerformed(boolean bl) {
        this.plNew = new PrintLayout(null);
        this.plNew.layout = this.layoutButtonGroup.getSelection().getActionCommand().toLowerCase();
        this.plNew.font = null;
        this.plNew.position = this.positionButtonGroup.getSelection().getActionCommand().toLowerCase();
        this.plNew.showGrid = this.gridCheckBox.isSelected();
        this.plNew.showXScale = this.scaleXCheckBox.isSelected();
        this.plNew.showYScale = this.scaleYCheckBox.isSelected();
        this.plNew.showTitles = this.titleCheckBox.isSelected();
        this.plNew.paper = paperComboBox.getSelectedItem();
        this.plNew.asPDF = bl;
        this.dispose();
    }

    @Override
    public PrintLayout getPrintLayout() {
        return this.plNew;
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

