/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.ant.execution;

import com.intellij.rt.ant.execution.Packet;
import com.intellij.rt.ant.execution.PacketProcessor;
import com.intellij.rt.ant.execution.SegmentedStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class SegmentedOutputStream
extends OutputStream
implements PacketProcessor {
    private final PrintStream myPrintStream;
    private boolean myStarted = false;

    public SegmentedOutputStream(PrintStream transportStream) {
        this(transportStream, false);
    }

    public SegmentedOutputStream(PrintStream transportStream, boolean started) {
        this.myPrintStream = transportStream;
        this.myStarted = started;
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (b == 47 && this.myStarted) {
            this.writeNext(b);
        }
        this.writeNext(b);
        this.flush();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.myPrintStream.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.myPrintStream.close();
    }

    private void writeNext(int b) {
        this.myPrintStream.write(b);
    }

    @Override
    public synchronized void processPacket(String packet) {
        if (!this.myStarted) {
            this.sendStart();
        }
        this.writeNext(SegmentedStream.MARKER_PREFIX);
        String encodedPacket = Packet.encode(packet);
        this.writeNext(encodedPacket.length() + " " + encodedPacket);
    }

    private void writeNext(String string) {
        try {
            this.myPrintStream.write(string.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void sendStart() {
        this.writeNext("@#IJIDEA#JUnitSupport#@");
        this.myStarted = true;
    }

    public PrintStream getPrintStream() {
        return this.myPrintStream;
    }
}

