/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.keyboard.PromptEntry;

public class InteractiveChallenge
implements Cloneable {
    private String interactionName;
    private String interactionInstruction;
    private String languageTag;
    private List<PromptEntry> prompts = new ArrayList<PromptEntry>();

    public String getInteractionName() {
        return this.interactionName;
    }

    public void setInteractionName(String interactionName) {
        this.interactionName = interactionName;
    }

    public String getInteractionInstruction() {
        return this.interactionInstruction;
    }

    public void setInteractionInstruction(String interactionInstruction) {
        this.interactionInstruction = interactionInstruction;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public void setLanguageTag(String languageTag) {
        this.languageTag = languageTag;
    }

    public void addPrompt(String prompt, boolean echo) {
        this.addPrompt(new PromptEntry(prompt, echo));
    }

    public void addPrompt(PromptEntry entry) {
        this.prompts.add(Objects.requireNonNull(entry, "No entry"));
    }

    public List<PromptEntry> getPrompts() {
        return this.prompts;
    }

    public void setPrompts(Collection<? extends PromptEntry> prompts) {
        this.clearPrompts();
        if (GenericUtils.size(prompts) > 0) {
            this.prompts.addAll(prompts);
        }
    }

    public void clearPrompts() {
        this.prompts.clear();
    }

    public <B extends Buffer> B append(B buffer) {
        buffer.putString(this.getInteractionName());
        buffer.putString(this.getInteractionInstruction());
        buffer.putString(this.getLanguageTag());
        List<PromptEntry> entries = this.getPrompts();
        int numEntries = GenericUtils.size(entries);
        buffer.putUInt(numEntries);
        for (int index = 0; index < numEntries; ++index) {
            PromptEntry e = entries.get(index);
            e.append(buffer);
        }
        return buffer;
    }

    public InteractiveChallenge clone() {
        try {
            InteractiveChallenge other = (InteractiveChallenge)this.getClass().cast(super.clone());
            other.prompts = new ArrayList<PromptEntry>();
            for (PromptEntry entry : this.getPrompts()) {
                other.addPrompt(entry.clone());
            }
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Failed to clone " + this.toString() + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.getInteractionName() + "[" + this.getInteractionInstruction() + "](" + this.getLanguageTag() + "): " + this.getPrompts();
    }
}

