/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import org.gradle.cache.CrossProcessCacheAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafeIndexedCache;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.jspecify.annotations.Nullable;

public class CrossProcessSynchronizingIndexedCache<K, V>
implements MultiProcessSafeIndexedCache<K, V> {
    private final CrossProcessCacheAccess cacheAccess;
    private final MultiProcessSafeAsyncPersistentIndexedCache<K, V> target;

    public CrossProcessSynchronizingIndexedCache(MultiProcessSafeAsyncPersistentIndexedCache<K, V> target, CrossProcessCacheAccess cacheAccess) {
        this.target = target;
        this.cacheAccess = cacheAccess;
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public @Nullable V getIfPresent(K key) {
        return (V)this.cacheAccess.withFileLock(() -> this.target.get(key));
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> producer) {
        Runnable runnable = this.cacheAccess.acquireFileLock();
        return this.target.get((K)key, producer, runnable);
    }

    @Override
    public void put(K key, V value) {
        Runnable runnable = this.cacheAccess.acquireFileLock();
        this.target.putLater(key, value, runnable);
    }

    @Override
    public void remove(K key) {
        Runnable runnable = this.cacheAccess.acquireFileLock();
        this.target.removeLater(key, runnable);
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        this.target.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.target.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.target.beforeLockRelease(currentCacheState);
    }
}

