[![Build Status](https://github.com/gap-packages/numericalsgps/workflows/CI/badge.svg?branch=master)](https://github.com/gap-packages/numericalsgps/actions?query=workflow%3ACI+branch%3Amaster)
[![Code Coverage](https://codecov.io/github/gap-packages/numericalsgps/coverage.svg?branch=master&token=)](https://codecov.io/gh/gap-packages/numericalsgps)

NumericalSgps
=============

`NumericalSgps` is a GAP package for computing with Numerical Semigroups.


Introduction
------------

The features of the package `NumericalSgps` include

- defining numerical semigroups;
- computing several properties of numerical semigroups, namely: multiplicity, Frobenius number, (minimal) system of generators, Apéry set, gaps, fundamental gaps, etc.;
- perform several operations on numerical semigroups and ideals, namely: intersection, quotient by an integer, decompose into irreducible semigroups, add a special gap, ...;
-computing and testing membership to relevant families of numerical semigroups.

There is a manual in the sub-directory `doc` written using the GAP package
gapdoc which describes the available functions in detail. The pdf, html
versions of the manual are also available there.

If you have used this package, please let us know by sending
us an email.  If you  have found important features missing or if there is a
bug, we would appreciate it very much if you send us an email.

The current maintainers of the package are:

Manuel Delgado			<mdelgado@fc.up.pt>

Pedro A. García-Sánchez		<pedro@ugr.es>

For the full list of contributors (and contributions), please refer to  to the [contributions](https://gap-packages.github.io/numericalsgps/doc/chapC.html) appendix in the manual.

Installation
------------
This package consists only of GAP code, so for its installation please refer to the [GAP manual](https://docs.gap-system.org/doc/ref/chap76.html#X82473E4B8756C6CD).


Acknowledgements and funding
----------------------------

Please refer to the [acknowledgements](https://gap-packages.github.io/numericalsgps/doc/chap0.html) section in the manual.


Papers using numericalsgps
--------------------------

A list can be found in [swmath](https://www.swmath.org/software/640).