/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;

public class HSLColorConverter {
    public static Color generateColorFromLong(long value) {
        float hue = (float)(value >> 8 & 0xFFFFFFL) / 1.6777215E7f;
        float lightness = 0.3f + (float)(value & 0xFFL) / 255.0f * 0.4f;
        float saturation = 1.0f;
        float adjustedHue = HSLColorConverter.adjustHueToYellow(hue);
        return HSLColorConverter.hslToRgb(adjustedHue, saturation, lightness);
    }

    public static float adjustHueToYellow(float x) {
        if (x < 0.11111111f) {
            return x * 1.0277778f;
        }
        if (x < 0.22222222f) {
            return 0.16666667f + (x - 0.16666667f) * 1.0f / 2.0f;
        }
        return 1.0f + (x - 1.0f) * 1.0357143f;
    }

    public static Color hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = HSLColorConverter.hueToRgb(p, q, h + 0.33333334f);
            g = HSLColorConverter.hueToRgb(p, q, h);
            b = HSLColorConverter.hueToRgb(p, q, h - 0.33333334f);
        }
        return new Color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static float lightness(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        int lightness = max + min;
        return (float)lightness / 512.0f;
    }
}

