/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class DoubleClickTimer {
    public static final int MAX_TIME_BETWEEN_CLICKS;
    private Timer timer;
    private int delay;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void start(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        this.cancel();
        if (this.delay == 0) {
            runnable.run();
            return;
        }
        this.timer = new Timer(this.delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DoubleClickTimer.this.timer = null;
                runnable.run();
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void cancel() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    static {
        Object p = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        MAX_TIME_BETWEEN_CLICKS = p instanceof Integer ? (Integer)p : 250;
    }
}

