// PartUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef PartUI_h
#define PartUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2023, Will Godfrey
// Copyright 2024-2025 Kristian Amlie, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code.


#include "UI/MiscGui.h"
    #include "EffUI.h"
    #include "BankUI.h"
    #include "ADnoteUI.h"
    #include "SUBnoteUI.h"
    #include "PADnoteUI.h"
    #include "UI/WidgetMWSlider.h"
    #include "UI/WidgetSpinner.h"
    #include "UI/WidgetCheckButton.h"
    #include "Params/Controller.h"
#include "Misc/Part.h"
    #define MAX_INFO_TEXT_SIZE 256
#include "UI/ScaleTrackedWindow.h"
#include "Interface/TextLists.h"

class PartUI_ {
public:
  virtual void showparameters(int /* kititem */,int /* engine */);
};
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Choice.H>

class PartKitItem : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *partkititem;
  Fl_Group *partkititemgroup;
  Fl_Check_Button2 *mutedcheck;
private:
  inline void cb_mutedcheck_i(Fl_Check_Button2*, void*);
  static void cb_mutedcheck(Fl_Check_Button2*, void*);
public:
  Fl_Button *labelbutton;
private:
  inline void cb_labelbutton_i(Fl_Button*, void*);
  static void cb_labelbutton(Fl_Button*, void*);
public:
  Fl_Counter *minkcounter;
private:
  inline void cb_minkcounter_i(Fl_Counter*, void*);
  static void cb_minkcounter(Fl_Counter*, void*);
public:
  Fl_Button *setmin;
private:
  inline void cb_setmin_i(Fl_Button*, void*);
  static void cb_setmin(Fl_Button*, void*);
public:
  Fl_Button *setmax;
private:
  inline void cb_setmax_i(Fl_Button*, void*);
  static void cb_setmax(Fl_Button*, void*);
public:
  Fl_Button *setfull;
private:
  inline void cb_setfull_i(Fl_Button*, void*);
  static void cb_setfull(Fl_Button*, void*);
public:
  Fl_Counter *maxkcounter;
private:
  inline void cb_maxkcounter_i(Fl_Counter*, void*);
  static void cb_maxkcounter(Fl_Counter*, void*);
public:
  Fl_Button *adeditbutton;
private:
  inline void cb_adeditbutton_i(Fl_Button*, void*);
  static void cb_adeditbutton(Fl_Button*, void*);
public:
  Fl_Check_Button2 *adcheck;
private:
  inline void cb_adcheck_i(Fl_Check_Button2*, void*);
  static void cb_adcheck(Fl_Check_Button2*, void*);
public:
  Fl_Button *subeditbutton;
private:
  inline void cb_subeditbutton_i(Fl_Button*, void*);
  static void cb_subeditbutton(Fl_Button*, void*);
public:
  Fl_Check_Button2 *subcheck;
private:
  inline void cb_subcheck_i(Fl_Check_Button2*, void*);
  static void cb_subcheck(Fl_Check_Button2*, void*);
public:
  Fl_Button *padeditbutton;
private:
  inline void cb_padeditbutton_i(Fl_Button*, void*);
  static void cb_padeditbutton(Fl_Button*, void*);
public:
  Fl_Check_Button2 *padcheck;
private:
  inline void cb_padcheck_i(Fl_Check_Button2*, void*);
  static void cb_padcheck(Fl_Check_Button2*, void*);
public:
  Fl_Choice *sendtoeffect;
private:
  inline void cb_sendtoeffect_i(Fl_Choice*, void*);
  static void cb_sendtoeffect(Fl_Choice*, void*);
public:
  Fl_Check_Button2 *enabledcheck;
private:
  inline void cb_enabledcheck_i(Fl_Check_Button2*, void*);
  static void cb_enabledcheck(Fl_Check_Button2*, void*);
public:
  void send_data(int action, int control, float value, int type, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int miscmsg = UNUSED);
  PartKitItem(int x,int y, int w, int h, const char *label=0);
  void clearLine();
  void init(Part *part_, int n_, int npart_, PartUI_ *partui_);
  void itemRtext(float dScale);
  ~PartKitItem();
  Part *part;
private:
  int n;
  int npart;
  char label[10];
  PartUI_ *partui;
  SynthEngine *synth;
};
#include <FL/Fl_Box.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Pack.H>

class PartUI : public Fl_Group, PartUI_ {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *instrumenteditwindow;
private:
  inline void cb_instrumenteditwindow_i(ScaleTrackedWindow*, void*);
  static void cb_instrumenteditwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Group *ADD;
  Fl_Check_Button2 *adsynenabledcheck;
private:
  inline void cb_adsynenabledcheck_i(Fl_Check_Button2*, void*);
  static void cb_adsynenabledcheck(Fl_Check_Button2*, void*);
public:
  Fl_Box *addbox;
  Fl_Button *adeditbutton;
private:
  inline void cb_adeditbutton1_i(Fl_Button*, void*);
  static void cb_adeditbutton1(Fl_Button*, void*);
public:
  Fl_Group *SUB;
  Fl_Check_Button2 *subsynenabledcheck;
private:
  inline void cb_subsynenabledcheck_i(Fl_Check_Button2*, void*);
  static void cb_subsynenabledcheck(Fl_Check_Button2*, void*);
public:
  Fl_Box *subbox;
  Fl_Button *subeditbutton;
private:
  inline void cb_subeditbutton1_i(Fl_Button*, void*);
  static void cb_subeditbutton1(Fl_Button*, void*);
public:
  Fl_Group *PAD;
  Fl_Check_Button2 *padsynenabledcheck;
private:
  inline void cb_padsynenabledcheck_i(Fl_Check_Button2*, void*);
  static void cb_padsynenabledcheck(Fl_Check_Button2*, void*);
public:
  Fl_Box *padbox;
  Fl_Button *padeditbutton;
private:
  inline void cb_padeditbutton1_i(Fl_Button*, void*);
  static void cb_padeditbutton1(Fl_Button*, void*);
public:
  Fl_Button *kitedit;
private:
  inline void cb_kitedit_i(Fl_Button*, void*);
  static void cb_kitedit(Fl_Button*, void*);
public:
  Fl_Button *effects;
private:
  inline void cb_effects_i(Fl_Button*, void*);
  static void cb_effects(Fl_Button*, void*);
public:
  Fl_Button *editAT;
private:
  inline void cb_editAT_i(Fl_Button*, void*);
  static void cb_editAT(Fl_Button*, void*);
public:
  Fl_Button *instrumentReset;
private:
  inline void cb_instrumentReset_i(Fl_Button*, void*);
  static void cb_instrumentReset(Fl_Button*, void*);
public:
  Fl_Button *editClose;
private:
  inline void cb_editClose_i(Fl_Button*, void*);
  static void cb_editClose(Fl_Button*, void*);
public:
  Fl_Text_Display *A_C_display;
  Fl_Button *A_C_default;
private:
  inline void cb_A_C_default_i(Fl_Button*, void*);
  static void cb_A_C_default(Fl_Button*, void*);
public:
  Fl_Input *copyright;
private:
  inline void cb_copyright_i(Fl_Input*, void*);
  static void cb_copyright(Fl_Input*, void*);
public:
  Fl_Input *commentField;
private:
  inline void cb_commentField_i(Fl_Input*, void*);
  static void cb_commentField(Fl_Input*, void*);
public:
  Fl_Choice *instrumentType;
private:
  inline void cb_instrumentType_i(Fl_Choice*, void*);
  static void cb_instrumentType(Fl_Choice*, void*);
public:
  Fl_Box *humaniseBox;
  Fl_Text_Display *humanise_display;
  mwheel_slider_rev *humanise;
private:
  inline void cb_humanise_i(mwheel_slider_rev*, void*);
  static void cb_humanise(mwheel_slider_rev*, void*);
public:
  mwheel_slider_rev *velocityhumanise;
private:
  inline void cb_velocityhumanise_i(mwheel_slider_rev*, void*);
  static void cb_velocityhumanise(mwheel_slider_rev*, void*);
public:
  Fl_Text_Display *originalname;
  Fl_Text_Display *originaltext;
  ScaleTrackedWindow *instrumentkitlist;
private:
  inline void cb_instrumentkitlist_i(ScaleTrackedWindow*, void*);
  static void cb_instrumentkitlist(ScaleTrackedWindow*, void*);
public:
  Fl_Group *kitlist;
  Fl_Pack *kitpack;
  Fl_Box *kitnum;
  Fl_Box *kitmute;
  Fl_Box *kitID;
  Fl_Box *kitminkey;
  Fl_Box *kitmaxkey;
  Fl_Text_Display *addON;
  Fl_Box *kitadd;
  Fl_Text_Display *subON;
  Fl_Box *kitsub;
  Fl_Text_Display *padON;
  Fl_Box *kitpad;
  Fl_Box *kitfxnum;
  Fl_Choice *kitMode;
private:
  inline void cb_kitMode_i(Fl_Choice*, void*);
  static void cb_kitMode(Fl_Choice*, void*);
public:
  Fl_Check_Button2 *drumMode;
private:
  inline void cb_drumMode_i(Fl_Check_Button2*, void*);
  static void cb_drumMode(Fl_Check_Button2*, void*);
public:
  Fl_Button *kitClose;
private:
  inline void cb_kitClose_i(Fl_Button*, void*);
  static void cb_kitClose(Fl_Button*, void*);
public:
  ScaleTrackedWindow *partfx;
private:
  inline void cb_partfx_i(ScaleTrackedWindow*, void*);
  static void cb_partfx(ScaleTrackedWindow*, void*);
public:
  WidgetSpinner *inseffnocounter;
private:
  inline void cb_inseffnocounter_i(WidgetSpinner*, void*);
  static void cb_inseffnocounter(WidgetSpinner*, void*);
public:
  Fl_Choice *insefftype;
private:
  inline void cb_insefftype_i(Fl_Choice*, void*);
  static void cb_insefftype(Fl_Choice*, void*);
public:
  Fl_Group *inseffectuigroup;
  EffUI *inseffectui;
  Fl_Choice *sendtochoice;
private:
  inline void cb_sendtochoice_i(Fl_Choice*, void*);
  static void cb_sendtochoice(Fl_Choice*, void*);
public:
  Fl_Button *effCopy;
private:
  inline void cb_effCopy_i(Fl_Button*, void*);
  static void cb_effCopy(Fl_Button*, void*);
public:
  Fl_Button *effPaste;
private:
  inline void cb_effPaste_i(Fl_Button*, void*);
  static void cb_effPaste(Fl_Button*, void*);
public:
  Fl_Check_Button2 *bypasseff;
private:
  inline void cb_bypasseff_i(Fl_Check_Button2*, void*);
  static void cb_bypasseff(Fl_Check_Button2*, void*);
public:
  Fl_Button *effClose;
private:
  inline void cb_effClose_i(Fl_Button*, void*);
  static void cb_effClose(Fl_Button*, void*);
// ctlmidi, ctlwindow, aftertouch control MUST be that order
public:
  ScaleTrackedWindow *ctlmidi;
  WidgetPDial *modulation;
private:
  inline void cb_modulation_i(WidgetPDial*, void*);
  static void cb_modulation(WidgetPDial*, void*);
public:
  WidgetPDial *expression;
private:
  inline void cb_expression_i(WidgetPDial*, void*);
  static void cb_expression(WidgetPDial*, void*);
public:
  WidgetPDial *filterq;
private:
  inline void cb_filterq_i(WidgetPDial*, void*);
  static void cb_filterq(WidgetPDial*, void*);
public:
  WidgetPDial *filtercutoff;
private:
  inline void cb_filtercutoff_i(WidgetPDial*, void*);
  static void cb_filtercutoff(WidgetPDial*, void*);
public:
  WidgetPDial *masterbandwidth;
private:
  inline void cb_masterbandwidth_i(WidgetPDial*, void*);
  static void cb_masterbandwidth(WidgetPDial*, void*);
public:
  Fl_Button *ctlmidiclose;
private:
  inline void cb_ctlmidiclose_i(Fl_Button*, void*);
  static void cb_ctlmidiclose(Fl_Button*, void*);
public:
  ScaleTrackedWindow *ctlwindow;
private:
  inline void cb_ctlwindow_i(ScaleTrackedWindow*, void*);
  static void cb_ctlwindow(ScaleTrackedWindow*, void*);
public:
  WidgetPDial *volrng;
private:
  inline void cb_volrng_i(WidgetPDial*, void*);
  static void cb_volrng(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *vol;
private:
  inline void cb_vol_i(Fl_Check_Button2*, void*);
  static void cb_vol(Fl_Check_Button2*, void*);
public:
  WidgetPDial *panwidth;
private:
  inline void cb_panwidth_i(WidgetPDial*, void*);
  static void cb_panwidth(WidgetPDial*, void*);
public:
  WidgetPDial *modwh;
private:
  inline void cb_modwh_i(WidgetPDial*, void*);
  static void cb_modwh(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *expmwh;
private:
  inline void cb_expmwh_i(Fl_Check_Button2*, void*);
  static void cb_expmwh(Fl_Check_Button2*, void*);
public:
  WidgetPDial *bwdpth;
private:
  inline void cb_bwdpth_i(WidgetPDial*, void*);
  static void cb_bwdpth(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *expbw;
private:
  inline void cb_expbw_i(Fl_Check_Button2*, void*);
  static void cb_expbw(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *expr;
private:
  inline void cb_expr_i(Fl_Check_Button2*, void*);
  static void cb_expr(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *fmamp;
private:
  inline void cb_fmamp_i(Fl_Check_Button2*, void*);
  static void cb_fmamp(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *sustain;
private:
  inline void cb_sustain_i(Fl_Check_Button2*, void*);
  static void cb_sustain(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *breath;
private:
  inline void cb_breath_i(Fl_Check_Button2*, void*);
  static void cb_breath(Fl_Check_Button2*, void*);
public:
  Fl_Box *pwheelrnglabel;
  Fl_Counter *pwheelbrng;
private:
  inline void cb_pwheelbrng_i(Fl_Counter*, void*);
  static void cb_pwheelbrng(Fl_Counter*, void*);
public:
  WidgetPDial *filtq;
private:
  inline void cb_filtq_i(WidgetPDial*, void*);
  static void cb_filtq(WidgetPDial*, void*);
public:
  WidgetPDial *fltcut;
private:
  inline void cb_fltcut_i(WidgetPDial*, void*);
  static void cb_fltcut(WidgetPDial*, void*);
public:
  Fl_Group *ctlresonance;
  WidgetPDial *cfdpth;
private:
  inline void cb_cfdpth_i(WidgetPDial*, void*);
  static void cb_cfdpth(WidgetPDial*, void*);
public:
  WidgetPDial *rbwdpth;
private:
  inline void cb_rbwdpth_i(WidgetPDial*, void*);
  static void cb_rbwdpth(WidgetPDial*, void*);
public:
  Fl_Box *threshlabel;
  Fl_Group *ctlportamento;
  Fl_Box *ctlx100;
  WidgetPDial *prtime;
private:
  inline void cb_prtime_i(WidgetPDial*, void*);
  static void cb_prtime(WidgetPDial*, void*);
public:
  WidgetPDial *timedu;
private:
  inline void cb_timedu_i(WidgetPDial*, void*);
  static void cb_timedu(WidgetPDial*, void*);
public:
  Fl_Counter *thresh;
private:
  inline void cb_thresh_i(Fl_Counter*, void*);
  static void cb_thresh(Fl_Counter*, void*);
public:
  Fl_Check_Button2 *thtype;
private:
  inline void cb_thtype_i(Fl_Check_Button2*, void*);
  static void cb_thtype(Fl_Check_Button2*, void*);
public:
  WidgetPDial *propta;
private:
  inline void cb_propta_i(WidgetPDial*, void*);
  static void cb_propta(WidgetPDial*, void*);
public:
  WidgetPDial *proptb;
private:
  inline void cb_proptb_i(WidgetPDial*, void*);
  static void cb_proptb(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *rcv;
private:
  inline void cb_rcv_i(Fl_Check_Button2*, void*);
  static void cb_rcv(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *proprt;
private:
  inline void cb_proprt_i(Fl_Check_Button2*, void*);
  static void cb_proprt(Fl_Check_Button2*, void*);
public:
  Fl_Button *resetallctl;
private:
  inline void cb_resetallctl_i(Fl_Button*, void*);
  static void cb_resetallctl(Fl_Button*, void*);
public:
  Fl_Button *aftertouch;
private:
  inline void cb_aftertouch_i(Fl_Button*, void*);
  static void cb_aftertouch(Fl_Button*, void*);
public:
  Fl_Button *ctlclose;
private:
  inline void cb_ctlclose_i(Fl_Button*, void*);
  static void cb_ctlclose(Fl_Button*, void*);
public:
  ScaleTrackedWindow *aftertouchcontrol;
private:
  inline void cb_aftertouchcontrol_i(ScaleTrackedWindow*, void*);
  static void cb_aftertouchcontrol(ScaleTrackedWindow*, void*);
public:
  Fl_Box *ATchan;
  Fl_Button *channeloff;
private:
  inline void cb_channeloff_i(Fl_Button*, void*);
  static void cb_channeloff(Fl_Button*, void*);
public:
  Fl_Check_Button2 *channelfiltercutoff;
private:
  inline void cb_channelfiltercutoff_i(Fl_Check_Button2*, void*);
  static void cb_channelfiltercutoff(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelfilterCminus;
private:
  inline void cb_channelfilterCminus_i(Fl_Check_Button2*, void*);
  static void cb_channelfilterCminus(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelfilterQ;
private:
  inline void cb_channelfilterQ_i(Fl_Check_Button2*, void*);
  static void cb_channelfilterQ(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelfilterQminus;
private:
  inline void cb_channelfilterQminus_i(Fl_Check_Button2*, void*);
  static void cb_channelfilterQminus(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelpitchbend;
private:
  inline void cb_channelpitchbend_i(Fl_Check_Button2*, void*);
  static void cb_channelpitchbend(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelpitchBminus;
private:
  inline void cb_channelpitchBminus_i(Fl_Check_Button2*, void*);
  static void cb_channelpitchBminus(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelmodulation;
private:
  inline void cb_channelmodulation_i(Fl_Check_Button2*, void*);
  static void cb_channelmodulation(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *channelvolume;
private:
  inline void cb_channelvolume_i(Fl_Check_Button2*, void*);
  static void cb_channelvolume(Fl_Check_Button2*, void*);
public:
  Fl_Box *ATkey;
  Fl_Button *polyoff;
private:
  inline void cb_polyoff_i(Fl_Button*, void*);
  static void cb_polyoff(Fl_Button*, void*);
public:
  Fl_Check_Button2 *polyfiltercutoff;
private:
  inline void cb_polyfiltercutoff_i(Fl_Check_Button2*, void*);
  static void cb_polyfiltercutoff(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *polyfilterCminus;
private:
  inline void cb_polyfilterCminus_i(Fl_Check_Button2*, void*);
  static void cb_polyfilterCminus(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *polyfilterQ;
private:
  inline void cb_polyfilterQ_i(Fl_Check_Button2*, void*);
  static void cb_polyfilterQ(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *polyfilterQminus;
private:
  inline void cb_polyfilterQminus_i(Fl_Check_Button2*, void*);
  static void cb_polyfilterQminus(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *polypitchbend;
private:
  inline void cb_polypitchbend_i(Fl_Check_Button2*, void*);
  static void cb_polypitchbend(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *polypitchBminus;
private:
  inline void cb_polypitchBminus_i(Fl_Check_Button2*, void*);
  static void cb_polypitchBminus(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *polymodulation;
private:
  inline void cb_polymodulation_i(Fl_Check_Button2*, void*);
  static void cb_polymodulation(Fl_Check_Button2*, void*);
public:
  Fl_Button *atClose;
private:
  inline void cb_atClose_i(Fl_Button*, void*);
  static void cb_atClose(Fl_Button*, void*);
public:
  void send_data(int action, int control, float value, int type, int npart, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int miscmsg = UNUSED);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED, int request = UNUSED);
  void returns_update(CommandBlock *getData);
  void paste(CommandBlock *getData);
  PartUI(int x,int y, int w, int h, const char *label=0);
  void rebuild(int npart_);
  void fillInstrumentType();
  void editrefresh();
  void effectsrefresh();
  void kitrefresh();
  void controllersrefresh();
  void ctlmidirefresh();
  void ATrefresh();
  void fetchChannel();
  void fetchKey();
  void setATchannel(int type, int state);
  void setATkey(int type, int state);
  void init(Part *part_,int npart_,BankUI *bankui_);
  void checkEngines(string instrumentName = "");
  void showparameters(int kititem, int engine);
  void setinstrumentlabel(string text = "");
  void refreshEffUI();
  void seteditname();
  void Showedit();
  void Showctl();
  void ShowAT();
  void Showctlmidi();
  void Showefx();
  void Showkit();
  void wincheck();
  void theme();
  void editRtext();
  void ctlRtext();
  void ATRtext();
  void ctlmidiRtext();
  void fxRtext();
  void kitRtext(bool force = false);
  ~PartUI();
  Part *part;
private:
  BankUI *bankui;
public:
  ADnoteUI *adnoteui;
  SUBnoteUI *subnoteui;
  PADnoteUI *padnoteui;
  int npart;
  int lastkititem;
  string partname;
  string kitname;
  PartKitItem *partkititem[NUM_KIT_ITEMS];
private:
  SynthEngine *synth;
  int *plgroup;
  int engine;
public:
  bool partKitOn;
private:
  int lastkey;
  int channelATselection;
  int keyATselection;
public:
  float midiDW;
  float midiDH;
private:
  bool ctlmidiSeen;
public:
  float atDW;
  float atDH;
private:
  int atSeen;
public:
  float ctlDW;
  float ctlDH;
private:
  int lastctlW;
  bool ctlSeen;
public:
  float fxDW;
  float fxDH;
private:
  bool fxSeen;
public:
  float editDW;
  float editDH;
private:
  int lasteditW;
  bool editSeen;
public:
  float kitDW;
  float kitDH;
private:
  bool kitSeen;
  int lastfxW;
  int lastDynFiltW;
  int lastkitW;
  int lastmidiW;
  int lastatW;
};
#endif
