/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __XDP_SAMPLE_SKEL_H__
#define __XDP_SAMPLE_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct xdp_sample {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *tp_xdp_cpumap_kthread;
	} progs;
	struct {
		struct bpf_link *tp_xdp_cpumap_kthread;
	} links;

#ifdef __cplusplus
	static inline struct xdp_sample *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct xdp_sample *open_and_load();
	static inline int load(struct xdp_sample *skel);
	static inline int attach(struct xdp_sample *skel);
	static inline void detach(struct xdp_sample *skel);
	static inline void destroy(struct xdp_sample *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
xdp_sample__destroy(struct xdp_sample *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
xdp_sample__create_skeleton(struct xdp_sample *obj);

static inline struct xdp_sample *
xdp_sample__open_opts(const struct bpf_object_open_opts *opts)
{
	struct xdp_sample *obj;
	int err;

	obj = (struct xdp_sample *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = xdp_sample__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	xdp_sample__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct xdp_sample *
xdp_sample__open(void)
{
	return xdp_sample__open_opts(NULL);
}

static inline int
xdp_sample__load(struct xdp_sample *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct xdp_sample *
xdp_sample__open_and_load(void)
{
	struct xdp_sample *obj;
	int err;

	obj = xdp_sample__open();
	if (!obj)
		return NULL;
	err = xdp_sample__load(obj);
	if (err) {
		xdp_sample__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
xdp_sample__attach(struct xdp_sample *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
xdp_sample__detach(struct xdp_sample *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *xdp_sample__elf_bytes(size_t *sz);

static inline int
xdp_sample__create_skeleton(struct xdp_sample *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "xdp_sample";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "xdp_samp.rodata";
	map->map = &obj->maps.rodata;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "tp_xdp_cpumap_kthread";
	s->progs[0].prog = &obj->progs.tp_xdp_cpumap_kthread;
	s->progs[0].link = &obj->links.tp_xdp_cpumap_kthread;

	s->data = xdp_sample__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *xdp_sample__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x13\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x1c\0\x01\
\0\x79\x12\x20\0\0\0\0\0\x79\x13\0\0\0\0\0\0\x79\x14\x08\0\0\0\0\0\x79\x15\x10\
\0\0\0\0\0\x79\x11\x18\0\0\0\0\0\x67\x01\0\0\x20\0\0\0\xc7\x01\0\0\x20\0\0\0\
\x7b\x1a\xf0\xff\0\0\0\0\x67\x05\0\0\x20\0\0\0\x77\x05\0\0\x20\0\0\0\x7b\x5a\
\xe8\xff\0\0\0\0\x67\x04\0\0\x20\0\0\0\x77\x04\0\0\x20\0\0\0\x7b\x4a\xe0\xff\0\
\0\0\0\x67\x03\0\0\x20\0\0\0\xc7\x03\0\0\x20\0\0\0\x7b\x3a\xd8\xff\0\0\0\0\x61\
\x21\x04\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xd8\
\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\x02\0\0\x17\0\0\0\xb4\x04\
\0\0\x28\0\0\0\x85\0\0\0\xb1\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x47\x50\
\x4c\0\x53\x74\x61\x74\x73\x3a\x20\x25\x64\x20\x25\x75\x20\x25\x75\x20\x25\x64\
\x20\x25\x64\x0a\0\xdd\0\0\0\x05\0\x08\0\x07\0\0\0\x1c\0\0\0\x22\0\0\0\x84\0\0\
\0\x96\0\0\0\xa8\0\0\0\xaf\0\0\0\xc2\0\0\0\x04\0\x28\x01\x51\0\x04\x28\x50\x0c\
\x7a\0\x93\x10\x7a\x10\x93\x08\x7a\x18\x93\x10\x04\x50\x58\x0a\x93\x08\x7a\x08\
\x93\x08\x7a\x10\x93\x18\x04\x58\x68\x04\x7a\0\x93\x10\x04\x68\x70\x08\x7a\0\
\x93\x08\x7a\x08\x93\x20\x04\x70\x88\x01\x0a\x93\x08\x7a\x08\x93\x08\x7a\x10\
\x93\x18\x04\x88\x01\x98\x01\x0c\x7a\0\x93\x18\x7a\x18\x93\x08\x7a\x20\x93\x08\
\x04\x98\x01\xe0\x01\x08\x7a\0\x93\x20\x7a\x20\x93\x08\0\x04\x28\x78\x0d\x73\0\
\xa8\xab\x80\x80\0\xa8\xaf\x80\x80\0\x9f\0\x04\x28\x30\x0d\x71\0\xa8\xab\x80\
\x80\0\xa8\xaf\x80\x80\0\x9f\0\x04\x28\xc0\x01\x01\x52\0\x04\x50\xd0\x01\x0d\
\x75\0\xa8\xab\x80\x80\0\xa8\xaf\x80\x80\0\x9f\0\x04\x68\xc8\x01\x0d\x74\0\xa8\
\xab\x80\x80\0\xa8\xaf\x80\x80\0\x9f\0\x01\x11\x01\x25\x25\x13\x05\x03\x25\x72\
\x17\x10\x17\x1b\x25\x11\x1b\x12\x06\x73\x17\x74\x17\x8c\x01\x17\0\0\x02\x24\0\
\x03\x25\x3e\x0b\x0b\x0b\0\0\x03\x34\0\x03\x25\x49\x13\x3f\x19\x3a\x0b\x3b\x0b\
\x02\x18\0\0\x04\x01\x01\x49\x13\0\0\x05\x21\0\x49\x13\x37\x0b\0\0\x06\x24\0\
\x03\x25\x0b\x0b\x3e\x0b\0\0\x07\x2e\x01\0\0\x08\x34\0\x03\x25\x49\x13\x3a\x0b\
\x3b\x0b\x02\x18\0\0\x09\x26\0\x49\x13\0\0\x0a\x34\0\x03\x25\x49\x13\x3a\x0b\
\x3b\x05\0\0\x0b\x0f\0\x49\x13\0\0\x0c\x15\x01\x49\x13\x27\x19\0\0\x0d\x05\0\
\x49\x13\0\0\x0e\x16\0\x49\x13\x03\x25\x3a\x0b\x3b\x0b\0\0\x0f\x26\0\0\0\x10\
\x2e\x01\x03\x25\x3a\x0b\x3b\x0b\x27\x19\x49\x13\x20\x21\x01\0\0\x11\x05\0\x03\
\x25\x3a\x0b\x3b\x0b\x49\x13\0\0\x12\x34\0\x03\x25\x3a\x0b\x3b\x0b\x49\x13\0\0\
\x13\x13\x01\x03\x25\x0b\x0b\x3a\x0b\x3b\x0b\0\0\x14\x0d\0\x03\x25\x49\x13\x3a\
\x0b\x3b\x0b\x38\x0b\0\0\x15\x2e\x01\x11\x1b\x12\x06\x40\x18\x7a\x19\x03\x25\
\x3a\x0b\x3b\x0b\x27\x19\x49\x13\x3f\x19\0\0\x16\x05\0\x02\x22\x03\x25\x3a\x0b\
\x3b\x0b\x49\x13\0\0\x17\x1d\x01\x31\x13\x55\x23\x58\x0b\x59\x0b\x57\x0b\0\0\
\x18\x05\0\x02\x22\x31\x13\0\0\x19\x34\0\x02\x22\x31\x13\0\0\0\x7c\x01\0\0\x05\
\0\x01\x08\0\0\0\0\x01\0\x1d\0\x01\x08\0\0\0\0\0\0\0\x02\x02\xe0\0\0\0\x08\0\0\
\0\x0c\0\0\0\x0c\0\0\0\x02\x1a\x07\x08\x02\x19\x07\x04\x03\x03\x3e\0\0\0\0\x1b\
\x02\xa1\0\x04\x4a\0\0\0\x05\x4e\0\0\0\x04\0\x02\x04\x06\x01\x06\x05\x08\x07\
\x07\x08\x06\x5f\0\0\0\0\x12\x02\xa1\x01\0\x04\x6b\0\0\0\x05\x4e\0\0\0\x17\0\
\x09\x4a\0\0\0\x0a\x07\x79\0\0\0\x02\x4a\x10\x09\x7e\0\0\0\x0b\x83\0\0\0\x0c\
\x9d\0\0\0\x0d\xa1\0\0\0\x0d\xa6\0\0\0\x0d\xb2\0\0\0\x0d\xa6\0\0\0\0\x02\x08\
\x05\x08\x0b\x6b\0\0\0\x0e\xae\0\0\0\x0a\x01\x1b\x02\x09\x07\x04\x0b\xb7\0\0\0\
\x0f\x10\x0b\0\x0f\xf9\0\0\0\x11\x0d\0\x0f\xfd\0\0\0\x11\x0f\0\x0f\xf9\0\0\0\
\x11\x10\0\x0f\xae\0\0\0\x11\x11\0\x0f\xae\0\0\0\x11\x12\0\x0f\xf9\0\0\0\x11\
\x13\0\x0f\x06\x01\0\0\x12\x18\0\x13\x2c\x01\0\0\0\x02\x0c\x05\x04\x0b\x02\x01\
\0\0\x02\x0e\x07\x08\x0b\x0b\x01\0\0\x13\x17\x0c\x03\x0c\x14\x14\xae\0\0\0\x03\
\x0d\0\x14\x15\xae\0\0\0\x03\x0e\x04\x14\x16\xae\0\0\0\x03\x0f\x08\0\x04\x02\
\x01\0\0\x05\x4e\0\0\0\x05\0\x15\x02\xe0\0\0\0\x01\x5a\x1b\0\x0f\xf9\0\0\0\x16\
\0\x0d\0\x0f\xfd\0\0\0\x17\xb8\0\0\0\0\0\x0f\x05\x18\x02\xc8\0\0\0\x18\x06\xd0\
\0\0\0\x18\x05\xd8\0\0\0\x18\x03\xe0\0\0\0\x18\x04\xe8\0\0\0\x19\x01\xf0\0\0\0\
\0\0\0\x17\0\0\0\x05\0\x08\0\x01\0\0\0\x04\0\0\0\x04\x28\x40\x04\x50\x58\x04\
\x68\xd0\x01\0\x74\0\0\0\x05\0\0\0\0\0\0\0\x15\0\0\0\x26\0\0\0\x58\0\0\0\x61\0\
\0\0\x66\0\0\0\x7a\0\0\0\x7e\0\0\0\x90\0\0\0\x95\0\0\0\xa2\0\0\0\xa8\0\0\0\xc2\
\0\0\0\xc6\0\0\0\xca\0\0\0\xdd\0\0\0\xe4\0\0\0\xee\0\0\0\xf4\0\0\0\xfa\0\0\0\
\x04\x01\0\0\x0d\x01\0\0\x12\x01\0\0\x17\x01\0\0\x28\x01\0\0\x2d\x01\0\0\x40\
\x01\0\0\x53\x01\0\0\x63\x6c\x61\x6e\x67\x20\x76\x65\x72\x73\x69\x6f\x6e\x20\
\x32\x31\x2e\x31\x2e\x36\0\x78\x64\x70\x5f\x73\x61\x6d\x70\x6c\x65\x2e\x62\x70\
\x66\x2e\x63\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\
\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\
\x31\x2e\x36\x2e\x30\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\0\x5f\x6c\x69\x63\x65\
\x6e\x73\x65\0\x63\x68\x61\x72\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\
\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x66\x6d\x74\0\x62\x70\x66\x5f\x74\x72\x61\
\x63\x65\x5f\x76\x70\x72\x69\x6e\x74\x6b\0\x6c\x6f\x6e\x67\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x5f\x5f\x75\x33\x32\0\x5f\x5f\x5f\x5f\x74\
\x70\x5f\x78\x64\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\x68\x72\x65\x61\
\x64\0\x69\x6e\x74\0\x63\x74\x78\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\
\x6e\x67\x20\x6c\x6f\x6e\x67\0\x6d\x61\x70\x5f\x69\x64\0\x70\x72\x6f\x63\x65\
\x73\x73\x65\x64\0\x64\x72\x6f\x70\x73\0\x73\x63\x68\x65\x64\0\x78\x64\x70\x5f\
\x73\x74\x61\x74\x73\0\x72\x65\x64\x69\x72\x65\x63\x74\0\x70\x61\x73\x73\0\x64\
\x72\x6f\x70\0\x78\x64\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x73\x74\x61\x74\x73\
\0\x61\x72\x67\x73\0\x44\x57\x5f\x41\x54\x45\x5f\x75\x6e\x73\x69\x67\x6e\x65\
\x64\x5f\x33\x32\0\x44\x57\x5f\x41\x54\x45\x5f\x75\x6e\x73\x69\x67\x6e\x65\x64\
\x5f\x36\x34\0\x74\x70\x5f\x78\x64\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\
\x68\x72\x65\x61\x64\0\x1c\0\0\0\x05\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x38\x01\0\0\x38\x01\0\0\x14\
\x01\0\0\0\0\0\0\0\0\0\x02\x02\0\0\0\x01\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\
\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x01\0\0\0\x18\0\0\0\0\0\0\x01\x04\0\0\0\
\x20\0\0\x01\x1c\0\0\0\x01\0\0\x0c\x03\0\0\0\x8f\0\0\0\x03\0\0\x04\x0c\0\0\0\
\xa0\0\0\0\x07\0\0\0\0\0\0\0\xa9\0\0\0\x07\0\0\0\x20\0\0\0\xae\0\0\0\x07\0\0\0\
\x40\0\0\0\xb3\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\xc4\0\0\0\0\0\0\x01\x01\0\0\
\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x08\0\0\0\x0a\0\0\0\x04\0\0\0\xc9\0\0\
\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\xdd\0\0\0\0\0\0\x0e\x09\0\0\0\x01\0\0\0\0\0\0\
\0\0\0\0\x0a\x08\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x0c\0\0\0\x0a\0\0\0\x17\0\0\0\
\xe6\0\0\0\0\0\0\x0e\x0d\0\0\0\0\0\0\0\x04\x01\0\0\x01\0\0\x0f\0\0\0\0\x0e\0\0\
\0\0\0\0\0\x17\0\0\0\x0c\x01\0\0\x01\0\0\x0f\0\0\0\0\x0b\0\0\0\0\0\0\0\x04\0\0\
\0\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\
\x63\x74\x78\0\x69\x6e\x74\0\x74\x70\x5f\x78\x64\x70\x5f\x63\x70\x75\x6d\x61\
\x70\x5f\x6b\x74\x68\x72\x65\x61\x64\0\x74\x70\x5f\x62\x74\x66\x2f\x78\x64\x70\
\x5f\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\x68\x72\x65\x61\x64\0\x2f\x75\x73\x72\
\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\x67\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\
\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2d\x31\x2e\x36\x2e\x30\x2f\x6c\
\x69\x62\x2f\x75\x74\x69\x6c\x2f\x78\x64\x70\x5f\x73\x61\x6d\x70\x6c\x65\x2e\
\x62\x70\x66\x2e\x63\0\x78\x64\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x73\x74\x61\
\x74\x73\0\x72\x65\x64\x69\x72\x65\x63\x74\0\x70\x61\x73\x73\0\x64\x72\x6f\x70\
\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x30\x3a\x31\0\x63\x68\x61\
\x72\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\
\x5f\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x5f\x5f\x5f\x5f\x74\x70\x5f\x78\x64\
\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\x68\x72\x65\x61\x64\x2e\x66\x6d\
\x74\0\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\x9f\xeb\x01\
\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\0\xdc\0\0\0\xf0\0\0\0\x1c\0\0\0\x08\0\0\
\0\x32\0\0\0\x01\0\0\0\0\0\0\0\x05\0\0\0\x10\0\0\0\x32\0\0\0\x0d\0\0\0\0\0\0\0\
\x4c\0\0\0\0\0\0\0\x05\x3c\0\0\x28\0\0\0\x4c\0\0\0\0\0\0\0\x1d\x50\0\0\x38\0\0\
\0\x4c\0\0\0\0\0\0\0\x1e\x4c\0\0\x40\0\0\0\x4c\0\0\0\0\0\0\0\x05\x3c\0\0\x50\0\
\0\0\x4c\0\0\0\0\0\0\0\x1e\x4c\0\0\x58\0\0\0\x4c\0\0\0\0\0\0\0\x05\x3c\0\0\x68\
\0\0\0\x4c\0\0\0\0\0\0\0\x1e\x4c\0\0\x70\0\0\0\x4c\0\0\0\0\0\0\0\x03\x50\0\0\
\x80\0\0\0\x4c\0\0\0\0\0\0\0\x1e\x4c\0\0\x88\0\0\0\x4c\0\0\0\0\0\0\0\x2f\x50\0\
\0\x90\0\0\0\x4c\0\0\0\0\0\0\0\x1e\x4c\0\0\xa8\0\0\0\x4c\0\0\0\0\0\0\0\x02\x5c\
\0\0\xd0\0\0\0\x4c\0\0\0\0\0\0\0\x05\x3c\0\0\x10\0\0\0\x32\0\0\0\x01\0\0\0\x88\
\0\0\0\x06\0\0\0\xc0\0\0\0\0\0\0\0\x0c\0\0\0\xff\xff\xff\xff\x04\0\x08\0\x08\
\x7c\x0b\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\xcb\0\0\0\x05\0\
\x08\0\x7e\0\0\0\x08\x01\x01\xfb\x0e\x0d\0\x01\x01\x01\x01\0\0\0\x01\0\0\x01\
\x01\x01\x1f\x03\0\0\0\0\x32\0\0\0\x37\0\0\0\x03\x01\x1f\x02\x0f\x05\x1e\x04\
\x49\0\0\0\0\xf9\x1a\x4e\xe5\x5e\xd1\x64\x99\x7d\x5c\x3d\x47\xf0\xf5\x29\xc4\
\x5a\0\0\0\x01\xb8\x10\xf2\x70\x73\x3e\x10\x63\x19\xb6\x7e\xf5\x12\xc6\x24\x6e\
\x79\0\0\0\x01\x11\xf0\x96\x23\xd7\x23\0\x81\x24\x7a\xfa\xcd\xc7\xc1\xa6\x41\
\x97\0\0\0\x02\x0e\xca\x27\x36\x9e\x78\xbb\x57\xf0\xef\xa8\xf0\x77\xa3\x05\x99\
\x04\0\x05\x05\x0a\0\x09\x02\0\0\0\0\0\0\0\0\x03\x0e\x01\x05\x1d\x5d\x05\x1e\
\x2d\x05\x05\x1c\x05\x1e\x32\x05\x05\x1c\x05\x1e\x32\x05\x03\x21\x05\x1e\x2d\
\x05\x2f\x21\x05\x1e\x1f\x06\x03\x6d\x20\x05\x02\x06\x03\x17\x2e\x05\x05\x03\
\x78\x58\x02\x02\0\x01\x01\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\
\x67\x2f\x78\x64\x70\x2d\x74\x6f\x6f\x6c\x73\x2f\x78\x64\x70\x2d\x74\x6f\x6f\
\x6c\x73\x2d\x31\x2e\x36\x2e\x30\x2f\x6c\x69\x62\x2f\x75\x74\x69\x6c\0\x2f\x75\
\x73\x72\0\x2e\x2e\x2f\x2e\x2e\x2f\x68\x65\x61\x64\x65\x72\x73\x2f\x62\x70\x66\
\0\x78\x64\x70\x5f\x73\x61\x6d\x70\x6c\x65\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\
\x63\x6c\x75\x64\x65\x2f\x61\x73\x6d\x2d\x67\x65\x6e\x65\x72\x69\x63\x2f\x69\
\x6e\x74\x2d\x6c\x6c\x36\x34\x2e\x68\0\x69\x6e\x63\x6c\x75\x64\x65\x2f\x62\x70\
\x66\x2f\x62\x70\x66\x5f\x68\x65\x6c\x70\x65\x72\x5f\x64\x65\x66\x73\x2e\x68\0\
\x76\x6d\x6c\x69\x6e\x75\x78\x2e\x68\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x1e\x01\0\0\x04\0\xf1\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\
\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x22\0\0\0\x01\0\x06\0\0\0\0\0\0\0\0\0\
\x17\0\0\0\0\0\0\0\0\0\0\0\x03\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x03\0\x07\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x08\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x03\0\x0c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0e\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x03\0\x15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x17\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x19\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xea\0\0\
\0\x12\0\x03\0\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\xc0\0\0\0\x11\0\x05\0\0\0\0\0\
\0\0\0\0\x04\0\0\0\0\0\0\0\xa8\0\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\x08\0\0\0\0\0\
\0\0\x03\0\0\0\x06\0\0\0\x11\0\0\0\0\0\0\0\x03\0\0\0\x08\0\0\0\x15\0\0\0\0\0\0\
\0\x03\0\0\0\x0c\0\0\0\x1f\0\0\0\0\0\0\0\x03\0\0\0\x0a\0\0\0\x23\0\0\0\0\0\0\0\
\x03\0\0\0\x07\0\0\0\x27\0\0\0\0\0\0\0\x03\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x0c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x10\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x14\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x18\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x1c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x20\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x24\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x28\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x2c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x30\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x34\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x38\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x3c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x44\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x48\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x4c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x50\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x54\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x58\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x5c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x60\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x64\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x68\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x6c\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x70\0\0\0\0\0\0\0\
\x03\0\0\0\x09\0\0\0\x74\0\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\
\x02\0\0\0\x0f\0\0\0\x10\0\0\0\0\0\0\0\x02\0\0\0\x04\0\0\0\x18\0\0\0\0\0\0\0\
\x02\0\0\0\x02\0\0\0\x30\x01\0\0\0\0\0\0\x03\0\0\0\x04\0\0\0\x48\x01\0\0\0\0\0\
\0\x04\0\0\0\x0f\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x40\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x50\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x60\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x70\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x80\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x90\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa0\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc0\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe0\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\0\x01\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x1c\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x14\0\0\0\0\0\0\0\
\x03\0\0\0\x0b\0\0\0\x18\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\x22\0\0\0\0\0\0\0\
\x03\0\0\0\x0d\0\0\0\x26\0\0\0\0\0\0\0\x03\0\0\0\x0d\0\0\0\x2a\0\0\0\0\0\0\0\
\x03\0\0\0\x0d\0\0\0\x36\0\0\0\0\0\0\0\x03\0\0\0\x0d\0\0\0\x4b\0\0\0\0\0\0\0\
\x03\0\0\0\x0d\0\0\0\x60\0\0\0\0\0\0\0\x03\0\0\0\x0d\0\0\0\x75\0\0\0\0\0\0\0\
\x03\0\0\0\x0d\0\0\0\x92\0\0\0\0\0\0\0\x02\0\0\0\x02\0\0\0\x0e\x0f\x03\0\x2e\
\x64\x65\x62\x75\x67\x5f\x61\x62\x62\x72\x65\x76\0\x2e\x74\x65\x78\x74\0\x2e\
\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x5f\x5f\x5f\x5f\x74\x70\x5f\x78\
\x64\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\x68\x72\x65\x61\x64\x2e\x66\
\x6d\x74\0\x2e\x64\x65\x62\x75\x67\x5f\x72\x6e\x67\x6c\x69\x73\x74\x73\0\x2e\
\x64\x65\x62\x75\x67\x5f\x6c\x6f\x63\x6c\x69\x73\x74\x73\0\x2e\x72\x65\x6c\x2e\
\x64\x65\x62\x75\x67\x5f\x73\x74\x72\x5f\x6f\x66\x66\x73\x65\x74\x73\0\x2e\x64\
\x65\x62\x75\x67\x5f\x73\x74\x72\0\x2e\x64\x65\x62\x75\x67\x5f\x6c\x69\x6e\x65\
\x5f\x73\x74\x72\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\x75\x67\x5f\x61\x64\x64\x72\
\0\x2e\x72\x65\x6c\x2e\x64\x65\x62\x75\x67\x5f\x69\x6e\x66\x6f\0\x2e\x6c\x6c\
\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\
\x2e\x72\x65\x6c\x2e\x64\x65\x62\x75\x67\x5f\x6c\x69\x6e\x65\0\x2e\x72\x65\x6c\
\x2e\x64\x65\x62\x75\x67\x5f\x66\x72\x61\x6d\x65\0\x74\x70\x5f\x78\x64\x70\x5f\
\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\x68\x72\x65\x61\x64\0\x2e\x72\x65\x6c\x74\
\x70\x5f\x62\x74\x66\x2f\x78\x64\x70\x5f\x63\x70\x75\x6d\x61\x70\x5f\x6b\x74\
\x68\x72\x65\x61\x64\0\x78\x64\x70\x5f\x73\x61\x6d\x70\x6c\x65\x2e\x62\x70\x66\
\x2e\x63\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\
\x6f\x64\x61\x74\x61\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2f\x01\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xab\x11\0\0\0\0\0\0\x50\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x04\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\
\0\0\xe0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\
\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\x0d\0\0\0\0\0\0\x10\0\0\0\
\0\0\0\0\x1b\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xc1\0\0\0\x01\
\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x3f\x01\0\0\x01\0\0\0\x02\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x24\x01\0\0\0\0\0\0\x17\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x3b\x01\0\0\0\0\0\0\xe1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1c\
\x02\0\0\0\0\0\0\x36\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xa6\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x52\x03\0\0\0\0\0\
\0\x80\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa2\0\
\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\x0d\0\0\0\0\0\0\x60\0\0\0\
\0\0\0\0\x1b\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x40\0\0\0\x01\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd2\x04\0\0\0\0\0\0\x1b\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x64\0\0\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xed\x04\0\0\0\0\0\0\x78\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x08\x0e\0\0\0\0\0\0\xc0\x01\0\0\0\0\0\0\x1b\0\0\0\x0c\0\0\0\x08\0\0\
\0\0\0\0\0\x10\0\0\0\0\0\0\0\x77\0\0\0\x01\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x65\x05\0\0\0\0\0\0\x69\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\
\x01\0\0\0\0\0\0\0\x96\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xce\x06\
\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x92\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x0f\0\0\0\0\0\0\
\x30\0\0\0\0\0\0\0\x1b\0\0\0\x0f\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x4b\
\x01\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x06\0\0\0\0\0\0\x64\x02\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x47\x01\0\0\x09\
\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x0f\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\
\x1b\0\0\0\x11\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x19\0\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x54\x09\0\0\0\0\0\0\x2c\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x15\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x18\x10\0\0\0\0\0\0\xf0\0\0\0\0\0\0\0\x1b\0\0\0\x13\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xdd\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x80\x0a\0\0\0\0\0\0\x28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xd9\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\
\x11\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x1b\0\0\0\x15\0\0\0\x08\0\0\0\0\0\0\0\x10\0\
\0\0\0\0\0\0\xcd\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\x0a\0\0\0\
\0\0\0\xcf\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc9\
\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x28\x11\0\0\0\0\0\0\x80\0\0\
\0\0\0\0\0\x1b\0\0\0\x17\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x82\0\0\0\
\x01\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x77\x0b\0\0\0\0\0\0\xa1\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\xb2\0\0\0\x03\x4c\xff\
\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\xa8\x11\0\0\0\0\0\0\x03\0\0\0\0\0\0\0\
\x1b\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x37\x01\0\0\x02\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x0c\0\0\0\0\0\0\x80\x01\0\0\0\0\0\0\x01\0\0\0\
\x0e\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct xdp_sample *xdp_sample::open(const struct bpf_object_open_opts *opts) { return xdp_sample__open_opts(opts); }
struct xdp_sample *xdp_sample::open_and_load() { return xdp_sample__open_and_load(); }
int xdp_sample::load(struct xdp_sample *skel) { return xdp_sample__load(skel); }
int xdp_sample::attach(struct xdp_sample *skel) { return xdp_sample__attach(skel); }
void xdp_sample::detach(struct xdp_sample *skel) { xdp_sample__detach(skel); }
void xdp_sample::destroy(struct xdp_sample *skel) { xdp_sample__destroy(skel); }
const void *xdp_sample::elf_bytes(size_t *sz) { return xdp_sample__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
xdp_sample__assert(struct xdp_sample *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __XDP_SAMPLE_SKEL_H__ */
