/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoFrameMetadata.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(VIDEO)

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const VideoFrameMetadata& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.captureTime)) {
        auto captureTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.captureTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "captureTime"_s), captureTimeValue);
    }
    auto expectedDisplayTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.expectedDisplayTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "expectedDisplayTime"_s), expectedDisplayTimeValue);
    auto heightValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.height);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    auto mediaTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.mediaTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "mediaTime"_s), mediaTimeValue);
    auto presentationTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.presentationTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "presentationTime"_s), presentationTimeValue);
    auto presentedFramesValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.presentedFrames);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "presentedFrames"_s), presentedFramesValue);
    if (!IDLDouble::isNullValue(dictionary.processingDuration)) {
        auto processingDurationValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.processingDuration));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "processingDuration"_s), processingDurationValue);
    }
    if (!IDLDouble::isNullValue(dictionary.receiveTime)) {
        auto receiveTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.receiveTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "receiveTime"_s), receiveTimeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.rtpTimestamp)) {
        auto rtpTimestampValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, IDLUnsignedLong::extractValueFromNullable(dictionary.rtpTimestamp));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rtpTimestamp"_s), rtpTimestampValue);
    }
    auto widthValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.width);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(VIDEO)
