/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSTextTrackCue.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentFragment.h"
#include "JSEventListener.h"
#include "JSTextTrack.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTextTrackCuePrototypeFunction_getCueAsHTML);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_track);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_id);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrackCue_id);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_startTime);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrackCue_startTime);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_endTime);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrackCue_endTime);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_pauseOnExit);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrackCue_pauseOnExit);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_onenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrackCue_onenter);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackCue_onexit);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrackCue_onexit);

class JSTextTrackCuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextTrackCuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackCuePrototype>(vm)) JSTextTrackCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextTrackCuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextTrackCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextTrackCuePrototype, JSTextTrackCuePrototype::Base);

using JSTextTrackCueDOMConstructor = JSDOMConstructor<JSTextTrackCue>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSTextTrackCueDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSTextTrackCueDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "TextTrackCue"_s);
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto startTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (startTimeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto endTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (endTimeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto cueNodeConversionResult = convert<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "cueNode"_s, "TextTrackCue"_s, nullptr, "DocumentFragment"_s); });
    if (cueNodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = TextTrackCue::create(document.get(), startTimeConversionResult.releaseReturnValue(), endTimeConversionResult.releaseReturnValue(), *cueNodeConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<TextTrackCue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<TextTrackCue>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSTextTrackCueDOMConstructorConstruct, JSTextTrackCueDOMConstructor::construct);

template<> const ClassInfo JSTextTrackCueDOMConstructor::s_info = { "TextTrackCue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCueDOMConstructor) };

template<> JSValue JSTextTrackCueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSTextTrackCueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    int constructorLength = 3;
    if (!((&globalObject)->inherits<JSDOMWindowBase>() && downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settings().genericCueAPIEnabled()))
        constructorLength = 0;
    putDirect(vm, vm.propertyNames->length, jsNumber(constructorLength), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TextTrackCue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTextTrackCue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 9> JSTextTrackCuePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCueConstructor, 0 } },
    HashTableValue { "track"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_track, 0 } },
    HashTableValue { "id"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_id, setJSTextTrackCue_id } },
    HashTableValue { "startTime"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_startTime, setJSTextTrackCue_startTime } },
    HashTableValue { "endTime"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_endTime, setJSTextTrackCue_endTime } },
    HashTableValue { "pauseOnExit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_pauseOnExit, setJSTextTrackCue_pauseOnExit } },
    HashTableValue { "onenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_onenter, setJSTextTrackCue_onenter } },
    HashTableValue { "onexit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackCue_onexit, setJSTextTrackCue_onexit } },
    HashTableValue { "getCueAsHTML"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTextTrackCuePrototypeFunction_getCueAsHTML, 0 } },
};

const ClassInfo JSTextTrackCuePrototype::s_info = { "TextTrackCue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCuePrototype) };

void JSTextTrackCuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextTrackCue::info(), JSTextTrackCuePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().genericCueAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getCueAsHTML"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTextTrackCue::s_info = { "TextTrackCue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackCue) };

JSTextTrackCue::JSTextTrackCue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextTrackCue>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<TextTrackCue> JSTextTrackCue::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSTextTrackCue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTextTrackCuePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSTextTrackCuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSTextTrackCue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextTrackCue>(vm, globalObject);
}

JSValue JSTextTrackCue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackCueDOMConstructor, DOMConstructorID::TextTrackCue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextTrackCuePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextTrackCue::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsTextTrackCue_trackGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<TextTrack>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_track, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_trackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextTrackCue_idGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrackCue_idSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setId(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrackCue_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCue_idSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrackCue_startTimeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.startTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_startTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_startTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrackCue_startTimeSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setStartTime(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrackCue_startTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCue_startTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrackCue_endTimeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.endTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_endTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_endTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrackCue_endTimeSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setEndTime(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrackCue_endTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCue_endTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrackCue_pauseOnExitGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.pauseOnExit())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_pauseOnExit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_pauseOnExitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrackCue_pauseOnExitSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPauseOnExit(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrackCue_pauseOnExit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCue_pauseOnExitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrackCue_onenterGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().enterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_onenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_onenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrackCue_onenterSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().enterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrackCue_onenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCue_onenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrackCue_onexitGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().exitEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackCue_onexit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::get<jsTextTrackCue_onexitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrackCue_onexitSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrackCue& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().exitEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrackCue_onexit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrackCue>::set<setJSTextTrackCue_onexitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsTextTrackCuePrototypeFunction_getCueAsHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextTrackCue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCueAsHTML())));
}

JSC_DEFINE_HOST_FUNCTION(jsTextTrackCuePrototypeFunction_getCueAsHTML, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextTrackCue>::call<jsTextTrackCuePrototypeFunction_getCueAsHTMLBody>(*lexicalGlobalObject, *callFrame, "getCueAsHTML");
}

JSC::GCClient::IsoSubspace* JSTextTrackCue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTextTrackCue, UseCustomHeapCellType::No>(vm, "JSTextTrackCue"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTextTrackCue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTextTrackCue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTextTrackCue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTextTrackCue = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSTextTrackCue::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTextTrackCue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSTextTrackCue);

template<typename Visitor>
void JSTextTrackCue::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTextTrackCue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSTextTrackCue::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSTextTrackCue::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSTextTrackCue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextTrackCue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

void JSTextTrackCueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextTrackCue = static_cast<JSTextTrackCue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTextTrackCue->protectedWrapped().ptr(), jsTextTrackCue);
}

TextTrackCue* JSTextTrackCue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextTrackCue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
