/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSResizeObserverSize.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverSizeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverSize_inlineSize);
static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverSize_blockSize);

class JSResizeObserverSizePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSResizeObserverSizePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSResizeObserverSizePrototype* ptr = new (NotNull, JSC::allocateCell<JSResizeObserverSizePrototype>(vm)) JSResizeObserverSizePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverSizePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSResizeObserverSizePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverSizePrototype, JSResizeObserverSizePrototype::Base);

using JSResizeObserverSizeDOMConstructor = JSDOMConstructorNotConstructable<JSResizeObserverSize>;

template<> const ClassInfo JSResizeObserverSizeDOMConstructor::s_info = { "ResizeObserverSize"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverSizeDOMConstructor) };

template<> JSValue JSResizeObserverSizeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSResizeObserverSizeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ResizeObserverSize"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSResizeObserverSize::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSResizeObserverSizePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverSizeConstructor, 0 } },
    HashTableValue { "inlineSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverSize_inlineSize, 0 } },
    HashTableValue { "blockSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverSize_blockSize, 0 } },
};

const ClassInfo JSResizeObserverSizePrototype::s_info = { "ResizeObserverSize"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverSizePrototype) };

void JSResizeObserverSizePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSResizeObserverSize::info(), JSResizeObserverSizePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSResizeObserverSize::s_info = { "ResizeObserverSize"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverSize) };

JSResizeObserverSize::JSResizeObserverSize(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ResizeObserverSize>&& impl)
    : JSDOMWrapper<ResizeObserverSize>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ResizeObserverSize>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSResizeObserverSize::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSResizeObserverSizePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSResizeObserverSizePrototype::create(vm, &globalObject, structure);
}

JSObject* JSResizeObserverSize::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSResizeObserverSize>(vm, globalObject);
}

JSValue JSResizeObserverSize::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSResizeObserverSizeDOMConstructor, DOMConstructorID::ResizeObserverSize>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSResizeObserverSize::destroy(JSC::JSCell* cell)
{
    JSResizeObserverSize* thisObject = static_cast<JSResizeObserverSize*>(cell);
    thisObject->JSResizeObserverSize::~JSResizeObserverSize();
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverSizeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverSizePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSResizeObserverSize::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsResizeObserverSize_inlineSizeGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverSize& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.inlineSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverSize_inlineSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSResizeObserverSize>::get<jsResizeObserverSize_inlineSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsResizeObserverSize_blockSizeGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverSize& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.blockSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverSize_blockSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSResizeObserverSize>::get<jsResizeObserverSize_blockSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSResizeObserverSize::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSResizeObserverSize, UseCustomHeapCellType::No>(vm, "JSResizeObserverSize"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForResizeObserverSize.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForResizeObserverSize = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForResizeObserverSize.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForResizeObserverSize = std::forward<decltype(space)>(space); }
    );
}

void JSResizeObserverSize::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSResizeObserverSize*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSResizeObserverSizeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSResizeObserverSizeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsResizeObserverSize = static_cast<JSResizeObserverSize*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsResizeObserverSize->protectedWrapped().ptr(), jsResizeObserverSize);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ResizeObserverSize@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18ResizeObserverSizeE[]; }
#endif
template<std::same_as<ResizeObserverSize> T>
static inline void verifyVTable(ResizeObserverSize* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ResizeObserverSize@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18ResizeObserverSizeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ResizeObserverSize has subclasses. If ResizeObserverSize has subclasses that get passed
        // to toJS() we currently require ResizeObserverSize you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ResizeObserverSize>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ResizeObserverSize>(impl.ptr());
#endif
    return createWrapper<ResizeObserverSize>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ResizeObserverSize& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ResizeObserverSize* JSResizeObserverSize::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSResizeObserverSize*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
