/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStencilFaceState.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUCompareFunction.h"
#include "JSGPUStencilOperation.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUStencilFaceState>> convertDictionary<GPUStencilFaceState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUStencilFaceState result;
    JSValue compareValue;
    if (isNullOrUndefined)
        compareValue = jsUndefined();
    else {
        compareValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compare"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto compareConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, compareValue, [&]() -> ConversionResult<IDLEnumeration<GPUCompareFunction>> { return Converter<IDLEnumeration<GPUCompareFunction>>::ReturnType { GPUCompareFunction::Always }; });
    if (compareConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.compare = compareConversionResult.releaseReturnValue();
    JSValue depthFailOpValue;
    if (isNullOrUndefined)
        depthFailOpValue = jsUndefined();
    else {
        depthFailOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthFailOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthFailOpConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUStencilOperation>>(lexicalGlobalObject, depthFailOpValue, [&]() -> ConversionResult<IDLEnumeration<GPUStencilOperation>> { return Converter<IDLEnumeration<GPUStencilOperation>>::ReturnType { GPUStencilOperation::Keep }; });
    if (depthFailOpConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.depthFailOp = depthFailOpConversionResult.releaseReturnValue();
    JSValue failOpValue;
    if (isNullOrUndefined)
        failOpValue = jsUndefined();
    else {
        failOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "failOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto failOpConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUStencilOperation>>(lexicalGlobalObject, failOpValue, [&]() -> ConversionResult<IDLEnumeration<GPUStencilOperation>> { return Converter<IDLEnumeration<GPUStencilOperation>>::ReturnType { GPUStencilOperation::Keep }; });
    if (failOpConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.failOp = failOpConversionResult.releaseReturnValue();
    JSValue passOpValue;
    if (isNullOrUndefined)
        passOpValue = jsUndefined();
    else {
        passOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "passOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto passOpConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUStencilOperation>>(lexicalGlobalObject, passOpValue, [&]() -> ConversionResult<IDLEnumeration<GPUStencilOperation>> { return Converter<IDLEnumeration<GPUStencilOperation>>::ReturnType { GPUStencilOperation::Keep }; });
    if (passOpConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.passOp = passOpConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

