/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUExternalTextureDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUPredefinedColorSpace.h"
#include "JSHTMLVideoElement.h"
#include "JSWebCodecsVideoFrame.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUExternalTextureDescriptor>> convertDictionary<GPUExternalTextureDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUExternalTextureDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue colorSpaceValue;
    if (isNullOrUndefined)
        colorSpaceValue = jsUndefined();
    else {
        colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto colorSpaceConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUPredefinedColorSpace>>(lexicalGlobalObject, colorSpaceValue, [&]() -> ConversionResult<IDLEnumeration<GPUPredefinedColorSpace>> { return Converter<IDLEnumeration<GPUPredefinedColorSpace>>::ReturnType { GPUPredefinedColorSpace::SRGB }; });
    if (colorSpaceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.colorSpace = colorSpaceConversionResult.releaseReturnValue();
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (sourceValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "source"_s, "GPUExternalTextureDescriptor"_s, "(HTMLVideoElement or WebCodecsVideoFrame)"_s);
        return ConversionResultException { };
    }
    auto sourceConversionResult = convert<IDLUnion<IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(lexicalGlobalObject, sourceValue);
    if (sourceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.source = sourceConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

