/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCredentialsContainer.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSBasicCredential.h"
#include "JSCredentialCreationOptions.h"
#include "JSCredentialRequestOptions.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_get);
static JSC_DECLARE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_store);
static JSC_DECLARE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_create);
static JSC_DECLARE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_preventSilentAccess);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCredentialsContainerConstructor);

class JSCredentialsContainerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCredentialsContainerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCredentialsContainerPrototype* ptr = new (NotNull, JSC::allocateCell<JSCredentialsContainerPrototype>(vm)) JSCredentialsContainerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCredentialsContainerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCredentialsContainerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCredentialsContainerPrototype, JSCredentialsContainerPrototype::Base);

using JSCredentialsContainerDOMConstructor = JSDOMConstructorNotConstructable<JSCredentialsContainer>;

template<> const ClassInfo JSCredentialsContainerDOMConstructor::s_info = { "CredentialsContainer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCredentialsContainerDOMConstructor) };

template<> JSValue JSCredentialsContainerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCredentialsContainerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CredentialsContainer"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCredentialsContainer::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSCredentialsContainerPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCredentialsContainerConstructor, 0 } },
    HashTableValue { "get"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCredentialsContainerPrototypeFunction_get, 0 } },
    HashTableValue { "store"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCredentialsContainerPrototypeFunction_store, 1 } },
    HashTableValue { "create"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCredentialsContainerPrototypeFunction_create, 0 } },
    HashTableValue { "preventSilentAccess"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCredentialsContainerPrototypeFunction_preventSilentAccess, 0 } },
};

const ClassInfo JSCredentialsContainerPrototype::s_info = { "CredentialsContainer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCredentialsContainerPrototype) };

void JSCredentialsContainerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCredentialsContainer::info(), JSCredentialsContainerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCredentialsContainer::s_info = { "CredentialsContainer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCredentialsContainer) };

JSCredentialsContainer::JSCredentialsContainer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CredentialsContainer>&& impl)
    : JSDOMWrapper<CredentialsContainer>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CredentialsContainer>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCredentialsContainer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCredentialsContainerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCredentialsContainerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCredentialsContainer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCredentialsContainer>(vm, globalObject);
}

JSValue JSCredentialsContainer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCredentialsContainerDOMConstructor, DOMConstructorID::CredentialsContainer>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCredentialsContainer::destroy(JSC::JSCell* cell)
{
    JSCredentialsContainer* thisObject = static_cast<JSCredentialsContainer*>(cell);
    thisObject->JSCredentialsContainer::~JSCredentialsContainer();
}

JSC_DEFINE_CUSTOM_GETTER(jsCredentialsContainerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCredentialsContainerPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCredentialsContainer::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCredentialsContainerPrototypeFunction_getBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCredentialsContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<CredentialRequestOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLInterface<BasicCredential>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.get(optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_get, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCredentialsContainer>::call<jsCredentialsContainerPrototypeFunction_getBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsCredentialsContainerPrototypeFunction_storeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCredentialsContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto credentialConversionResult = convert<IDLInterface<BasicCredential>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "credential"_s, "CredentialsContainer"_s, "store"_s, "BasicCredential"_s); });
    if (credentialConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<BasicCredential>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.store(*credentialConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_store, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCredentialsContainer>::call<jsCredentialsContainerPrototypeFunction_storeBody>(*lexicalGlobalObject, *callFrame, "store");
}

static inline JSC::EncodedJSValue jsCredentialsContainerPrototypeFunction_createBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCredentialsContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<CredentialCreationOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLInterface<BasicCredential>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.isCreate(optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_create, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCredentialsContainer>::call<jsCredentialsContainerPrototypeFunction_createBody>(*lexicalGlobalObject, *callFrame, "create");
}

static inline JSC::EncodedJSValue jsCredentialsContainerPrototypeFunction_preventSilentAccessBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCredentialsContainer>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.preventSilentAccess(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCredentialsContainerPrototypeFunction_preventSilentAccess, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCredentialsContainer>::call<jsCredentialsContainerPrototypeFunction_preventSilentAccessBody>(*lexicalGlobalObject, *callFrame, "preventSilentAccess");
}

JSC::GCClient::IsoSubspace* JSCredentialsContainer::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCredentialsContainer, UseCustomHeapCellType::No>(vm, "JSCredentialsContainer"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCredentialsContainer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCredentialsContainer = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCredentialsContainer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCredentialsContainer = std::forward<decltype(space)>(space); }
    );
}

void JSCredentialsContainer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCredentialsContainer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCredentialsContainerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCredentialsContainerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCredentialsContainer = static_cast<JSCredentialsContainer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCredentialsContainer->protectedWrapped().ptr(), jsCredentialsContainer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CredentialsContainer>&& impl)
{
    return createWrapper<CredentialsContainer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CredentialsContainer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CredentialsContainer* JSCredentialsContainer::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCredentialsContainer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
