/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCredentialMediationRequirement.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediationRequirement enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("silent"),
        MAKE_STATIC_STRING_IMPL("optional"),
        MAKE_STATIC_STRING_IMPL("required"),
        MAKE_STATIC_STRING_IMPL("conditional"),
    };
    static_assert(static_cast<size_t>(MediationRequirement::Silent) == 0, "MediationRequirement::Silent is not 0 as expected");
    static_assert(static_cast<size_t>(MediationRequirement::Optional) == 1, "MediationRequirement::Optional is not 1 as expected");
    static_assert(static_cast<size_t>(MediationRequirement::Required) == 2, "MediationRequirement::Required is not 2 as expected");
    static_assert(static_cast<size_t>(MediationRequirement::Conditional) == 3, "MediationRequirement::Conditional is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediationRequirement enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediationRequirement> parseEnumerationFromString<MediationRequirement>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, MediationRequirement>, 4> mappings {
        std::pair<ComparableASCIILiteral, MediationRequirement> { "conditional"_s, MediationRequirement::Conditional },
        std::pair<ComparableASCIILiteral, MediationRequirement> { "optional"_s, MediationRequirement::Optional },
        std::pair<ComparableASCIILiteral, MediationRequirement> { "required"_s, MediationRequirement::Required },
        std::pair<ComparableASCIILiteral, MediationRequirement> { "silent"_s, MediationRequirement::Silent },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediationRequirement> parseEnumeration<MediationRequirement>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediationRequirement>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediationRequirement>()
{
    return "\"silent\", \"optional\", \"required\", \"conditional\""_s;
}

} // namespace WebCore

