/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSAudioSampleFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(AudioSampleFormat enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 8> values {
        MAKE_STATIC_STRING_IMPL("u8"),
        MAKE_STATIC_STRING_IMPL("s16"),
        MAKE_STATIC_STRING_IMPL("s32"),
        MAKE_STATIC_STRING_IMPL("f32"),
        MAKE_STATIC_STRING_IMPL("u8-planar"),
        MAKE_STATIC_STRING_IMPL("s16-planar"),
        MAKE_STATIC_STRING_IMPL("s32-planar"),
        MAKE_STATIC_STRING_IMPL("f32-planar"),
    };
    static_assert(static_cast<size_t>(AudioSampleFormat::U8) == 0, "AudioSampleFormat::U8 is not 0 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::S16) == 1, "AudioSampleFormat::S16 is not 1 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::S32) == 2, "AudioSampleFormat::S32 is not 2 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::F32) == 3, "AudioSampleFormat::F32 is not 3 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::U8Planar) == 4, "AudioSampleFormat::U8Planar is not 4 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::S16Planar) == 5, "AudioSampleFormat::S16Planar is not 5 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::S32Planar) == 6, "AudioSampleFormat::S32Planar is not 6 as expected");
    static_assert(static_cast<size_t>(AudioSampleFormat::F32Planar) == 7, "AudioSampleFormat::F32Planar is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, AudioSampleFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<AudioSampleFormat> parseEnumerationFromString<AudioSampleFormat>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, AudioSampleFormat>, 8> mappings {
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "f32"_s, AudioSampleFormat::F32 },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "f32-planar"_s, AudioSampleFormat::F32Planar },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "s16"_s, AudioSampleFormat::S16 },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "s16-planar"_s, AudioSampleFormat::S16Planar },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "s32"_s, AudioSampleFormat::S32 },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "s32-planar"_s, AudioSampleFormat::S32Planar },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "u8"_s, AudioSampleFormat::U8 },
        std::pair<ComparableASCIILiteral, AudioSampleFormat> { "u8-planar"_s, AudioSampleFormat::U8Planar },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<AudioSampleFormat> parseEnumeration<AudioSampleFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<AudioSampleFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<AudioSampleFormat>()
{
    return "\"u8\", \"s16\", \"s32\", \"f32\", \"u8-planar\", \"s16-planar\", \"s32-planar\", \"f32-planar\""_s;
}

} // namespace WebCore


#endif // ENABLE(WEB_CODECS)
