/*
 * Copyright (c) 2016, 2022 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "DecompressionStreamBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_decompressionStreamInitializeDecompressionStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_decompressionStreamInitializeDecompressionStreamCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_decompressionStreamInitializeDecompressionStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_decompressionStreamInitializeDecompressionStreamCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_decompressionStreamInitializeDecompressionStreamCodeLength = 2587;
static constinit const JSC::Intrinsic s_decompressionStreamInitializeDecompressionStreamCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_decompressionStreamInitializeDecompressionStreamCode =
    "(function (format)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const errorMessage = \"DecompressionStream requires a single argument with the value 'brotli', 'deflate', 'deflate-raw', or 'gzip'.\";\n" \
    "\n" \
    "    if (arguments.length < 1)\n" \
    "        @throwTypeError(errorMessage);\n" \
    "\n" \
    "    const algorithms = ['brotli', 'gzip', 'deflate', 'deflate-raw'];\n" \
    "    const lowercaseFormat = @toString(arguments[0]).toLowerCase();\n" \
    "    const findAlgorithm = (element) => element === lowercaseFormat;\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    const index = algorithms.findIndex(findAlgorithm);\n" \
    "\n" \
    "    if (index === -1)\n" \
    "        @throwTypeError(errorMessage);\n" \
    "\n" \
    "    //\n" \
    "    const startAlgorithm = () => {\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const transformAlgorithm = (chunk) => {\n" \
    "        if (!@isObject(chunk) || (!(chunk instanceof @ArrayBuffer) && !(chunk.buffer instanceof @ArrayBuffer)))\n" \
    "            return @Promise.@reject(@makeTypeError(\"Invalid type should be ArrayBuffer\"));\n" \
    "\n" \
    "        try {\n" \
    "            const decoder = @getByIdDirectPrivate(this, \"DecompressionStreamDecoder\");\n" \
    "            const buffer = decoder.@decode(chunk);\n" \
    "\n" \
    "            if (buffer) {\n" \
    "                const transformStream = @getByIdDirectPrivate(this, \"DecompressionStreamTransform\");\n" \
    "                const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "                @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "            }\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(@makeTypeError(e.message));\n" \
    "        }\n" \
    "\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "    const flushAlgorithm = () => {        \n" \
    "        try {\n" \
    "            const decoder = @getByIdDirectPrivate(this, \"DecompressionStreamDecoder\");\n" \
    "            const buffer = decoder.@flush();\n" \
    "\n" \
    "            if (buffer) {\n" \
    "                const transformStream = @getByIdDirectPrivate(this, \"DecompressionStreamTransform\");\n" \
    "                const controller = @getByIdDirectPrivate(transformStream, \"controller\");\n" \
    "                @transformStreamDefaultControllerEnqueue(controller, buffer);\n" \
    "            }\n" \
    "        } catch (e) {\n" \
    "            return @Promise.@reject(@makeTypeError(e.message));\n" \
    "        }\n" \
    "\n" \
    "        return @Promise.@resolve();\n" \
    "    };\n" \
    "\n" \
    "    const [transform, readable, writable] = @createTransformStream(startAlgorithm, transformAlgorithm, flushAlgorithm);\n" \
    "    @putByIdDirectPrivate(this, \"DecompressionStreamTransform\", transform);\n" \
    "    @putByIdDirectPrivate(this, \"readable\", readable);\n" \
    "    @putByIdDirectPrivate(this, \"writable\", writable);\n" \
    "    @putByIdDirectPrivate(this, \"DecompressionStreamDecoder\", new @DecompressionStreamDecoder(index));\n" \
    "    return this;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_decompressionStreamReadableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_decompressionStreamReadableCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_decompressionStreamReadableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_decompressionStreamReadableCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_decompressionStreamReadableCodeLength = 269;
static constinit const JSC::Intrinsic s_decompressionStreamReadableCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_decompressionStreamReadableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"DecompressionStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"DecompressionStreamDecoder\", \"readable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"readable\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_decompressionStreamWritableCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_decompressionStreamWritableCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_decompressionStreamWritableCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_decompressionStreamWritableCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_decompressionStreamWritableCodeLength = 269;
static constinit const JSC::Intrinsic s_decompressionStreamWritableCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_decompressionStreamWritableCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const transform = @getByIdDirectPrivate(this, \"DecompressionStreamTransform\");\n" \
    "    if (!transform)\n" \
    "        throw @makeThisTypeError(\"DecompressionStreamDecoder\", \"writable\");\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"writable\");\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().decompressionStreamBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().decompressionStreamBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_DECOMPRESSIONSTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
