/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Automation.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include <JavaScriptCore/InspectorProtocolTypes.h>
#include <wtf/JSONValues.h>
#include <wtf/text/WTFString.h>

namespace Inspector {



namespace Protocol {



// Forward declarations.
namespace Automation {
class Point;
class Size;
class Rect;
class BrowsingContext;
class KeyboardInteraction;
class Cookie;
class SessionPermissionData;
class InputSource;
class InteractionStep;
class InputSourceState;
class VirtualAuthenticatorCredential;
class VirtualAuthenticatorConfiguration;
enum class CoordinateSystem;
enum class BrowsingContextPresentation;
enum class ErrorMessage;
enum class PageLoadStrategy;
enum class MouseInteraction;
enum class MouseButton;
enum class KeyModifier;
enum class VirtualKey;
enum class KeyboardInteractionType;
enum class CookieSameSitePolicy;
enum class SessionPermission;
enum class InputSourceType;
enum class MouseMoveOrigin;
enum class AuthenticatorProtocol;
enum class AuthenticatorTransport;
enum class WebExtensionResourceOptions;
} // Automation
// End of forward declarations.


// Typedefs.
namespace Automation {
/* An opaque identifier for a browsing context. */
using BrowsingContextHandle = String;
/* An opaque identifier for a frame in a page. */
using FrameHandle = String;
/* An opaque identifier for a node in a page. */
using NodeHandle = String;
} // Automation
// End of typedefs.

namespace AutomationHelpers {

String getEnumConstantValue(int code);

template<typename T> String getEnumConstantValue(T enumValue)
{
    return getEnumConstantValue(static_cast<int>(enumValue));
}

} // namespace AutomationHelpers

namespace Automation {

class Point final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        AllFieldsSet = (XSet | YSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Point*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Point;
    public:

        Builder<STATE | XSet>& setX(double in_x)
        {
            static_assert(!(STATE & XSet), "property x already set");
            m_result->setDouble("x"_s, in_x);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(double in_y)
        {
            static_assert(!(STATE & YSet), "property y already set");
            m_result->setDouble("y"_s, in_y);
            return castState<YSet>();
        }

        Ref<Point> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Point) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Point>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Point> result = Point::create()
     *     .setX(...)
     *     .setY(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class Size final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        WidthSet = 1 << 0,
        HeightSet = 1 << 1,
        AllFieldsSet = (WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Size*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Size;
    public:

        Builder<STATE | WidthSet>& setWidth(double in_width)
        {
            static_assert(!(STATE & WidthSet), "property width already set");
            m_result->setDouble("width"_s, in_width);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(double in_height)
        {
            static_assert(!(STATE & HeightSet), "property height already set");
            m_result->setDouble("height"_s, in_height);
            return castState<HeightSet>();
        }

        Ref<Size> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Size) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Size>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Size> result = Size::create()
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class Rect final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OriginSet = 1 << 0,
        SizeSet = 1 << 1,
        AllFieldsSet = (OriginSet | SizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Rect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Rect;
    public:

        Builder<STATE | OriginSet>& setOrigin(Ref<Protocol::Automation::Point>&& in_origin)
        {
            static_assert(!(STATE & OriginSet), "property origin already set");
            m_result->setObject("origin"_s, WTFMove(in_origin));
            return castState<OriginSet>();
        }

        Builder<STATE | SizeSet>& setSize(Ref<Protocol::Automation::Size>&& in_size)
        {
            static_assert(!(STATE & SizeSet), "property size already set");
            m_result->setObject("size"_s, WTFMove(in_size));
            return castState<SizeSet>();
        }

        Ref<Rect> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Rect) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Rect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Rect> result = Rect::create()
     *     .setOrigin(...)
     *     .setSize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* The coordinate system in which rects, points, and sizes are to be interpreted. LayoutViewport is a legacy value and should not be used going forward. */
enum class CoordinateSystem {
    Page = 0,
    Viewport = 1,
    LayoutViewport = 2,
}; // enum class CoordinateSystem

/* How a browsing context is presented by the user agent. A browsing context is considered a tab if it shares an OS-level window with another browsing context. */
enum class BrowsingContextPresentation {
    Window = 3,
    Tab = 4,
}; // enum class BrowsingContextPresentation

/* This enum contains predefined error messages that can be used to signal a well-defined error condition, such as a missing implementation, unknown window handle, and so forth. The backend signals one of these errors by using it as a prefix of the commands's error message (the errorString argument in generated C++ backend dispatchers). This will be reported to the frontend as a protocol error with a JSON-RPC error code of 'ServerError'. It is up to the frontend whether and how to deal with errors. */
enum class ErrorMessage {
    InternalError = 5,
    Timeout = 6,
    JavaScriptError = 7,
    JavaScriptTimeout = 8,
    WindowNotFound = 9,
    FrameNotFound = 10,
    NodeNotFound = 11,
    InvalidNodeIdentifier = 12,
    InvalidElementState = 13,
    NoJavaScriptDialog = 14,
    NotImplemented = 15,
    MissingParameter = 16,
    InvalidParameter = 17,
    InvalidSelector = 18,
    ElementNotInteractable = 19,
    ElementNotSelectable = 20,
    ScreenshotError = 21,
    UnexpectedAlertOpen = 22,
    TargetOutOfBounds = 23,
    UnableToLoadExtension = 24,
    UnableToUnloadExtension = 25,
    NoSuchExtension = 26,
}; // enum class ErrorMessage

/* Enumerates different page load strategies. */
enum class PageLoadStrategy {
    None = 27,
    Eager = 28,
    Normal = 29,
}; // enum class PageLoadStrategy

/* A handle representing an open window or tab in the automation session. */
class BrowsingContext final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HandleSet = 1 << 0,
        ActiveSet = 1 << 1,
        UrlSet = 1 << 2,
        WindowSizeSet = 1 << 3,
        WindowOriginSet = 1 << 4,
        AllFieldsSet = (HandleSet | ActiveSet | UrlSet | WindowSizeSet | WindowOriginSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BrowsingContext*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class BrowsingContext;
    public:

        Builder<STATE | HandleSet>& setHandle(const String& in_handle)
        {
            static_assert(!(STATE & HandleSet), "property handle already set");
            m_result->setString("handle"_s, in_handle);
            return castState<HandleSet>();
        }

        Builder<STATE | ActiveSet>& setActive(bool in_active)
        {
            static_assert(!(STATE & ActiveSet), "property active already set");
            m_result->setBoolean("active"_s, in_active);
            return castState<ActiveSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | WindowSizeSet>& setWindowSize(Ref<Protocol::Automation::Size>&& in_windowSize)
        {
            static_assert(!(STATE & WindowSizeSet), "property windowSize already set");
            m_result->setObject("windowSize"_s, WTFMove(in_windowSize));
            return castState<WindowSizeSet>();
        }

        Builder<STATE | WindowOriginSet>& setWindowOrigin(Ref<Protocol::Automation::Point>&& in_windowOrigin)
        {
            static_assert(!(STATE & WindowOriginSet), "property windowOrigin already set");
            m_result->setObject("windowOrigin"_s, WTFMove(in_windowOrigin));
            return castState<WindowOriginSet>();
        }

        Ref<BrowsingContext> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(BrowsingContext) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BrowsingContext>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BrowsingContext> result = BrowsingContext::create()
     *     .setHandle(...)
     *     .setActive(...)
     *     .setUrl(...)
     *     .setWindowSize(...)
     *     .setWindowOrigin(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Enumerates different ways of interacting with a mouse cursor. */
enum class MouseInteraction {
    Move = 30,
    Down = 31,
    Up = 32,
    SingleClick = 33,
    DoubleClick = 34,
}; // enum class MouseInteraction

/* Enumerates different mouse buttons that can be used. */
enum class MouseButton {
    None = 27,
    Left = 35,
    Middle = 36,
    Right = 37,
}; // enum class MouseButton

/* Enumerates different key modifiers that can remain pressed during other mouse/touch interactions. */
enum class KeyModifier {
    CapsLock = 38,
    Control = 39,
    Shift = 40,
    Meta = 41,
    Alt = 42,
}; // enum class KeyModifier

/* Enumerates different platform-independent virtual keys on a physical keyboard whose input via keyboard may or may not produce characters. */
enum class VirtualKey {
    Shift = 40,
    ShiftRight = 43,
    Control = 39,
    ControlRight = 44,
    Alternate = 45,
    AlternateRight = 46,
    Meta = 41,
    MetaRight = 47,
    Command = 48,
    CommandRight = 49,
    Cancel = 50,
    Help = 51,
    Backspace = 52,
    Tab = 4,
    Clear = 53,
    Enter = 54,
    Pause = 55,
    Escape = 56,
    PageUp = 57,
    PageUpRight = 58,
    PageDown = 59,
    PageDownRight = 60,
    End = 61,
    EndRight = 62,
    Home = 63,
    HomeRight = 64,
    LeftArrow = 65,
    LeftArrowRight = 66,
    UpArrow = 67,
    UpArrowRight = 68,
    RightArrow = 69,
    RightArrowRight = 70,
    DownArrow = 71,
    DownArrowRight = 72,
    Insert = 73,
    InsertRight = 74,
    Delete = 75,
    DeleteRight = 76,
    Space = 77,
    Semicolon = 78,
    Equals = 79,
    Return = 80,
    NumberPad0 = 81,
    NumberPad1 = 82,
    NumberPad2 = 83,
    NumberPad3 = 84,
    NumberPad4 = 85,
    NumberPad5 = 86,
    NumberPad6 = 87,
    NumberPad7 = 88,
    NumberPad8 = 89,
    NumberPad9 = 90,
    NumberPadMultiply = 91,
    NumberPadAdd = 92,
    NumberPadSeparator = 93,
    NumberPadSubtract = 94,
    NumberPadDecimal = 95,
    NumberPadDivide = 96,
    Function1 = 97,
    Function2 = 98,
    Function3 = 99,
    Function4 = 100,
    Function5 = 101,
    Function6 = 102,
    Function7 = 103,
    Function8 = 104,
    Function9 = 105,
    Function10 = 106,
    Function11 = 107,
    Function12 = 108,
}; // enum class VirtualKey

/* Enumerates different ways of interacting with a keyboard device. 'InsertByKey' implies that a separate KeyDown and KeyUp event are produced for each combining character sequence, regardless of the actual keystrokes required to produce the character sequence. */
enum class KeyboardInteractionType {
    KeyPress = 109,
    KeyRelease = 110,
    InsertByKey = 111,
}; // enum class KeyboardInteractionType

/* A single step in a key sequence. A step can contain a key up/down of a virtual key, or a sequence of Unicode code points that are delivered to the page at grapheme cluster boundaries. Either a 'key' or 'text' property must be specified. */
class KeyboardInteraction final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyboardInteraction*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class KeyboardInteraction;
    public:

        Builder<STATE | TypeSet>& setType(Protocol::Automation::KeyboardInteractionType in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<KeyboardInteraction> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(KeyboardInteraction) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<KeyboardInteraction>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyboardInteraction> result = KeyboardInteraction::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setKey(Protocol::Automation::VirtualKey in_opt_key)
    {
        JSON::ObjectBase::setString("key"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_opt_key));
    }

    void setText(const String& in_opt_text)
    {
        JSON::ObjectBase::setString("text"_s, in_opt_text);
    }
};

/* Enumerates values for cookies same site policy */
enum class CookieSameSitePolicy {
    None = 27,
    Lax = 112,
    Strict = 113,
}; // enum class CookieSameSitePolicy

class Cookie final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        SizeSet = 1 << 5,
        HttpOnlySet = 1 << 6,
        SecureSet = 1 << 7,
        SessionSet = 1 << 8,
        SameSiteSet = 1 << 9,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SizeSet | HttpOnlySet | SecureSet | SessionSet | SameSiteSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Cookie*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& in_domain)
        {
            static_assert(!(STATE & DomainSet), "property domain already set");
            m_result->setString("domain"_s, in_domain);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& in_path)
        {
            static_assert(!(STATE & PathSet), "property path already set");
            m_result->setString("path"_s, in_path);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double in_expires)
        {
            static_assert(!(STATE & ExpiresSet), "property expires already set");
            m_result->setDouble("expires"_s, in_expires);
            return castState<ExpiresSet>();
        }

        Builder<STATE | SizeSet>& setSize(int in_size)
        {
            static_assert(!(STATE & SizeSet), "property size already set");
            m_result->setInteger("size"_s, in_size);
            return castState<SizeSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool in_httpOnly)
        {
            static_assert(!(STATE & HttpOnlySet), "property httpOnly already set");
            m_result->setBoolean("httpOnly"_s, in_httpOnly);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool in_secure)
        {
            static_assert(!(STATE & SecureSet), "property secure already set");
            m_result->setBoolean("secure"_s, in_secure);
            return castState<SecureSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool in_session)
        {
            static_assert(!(STATE & SessionSet), "property session already set");
            m_result->setBoolean("session"_s, in_session);
            return castState<SessionSet>();
        }

        Builder<STATE | SameSiteSet>& setSameSite(Protocol::Automation::CookieSameSitePolicy in_sameSite)
        {
            static_assert(!(STATE & SameSiteSet), "property sameSite already set");
            m_result->setString("sameSite"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_sameSite));
            return castState<SameSiteSet>();
        }

        Ref<Cookie> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Cookie) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Cookie>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setSize(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSession(...)
     *     .setSameSite(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Enumerates different permissions that must be obtained in order to use privileged APIs. */
enum class SessionPermission {
    GetUserMedia = 114,
}; // enum class SessionPermission

class SessionPermissionData final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        PermissionSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (PermissionSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SessionPermissionData*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class SessionPermissionData;
    public:

        Builder<STATE | PermissionSet>& setPermission(Protocol::Automation::SessionPermission in_permission)
        {
            static_assert(!(STATE & PermissionSet), "property permission already set");
            m_result->setString("permission"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_permission));
            return castState<PermissionSet>();
        }

        Builder<STATE | ValueSet>& setValue(bool in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setBoolean("value"_s, in_value);
            return castState<ValueSet>();
        }

        Ref<SessionPermissionData> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(SessionPermissionData) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SessionPermissionData>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SessionPermissionData> result = SessionPermissionData::create()
     *     .setPermission(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* The type of an input source. This determines which state properties are applicable to the input source. The 'Null' input source type has no properties, only a duration. This can extend the effective wait for a tick. */
enum class InputSourceType {
    Null = 115,
    Mouse = 116,
    Keyboard = 117,
    Touch = 118,
    Wheel = 119,
    Pen = 120,
}; // enum class InputSourceType

class InputSource final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceIdSet = 1 << 0,
        SourceTypeSet = 1 << 1,
        AllFieldsSet = (SourceIdSet | SourceTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InputSource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class InputSource;
    public:

        Builder<STATE | SourceIdSet>& setSourceId(const String& in_sourceId)
        {
            static_assert(!(STATE & SourceIdSet), "property sourceId already set");
            m_result->setString("sourceId"_s, in_sourceId);
            return castState<SourceIdSet>();
        }

        Builder<STATE | SourceTypeSet>& setSourceType(Protocol::Automation::InputSourceType in_sourceType)
        {
            static_assert(!(STATE & SourceTypeSet), "property sourceType already set");
            m_result->setString("sourceType"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_sourceType));
            return castState<SourceTypeSet>();
        }

        Ref<InputSource> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(InputSource) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InputSource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InputSource> result = InputSource::create()
     *     .setSourceId(...)
     *     .setSourceType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* A set of input source states to which all applicable input sources must transition before further steps may be processed. If an input source does not have a corresponding state in a step, its state assumed to be 'released' for that step. */
class InteractionStep final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InteractionStep*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class InteractionStep;
    public:

        Ref<InteractionStep> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(InteractionStep) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InteractionStep>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InteractionStep> result = InteractionStep::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStates(Ref<JSON::ArrayOf<Protocol::Automation::InputSourceState>>&& in_opt_states)
    {
        JSON::ObjectBase::setArray("states"_s, WTFMove(in_opt_states));
    }
};

/* Enumerates different origin types that can be used in mouse move interactions. */
enum class MouseMoveOrigin {
    Viewport = 1,
    Pointer = 121,
    Element = 122,
}; // enum class MouseMoveOrigin

/* A new state for a specific input source. All state-related fields are optional and must be applicable to the InputSource referenced by 'sourceId'. If no state-related fields are specified, the state is assumed to remain the same as in the previous step (i.e., 'sustained'). */
class InputSourceState final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceIdSet = 1 << 0,
        AllFieldsSet = (SourceIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InputSourceState*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class InputSourceState;
    public:

        Builder<STATE | SourceIdSet>& setSourceId(const String& in_sourceId)
        {
            static_assert(!(STATE & SourceIdSet), "property sourceId already set");
            m_result->setString("sourceId"_s, in_sourceId);
            return castState<SourceIdSet>();
        }

        Ref<InputSourceState> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(InputSourceState) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InputSourceState>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InputSourceState> result = InputSourceState::create()
     *     .setSourceId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setPressedCharKey(const String& in_opt_pressedCharKey)
    {
        JSON::ObjectBase::setString("pressedCharKey"_s, in_opt_pressedCharKey);
    }

    void setPressedVirtualKeys(Ref<JSON::ArrayOf<Protocol::Automation::VirtualKey>>&& in_opt_pressedVirtualKeys)
    {
        JSON::ObjectBase::setArray("pressedVirtualKeys"_s, WTFMove(in_opt_pressedVirtualKeys));
    }

    void setPressedButton(Protocol::Automation::MouseButton in_opt_pressedButton)
    {
        JSON::ObjectBase::setString("pressedButton"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_opt_pressedButton));
    }

    void setMouseInteraction(Protocol::Automation::MouseInteraction in_opt_mouseInteraction)
    {
        JSON::ObjectBase::setString("mouseInteraction"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_opt_mouseInteraction));
    }

    void setOrigin(Protocol::Automation::MouseMoveOrigin in_opt_origin)
    {
        JSON::ObjectBase::setString("origin"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_opt_origin));
    }

    void setNodeHandle(const String& in_opt_nodeHandle)
    {
        JSON::ObjectBase::setString("nodeHandle"_s, in_opt_nodeHandle);
    }

    void setLocation(Ref<Protocol::Automation::Point>&& in_opt_location)
    {
        JSON::ObjectBase::setObject("location"_s, WTFMove(in_opt_location));
    }

    void setDelta(Ref<Protocol::Automation::Size>&& in_opt_delta)
    {
        JSON::ObjectBase::setObject("delta"_s, WTFMove(in_opt_delta));
    }

    void setDuration(int in_opt_duration)
    {
        JSON::ObjectBase::setInteger("duration"_s, in_opt_duration);
    }
};

/* This enum contains the different protocol types supported by virtual authenticators. */
enum class AuthenticatorProtocol {
    Ctap1_u2f = 123,
    Ctap2 = 124,
    Ctap2_1 = 125,
}; // enum class AuthenticatorProtocol

/* Authenticators may implement various transports for communicating with clients. This enumeration defines hints as to how clients might communicate with a particular authenticator in order to obtain an assertion for a specific credential. */
enum class AuthenticatorTransport {
    Usb = 126,
    Nfc = 127,
    Ble = 128,
    Internal = 129,
}; // enum class AuthenticatorTransport

/* A credential object used for virtual authenticators. */
class VirtualAuthenticatorCredential final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CredentialIdSet = 1 << 0,
        IsResidentCredentialSet = 1 << 1,
        RpIdSet = 1 << 2,
        PrivateKeySet = 1 << 3,
        SignCountSet = 1 << 4,
        AllFieldsSet = (CredentialIdSet | IsResidentCredentialSet | RpIdSet | PrivateKeySet | SignCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*VirtualAuthenticatorCredential*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class VirtualAuthenticatorCredential;
    public:

        Builder<STATE | CredentialIdSet>& setCredentialId(const String& in_credentialId)
        {
            static_assert(!(STATE & CredentialIdSet), "property credentialId already set");
            m_result->setString("credentialId"_s, in_credentialId);
            return castState<CredentialIdSet>();
        }

        Builder<STATE | IsResidentCredentialSet>& setIsResidentCredential(bool in_isResidentCredential)
        {
            static_assert(!(STATE & IsResidentCredentialSet), "property isResidentCredential already set");
            m_result->setBoolean("isResidentCredential"_s, in_isResidentCredential);
            return castState<IsResidentCredentialSet>();
        }

        Builder<STATE | RpIdSet>& setRpId(const String& in_rpId)
        {
            static_assert(!(STATE & RpIdSet), "property rpId already set");
            m_result->setString("rpId"_s, in_rpId);
            return castState<RpIdSet>();
        }

        Builder<STATE | PrivateKeySet>& setPrivateKey(const String& in_privateKey)
        {
            static_assert(!(STATE & PrivateKeySet), "property privateKey already set");
            m_result->setString("privateKey"_s, in_privateKey);
            return castState<PrivateKeySet>();
        }

        Builder<STATE | SignCountSet>& setSignCount(int in_signCount)
        {
            static_assert(!(STATE & SignCountSet), "property signCount already set");
            m_result->setInteger("signCount"_s, in_signCount);
            return castState<SignCountSet>();
        }

        Ref<VirtualAuthenticatorCredential> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(VirtualAuthenticatorCredential) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<VirtualAuthenticatorCredential>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<VirtualAuthenticatorCredential> result = VirtualAuthenticatorCredential::create()
     *     .setCredentialId(...)
     *     .setIsResidentCredential(...)
     *     .setRpId(...)
     *     .setPrivateKey(...)
     *     .setSignCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setUserHandle(const String& in_opt_userHandle)
    {
        JSON::ObjectBase::setString("userHandle"_s, in_opt_userHandle);
    }

    void setLargeBlob(const String& in_opt_largeBlob)
    {
        JSON::ObjectBase::setString("largeBlob"_s, in_opt_largeBlob);
    }
};

/* Parameters used when creating a virtual authenticator */
class VirtualAuthenticatorConfiguration final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProtocolSet = 1 << 0,
        TransportSet = 1 << 1,
        AllFieldsSet = (ProtocolSet | TransportSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*VirtualAuthenticatorConfiguration*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class VirtualAuthenticatorConfiguration;
    public:

        Builder<STATE | ProtocolSet>& setProtocol(Protocol::Automation::AuthenticatorProtocol in_protocol)
        {
            static_assert(!(STATE & ProtocolSet), "property protocol already set");
            m_result->setString("protocol"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_protocol));
            return castState<ProtocolSet>();
        }

        Builder<STATE | TransportSet>& setTransport(Protocol::Automation::AuthenticatorTransport in_transport)
        {
            static_assert(!(STATE & TransportSet), "property transport already set");
            m_result->setString("transport"_s, Protocol::AutomationHelpers::getEnumConstantValue(in_transport));
            return castState<TransportSet>();
        }

        Ref<VirtualAuthenticatorConfiguration> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(VirtualAuthenticatorConfiguration) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<VirtualAuthenticatorConfiguration>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<VirtualAuthenticatorConfiguration> result = VirtualAuthenticatorConfiguration::create()
     *     .setProtocol(...)
     *     .setTransport(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setHasResidentKey(bool in_opt_hasResidentKey)
    {
        JSON::ObjectBase::setBoolean("hasResidentKey"_s, in_opt_hasResidentKey);
    }

    void setHasUserVerification(bool in_opt_hasUserVerification)
    {
        JSON::ObjectBase::setBoolean("hasUserVerification"_s, in_opt_hasUserVerification);
    }

    void setIsUserConsenting(bool in_opt_isUserConsenting)
    {
        JSON::ObjectBase::setBoolean("isUserConsenting"_s, in_opt_isUserConsenting);
    }

    void setIsUserVerified(bool in_opt_isUserVerified)
    {
        JSON::ObjectBase::setBoolean("isUserVerified"_s, in_opt_isUserVerified);
    }

    void setExtensions(Ref<JSON::ArrayOf<String>>&& in_opt_extensions)
    {
        JSON::ObjectBase::setArray("extensions"_s, WTFMove(in_opt_extensions));
    }

    void setUvm(Ref<JSON::ArrayOf<int>>&& in_opt_uvm)
    {
        JSON::ObjectBase::setArray("uvm"_s, WTFMove(in_opt_uvm));
    }
};

/* The format of the resource used to load the web extension. */
enum class WebExtensionResourceOptions {
    Path = 130,
    ArchivePath = 131,
    Base64 = 132,
}; // enum class WebExtensionResourceOptions

} // Automation



namespace AutomationHelpers {

template<typename ProtocolEnumType>
std::optional<ProtocolEnumType> parseEnumValueFromString(const String&);

// Enums in the 'Automation' Domain
template<>
std::optional<Protocol::Automation::CoordinateSystem> parseEnumValueFromString<Protocol::Automation::CoordinateSystem>(const String&);
template<>
std::optional<Protocol::Automation::BrowsingContextPresentation> parseEnumValueFromString<Protocol::Automation::BrowsingContextPresentation>(const String&);
template<>
std::optional<Protocol::Automation::ErrorMessage> parseEnumValueFromString<Protocol::Automation::ErrorMessage>(const String&);
template<>
std::optional<Protocol::Automation::PageLoadStrategy> parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(const String&);
template<>
std::optional<Protocol::Automation::MouseInteraction> parseEnumValueFromString<Protocol::Automation::MouseInteraction>(const String&);
template<>
std::optional<Protocol::Automation::MouseButton> parseEnumValueFromString<Protocol::Automation::MouseButton>(const String&);
template<>
std::optional<Protocol::Automation::KeyModifier> parseEnumValueFromString<Protocol::Automation::KeyModifier>(const String&);
template<>
std::optional<Protocol::Automation::VirtualKey> parseEnumValueFromString<Protocol::Automation::VirtualKey>(const String&);
template<>
std::optional<Protocol::Automation::KeyboardInteractionType> parseEnumValueFromString<Protocol::Automation::KeyboardInteractionType>(const String&);
template<>
std::optional<Protocol::Automation::CookieSameSitePolicy> parseEnumValueFromString<Protocol::Automation::CookieSameSitePolicy>(const String&);
template<>
std::optional<Protocol::Automation::SessionPermission> parseEnumValueFromString<Protocol::Automation::SessionPermission>(const String&);
template<>
std::optional<Protocol::Automation::InputSourceType> parseEnumValueFromString<Protocol::Automation::InputSourceType>(const String&);
template<>
std::optional<Protocol::Automation::MouseMoveOrigin> parseEnumValueFromString<Protocol::Automation::MouseMoveOrigin>(const String&);
template<>
std::optional<Protocol::Automation::AuthenticatorProtocol> parseEnumValueFromString<Protocol::Automation::AuthenticatorProtocol>(const String&);
template<>
std::optional<Protocol::Automation::AuthenticatorTransport> parseEnumValueFromString<Protocol::Automation::AuthenticatorTransport>(const String&);
template<>
std::optional<Protocol::Automation::WebExtensionResourceOptions> parseEnumValueFromString<Protocol::Automation::WebExtensionResourceOptions>(const String&);

} // namespace AutomationHelpers

} // namespace Protocol

} // namespace Inspector

namespace WTF {

template<typename T> struct DefaultHash;

// Hash declarations in the 'Automation' Domain
template<>
struct DefaultHash<Inspector::Protocol::Automation::CoordinateSystem> : IntHash<Inspector::Protocol::Automation::CoordinateSystem> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::BrowsingContextPresentation> : IntHash<Inspector::Protocol::Automation::BrowsingContextPresentation> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::ErrorMessage> : IntHash<Inspector::Protocol::Automation::ErrorMessage> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::PageLoadStrategy> : IntHash<Inspector::Protocol::Automation::PageLoadStrategy> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::MouseInteraction> : IntHash<Inspector::Protocol::Automation::MouseInteraction> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::MouseButton> : IntHash<Inspector::Protocol::Automation::MouseButton> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::KeyModifier> : IntHash<Inspector::Protocol::Automation::KeyModifier> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::VirtualKey> : IntHash<Inspector::Protocol::Automation::VirtualKey> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::KeyboardInteractionType> : IntHash<Inspector::Protocol::Automation::KeyboardInteractionType> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::CookieSameSitePolicy> : IntHash<Inspector::Protocol::Automation::CookieSameSitePolicy> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::SessionPermission> : IntHash<Inspector::Protocol::Automation::SessionPermission> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::InputSourceType> : IntHash<Inspector::Protocol::Automation::InputSourceType> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::MouseMoveOrigin> : IntHash<Inspector::Protocol::Automation::MouseMoveOrigin> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::AuthenticatorProtocol> : IntHash<Inspector::Protocol::Automation::AuthenticatorProtocol> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::AuthenticatorTransport> : IntHash<Inspector::Protocol::Automation::AuthenticatorTransport> { };
template<>
struct DefaultHash<Inspector::Protocol::Automation::WebExtensionResourceOptions> : IntHash<Inspector::Protocol::Automation::WebExtensionResourceOptions> { };

} // namespace WTF
