/*
	This file is part of Warzone 2100.
	Copyright (C) 2024  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/
/**
 * @file port_mapping_manager_impl_libplum.h
 */
#pragma once

#include "port_mapping_manager.h"

class PortMappingImpl_LibPlum : public PortMappingImpl
{
public:
	virtual ~PortMappingImpl_LibPlum();
	virtual bool init() override;
	virtual bool shutdown() override;
	virtual int create_port_mapping(uint16_t port, PortMappingInternetProtocol protocol) override;
	virtual bool destroy_port_mapping(int mappingId) override;
	virtual PortMappingImpl::Type get_impl_type() const override;
	virtual int get_discovery_timeout_seconds() const override;
private:
	bool m_isInit = false;
};

